package software.amazon.awscdk.services.s3;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-03T12:12:13.500Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BucketProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The block public access configuration of this bucket.
     * 
     * Default: false New buckets and objects don't allow public access, but users can modify bucket
     * policies or object permissions to allow public access.
     * 
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.s3.BlockPublicAccess getBlockPublicAccess();
    /**
     * Physical name of this bucket.
     * 
     * Default: - Assigned by CloudFormation (recommended).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getBucketName();
    /**
     * The CORS configuration of this bucket.
     * 
     * Default: - No CORS configuration.
     * 
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.s3.CorsRule> getCors();
    /**
     * The kind of server-side encryption to apply to this bucket.
     * 
     * If you choose KMS, you can specify a KMS key via `encryptionKey`. If
     * encryption key is not specified, a key will automatically be created.
     * 
     * Default: - `Kms` if `encryptionKey` is specified, or `Unencrypted` otherwise.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.s3.BucketEncryption getEncryption();
    /**
     * External KMS key to use for bucket encryption.
     * 
     * The 'encryption' property must be either not specified or set to "Kms".
     * An error will be emitted if encryption is set to "Unencrypted" or
     * "Managed".
     * 
     * Default: - If encryption is set to "Kms" and this property is undefined,
     * a new KMS key will be created and associated with this bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.kms.IKey getEncryptionKey();
    /**
     * Rules that define how Amazon S3 manages objects during their lifetime.
     * 
     * Default: - No lifecycle rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> getLifecycleRules();
    /**
     * The metrics configuration of this bucket.
     * 
     * Default: - No metrics configuration.
     * 
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.s3.BucketMetrics> getMetrics();
    /**
     * Grants public read access to all objects in the bucket. Similar to calling `bucket.grantPublicAccess()`.
     * 
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getPublicReadAccess();
    /**
     * Policy to apply when the bucket is removed from this stack.
     * 
     * Default: - The bucket will be orphaned.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy();
    /**
     * Whether this bucket should have versioning turned on or not.
     * 
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getVersioned();
    /**
     * The name of the error document (e.g. "404.html") for the website. `websiteIndexDocument` must also be set if this is set.
     * 
     * Default: - No error document.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getWebsiteErrorDocument();
    /**
     * The name of the index document (e.g. "index.html") for the website. Enables static website hosting for this bucket.
     * 
     * Default: - No index document.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getWebsiteIndexDocument();

    /**
     * @return a {@link Builder} of {@link BucketProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link BucketProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.s3.BlockPublicAccess _blockPublicAccess;
        @javax.annotation.Nullable
        private java.lang.String _bucketName;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.s3.CorsRule> _cors;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.s3.BucketEncryption _encryption;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.kms.IKey _encryptionKey;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> _lifecycleRules;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.s3.BucketMetrics> _metrics;
        @javax.annotation.Nullable
        private java.lang.Boolean _publicReadAccess;
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.RemovalPolicy _removalPolicy;
        @javax.annotation.Nullable
        private java.lang.Boolean _versioned;
        @javax.annotation.Nullable
        private java.lang.String _websiteErrorDocument;
        @javax.annotation.Nullable
        private java.lang.String _websiteIndexDocument;

        /**
         * Sets the value of BlockPublicAccess
         * @param value The block public access configuration of this bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withBlockPublicAccess(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.BlockPublicAccess value) {
            this._blockPublicAccess = value;
            return this;
        }
        /**
         * Sets the value of BucketName
         * @param value Physical name of this bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withBucketName(@javax.annotation.Nullable final java.lang.String value) {
            this._bucketName = value;
            return this;
        }
        /**
         * Sets the value of Cors
         * @param value The CORS configuration of this bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withCors(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.s3.CorsRule> value) {
            this._cors = value;
            return this;
        }
        /**
         * Sets the value of Encryption
         * @param value The kind of server-side encryption to apply to this bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withEncryption(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.BucketEncryption value) {
            this._encryption = value;
            return this;
        }
        /**
         * Sets the value of EncryptionKey
         * @param value External KMS key to use for bucket encryption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withEncryptionKey(@javax.annotation.Nullable final software.amazon.awscdk.services.kms.IKey value) {
            this._encryptionKey = value;
            return this;
        }
        /**
         * Sets the value of LifecycleRules
         * @param value Rules that define how Amazon S3 manages objects during their lifetime.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withLifecycleRules(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> value) {
            this._lifecycleRules = value;
            return this;
        }
        /**
         * Sets the value of Metrics
         * @param value The metrics configuration of this bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withMetrics(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.s3.BucketMetrics> value) {
            this._metrics = value;
            return this;
        }
        /**
         * Sets the value of PublicReadAccess
         * @param value Grants public read access to all objects in the bucket. Similar to calling `bucket.grantPublicAccess()`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPublicReadAccess(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._publicReadAccess = value;
            return this;
        }
        /**
         * Sets the value of RemovalPolicy
         * @param value Policy to apply when the bucket is removed from this stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withRemovalPolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.RemovalPolicy value) {
            this._removalPolicy = value;
            return this;
        }
        /**
         * Sets the value of Versioned
         * @param value Whether this bucket should have versioning turned on or not.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withVersioned(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._versioned = value;
            return this;
        }
        /**
         * Sets the value of WebsiteErrorDocument
         * @param value The name of the error document (e.g. "404.html") for the website. `websiteIndexDocument` must also be set if this is set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withWebsiteErrorDocument(@javax.annotation.Nullable final java.lang.String value) {
            this._websiteErrorDocument = value;
            return this;
        }
        /**
         * Sets the value of WebsiteIndexDocument
         * @param value The name of the index document (e.g. "index.html") for the website. Enables static website hosting for this bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withWebsiteIndexDocument(@javax.annotation.Nullable final java.lang.String value) {
            this._websiteIndexDocument = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BucketProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public BucketProps build() {
            return new BucketProps() {
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.s3.BlockPublicAccess $blockPublicAccess = _blockPublicAccess;
                @javax.annotation.Nullable
                private final java.lang.String $bucketName = _bucketName;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.s3.CorsRule> $cors = _cors;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.s3.BucketEncryption $encryption = _encryption;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.kms.IKey $encryptionKey = _encryptionKey;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> $lifecycleRules = _lifecycleRules;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.s3.BucketMetrics> $metrics = _metrics;
                @javax.annotation.Nullable
                private final java.lang.Boolean $publicReadAccess = _publicReadAccess;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.RemovalPolicy $removalPolicy = _removalPolicy;
                @javax.annotation.Nullable
                private final java.lang.Boolean $versioned = _versioned;
                @javax.annotation.Nullable
                private final java.lang.String $websiteErrorDocument = _websiteErrorDocument;
                @javax.annotation.Nullable
                private final java.lang.String $websiteIndexDocument = _websiteIndexDocument;

                @Override
                public software.amazon.awscdk.services.s3.BlockPublicAccess getBlockPublicAccess() {
                    return this.$blockPublicAccess;
                }

                @Override
                public java.lang.String getBucketName() {
                    return this.$bucketName;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.s3.CorsRule> getCors() {
                    return this.$cors;
                }

                @Override
                public software.amazon.awscdk.services.s3.BucketEncryption getEncryption() {
                    return this.$encryption;
                }

                @Override
                public software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
                    return this.$encryptionKey;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> getLifecycleRules() {
                    return this.$lifecycleRules;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.s3.BucketMetrics> getMetrics() {
                    return this.$metrics;
                }

                @Override
                public java.lang.Boolean getPublicReadAccess() {
                    return this.$publicReadAccess;
                }

                @Override
                public software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
                    return this.$removalPolicy;
                }

                @Override
                public java.lang.Boolean getVersioned() {
                    return this.$versioned;
                }

                @Override
                public java.lang.String getWebsiteErrorDocument() {
                    return this.$websiteErrorDocument;
                }

                @Override
                public java.lang.String getWebsiteIndexDocument() {
                    return this.$websiteIndexDocument;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getBlockPublicAccess() != null) {
                        obj.set("blockPublicAccess", om.valueToTree(this.getBlockPublicAccess()));
                    }
                    if (this.getBucketName() != null) {
                        obj.set("bucketName", om.valueToTree(this.getBucketName()));
                    }
                    if (this.getCors() != null) {
                        obj.set("cors", om.valueToTree(this.getCors()));
                    }
                    if (this.getEncryption() != null) {
                        obj.set("encryption", om.valueToTree(this.getEncryption()));
                    }
                    if (this.getEncryptionKey() != null) {
                        obj.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
                    }
                    if (this.getLifecycleRules() != null) {
                        obj.set("lifecycleRules", om.valueToTree(this.getLifecycleRules()));
                    }
                    if (this.getMetrics() != null) {
                        obj.set("metrics", om.valueToTree(this.getMetrics()));
                    }
                    if (this.getPublicReadAccess() != null) {
                        obj.set("publicReadAccess", om.valueToTree(this.getPublicReadAccess()));
                    }
                    if (this.getRemovalPolicy() != null) {
                        obj.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
                    }
                    if (this.getVersioned() != null) {
                        obj.set("versioned", om.valueToTree(this.getVersioned()));
                    }
                    if (this.getWebsiteErrorDocument() != null) {
                        obj.set("websiteErrorDocument", om.valueToTree(this.getWebsiteErrorDocument()));
                    }
                    if (this.getWebsiteIndexDocument() != null) {
                        obj.set("websiteIndexDocument", om.valueToTree(this.getWebsiteIndexDocument()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.BucketProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The block public access configuration of this bucket.
         * 
         * Default: false New buckets and objects don't allow public access, but users can modify bucket
         * policies or object permissions to allow public access.
         * 
         * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.s3.BlockPublicAccess getBlockPublicAccess() {
            return this.jsiiGet("blockPublicAccess", software.amazon.awscdk.services.s3.BlockPublicAccess.class);
        }

        /**
         * Physical name of this bucket.
         * 
         * Default: - Assigned by CloudFormation (recommended).
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getBucketName() {
            return this.jsiiGet("bucketName", java.lang.String.class);
        }

        /**
         * The CORS configuration of this bucket.
         * 
         * Default: - No CORS configuration.
         * 
         * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.s3.CorsRule> getCors() {
            return this.jsiiGet("cors", java.util.List.class);
        }

        /**
         * The kind of server-side encryption to apply to this bucket.
         * 
         * If you choose KMS, you can specify a KMS key via `encryptionKey`. If
         * encryption key is not specified, a key will automatically be created.
         * 
         * Default: - `Kms` if `encryptionKey` is specified, or `Unencrypted` otherwise.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.s3.BucketEncryption getEncryption() {
            return this.jsiiGet("encryption", software.amazon.awscdk.services.s3.BucketEncryption.class);
        }

        /**
         * External KMS key to use for bucket encryption.
         * 
         * The 'encryption' property must be either not specified or set to "Kms".
         * An error will be emitted if encryption is set to "Unencrypted" or
         * "Managed".
         * 
         * Default: - If encryption is set to "Kms" and this property is undefined,
         * a new KMS key will be created and associated with this bucket.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.IKey.class);
        }

        /**
         * Rules that define how Amazon S3 manages objects during their lifetime.
         * 
         * Default: - No lifecycle rules.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> getLifecycleRules() {
            return this.jsiiGet("lifecycleRules", java.util.List.class);
        }

        /**
         * The metrics configuration of this bucket.
         * 
         * Default: - No metrics configuration.
         * 
         * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.s3.BucketMetrics> getMetrics() {
            return this.jsiiGet("metrics", java.util.List.class);
        }

        /**
         * Grants public read access to all objects in the bucket. Similar to calling `bucket.grantPublicAccess()`.
         * 
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getPublicReadAccess() {
            return this.jsiiGet("publicReadAccess", java.lang.Boolean.class);
        }

        /**
         * Policy to apply when the bucket is removed from this stack.
         * 
         * Default: - The bucket will be orphaned.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
            return this.jsiiGet("removalPolicy", software.amazon.awscdk.core.RemovalPolicy.class);
        }

        /**
         * Whether this bucket should have versioning turned on or not.
         * 
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getVersioned() {
            return this.jsiiGet("versioned", java.lang.Boolean.class);
        }

        /**
         * The name of the error document (e.g. "404.html") for the website. `websiteIndexDocument` must also be set if this is set.
         * 
         * Default: - No error document.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getWebsiteErrorDocument() {
            return this.jsiiGet("websiteErrorDocument", java.lang.String.class);
        }

        /**
         * The name of the index document (e.g. "index.html") for the website. Enables static website hosting for this bucket.
         * 
         * Default: - No index document.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getWebsiteIndexDocument() {
            return this.jsiiGet("websiteIndexDocument", java.lang.String.class);
        }
    }
}
