package software.amazon.awscdk.services.s3;

/**
 * A reference to a bucket.
 * 
 * The easiest way to instantiate is to call
 * `bucket.export()`. Then, the consumer can use `Bucket.import(this, ref)` and
 * get a `Bucket`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-08T13:05:58.311Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BucketAttributes extends software.amazon.jsii.JsiiSerializable {
    /**
     * The ARN of the bucket.
     * 
     * At least one of bucketArn or bucketName must be
     * defined in order to initialize a bucket ref.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getBucketArn();
    /**
     * The domain name of the bucket.
     * 
     * Default: Inferred from bucket name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getBucketDomainName();
    /**
     * The IPv6 DNS name of the specified bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getBucketDualStackDomainName();
    /**
     * The name of the bucket.
     * 
     * If the underlying value of ARN is a string, the
     * name will be parsed from the ARN. Otherwise, the name is optional, but
     * some features that require the bucket name such as auto-creating a bucket
     * policy, won't work.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getBucketName();
    /**
     * The regional domain name of the specified bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getBucketRegionalDomainName();
    /**
     * The format of the website URL of the bucket.
     * 
     * This should be true for
     * regions launched since 2014.
     * 
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getBucketWebsiteNewUrlFormat();
    /**
     * The website URL of the bucket (if static web hosting is enabled).
     * 
     * Default: Inferred from bucket name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getBucketWebsiteUrl();

    /**
     * @return a {@link Builder} of {@link BucketAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link BucketAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.String _bucketArn;
        @javax.annotation.Nullable
        private java.lang.String _bucketDomainName;
        @javax.annotation.Nullable
        private java.lang.String _bucketDualStackDomainName;
        @javax.annotation.Nullable
        private java.lang.String _bucketName;
        @javax.annotation.Nullable
        private java.lang.String _bucketRegionalDomainName;
        @javax.annotation.Nullable
        private java.lang.Boolean _bucketWebsiteNewUrlFormat;
        @javax.annotation.Nullable
        private java.lang.String _bucketWebsiteUrl;

        /**
         * Sets the value of BucketArn
         * @param value The ARN of the bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withBucketArn(@javax.annotation.Nullable final java.lang.String value) {
            this._bucketArn = value;
            return this;
        }
        /**
         * Sets the value of BucketDomainName
         * @param value The domain name of the bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withBucketDomainName(@javax.annotation.Nullable final java.lang.String value) {
            this._bucketDomainName = value;
            return this;
        }
        /**
         * Sets the value of BucketDualStackDomainName
         * @param value The IPv6 DNS name of the specified bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withBucketDualStackDomainName(@javax.annotation.Nullable final java.lang.String value) {
            this._bucketDualStackDomainName = value;
            return this;
        }
        /**
         * Sets the value of BucketName
         * @param value The name of the bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withBucketName(@javax.annotation.Nullable final java.lang.String value) {
            this._bucketName = value;
            return this;
        }
        /**
         * Sets the value of BucketRegionalDomainName
         * @param value The regional domain name of the specified bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withBucketRegionalDomainName(@javax.annotation.Nullable final java.lang.String value) {
            this._bucketRegionalDomainName = value;
            return this;
        }
        /**
         * Sets the value of BucketWebsiteNewUrlFormat
         * @param value The format of the website URL of the bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withBucketWebsiteNewUrlFormat(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._bucketWebsiteNewUrlFormat = value;
            return this;
        }
        /**
         * Sets the value of BucketWebsiteUrl
         * @param value The website URL of the bucket (if static web hosting is enabled).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withBucketWebsiteUrl(@javax.annotation.Nullable final java.lang.String value) {
            this._bucketWebsiteUrl = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BucketAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public BucketAttributes build() {
            return new BucketAttributes() {
                @javax.annotation.Nullable
                private final java.lang.String $bucketArn = _bucketArn;
                @javax.annotation.Nullable
                private final java.lang.String $bucketDomainName = _bucketDomainName;
                @javax.annotation.Nullable
                private final java.lang.String $bucketDualStackDomainName = _bucketDualStackDomainName;
                @javax.annotation.Nullable
                private final java.lang.String $bucketName = _bucketName;
                @javax.annotation.Nullable
                private final java.lang.String $bucketRegionalDomainName = _bucketRegionalDomainName;
                @javax.annotation.Nullable
                private final java.lang.Boolean $bucketWebsiteNewUrlFormat = _bucketWebsiteNewUrlFormat;
                @javax.annotation.Nullable
                private final java.lang.String $bucketWebsiteUrl = _bucketWebsiteUrl;

                @Override
                public java.lang.String getBucketArn() {
                    return this.$bucketArn;
                }

                @Override
                public java.lang.String getBucketDomainName() {
                    return this.$bucketDomainName;
                }

                @Override
                public java.lang.String getBucketDualStackDomainName() {
                    return this.$bucketDualStackDomainName;
                }

                @Override
                public java.lang.String getBucketName() {
                    return this.$bucketName;
                }

                @Override
                public java.lang.String getBucketRegionalDomainName() {
                    return this.$bucketRegionalDomainName;
                }

                @Override
                public java.lang.Boolean getBucketWebsiteNewUrlFormat() {
                    return this.$bucketWebsiteNewUrlFormat;
                }

                @Override
                public java.lang.String getBucketWebsiteUrl() {
                    return this.$bucketWebsiteUrl;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getBucketArn() != null) {
                        obj.set("bucketArn", om.valueToTree(this.getBucketArn()));
                    }
                    if (this.getBucketDomainName() != null) {
                        obj.set("bucketDomainName", om.valueToTree(this.getBucketDomainName()));
                    }
                    if (this.getBucketDualStackDomainName() != null) {
                        obj.set("bucketDualStackDomainName", om.valueToTree(this.getBucketDualStackDomainName()));
                    }
                    if (this.getBucketName() != null) {
                        obj.set("bucketName", om.valueToTree(this.getBucketName()));
                    }
                    if (this.getBucketRegionalDomainName() != null) {
                        obj.set("bucketRegionalDomainName", om.valueToTree(this.getBucketRegionalDomainName()));
                    }
                    if (this.getBucketWebsiteNewUrlFormat() != null) {
                        obj.set("bucketWebsiteNewUrlFormat", om.valueToTree(this.getBucketWebsiteNewUrlFormat()));
                    }
                    if (this.getBucketWebsiteUrl() != null) {
                        obj.set("bucketWebsiteUrl", om.valueToTree(this.getBucketWebsiteUrl()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.BucketAttributes {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The ARN of the bucket.
         * 
         * At least one of bucketArn or bucketName must be
         * defined in order to initialize a bucket ref.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getBucketArn() {
            return this.jsiiGet("bucketArn", java.lang.String.class);
        }

        /**
         * The domain name of the bucket.
         * 
         * Default: Inferred from bucket name
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getBucketDomainName() {
            return this.jsiiGet("bucketDomainName", java.lang.String.class);
        }

        /**
         * The IPv6 DNS name of the specified bucket.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getBucketDualStackDomainName() {
            return this.jsiiGet("bucketDualStackDomainName", java.lang.String.class);
        }

        /**
         * The name of the bucket.
         * 
         * If the underlying value of ARN is a string, the
         * name will be parsed from the ARN. Otherwise, the name is optional, but
         * some features that require the bucket name such as auto-creating a bucket
         * policy, won't work.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getBucketName() {
            return this.jsiiGet("bucketName", java.lang.String.class);
        }

        /**
         * The regional domain name of the specified bucket.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getBucketRegionalDomainName() {
            return this.jsiiGet("bucketRegionalDomainName", java.lang.String.class);
        }

        /**
         * The format of the website URL of the bucket.
         * 
         * This should be true for
         * regions launched since 2014.
         * 
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getBucketWebsiteNewUrlFormat() {
            return this.jsiiGet("bucketWebsiteNewUrlFormat", java.lang.Boolean.class);
        }

        /**
         * The website URL of the bucket (if static web hosting is enabled).
         * 
         * Default: Inferred from bucket name
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getBucketWebsiteUrl() {
            return this.jsiiGet("bucketWebsiteUrl", java.lang.String.class);
        }
    }
}
