package software.amazon.awscdk.services.s3;

/**
 * Declaration of a Life cycle rule.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-08T13:05:58.354Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LifecycleRule extends software.amazon.jsii.JsiiSerializable {
    /**
     * Specifies a lifecycle rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
     * 
     * The AbortIncompleteMultipartUpload property type creates a lifecycle
     * rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
     * When Amazon S3 aborts a multipart upload, it deletes all parts
     * associated with the multipart upload.
     * 
     * Default: Incomplete uploads are never aborted
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.Duration getAbortIncompleteMultipartUploadAfter();
    /**
     * Whether this rule is enabled.
     * 
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getEnabled();
    /**
     * Indicates the number of days after creation when objects are deleted from Amazon S3 and Amazon Glacier.
     * 
     * If you specify an expiration and transition time, you must use the same
     * time unit for both properties (either in days or by date). The
     * expiration time must also be later than the transition time.
     * 
     * Default: No expiration timeout
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.Duration getExpiration();
    /**
     * Indicates when objects are deleted from Amazon S3 and Amazon Glacier.
     * 
     * The date value must be in ISO 8601 format. The time is always midnight UTC.
     * 
     * If you specify an expiration and transition time, you must use the same
     * time unit for both properties (either in days or by date). The
     * expiration time must also be later than the transition time.
     * 
     * Default: No expiration date
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.time.Instant getExpirationDate();
    /**
     * A unique identifier for this rule.
     * 
     * The value cannot be more than 255 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getId();
    /**
     * Time between when a new version of the object is uploaded to the bucket and when old versions of the object expire.
     * 
     * For buckets with versioning enabled (or suspended), specifies the time,
     * in days, between when a new version of the object is uploaded to the
     * bucket and when old versions of the object expire. When object versions
     * expire, Amazon S3 permanently deletes them. If you specify a transition
     * and expiration time, the expiration time must be later than the
     * transition time.
     * 
     * Default: No noncurrent version expiration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.Duration getNoncurrentVersionExpiration();
    /**
     * One or more transition rules that specify when non-current objects transition to a specified storage class.
     * 
     * Only for for buckets with versioning enabled (or suspended).
     * 
     * If you specify a transition and expiration time, the expiration time
     * must be later than the transition time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.s3.NoncurrentVersionTransition> getNoncurrentVersionTransitions();
    /**
     * Object key prefix that identifies one or more objects to which this rule applies.
     * 
     * Default: Rule applies to all objects
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getPrefix();
    /**
     * The TagFilter property type specifies tags to use to identify a subset of objects for an Amazon S3 bucket.
     * 
     * Default: Rule applies to all objects
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.Map<java.lang.String, java.lang.Object> getTagFilters();
    /**
     * One or more transition rules that specify when an object transitions to a specified storage class.
     * 
     * If you specify an expiration and transition time, you must use the same
     * time unit for both properties (either in days or by date). The
     * expiration time must also be later than the transition time.
     * 
     * Default: No transition rules
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.s3.Transition> getTransitions();

    /**
     * @return a {@link Builder} of {@link LifecycleRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link LifecycleRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.Duration _abortIncompleteMultipartUploadAfter;
        @javax.annotation.Nullable
        private java.lang.Boolean _enabled;
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.Duration _expiration;
        @javax.annotation.Nullable
        private java.time.Instant _expirationDate;
        @javax.annotation.Nullable
        private java.lang.String _id;
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.Duration _noncurrentVersionExpiration;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.s3.NoncurrentVersionTransition> _noncurrentVersionTransitions;
        @javax.annotation.Nullable
        private java.lang.String _prefix;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.Object> _tagFilters;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.s3.Transition> _transitions;

        /**
         * Sets the value of AbortIncompleteMultipartUploadAfter
         * @param value Specifies a lifecycle rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withAbortIncompleteMultipartUploadAfter(@javax.annotation.Nullable final software.amazon.awscdk.core.Duration value) {
            this._abortIncompleteMultipartUploadAfter = value;
            return this;
        }
        /**
         * Sets the value of Enabled
         * @param value Whether this rule is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._enabled = value;
            return this;
        }
        /**
         * Sets the value of Expiration
         * @param value Indicates the number of days after creation when objects are deleted from Amazon S3 and Amazon Glacier.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withExpiration(@javax.annotation.Nullable final software.amazon.awscdk.core.Duration value) {
            this._expiration = value;
            return this;
        }
        /**
         * Sets the value of ExpirationDate
         * @param value Indicates when objects are deleted from Amazon S3 and Amazon Glacier.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withExpirationDate(@javax.annotation.Nullable final java.time.Instant value) {
            this._expirationDate = value;
            return this;
        }
        /**
         * Sets the value of Id
         * @param value A unique identifier for this rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withId(@javax.annotation.Nullable final java.lang.String value) {
            this._id = value;
            return this;
        }
        /**
         * Sets the value of NoncurrentVersionExpiration
         * @param value Time between when a new version of the object is uploaded to the bucket and when old versions of the object expire.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withNoncurrentVersionExpiration(@javax.annotation.Nullable final software.amazon.awscdk.core.Duration value) {
            this._noncurrentVersionExpiration = value;
            return this;
        }
        /**
         * Sets the value of NoncurrentVersionTransitions
         * @param value One or more transition rules that specify when non-current objects transition to a specified storage class.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withNoncurrentVersionTransitions(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.s3.NoncurrentVersionTransition> value) {
            this._noncurrentVersionTransitions = value;
            return this;
        }
        /**
         * Sets the value of Prefix
         * @param value Object key prefix that identifies one or more objects to which this rule applies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPrefix(@javax.annotation.Nullable final java.lang.String value) {
            this._prefix = value;
            return this;
        }
        /**
         * Sets the value of TagFilters
         * @param value The TagFilter property type specifies tags to use to identify a subset of objects for an Amazon S3 bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withTagFilters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
            this._tagFilters = value;
            return this;
        }
        /**
         * Sets the value of Transitions
         * @param value One or more transition rules that specify when an object transitions to a specified storage class.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withTransitions(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.s3.Transition> value) {
            this._transitions = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LifecycleRule}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public LifecycleRule build() {
            return new LifecycleRule() {
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.Duration $abortIncompleteMultipartUploadAfter = _abortIncompleteMultipartUploadAfter;
                @javax.annotation.Nullable
                private final java.lang.Boolean $enabled = _enabled;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.Duration $expiration = _expiration;
                @javax.annotation.Nullable
                private final java.time.Instant $expirationDate = _expirationDate;
                @javax.annotation.Nullable
                private final java.lang.String $id = _id;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.Duration $noncurrentVersionExpiration = _noncurrentVersionExpiration;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.s3.NoncurrentVersionTransition> $noncurrentVersionTransitions = _noncurrentVersionTransitions;
                @javax.annotation.Nullable
                private final java.lang.String $prefix = _prefix;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, java.lang.Object> $tagFilters = _tagFilters;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.s3.Transition> $transitions = _transitions;

                @Override
                public software.amazon.awscdk.core.Duration getAbortIncompleteMultipartUploadAfter() {
                    return this.$abortIncompleteMultipartUploadAfter;
                }

                @Override
                public java.lang.Boolean getEnabled() {
                    return this.$enabled;
                }

                @Override
                public software.amazon.awscdk.core.Duration getExpiration() {
                    return this.$expiration;
                }

                @Override
                public java.time.Instant getExpirationDate() {
                    return this.$expirationDate;
                }

                @Override
                public java.lang.String getId() {
                    return this.$id;
                }

                @Override
                public software.amazon.awscdk.core.Duration getNoncurrentVersionExpiration() {
                    return this.$noncurrentVersionExpiration;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.s3.NoncurrentVersionTransition> getNoncurrentVersionTransitions() {
                    return this.$noncurrentVersionTransitions;
                }

                @Override
                public java.lang.String getPrefix() {
                    return this.$prefix;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.Object> getTagFilters() {
                    return this.$tagFilters;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.s3.Transition> getTransitions() {
                    return this.$transitions;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getAbortIncompleteMultipartUploadAfter() != null) {
                        obj.set("abortIncompleteMultipartUploadAfter", om.valueToTree(this.getAbortIncompleteMultipartUploadAfter()));
                    }
                    if (this.getEnabled() != null) {
                        obj.set("enabled", om.valueToTree(this.getEnabled()));
                    }
                    if (this.getExpiration() != null) {
                        obj.set("expiration", om.valueToTree(this.getExpiration()));
                    }
                    if (this.getExpirationDate() != null) {
                        obj.set("expirationDate", om.valueToTree(this.getExpirationDate()));
                    }
                    if (this.getId() != null) {
                        obj.set("id", om.valueToTree(this.getId()));
                    }
                    if (this.getNoncurrentVersionExpiration() != null) {
                        obj.set("noncurrentVersionExpiration", om.valueToTree(this.getNoncurrentVersionExpiration()));
                    }
                    if (this.getNoncurrentVersionTransitions() != null) {
                        obj.set("noncurrentVersionTransitions", om.valueToTree(this.getNoncurrentVersionTransitions()));
                    }
                    if (this.getPrefix() != null) {
                        obj.set("prefix", om.valueToTree(this.getPrefix()));
                    }
                    if (this.getTagFilters() != null) {
                        obj.set("tagFilters", om.valueToTree(this.getTagFilters()));
                    }
                    if (this.getTransitions() != null) {
                        obj.set("transitions", om.valueToTree(this.getTransitions()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.LifecycleRule {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Specifies a lifecycle rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
         * 
         * The AbortIncompleteMultipartUpload property type creates a lifecycle
         * rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
         * When Amazon S3 aborts a multipart upload, it deletes all parts
         * associated with the multipart upload.
         * 
         * Default: Incomplete uploads are never aborted
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.Duration getAbortIncompleteMultipartUploadAfter() {
            return this.jsiiGet("abortIncompleteMultipartUploadAfter", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * Whether this rule is enabled.
         * 
         * Default: true
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getEnabled() {
            return this.jsiiGet("enabled", java.lang.Boolean.class);
        }

        /**
         * Indicates the number of days after creation when objects are deleted from Amazon S3 and Amazon Glacier.
         * 
         * If you specify an expiration and transition time, you must use the same
         * time unit for both properties (either in days or by date). The
         * expiration time must also be later than the transition time.
         * 
         * Default: No expiration timeout
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.Duration getExpiration() {
            return this.jsiiGet("expiration", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * Indicates when objects are deleted from Amazon S3 and Amazon Glacier.
         * 
         * The date value must be in ISO 8601 format. The time is always midnight UTC.
         * 
         * If you specify an expiration and transition time, you must use the same
         * time unit for both properties (either in days or by date). The
         * expiration time must also be later than the transition time.
         * 
         * Default: No expiration date
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.time.Instant getExpirationDate() {
            return this.jsiiGet("expirationDate", java.time.Instant.class);
        }

        /**
         * A unique identifier for this rule.
         * 
         * The value cannot be more than 255 characters.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getId() {
            return this.jsiiGet("id", java.lang.String.class);
        }

        /**
         * Time between when a new version of the object is uploaded to the bucket and when old versions of the object expire.
         * 
         * For buckets with versioning enabled (or suspended), specifies the time,
         * in days, between when a new version of the object is uploaded to the
         * bucket and when old versions of the object expire. When object versions
         * expire, Amazon S3 permanently deletes them. If you specify a transition
         * and expiration time, the expiration time must be later than the
         * transition time.
         * 
         * Default: No noncurrent version expiration
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.Duration getNoncurrentVersionExpiration() {
            return this.jsiiGet("noncurrentVersionExpiration", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * One or more transition rules that specify when non-current objects transition to a specified storage class.
         * 
         * Only for for buckets with versioning enabled (or suspended).
         * 
         * If you specify a transition and expiration time, the expiration time
         * must be later than the transition time.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.s3.NoncurrentVersionTransition> getNoncurrentVersionTransitions() {
            return this.jsiiGet("noncurrentVersionTransitions", java.util.List.class);
        }

        /**
         * Object key prefix that identifies one or more objects to which this rule applies.
         * 
         * Default: Rule applies to all objects
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getPrefix() {
            return this.jsiiGet("prefix", java.lang.String.class);
        }

        /**
         * The TagFilter property type specifies tags to use to identify a subset of objects for an Amazon S3 bucket.
         * 
         * Default: Rule applies to all objects
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.Object> getTagFilters() {
            return this.jsiiGet("tagFilters", java.util.Map.class);
        }

        /**
         * One or more transition rules that specify when an object transitions to a specified storage class.
         * 
         * If you specify an expiration and transition time, you must use the same
         * time unit for both properties (either in days or by date). The
         * expiration time must also be later than the transition time.
         * 
         * Default: No transition rules
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.s3.Transition> getTransitions() {
            return this.jsiiGet("transitions", java.util.List.class);
        }
    }
}
