package software.amazon.awscdk.services.s3;

/**
 * Describes when an object transitions to a specified storage class.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-08T13:05:58.364Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface Transition extends software.amazon.jsii.JsiiSerializable {
    /**
     * The storage class to which you want the object to transition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.s3.StorageClass getStorageClass();
    /**
     * Indicates the number of days after creation when objects are transitioned to the specified storage class.
     * 
     * Default: No transition count.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.Duration getTransitionAfter();
    /**
     * Indicates when objects are transitioned to the specified storage class.
     * 
     * The date value must be in ISO 8601 format. The time is always midnight UTC.
     * 
     * Default: No transition date.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.time.Instant getTransitionDate();

    /**
     * @return a {@link Builder} of {@link Transition}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link Transition}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.services.s3.StorageClass _storageClass;
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.Duration _transitionAfter;
        @javax.annotation.Nullable
        private java.time.Instant _transitionDate;

        /**
         * Sets the value of StorageClass
         * @param value The storage class to which you want the object to transition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withStorageClass(final software.amazon.awscdk.services.s3.StorageClass value) {
            this._storageClass = java.util.Objects.requireNonNull(value, "storageClass is required");
            return this;
        }
        /**
         * Sets the value of TransitionAfter
         * @param value Indicates the number of days after creation when objects are transitioned to the specified storage class.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withTransitionAfter(@javax.annotation.Nullable final software.amazon.awscdk.core.Duration value) {
            this._transitionAfter = value;
            return this;
        }
        /**
         * Sets the value of TransitionDate
         * @param value Indicates when objects are transitioned to the specified storage class.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withTransitionDate(@javax.annotation.Nullable final java.time.Instant value) {
            this._transitionDate = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Transition}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Transition build() {
            return new Transition() {
                private final software.amazon.awscdk.services.s3.StorageClass $storageClass = java.util.Objects.requireNonNull(_storageClass, "storageClass is required");
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.Duration $transitionAfter = _transitionAfter;
                @javax.annotation.Nullable
                private final java.time.Instant $transitionDate = _transitionDate;

                @Override
                public software.amazon.awscdk.services.s3.StorageClass getStorageClass() {
                    return this.$storageClass;
                }

                @Override
                public software.amazon.awscdk.core.Duration getTransitionAfter() {
                    return this.$transitionAfter;
                }

                @Override
                public java.time.Instant getTransitionDate() {
                    return this.$transitionDate;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("storageClass", om.valueToTree(this.getStorageClass()));
                    if (this.getTransitionAfter() != null) {
                        obj.set("transitionAfter", om.valueToTree(this.getTransitionAfter()));
                    }
                    if (this.getTransitionDate() != null) {
                        obj.set("transitionDate", om.valueToTree(this.getTransitionDate()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.Transition {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The storage class to which you want the object to transition.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.s3.StorageClass getStorageClass() {
            return this.jsiiGet("storageClass", software.amazon.awscdk.services.s3.StorageClass.class);
        }

        /**
         * Indicates the number of days after creation when objects are transitioned to the specified storage class.
         * 
         * Default: No transition count.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.Duration getTransitionAfter() {
            return this.jsiiGet("transitionAfter", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * Indicates when objects are transitioned to the specified storage class.
         * 
         * The date value must be in ISO 8601 format. The time is always midnight UTC.
         * 
         * Default: No transition date.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.time.Instant getTransitionDate() {
            return this.jsiiGet("transitionDate", java.time.Instant.class);
        }
    }
}
