package software.amazon.awscdk.services.s3;
/**
 * Describes when noncurrent versions transition to a specified storage class.
 */
public interface NoncurrentVersionTransition extends software.amazon.jsii.JsiiSerializable {
    /**
     * The storage class to which you want the object to transition.
     */
    software.amazon.awscdk.services.s3.StorageClass getStorageClass();
    /**
     * The storage class to which you want the object to transition.
     */
    void setStorageClass(final software.amazon.awscdk.services.s3.StorageClass value);
    /**
     * Indicates the number of days after creation when objects are transitioned to the specified storage class.
     * @default No transition count.
     */
    java.lang.Number getTransitionInDays();
    /**
     * Indicates the number of days after creation when objects are transitioned to the specified storage class.
     * @default No transition count.
     */
    void setTransitionInDays(final java.lang.Number value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link NoncurrentVersionTransition}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * The storage class to which you want the object to transition.
         */
        public TransitionInDaysStep withStorageClass(final software.amazon.awscdk.services.s3.StorageClass value) {
            return new FullBuilder().withStorageClass(value);
        }

        public interface TransitionInDaysStep {
            /**
             * Indicates the number of days after creation when objects are transitioned to the specified storage class.
             * @default No transition count.
             */
            Build withTransitionInDays(final java.lang.Number value);
        }

        public interface Build {
            /**
             * @return a new {@link NoncurrentVersionTransition} object, initialized with the values set on this builder.
             */
            NoncurrentVersionTransition build();
        }

        final class FullBuilder implements TransitionInDaysStep, Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * The storage class to which you want the object to transition.
             */
            public TransitionInDaysStep withStorageClass(final software.amazon.awscdk.services.s3.StorageClass value) {
                java.util.Objects.requireNonNull(value, "NoncurrentVersionTransition#storageClass is required");
                this.instance._storageClass = value;
                return this;
            }
            /**
             * Indicates the number of days after creation when objects are transitioned to the specified storage class.
             * @default No transition count.
             */
            public Build withTransitionInDays(final java.lang.Number value) {
                java.util.Objects.requireNonNull(value, "NoncurrentVersionTransition#transitionInDays is required");
                this.instance._transitionInDays = value;
                return this;
            }
            public NoncurrentVersionTransition build() {
                NoncurrentVersionTransition result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link NoncurrentVersionTransition}.
     */
    final class Jsii$Pojo implements NoncurrentVersionTransition {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected software.amazon.awscdk.services.s3.StorageClass _storageClass;

        public software.amazon.awscdk.services.s3.StorageClass getStorageClass() {
            return this._storageClass;
        }
        public void setStorageClass(final software.amazon.awscdk.services.s3.StorageClass value) {
            this._storageClass = value;
        }

        protected java.lang.Number _transitionInDays;

        public java.lang.Number getTransitionInDays() {
            return this._transitionInDays;
        }
        public void setTransitionInDays(final java.lang.Number value) {
            this._transitionInDays = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.NoncurrentVersionTransition {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * The storage class to which you want the object to transition.
         */
        public software.amazon.awscdk.services.s3.StorageClass getStorageClass() {
            return this.jsiiGet("storageClass", software.amazon.awscdk.services.s3.StorageClass.class);
        }
        /**
         * The storage class to which you want the object to transition.
         */
        public void setStorageClass(final software.amazon.awscdk.services.s3.StorageClass value) {
            this.jsiiSet("storageClass", java.util.Objects.requireNonNull(value, "storageClass is required"));
        }
        /**
         * Indicates the number of days after creation when objects are transitioned to the specified storage class.
         * @default No transition count.
         */
        public java.lang.Number getTransitionInDays() {
            return this.jsiiGet("transitionInDays", java.lang.Number.class);
        }
        /**
         * Indicates the number of days after creation when objects are transitioned to the specified storage class.
         * @default No transition count.
         */
        public void setTransitionInDays(final java.lang.Number value) {
            this.jsiiSet("transitionInDays", java.util.Objects.requireNonNull(value, "transitionInDays is required"));
        }
    }
}
