package software.amazon.awscdk.services.s3;
/**
 * Describes when an object transitions to a specified storage class.
 */
public interface Transition extends software.amazon.jsii.JsiiSerializable {
    /**
     * The storage class to which you want the object to transition.
     */
    software.amazon.awscdk.services.s3.StorageClass getStorageClass();
    /**
     * The storage class to which you want the object to transition.
     */
    void setStorageClass(final software.amazon.awscdk.services.s3.StorageClass value);
    /**
     * Indicates when objects are transitioned to the specified storage class.
     * 
     * The date value must be in ISO 8601 format. The time is always midnight UTC.
     * @default No transition date.
     */
    java.time.Instant getTransitionDate();
    /**
     * Indicates when objects are transitioned to the specified storage class.
     * 
     * The date value must be in ISO 8601 format. The time is always midnight UTC.
     * @default No transition date.
     */
    void setTransitionDate(final java.time.Instant value);
    /**
     * Indicates the number of days after creation when objects are transitioned to the specified storage class.
     * @default No transition count.
     */
    java.lang.Number getTransitionInDays();
    /**
     * Indicates the number of days after creation when objects are transitioned to the specified storage class.
     * @default No transition count.
     */
    void setTransitionInDays(final java.lang.Number value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link Transition}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * The storage class to which you want the object to transition.
         */
        public Build withStorageClass(final software.amazon.awscdk.services.s3.StorageClass value) {
            return new FullBuilder().withStorageClass(value);
        }

        public interface Build {
            /**
             * @return a new {@link Transition} object, initialized with the values set on this builder.
             */
            Transition build();
            /**
             * Indicates when objects are transitioned to the specified storage class.
             * 
             * The date value must be in ISO 8601 format. The time is always midnight UTC.
             * @default No transition date.
             */
            Build withTransitionDate(final java.time.Instant value);
            /**
             * Indicates the number of days after creation when objects are transitioned to the specified storage class.
             * @default No transition count.
             */
            Build withTransitionInDays(final java.lang.Number value);
        }

        final class FullBuilder implements Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * The storage class to which you want the object to transition.
             */
            public Build withStorageClass(final software.amazon.awscdk.services.s3.StorageClass value) {
                java.util.Objects.requireNonNull(value, "Transition#storageClass is required");
                this.instance._storageClass = value;
                return this;
            }
            /**
             * Indicates when objects are transitioned to the specified storage class.
             * 
             * The date value must be in ISO 8601 format. The time is always midnight UTC.
             * @default No transition date.
             */
            public Build withTransitionDate(final java.time.Instant value) {
                this.instance._transitionDate = value;
                return this;
            }
            /**
             * Indicates the number of days after creation when objects are transitioned to the specified storage class.
             * @default No transition count.
             */
            public Build withTransitionInDays(final java.lang.Number value) {
                this.instance._transitionInDays = value;
                return this;
            }
            public Transition build() {
                Transition result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link Transition}.
     */
    final class Jsii$Pojo implements Transition {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected software.amazon.awscdk.services.s3.StorageClass _storageClass;

        public software.amazon.awscdk.services.s3.StorageClass getStorageClass() {
            return this._storageClass;
        }
        public void setStorageClass(final software.amazon.awscdk.services.s3.StorageClass value) {
            this._storageClass = value;
        }

        protected java.time.Instant _transitionDate;

        public java.time.Instant getTransitionDate() {
            return this._transitionDate;
        }
        public void setTransitionDate(final java.time.Instant value) {
            this._transitionDate = value;
        }

        protected java.lang.Number _transitionInDays;

        public java.lang.Number getTransitionInDays() {
            return this._transitionInDays;
        }
        public void setTransitionInDays(final java.lang.Number value) {
            this._transitionInDays = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.Transition {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * The storage class to which you want the object to transition.
         */
        public software.amazon.awscdk.services.s3.StorageClass getStorageClass() {
            return this.jsiiGet("storageClass", software.amazon.awscdk.services.s3.StorageClass.class);
        }
        /**
         * The storage class to which you want the object to transition.
         */
        public void setStorageClass(final software.amazon.awscdk.services.s3.StorageClass value) {
            this.jsiiSet("storageClass", java.util.Objects.requireNonNull(value, "storageClass is required"));
        }
        /**
         * Indicates when objects are transitioned to the specified storage class.
         * 
         * The date value must be in ISO 8601 format. The time is always midnight UTC.
         * @default No transition date.
         */
        @javax.annotation.Nullable
        public java.time.Instant getTransitionDate() {
            return this.jsiiGet("transitionDate", java.time.Instant.class);
        }
        /**
         * Indicates when objects are transitioned to the specified storage class.
         * 
         * The date value must be in ISO 8601 format. The time is always midnight UTC.
         * @default No transition date.
         */
        public void setTransitionDate(@javax.annotation.Nullable final java.time.Instant value) {
            this.jsiiSet("transitionDate", value);
        }
        /**
         * Indicates the number of days after creation when objects are transitioned to the specified storage class.
         * @default No transition count.
         */
        @javax.annotation.Nullable
        public java.lang.Number getTransitionInDays() {
            return this.jsiiGet("transitionInDays", java.lang.Number.class);
        }
        /**
         * Indicates the number of days after creation when objects are transitioned to the specified storage class.
         * @default No transition count.
         */
        public void setTransitionInDays(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("transitionInDays", value);
        }
    }
}
