package software.amazon.awscdk.services.s3;
/**
 * An S3 bucket with associated policy objects
 * 
 * This bucket does not yet have all features that exposed by the underlying
 * BucketResource.
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.Bucket")
public class Bucket extends software.amazon.awscdk.services.s3.BucketRef {
    protected Bucket(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public Bucket(final software.amazon.awscdk.Construct parent, final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.s3.BucketProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(props)).toArray());
    }
    public Bucket(final software.amazon.awscdk.Construct parent, final java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))).toArray());
    }
    /**
     * Add a lifecycle rule to the bucket
     * @param rule The rule to add
     */
    public void addLifecycleRule(final software.amazon.awscdk.services.s3.LifecycleRule rule) {
        this.jsiiCall("addLifecycleRule", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(rule, "rule is required")).toArray());
    }
    /**
     * The ARN of the bucket.
     */
    public software.amazon.awscdk.services.s3.BucketArn getBucketArn() {
        return this.jsiiGet("bucketArn", software.amazon.awscdk.services.s3.BucketArn.class);
    }
    /**
     * The name of the bucket.
     */
    public software.amazon.awscdk.services.s3.BucketName getBucketName() {
        return this.jsiiGet("bucketName", software.amazon.awscdk.services.s3.BucketName.class);
    }
    public software.amazon.awscdk.services.s3.BucketDomainName getDomainName() {
        return this.jsiiGet("domainName", software.amazon.awscdk.services.s3.BucketDomainName.class);
    }
    public software.amazon.awscdk.services.s3.BucketDualStackDomainName getDualstackDomainName() {
        return this.jsiiGet("dualstackDomainName", software.amazon.awscdk.services.s3.BucketDualStackDomainName.class);
    }
    /**
     * Optional KMS encryption key associated with this bucket.
     */
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.kms.EncryptionKeyRef getEncryptionKey() {
        return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.EncryptionKeyRef.class);
    }
    /**
     * The resource policy assoicated with this bucket.
     * 
     * If `autoCreatePolicy` is true, a `BucketPolicy` will be created upon the
     * first call to addToResourcePolicy(s).
     */
    @javax.annotation.Nullable
    protected software.amazon.awscdk.services.s3.BucketPolicy getPolicy() {
        return this.jsiiGet("policy", software.amazon.awscdk.services.s3.BucketPolicy.class);
    }
    /**
     * The resource policy assoicated with this bucket.
     * 
     * If `autoCreatePolicy` is true, a `BucketPolicy` will be created upon the
     * first call to addToResourcePolicy(s).
     */
    protected void setPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.BucketPolicy value) {
        this.jsiiSet("policy", value);
    }
    /**
     * Indicates if a bucket resource policy should automatically created upon
     * the first call to `addToResourcePolicy`.
     */
    protected java.lang.Boolean getAutoCreatePolicy() {
        return this.jsiiGet("autoCreatePolicy", java.lang.Boolean.class);
    }
    /**
     * Indicates if a bucket resource policy should automatically created upon
     * the first call to `addToResourcePolicy`.
     */
    protected void setAutoCreatePolicy(final java.lang.Boolean value) {
        this.jsiiSet("autoCreatePolicy", java.util.Objects.requireNonNull(value, "autoCreatePolicy is required"));
    }
}
