package software.amazon.awscdk.services.s3;
public interface BucketProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The kind of server-side encryption to apply to this bucket.
     * 
     * If you choose KMS, you can specify a KMS key via `encryptionKey`. If
     * encryption key is not specified, a key will automatically be created.
     * @default Unencrypted
     */
    software.amazon.awscdk.services.s3.BucketEncryption getEncryption();
    /**
     * The kind of server-side encryption to apply to this bucket.
     * 
     * If you choose KMS, you can specify a KMS key via `encryptionKey`. If
     * encryption key is not specified, a key will automatically be created.
     * @default Unencrypted
     */
    void setEncryption(final software.amazon.awscdk.services.s3.BucketEncryption value);
    /**
     * External KMS key to use for bucket encryption.
     * 
     * The 'encryption' property must be either not specified or set to "Kms".
     * An error will be emitted if encryption is set to "Unencrypted" or
     * "Managed".
     * @default If encryption is set to "Kms" and this property is undefined, a new KMS key will be created and associated with this bucket.
     */
    software.amazon.awscdk.services.kms.EncryptionKeyRef getEncryptionKey();
    /**
     * External KMS key to use for bucket encryption.
     * 
     * The 'encryption' property must be either not specified or set to "Kms".
     * An error will be emitted if encryption is set to "Unencrypted" or
     * "Managed".
     * @default If encryption is set to "Kms" and this property is undefined, a new KMS key will be created and associated with this bucket.
     */
    void setEncryptionKey(final software.amazon.awscdk.services.kms.EncryptionKeyRef value);
    /**
     * Physical name of this bucket.
     * @default Assigned by CloudFormation (recommended)
     */
    java.lang.String getBucketName();
    /**
     * Physical name of this bucket.
     * @default Assigned by CloudFormation (recommended)
     */
    void setBucketName(final java.lang.String value);
    /**
     * Policy to apply when the bucket is removed from this stack.
     * @default By default, the bucket will be destroyed if it is removed from the stack.
     */
    software.amazon.awscdk.RemovalPolicy getRemovalPolicy();
    /**
     * Policy to apply when the bucket is removed from this stack.
     * @default By default, the bucket will be destroyed if it is removed from the stack.
     */
    void setRemovalPolicy(final software.amazon.awscdk.RemovalPolicy value);
    /**
     * The bucket policy associated with this bucket.
     * @default A bucket policy will be created automatically in the first call to addToPolicy.
     */
    software.amazon.awscdk.services.s3.BucketPolicy getPolicy();
    /**
     * The bucket policy associated with this bucket.
     * @default A bucket policy will be created automatically in the first call to addToPolicy.
     */
    void setPolicy(final software.amazon.awscdk.services.s3.BucketPolicy value);
    /**
     * Whether this bucket should have versioning turned on or not.
     * @default false
     */
    java.lang.Boolean getVersioned();
    /**
     * Whether this bucket should have versioning turned on or not.
     * @default false
     */
    void setVersioned(final java.lang.Boolean value);
    /**
     * Rules that define how Amazon S3 manages objects during their lifetime.
     * @default No lifecycle rules
     */
    java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> getLifecycleRules();
    /**
     * Rules that define how Amazon S3 manages objects during their lifetime.
     * @default No lifecycle rules
     */
    void setLifecycleRules(final java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }

    /**
     * A fluent builder class for {@link BucketProps}.
     */
    public static final class Builder {
        private Jsii$Pojo instance = new Jsii$Pojo();

        /**
         * The kind of server-side encryption to apply to this bucket.
         * 
         * If you choose KMS, you can specify a KMS key via `encryptionKey`. If
         * encryption key is not specified, a key will automatically be created.
         * @default Unencrypted
         */
        public Builder withEncryption(final software.amazon.awscdk.services.s3.BucketEncryption value) {
            this.instance._encryption = value;
            return this;
        }
        /**
         * External KMS key to use for bucket encryption.
         * 
         * The 'encryption' property must be either not specified or set to "Kms".
         * An error will be emitted if encryption is set to "Unencrypted" or
         * "Managed".
         * @default If encryption is set to "Kms" and this property is undefined, a new KMS key will be created and associated with this bucket.
         */
        public Builder withEncryptionKey(final software.amazon.awscdk.services.kms.EncryptionKeyRef value) {
            this.instance._encryptionKey = value;
            return this;
        }
        /**
         * Physical name of this bucket.
         * @default Assigned by CloudFormation (recommended)
         */
        public Builder withBucketName(final java.lang.String value) {
            this.instance._bucketName = value;
            return this;
        }
        /**
         * Policy to apply when the bucket is removed from this stack.
         * @default By default, the bucket will be destroyed if it is removed from the stack.
         */
        public Builder withRemovalPolicy(final software.amazon.awscdk.RemovalPolicy value) {
            this.instance._removalPolicy = value;
            return this;
        }
        /**
         * The bucket policy associated with this bucket.
         * @default A bucket policy will be created automatically in the first call to addToPolicy.
         */
        public Builder withPolicy(final software.amazon.awscdk.services.s3.BucketPolicy value) {
            this.instance._policy = value;
            return this;
        }
        /**
         * Whether this bucket should have versioning turned on or not.
         * @default false
         */
        public Builder withVersioned(final java.lang.Boolean value) {
            this.instance._versioned = value;
            return this;
        }
        /**
         * Rules that define how Amazon S3 manages objects during their lifetime.
         * @default No lifecycle rules
         */
        public Builder withLifecycleRules(final java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> value) {
            this.instance._lifecycleRules = value;
            return this;
        }
        public BucketProps build() {
            BucketProps result = this.instance;
            this.instance = new Jsii$Pojo();
            return result;
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link BucketProps}.
     */
    final class Jsii$Pojo implements BucketProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected software.amazon.awscdk.services.s3.BucketEncryption _encryption;

        public software.amazon.awscdk.services.s3.BucketEncryption getEncryption() {
            return this._encryption;
        }
        public void setEncryption(final software.amazon.awscdk.services.s3.BucketEncryption value) {
            this._encryption = value;
        }

        protected software.amazon.awscdk.services.kms.EncryptionKeyRef _encryptionKey;

        public software.amazon.awscdk.services.kms.EncryptionKeyRef getEncryptionKey() {
            return this._encryptionKey;
        }
        public void setEncryptionKey(final software.amazon.awscdk.services.kms.EncryptionKeyRef value) {
            this._encryptionKey = value;
        }

        protected java.lang.String _bucketName;

        public java.lang.String getBucketName() {
            return this._bucketName;
        }
        public void setBucketName(final java.lang.String value) {
            this._bucketName = value;
        }

        protected software.amazon.awscdk.RemovalPolicy _removalPolicy;

        public software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
            return this._removalPolicy;
        }
        public void setRemovalPolicy(final software.amazon.awscdk.RemovalPolicy value) {
            this._removalPolicy = value;
        }

        protected software.amazon.awscdk.services.s3.BucketPolicy _policy;

        public software.amazon.awscdk.services.s3.BucketPolicy getPolicy() {
            return this._policy;
        }
        public void setPolicy(final software.amazon.awscdk.services.s3.BucketPolicy value) {
            this._policy = value;
        }

        protected java.lang.Boolean _versioned;

        public java.lang.Boolean getVersioned() {
            return this._versioned;
        }
        public void setVersioned(final java.lang.Boolean value) {
            this._versioned = value;
        }

        protected java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> _lifecycleRules;

        public java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> getLifecycleRules() {
            return this._lifecycleRules;
        }
        public void setLifecycleRules(final java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> value) {
            this._lifecycleRules = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.BucketProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * The kind of server-side encryption to apply to this bucket.
         * 
         * If you choose KMS, you can specify a KMS key via `encryptionKey`. If
         * encryption key is not specified, a key will automatically be created.
         * @default Unencrypted
         */
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.s3.BucketEncryption getEncryption() {
            return this.jsiiGet("encryption", software.amazon.awscdk.services.s3.BucketEncryption.class);
        }
        /**
         * The kind of server-side encryption to apply to this bucket.
         * 
         * If you choose KMS, you can specify a KMS key via `encryptionKey`. If
         * encryption key is not specified, a key will automatically be created.
         * @default Unencrypted
         */
        public void setEncryption(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.BucketEncryption value) {
            this.jsiiSet("encryption", value);
        }
        /**
         * External KMS key to use for bucket encryption.
         * 
         * The 'encryption' property must be either not specified or set to "Kms".
         * An error will be emitted if encryption is set to "Unencrypted" or
         * "Managed".
         * @default If encryption is set to "Kms" and this property is undefined, a new KMS key will be created and associated with this bucket.
         */
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.kms.EncryptionKeyRef getEncryptionKey() {
            return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.EncryptionKeyRef.class);
        }
        /**
         * External KMS key to use for bucket encryption.
         * 
         * The 'encryption' property must be either not specified or set to "Kms".
         * An error will be emitted if encryption is set to "Unencrypted" or
         * "Managed".
         * @default If encryption is set to "Kms" and this property is undefined, a new KMS key will be created and associated with this bucket.
         */
        public void setEncryptionKey(@javax.annotation.Nullable final software.amazon.awscdk.services.kms.EncryptionKeyRef value) {
            this.jsiiSet("encryptionKey", value);
        }
        /**
         * Physical name of this bucket.
         * @default Assigned by CloudFormation (recommended)
         */
        @javax.annotation.Nullable
        public java.lang.String getBucketName() {
            return this.jsiiGet("bucketName", java.lang.String.class);
        }
        /**
         * Physical name of this bucket.
         * @default Assigned by CloudFormation (recommended)
         */
        public void setBucketName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("bucketName", value);
        }
        /**
         * Policy to apply when the bucket is removed from this stack.
         * @default By default, the bucket will be destroyed if it is removed from the stack.
         */
        @javax.annotation.Nullable
        public software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
            return this.jsiiGet("removalPolicy", software.amazon.awscdk.RemovalPolicy.class);
        }
        /**
         * Policy to apply when the bucket is removed from this stack.
         * @default By default, the bucket will be destroyed if it is removed from the stack.
         */
        public void setRemovalPolicy(@javax.annotation.Nullable final software.amazon.awscdk.RemovalPolicy value) {
            this.jsiiSet("removalPolicy", value);
        }
        /**
         * The bucket policy associated with this bucket.
         * @default A bucket policy will be created automatically in the first call to addToPolicy.
         */
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.s3.BucketPolicy getPolicy() {
            return this.jsiiGet("policy", software.amazon.awscdk.services.s3.BucketPolicy.class);
        }
        /**
         * The bucket policy associated with this bucket.
         * @default A bucket policy will be created automatically in the first call to addToPolicy.
         */
        public void setPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.BucketPolicy value) {
            this.jsiiSet("policy", value);
        }
        /**
         * Whether this bucket should have versioning turned on or not.
         * @default false
         */
        @javax.annotation.Nullable
        public java.lang.Boolean getVersioned() {
            return this.jsiiGet("versioned", java.lang.Boolean.class);
        }
        /**
         * Whether this bucket should have versioning turned on or not.
         * @default false
         */
        public void setVersioned(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("versioned", value);
        }
        /**
         * Rules that define how Amazon S3 manages objects during their lifetime.
         * @default No lifecycle rules
         */
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> getLifecycleRules() {
            return this.jsiiGet("lifecycleRules", java.util.List.class);
        }
        /**
         * Rules that define how Amazon S3 manages objects during their lifetime.
         * @default No lifecycle rules
         */
        public void setLifecycleRules(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> value) {
            this.jsiiSet("lifecycleRules", value);
        }
    }
}
