package software.amazon.awscdk.services.s3.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html
 */
public interface BucketPolicyResourceProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * ``AWS::S3::BucketPolicy.Bucket``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-bucket
     */
    java.lang.Object getBucket();
    /**
     * ``AWS::S3::BucketPolicy.Bucket``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-bucket
     */
    void setBucket(final java.lang.String value);
    /**
     * ``AWS::S3::BucketPolicy.Bucket``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-bucket
     */
    void setBucket(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::S3::BucketPolicy.PolicyDocument``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-policydocument
     */
    java.lang.Object getPolicyDocument();
    /**
     * ``AWS::S3::BucketPolicy.PolicyDocument``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-policydocument
     */
    void setPolicyDocument(final com.fasterxml.jackson.databind.node.ObjectNode value);
    /**
     * ``AWS::S3::BucketPolicy.PolicyDocument``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-policydocument
     */
    void setPolicyDocument(final software.amazon.awscdk.Token value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link BucketPolicyResourceProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * ``AWS::S3::BucketPolicy.Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-bucket
         */
        public PolicyDocumentStep withBucket(final java.lang.String value) {
            return new FullBuilder().withBucket(value);
        }
        /**
         * ``AWS::S3::BucketPolicy.Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-bucket
         */
        public PolicyDocumentStep withBucket(final software.amazon.awscdk.Token value) {
            return new FullBuilder().withBucket(value);
        }

        public interface PolicyDocumentStep {
            /**
             * ``AWS::S3::BucketPolicy.PolicyDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-policydocument
             */
            Build withPolicyDocument(final com.fasterxml.jackson.databind.node.ObjectNode value);
            /**
             * ``AWS::S3::BucketPolicy.PolicyDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-policydocument
             */
            Build withPolicyDocument(final software.amazon.awscdk.Token value);
        }

        public interface Build {
            /**
             * @return a new {@link BucketPolicyResourceProps} object, initialized with the values set on this builder.
             */
            BucketPolicyResourceProps build();
        }

        final class FullBuilder implements PolicyDocumentStep, Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``AWS::S3::BucketPolicy.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-bucket
             */
            public PolicyDocumentStep withBucket(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "BucketPolicyResourceProps#bucket is required");
                this.instance._bucket = value;
                return this;
            }
            /**
             * ``AWS::S3::BucketPolicy.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-bucket
             */
            public PolicyDocumentStep withBucket(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "BucketPolicyResourceProps#bucket is required");
                this.instance._bucket = value;
                return this;
            }
            /**
             * ``AWS::S3::BucketPolicy.PolicyDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-policydocument
             */
            public Build withPolicyDocument(final com.fasterxml.jackson.databind.node.ObjectNode value) {
                java.util.Objects.requireNonNull(value, "BucketPolicyResourceProps#policyDocument is required");
                this.instance._policyDocument = value;
                return this;
            }
            /**
             * ``AWS::S3::BucketPolicy.PolicyDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-policydocument
             */
            public Build withPolicyDocument(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "BucketPolicyResourceProps#policyDocument is required");
                this.instance._policyDocument = value;
                return this;
            }
            public BucketPolicyResourceProps build() {
                BucketPolicyResourceProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link BucketPolicyResourceProps}.
     */
    final class Jsii$Pojo implements BucketPolicyResourceProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.Object _bucket;

        public java.lang.Object getBucket() {
            return this._bucket;
        }
        public void setBucket(final java.lang.String value) {
            this._bucket = value;
        }
        public void setBucket(final software.amazon.awscdk.Token value) {
            this._bucket = value;
        }

        protected java.lang.Object _policyDocument;

        public java.lang.Object getPolicyDocument() {
            return this._policyDocument;
        }
        public void setPolicyDocument(final com.fasterxml.jackson.databind.node.ObjectNode value) {
            this._policyDocument = value;
        }
        public void setPolicyDocument(final software.amazon.awscdk.Token value) {
            this._policyDocument = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketPolicyResourceProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * ``AWS::S3::BucketPolicy.Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-bucket
         */
        public java.lang.Object getBucket() {
            return this.jsiiGet("bucket", java.lang.Object.class);
        }
        /**
         * ``AWS::S3::BucketPolicy.Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-bucket
         */
        public void setBucket(final java.lang.String value) {
            this.jsiiSet("bucket", java.util.Objects.requireNonNull(value, "bucket is required"));
        }
        /**
         * ``AWS::S3::BucketPolicy.Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-bucket
         */
        public void setBucket(final software.amazon.awscdk.Token value) {
            this.jsiiSet("bucket", java.util.Objects.requireNonNull(value, "bucket is required"));
        }
        /**
         * ``AWS::S3::BucketPolicy.PolicyDocument``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-policydocument
         */
        public java.lang.Object getPolicyDocument() {
            return this.jsiiGet("policyDocument", java.lang.Object.class);
        }
        /**
         * ``AWS::S3::BucketPolicy.PolicyDocument``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-policydocument
         */
        public void setPolicyDocument(final com.fasterxml.jackson.databind.node.ObjectNode value) {
            this.jsiiSet("policyDocument", java.util.Objects.requireNonNull(value, "policyDocument is required"));
        }
        /**
         * ``AWS::S3::BucketPolicy.PolicyDocument``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-policydocument
         */
        public void setPolicyDocument(final software.amazon.awscdk.Token value) {
            this.jsiiSet("policyDocument", java.util.Objects.requireNonNull(value, "policyDocument is required"));
        }
    }
}
