package software.amazon.awscdk.services.s3.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.cloudformation.BucketResource")
public class BucketResource extends software.amazon.awscdk.Resource {
    protected BucketResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.s3.cloudformation.BucketResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::S3::Bucket``.
     * @param parent the ``cdk.Construct`` this ``BucketResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``BucketResource``
     */
    public BucketResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(properties)).toArray());
    }
    /**
     * Creates a new ``AWS::S3::Bucket``.
     * @param parent the ``cdk.Construct`` this ``BucketResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     */
    public BucketResource(final software.amazon.awscdk.Construct parent, final java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @cloudformation_attribute Arn
     */
    public software.amazon.awscdk.services.s3.BucketArn getBucketArn() {
        return this.jsiiGet("bucketArn", software.amazon.awscdk.services.s3.BucketArn.class);
    }
    /**
     * @cloudformation_attribute DomainName
     */
    public software.amazon.awscdk.services.s3.BucketDomainName getBucketDomainName() {
        return this.jsiiGet("bucketDomainName", software.amazon.awscdk.services.s3.BucketDomainName.class);
    }
    /**
     * @cloudformation_attribute DualStackDomainName
     */
    public software.amazon.awscdk.services.s3.BucketDualStackDomainName getBucketDualStackDomainName() {
        return this.jsiiGet("bucketDualStackDomainName", software.amazon.awscdk.services.s3.BucketDualStackDomainName.class);
    }
    /**
     * @cloudformation_attribute WebsiteURL
     */
    public software.amazon.awscdk.services.s3.BucketWebsiteUrl getBucketWebsiteUrl() {
        return this.jsiiGet("bucketWebsiteUrl", software.amazon.awscdk.services.s3.BucketWebsiteUrl.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html
     */
    public static interface AbortIncompleteMultipartUploadProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
         */
        java.lang.Object getDaysAfterInitiation();
        /**
         * ``BucketResource.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
         */
        void setDaysAfterInitiation(final java.lang.Number value);
        /**
         * ``BucketResource.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
         */
        void setDaysAfterInitiation(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link AbortIncompleteMultipartUploadProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
             */
            public Build withDaysAfterInitiation(final java.lang.Number value) {
                return new FullBuilder().withDaysAfterInitiation(value);
            }
            /**
             * ``BucketResource.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
             */
            public Build withDaysAfterInitiation(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withDaysAfterInitiation(value);
            }

            public interface Build {
                /**
                 * @return a new {@link AbortIncompleteMultipartUploadProperty} object, initialized with the values set on this builder.
                 */
                AbortIncompleteMultipartUploadProperty build();
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
                 */
                public Build withDaysAfterInitiation(final java.lang.Number value) {
                    java.util.Objects.requireNonNull(value, "AbortIncompleteMultipartUploadProperty#daysAfterInitiation is required");
                    this.instance._daysAfterInitiation = value;
                    return this;
                }
                /**
                 * ``BucketResource.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
                 */
                public Build withDaysAfterInitiation(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "AbortIncompleteMultipartUploadProperty#daysAfterInitiation is required");
                    this.instance._daysAfterInitiation = value;
                    return this;
                }
                public AbortIncompleteMultipartUploadProperty build() {
                    AbortIncompleteMultipartUploadProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link AbortIncompleteMultipartUploadProperty}.
         */
        final class Jsii$Pojo implements AbortIncompleteMultipartUploadProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _daysAfterInitiation;

            public java.lang.Object getDaysAfterInitiation() {
                return this._daysAfterInitiation;
            }
            public void setDaysAfterInitiation(final java.lang.Number value) {
                this._daysAfterInitiation = value;
            }
            public void setDaysAfterInitiation(final software.amazon.awscdk.Token value) {
                this._daysAfterInitiation = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.AbortIncompleteMultipartUploadProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
             */
            public java.lang.Object getDaysAfterInitiation() {
                return this.jsiiGet("daysAfterInitiation", java.lang.Object.class);
            }
            /**
             * ``BucketResource.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
             */
            public void setDaysAfterInitiation(final java.lang.Number value) {
                this.jsiiSet("daysAfterInitiation", java.util.Objects.requireNonNull(value, "daysAfterInitiation is required"));
            }
            /**
             * ``BucketResource.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
             */
            public void setDaysAfterInitiation(final software.amazon.awscdk.Token value) {
                this.jsiiSet("daysAfterInitiation", java.util.Objects.requireNonNull(value, "daysAfterInitiation is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html
     */
    public static interface AccelerateConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.AccelerateConfigurationProperty.AccelerationStatus``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html#cfn-s3-bucket-accelerateconfiguration-accelerationstatus
         */
        java.lang.Object getAccelerationStatus();
        /**
         * ``BucketResource.AccelerateConfigurationProperty.AccelerationStatus``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html#cfn-s3-bucket-accelerateconfiguration-accelerationstatus
         */
        void setAccelerationStatus(final java.lang.String value);
        /**
         * ``BucketResource.AccelerateConfigurationProperty.AccelerationStatus``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html#cfn-s3-bucket-accelerateconfiguration-accelerationstatus
         */
        void setAccelerationStatus(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link AccelerateConfigurationProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.AccelerateConfigurationProperty.AccelerationStatus``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html#cfn-s3-bucket-accelerateconfiguration-accelerationstatus
             */
            public Build withAccelerationStatus(final java.lang.String value) {
                return new FullBuilder().withAccelerationStatus(value);
            }
            /**
             * ``BucketResource.AccelerateConfigurationProperty.AccelerationStatus``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html#cfn-s3-bucket-accelerateconfiguration-accelerationstatus
             */
            public Build withAccelerationStatus(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withAccelerationStatus(value);
            }

            public interface Build {
                /**
                 * @return a new {@link AccelerateConfigurationProperty} object, initialized with the values set on this builder.
                 */
                AccelerateConfigurationProperty build();
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.AccelerateConfigurationProperty.AccelerationStatus``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html#cfn-s3-bucket-accelerateconfiguration-accelerationstatus
                 */
                public Build withAccelerationStatus(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "AccelerateConfigurationProperty#accelerationStatus is required");
                    this.instance._accelerationStatus = value;
                    return this;
                }
                /**
                 * ``BucketResource.AccelerateConfigurationProperty.AccelerationStatus``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html#cfn-s3-bucket-accelerateconfiguration-accelerationstatus
                 */
                public Build withAccelerationStatus(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "AccelerateConfigurationProperty#accelerationStatus is required");
                    this.instance._accelerationStatus = value;
                    return this;
                }
                public AccelerateConfigurationProperty build() {
                    AccelerateConfigurationProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link AccelerateConfigurationProperty}.
         */
        final class Jsii$Pojo implements AccelerateConfigurationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _accelerationStatus;

            public java.lang.Object getAccelerationStatus() {
                return this._accelerationStatus;
            }
            public void setAccelerationStatus(final java.lang.String value) {
                this._accelerationStatus = value;
            }
            public void setAccelerationStatus(final software.amazon.awscdk.Token value) {
                this._accelerationStatus = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.AccelerateConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.AccelerateConfigurationProperty.AccelerationStatus``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html#cfn-s3-bucket-accelerateconfiguration-accelerationstatus
             */
            public java.lang.Object getAccelerationStatus() {
                return this.jsiiGet("accelerationStatus", java.lang.Object.class);
            }
            /**
             * ``BucketResource.AccelerateConfigurationProperty.AccelerationStatus``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html#cfn-s3-bucket-accelerateconfiguration-accelerationstatus
             */
            public void setAccelerationStatus(final java.lang.String value) {
                this.jsiiSet("accelerationStatus", java.util.Objects.requireNonNull(value, "accelerationStatus is required"));
            }
            /**
             * ``BucketResource.AccelerateConfigurationProperty.AccelerationStatus``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html#cfn-s3-bucket-accelerateconfiguration-accelerationstatus
             */
            public void setAccelerationStatus(final software.amazon.awscdk.Token value) {
                this.jsiiSet("accelerationStatus", java.util.Objects.requireNonNull(value, "accelerationStatus is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html
     */
    public static interface AccessControlTranslationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.AccessControlTranslationProperty.Owner``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html#cfn-s3-bucket-accesscontroltranslation-owner
         */
        java.lang.Object getOwner();
        /**
         * ``BucketResource.AccessControlTranslationProperty.Owner``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html#cfn-s3-bucket-accesscontroltranslation-owner
         */
        void setOwner(final java.lang.String value);
        /**
         * ``BucketResource.AccessControlTranslationProperty.Owner``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html#cfn-s3-bucket-accesscontroltranslation-owner
         */
        void setOwner(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link AccessControlTranslationProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.AccessControlTranslationProperty.Owner``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html#cfn-s3-bucket-accesscontroltranslation-owner
             */
            public Build withOwner(final java.lang.String value) {
                return new FullBuilder().withOwner(value);
            }
            /**
             * ``BucketResource.AccessControlTranslationProperty.Owner``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html#cfn-s3-bucket-accesscontroltranslation-owner
             */
            public Build withOwner(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withOwner(value);
            }

            public interface Build {
                /**
                 * @return a new {@link AccessControlTranslationProperty} object, initialized with the values set on this builder.
                 */
                AccessControlTranslationProperty build();
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.AccessControlTranslationProperty.Owner``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html#cfn-s3-bucket-accesscontroltranslation-owner
                 */
                public Build withOwner(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "AccessControlTranslationProperty#owner is required");
                    this.instance._owner = value;
                    return this;
                }
                /**
                 * ``BucketResource.AccessControlTranslationProperty.Owner``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html#cfn-s3-bucket-accesscontroltranslation-owner
                 */
                public Build withOwner(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "AccessControlTranslationProperty#owner is required");
                    this.instance._owner = value;
                    return this;
                }
                public AccessControlTranslationProperty build() {
                    AccessControlTranslationProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link AccessControlTranslationProperty}.
         */
        final class Jsii$Pojo implements AccessControlTranslationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _owner;

            public java.lang.Object getOwner() {
                return this._owner;
            }
            public void setOwner(final java.lang.String value) {
                this._owner = value;
            }
            public void setOwner(final software.amazon.awscdk.Token value) {
                this._owner = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.AccessControlTranslationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.AccessControlTranslationProperty.Owner``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html#cfn-s3-bucket-accesscontroltranslation-owner
             */
            public java.lang.Object getOwner() {
                return this.jsiiGet("owner", java.lang.Object.class);
            }
            /**
             * ``BucketResource.AccessControlTranslationProperty.Owner``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html#cfn-s3-bucket-accesscontroltranslation-owner
             */
            public void setOwner(final java.lang.String value) {
                this.jsiiSet("owner", java.util.Objects.requireNonNull(value, "owner is required"));
            }
            /**
             * ``BucketResource.AccessControlTranslationProperty.Owner``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html#cfn-s3-bucket-accesscontroltranslation-owner
             */
            public void setOwner(final software.amazon.awscdk.Token value) {
                this.jsiiSet("owner", java.util.Objects.requireNonNull(value, "owner is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html
     */
    public static interface AnalyticsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.AnalyticsConfigurationProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-id
         */
        java.lang.Object getId();
        /**
         * ``BucketResource.AnalyticsConfigurationProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-id
         */
        void setId(final java.lang.String value);
        /**
         * ``BucketResource.AnalyticsConfigurationProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-id
         */
        void setId(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.AnalyticsConfigurationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-prefix
         */
        java.lang.Object getPrefix();
        /**
         * ``BucketResource.AnalyticsConfigurationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-prefix
         */
        void setPrefix(final java.lang.String value);
        /**
         * ``BucketResource.AnalyticsConfigurationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-prefix
         */
        void setPrefix(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.AnalyticsConfigurationProperty.StorageClassAnalysis``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
         */
        java.lang.Object getStorageClassAnalysis();
        /**
         * ``BucketResource.AnalyticsConfigurationProperty.StorageClassAnalysis``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
         */
        void setStorageClassAnalysis(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.AnalyticsConfigurationProperty.StorageClassAnalysis``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
         */
        void setStorageClassAnalysis(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.StorageClassAnalysisProperty value);
        /**
         * ``BucketResource.AnalyticsConfigurationProperty.TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
         */
        java.lang.Object getTagFilters();
        /**
         * ``BucketResource.AnalyticsConfigurationProperty.TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
         */
        void setTagFilters(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.AnalyticsConfigurationProperty.TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
         */
        void setTagFilters(final java.util.List<java.lang.Object> value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link AnalyticsConfigurationProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.AnalyticsConfigurationProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-id
             */
            public StorageClassAnalysisStep withId(final java.lang.String value) {
                return new FullBuilder().withId(value);
            }
            /**
             * ``BucketResource.AnalyticsConfigurationProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-id
             */
            public StorageClassAnalysisStep withId(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withId(value);
            }

            public interface StorageClassAnalysisStep {
                /**
                 * ``BucketResource.AnalyticsConfigurationProperty.StorageClassAnalysis``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
                 */
                Build withStorageClassAnalysis(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.AnalyticsConfigurationProperty.StorageClassAnalysis``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
                 */
                Build withStorageClassAnalysis(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.StorageClassAnalysisProperty value);
            }

            public interface Build {
                /**
                 * @return a new {@link AnalyticsConfigurationProperty} object, initialized with the values set on this builder.
                 */
                AnalyticsConfigurationProperty build();
                /**
                 * ``BucketResource.AnalyticsConfigurationProperty.Prefix``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-prefix
                 */
                Build withPrefix(final java.lang.String value);
                /**
                 * ``BucketResource.AnalyticsConfigurationProperty.Prefix``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-prefix
                 */
                Build withPrefix(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.AnalyticsConfigurationProperty.TagFilters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
                 */
                Build withTagFilters(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.AnalyticsConfigurationProperty.TagFilters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
                 */
                Build withTagFilters(final java.util.List<java.lang.Object> value);
            }

            final class FullBuilder implements StorageClassAnalysisStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.AnalyticsConfigurationProperty.Id``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-id
                 */
                public StorageClassAnalysisStep withId(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "AnalyticsConfigurationProperty#id is required");
                    this.instance._id = value;
                    return this;
                }
                /**
                 * ``BucketResource.AnalyticsConfigurationProperty.Id``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-id
                 */
                public StorageClassAnalysisStep withId(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "AnalyticsConfigurationProperty#id is required");
                    this.instance._id = value;
                    return this;
                }
                /**
                 * ``BucketResource.AnalyticsConfigurationProperty.Prefix``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-prefix
                 */
                public Build withPrefix(final java.lang.String value) {
                    this.instance._prefix = value;
                    return this;
                }
                /**
                 * ``BucketResource.AnalyticsConfigurationProperty.Prefix``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-prefix
                 */
                public Build withPrefix(final software.amazon.awscdk.Token value) {
                    this.instance._prefix = value;
                    return this;
                }
                /**
                 * ``BucketResource.AnalyticsConfigurationProperty.StorageClassAnalysis``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
                 */
                public Build withStorageClassAnalysis(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "AnalyticsConfigurationProperty#storageClassAnalysis is required");
                    this.instance._storageClassAnalysis = value;
                    return this;
                }
                /**
                 * ``BucketResource.AnalyticsConfigurationProperty.StorageClassAnalysis``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
                 */
                public Build withStorageClassAnalysis(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.StorageClassAnalysisProperty value) {
                    java.util.Objects.requireNonNull(value, "AnalyticsConfigurationProperty#storageClassAnalysis is required");
                    this.instance._storageClassAnalysis = value;
                    return this;
                }
                /**
                 * ``BucketResource.AnalyticsConfigurationProperty.TagFilters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
                 */
                public Build withTagFilters(final software.amazon.awscdk.Token value) {
                    this.instance._tagFilters = value;
                    return this;
                }
                /**
                 * ``BucketResource.AnalyticsConfigurationProperty.TagFilters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
                 */
                public Build withTagFilters(final java.util.List<java.lang.Object> value) {
                    this.instance._tagFilters = value;
                    return this;
                }
                public AnalyticsConfigurationProperty build() {
                    AnalyticsConfigurationProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link AnalyticsConfigurationProperty}.
         */
        final class Jsii$Pojo implements AnalyticsConfigurationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _id;

            public java.lang.Object getId() {
                return this._id;
            }
            public void setId(final java.lang.String value) {
                this._id = value;
            }
            public void setId(final software.amazon.awscdk.Token value) {
                this._id = value;
            }

            protected java.lang.Object _prefix;

            public java.lang.Object getPrefix() {
                return this._prefix;
            }
            public void setPrefix(final java.lang.String value) {
                this._prefix = value;
            }
            public void setPrefix(final software.amazon.awscdk.Token value) {
                this._prefix = value;
            }

            protected java.lang.Object _storageClassAnalysis;

            public java.lang.Object getStorageClassAnalysis() {
                return this._storageClassAnalysis;
            }
            public void setStorageClassAnalysis(final software.amazon.awscdk.Token value) {
                this._storageClassAnalysis = value;
            }
            public void setStorageClassAnalysis(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.StorageClassAnalysisProperty value) {
                this._storageClassAnalysis = value;
            }

            protected java.lang.Object _tagFilters;

            public java.lang.Object getTagFilters() {
                return this._tagFilters;
            }
            public void setTagFilters(final software.amazon.awscdk.Token value) {
                this._tagFilters = value;
            }
            public void setTagFilters(final java.util.List<java.lang.Object> value) {
                this._tagFilters = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.AnalyticsConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.AnalyticsConfigurationProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-id
             */
            public java.lang.Object getId() {
                return this.jsiiGet("id", java.lang.Object.class);
            }
            /**
             * ``BucketResource.AnalyticsConfigurationProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-id
             */
            public void setId(final java.lang.String value) {
                this.jsiiSet("id", java.util.Objects.requireNonNull(value, "id is required"));
            }
            /**
             * ``BucketResource.AnalyticsConfigurationProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-id
             */
            public void setId(final software.amazon.awscdk.Token value) {
                this.jsiiSet("id", java.util.Objects.requireNonNull(value, "id is required"));
            }
            /**
             * ``BucketResource.AnalyticsConfigurationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-prefix
             */
            @javax.annotation.Nullable
            public java.lang.Object getPrefix() {
                return this.jsiiGet("prefix", java.lang.Object.class);
            }
            /**
             * ``BucketResource.AnalyticsConfigurationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-prefix
             */
            public void setPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("prefix", value);
            }
            /**
             * ``BucketResource.AnalyticsConfigurationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-prefix
             */
            public void setPrefix(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("prefix", value);
            }
            /**
             * ``BucketResource.AnalyticsConfigurationProperty.StorageClassAnalysis``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
             */
            public java.lang.Object getStorageClassAnalysis() {
                return this.jsiiGet("storageClassAnalysis", java.lang.Object.class);
            }
            /**
             * ``BucketResource.AnalyticsConfigurationProperty.StorageClassAnalysis``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
             */
            public void setStorageClassAnalysis(final software.amazon.awscdk.Token value) {
                this.jsiiSet("storageClassAnalysis", java.util.Objects.requireNonNull(value, "storageClassAnalysis is required"));
            }
            /**
             * ``BucketResource.AnalyticsConfigurationProperty.StorageClassAnalysis``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
             */
            public void setStorageClassAnalysis(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.StorageClassAnalysisProperty value) {
                this.jsiiSet("storageClassAnalysis", java.util.Objects.requireNonNull(value, "storageClassAnalysis is required"));
            }
            /**
             * ``BucketResource.AnalyticsConfigurationProperty.TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
             */
            @javax.annotation.Nullable
            public java.lang.Object getTagFilters() {
                return this.jsiiGet("tagFilters", java.lang.Object.class);
            }
            /**
             * ``BucketResource.AnalyticsConfigurationProperty.TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
             */
            public void setTagFilters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("tagFilters", value);
            }
            /**
             * ``BucketResource.AnalyticsConfigurationProperty.TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
             */
            public void setTagFilters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("tagFilters", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html
     */
    public static interface BucketEncryptionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.BucketEncryptionProperty.ServerSideEncryptionConfiguration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
         */
        java.lang.Object getServerSideEncryptionConfiguration();
        /**
         * ``BucketResource.BucketEncryptionProperty.ServerSideEncryptionConfiguration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
         */
        void setServerSideEncryptionConfiguration(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.BucketEncryptionProperty.ServerSideEncryptionConfiguration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
         */
        void setServerSideEncryptionConfiguration(final java.util.List<java.lang.Object> value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link BucketEncryptionProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.BucketEncryptionProperty.ServerSideEncryptionConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
             */
            public Build withServerSideEncryptionConfiguration(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withServerSideEncryptionConfiguration(value);
            }
            /**
             * ``BucketResource.BucketEncryptionProperty.ServerSideEncryptionConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
             */
            public Build withServerSideEncryptionConfiguration(final java.util.List<java.lang.Object> value) {
                return new FullBuilder().withServerSideEncryptionConfiguration(value);
            }

            public interface Build {
                /**
                 * @return a new {@link BucketEncryptionProperty} object, initialized with the values set on this builder.
                 */
                BucketEncryptionProperty build();
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.BucketEncryptionProperty.ServerSideEncryptionConfiguration``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
                 */
                public Build withServerSideEncryptionConfiguration(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "BucketEncryptionProperty#serverSideEncryptionConfiguration is required");
                    this.instance._serverSideEncryptionConfiguration = value;
                    return this;
                }
                /**
                 * ``BucketResource.BucketEncryptionProperty.ServerSideEncryptionConfiguration``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
                 */
                public Build withServerSideEncryptionConfiguration(final java.util.List<java.lang.Object> value) {
                    java.util.Objects.requireNonNull(value, "BucketEncryptionProperty#serverSideEncryptionConfiguration is required");
                    this.instance._serverSideEncryptionConfiguration = value;
                    return this;
                }
                public BucketEncryptionProperty build() {
                    BucketEncryptionProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link BucketEncryptionProperty}.
         */
        final class Jsii$Pojo implements BucketEncryptionProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _serverSideEncryptionConfiguration;

            public java.lang.Object getServerSideEncryptionConfiguration() {
                return this._serverSideEncryptionConfiguration;
            }
            public void setServerSideEncryptionConfiguration(final software.amazon.awscdk.Token value) {
                this._serverSideEncryptionConfiguration = value;
            }
            public void setServerSideEncryptionConfiguration(final java.util.List<java.lang.Object> value) {
                this._serverSideEncryptionConfiguration = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.BucketEncryptionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.BucketEncryptionProperty.ServerSideEncryptionConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
             */
            public java.lang.Object getServerSideEncryptionConfiguration() {
                return this.jsiiGet("serverSideEncryptionConfiguration", java.lang.Object.class);
            }
            /**
             * ``BucketResource.BucketEncryptionProperty.ServerSideEncryptionConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
             */
            public void setServerSideEncryptionConfiguration(final software.amazon.awscdk.Token value) {
                this.jsiiSet("serverSideEncryptionConfiguration", java.util.Objects.requireNonNull(value, "serverSideEncryptionConfiguration is required"));
            }
            /**
             * ``BucketResource.BucketEncryptionProperty.ServerSideEncryptionConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
             */
            public void setServerSideEncryptionConfiguration(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("serverSideEncryptionConfiguration", java.util.Objects.requireNonNull(value, "serverSideEncryptionConfiguration is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html
     */
    public static interface CorsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.CorsConfigurationProperty.CorsRules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
         */
        java.lang.Object getCorsRules();
        /**
         * ``BucketResource.CorsConfigurationProperty.CorsRules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
         */
        void setCorsRules(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.CorsConfigurationProperty.CorsRules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
         */
        void setCorsRules(final java.util.List<java.lang.Object> value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link CorsConfigurationProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.CorsConfigurationProperty.CorsRules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
             */
            public Build withCorsRules(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withCorsRules(value);
            }
            /**
             * ``BucketResource.CorsConfigurationProperty.CorsRules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
             */
            public Build withCorsRules(final java.util.List<java.lang.Object> value) {
                return new FullBuilder().withCorsRules(value);
            }

            public interface Build {
                /**
                 * @return a new {@link CorsConfigurationProperty} object, initialized with the values set on this builder.
                 */
                CorsConfigurationProperty build();
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.CorsConfigurationProperty.CorsRules``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
                 */
                public Build withCorsRules(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "CorsConfigurationProperty#corsRules is required");
                    this.instance._corsRules = value;
                    return this;
                }
                /**
                 * ``BucketResource.CorsConfigurationProperty.CorsRules``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
                 */
                public Build withCorsRules(final java.util.List<java.lang.Object> value) {
                    java.util.Objects.requireNonNull(value, "CorsConfigurationProperty#corsRules is required");
                    this.instance._corsRules = value;
                    return this;
                }
                public CorsConfigurationProperty build() {
                    CorsConfigurationProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link CorsConfigurationProperty}.
         */
        final class Jsii$Pojo implements CorsConfigurationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _corsRules;

            public java.lang.Object getCorsRules() {
                return this._corsRules;
            }
            public void setCorsRules(final software.amazon.awscdk.Token value) {
                this._corsRules = value;
            }
            public void setCorsRules(final java.util.List<java.lang.Object> value) {
                this._corsRules = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.CorsConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.CorsConfigurationProperty.CorsRules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
             */
            public java.lang.Object getCorsRules() {
                return this.jsiiGet("corsRules", java.lang.Object.class);
            }
            /**
             * ``BucketResource.CorsConfigurationProperty.CorsRules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
             */
            public void setCorsRules(final software.amazon.awscdk.Token value) {
                this.jsiiSet("corsRules", java.util.Objects.requireNonNull(value, "corsRules is required"));
            }
            /**
             * ``BucketResource.CorsConfigurationProperty.CorsRules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
             */
            public void setCorsRules(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("corsRules", java.util.Objects.requireNonNull(value, "corsRules is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html
     */
    public static interface CorsRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.CorsRuleProperty.AllowedHeaders``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
         */
        java.lang.Object getAllowedHeaders();
        /**
         * ``BucketResource.CorsRuleProperty.AllowedHeaders``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
         */
        void setAllowedHeaders(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.CorsRuleProperty.AllowedHeaders``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
         */
        void setAllowedHeaders(final java.util.List<java.lang.Object> value);
        /**
         * ``BucketResource.CorsRuleProperty.AllowedMethods``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
         */
        java.lang.Object getAllowedMethods();
        /**
         * ``BucketResource.CorsRuleProperty.AllowedMethods``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
         */
        void setAllowedMethods(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.CorsRuleProperty.AllowedMethods``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
         */
        void setAllowedMethods(final java.util.List<java.lang.Object> value);
        /**
         * ``BucketResource.CorsRuleProperty.AllowedOrigins``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
         */
        java.lang.Object getAllowedOrigins();
        /**
         * ``BucketResource.CorsRuleProperty.AllowedOrigins``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
         */
        void setAllowedOrigins(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.CorsRuleProperty.AllowedOrigins``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
         */
        void setAllowedOrigins(final java.util.List<java.lang.Object> value);
        /**
         * ``BucketResource.CorsRuleProperty.ExposedHeaders``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
         */
        java.lang.Object getExposedHeaders();
        /**
         * ``BucketResource.CorsRuleProperty.ExposedHeaders``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
         */
        void setExposedHeaders(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.CorsRuleProperty.ExposedHeaders``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
         */
        void setExposedHeaders(final java.util.List<java.lang.Object> value);
        /**
         * ``BucketResource.CorsRuleProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-id
         */
        java.lang.Object getId();
        /**
         * ``BucketResource.CorsRuleProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-id
         */
        void setId(final java.lang.String value);
        /**
         * ``BucketResource.CorsRuleProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-id
         */
        void setId(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.CorsRuleProperty.MaxAge``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
         */
        java.lang.Object getMaxAge();
        /**
         * ``BucketResource.CorsRuleProperty.MaxAge``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
         */
        void setMaxAge(final java.lang.Number value);
        /**
         * ``BucketResource.CorsRuleProperty.MaxAge``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
         */
        void setMaxAge(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link CorsRuleProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.CorsRuleProperty.AllowedMethods``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
             */
            public AllowedOriginsStep withAllowedMethods(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withAllowedMethods(value);
            }
            /**
             * ``BucketResource.CorsRuleProperty.AllowedMethods``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
             */
            public AllowedOriginsStep withAllowedMethods(final java.util.List<java.lang.Object> value) {
                return new FullBuilder().withAllowedMethods(value);
            }

            public interface AllowedOriginsStep {
                /**
                 * ``BucketResource.CorsRuleProperty.AllowedOrigins``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
                 */
                Build withAllowedOrigins(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.CorsRuleProperty.AllowedOrigins``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
                 */
                Build withAllowedOrigins(final java.util.List<java.lang.Object> value);
            }

            public interface Build {
                /**
                 * @return a new {@link CorsRuleProperty} object, initialized with the values set on this builder.
                 */
                CorsRuleProperty build();
                /**
                 * ``BucketResource.CorsRuleProperty.AllowedHeaders``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
                 */
                Build withAllowedHeaders(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.CorsRuleProperty.AllowedHeaders``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
                 */
                Build withAllowedHeaders(final java.util.List<java.lang.Object> value);
                /**
                 * ``BucketResource.CorsRuleProperty.ExposedHeaders``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
                 */
                Build withExposedHeaders(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.CorsRuleProperty.ExposedHeaders``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
                 */
                Build withExposedHeaders(final java.util.List<java.lang.Object> value);
                /**
                 * ``BucketResource.CorsRuleProperty.Id``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-id
                 */
                Build withId(final java.lang.String value);
                /**
                 * ``BucketResource.CorsRuleProperty.Id``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-id
                 */
                Build withId(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.CorsRuleProperty.MaxAge``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
                 */
                Build withMaxAge(final java.lang.Number value);
                /**
                 * ``BucketResource.CorsRuleProperty.MaxAge``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
                 */
                Build withMaxAge(final software.amazon.awscdk.Token value);
            }

            final class FullBuilder implements AllowedOriginsStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.CorsRuleProperty.AllowedHeaders``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
                 */
                public Build withAllowedHeaders(final software.amazon.awscdk.Token value) {
                    this.instance._allowedHeaders = value;
                    return this;
                }
                /**
                 * ``BucketResource.CorsRuleProperty.AllowedHeaders``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
                 */
                public Build withAllowedHeaders(final java.util.List<java.lang.Object> value) {
                    this.instance._allowedHeaders = value;
                    return this;
                }
                /**
                 * ``BucketResource.CorsRuleProperty.AllowedMethods``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
                 */
                public AllowedOriginsStep withAllowedMethods(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "CorsRuleProperty#allowedMethods is required");
                    this.instance._allowedMethods = value;
                    return this;
                }
                /**
                 * ``BucketResource.CorsRuleProperty.AllowedMethods``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
                 */
                public AllowedOriginsStep withAllowedMethods(final java.util.List<java.lang.Object> value) {
                    java.util.Objects.requireNonNull(value, "CorsRuleProperty#allowedMethods is required");
                    this.instance._allowedMethods = value;
                    return this;
                }
                /**
                 * ``BucketResource.CorsRuleProperty.AllowedOrigins``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
                 */
                public Build withAllowedOrigins(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "CorsRuleProperty#allowedOrigins is required");
                    this.instance._allowedOrigins = value;
                    return this;
                }
                /**
                 * ``BucketResource.CorsRuleProperty.AllowedOrigins``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
                 */
                public Build withAllowedOrigins(final java.util.List<java.lang.Object> value) {
                    java.util.Objects.requireNonNull(value, "CorsRuleProperty#allowedOrigins is required");
                    this.instance._allowedOrigins = value;
                    return this;
                }
                /**
                 * ``BucketResource.CorsRuleProperty.ExposedHeaders``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
                 */
                public Build withExposedHeaders(final software.amazon.awscdk.Token value) {
                    this.instance._exposedHeaders = value;
                    return this;
                }
                /**
                 * ``BucketResource.CorsRuleProperty.ExposedHeaders``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
                 */
                public Build withExposedHeaders(final java.util.List<java.lang.Object> value) {
                    this.instance._exposedHeaders = value;
                    return this;
                }
                /**
                 * ``BucketResource.CorsRuleProperty.Id``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-id
                 */
                public Build withId(final java.lang.String value) {
                    this.instance._id = value;
                    return this;
                }
                /**
                 * ``BucketResource.CorsRuleProperty.Id``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-id
                 */
                public Build withId(final software.amazon.awscdk.Token value) {
                    this.instance._id = value;
                    return this;
                }
                /**
                 * ``BucketResource.CorsRuleProperty.MaxAge``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
                 */
                public Build withMaxAge(final java.lang.Number value) {
                    this.instance._maxAge = value;
                    return this;
                }
                /**
                 * ``BucketResource.CorsRuleProperty.MaxAge``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
                 */
                public Build withMaxAge(final software.amazon.awscdk.Token value) {
                    this.instance._maxAge = value;
                    return this;
                }
                public CorsRuleProperty build() {
                    CorsRuleProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link CorsRuleProperty}.
         */
        final class Jsii$Pojo implements CorsRuleProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _allowedHeaders;

            public java.lang.Object getAllowedHeaders() {
                return this._allowedHeaders;
            }
            public void setAllowedHeaders(final software.amazon.awscdk.Token value) {
                this._allowedHeaders = value;
            }
            public void setAllowedHeaders(final java.util.List<java.lang.Object> value) {
                this._allowedHeaders = value;
            }

            protected java.lang.Object _allowedMethods;

            public java.lang.Object getAllowedMethods() {
                return this._allowedMethods;
            }
            public void setAllowedMethods(final software.amazon.awscdk.Token value) {
                this._allowedMethods = value;
            }
            public void setAllowedMethods(final java.util.List<java.lang.Object> value) {
                this._allowedMethods = value;
            }

            protected java.lang.Object _allowedOrigins;

            public java.lang.Object getAllowedOrigins() {
                return this._allowedOrigins;
            }
            public void setAllowedOrigins(final software.amazon.awscdk.Token value) {
                this._allowedOrigins = value;
            }
            public void setAllowedOrigins(final java.util.List<java.lang.Object> value) {
                this._allowedOrigins = value;
            }

            protected java.lang.Object _exposedHeaders;

            public java.lang.Object getExposedHeaders() {
                return this._exposedHeaders;
            }
            public void setExposedHeaders(final software.amazon.awscdk.Token value) {
                this._exposedHeaders = value;
            }
            public void setExposedHeaders(final java.util.List<java.lang.Object> value) {
                this._exposedHeaders = value;
            }

            protected java.lang.Object _id;

            public java.lang.Object getId() {
                return this._id;
            }
            public void setId(final java.lang.String value) {
                this._id = value;
            }
            public void setId(final software.amazon.awscdk.Token value) {
                this._id = value;
            }

            protected java.lang.Object _maxAge;

            public java.lang.Object getMaxAge() {
                return this._maxAge;
            }
            public void setMaxAge(final java.lang.Number value) {
                this._maxAge = value;
            }
            public void setMaxAge(final software.amazon.awscdk.Token value) {
                this._maxAge = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.CorsRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.CorsRuleProperty.AllowedHeaders``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
             */
            @javax.annotation.Nullable
            public java.lang.Object getAllowedHeaders() {
                return this.jsiiGet("allowedHeaders", java.lang.Object.class);
            }
            /**
             * ``BucketResource.CorsRuleProperty.AllowedHeaders``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
             */
            public void setAllowedHeaders(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("allowedHeaders", value);
            }
            /**
             * ``BucketResource.CorsRuleProperty.AllowedHeaders``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
             */
            public void setAllowedHeaders(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("allowedHeaders", value);
            }
            /**
             * ``BucketResource.CorsRuleProperty.AllowedMethods``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
             */
            public java.lang.Object getAllowedMethods() {
                return this.jsiiGet("allowedMethods", java.lang.Object.class);
            }
            /**
             * ``BucketResource.CorsRuleProperty.AllowedMethods``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
             */
            public void setAllowedMethods(final software.amazon.awscdk.Token value) {
                this.jsiiSet("allowedMethods", java.util.Objects.requireNonNull(value, "allowedMethods is required"));
            }
            /**
             * ``BucketResource.CorsRuleProperty.AllowedMethods``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
             */
            public void setAllowedMethods(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("allowedMethods", java.util.Objects.requireNonNull(value, "allowedMethods is required"));
            }
            /**
             * ``BucketResource.CorsRuleProperty.AllowedOrigins``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
             */
            public java.lang.Object getAllowedOrigins() {
                return this.jsiiGet("allowedOrigins", java.lang.Object.class);
            }
            /**
             * ``BucketResource.CorsRuleProperty.AllowedOrigins``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
             */
            public void setAllowedOrigins(final software.amazon.awscdk.Token value) {
                this.jsiiSet("allowedOrigins", java.util.Objects.requireNonNull(value, "allowedOrigins is required"));
            }
            /**
             * ``BucketResource.CorsRuleProperty.AllowedOrigins``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
             */
            public void setAllowedOrigins(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("allowedOrigins", java.util.Objects.requireNonNull(value, "allowedOrigins is required"));
            }
            /**
             * ``BucketResource.CorsRuleProperty.ExposedHeaders``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
             */
            @javax.annotation.Nullable
            public java.lang.Object getExposedHeaders() {
                return this.jsiiGet("exposedHeaders", java.lang.Object.class);
            }
            /**
             * ``BucketResource.CorsRuleProperty.ExposedHeaders``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
             */
            public void setExposedHeaders(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("exposedHeaders", value);
            }
            /**
             * ``BucketResource.CorsRuleProperty.ExposedHeaders``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
             */
            public void setExposedHeaders(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("exposedHeaders", value);
            }
            /**
             * ``BucketResource.CorsRuleProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-id
             */
            @javax.annotation.Nullable
            public java.lang.Object getId() {
                return this.jsiiGet("id", java.lang.Object.class);
            }
            /**
             * ``BucketResource.CorsRuleProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-id
             */
            public void setId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("id", value);
            }
            /**
             * ``BucketResource.CorsRuleProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-id
             */
            public void setId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("id", value);
            }
            /**
             * ``BucketResource.CorsRuleProperty.MaxAge``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
             */
            @javax.annotation.Nullable
            public java.lang.Object getMaxAge() {
                return this.jsiiGet("maxAge", java.lang.Object.class);
            }
            /**
             * ``BucketResource.CorsRuleProperty.MaxAge``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
             */
            public void setMaxAge(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("maxAge", value);
            }
            /**
             * ``BucketResource.CorsRuleProperty.MaxAge``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
             */
            public void setMaxAge(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("maxAge", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html
     */
    public static interface DataExportProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.DataExportProperty.Destination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
         */
        java.lang.Object getDestination();
        /**
         * ``BucketResource.DataExportProperty.Destination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
         */
        void setDestination(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.DataExportProperty.Destination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
         */
        void setDestination(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.DestinationProperty value);
        /**
         * ``BucketResource.DataExportProperty.OutputSchemaVersion``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-outputschemaversion
         */
        java.lang.Object getOutputSchemaVersion();
        /**
         * ``BucketResource.DataExportProperty.OutputSchemaVersion``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-outputschemaversion
         */
        void setOutputSchemaVersion(final java.lang.String value);
        /**
         * ``BucketResource.DataExportProperty.OutputSchemaVersion``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-outputschemaversion
         */
        void setOutputSchemaVersion(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link DataExportProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.DataExportProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
             */
            public OutputSchemaVersionStep withDestination(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withDestination(value);
            }
            /**
             * ``BucketResource.DataExportProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
             */
            public OutputSchemaVersionStep withDestination(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.DestinationProperty value) {
                return new FullBuilder().withDestination(value);
            }

            public interface OutputSchemaVersionStep {
                /**
                 * ``BucketResource.DataExportProperty.OutputSchemaVersion``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-outputschemaversion
                 */
                Build withOutputSchemaVersion(final java.lang.String value);
                /**
                 * ``BucketResource.DataExportProperty.OutputSchemaVersion``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-outputschemaversion
                 */
                Build withOutputSchemaVersion(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link DataExportProperty} object, initialized with the values set on this builder.
                 */
                DataExportProperty build();
            }

            final class FullBuilder implements OutputSchemaVersionStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.DataExportProperty.Destination``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
                 */
                public OutputSchemaVersionStep withDestination(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "DataExportProperty#destination is required");
                    this.instance._destination = value;
                    return this;
                }
                /**
                 * ``BucketResource.DataExportProperty.Destination``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
                 */
                public OutputSchemaVersionStep withDestination(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.DestinationProperty value) {
                    java.util.Objects.requireNonNull(value, "DataExportProperty#destination is required");
                    this.instance._destination = value;
                    return this;
                }
                /**
                 * ``BucketResource.DataExportProperty.OutputSchemaVersion``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-outputschemaversion
                 */
                public Build withOutputSchemaVersion(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "DataExportProperty#outputSchemaVersion is required");
                    this.instance._outputSchemaVersion = value;
                    return this;
                }
                /**
                 * ``BucketResource.DataExportProperty.OutputSchemaVersion``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-outputschemaversion
                 */
                public Build withOutputSchemaVersion(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "DataExportProperty#outputSchemaVersion is required");
                    this.instance._outputSchemaVersion = value;
                    return this;
                }
                public DataExportProperty build() {
                    DataExportProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link DataExportProperty}.
         */
        final class Jsii$Pojo implements DataExportProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _destination;

            public java.lang.Object getDestination() {
                return this._destination;
            }
            public void setDestination(final software.amazon.awscdk.Token value) {
                this._destination = value;
            }
            public void setDestination(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.DestinationProperty value) {
                this._destination = value;
            }

            protected java.lang.Object _outputSchemaVersion;

            public java.lang.Object getOutputSchemaVersion() {
                return this._outputSchemaVersion;
            }
            public void setOutputSchemaVersion(final java.lang.String value) {
                this._outputSchemaVersion = value;
            }
            public void setOutputSchemaVersion(final software.amazon.awscdk.Token value) {
                this._outputSchemaVersion = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.DataExportProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.DataExportProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
             */
            public java.lang.Object getDestination() {
                return this.jsiiGet("destination", java.lang.Object.class);
            }
            /**
             * ``BucketResource.DataExportProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
             */
            public void setDestination(final software.amazon.awscdk.Token value) {
                this.jsiiSet("destination", java.util.Objects.requireNonNull(value, "destination is required"));
            }
            /**
             * ``BucketResource.DataExportProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
             */
            public void setDestination(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.DestinationProperty value) {
                this.jsiiSet("destination", java.util.Objects.requireNonNull(value, "destination is required"));
            }
            /**
             * ``BucketResource.DataExportProperty.OutputSchemaVersion``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-outputschemaversion
             */
            public java.lang.Object getOutputSchemaVersion() {
                return this.jsiiGet("outputSchemaVersion", java.lang.Object.class);
            }
            /**
             * ``BucketResource.DataExportProperty.OutputSchemaVersion``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-outputschemaversion
             */
            public void setOutputSchemaVersion(final java.lang.String value) {
                this.jsiiSet("outputSchemaVersion", java.util.Objects.requireNonNull(value, "outputSchemaVersion is required"));
            }
            /**
             * ``BucketResource.DataExportProperty.OutputSchemaVersion``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-outputschemaversion
             */
            public void setOutputSchemaVersion(final software.amazon.awscdk.Token value) {
                this.jsiiSet("outputSchemaVersion", java.util.Objects.requireNonNull(value, "outputSchemaVersion is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html
     */
    public static interface DestinationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.DestinationProperty.BucketAccountId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketaccountid
         */
        java.lang.Object getBucketAccountId();
        /**
         * ``BucketResource.DestinationProperty.BucketAccountId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketaccountid
         */
        void setBucketAccountId(final java.lang.String value);
        /**
         * ``BucketResource.DestinationProperty.BucketAccountId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketaccountid
         */
        void setBucketAccountId(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.DestinationProperty.BucketArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketarn
         */
        java.lang.Object getBucketArn();
        /**
         * ``BucketResource.DestinationProperty.BucketArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketarn
         */
        void setBucketArn(final java.lang.String value);
        /**
         * ``BucketResource.DestinationProperty.BucketArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketarn
         */
        void setBucketArn(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.DestinationProperty.Format``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-format
         */
        java.lang.Object getFormat();
        /**
         * ``BucketResource.DestinationProperty.Format``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-format
         */
        void setFormat(final java.lang.String value);
        /**
         * ``BucketResource.DestinationProperty.Format``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-format
         */
        void setFormat(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.DestinationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-prefix
         */
        java.lang.Object getPrefix();
        /**
         * ``BucketResource.DestinationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-prefix
         */
        void setPrefix(final java.lang.String value);
        /**
         * ``BucketResource.DestinationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-prefix
         */
        void setPrefix(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link DestinationProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.DestinationProperty.BucketArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketarn
             */
            public FormatStep withBucketArn(final java.lang.String value) {
                return new FullBuilder().withBucketArn(value);
            }
            /**
             * ``BucketResource.DestinationProperty.BucketArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketarn
             */
            public FormatStep withBucketArn(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withBucketArn(value);
            }

            public interface FormatStep {
                /**
                 * ``BucketResource.DestinationProperty.Format``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-format
                 */
                Build withFormat(final java.lang.String value);
                /**
                 * ``BucketResource.DestinationProperty.Format``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-format
                 */
                Build withFormat(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link DestinationProperty} object, initialized with the values set on this builder.
                 */
                DestinationProperty build();
                /**
                 * ``BucketResource.DestinationProperty.BucketAccountId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketaccountid
                 */
                Build withBucketAccountId(final java.lang.String value);
                /**
                 * ``BucketResource.DestinationProperty.BucketAccountId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketaccountid
                 */
                Build withBucketAccountId(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.DestinationProperty.Prefix``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-prefix
                 */
                Build withPrefix(final java.lang.String value);
                /**
                 * ``BucketResource.DestinationProperty.Prefix``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-prefix
                 */
                Build withPrefix(final software.amazon.awscdk.Token value);
            }

            final class FullBuilder implements FormatStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.DestinationProperty.BucketAccountId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketaccountid
                 */
                public Build withBucketAccountId(final java.lang.String value) {
                    this.instance._bucketAccountId = value;
                    return this;
                }
                /**
                 * ``BucketResource.DestinationProperty.BucketAccountId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketaccountid
                 */
                public Build withBucketAccountId(final software.amazon.awscdk.Token value) {
                    this.instance._bucketAccountId = value;
                    return this;
                }
                /**
                 * ``BucketResource.DestinationProperty.BucketArn``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketarn
                 */
                public FormatStep withBucketArn(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "DestinationProperty#bucketArn is required");
                    this.instance._bucketArn = value;
                    return this;
                }
                /**
                 * ``BucketResource.DestinationProperty.BucketArn``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketarn
                 */
                public FormatStep withBucketArn(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "DestinationProperty#bucketArn is required");
                    this.instance._bucketArn = value;
                    return this;
                }
                /**
                 * ``BucketResource.DestinationProperty.Format``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-format
                 */
                public Build withFormat(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "DestinationProperty#format is required");
                    this.instance._format = value;
                    return this;
                }
                /**
                 * ``BucketResource.DestinationProperty.Format``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-format
                 */
                public Build withFormat(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "DestinationProperty#format is required");
                    this.instance._format = value;
                    return this;
                }
                /**
                 * ``BucketResource.DestinationProperty.Prefix``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-prefix
                 */
                public Build withPrefix(final java.lang.String value) {
                    this.instance._prefix = value;
                    return this;
                }
                /**
                 * ``BucketResource.DestinationProperty.Prefix``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-prefix
                 */
                public Build withPrefix(final software.amazon.awscdk.Token value) {
                    this.instance._prefix = value;
                    return this;
                }
                public DestinationProperty build() {
                    DestinationProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link DestinationProperty}.
         */
        final class Jsii$Pojo implements DestinationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _bucketAccountId;

            public java.lang.Object getBucketAccountId() {
                return this._bucketAccountId;
            }
            public void setBucketAccountId(final java.lang.String value) {
                this._bucketAccountId = value;
            }
            public void setBucketAccountId(final software.amazon.awscdk.Token value) {
                this._bucketAccountId = value;
            }

            protected java.lang.Object _bucketArn;

            public java.lang.Object getBucketArn() {
                return this._bucketArn;
            }
            public void setBucketArn(final java.lang.String value) {
                this._bucketArn = value;
            }
            public void setBucketArn(final software.amazon.awscdk.Token value) {
                this._bucketArn = value;
            }

            protected java.lang.Object _format;

            public java.lang.Object getFormat() {
                return this._format;
            }
            public void setFormat(final java.lang.String value) {
                this._format = value;
            }
            public void setFormat(final software.amazon.awscdk.Token value) {
                this._format = value;
            }

            protected java.lang.Object _prefix;

            public java.lang.Object getPrefix() {
                return this._prefix;
            }
            public void setPrefix(final java.lang.String value) {
                this._prefix = value;
            }
            public void setPrefix(final software.amazon.awscdk.Token value) {
                this._prefix = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.DestinationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.DestinationProperty.BucketAccountId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketaccountid
             */
            @javax.annotation.Nullable
            public java.lang.Object getBucketAccountId() {
                return this.jsiiGet("bucketAccountId", java.lang.Object.class);
            }
            /**
             * ``BucketResource.DestinationProperty.BucketAccountId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketaccountid
             */
            public void setBucketAccountId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("bucketAccountId", value);
            }
            /**
             * ``BucketResource.DestinationProperty.BucketAccountId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketaccountid
             */
            public void setBucketAccountId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("bucketAccountId", value);
            }
            /**
             * ``BucketResource.DestinationProperty.BucketArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketarn
             */
            public java.lang.Object getBucketArn() {
                return this.jsiiGet("bucketArn", java.lang.Object.class);
            }
            /**
             * ``BucketResource.DestinationProperty.BucketArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketarn
             */
            public void setBucketArn(final java.lang.String value) {
                this.jsiiSet("bucketArn", java.util.Objects.requireNonNull(value, "bucketArn is required"));
            }
            /**
             * ``BucketResource.DestinationProperty.BucketArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketarn
             */
            public void setBucketArn(final software.amazon.awscdk.Token value) {
                this.jsiiSet("bucketArn", java.util.Objects.requireNonNull(value, "bucketArn is required"));
            }
            /**
             * ``BucketResource.DestinationProperty.Format``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-format
             */
            public java.lang.Object getFormat() {
                return this.jsiiGet("format", java.lang.Object.class);
            }
            /**
             * ``BucketResource.DestinationProperty.Format``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-format
             */
            public void setFormat(final java.lang.String value) {
                this.jsiiSet("format", java.util.Objects.requireNonNull(value, "format is required"));
            }
            /**
             * ``BucketResource.DestinationProperty.Format``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-format
             */
            public void setFormat(final software.amazon.awscdk.Token value) {
                this.jsiiSet("format", java.util.Objects.requireNonNull(value, "format is required"));
            }
            /**
             * ``BucketResource.DestinationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-prefix
             */
            @javax.annotation.Nullable
            public java.lang.Object getPrefix() {
                return this.jsiiGet("prefix", java.lang.Object.class);
            }
            /**
             * ``BucketResource.DestinationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-prefix
             */
            public void setPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("prefix", value);
            }
            /**
             * ``BucketResource.DestinationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-prefix
             */
            public void setPrefix(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("prefix", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html
     */
    public static interface EncryptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.EncryptionConfigurationProperty.ReplicaKmsKeyID``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html#cfn-s3-bucket-encryptionconfiguration-replicakmskeyid
         */
        java.lang.Object getReplicaKmsKeyId();
        /**
         * ``BucketResource.EncryptionConfigurationProperty.ReplicaKmsKeyID``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html#cfn-s3-bucket-encryptionconfiguration-replicakmskeyid
         */
        void setReplicaKmsKeyId(final java.lang.String value);
        /**
         * ``BucketResource.EncryptionConfigurationProperty.ReplicaKmsKeyID``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html#cfn-s3-bucket-encryptionconfiguration-replicakmskeyid
         */
        void setReplicaKmsKeyId(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link EncryptionConfigurationProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.EncryptionConfigurationProperty.ReplicaKmsKeyID``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html#cfn-s3-bucket-encryptionconfiguration-replicakmskeyid
             */
            public Build withReplicaKmsKeyId(final java.lang.String value) {
                return new FullBuilder().withReplicaKmsKeyId(value);
            }
            /**
             * ``BucketResource.EncryptionConfigurationProperty.ReplicaKmsKeyID``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html#cfn-s3-bucket-encryptionconfiguration-replicakmskeyid
             */
            public Build withReplicaKmsKeyId(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withReplicaKmsKeyId(value);
            }

            public interface Build {
                /**
                 * @return a new {@link EncryptionConfigurationProperty} object, initialized with the values set on this builder.
                 */
                EncryptionConfigurationProperty build();
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.EncryptionConfigurationProperty.ReplicaKmsKeyID``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html#cfn-s3-bucket-encryptionconfiguration-replicakmskeyid
                 */
                public Build withReplicaKmsKeyId(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "EncryptionConfigurationProperty#replicaKmsKeyId is required");
                    this.instance._replicaKmsKeyId = value;
                    return this;
                }
                /**
                 * ``BucketResource.EncryptionConfigurationProperty.ReplicaKmsKeyID``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html#cfn-s3-bucket-encryptionconfiguration-replicakmskeyid
                 */
                public Build withReplicaKmsKeyId(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "EncryptionConfigurationProperty#replicaKmsKeyId is required");
                    this.instance._replicaKmsKeyId = value;
                    return this;
                }
                public EncryptionConfigurationProperty build() {
                    EncryptionConfigurationProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link EncryptionConfigurationProperty}.
         */
        final class Jsii$Pojo implements EncryptionConfigurationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _replicaKmsKeyId;

            public java.lang.Object getReplicaKmsKeyId() {
                return this._replicaKmsKeyId;
            }
            public void setReplicaKmsKeyId(final java.lang.String value) {
                this._replicaKmsKeyId = value;
            }
            public void setReplicaKmsKeyId(final software.amazon.awscdk.Token value) {
                this._replicaKmsKeyId = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.EncryptionConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.EncryptionConfigurationProperty.ReplicaKmsKeyID``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html#cfn-s3-bucket-encryptionconfiguration-replicakmskeyid
             */
            public java.lang.Object getReplicaKmsKeyId() {
                return this.jsiiGet("replicaKmsKeyId", java.lang.Object.class);
            }
            /**
             * ``BucketResource.EncryptionConfigurationProperty.ReplicaKmsKeyID``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html#cfn-s3-bucket-encryptionconfiguration-replicakmskeyid
             */
            public void setReplicaKmsKeyId(final java.lang.String value) {
                this.jsiiSet("replicaKmsKeyId", java.util.Objects.requireNonNull(value, "replicaKmsKeyId is required"));
            }
            /**
             * ``BucketResource.EncryptionConfigurationProperty.ReplicaKmsKeyID``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html#cfn-s3-bucket-encryptionconfiguration-replicakmskeyid
             */
            public void setReplicaKmsKeyId(final software.amazon.awscdk.Token value) {
                this.jsiiSet("replicaKmsKeyId", java.util.Objects.requireNonNull(value, "replicaKmsKeyId is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html
     */
    public static interface FilterRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.FilterRuleProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-name
         */
        java.lang.Object getName();
        /**
         * ``BucketResource.FilterRuleProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-name
         */
        void setName(final java.lang.String value);
        /**
         * ``BucketResource.FilterRuleProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-name
         */
        void setName(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.FilterRuleProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-value
         */
        java.lang.Object getValue();
        /**
         * ``BucketResource.FilterRuleProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-value
         */
        void setValue(final java.lang.String value);
        /**
         * ``BucketResource.FilterRuleProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-value
         */
        void setValue(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link FilterRuleProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.FilterRuleProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-name
             */
            public ValueStep withName(final java.lang.String value) {
                return new FullBuilder().withName(value);
            }
            /**
             * ``BucketResource.FilterRuleProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-name
             */
            public ValueStep withName(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withName(value);
            }

            public interface ValueStep {
                /**
                 * ``BucketResource.FilterRuleProperty.Value``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-value
                 */
                Build withValue(final java.lang.String value);
                /**
                 * ``BucketResource.FilterRuleProperty.Value``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-value
                 */
                Build withValue(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link FilterRuleProperty} object, initialized with the values set on this builder.
                 */
                FilterRuleProperty build();
            }

            final class FullBuilder implements ValueStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.FilterRuleProperty.Name``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-name
                 */
                public ValueStep withName(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "FilterRuleProperty#name is required");
                    this.instance._name = value;
                    return this;
                }
                /**
                 * ``BucketResource.FilterRuleProperty.Name``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-name
                 */
                public ValueStep withName(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "FilterRuleProperty#name is required");
                    this.instance._name = value;
                    return this;
                }
                /**
                 * ``BucketResource.FilterRuleProperty.Value``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-value
                 */
                public Build withValue(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "FilterRuleProperty#value is required");
                    this.instance._value = value;
                    return this;
                }
                /**
                 * ``BucketResource.FilterRuleProperty.Value``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-value
                 */
                public Build withValue(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "FilterRuleProperty#value is required");
                    this.instance._value = value;
                    return this;
                }
                public FilterRuleProperty build() {
                    FilterRuleProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link FilterRuleProperty}.
         */
        final class Jsii$Pojo implements FilterRuleProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _name;

            public java.lang.Object getName() {
                return this._name;
            }
            public void setName(final java.lang.String value) {
                this._name = value;
            }
            public void setName(final software.amazon.awscdk.Token value) {
                this._name = value;
            }

            protected java.lang.Object _value;

            public java.lang.Object getValue() {
                return this._value;
            }
            public void setValue(final java.lang.String value) {
                this._value = value;
            }
            public void setValue(final software.amazon.awscdk.Token value) {
                this._value = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.FilterRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.FilterRuleProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-name
             */
            public java.lang.Object getName() {
                return this.jsiiGet("name", java.lang.Object.class);
            }
            /**
             * ``BucketResource.FilterRuleProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-name
             */
            public void setName(final java.lang.String value) {
                this.jsiiSet("name", java.util.Objects.requireNonNull(value, "name is required"));
            }
            /**
             * ``BucketResource.FilterRuleProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-name
             */
            public void setName(final software.amazon.awscdk.Token value) {
                this.jsiiSet("name", java.util.Objects.requireNonNull(value, "name is required"));
            }
            /**
             * ``BucketResource.FilterRuleProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-value
             */
            public java.lang.Object getValue() {
                return this.jsiiGet("value", java.lang.Object.class);
            }
            /**
             * ``BucketResource.FilterRuleProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-value
             */
            public void setValue(final java.lang.String value) {
                this.jsiiSet("value", java.util.Objects.requireNonNull(value, "value is required"));
            }
            /**
             * ``BucketResource.FilterRuleProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-value
             */
            public void setValue(final software.amazon.awscdk.Token value) {
                this.jsiiSet("value", java.util.Objects.requireNonNull(value, "value is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html
     */
    public static interface InventoryConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.InventoryConfigurationProperty.Destination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
         */
        java.lang.Object getDestination();
        /**
         * ``BucketResource.InventoryConfigurationProperty.Destination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
         */
        void setDestination(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.InventoryConfigurationProperty.Destination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
         */
        void setDestination(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.DestinationProperty value);
        /**
         * ``BucketResource.InventoryConfigurationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
         */
        java.lang.Object getEnabled();
        /**
         * ``BucketResource.InventoryConfigurationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
         */
        void setEnabled(final java.lang.Boolean value);
        /**
         * ``BucketResource.InventoryConfigurationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
         */
        void setEnabled(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.InventoryConfigurationProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-id
         */
        java.lang.Object getId();
        /**
         * ``BucketResource.InventoryConfigurationProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-id
         */
        void setId(final java.lang.String value);
        /**
         * ``BucketResource.InventoryConfigurationProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-id
         */
        void setId(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.InventoryConfigurationProperty.IncludedObjectVersions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-includedobjectversions
         */
        java.lang.Object getIncludedObjectVersions();
        /**
         * ``BucketResource.InventoryConfigurationProperty.IncludedObjectVersions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-includedobjectversions
         */
        void setIncludedObjectVersions(final java.lang.String value);
        /**
         * ``BucketResource.InventoryConfigurationProperty.IncludedObjectVersions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-includedobjectversions
         */
        void setIncludedObjectVersions(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.InventoryConfigurationProperty.OptionalFields``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
         */
        java.lang.Object getOptionalFields();
        /**
         * ``BucketResource.InventoryConfigurationProperty.OptionalFields``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
         */
        void setOptionalFields(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.InventoryConfigurationProperty.OptionalFields``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
         */
        void setOptionalFields(final java.util.List<java.lang.Object> value);
        /**
         * ``BucketResource.InventoryConfigurationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-prefix
         */
        java.lang.Object getPrefix();
        /**
         * ``BucketResource.InventoryConfigurationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-prefix
         */
        void setPrefix(final java.lang.String value);
        /**
         * ``BucketResource.InventoryConfigurationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-prefix
         */
        void setPrefix(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.InventoryConfigurationProperty.ScheduleFrequency``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-schedulefrequency
         */
        java.lang.Object getScheduleFrequency();
        /**
         * ``BucketResource.InventoryConfigurationProperty.ScheduleFrequency``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-schedulefrequency
         */
        void setScheduleFrequency(final java.lang.String value);
        /**
         * ``BucketResource.InventoryConfigurationProperty.ScheduleFrequency``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-schedulefrequency
         */
        void setScheduleFrequency(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link InventoryConfigurationProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.InventoryConfigurationProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
             */
            public EnabledStep withDestination(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withDestination(value);
            }
            /**
             * ``BucketResource.InventoryConfigurationProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
             */
            public EnabledStep withDestination(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.DestinationProperty value) {
                return new FullBuilder().withDestination(value);
            }

            public interface EnabledStep {
                /**
                 * ``BucketResource.InventoryConfigurationProperty.Enabled``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
                 */
                IdStep withEnabled(final java.lang.Boolean value);
                /**
                 * ``BucketResource.InventoryConfigurationProperty.Enabled``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
                 */
                IdStep withEnabled(final software.amazon.awscdk.Token value);
            }

            public interface IdStep {
                /**
                 * ``BucketResource.InventoryConfigurationProperty.Id``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-id
                 */
                IncludedObjectVersionsStep withId(final java.lang.String value);
                /**
                 * ``BucketResource.InventoryConfigurationProperty.Id``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-id
                 */
                IncludedObjectVersionsStep withId(final software.amazon.awscdk.Token value);
            }

            public interface IncludedObjectVersionsStep {
                /**
                 * ``BucketResource.InventoryConfigurationProperty.IncludedObjectVersions``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-includedobjectversions
                 */
                ScheduleFrequencyStep withIncludedObjectVersions(final java.lang.String value);
                /**
                 * ``BucketResource.InventoryConfigurationProperty.IncludedObjectVersions``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-includedobjectversions
                 */
                ScheduleFrequencyStep withIncludedObjectVersions(final software.amazon.awscdk.Token value);
            }

            public interface ScheduleFrequencyStep {
                /**
                 * ``BucketResource.InventoryConfigurationProperty.ScheduleFrequency``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-schedulefrequency
                 */
                Build withScheduleFrequency(final java.lang.String value);
                /**
                 * ``BucketResource.InventoryConfigurationProperty.ScheduleFrequency``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-schedulefrequency
                 */
                Build withScheduleFrequency(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link InventoryConfigurationProperty} object, initialized with the values set on this builder.
                 */
                InventoryConfigurationProperty build();
                /**
                 * ``BucketResource.InventoryConfigurationProperty.OptionalFields``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
                 */
                Build withOptionalFields(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.InventoryConfigurationProperty.OptionalFields``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
                 */
                Build withOptionalFields(final java.util.List<java.lang.Object> value);
                /**
                 * ``BucketResource.InventoryConfigurationProperty.Prefix``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-prefix
                 */
                Build withPrefix(final java.lang.String value);
                /**
                 * ``BucketResource.InventoryConfigurationProperty.Prefix``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-prefix
                 */
                Build withPrefix(final software.amazon.awscdk.Token value);
            }

            final class FullBuilder implements EnabledStep, IdStep, IncludedObjectVersionsStep, ScheduleFrequencyStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.InventoryConfigurationProperty.Destination``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
                 */
                public EnabledStep withDestination(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "InventoryConfigurationProperty#destination is required");
                    this.instance._destination = value;
                    return this;
                }
                /**
                 * ``BucketResource.InventoryConfigurationProperty.Destination``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
                 */
                public EnabledStep withDestination(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.DestinationProperty value) {
                    java.util.Objects.requireNonNull(value, "InventoryConfigurationProperty#destination is required");
                    this.instance._destination = value;
                    return this;
                }
                /**
                 * ``BucketResource.InventoryConfigurationProperty.Enabled``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
                 */
                public IdStep withEnabled(final java.lang.Boolean value) {
                    java.util.Objects.requireNonNull(value, "InventoryConfigurationProperty#enabled is required");
                    this.instance._enabled = value;
                    return this;
                }
                /**
                 * ``BucketResource.InventoryConfigurationProperty.Enabled``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
                 */
                public IdStep withEnabled(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "InventoryConfigurationProperty#enabled is required");
                    this.instance._enabled = value;
                    return this;
                }
                /**
                 * ``BucketResource.InventoryConfigurationProperty.Id``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-id
                 */
                public IncludedObjectVersionsStep withId(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "InventoryConfigurationProperty#id is required");
                    this.instance._id = value;
                    return this;
                }
                /**
                 * ``BucketResource.InventoryConfigurationProperty.Id``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-id
                 */
                public IncludedObjectVersionsStep withId(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "InventoryConfigurationProperty#id is required");
                    this.instance._id = value;
                    return this;
                }
                /**
                 * ``BucketResource.InventoryConfigurationProperty.IncludedObjectVersions``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-includedobjectversions
                 */
                public ScheduleFrequencyStep withIncludedObjectVersions(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "InventoryConfigurationProperty#includedObjectVersions is required");
                    this.instance._includedObjectVersions = value;
                    return this;
                }
                /**
                 * ``BucketResource.InventoryConfigurationProperty.IncludedObjectVersions``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-includedobjectversions
                 */
                public ScheduleFrequencyStep withIncludedObjectVersions(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "InventoryConfigurationProperty#includedObjectVersions is required");
                    this.instance._includedObjectVersions = value;
                    return this;
                }
                /**
                 * ``BucketResource.InventoryConfigurationProperty.OptionalFields``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
                 */
                public Build withOptionalFields(final software.amazon.awscdk.Token value) {
                    this.instance._optionalFields = value;
                    return this;
                }
                /**
                 * ``BucketResource.InventoryConfigurationProperty.OptionalFields``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
                 */
                public Build withOptionalFields(final java.util.List<java.lang.Object> value) {
                    this.instance._optionalFields = value;
                    return this;
                }
                /**
                 * ``BucketResource.InventoryConfigurationProperty.Prefix``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-prefix
                 */
                public Build withPrefix(final java.lang.String value) {
                    this.instance._prefix = value;
                    return this;
                }
                /**
                 * ``BucketResource.InventoryConfigurationProperty.Prefix``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-prefix
                 */
                public Build withPrefix(final software.amazon.awscdk.Token value) {
                    this.instance._prefix = value;
                    return this;
                }
                /**
                 * ``BucketResource.InventoryConfigurationProperty.ScheduleFrequency``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-schedulefrequency
                 */
                public Build withScheduleFrequency(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "InventoryConfigurationProperty#scheduleFrequency is required");
                    this.instance._scheduleFrequency = value;
                    return this;
                }
                /**
                 * ``BucketResource.InventoryConfigurationProperty.ScheduleFrequency``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-schedulefrequency
                 */
                public Build withScheduleFrequency(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "InventoryConfigurationProperty#scheduleFrequency is required");
                    this.instance._scheduleFrequency = value;
                    return this;
                }
                public InventoryConfigurationProperty build() {
                    InventoryConfigurationProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link InventoryConfigurationProperty}.
         */
        final class Jsii$Pojo implements InventoryConfigurationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _destination;

            public java.lang.Object getDestination() {
                return this._destination;
            }
            public void setDestination(final software.amazon.awscdk.Token value) {
                this._destination = value;
            }
            public void setDestination(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.DestinationProperty value) {
                this._destination = value;
            }

            protected java.lang.Object _enabled;

            public java.lang.Object getEnabled() {
                return this._enabled;
            }
            public void setEnabled(final java.lang.Boolean value) {
                this._enabled = value;
            }
            public void setEnabled(final software.amazon.awscdk.Token value) {
                this._enabled = value;
            }

            protected java.lang.Object _id;

            public java.lang.Object getId() {
                return this._id;
            }
            public void setId(final java.lang.String value) {
                this._id = value;
            }
            public void setId(final software.amazon.awscdk.Token value) {
                this._id = value;
            }

            protected java.lang.Object _includedObjectVersions;

            public java.lang.Object getIncludedObjectVersions() {
                return this._includedObjectVersions;
            }
            public void setIncludedObjectVersions(final java.lang.String value) {
                this._includedObjectVersions = value;
            }
            public void setIncludedObjectVersions(final software.amazon.awscdk.Token value) {
                this._includedObjectVersions = value;
            }

            protected java.lang.Object _optionalFields;

            public java.lang.Object getOptionalFields() {
                return this._optionalFields;
            }
            public void setOptionalFields(final software.amazon.awscdk.Token value) {
                this._optionalFields = value;
            }
            public void setOptionalFields(final java.util.List<java.lang.Object> value) {
                this._optionalFields = value;
            }

            protected java.lang.Object _prefix;

            public java.lang.Object getPrefix() {
                return this._prefix;
            }
            public void setPrefix(final java.lang.String value) {
                this._prefix = value;
            }
            public void setPrefix(final software.amazon.awscdk.Token value) {
                this._prefix = value;
            }

            protected java.lang.Object _scheduleFrequency;

            public java.lang.Object getScheduleFrequency() {
                return this._scheduleFrequency;
            }
            public void setScheduleFrequency(final java.lang.String value) {
                this._scheduleFrequency = value;
            }
            public void setScheduleFrequency(final software.amazon.awscdk.Token value) {
                this._scheduleFrequency = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.InventoryConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.InventoryConfigurationProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
             */
            public java.lang.Object getDestination() {
                return this.jsiiGet("destination", java.lang.Object.class);
            }
            /**
             * ``BucketResource.InventoryConfigurationProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
             */
            public void setDestination(final software.amazon.awscdk.Token value) {
                this.jsiiSet("destination", java.util.Objects.requireNonNull(value, "destination is required"));
            }
            /**
             * ``BucketResource.InventoryConfigurationProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
             */
            public void setDestination(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.DestinationProperty value) {
                this.jsiiSet("destination", java.util.Objects.requireNonNull(value, "destination is required"));
            }
            /**
             * ``BucketResource.InventoryConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
             */
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }
            /**
             * ``BucketResource.InventoryConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
             */
            public void setEnabled(final java.lang.Boolean value) {
                this.jsiiSet("enabled", java.util.Objects.requireNonNull(value, "enabled is required"));
            }
            /**
             * ``BucketResource.InventoryConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
             */
            public void setEnabled(final software.amazon.awscdk.Token value) {
                this.jsiiSet("enabled", java.util.Objects.requireNonNull(value, "enabled is required"));
            }
            /**
             * ``BucketResource.InventoryConfigurationProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-id
             */
            public java.lang.Object getId() {
                return this.jsiiGet("id", java.lang.Object.class);
            }
            /**
             * ``BucketResource.InventoryConfigurationProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-id
             */
            public void setId(final java.lang.String value) {
                this.jsiiSet("id", java.util.Objects.requireNonNull(value, "id is required"));
            }
            /**
             * ``BucketResource.InventoryConfigurationProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-id
             */
            public void setId(final software.amazon.awscdk.Token value) {
                this.jsiiSet("id", java.util.Objects.requireNonNull(value, "id is required"));
            }
            /**
             * ``BucketResource.InventoryConfigurationProperty.IncludedObjectVersions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-includedobjectversions
             */
            public java.lang.Object getIncludedObjectVersions() {
                return this.jsiiGet("includedObjectVersions", java.lang.Object.class);
            }
            /**
             * ``BucketResource.InventoryConfigurationProperty.IncludedObjectVersions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-includedobjectversions
             */
            public void setIncludedObjectVersions(final java.lang.String value) {
                this.jsiiSet("includedObjectVersions", java.util.Objects.requireNonNull(value, "includedObjectVersions is required"));
            }
            /**
             * ``BucketResource.InventoryConfigurationProperty.IncludedObjectVersions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-includedobjectversions
             */
            public void setIncludedObjectVersions(final software.amazon.awscdk.Token value) {
                this.jsiiSet("includedObjectVersions", java.util.Objects.requireNonNull(value, "includedObjectVersions is required"));
            }
            /**
             * ``BucketResource.InventoryConfigurationProperty.OptionalFields``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
             */
            @javax.annotation.Nullable
            public java.lang.Object getOptionalFields() {
                return this.jsiiGet("optionalFields", java.lang.Object.class);
            }
            /**
             * ``BucketResource.InventoryConfigurationProperty.OptionalFields``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
             */
            public void setOptionalFields(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("optionalFields", value);
            }
            /**
             * ``BucketResource.InventoryConfigurationProperty.OptionalFields``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
             */
            public void setOptionalFields(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("optionalFields", value);
            }
            /**
             * ``BucketResource.InventoryConfigurationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-prefix
             */
            @javax.annotation.Nullable
            public java.lang.Object getPrefix() {
                return this.jsiiGet("prefix", java.lang.Object.class);
            }
            /**
             * ``BucketResource.InventoryConfigurationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-prefix
             */
            public void setPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("prefix", value);
            }
            /**
             * ``BucketResource.InventoryConfigurationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-prefix
             */
            public void setPrefix(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("prefix", value);
            }
            /**
             * ``BucketResource.InventoryConfigurationProperty.ScheduleFrequency``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-schedulefrequency
             */
            public java.lang.Object getScheduleFrequency() {
                return this.jsiiGet("scheduleFrequency", java.lang.Object.class);
            }
            /**
             * ``BucketResource.InventoryConfigurationProperty.ScheduleFrequency``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-schedulefrequency
             */
            public void setScheduleFrequency(final java.lang.String value) {
                this.jsiiSet("scheduleFrequency", java.util.Objects.requireNonNull(value, "scheduleFrequency is required"));
            }
            /**
             * ``BucketResource.InventoryConfigurationProperty.ScheduleFrequency``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-schedulefrequency
             */
            public void setScheduleFrequency(final software.amazon.awscdk.Token value) {
                this.jsiiSet("scheduleFrequency", java.util.Objects.requireNonNull(value, "scheduleFrequency is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html
     */
    public static interface LambdaConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.LambdaConfigurationProperty.Event``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-event
         */
        java.lang.Object getEvent();
        /**
         * ``BucketResource.LambdaConfigurationProperty.Event``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-event
         */
        void setEvent(final java.lang.String value);
        /**
         * ``BucketResource.LambdaConfigurationProperty.Event``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-event
         */
        void setEvent(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.LambdaConfigurationProperty.Filter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
         */
        java.lang.Object getFilter();
        /**
         * ``BucketResource.LambdaConfigurationProperty.Filter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
         */
        void setFilter(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.LambdaConfigurationProperty.Filter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
         */
        void setFilter(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationFilterProperty value);
        /**
         * ``BucketResource.LambdaConfigurationProperty.Function``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-function
         */
        java.lang.Object getFunction();
        /**
         * ``BucketResource.LambdaConfigurationProperty.Function``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-function
         */
        void setFunction(final java.lang.String value);
        /**
         * ``BucketResource.LambdaConfigurationProperty.Function``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-function
         */
        void setFunction(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link LambdaConfigurationProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.LambdaConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-event
             */
            public FunctionStep withEvent(final java.lang.String value) {
                return new FullBuilder().withEvent(value);
            }
            /**
             * ``BucketResource.LambdaConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-event
             */
            public FunctionStep withEvent(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withEvent(value);
            }

            public interface FunctionStep {
                /**
                 * ``BucketResource.LambdaConfigurationProperty.Function``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-function
                 */
                Build withFunction(final java.lang.String value);
                /**
                 * ``BucketResource.LambdaConfigurationProperty.Function``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-function
                 */
                Build withFunction(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link LambdaConfigurationProperty} object, initialized with the values set on this builder.
                 */
                LambdaConfigurationProperty build();
                /**
                 * ``BucketResource.LambdaConfigurationProperty.Filter``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
                 */
                Build withFilter(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.LambdaConfigurationProperty.Filter``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
                 */
                Build withFilter(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationFilterProperty value);
            }

            final class FullBuilder implements FunctionStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.LambdaConfigurationProperty.Event``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-event
                 */
                public FunctionStep withEvent(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "LambdaConfigurationProperty#event is required");
                    this.instance._event = value;
                    return this;
                }
                /**
                 * ``BucketResource.LambdaConfigurationProperty.Event``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-event
                 */
                public FunctionStep withEvent(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "LambdaConfigurationProperty#event is required");
                    this.instance._event = value;
                    return this;
                }
                /**
                 * ``BucketResource.LambdaConfigurationProperty.Filter``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
                 */
                public Build withFilter(final software.amazon.awscdk.Token value) {
                    this.instance._filter = value;
                    return this;
                }
                /**
                 * ``BucketResource.LambdaConfigurationProperty.Filter``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
                 */
                public Build withFilter(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationFilterProperty value) {
                    this.instance._filter = value;
                    return this;
                }
                /**
                 * ``BucketResource.LambdaConfigurationProperty.Function``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-function
                 */
                public Build withFunction(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "LambdaConfigurationProperty#function is required");
                    this.instance._function = value;
                    return this;
                }
                /**
                 * ``BucketResource.LambdaConfigurationProperty.Function``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-function
                 */
                public Build withFunction(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "LambdaConfigurationProperty#function is required");
                    this.instance._function = value;
                    return this;
                }
                public LambdaConfigurationProperty build() {
                    LambdaConfigurationProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link LambdaConfigurationProperty}.
         */
        final class Jsii$Pojo implements LambdaConfigurationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _event;

            public java.lang.Object getEvent() {
                return this._event;
            }
            public void setEvent(final java.lang.String value) {
                this._event = value;
            }
            public void setEvent(final software.amazon.awscdk.Token value) {
                this._event = value;
            }

            protected java.lang.Object _filter;

            public java.lang.Object getFilter() {
                return this._filter;
            }
            public void setFilter(final software.amazon.awscdk.Token value) {
                this._filter = value;
            }
            public void setFilter(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationFilterProperty value) {
                this._filter = value;
            }

            protected java.lang.Object _function;

            public java.lang.Object getFunction() {
                return this._function;
            }
            public void setFunction(final java.lang.String value) {
                this._function = value;
            }
            public void setFunction(final software.amazon.awscdk.Token value) {
                this._function = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.LambdaConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.LambdaConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-event
             */
            public java.lang.Object getEvent() {
                return this.jsiiGet("event", java.lang.Object.class);
            }
            /**
             * ``BucketResource.LambdaConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-event
             */
            public void setEvent(final java.lang.String value) {
                this.jsiiSet("event", java.util.Objects.requireNonNull(value, "event is required"));
            }
            /**
             * ``BucketResource.LambdaConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-event
             */
            public void setEvent(final software.amazon.awscdk.Token value) {
                this.jsiiSet("event", java.util.Objects.requireNonNull(value, "event is required"));
            }
            /**
             * ``BucketResource.LambdaConfigurationProperty.Filter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
             */
            @javax.annotation.Nullable
            public java.lang.Object getFilter() {
                return this.jsiiGet("filter", java.lang.Object.class);
            }
            /**
             * ``BucketResource.LambdaConfigurationProperty.Filter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
             */
            public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("filter", value);
            }
            /**
             * ``BucketResource.LambdaConfigurationProperty.Filter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
             */
            public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationFilterProperty value) {
                this.jsiiSet("filter", value);
            }
            /**
             * ``BucketResource.LambdaConfigurationProperty.Function``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-function
             */
            public java.lang.Object getFunction() {
                return this.jsiiGet("function", java.lang.Object.class);
            }
            /**
             * ``BucketResource.LambdaConfigurationProperty.Function``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-function
             */
            public void setFunction(final java.lang.String value) {
                this.jsiiSet("function", java.util.Objects.requireNonNull(value, "function is required"));
            }
            /**
             * ``BucketResource.LambdaConfigurationProperty.Function``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-function
             */
            public void setFunction(final software.amazon.awscdk.Token value) {
                this.jsiiSet("function", java.util.Objects.requireNonNull(value, "function is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html
     */
    public static interface LifecycleConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.LifecycleConfigurationProperty.Rules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
         */
        java.lang.Object getRules();
        /**
         * ``BucketResource.LifecycleConfigurationProperty.Rules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
         */
        void setRules(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.LifecycleConfigurationProperty.Rules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
         */
        void setRules(final java.util.List<java.lang.Object> value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link LifecycleConfigurationProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.LifecycleConfigurationProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
             */
            public Build withRules(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withRules(value);
            }
            /**
             * ``BucketResource.LifecycleConfigurationProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
             */
            public Build withRules(final java.util.List<java.lang.Object> value) {
                return new FullBuilder().withRules(value);
            }

            public interface Build {
                /**
                 * @return a new {@link LifecycleConfigurationProperty} object, initialized with the values set on this builder.
                 */
                LifecycleConfigurationProperty build();
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.LifecycleConfigurationProperty.Rules``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
                 */
                public Build withRules(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "LifecycleConfigurationProperty#rules is required");
                    this.instance._rules = value;
                    return this;
                }
                /**
                 * ``BucketResource.LifecycleConfigurationProperty.Rules``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
                 */
                public Build withRules(final java.util.List<java.lang.Object> value) {
                    java.util.Objects.requireNonNull(value, "LifecycleConfigurationProperty#rules is required");
                    this.instance._rules = value;
                    return this;
                }
                public LifecycleConfigurationProperty build() {
                    LifecycleConfigurationProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link LifecycleConfigurationProperty}.
         */
        final class Jsii$Pojo implements LifecycleConfigurationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _rules;

            public java.lang.Object getRules() {
                return this._rules;
            }
            public void setRules(final software.amazon.awscdk.Token value) {
                this._rules = value;
            }
            public void setRules(final java.util.List<java.lang.Object> value) {
                this._rules = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.LifecycleConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.LifecycleConfigurationProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
             */
            public java.lang.Object getRules() {
                return this.jsiiGet("rules", java.lang.Object.class);
            }
            /**
             * ``BucketResource.LifecycleConfigurationProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
             */
            public void setRules(final software.amazon.awscdk.Token value) {
                this.jsiiSet("rules", java.util.Objects.requireNonNull(value, "rules is required"));
            }
            /**
             * ``BucketResource.LifecycleConfigurationProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
             */
            public void setRules(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("rules", java.util.Objects.requireNonNull(value, "rules is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html
     */
    public static interface LoggingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.LoggingConfigurationProperty.DestinationBucketName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-destinationbucketname
         */
        java.lang.Object getDestinationBucketName();
        /**
         * ``BucketResource.LoggingConfigurationProperty.DestinationBucketName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-destinationbucketname
         */
        void setDestinationBucketName(final java.lang.String value);
        /**
         * ``BucketResource.LoggingConfigurationProperty.DestinationBucketName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-destinationbucketname
         */
        void setDestinationBucketName(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.LoggingConfigurationProperty.LogFilePrefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-logfileprefix
         */
        java.lang.Object getLogFilePrefix();
        /**
         * ``BucketResource.LoggingConfigurationProperty.LogFilePrefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-logfileprefix
         */
        void setLogFilePrefix(final java.lang.String value);
        /**
         * ``BucketResource.LoggingConfigurationProperty.LogFilePrefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-logfileprefix
         */
        void setLogFilePrefix(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link LoggingConfigurationProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``BucketResource.LoggingConfigurationProperty.DestinationBucketName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-destinationbucketname
             */
            public Builder withDestinationBucketName(final java.lang.String value) {
                this.instance._destinationBucketName = value;
                return this;
            }
            /**
             * ``BucketResource.LoggingConfigurationProperty.DestinationBucketName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-destinationbucketname
             */
            public Builder withDestinationBucketName(final software.amazon.awscdk.Token value) {
                this.instance._destinationBucketName = value;
                return this;
            }
            /**
             * ``BucketResource.LoggingConfigurationProperty.LogFilePrefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-logfileprefix
             */
            public Builder withLogFilePrefix(final java.lang.String value) {
                this.instance._logFilePrefix = value;
                return this;
            }
            /**
             * ``BucketResource.LoggingConfigurationProperty.LogFilePrefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-logfileprefix
             */
            public Builder withLogFilePrefix(final software.amazon.awscdk.Token value) {
                this.instance._logFilePrefix = value;
                return this;
            }
            public LoggingConfigurationProperty build() {
                LoggingConfigurationProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link LoggingConfigurationProperty}.
         */
        final class Jsii$Pojo implements LoggingConfigurationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _destinationBucketName;

            public java.lang.Object getDestinationBucketName() {
                return this._destinationBucketName;
            }
            public void setDestinationBucketName(final java.lang.String value) {
                this._destinationBucketName = value;
            }
            public void setDestinationBucketName(final software.amazon.awscdk.Token value) {
                this._destinationBucketName = value;
            }

            protected java.lang.Object _logFilePrefix;

            public java.lang.Object getLogFilePrefix() {
                return this._logFilePrefix;
            }
            public void setLogFilePrefix(final java.lang.String value) {
                this._logFilePrefix = value;
            }
            public void setLogFilePrefix(final software.amazon.awscdk.Token value) {
                this._logFilePrefix = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.LoggingConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.LoggingConfigurationProperty.DestinationBucketName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-destinationbucketname
             */
            @javax.annotation.Nullable
            public java.lang.Object getDestinationBucketName() {
                return this.jsiiGet("destinationBucketName", java.lang.Object.class);
            }
            /**
             * ``BucketResource.LoggingConfigurationProperty.DestinationBucketName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-destinationbucketname
             */
            public void setDestinationBucketName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("destinationBucketName", value);
            }
            /**
             * ``BucketResource.LoggingConfigurationProperty.DestinationBucketName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-destinationbucketname
             */
            public void setDestinationBucketName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("destinationBucketName", value);
            }
            /**
             * ``BucketResource.LoggingConfigurationProperty.LogFilePrefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-logfileprefix
             */
            @javax.annotation.Nullable
            public java.lang.Object getLogFilePrefix() {
                return this.jsiiGet("logFilePrefix", java.lang.Object.class);
            }
            /**
             * ``BucketResource.LoggingConfigurationProperty.LogFilePrefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-logfileprefix
             */
            public void setLogFilePrefix(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("logFilePrefix", value);
            }
            /**
             * ``BucketResource.LoggingConfigurationProperty.LogFilePrefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-logfileprefix
             */
            public void setLogFilePrefix(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("logFilePrefix", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html
     */
    public static interface MetricsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.MetricsConfigurationProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-id
         */
        java.lang.Object getId();
        /**
         * ``BucketResource.MetricsConfigurationProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-id
         */
        void setId(final java.lang.String value);
        /**
         * ``BucketResource.MetricsConfigurationProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-id
         */
        void setId(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.MetricsConfigurationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-prefix
         */
        java.lang.Object getPrefix();
        /**
         * ``BucketResource.MetricsConfigurationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-prefix
         */
        void setPrefix(final java.lang.String value);
        /**
         * ``BucketResource.MetricsConfigurationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-prefix
         */
        void setPrefix(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.MetricsConfigurationProperty.TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
         */
        java.lang.Object getTagFilters();
        /**
         * ``BucketResource.MetricsConfigurationProperty.TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
         */
        void setTagFilters(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.MetricsConfigurationProperty.TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
         */
        void setTagFilters(final java.util.List<java.lang.Object> value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link MetricsConfigurationProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.MetricsConfigurationProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-id
             */
            public Build withId(final java.lang.String value) {
                return new FullBuilder().withId(value);
            }
            /**
             * ``BucketResource.MetricsConfigurationProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-id
             */
            public Build withId(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withId(value);
            }

            public interface Build {
                /**
                 * @return a new {@link MetricsConfigurationProperty} object, initialized with the values set on this builder.
                 */
                MetricsConfigurationProperty build();
                /**
                 * ``BucketResource.MetricsConfigurationProperty.Prefix``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-prefix
                 */
                Build withPrefix(final java.lang.String value);
                /**
                 * ``BucketResource.MetricsConfigurationProperty.Prefix``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-prefix
                 */
                Build withPrefix(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.MetricsConfigurationProperty.TagFilters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
                 */
                Build withTagFilters(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.MetricsConfigurationProperty.TagFilters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
                 */
                Build withTagFilters(final java.util.List<java.lang.Object> value);
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.MetricsConfigurationProperty.Id``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-id
                 */
                public Build withId(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "MetricsConfigurationProperty#id is required");
                    this.instance._id = value;
                    return this;
                }
                /**
                 * ``BucketResource.MetricsConfigurationProperty.Id``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-id
                 */
                public Build withId(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "MetricsConfigurationProperty#id is required");
                    this.instance._id = value;
                    return this;
                }
                /**
                 * ``BucketResource.MetricsConfigurationProperty.Prefix``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-prefix
                 */
                public Build withPrefix(final java.lang.String value) {
                    this.instance._prefix = value;
                    return this;
                }
                /**
                 * ``BucketResource.MetricsConfigurationProperty.Prefix``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-prefix
                 */
                public Build withPrefix(final software.amazon.awscdk.Token value) {
                    this.instance._prefix = value;
                    return this;
                }
                /**
                 * ``BucketResource.MetricsConfigurationProperty.TagFilters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
                 */
                public Build withTagFilters(final software.amazon.awscdk.Token value) {
                    this.instance._tagFilters = value;
                    return this;
                }
                /**
                 * ``BucketResource.MetricsConfigurationProperty.TagFilters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
                 */
                public Build withTagFilters(final java.util.List<java.lang.Object> value) {
                    this.instance._tagFilters = value;
                    return this;
                }
                public MetricsConfigurationProperty build() {
                    MetricsConfigurationProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link MetricsConfigurationProperty}.
         */
        final class Jsii$Pojo implements MetricsConfigurationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _id;

            public java.lang.Object getId() {
                return this._id;
            }
            public void setId(final java.lang.String value) {
                this._id = value;
            }
            public void setId(final software.amazon.awscdk.Token value) {
                this._id = value;
            }

            protected java.lang.Object _prefix;

            public java.lang.Object getPrefix() {
                return this._prefix;
            }
            public void setPrefix(final java.lang.String value) {
                this._prefix = value;
            }
            public void setPrefix(final software.amazon.awscdk.Token value) {
                this._prefix = value;
            }

            protected java.lang.Object _tagFilters;

            public java.lang.Object getTagFilters() {
                return this._tagFilters;
            }
            public void setTagFilters(final software.amazon.awscdk.Token value) {
                this._tagFilters = value;
            }
            public void setTagFilters(final java.util.List<java.lang.Object> value) {
                this._tagFilters = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.MetricsConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.MetricsConfigurationProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-id
             */
            public java.lang.Object getId() {
                return this.jsiiGet("id", java.lang.Object.class);
            }
            /**
             * ``BucketResource.MetricsConfigurationProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-id
             */
            public void setId(final java.lang.String value) {
                this.jsiiSet("id", java.util.Objects.requireNonNull(value, "id is required"));
            }
            /**
             * ``BucketResource.MetricsConfigurationProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-id
             */
            public void setId(final software.amazon.awscdk.Token value) {
                this.jsiiSet("id", java.util.Objects.requireNonNull(value, "id is required"));
            }
            /**
             * ``BucketResource.MetricsConfigurationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-prefix
             */
            @javax.annotation.Nullable
            public java.lang.Object getPrefix() {
                return this.jsiiGet("prefix", java.lang.Object.class);
            }
            /**
             * ``BucketResource.MetricsConfigurationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-prefix
             */
            public void setPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("prefix", value);
            }
            /**
             * ``BucketResource.MetricsConfigurationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-prefix
             */
            public void setPrefix(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("prefix", value);
            }
            /**
             * ``BucketResource.MetricsConfigurationProperty.TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
             */
            @javax.annotation.Nullable
            public java.lang.Object getTagFilters() {
                return this.jsiiGet("tagFilters", java.lang.Object.class);
            }
            /**
             * ``BucketResource.MetricsConfigurationProperty.TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
             */
            public void setTagFilters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("tagFilters", value);
            }
            /**
             * ``BucketResource.MetricsConfigurationProperty.TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
             */
            public void setTagFilters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("tagFilters", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html
     */
    public static interface NoncurrentVersionTransitionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.NoncurrentVersionTransitionProperty.StorageClass``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-storageclass
         */
        java.lang.Object getStorageClass();
        /**
         * ``BucketResource.NoncurrentVersionTransitionProperty.StorageClass``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-storageclass
         */
        void setStorageClass(final java.lang.String value);
        /**
         * ``BucketResource.NoncurrentVersionTransitionProperty.StorageClass``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-storageclass
         */
        void setStorageClass(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.NoncurrentVersionTransitionProperty.TransitionInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
         */
        java.lang.Object getTransitionInDays();
        /**
         * ``BucketResource.NoncurrentVersionTransitionProperty.TransitionInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
         */
        void setTransitionInDays(final java.lang.Number value);
        /**
         * ``BucketResource.NoncurrentVersionTransitionProperty.TransitionInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
         */
        void setTransitionInDays(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link NoncurrentVersionTransitionProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.NoncurrentVersionTransitionProperty.StorageClass``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-storageclass
             */
            public TransitionInDaysStep withStorageClass(final java.lang.String value) {
                return new FullBuilder().withStorageClass(value);
            }
            /**
             * ``BucketResource.NoncurrentVersionTransitionProperty.StorageClass``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-storageclass
             */
            public TransitionInDaysStep withStorageClass(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withStorageClass(value);
            }

            public interface TransitionInDaysStep {
                /**
                 * ``BucketResource.NoncurrentVersionTransitionProperty.TransitionInDays``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
                 */
                Build withTransitionInDays(final java.lang.Number value);
                /**
                 * ``BucketResource.NoncurrentVersionTransitionProperty.TransitionInDays``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
                 */
                Build withTransitionInDays(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link NoncurrentVersionTransitionProperty} object, initialized with the values set on this builder.
                 */
                NoncurrentVersionTransitionProperty build();
            }

            final class FullBuilder implements TransitionInDaysStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.NoncurrentVersionTransitionProperty.StorageClass``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-storageclass
                 */
                public TransitionInDaysStep withStorageClass(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "NoncurrentVersionTransitionProperty#storageClass is required");
                    this.instance._storageClass = value;
                    return this;
                }
                /**
                 * ``BucketResource.NoncurrentVersionTransitionProperty.StorageClass``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-storageclass
                 */
                public TransitionInDaysStep withStorageClass(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "NoncurrentVersionTransitionProperty#storageClass is required");
                    this.instance._storageClass = value;
                    return this;
                }
                /**
                 * ``BucketResource.NoncurrentVersionTransitionProperty.TransitionInDays``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
                 */
                public Build withTransitionInDays(final java.lang.Number value) {
                    java.util.Objects.requireNonNull(value, "NoncurrentVersionTransitionProperty#transitionInDays is required");
                    this.instance._transitionInDays = value;
                    return this;
                }
                /**
                 * ``BucketResource.NoncurrentVersionTransitionProperty.TransitionInDays``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
                 */
                public Build withTransitionInDays(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "NoncurrentVersionTransitionProperty#transitionInDays is required");
                    this.instance._transitionInDays = value;
                    return this;
                }
                public NoncurrentVersionTransitionProperty build() {
                    NoncurrentVersionTransitionProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link NoncurrentVersionTransitionProperty}.
         */
        final class Jsii$Pojo implements NoncurrentVersionTransitionProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _storageClass;

            public java.lang.Object getStorageClass() {
                return this._storageClass;
            }
            public void setStorageClass(final java.lang.String value) {
                this._storageClass = value;
            }
            public void setStorageClass(final software.amazon.awscdk.Token value) {
                this._storageClass = value;
            }

            protected java.lang.Object _transitionInDays;

            public java.lang.Object getTransitionInDays() {
                return this._transitionInDays;
            }
            public void setTransitionInDays(final java.lang.Number value) {
                this._transitionInDays = value;
            }
            public void setTransitionInDays(final software.amazon.awscdk.Token value) {
                this._transitionInDays = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.NoncurrentVersionTransitionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.NoncurrentVersionTransitionProperty.StorageClass``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-storageclass
             */
            public java.lang.Object getStorageClass() {
                return this.jsiiGet("storageClass", java.lang.Object.class);
            }
            /**
             * ``BucketResource.NoncurrentVersionTransitionProperty.StorageClass``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-storageclass
             */
            public void setStorageClass(final java.lang.String value) {
                this.jsiiSet("storageClass", java.util.Objects.requireNonNull(value, "storageClass is required"));
            }
            /**
             * ``BucketResource.NoncurrentVersionTransitionProperty.StorageClass``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-storageclass
             */
            public void setStorageClass(final software.amazon.awscdk.Token value) {
                this.jsiiSet("storageClass", java.util.Objects.requireNonNull(value, "storageClass is required"));
            }
            /**
             * ``BucketResource.NoncurrentVersionTransitionProperty.TransitionInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
             */
            public java.lang.Object getTransitionInDays() {
                return this.jsiiGet("transitionInDays", java.lang.Object.class);
            }
            /**
             * ``BucketResource.NoncurrentVersionTransitionProperty.TransitionInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
             */
            public void setTransitionInDays(final java.lang.Number value) {
                this.jsiiSet("transitionInDays", java.util.Objects.requireNonNull(value, "transitionInDays is required"));
            }
            /**
             * ``BucketResource.NoncurrentVersionTransitionProperty.TransitionInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
             */
            public void setTransitionInDays(final software.amazon.awscdk.Token value) {
                this.jsiiSet("transitionInDays", java.util.Objects.requireNonNull(value, "transitionInDays is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html
     */
    public static interface NotificationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.NotificationConfigurationProperty.LambdaConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig
         */
        java.lang.Object getLambdaConfigurations();
        /**
         * ``BucketResource.NotificationConfigurationProperty.LambdaConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig
         */
        void setLambdaConfigurations(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.NotificationConfigurationProperty.LambdaConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig
         */
        void setLambdaConfigurations(final java.util.List<java.lang.Object> value);
        /**
         * ``BucketResource.NotificationConfigurationProperty.QueueConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-queueconfig
         */
        java.lang.Object getQueueConfigurations();
        /**
         * ``BucketResource.NotificationConfigurationProperty.QueueConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-queueconfig
         */
        void setQueueConfigurations(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.NotificationConfigurationProperty.QueueConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-queueconfig
         */
        void setQueueConfigurations(final java.util.List<java.lang.Object> value);
        /**
         * ``BucketResource.NotificationConfigurationProperty.TopicConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-topicconfig
         */
        java.lang.Object getTopicConfigurations();
        /**
         * ``BucketResource.NotificationConfigurationProperty.TopicConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-topicconfig
         */
        void setTopicConfigurations(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.NotificationConfigurationProperty.TopicConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-topicconfig
         */
        void setTopicConfigurations(final java.util.List<java.lang.Object> value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link NotificationConfigurationProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``BucketResource.NotificationConfigurationProperty.LambdaConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig
             */
            public Builder withLambdaConfigurations(final software.amazon.awscdk.Token value) {
                this.instance._lambdaConfigurations = value;
                return this;
            }
            /**
             * ``BucketResource.NotificationConfigurationProperty.LambdaConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig
             */
            public Builder withLambdaConfigurations(final java.util.List<java.lang.Object> value) {
                this.instance._lambdaConfigurations = value;
                return this;
            }
            /**
             * ``BucketResource.NotificationConfigurationProperty.QueueConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-queueconfig
             */
            public Builder withQueueConfigurations(final software.amazon.awscdk.Token value) {
                this.instance._queueConfigurations = value;
                return this;
            }
            /**
             * ``BucketResource.NotificationConfigurationProperty.QueueConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-queueconfig
             */
            public Builder withQueueConfigurations(final java.util.List<java.lang.Object> value) {
                this.instance._queueConfigurations = value;
                return this;
            }
            /**
             * ``BucketResource.NotificationConfigurationProperty.TopicConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-topicconfig
             */
            public Builder withTopicConfigurations(final software.amazon.awscdk.Token value) {
                this.instance._topicConfigurations = value;
                return this;
            }
            /**
             * ``BucketResource.NotificationConfigurationProperty.TopicConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-topicconfig
             */
            public Builder withTopicConfigurations(final java.util.List<java.lang.Object> value) {
                this.instance._topicConfigurations = value;
                return this;
            }
            public NotificationConfigurationProperty build() {
                NotificationConfigurationProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link NotificationConfigurationProperty}.
         */
        final class Jsii$Pojo implements NotificationConfigurationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _lambdaConfigurations;

            public java.lang.Object getLambdaConfigurations() {
                return this._lambdaConfigurations;
            }
            public void setLambdaConfigurations(final software.amazon.awscdk.Token value) {
                this._lambdaConfigurations = value;
            }
            public void setLambdaConfigurations(final java.util.List<java.lang.Object> value) {
                this._lambdaConfigurations = value;
            }

            protected java.lang.Object _queueConfigurations;

            public java.lang.Object getQueueConfigurations() {
                return this._queueConfigurations;
            }
            public void setQueueConfigurations(final software.amazon.awscdk.Token value) {
                this._queueConfigurations = value;
            }
            public void setQueueConfigurations(final java.util.List<java.lang.Object> value) {
                this._queueConfigurations = value;
            }

            protected java.lang.Object _topicConfigurations;

            public java.lang.Object getTopicConfigurations() {
                return this._topicConfigurations;
            }
            public void setTopicConfigurations(final software.amazon.awscdk.Token value) {
                this._topicConfigurations = value;
            }
            public void setTopicConfigurations(final java.util.List<java.lang.Object> value) {
                this._topicConfigurations = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.NotificationConfigurationProperty.LambdaConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig
             */
            @javax.annotation.Nullable
            public java.lang.Object getLambdaConfigurations() {
                return this.jsiiGet("lambdaConfigurations", java.lang.Object.class);
            }
            /**
             * ``BucketResource.NotificationConfigurationProperty.LambdaConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig
             */
            public void setLambdaConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("lambdaConfigurations", value);
            }
            /**
             * ``BucketResource.NotificationConfigurationProperty.LambdaConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig
             */
            public void setLambdaConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("lambdaConfigurations", value);
            }
            /**
             * ``BucketResource.NotificationConfigurationProperty.QueueConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-queueconfig
             */
            @javax.annotation.Nullable
            public java.lang.Object getQueueConfigurations() {
                return this.jsiiGet("queueConfigurations", java.lang.Object.class);
            }
            /**
             * ``BucketResource.NotificationConfigurationProperty.QueueConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-queueconfig
             */
            public void setQueueConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("queueConfigurations", value);
            }
            /**
             * ``BucketResource.NotificationConfigurationProperty.QueueConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-queueconfig
             */
            public void setQueueConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("queueConfigurations", value);
            }
            /**
             * ``BucketResource.NotificationConfigurationProperty.TopicConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-topicconfig
             */
            @javax.annotation.Nullable
            public java.lang.Object getTopicConfigurations() {
                return this.jsiiGet("topicConfigurations", java.lang.Object.class);
            }
            /**
             * ``BucketResource.NotificationConfigurationProperty.TopicConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-topicconfig
             */
            public void setTopicConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("topicConfigurations", value);
            }
            /**
             * ``BucketResource.NotificationConfigurationProperty.TopicConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-topicconfig
             */
            public void setTopicConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("topicConfigurations", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html
     */
    public static interface NotificationFilterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.NotificationFilterProperty.S3Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
         */
        java.lang.Object getS3Key();
        /**
         * ``BucketResource.NotificationFilterProperty.S3Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
         */
        void setS3Key(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.NotificationFilterProperty.S3Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
         */
        void setS3Key(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.S3KeyFilterProperty value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link NotificationFilterProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.NotificationFilterProperty.S3Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
             */
            public Build withS3Key(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withS3Key(value);
            }
            /**
             * ``BucketResource.NotificationFilterProperty.S3Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
             */
            public Build withS3Key(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.S3KeyFilterProperty value) {
                return new FullBuilder().withS3Key(value);
            }

            public interface Build {
                /**
                 * @return a new {@link NotificationFilterProperty} object, initialized with the values set on this builder.
                 */
                NotificationFilterProperty build();
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.NotificationFilterProperty.S3Key``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
                 */
                public Build withS3Key(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "NotificationFilterProperty#s3Key is required");
                    this.instance._s3Key = value;
                    return this;
                }
                /**
                 * ``BucketResource.NotificationFilterProperty.S3Key``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
                 */
                public Build withS3Key(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.S3KeyFilterProperty value) {
                    java.util.Objects.requireNonNull(value, "NotificationFilterProperty#s3Key is required");
                    this.instance._s3Key = value;
                    return this;
                }
                public NotificationFilterProperty build() {
                    NotificationFilterProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link NotificationFilterProperty}.
         */
        final class Jsii$Pojo implements NotificationFilterProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _s3Key;

            public java.lang.Object getS3Key() {
                return this._s3Key;
            }
            public void setS3Key(final software.amazon.awscdk.Token value) {
                this._s3Key = value;
            }
            public void setS3Key(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.S3KeyFilterProperty value) {
                this._s3Key = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationFilterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.NotificationFilterProperty.S3Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
             */
            public java.lang.Object getS3Key() {
                return this.jsiiGet("s3Key", java.lang.Object.class);
            }
            /**
             * ``BucketResource.NotificationFilterProperty.S3Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
             */
            public void setS3Key(final software.amazon.awscdk.Token value) {
                this.jsiiSet("s3Key", java.util.Objects.requireNonNull(value, "s3Key is required"));
            }
            /**
             * ``BucketResource.NotificationFilterProperty.S3Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
             */
            public void setS3Key(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.S3KeyFilterProperty value) {
                this.jsiiSet("s3Key", java.util.Objects.requireNonNull(value, "s3Key is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html
     */
    public static interface QueueConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.QueueConfigurationProperty.Event``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-event
         */
        java.lang.Object getEvent();
        /**
         * ``BucketResource.QueueConfigurationProperty.Event``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-event
         */
        void setEvent(final java.lang.String value);
        /**
         * ``BucketResource.QueueConfigurationProperty.Event``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-event
         */
        void setEvent(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.QueueConfigurationProperty.Filter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
         */
        java.lang.Object getFilter();
        /**
         * ``BucketResource.QueueConfigurationProperty.Filter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
         */
        void setFilter(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.QueueConfigurationProperty.Filter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
         */
        void setFilter(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationFilterProperty value);
        /**
         * ``BucketResource.QueueConfigurationProperty.Queue``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-queue
         */
        java.lang.Object getQueue();
        /**
         * ``BucketResource.QueueConfigurationProperty.Queue``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-queue
         */
        void setQueue(final java.lang.String value);
        /**
         * ``BucketResource.QueueConfigurationProperty.Queue``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-queue
         */
        void setQueue(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link QueueConfigurationProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.QueueConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-event
             */
            public QueueStep withEvent(final java.lang.String value) {
                return new FullBuilder().withEvent(value);
            }
            /**
             * ``BucketResource.QueueConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-event
             */
            public QueueStep withEvent(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withEvent(value);
            }

            public interface QueueStep {
                /**
                 * ``BucketResource.QueueConfigurationProperty.Queue``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-queue
                 */
                Build withQueue(final java.lang.String value);
                /**
                 * ``BucketResource.QueueConfigurationProperty.Queue``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-queue
                 */
                Build withQueue(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link QueueConfigurationProperty} object, initialized with the values set on this builder.
                 */
                QueueConfigurationProperty build();
                /**
                 * ``BucketResource.QueueConfigurationProperty.Filter``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
                 */
                Build withFilter(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.QueueConfigurationProperty.Filter``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
                 */
                Build withFilter(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationFilterProperty value);
            }

            final class FullBuilder implements QueueStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.QueueConfigurationProperty.Event``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-event
                 */
                public QueueStep withEvent(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "QueueConfigurationProperty#event is required");
                    this.instance._event = value;
                    return this;
                }
                /**
                 * ``BucketResource.QueueConfigurationProperty.Event``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-event
                 */
                public QueueStep withEvent(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "QueueConfigurationProperty#event is required");
                    this.instance._event = value;
                    return this;
                }
                /**
                 * ``BucketResource.QueueConfigurationProperty.Filter``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
                 */
                public Build withFilter(final software.amazon.awscdk.Token value) {
                    this.instance._filter = value;
                    return this;
                }
                /**
                 * ``BucketResource.QueueConfigurationProperty.Filter``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
                 */
                public Build withFilter(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationFilterProperty value) {
                    this.instance._filter = value;
                    return this;
                }
                /**
                 * ``BucketResource.QueueConfigurationProperty.Queue``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-queue
                 */
                public Build withQueue(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "QueueConfigurationProperty#queue is required");
                    this.instance._queue = value;
                    return this;
                }
                /**
                 * ``BucketResource.QueueConfigurationProperty.Queue``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-queue
                 */
                public Build withQueue(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "QueueConfigurationProperty#queue is required");
                    this.instance._queue = value;
                    return this;
                }
                public QueueConfigurationProperty build() {
                    QueueConfigurationProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link QueueConfigurationProperty}.
         */
        final class Jsii$Pojo implements QueueConfigurationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _event;

            public java.lang.Object getEvent() {
                return this._event;
            }
            public void setEvent(final java.lang.String value) {
                this._event = value;
            }
            public void setEvent(final software.amazon.awscdk.Token value) {
                this._event = value;
            }

            protected java.lang.Object _filter;

            public java.lang.Object getFilter() {
                return this._filter;
            }
            public void setFilter(final software.amazon.awscdk.Token value) {
                this._filter = value;
            }
            public void setFilter(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationFilterProperty value) {
                this._filter = value;
            }

            protected java.lang.Object _queue;

            public java.lang.Object getQueue() {
                return this._queue;
            }
            public void setQueue(final java.lang.String value) {
                this._queue = value;
            }
            public void setQueue(final software.amazon.awscdk.Token value) {
                this._queue = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.QueueConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.QueueConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-event
             */
            public java.lang.Object getEvent() {
                return this.jsiiGet("event", java.lang.Object.class);
            }
            /**
             * ``BucketResource.QueueConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-event
             */
            public void setEvent(final java.lang.String value) {
                this.jsiiSet("event", java.util.Objects.requireNonNull(value, "event is required"));
            }
            /**
             * ``BucketResource.QueueConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-event
             */
            public void setEvent(final software.amazon.awscdk.Token value) {
                this.jsiiSet("event", java.util.Objects.requireNonNull(value, "event is required"));
            }
            /**
             * ``BucketResource.QueueConfigurationProperty.Filter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
             */
            @javax.annotation.Nullable
            public java.lang.Object getFilter() {
                return this.jsiiGet("filter", java.lang.Object.class);
            }
            /**
             * ``BucketResource.QueueConfigurationProperty.Filter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
             */
            public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("filter", value);
            }
            /**
             * ``BucketResource.QueueConfigurationProperty.Filter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
             */
            public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationFilterProperty value) {
                this.jsiiSet("filter", value);
            }
            /**
             * ``BucketResource.QueueConfigurationProperty.Queue``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-queue
             */
            public java.lang.Object getQueue() {
                return this.jsiiGet("queue", java.lang.Object.class);
            }
            /**
             * ``BucketResource.QueueConfigurationProperty.Queue``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-queue
             */
            public void setQueue(final java.lang.String value) {
                this.jsiiSet("queue", java.util.Objects.requireNonNull(value, "queue is required"));
            }
            /**
             * ``BucketResource.QueueConfigurationProperty.Queue``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-queue
             */
            public void setQueue(final software.amazon.awscdk.Token value) {
                this.jsiiSet("queue", java.util.Objects.requireNonNull(value, "queue is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html
     */
    public static interface RedirectAllRequestsToProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.RedirectAllRequestsToProperty.HostName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-hostname
         */
        java.lang.Object getHostName();
        /**
         * ``BucketResource.RedirectAllRequestsToProperty.HostName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-hostname
         */
        void setHostName(final java.lang.String value);
        /**
         * ``BucketResource.RedirectAllRequestsToProperty.HostName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-hostname
         */
        void setHostName(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RedirectAllRequestsToProperty.Protocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-protocol
         */
        java.lang.Object getProtocol();
        /**
         * ``BucketResource.RedirectAllRequestsToProperty.Protocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-protocol
         */
        void setProtocol(final java.lang.String value);
        /**
         * ``BucketResource.RedirectAllRequestsToProperty.Protocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-protocol
         */
        void setProtocol(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link RedirectAllRequestsToProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.RedirectAllRequestsToProperty.HostName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-hostname
             */
            public Build withHostName(final java.lang.String value) {
                return new FullBuilder().withHostName(value);
            }
            /**
             * ``BucketResource.RedirectAllRequestsToProperty.HostName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-hostname
             */
            public Build withHostName(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withHostName(value);
            }

            public interface Build {
                /**
                 * @return a new {@link RedirectAllRequestsToProperty} object, initialized with the values set on this builder.
                 */
                RedirectAllRequestsToProperty build();
                /**
                 * ``BucketResource.RedirectAllRequestsToProperty.Protocol``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-protocol
                 */
                Build withProtocol(final java.lang.String value);
                /**
                 * ``BucketResource.RedirectAllRequestsToProperty.Protocol``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-protocol
                 */
                Build withProtocol(final software.amazon.awscdk.Token value);
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.RedirectAllRequestsToProperty.HostName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-hostname
                 */
                public Build withHostName(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "RedirectAllRequestsToProperty#hostName is required");
                    this.instance._hostName = value;
                    return this;
                }
                /**
                 * ``BucketResource.RedirectAllRequestsToProperty.HostName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-hostname
                 */
                public Build withHostName(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "RedirectAllRequestsToProperty#hostName is required");
                    this.instance._hostName = value;
                    return this;
                }
                /**
                 * ``BucketResource.RedirectAllRequestsToProperty.Protocol``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-protocol
                 */
                public Build withProtocol(final java.lang.String value) {
                    this.instance._protocol = value;
                    return this;
                }
                /**
                 * ``BucketResource.RedirectAllRequestsToProperty.Protocol``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-protocol
                 */
                public Build withProtocol(final software.amazon.awscdk.Token value) {
                    this.instance._protocol = value;
                    return this;
                }
                public RedirectAllRequestsToProperty build() {
                    RedirectAllRequestsToProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link RedirectAllRequestsToProperty}.
         */
        final class Jsii$Pojo implements RedirectAllRequestsToProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _hostName;

            public java.lang.Object getHostName() {
                return this._hostName;
            }
            public void setHostName(final java.lang.String value) {
                this._hostName = value;
            }
            public void setHostName(final software.amazon.awscdk.Token value) {
                this._hostName = value;
            }

            protected java.lang.Object _protocol;

            public java.lang.Object getProtocol() {
                return this._protocol;
            }
            public void setProtocol(final java.lang.String value) {
                this._protocol = value;
            }
            public void setProtocol(final software.amazon.awscdk.Token value) {
                this._protocol = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.RedirectAllRequestsToProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.RedirectAllRequestsToProperty.HostName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-hostname
             */
            public java.lang.Object getHostName() {
                return this.jsiiGet("hostName", java.lang.Object.class);
            }
            /**
             * ``BucketResource.RedirectAllRequestsToProperty.HostName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-hostname
             */
            public void setHostName(final java.lang.String value) {
                this.jsiiSet("hostName", java.util.Objects.requireNonNull(value, "hostName is required"));
            }
            /**
             * ``BucketResource.RedirectAllRequestsToProperty.HostName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-hostname
             */
            public void setHostName(final software.amazon.awscdk.Token value) {
                this.jsiiSet("hostName", java.util.Objects.requireNonNull(value, "hostName is required"));
            }
            /**
             * ``BucketResource.RedirectAllRequestsToProperty.Protocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-protocol
             */
            @javax.annotation.Nullable
            public java.lang.Object getProtocol() {
                return this.jsiiGet("protocol", java.lang.Object.class);
            }
            /**
             * ``BucketResource.RedirectAllRequestsToProperty.Protocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-protocol
             */
            public void setProtocol(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("protocol", value);
            }
            /**
             * ``BucketResource.RedirectAllRequestsToProperty.Protocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-protocol
             */
            public void setProtocol(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("protocol", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html
     */
    public static interface RedirectRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.RedirectRuleProperty.HostName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-hostname
         */
        java.lang.Object getHostName();
        /**
         * ``BucketResource.RedirectRuleProperty.HostName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-hostname
         */
        void setHostName(final java.lang.String value);
        /**
         * ``BucketResource.RedirectRuleProperty.HostName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-hostname
         */
        void setHostName(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RedirectRuleProperty.HttpRedirectCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-httpredirectcode
         */
        java.lang.Object getHttpRedirectCode();
        /**
         * ``BucketResource.RedirectRuleProperty.HttpRedirectCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-httpredirectcode
         */
        void setHttpRedirectCode(final java.lang.String value);
        /**
         * ``BucketResource.RedirectRuleProperty.HttpRedirectCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-httpredirectcode
         */
        void setHttpRedirectCode(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RedirectRuleProperty.Protocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-protocol
         */
        java.lang.Object getProtocol();
        /**
         * ``BucketResource.RedirectRuleProperty.Protocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-protocol
         */
        void setProtocol(final java.lang.String value);
        /**
         * ``BucketResource.RedirectRuleProperty.Protocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-protocol
         */
        void setProtocol(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RedirectRuleProperty.ReplaceKeyPrefixWith``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeyprefixwith
         */
        java.lang.Object getReplaceKeyPrefixWith();
        /**
         * ``BucketResource.RedirectRuleProperty.ReplaceKeyPrefixWith``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeyprefixwith
         */
        void setReplaceKeyPrefixWith(final java.lang.String value);
        /**
         * ``BucketResource.RedirectRuleProperty.ReplaceKeyPrefixWith``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeyprefixwith
         */
        void setReplaceKeyPrefixWith(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RedirectRuleProperty.ReplaceKeyWith``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeywith
         */
        java.lang.Object getReplaceKeyWith();
        /**
         * ``BucketResource.RedirectRuleProperty.ReplaceKeyWith``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeywith
         */
        void setReplaceKeyWith(final java.lang.String value);
        /**
         * ``BucketResource.RedirectRuleProperty.ReplaceKeyWith``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeywith
         */
        void setReplaceKeyWith(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link RedirectRuleProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``BucketResource.RedirectRuleProperty.HostName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-hostname
             */
            public Builder withHostName(final java.lang.String value) {
                this.instance._hostName = value;
                return this;
            }
            /**
             * ``BucketResource.RedirectRuleProperty.HostName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-hostname
             */
            public Builder withHostName(final software.amazon.awscdk.Token value) {
                this.instance._hostName = value;
                return this;
            }
            /**
             * ``BucketResource.RedirectRuleProperty.HttpRedirectCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-httpredirectcode
             */
            public Builder withHttpRedirectCode(final java.lang.String value) {
                this.instance._httpRedirectCode = value;
                return this;
            }
            /**
             * ``BucketResource.RedirectRuleProperty.HttpRedirectCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-httpredirectcode
             */
            public Builder withHttpRedirectCode(final software.amazon.awscdk.Token value) {
                this.instance._httpRedirectCode = value;
                return this;
            }
            /**
             * ``BucketResource.RedirectRuleProperty.Protocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-protocol
             */
            public Builder withProtocol(final java.lang.String value) {
                this.instance._protocol = value;
                return this;
            }
            /**
             * ``BucketResource.RedirectRuleProperty.Protocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-protocol
             */
            public Builder withProtocol(final software.amazon.awscdk.Token value) {
                this.instance._protocol = value;
                return this;
            }
            /**
             * ``BucketResource.RedirectRuleProperty.ReplaceKeyPrefixWith``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeyprefixwith
             */
            public Builder withReplaceKeyPrefixWith(final java.lang.String value) {
                this.instance._replaceKeyPrefixWith = value;
                return this;
            }
            /**
             * ``BucketResource.RedirectRuleProperty.ReplaceKeyPrefixWith``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeyprefixwith
             */
            public Builder withReplaceKeyPrefixWith(final software.amazon.awscdk.Token value) {
                this.instance._replaceKeyPrefixWith = value;
                return this;
            }
            /**
             * ``BucketResource.RedirectRuleProperty.ReplaceKeyWith``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeywith
             */
            public Builder withReplaceKeyWith(final java.lang.String value) {
                this.instance._replaceKeyWith = value;
                return this;
            }
            /**
             * ``BucketResource.RedirectRuleProperty.ReplaceKeyWith``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeywith
             */
            public Builder withReplaceKeyWith(final software.amazon.awscdk.Token value) {
                this.instance._replaceKeyWith = value;
                return this;
            }
            public RedirectRuleProperty build() {
                RedirectRuleProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link RedirectRuleProperty}.
         */
        final class Jsii$Pojo implements RedirectRuleProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _hostName;

            public java.lang.Object getHostName() {
                return this._hostName;
            }
            public void setHostName(final java.lang.String value) {
                this._hostName = value;
            }
            public void setHostName(final software.amazon.awscdk.Token value) {
                this._hostName = value;
            }

            protected java.lang.Object _httpRedirectCode;

            public java.lang.Object getHttpRedirectCode() {
                return this._httpRedirectCode;
            }
            public void setHttpRedirectCode(final java.lang.String value) {
                this._httpRedirectCode = value;
            }
            public void setHttpRedirectCode(final software.amazon.awscdk.Token value) {
                this._httpRedirectCode = value;
            }

            protected java.lang.Object _protocol;

            public java.lang.Object getProtocol() {
                return this._protocol;
            }
            public void setProtocol(final java.lang.String value) {
                this._protocol = value;
            }
            public void setProtocol(final software.amazon.awscdk.Token value) {
                this._protocol = value;
            }

            protected java.lang.Object _replaceKeyPrefixWith;

            public java.lang.Object getReplaceKeyPrefixWith() {
                return this._replaceKeyPrefixWith;
            }
            public void setReplaceKeyPrefixWith(final java.lang.String value) {
                this._replaceKeyPrefixWith = value;
            }
            public void setReplaceKeyPrefixWith(final software.amazon.awscdk.Token value) {
                this._replaceKeyPrefixWith = value;
            }

            protected java.lang.Object _replaceKeyWith;

            public java.lang.Object getReplaceKeyWith() {
                return this._replaceKeyWith;
            }
            public void setReplaceKeyWith(final java.lang.String value) {
                this._replaceKeyWith = value;
            }
            public void setReplaceKeyWith(final software.amazon.awscdk.Token value) {
                this._replaceKeyWith = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.RedirectRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.RedirectRuleProperty.HostName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-hostname
             */
            @javax.annotation.Nullable
            public java.lang.Object getHostName() {
                return this.jsiiGet("hostName", java.lang.Object.class);
            }
            /**
             * ``BucketResource.RedirectRuleProperty.HostName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-hostname
             */
            public void setHostName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("hostName", value);
            }
            /**
             * ``BucketResource.RedirectRuleProperty.HostName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-hostname
             */
            public void setHostName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("hostName", value);
            }
            /**
             * ``BucketResource.RedirectRuleProperty.HttpRedirectCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-httpredirectcode
             */
            @javax.annotation.Nullable
            public java.lang.Object getHttpRedirectCode() {
                return this.jsiiGet("httpRedirectCode", java.lang.Object.class);
            }
            /**
             * ``BucketResource.RedirectRuleProperty.HttpRedirectCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-httpredirectcode
             */
            public void setHttpRedirectCode(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("httpRedirectCode", value);
            }
            /**
             * ``BucketResource.RedirectRuleProperty.HttpRedirectCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-httpredirectcode
             */
            public void setHttpRedirectCode(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("httpRedirectCode", value);
            }
            /**
             * ``BucketResource.RedirectRuleProperty.Protocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-protocol
             */
            @javax.annotation.Nullable
            public java.lang.Object getProtocol() {
                return this.jsiiGet("protocol", java.lang.Object.class);
            }
            /**
             * ``BucketResource.RedirectRuleProperty.Protocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-protocol
             */
            public void setProtocol(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("protocol", value);
            }
            /**
             * ``BucketResource.RedirectRuleProperty.Protocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-protocol
             */
            public void setProtocol(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("protocol", value);
            }
            /**
             * ``BucketResource.RedirectRuleProperty.ReplaceKeyPrefixWith``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeyprefixwith
             */
            @javax.annotation.Nullable
            public java.lang.Object getReplaceKeyPrefixWith() {
                return this.jsiiGet("replaceKeyPrefixWith", java.lang.Object.class);
            }
            /**
             * ``BucketResource.RedirectRuleProperty.ReplaceKeyPrefixWith``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeyprefixwith
             */
            public void setReplaceKeyPrefixWith(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("replaceKeyPrefixWith", value);
            }
            /**
             * ``BucketResource.RedirectRuleProperty.ReplaceKeyPrefixWith``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeyprefixwith
             */
            public void setReplaceKeyPrefixWith(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("replaceKeyPrefixWith", value);
            }
            /**
             * ``BucketResource.RedirectRuleProperty.ReplaceKeyWith``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeywith
             */
            @javax.annotation.Nullable
            public java.lang.Object getReplaceKeyWith() {
                return this.jsiiGet("replaceKeyWith", java.lang.Object.class);
            }
            /**
             * ``BucketResource.RedirectRuleProperty.ReplaceKeyWith``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeywith
             */
            public void setReplaceKeyWith(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("replaceKeyWith", value);
            }
            /**
             * ``BucketResource.RedirectRuleProperty.ReplaceKeyWith``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeywith
             */
            public void setReplaceKeyWith(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("replaceKeyWith", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html
     */
    public static interface ReplicationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.ReplicationConfigurationProperty.Role``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-role
         */
        java.lang.Object getRole();
        /**
         * ``BucketResource.ReplicationConfigurationProperty.Role``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-role
         */
        void setRole(final java.lang.String value);
        /**
         * ``BucketResource.ReplicationConfigurationProperty.Role``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-role
         */
        void setRole(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.ReplicationConfigurationProperty.Rules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
         */
        java.lang.Object getRules();
        /**
         * ``BucketResource.ReplicationConfigurationProperty.Rules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
         */
        void setRules(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.ReplicationConfigurationProperty.Rules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
         */
        void setRules(final java.util.List<java.lang.Object> value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link ReplicationConfigurationProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.ReplicationConfigurationProperty.Role``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-role
             */
            public RulesStep withRole(final java.lang.String value) {
                return new FullBuilder().withRole(value);
            }
            /**
             * ``BucketResource.ReplicationConfigurationProperty.Role``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-role
             */
            public RulesStep withRole(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withRole(value);
            }

            public interface RulesStep {
                /**
                 * ``BucketResource.ReplicationConfigurationProperty.Rules``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
                 */
                Build withRules(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.ReplicationConfigurationProperty.Rules``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
                 */
                Build withRules(final java.util.List<java.lang.Object> value);
            }

            public interface Build {
                /**
                 * @return a new {@link ReplicationConfigurationProperty} object, initialized with the values set on this builder.
                 */
                ReplicationConfigurationProperty build();
            }

            final class FullBuilder implements RulesStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.ReplicationConfigurationProperty.Role``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-role
                 */
                public RulesStep withRole(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "ReplicationConfigurationProperty#role is required");
                    this.instance._role = value;
                    return this;
                }
                /**
                 * ``BucketResource.ReplicationConfigurationProperty.Role``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-role
                 */
                public RulesStep withRole(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "ReplicationConfigurationProperty#role is required");
                    this.instance._role = value;
                    return this;
                }
                /**
                 * ``BucketResource.ReplicationConfigurationProperty.Rules``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
                 */
                public Build withRules(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "ReplicationConfigurationProperty#rules is required");
                    this.instance._rules = value;
                    return this;
                }
                /**
                 * ``BucketResource.ReplicationConfigurationProperty.Rules``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
                 */
                public Build withRules(final java.util.List<java.lang.Object> value) {
                    java.util.Objects.requireNonNull(value, "ReplicationConfigurationProperty#rules is required");
                    this.instance._rules = value;
                    return this;
                }
                public ReplicationConfigurationProperty build() {
                    ReplicationConfigurationProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link ReplicationConfigurationProperty}.
         */
        final class Jsii$Pojo implements ReplicationConfigurationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _role;

            public java.lang.Object getRole() {
                return this._role;
            }
            public void setRole(final java.lang.String value) {
                this._role = value;
            }
            public void setRole(final software.amazon.awscdk.Token value) {
                this._role = value;
            }

            protected java.lang.Object _rules;

            public java.lang.Object getRules() {
                return this._rules;
            }
            public void setRules(final software.amazon.awscdk.Token value) {
                this._rules = value;
            }
            public void setRules(final java.util.List<java.lang.Object> value) {
                this._rules = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.ReplicationConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.ReplicationConfigurationProperty.Role``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-role
             */
            public java.lang.Object getRole() {
                return this.jsiiGet("role", java.lang.Object.class);
            }
            /**
             * ``BucketResource.ReplicationConfigurationProperty.Role``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-role
             */
            public void setRole(final java.lang.String value) {
                this.jsiiSet("role", java.util.Objects.requireNonNull(value, "role is required"));
            }
            /**
             * ``BucketResource.ReplicationConfigurationProperty.Role``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-role
             */
            public void setRole(final software.amazon.awscdk.Token value) {
                this.jsiiSet("role", java.util.Objects.requireNonNull(value, "role is required"));
            }
            /**
             * ``BucketResource.ReplicationConfigurationProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
             */
            public java.lang.Object getRules() {
                return this.jsiiGet("rules", java.lang.Object.class);
            }
            /**
             * ``BucketResource.ReplicationConfigurationProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
             */
            public void setRules(final software.amazon.awscdk.Token value) {
                this.jsiiSet("rules", java.util.Objects.requireNonNull(value, "rules is required"));
            }
            /**
             * ``BucketResource.ReplicationConfigurationProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
             */
            public void setRules(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("rules", java.util.Objects.requireNonNull(value, "rules is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html
     */
    public static interface ReplicationDestinationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.ReplicationDestinationProperty.AccessControlTranslation``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
         */
        java.lang.Object getAccessControlTranslation();
        /**
         * ``BucketResource.ReplicationDestinationProperty.AccessControlTranslation``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
         */
        void setAccessControlTranslation(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.ReplicationDestinationProperty.AccessControlTranslation``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
         */
        void setAccessControlTranslation(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.AccessControlTranslationProperty value);
        /**
         * ``BucketResource.ReplicationDestinationProperty.Account``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-account
         */
        java.lang.Object getAccount();
        /**
         * ``BucketResource.ReplicationDestinationProperty.Account``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-account
         */
        void setAccount(final java.lang.String value);
        /**
         * ``BucketResource.ReplicationDestinationProperty.Account``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-account
         */
        void setAccount(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.ReplicationDestinationProperty.Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-bucket
         */
        java.lang.Object getBucket();
        /**
         * ``BucketResource.ReplicationDestinationProperty.Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-bucket
         */
        void setBucket(final java.lang.String value);
        /**
         * ``BucketResource.ReplicationDestinationProperty.Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-bucket
         */
        void setBucket(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.ReplicationDestinationProperty.EncryptionConfiguration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
         */
        java.lang.Object getEncryptionConfiguration();
        /**
         * ``BucketResource.ReplicationDestinationProperty.EncryptionConfiguration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
         */
        void setEncryptionConfiguration(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.ReplicationDestinationProperty.EncryptionConfiguration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
         */
        void setEncryptionConfiguration(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.EncryptionConfigurationProperty value);
        /**
         * ``BucketResource.ReplicationDestinationProperty.StorageClass``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-storageclass
         */
        java.lang.Object getStorageClass();
        /**
         * ``BucketResource.ReplicationDestinationProperty.StorageClass``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-storageclass
         */
        void setStorageClass(final java.lang.String value);
        /**
         * ``BucketResource.ReplicationDestinationProperty.StorageClass``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-storageclass
         */
        void setStorageClass(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link ReplicationDestinationProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.ReplicationDestinationProperty.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-bucket
             */
            public Build withBucket(final java.lang.String value) {
                return new FullBuilder().withBucket(value);
            }
            /**
             * ``BucketResource.ReplicationDestinationProperty.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-bucket
             */
            public Build withBucket(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withBucket(value);
            }

            public interface Build {
                /**
                 * @return a new {@link ReplicationDestinationProperty} object, initialized with the values set on this builder.
                 */
                ReplicationDestinationProperty build();
                /**
                 * ``BucketResource.ReplicationDestinationProperty.AccessControlTranslation``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
                 */
                Build withAccessControlTranslation(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.ReplicationDestinationProperty.AccessControlTranslation``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
                 */
                Build withAccessControlTranslation(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.AccessControlTranslationProperty value);
                /**
                 * ``BucketResource.ReplicationDestinationProperty.Account``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-account
                 */
                Build withAccount(final java.lang.String value);
                /**
                 * ``BucketResource.ReplicationDestinationProperty.Account``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-account
                 */
                Build withAccount(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.ReplicationDestinationProperty.EncryptionConfiguration``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
                 */
                Build withEncryptionConfiguration(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.ReplicationDestinationProperty.EncryptionConfiguration``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
                 */
                Build withEncryptionConfiguration(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.EncryptionConfigurationProperty value);
                /**
                 * ``BucketResource.ReplicationDestinationProperty.StorageClass``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-storageclass
                 */
                Build withStorageClass(final java.lang.String value);
                /**
                 * ``BucketResource.ReplicationDestinationProperty.StorageClass``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-storageclass
                 */
                Build withStorageClass(final software.amazon.awscdk.Token value);
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.ReplicationDestinationProperty.AccessControlTranslation``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
                 */
                public Build withAccessControlTranslation(final software.amazon.awscdk.Token value) {
                    this.instance._accessControlTranslation = value;
                    return this;
                }
                /**
                 * ``BucketResource.ReplicationDestinationProperty.AccessControlTranslation``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
                 */
                public Build withAccessControlTranslation(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.AccessControlTranslationProperty value) {
                    this.instance._accessControlTranslation = value;
                    return this;
                }
                /**
                 * ``BucketResource.ReplicationDestinationProperty.Account``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-account
                 */
                public Build withAccount(final java.lang.String value) {
                    this.instance._account = value;
                    return this;
                }
                /**
                 * ``BucketResource.ReplicationDestinationProperty.Account``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-account
                 */
                public Build withAccount(final software.amazon.awscdk.Token value) {
                    this.instance._account = value;
                    return this;
                }
                /**
                 * ``BucketResource.ReplicationDestinationProperty.Bucket``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-bucket
                 */
                public Build withBucket(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "ReplicationDestinationProperty#bucket is required");
                    this.instance._bucket = value;
                    return this;
                }
                /**
                 * ``BucketResource.ReplicationDestinationProperty.Bucket``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-bucket
                 */
                public Build withBucket(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "ReplicationDestinationProperty#bucket is required");
                    this.instance._bucket = value;
                    return this;
                }
                /**
                 * ``BucketResource.ReplicationDestinationProperty.EncryptionConfiguration``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
                 */
                public Build withEncryptionConfiguration(final software.amazon.awscdk.Token value) {
                    this.instance._encryptionConfiguration = value;
                    return this;
                }
                /**
                 * ``BucketResource.ReplicationDestinationProperty.EncryptionConfiguration``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
                 */
                public Build withEncryptionConfiguration(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.EncryptionConfigurationProperty value) {
                    this.instance._encryptionConfiguration = value;
                    return this;
                }
                /**
                 * ``BucketResource.ReplicationDestinationProperty.StorageClass``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-storageclass
                 */
                public Build withStorageClass(final java.lang.String value) {
                    this.instance._storageClass = value;
                    return this;
                }
                /**
                 * ``BucketResource.ReplicationDestinationProperty.StorageClass``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-storageclass
                 */
                public Build withStorageClass(final software.amazon.awscdk.Token value) {
                    this.instance._storageClass = value;
                    return this;
                }
                public ReplicationDestinationProperty build() {
                    ReplicationDestinationProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link ReplicationDestinationProperty}.
         */
        final class Jsii$Pojo implements ReplicationDestinationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _accessControlTranslation;

            public java.lang.Object getAccessControlTranslation() {
                return this._accessControlTranslation;
            }
            public void setAccessControlTranslation(final software.amazon.awscdk.Token value) {
                this._accessControlTranslation = value;
            }
            public void setAccessControlTranslation(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.AccessControlTranslationProperty value) {
                this._accessControlTranslation = value;
            }

            protected java.lang.Object _account;

            public java.lang.Object getAccount() {
                return this._account;
            }
            public void setAccount(final java.lang.String value) {
                this._account = value;
            }
            public void setAccount(final software.amazon.awscdk.Token value) {
                this._account = value;
            }

            protected java.lang.Object _bucket;

            public java.lang.Object getBucket() {
                return this._bucket;
            }
            public void setBucket(final java.lang.String value) {
                this._bucket = value;
            }
            public void setBucket(final software.amazon.awscdk.Token value) {
                this._bucket = value;
            }

            protected java.lang.Object _encryptionConfiguration;

            public java.lang.Object getEncryptionConfiguration() {
                return this._encryptionConfiguration;
            }
            public void setEncryptionConfiguration(final software.amazon.awscdk.Token value) {
                this._encryptionConfiguration = value;
            }
            public void setEncryptionConfiguration(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.EncryptionConfigurationProperty value) {
                this._encryptionConfiguration = value;
            }

            protected java.lang.Object _storageClass;

            public java.lang.Object getStorageClass() {
                return this._storageClass;
            }
            public void setStorageClass(final java.lang.String value) {
                this._storageClass = value;
            }
            public void setStorageClass(final software.amazon.awscdk.Token value) {
                this._storageClass = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.ReplicationDestinationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.ReplicationDestinationProperty.AccessControlTranslation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
             */
            @javax.annotation.Nullable
            public java.lang.Object getAccessControlTranslation() {
                return this.jsiiGet("accessControlTranslation", java.lang.Object.class);
            }
            /**
             * ``BucketResource.ReplicationDestinationProperty.AccessControlTranslation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
             */
            public void setAccessControlTranslation(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("accessControlTranslation", value);
            }
            /**
             * ``BucketResource.ReplicationDestinationProperty.AccessControlTranslation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
             */
            public void setAccessControlTranslation(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.AccessControlTranslationProperty value) {
                this.jsiiSet("accessControlTranslation", value);
            }
            /**
             * ``BucketResource.ReplicationDestinationProperty.Account``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-account
             */
            @javax.annotation.Nullable
            public java.lang.Object getAccount() {
                return this.jsiiGet("account", java.lang.Object.class);
            }
            /**
             * ``BucketResource.ReplicationDestinationProperty.Account``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-account
             */
            public void setAccount(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("account", value);
            }
            /**
             * ``BucketResource.ReplicationDestinationProperty.Account``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-account
             */
            public void setAccount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("account", value);
            }
            /**
             * ``BucketResource.ReplicationDestinationProperty.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-bucket
             */
            public java.lang.Object getBucket() {
                return this.jsiiGet("bucket", java.lang.Object.class);
            }
            /**
             * ``BucketResource.ReplicationDestinationProperty.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-bucket
             */
            public void setBucket(final java.lang.String value) {
                this.jsiiSet("bucket", java.util.Objects.requireNonNull(value, "bucket is required"));
            }
            /**
             * ``BucketResource.ReplicationDestinationProperty.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-bucket
             */
            public void setBucket(final software.amazon.awscdk.Token value) {
                this.jsiiSet("bucket", java.util.Objects.requireNonNull(value, "bucket is required"));
            }
            /**
             * ``BucketResource.ReplicationDestinationProperty.EncryptionConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
             */
            @javax.annotation.Nullable
            public java.lang.Object getEncryptionConfiguration() {
                return this.jsiiGet("encryptionConfiguration", java.lang.Object.class);
            }
            /**
             * ``BucketResource.ReplicationDestinationProperty.EncryptionConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
             */
            public void setEncryptionConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("encryptionConfiguration", value);
            }
            /**
             * ``BucketResource.ReplicationDestinationProperty.EncryptionConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
             */
            public void setEncryptionConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.EncryptionConfigurationProperty value) {
                this.jsiiSet("encryptionConfiguration", value);
            }
            /**
             * ``BucketResource.ReplicationDestinationProperty.StorageClass``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-storageclass
             */
            @javax.annotation.Nullable
            public java.lang.Object getStorageClass() {
                return this.jsiiGet("storageClass", java.lang.Object.class);
            }
            /**
             * ``BucketResource.ReplicationDestinationProperty.StorageClass``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-storageclass
             */
            public void setStorageClass(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("storageClass", value);
            }
            /**
             * ``BucketResource.ReplicationDestinationProperty.StorageClass``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-storageclass
             */
            public void setStorageClass(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("storageClass", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html
     */
    public static interface ReplicationRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.ReplicationRuleProperty.Destination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
         */
        java.lang.Object getDestination();
        /**
         * ``BucketResource.ReplicationRuleProperty.Destination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
         */
        void setDestination(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.ReplicationRuleProperty.Destination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
         */
        void setDestination(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.ReplicationDestinationProperty value);
        /**
         * ``BucketResource.ReplicationRuleProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-id
         */
        java.lang.Object getId();
        /**
         * ``BucketResource.ReplicationRuleProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-id
         */
        void setId(final java.lang.String value);
        /**
         * ``BucketResource.ReplicationRuleProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-id
         */
        void setId(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.ReplicationRuleProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-prefix
         */
        java.lang.Object getPrefix();
        /**
         * ``BucketResource.ReplicationRuleProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-prefix
         */
        void setPrefix(final java.lang.String value);
        /**
         * ``BucketResource.ReplicationRuleProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-prefix
         */
        void setPrefix(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.ReplicationRuleProperty.SourceSelectionCriteria``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
         */
        java.lang.Object getSourceSelectionCriteria();
        /**
         * ``BucketResource.ReplicationRuleProperty.SourceSelectionCriteria``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
         */
        void setSourceSelectionCriteria(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.ReplicationRuleProperty.SourceSelectionCriteria``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
         */
        void setSourceSelectionCriteria(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.SourceSelectionCriteriaProperty value);
        /**
         * ``BucketResource.ReplicationRuleProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-status
         */
        java.lang.Object getStatus();
        /**
         * ``BucketResource.ReplicationRuleProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-status
         */
        void setStatus(final java.lang.String value);
        /**
         * ``BucketResource.ReplicationRuleProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-status
         */
        void setStatus(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link ReplicationRuleProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.ReplicationRuleProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
             */
            public PrefixStep withDestination(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withDestination(value);
            }
            /**
             * ``BucketResource.ReplicationRuleProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
             */
            public PrefixStep withDestination(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.ReplicationDestinationProperty value) {
                return new FullBuilder().withDestination(value);
            }

            public interface PrefixStep {
                /**
                 * ``BucketResource.ReplicationRuleProperty.Prefix``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-prefix
                 */
                StatusStep withPrefix(final java.lang.String value);
                /**
                 * ``BucketResource.ReplicationRuleProperty.Prefix``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-prefix
                 */
                StatusStep withPrefix(final software.amazon.awscdk.Token value);
            }

            public interface StatusStep {
                /**
                 * ``BucketResource.ReplicationRuleProperty.Status``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-status
                 */
                Build withStatus(final java.lang.String value);
                /**
                 * ``BucketResource.ReplicationRuleProperty.Status``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-status
                 */
                Build withStatus(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link ReplicationRuleProperty} object, initialized with the values set on this builder.
                 */
                ReplicationRuleProperty build();
                /**
                 * ``BucketResource.ReplicationRuleProperty.Id``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-id
                 */
                Build withId(final java.lang.String value);
                /**
                 * ``BucketResource.ReplicationRuleProperty.Id``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-id
                 */
                Build withId(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.ReplicationRuleProperty.SourceSelectionCriteria``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
                 */
                Build withSourceSelectionCriteria(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.ReplicationRuleProperty.SourceSelectionCriteria``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
                 */
                Build withSourceSelectionCriteria(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.SourceSelectionCriteriaProperty value);
            }

            final class FullBuilder implements PrefixStep, StatusStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.ReplicationRuleProperty.Destination``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
                 */
                public PrefixStep withDestination(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "ReplicationRuleProperty#destination is required");
                    this.instance._destination = value;
                    return this;
                }
                /**
                 * ``BucketResource.ReplicationRuleProperty.Destination``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
                 */
                public PrefixStep withDestination(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.ReplicationDestinationProperty value) {
                    java.util.Objects.requireNonNull(value, "ReplicationRuleProperty#destination is required");
                    this.instance._destination = value;
                    return this;
                }
                /**
                 * ``BucketResource.ReplicationRuleProperty.Id``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-id
                 */
                public Build withId(final java.lang.String value) {
                    this.instance._id = value;
                    return this;
                }
                /**
                 * ``BucketResource.ReplicationRuleProperty.Id``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-id
                 */
                public Build withId(final software.amazon.awscdk.Token value) {
                    this.instance._id = value;
                    return this;
                }
                /**
                 * ``BucketResource.ReplicationRuleProperty.Prefix``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-prefix
                 */
                public StatusStep withPrefix(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "ReplicationRuleProperty#prefix is required");
                    this.instance._prefix = value;
                    return this;
                }
                /**
                 * ``BucketResource.ReplicationRuleProperty.Prefix``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-prefix
                 */
                public StatusStep withPrefix(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "ReplicationRuleProperty#prefix is required");
                    this.instance._prefix = value;
                    return this;
                }
                /**
                 * ``BucketResource.ReplicationRuleProperty.SourceSelectionCriteria``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
                 */
                public Build withSourceSelectionCriteria(final software.amazon.awscdk.Token value) {
                    this.instance._sourceSelectionCriteria = value;
                    return this;
                }
                /**
                 * ``BucketResource.ReplicationRuleProperty.SourceSelectionCriteria``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
                 */
                public Build withSourceSelectionCriteria(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.SourceSelectionCriteriaProperty value) {
                    this.instance._sourceSelectionCriteria = value;
                    return this;
                }
                /**
                 * ``BucketResource.ReplicationRuleProperty.Status``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-status
                 */
                public Build withStatus(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "ReplicationRuleProperty#status is required");
                    this.instance._status = value;
                    return this;
                }
                /**
                 * ``BucketResource.ReplicationRuleProperty.Status``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-status
                 */
                public Build withStatus(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "ReplicationRuleProperty#status is required");
                    this.instance._status = value;
                    return this;
                }
                public ReplicationRuleProperty build() {
                    ReplicationRuleProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link ReplicationRuleProperty}.
         */
        final class Jsii$Pojo implements ReplicationRuleProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _destination;

            public java.lang.Object getDestination() {
                return this._destination;
            }
            public void setDestination(final software.amazon.awscdk.Token value) {
                this._destination = value;
            }
            public void setDestination(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.ReplicationDestinationProperty value) {
                this._destination = value;
            }

            protected java.lang.Object _id;

            public java.lang.Object getId() {
                return this._id;
            }
            public void setId(final java.lang.String value) {
                this._id = value;
            }
            public void setId(final software.amazon.awscdk.Token value) {
                this._id = value;
            }

            protected java.lang.Object _prefix;

            public java.lang.Object getPrefix() {
                return this._prefix;
            }
            public void setPrefix(final java.lang.String value) {
                this._prefix = value;
            }
            public void setPrefix(final software.amazon.awscdk.Token value) {
                this._prefix = value;
            }

            protected java.lang.Object _sourceSelectionCriteria;

            public java.lang.Object getSourceSelectionCriteria() {
                return this._sourceSelectionCriteria;
            }
            public void setSourceSelectionCriteria(final software.amazon.awscdk.Token value) {
                this._sourceSelectionCriteria = value;
            }
            public void setSourceSelectionCriteria(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.SourceSelectionCriteriaProperty value) {
                this._sourceSelectionCriteria = value;
            }

            protected java.lang.Object _status;

            public java.lang.Object getStatus() {
                return this._status;
            }
            public void setStatus(final java.lang.String value) {
                this._status = value;
            }
            public void setStatus(final software.amazon.awscdk.Token value) {
                this._status = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.ReplicationRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.ReplicationRuleProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
             */
            public java.lang.Object getDestination() {
                return this.jsiiGet("destination", java.lang.Object.class);
            }
            /**
             * ``BucketResource.ReplicationRuleProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
             */
            public void setDestination(final software.amazon.awscdk.Token value) {
                this.jsiiSet("destination", java.util.Objects.requireNonNull(value, "destination is required"));
            }
            /**
             * ``BucketResource.ReplicationRuleProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
             */
            public void setDestination(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.ReplicationDestinationProperty value) {
                this.jsiiSet("destination", java.util.Objects.requireNonNull(value, "destination is required"));
            }
            /**
             * ``BucketResource.ReplicationRuleProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-id
             */
            @javax.annotation.Nullable
            public java.lang.Object getId() {
                return this.jsiiGet("id", java.lang.Object.class);
            }
            /**
             * ``BucketResource.ReplicationRuleProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-id
             */
            public void setId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("id", value);
            }
            /**
             * ``BucketResource.ReplicationRuleProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-id
             */
            public void setId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("id", value);
            }
            /**
             * ``BucketResource.ReplicationRuleProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-prefix
             */
            public java.lang.Object getPrefix() {
                return this.jsiiGet("prefix", java.lang.Object.class);
            }
            /**
             * ``BucketResource.ReplicationRuleProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-prefix
             */
            public void setPrefix(final java.lang.String value) {
                this.jsiiSet("prefix", java.util.Objects.requireNonNull(value, "prefix is required"));
            }
            /**
             * ``BucketResource.ReplicationRuleProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-prefix
             */
            public void setPrefix(final software.amazon.awscdk.Token value) {
                this.jsiiSet("prefix", java.util.Objects.requireNonNull(value, "prefix is required"));
            }
            /**
             * ``BucketResource.ReplicationRuleProperty.SourceSelectionCriteria``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
             */
            @javax.annotation.Nullable
            public java.lang.Object getSourceSelectionCriteria() {
                return this.jsiiGet("sourceSelectionCriteria", java.lang.Object.class);
            }
            /**
             * ``BucketResource.ReplicationRuleProperty.SourceSelectionCriteria``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
             */
            public void setSourceSelectionCriteria(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("sourceSelectionCriteria", value);
            }
            /**
             * ``BucketResource.ReplicationRuleProperty.SourceSelectionCriteria``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
             */
            public void setSourceSelectionCriteria(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.SourceSelectionCriteriaProperty value) {
                this.jsiiSet("sourceSelectionCriteria", value);
            }
            /**
             * ``BucketResource.ReplicationRuleProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-status
             */
            public java.lang.Object getStatus() {
                return this.jsiiGet("status", java.lang.Object.class);
            }
            /**
             * ``BucketResource.ReplicationRuleProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-status
             */
            public void setStatus(final java.lang.String value) {
                this.jsiiSet("status", java.util.Objects.requireNonNull(value, "status is required"));
            }
            /**
             * ``BucketResource.ReplicationRuleProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-status
             */
            public void setStatus(final software.amazon.awscdk.Token value) {
                this.jsiiSet("status", java.util.Objects.requireNonNull(value, "status is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html
     */
    public static interface RoutingRuleConditionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-httperrorcodereturnedequals
         */
        java.lang.Object getHttpErrorCodeReturnedEquals();
        /**
         * ``BucketResource.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-httperrorcodereturnedequals
         */
        void setHttpErrorCodeReturnedEquals(final java.lang.String value);
        /**
         * ``BucketResource.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-httperrorcodereturnedequals
         */
        void setHttpErrorCodeReturnedEquals(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RoutingRuleConditionProperty.KeyPrefixEquals``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-keyprefixequals
         */
        java.lang.Object getKeyPrefixEquals();
        /**
         * ``BucketResource.RoutingRuleConditionProperty.KeyPrefixEquals``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-keyprefixequals
         */
        void setKeyPrefixEquals(final java.lang.String value);
        /**
         * ``BucketResource.RoutingRuleConditionProperty.KeyPrefixEquals``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-keyprefixequals
         */
        void setKeyPrefixEquals(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link RoutingRuleConditionProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``BucketResource.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-httperrorcodereturnedequals
             */
            public Builder withHttpErrorCodeReturnedEquals(final java.lang.String value) {
                this.instance._httpErrorCodeReturnedEquals = value;
                return this;
            }
            /**
             * ``BucketResource.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-httperrorcodereturnedequals
             */
            public Builder withHttpErrorCodeReturnedEquals(final software.amazon.awscdk.Token value) {
                this.instance._httpErrorCodeReturnedEquals = value;
                return this;
            }
            /**
             * ``BucketResource.RoutingRuleConditionProperty.KeyPrefixEquals``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-keyprefixequals
             */
            public Builder withKeyPrefixEquals(final java.lang.String value) {
                this.instance._keyPrefixEquals = value;
                return this;
            }
            /**
             * ``BucketResource.RoutingRuleConditionProperty.KeyPrefixEquals``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-keyprefixequals
             */
            public Builder withKeyPrefixEquals(final software.amazon.awscdk.Token value) {
                this.instance._keyPrefixEquals = value;
                return this;
            }
            public RoutingRuleConditionProperty build() {
                RoutingRuleConditionProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link RoutingRuleConditionProperty}.
         */
        final class Jsii$Pojo implements RoutingRuleConditionProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _httpErrorCodeReturnedEquals;

            public java.lang.Object getHttpErrorCodeReturnedEquals() {
                return this._httpErrorCodeReturnedEquals;
            }
            public void setHttpErrorCodeReturnedEquals(final java.lang.String value) {
                this._httpErrorCodeReturnedEquals = value;
            }
            public void setHttpErrorCodeReturnedEquals(final software.amazon.awscdk.Token value) {
                this._httpErrorCodeReturnedEquals = value;
            }

            protected java.lang.Object _keyPrefixEquals;

            public java.lang.Object getKeyPrefixEquals() {
                return this._keyPrefixEquals;
            }
            public void setKeyPrefixEquals(final java.lang.String value) {
                this._keyPrefixEquals = value;
            }
            public void setKeyPrefixEquals(final software.amazon.awscdk.Token value) {
                this._keyPrefixEquals = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.RoutingRuleConditionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-httperrorcodereturnedequals
             */
            @javax.annotation.Nullable
            public java.lang.Object getHttpErrorCodeReturnedEquals() {
                return this.jsiiGet("httpErrorCodeReturnedEquals", java.lang.Object.class);
            }
            /**
             * ``BucketResource.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-httperrorcodereturnedequals
             */
            public void setHttpErrorCodeReturnedEquals(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("httpErrorCodeReturnedEquals", value);
            }
            /**
             * ``BucketResource.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-httperrorcodereturnedequals
             */
            public void setHttpErrorCodeReturnedEquals(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("httpErrorCodeReturnedEquals", value);
            }
            /**
             * ``BucketResource.RoutingRuleConditionProperty.KeyPrefixEquals``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-keyprefixequals
             */
            @javax.annotation.Nullable
            public java.lang.Object getKeyPrefixEquals() {
                return this.jsiiGet("keyPrefixEquals", java.lang.Object.class);
            }
            /**
             * ``BucketResource.RoutingRuleConditionProperty.KeyPrefixEquals``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-keyprefixequals
             */
            public void setKeyPrefixEquals(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("keyPrefixEquals", value);
            }
            /**
             * ``BucketResource.RoutingRuleConditionProperty.KeyPrefixEquals``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-keyprefixequals
             */
            public void setKeyPrefixEquals(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("keyPrefixEquals", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html
     */
    public static interface RoutingRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.RoutingRuleProperty.RedirectRule``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
         */
        java.lang.Object getRedirectRule();
        /**
         * ``BucketResource.RoutingRuleProperty.RedirectRule``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
         */
        void setRedirectRule(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RoutingRuleProperty.RedirectRule``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
         */
        void setRedirectRule(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.RedirectRuleProperty value);
        /**
         * ``BucketResource.RoutingRuleProperty.RoutingRuleCondition``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
         */
        java.lang.Object getRoutingRuleCondition();
        /**
         * ``BucketResource.RoutingRuleProperty.RoutingRuleCondition``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
         */
        void setRoutingRuleCondition(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RoutingRuleProperty.RoutingRuleCondition``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
         */
        void setRoutingRuleCondition(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.RoutingRuleConditionProperty value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link RoutingRuleProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.RoutingRuleProperty.RedirectRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
             */
            public Build withRedirectRule(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withRedirectRule(value);
            }
            /**
             * ``BucketResource.RoutingRuleProperty.RedirectRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
             */
            public Build withRedirectRule(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.RedirectRuleProperty value) {
                return new FullBuilder().withRedirectRule(value);
            }

            public interface Build {
                /**
                 * @return a new {@link RoutingRuleProperty} object, initialized with the values set on this builder.
                 */
                RoutingRuleProperty build();
                /**
                 * ``BucketResource.RoutingRuleProperty.RoutingRuleCondition``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
                 */
                Build withRoutingRuleCondition(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.RoutingRuleProperty.RoutingRuleCondition``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
                 */
                Build withRoutingRuleCondition(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.RoutingRuleConditionProperty value);
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.RoutingRuleProperty.RedirectRule``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
                 */
                public Build withRedirectRule(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "RoutingRuleProperty#redirectRule is required");
                    this.instance._redirectRule = value;
                    return this;
                }
                /**
                 * ``BucketResource.RoutingRuleProperty.RedirectRule``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
                 */
                public Build withRedirectRule(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.RedirectRuleProperty value) {
                    java.util.Objects.requireNonNull(value, "RoutingRuleProperty#redirectRule is required");
                    this.instance._redirectRule = value;
                    return this;
                }
                /**
                 * ``BucketResource.RoutingRuleProperty.RoutingRuleCondition``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
                 */
                public Build withRoutingRuleCondition(final software.amazon.awscdk.Token value) {
                    this.instance._routingRuleCondition = value;
                    return this;
                }
                /**
                 * ``BucketResource.RoutingRuleProperty.RoutingRuleCondition``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
                 */
                public Build withRoutingRuleCondition(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.RoutingRuleConditionProperty value) {
                    this.instance._routingRuleCondition = value;
                    return this;
                }
                public RoutingRuleProperty build() {
                    RoutingRuleProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link RoutingRuleProperty}.
         */
        final class Jsii$Pojo implements RoutingRuleProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _redirectRule;

            public java.lang.Object getRedirectRule() {
                return this._redirectRule;
            }
            public void setRedirectRule(final software.amazon.awscdk.Token value) {
                this._redirectRule = value;
            }
            public void setRedirectRule(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.RedirectRuleProperty value) {
                this._redirectRule = value;
            }

            protected java.lang.Object _routingRuleCondition;

            public java.lang.Object getRoutingRuleCondition() {
                return this._routingRuleCondition;
            }
            public void setRoutingRuleCondition(final software.amazon.awscdk.Token value) {
                this._routingRuleCondition = value;
            }
            public void setRoutingRuleCondition(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.RoutingRuleConditionProperty value) {
                this._routingRuleCondition = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.RoutingRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.RoutingRuleProperty.RedirectRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
             */
            public java.lang.Object getRedirectRule() {
                return this.jsiiGet("redirectRule", java.lang.Object.class);
            }
            /**
             * ``BucketResource.RoutingRuleProperty.RedirectRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
             */
            public void setRedirectRule(final software.amazon.awscdk.Token value) {
                this.jsiiSet("redirectRule", java.util.Objects.requireNonNull(value, "redirectRule is required"));
            }
            /**
             * ``BucketResource.RoutingRuleProperty.RedirectRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
             */
            public void setRedirectRule(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.RedirectRuleProperty value) {
                this.jsiiSet("redirectRule", java.util.Objects.requireNonNull(value, "redirectRule is required"));
            }
            /**
             * ``BucketResource.RoutingRuleProperty.RoutingRuleCondition``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
             */
            @javax.annotation.Nullable
            public java.lang.Object getRoutingRuleCondition() {
                return this.jsiiGet("routingRuleCondition", java.lang.Object.class);
            }
            /**
             * ``BucketResource.RoutingRuleProperty.RoutingRuleCondition``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
             */
            public void setRoutingRuleCondition(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("routingRuleCondition", value);
            }
            /**
             * ``BucketResource.RoutingRuleProperty.RoutingRuleCondition``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
             */
            public void setRoutingRuleCondition(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.RoutingRuleConditionProperty value) {
                this.jsiiSet("routingRuleCondition", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html
     */
    public static interface RuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.RuleProperty.AbortIncompleteMultipartUpload``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
         */
        java.lang.Object getAbortIncompleteMultipartUpload();
        /**
         * ``BucketResource.RuleProperty.AbortIncompleteMultipartUpload``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
         */
        void setAbortIncompleteMultipartUpload(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RuleProperty.AbortIncompleteMultipartUpload``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
         */
        void setAbortIncompleteMultipartUpload(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.AbortIncompleteMultipartUploadProperty value);
        /**
         * ``BucketResource.RuleProperty.ExpirationDate``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
         */
        java.lang.Object getExpirationDate();
        /**
         * ``BucketResource.RuleProperty.ExpirationDate``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
         */
        void setExpirationDate(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RuleProperty.ExpirationDate``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
         */
        void setExpirationDate(final java.time.Instant value);
        /**
         * ``BucketResource.RuleProperty.ExpirationInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
         */
        java.lang.Object getExpirationInDays();
        /**
         * ``BucketResource.RuleProperty.ExpirationInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
         */
        void setExpirationInDays(final java.lang.Number value);
        /**
         * ``BucketResource.RuleProperty.ExpirationInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
         */
        void setExpirationInDays(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RuleProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-id
         */
        java.lang.Object getId();
        /**
         * ``BucketResource.RuleProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-id
         */
        void setId(final java.lang.String value);
        /**
         * ``BucketResource.RuleProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-id
         */
        void setId(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RuleProperty.NoncurrentVersionExpirationInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
         */
        java.lang.Object getNoncurrentVersionExpirationInDays();
        /**
         * ``BucketResource.RuleProperty.NoncurrentVersionExpirationInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
         */
        void setNoncurrentVersionExpirationInDays(final java.lang.Number value);
        /**
         * ``BucketResource.RuleProperty.NoncurrentVersionExpirationInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
         */
        void setNoncurrentVersionExpirationInDays(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RuleProperty.NoncurrentVersionTransition``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
         */
        java.lang.Object getNoncurrentVersionTransition();
        /**
         * ``BucketResource.RuleProperty.NoncurrentVersionTransition``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
         */
        void setNoncurrentVersionTransition(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RuleProperty.NoncurrentVersionTransition``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
         */
        void setNoncurrentVersionTransition(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NoncurrentVersionTransitionProperty value);
        /**
         * ``BucketResource.RuleProperty.NoncurrentVersionTransitions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
         */
        java.lang.Object getNoncurrentVersionTransitions();
        /**
         * ``BucketResource.RuleProperty.NoncurrentVersionTransitions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
         */
        void setNoncurrentVersionTransitions(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RuleProperty.NoncurrentVersionTransitions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
         */
        void setNoncurrentVersionTransitions(final java.util.List<java.lang.Object> value);
        /**
         * ``BucketResource.RuleProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-prefix
         */
        java.lang.Object getPrefix();
        /**
         * ``BucketResource.RuleProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-prefix
         */
        void setPrefix(final java.lang.String value);
        /**
         * ``BucketResource.RuleProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-prefix
         */
        void setPrefix(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RuleProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-status
         */
        java.lang.Object getStatus();
        /**
         * ``BucketResource.RuleProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-status
         */
        void setStatus(final java.lang.String value);
        /**
         * ``BucketResource.RuleProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-status
         */
        void setStatus(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RuleProperty.TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
         */
        java.lang.Object getTagFilters();
        /**
         * ``BucketResource.RuleProperty.TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
         */
        void setTagFilters(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RuleProperty.TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
         */
        void setTagFilters(final java.util.List<java.lang.Object> value);
        /**
         * ``BucketResource.RuleProperty.Transition``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
         */
        java.lang.Object getTransition();
        /**
         * ``BucketResource.RuleProperty.Transition``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
         */
        void setTransition(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RuleProperty.Transition``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
         */
        void setTransition(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.TransitionProperty value);
        /**
         * ``BucketResource.RuleProperty.Transitions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
         */
        java.lang.Object getTransitions();
        /**
         * ``BucketResource.RuleProperty.Transitions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
         */
        void setTransitions(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RuleProperty.Transitions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
         */
        void setTransitions(final java.util.List<java.lang.Object> value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link RuleProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.RuleProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-status
             */
            public Build withStatus(final java.lang.String value) {
                return new FullBuilder().withStatus(value);
            }
            /**
             * ``BucketResource.RuleProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-status
             */
            public Build withStatus(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withStatus(value);
            }

            public interface Build {
                /**
                 * @return a new {@link RuleProperty} object, initialized with the values set on this builder.
                 */
                RuleProperty build();
                /**
                 * ``BucketResource.RuleProperty.AbortIncompleteMultipartUpload``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
                 */
                Build withAbortIncompleteMultipartUpload(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.RuleProperty.AbortIncompleteMultipartUpload``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
                 */
                Build withAbortIncompleteMultipartUpload(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.AbortIncompleteMultipartUploadProperty value);
                /**
                 * ``BucketResource.RuleProperty.ExpirationDate``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
                 */
                Build withExpirationDate(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.RuleProperty.ExpirationDate``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
                 */
                Build withExpirationDate(final java.time.Instant value);
                /**
                 * ``BucketResource.RuleProperty.ExpirationInDays``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
                 */
                Build withExpirationInDays(final java.lang.Number value);
                /**
                 * ``BucketResource.RuleProperty.ExpirationInDays``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
                 */
                Build withExpirationInDays(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.RuleProperty.Id``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-id
                 */
                Build withId(final java.lang.String value);
                /**
                 * ``BucketResource.RuleProperty.Id``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-id
                 */
                Build withId(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.RuleProperty.NoncurrentVersionExpirationInDays``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
                 */
                Build withNoncurrentVersionExpirationInDays(final java.lang.Number value);
                /**
                 * ``BucketResource.RuleProperty.NoncurrentVersionExpirationInDays``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
                 */
                Build withNoncurrentVersionExpirationInDays(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.RuleProperty.NoncurrentVersionTransition``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
                 */
                Build withNoncurrentVersionTransition(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.RuleProperty.NoncurrentVersionTransition``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
                 */
                Build withNoncurrentVersionTransition(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NoncurrentVersionTransitionProperty value);
                /**
                 * ``BucketResource.RuleProperty.NoncurrentVersionTransitions``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
                 */
                Build withNoncurrentVersionTransitions(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.RuleProperty.NoncurrentVersionTransitions``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
                 */
                Build withNoncurrentVersionTransitions(final java.util.List<java.lang.Object> value);
                /**
                 * ``BucketResource.RuleProperty.Prefix``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-prefix
                 */
                Build withPrefix(final java.lang.String value);
                /**
                 * ``BucketResource.RuleProperty.Prefix``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-prefix
                 */
                Build withPrefix(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.RuleProperty.TagFilters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
                 */
                Build withTagFilters(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.RuleProperty.TagFilters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
                 */
                Build withTagFilters(final java.util.List<java.lang.Object> value);
                /**
                 * ``BucketResource.RuleProperty.Transition``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
                 */
                Build withTransition(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.RuleProperty.Transition``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
                 */
                Build withTransition(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.TransitionProperty value);
                /**
                 * ``BucketResource.RuleProperty.Transitions``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
                 */
                Build withTransitions(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.RuleProperty.Transitions``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
                 */
                Build withTransitions(final java.util.List<java.lang.Object> value);
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.RuleProperty.AbortIncompleteMultipartUpload``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
                 */
                public Build withAbortIncompleteMultipartUpload(final software.amazon.awscdk.Token value) {
                    this.instance._abortIncompleteMultipartUpload = value;
                    return this;
                }
                /**
                 * ``BucketResource.RuleProperty.AbortIncompleteMultipartUpload``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
                 */
                public Build withAbortIncompleteMultipartUpload(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.AbortIncompleteMultipartUploadProperty value) {
                    this.instance._abortIncompleteMultipartUpload = value;
                    return this;
                }
                /**
                 * ``BucketResource.RuleProperty.ExpirationDate``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
                 */
                public Build withExpirationDate(final software.amazon.awscdk.Token value) {
                    this.instance._expirationDate = value;
                    return this;
                }
                /**
                 * ``BucketResource.RuleProperty.ExpirationDate``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
                 */
                public Build withExpirationDate(final java.time.Instant value) {
                    this.instance._expirationDate = value;
                    return this;
                }
                /**
                 * ``BucketResource.RuleProperty.ExpirationInDays``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
                 */
                public Build withExpirationInDays(final java.lang.Number value) {
                    this.instance._expirationInDays = value;
                    return this;
                }
                /**
                 * ``BucketResource.RuleProperty.ExpirationInDays``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
                 */
                public Build withExpirationInDays(final software.amazon.awscdk.Token value) {
                    this.instance._expirationInDays = value;
                    return this;
                }
                /**
                 * ``BucketResource.RuleProperty.Id``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-id
                 */
                public Build withId(final java.lang.String value) {
                    this.instance._id = value;
                    return this;
                }
                /**
                 * ``BucketResource.RuleProperty.Id``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-id
                 */
                public Build withId(final software.amazon.awscdk.Token value) {
                    this.instance._id = value;
                    return this;
                }
                /**
                 * ``BucketResource.RuleProperty.NoncurrentVersionExpirationInDays``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
                 */
                public Build withNoncurrentVersionExpirationInDays(final java.lang.Number value) {
                    this.instance._noncurrentVersionExpirationInDays = value;
                    return this;
                }
                /**
                 * ``BucketResource.RuleProperty.NoncurrentVersionExpirationInDays``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
                 */
                public Build withNoncurrentVersionExpirationInDays(final software.amazon.awscdk.Token value) {
                    this.instance._noncurrentVersionExpirationInDays = value;
                    return this;
                }
                /**
                 * ``BucketResource.RuleProperty.NoncurrentVersionTransition``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
                 */
                public Build withNoncurrentVersionTransition(final software.amazon.awscdk.Token value) {
                    this.instance._noncurrentVersionTransition = value;
                    return this;
                }
                /**
                 * ``BucketResource.RuleProperty.NoncurrentVersionTransition``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
                 */
                public Build withNoncurrentVersionTransition(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NoncurrentVersionTransitionProperty value) {
                    this.instance._noncurrentVersionTransition = value;
                    return this;
                }
                /**
                 * ``BucketResource.RuleProperty.NoncurrentVersionTransitions``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
                 */
                public Build withNoncurrentVersionTransitions(final software.amazon.awscdk.Token value) {
                    this.instance._noncurrentVersionTransitions = value;
                    return this;
                }
                /**
                 * ``BucketResource.RuleProperty.NoncurrentVersionTransitions``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
                 */
                public Build withNoncurrentVersionTransitions(final java.util.List<java.lang.Object> value) {
                    this.instance._noncurrentVersionTransitions = value;
                    return this;
                }
                /**
                 * ``BucketResource.RuleProperty.Prefix``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-prefix
                 */
                public Build withPrefix(final java.lang.String value) {
                    this.instance._prefix = value;
                    return this;
                }
                /**
                 * ``BucketResource.RuleProperty.Prefix``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-prefix
                 */
                public Build withPrefix(final software.amazon.awscdk.Token value) {
                    this.instance._prefix = value;
                    return this;
                }
                /**
                 * ``BucketResource.RuleProperty.Status``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-status
                 */
                public Build withStatus(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "RuleProperty#status is required");
                    this.instance._status = value;
                    return this;
                }
                /**
                 * ``BucketResource.RuleProperty.Status``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-status
                 */
                public Build withStatus(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "RuleProperty#status is required");
                    this.instance._status = value;
                    return this;
                }
                /**
                 * ``BucketResource.RuleProperty.TagFilters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
                 */
                public Build withTagFilters(final software.amazon.awscdk.Token value) {
                    this.instance._tagFilters = value;
                    return this;
                }
                /**
                 * ``BucketResource.RuleProperty.TagFilters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
                 */
                public Build withTagFilters(final java.util.List<java.lang.Object> value) {
                    this.instance._tagFilters = value;
                    return this;
                }
                /**
                 * ``BucketResource.RuleProperty.Transition``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
                 */
                public Build withTransition(final software.amazon.awscdk.Token value) {
                    this.instance._transition = value;
                    return this;
                }
                /**
                 * ``BucketResource.RuleProperty.Transition``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
                 */
                public Build withTransition(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.TransitionProperty value) {
                    this.instance._transition = value;
                    return this;
                }
                /**
                 * ``BucketResource.RuleProperty.Transitions``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
                 */
                public Build withTransitions(final software.amazon.awscdk.Token value) {
                    this.instance._transitions = value;
                    return this;
                }
                /**
                 * ``BucketResource.RuleProperty.Transitions``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
                 */
                public Build withTransitions(final java.util.List<java.lang.Object> value) {
                    this.instance._transitions = value;
                    return this;
                }
                public RuleProperty build() {
                    RuleProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link RuleProperty}.
         */
        final class Jsii$Pojo implements RuleProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _abortIncompleteMultipartUpload;

            public java.lang.Object getAbortIncompleteMultipartUpload() {
                return this._abortIncompleteMultipartUpload;
            }
            public void setAbortIncompleteMultipartUpload(final software.amazon.awscdk.Token value) {
                this._abortIncompleteMultipartUpload = value;
            }
            public void setAbortIncompleteMultipartUpload(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.AbortIncompleteMultipartUploadProperty value) {
                this._abortIncompleteMultipartUpload = value;
            }

            protected java.lang.Object _expirationDate;

            public java.lang.Object getExpirationDate() {
                return this._expirationDate;
            }
            public void setExpirationDate(final software.amazon.awscdk.Token value) {
                this._expirationDate = value;
            }
            public void setExpirationDate(final java.time.Instant value) {
                this._expirationDate = value;
            }

            protected java.lang.Object _expirationInDays;

            public java.lang.Object getExpirationInDays() {
                return this._expirationInDays;
            }
            public void setExpirationInDays(final java.lang.Number value) {
                this._expirationInDays = value;
            }
            public void setExpirationInDays(final software.amazon.awscdk.Token value) {
                this._expirationInDays = value;
            }

            protected java.lang.Object _id;

            public java.lang.Object getId() {
                return this._id;
            }
            public void setId(final java.lang.String value) {
                this._id = value;
            }
            public void setId(final software.amazon.awscdk.Token value) {
                this._id = value;
            }

            protected java.lang.Object _noncurrentVersionExpirationInDays;

            public java.lang.Object getNoncurrentVersionExpirationInDays() {
                return this._noncurrentVersionExpirationInDays;
            }
            public void setNoncurrentVersionExpirationInDays(final java.lang.Number value) {
                this._noncurrentVersionExpirationInDays = value;
            }
            public void setNoncurrentVersionExpirationInDays(final software.amazon.awscdk.Token value) {
                this._noncurrentVersionExpirationInDays = value;
            }

            protected java.lang.Object _noncurrentVersionTransition;

            public java.lang.Object getNoncurrentVersionTransition() {
                return this._noncurrentVersionTransition;
            }
            public void setNoncurrentVersionTransition(final software.amazon.awscdk.Token value) {
                this._noncurrentVersionTransition = value;
            }
            public void setNoncurrentVersionTransition(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NoncurrentVersionTransitionProperty value) {
                this._noncurrentVersionTransition = value;
            }

            protected java.lang.Object _noncurrentVersionTransitions;

            public java.lang.Object getNoncurrentVersionTransitions() {
                return this._noncurrentVersionTransitions;
            }
            public void setNoncurrentVersionTransitions(final software.amazon.awscdk.Token value) {
                this._noncurrentVersionTransitions = value;
            }
            public void setNoncurrentVersionTransitions(final java.util.List<java.lang.Object> value) {
                this._noncurrentVersionTransitions = value;
            }

            protected java.lang.Object _prefix;

            public java.lang.Object getPrefix() {
                return this._prefix;
            }
            public void setPrefix(final java.lang.String value) {
                this._prefix = value;
            }
            public void setPrefix(final software.amazon.awscdk.Token value) {
                this._prefix = value;
            }

            protected java.lang.Object _status;

            public java.lang.Object getStatus() {
                return this._status;
            }
            public void setStatus(final java.lang.String value) {
                this._status = value;
            }
            public void setStatus(final software.amazon.awscdk.Token value) {
                this._status = value;
            }

            protected java.lang.Object _tagFilters;

            public java.lang.Object getTagFilters() {
                return this._tagFilters;
            }
            public void setTagFilters(final software.amazon.awscdk.Token value) {
                this._tagFilters = value;
            }
            public void setTagFilters(final java.util.List<java.lang.Object> value) {
                this._tagFilters = value;
            }

            protected java.lang.Object _transition;

            public java.lang.Object getTransition() {
                return this._transition;
            }
            public void setTransition(final software.amazon.awscdk.Token value) {
                this._transition = value;
            }
            public void setTransition(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.TransitionProperty value) {
                this._transition = value;
            }

            protected java.lang.Object _transitions;

            public java.lang.Object getTransitions() {
                return this._transitions;
            }
            public void setTransitions(final software.amazon.awscdk.Token value) {
                this._transitions = value;
            }
            public void setTransitions(final java.util.List<java.lang.Object> value) {
                this._transitions = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.RuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.RuleProperty.AbortIncompleteMultipartUpload``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
             */
            @javax.annotation.Nullable
            public java.lang.Object getAbortIncompleteMultipartUpload() {
                return this.jsiiGet("abortIncompleteMultipartUpload", java.lang.Object.class);
            }
            /**
             * ``BucketResource.RuleProperty.AbortIncompleteMultipartUpload``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
             */
            public void setAbortIncompleteMultipartUpload(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("abortIncompleteMultipartUpload", value);
            }
            /**
             * ``BucketResource.RuleProperty.AbortIncompleteMultipartUpload``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
             */
            public void setAbortIncompleteMultipartUpload(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.AbortIncompleteMultipartUploadProperty value) {
                this.jsiiSet("abortIncompleteMultipartUpload", value);
            }
            /**
             * ``BucketResource.RuleProperty.ExpirationDate``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
             */
            @javax.annotation.Nullable
            public java.lang.Object getExpirationDate() {
                return this.jsiiGet("expirationDate", java.lang.Object.class);
            }
            /**
             * ``BucketResource.RuleProperty.ExpirationDate``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
             */
            public void setExpirationDate(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("expirationDate", value);
            }
            /**
             * ``BucketResource.RuleProperty.ExpirationDate``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
             */
            public void setExpirationDate(@javax.annotation.Nullable final java.time.Instant value) {
                this.jsiiSet("expirationDate", value);
            }
            /**
             * ``BucketResource.RuleProperty.ExpirationInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
             */
            @javax.annotation.Nullable
            public java.lang.Object getExpirationInDays() {
                return this.jsiiGet("expirationInDays", java.lang.Object.class);
            }
            /**
             * ``BucketResource.RuleProperty.ExpirationInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
             */
            public void setExpirationInDays(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("expirationInDays", value);
            }
            /**
             * ``BucketResource.RuleProperty.ExpirationInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
             */
            public void setExpirationInDays(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("expirationInDays", value);
            }
            /**
             * ``BucketResource.RuleProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-id
             */
            @javax.annotation.Nullable
            public java.lang.Object getId() {
                return this.jsiiGet("id", java.lang.Object.class);
            }
            /**
             * ``BucketResource.RuleProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-id
             */
            public void setId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("id", value);
            }
            /**
             * ``BucketResource.RuleProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-id
             */
            public void setId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("id", value);
            }
            /**
             * ``BucketResource.RuleProperty.NoncurrentVersionExpirationInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
             */
            @javax.annotation.Nullable
            public java.lang.Object getNoncurrentVersionExpirationInDays() {
                return this.jsiiGet("noncurrentVersionExpirationInDays", java.lang.Object.class);
            }
            /**
             * ``BucketResource.RuleProperty.NoncurrentVersionExpirationInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
             */
            public void setNoncurrentVersionExpirationInDays(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("noncurrentVersionExpirationInDays", value);
            }
            /**
             * ``BucketResource.RuleProperty.NoncurrentVersionExpirationInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
             */
            public void setNoncurrentVersionExpirationInDays(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("noncurrentVersionExpirationInDays", value);
            }
            /**
             * ``BucketResource.RuleProperty.NoncurrentVersionTransition``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
             */
            @javax.annotation.Nullable
            public java.lang.Object getNoncurrentVersionTransition() {
                return this.jsiiGet("noncurrentVersionTransition", java.lang.Object.class);
            }
            /**
             * ``BucketResource.RuleProperty.NoncurrentVersionTransition``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
             */
            public void setNoncurrentVersionTransition(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("noncurrentVersionTransition", value);
            }
            /**
             * ``BucketResource.RuleProperty.NoncurrentVersionTransition``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
             */
            public void setNoncurrentVersionTransition(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NoncurrentVersionTransitionProperty value) {
                this.jsiiSet("noncurrentVersionTransition", value);
            }
            /**
             * ``BucketResource.RuleProperty.NoncurrentVersionTransitions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
             */
            @javax.annotation.Nullable
            public java.lang.Object getNoncurrentVersionTransitions() {
                return this.jsiiGet("noncurrentVersionTransitions", java.lang.Object.class);
            }
            /**
             * ``BucketResource.RuleProperty.NoncurrentVersionTransitions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
             */
            public void setNoncurrentVersionTransitions(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("noncurrentVersionTransitions", value);
            }
            /**
             * ``BucketResource.RuleProperty.NoncurrentVersionTransitions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
             */
            public void setNoncurrentVersionTransitions(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("noncurrentVersionTransitions", value);
            }
            /**
             * ``BucketResource.RuleProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-prefix
             */
            @javax.annotation.Nullable
            public java.lang.Object getPrefix() {
                return this.jsiiGet("prefix", java.lang.Object.class);
            }
            /**
             * ``BucketResource.RuleProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-prefix
             */
            public void setPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("prefix", value);
            }
            /**
             * ``BucketResource.RuleProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-prefix
             */
            public void setPrefix(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("prefix", value);
            }
            /**
             * ``BucketResource.RuleProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-status
             */
            public java.lang.Object getStatus() {
                return this.jsiiGet("status", java.lang.Object.class);
            }
            /**
             * ``BucketResource.RuleProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-status
             */
            public void setStatus(final java.lang.String value) {
                this.jsiiSet("status", java.util.Objects.requireNonNull(value, "status is required"));
            }
            /**
             * ``BucketResource.RuleProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-status
             */
            public void setStatus(final software.amazon.awscdk.Token value) {
                this.jsiiSet("status", java.util.Objects.requireNonNull(value, "status is required"));
            }
            /**
             * ``BucketResource.RuleProperty.TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
             */
            @javax.annotation.Nullable
            public java.lang.Object getTagFilters() {
                return this.jsiiGet("tagFilters", java.lang.Object.class);
            }
            /**
             * ``BucketResource.RuleProperty.TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
             */
            public void setTagFilters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("tagFilters", value);
            }
            /**
             * ``BucketResource.RuleProperty.TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
             */
            public void setTagFilters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("tagFilters", value);
            }
            /**
             * ``BucketResource.RuleProperty.Transition``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
             */
            @javax.annotation.Nullable
            public java.lang.Object getTransition() {
                return this.jsiiGet("transition", java.lang.Object.class);
            }
            /**
             * ``BucketResource.RuleProperty.Transition``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
             */
            public void setTransition(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("transition", value);
            }
            /**
             * ``BucketResource.RuleProperty.Transition``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
             */
            public void setTransition(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.TransitionProperty value) {
                this.jsiiSet("transition", value);
            }
            /**
             * ``BucketResource.RuleProperty.Transitions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
             */
            @javax.annotation.Nullable
            public java.lang.Object getTransitions() {
                return this.jsiiGet("transitions", java.lang.Object.class);
            }
            /**
             * ``BucketResource.RuleProperty.Transitions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
             */
            public void setTransitions(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("transitions", value);
            }
            /**
             * ``BucketResource.RuleProperty.Transitions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
             */
            public void setTransitions(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("transitions", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html
     */
    public static interface S3KeyFilterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.S3KeyFilterProperty.Rules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
         */
        java.lang.Object getRules();
        /**
         * ``BucketResource.S3KeyFilterProperty.Rules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
         */
        void setRules(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.S3KeyFilterProperty.Rules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
         */
        void setRules(final java.util.List<java.lang.Object> value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link S3KeyFilterProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.S3KeyFilterProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
             */
            public Build withRules(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withRules(value);
            }
            /**
             * ``BucketResource.S3KeyFilterProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
             */
            public Build withRules(final java.util.List<java.lang.Object> value) {
                return new FullBuilder().withRules(value);
            }

            public interface Build {
                /**
                 * @return a new {@link S3KeyFilterProperty} object, initialized with the values set on this builder.
                 */
                S3KeyFilterProperty build();
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.S3KeyFilterProperty.Rules``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
                 */
                public Build withRules(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "S3KeyFilterProperty#rules is required");
                    this.instance._rules = value;
                    return this;
                }
                /**
                 * ``BucketResource.S3KeyFilterProperty.Rules``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
                 */
                public Build withRules(final java.util.List<java.lang.Object> value) {
                    java.util.Objects.requireNonNull(value, "S3KeyFilterProperty#rules is required");
                    this.instance._rules = value;
                    return this;
                }
                public S3KeyFilterProperty build() {
                    S3KeyFilterProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link S3KeyFilterProperty}.
         */
        final class Jsii$Pojo implements S3KeyFilterProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _rules;

            public java.lang.Object getRules() {
                return this._rules;
            }
            public void setRules(final software.amazon.awscdk.Token value) {
                this._rules = value;
            }
            public void setRules(final java.util.List<java.lang.Object> value) {
                this._rules = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.S3KeyFilterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.S3KeyFilterProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
             */
            public java.lang.Object getRules() {
                return this.jsiiGet("rules", java.lang.Object.class);
            }
            /**
             * ``BucketResource.S3KeyFilterProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
             */
            public void setRules(final software.amazon.awscdk.Token value) {
                this.jsiiSet("rules", java.util.Objects.requireNonNull(value, "rules is required"));
            }
            /**
             * ``BucketResource.S3KeyFilterProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
             */
            public void setRules(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("rules", java.util.Objects.requireNonNull(value, "rules is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html
     */
    public static interface ServerSideEncryptionByDefaultProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-kmsmasterkeyid
         */
        java.lang.Object getKmsMasterKeyId();
        /**
         * ``BucketResource.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-kmsmasterkeyid
         */
        void setKmsMasterKeyId(final java.lang.String value);
        /**
         * ``BucketResource.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-kmsmasterkeyid
         */
        void setKmsMasterKeyId(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.ServerSideEncryptionByDefaultProperty.SSEAlgorithm``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-ssealgorithm
         */
        java.lang.Object getSseAlgorithm();
        /**
         * ``BucketResource.ServerSideEncryptionByDefaultProperty.SSEAlgorithm``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-ssealgorithm
         */
        void setSseAlgorithm(final java.lang.String value);
        /**
         * ``BucketResource.ServerSideEncryptionByDefaultProperty.SSEAlgorithm``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-ssealgorithm
         */
        void setSseAlgorithm(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link ServerSideEncryptionByDefaultProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.ServerSideEncryptionByDefaultProperty.SSEAlgorithm``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-ssealgorithm
             */
            public Build withSseAlgorithm(final java.lang.String value) {
                return new FullBuilder().withSseAlgorithm(value);
            }
            /**
             * ``BucketResource.ServerSideEncryptionByDefaultProperty.SSEAlgorithm``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-ssealgorithm
             */
            public Build withSseAlgorithm(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withSseAlgorithm(value);
            }

            public interface Build {
                /**
                 * @return a new {@link ServerSideEncryptionByDefaultProperty} object, initialized with the values set on this builder.
                 */
                ServerSideEncryptionByDefaultProperty build();
                /**
                 * ``BucketResource.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-kmsmasterkeyid
                 */
                Build withKmsMasterKeyId(final java.lang.String value);
                /**
                 * ``BucketResource.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-kmsmasterkeyid
                 */
                Build withKmsMasterKeyId(final software.amazon.awscdk.Token value);
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-kmsmasterkeyid
                 */
                public Build withKmsMasterKeyId(final java.lang.String value) {
                    this.instance._kmsMasterKeyId = value;
                    return this;
                }
                /**
                 * ``BucketResource.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-kmsmasterkeyid
                 */
                public Build withKmsMasterKeyId(final software.amazon.awscdk.Token value) {
                    this.instance._kmsMasterKeyId = value;
                    return this;
                }
                /**
                 * ``BucketResource.ServerSideEncryptionByDefaultProperty.SSEAlgorithm``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-ssealgorithm
                 */
                public Build withSseAlgorithm(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "ServerSideEncryptionByDefaultProperty#sseAlgorithm is required");
                    this.instance._sseAlgorithm = value;
                    return this;
                }
                /**
                 * ``BucketResource.ServerSideEncryptionByDefaultProperty.SSEAlgorithm``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-ssealgorithm
                 */
                public Build withSseAlgorithm(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "ServerSideEncryptionByDefaultProperty#sseAlgorithm is required");
                    this.instance._sseAlgorithm = value;
                    return this;
                }
                public ServerSideEncryptionByDefaultProperty build() {
                    ServerSideEncryptionByDefaultProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link ServerSideEncryptionByDefaultProperty}.
         */
        final class Jsii$Pojo implements ServerSideEncryptionByDefaultProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _kmsMasterKeyId;

            public java.lang.Object getKmsMasterKeyId() {
                return this._kmsMasterKeyId;
            }
            public void setKmsMasterKeyId(final java.lang.String value) {
                this._kmsMasterKeyId = value;
            }
            public void setKmsMasterKeyId(final software.amazon.awscdk.Token value) {
                this._kmsMasterKeyId = value;
            }

            protected java.lang.Object _sseAlgorithm;

            public java.lang.Object getSseAlgorithm() {
                return this._sseAlgorithm;
            }
            public void setSseAlgorithm(final java.lang.String value) {
                this._sseAlgorithm = value;
            }
            public void setSseAlgorithm(final software.amazon.awscdk.Token value) {
                this._sseAlgorithm = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.ServerSideEncryptionByDefaultProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-kmsmasterkeyid
             */
            @javax.annotation.Nullable
            public java.lang.Object getKmsMasterKeyId() {
                return this.jsiiGet("kmsMasterKeyId", java.lang.Object.class);
            }
            /**
             * ``BucketResource.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-kmsmasterkeyid
             */
            public void setKmsMasterKeyId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("kmsMasterKeyId", value);
            }
            /**
             * ``BucketResource.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-kmsmasterkeyid
             */
            public void setKmsMasterKeyId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("kmsMasterKeyId", value);
            }
            /**
             * ``BucketResource.ServerSideEncryptionByDefaultProperty.SSEAlgorithm``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-ssealgorithm
             */
            public java.lang.Object getSseAlgorithm() {
                return this.jsiiGet("sseAlgorithm", java.lang.Object.class);
            }
            /**
             * ``BucketResource.ServerSideEncryptionByDefaultProperty.SSEAlgorithm``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-ssealgorithm
             */
            public void setSseAlgorithm(final java.lang.String value) {
                this.jsiiSet("sseAlgorithm", java.util.Objects.requireNonNull(value, "sseAlgorithm is required"));
            }
            /**
             * ``BucketResource.ServerSideEncryptionByDefaultProperty.SSEAlgorithm``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-ssealgorithm
             */
            public void setSseAlgorithm(final software.amazon.awscdk.Token value) {
                this.jsiiSet("sseAlgorithm", java.util.Objects.requireNonNull(value, "sseAlgorithm is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html
     */
    public static interface ServerSideEncryptionRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-serversideencryptionbydefault
         */
        java.lang.Object getServerSideEncryptionByDefault();
        /**
         * ``BucketResource.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-serversideencryptionbydefault
         */
        void setServerSideEncryptionByDefault(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-serversideencryptionbydefault
         */
        void setServerSideEncryptionByDefault(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.ServerSideEncryptionByDefaultProperty value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link ServerSideEncryptionRuleProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``BucketResource.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-serversideencryptionbydefault
             */
            public Builder withServerSideEncryptionByDefault(final software.amazon.awscdk.Token value) {
                this.instance._serverSideEncryptionByDefault = value;
                return this;
            }
            /**
             * ``BucketResource.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-serversideencryptionbydefault
             */
            public Builder withServerSideEncryptionByDefault(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.ServerSideEncryptionByDefaultProperty value) {
                this.instance._serverSideEncryptionByDefault = value;
                return this;
            }
            public ServerSideEncryptionRuleProperty build() {
                ServerSideEncryptionRuleProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link ServerSideEncryptionRuleProperty}.
         */
        final class Jsii$Pojo implements ServerSideEncryptionRuleProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _serverSideEncryptionByDefault;

            public java.lang.Object getServerSideEncryptionByDefault() {
                return this._serverSideEncryptionByDefault;
            }
            public void setServerSideEncryptionByDefault(final software.amazon.awscdk.Token value) {
                this._serverSideEncryptionByDefault = value;
            }
            public void setServerSideEncryptionByDefault(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.ServerSideEncryptionByDefaultProperty value) {
                this._serverSideEncryptionByDefault = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.ServerSideEncryptionRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-serversideencryptionbydefault
             */
            @javax.annotation.Nullable
            public java.lang.Object getServerSideEncryptionByDefault() {
                return this.jsiiGet("serverSideEncryptionByDefault", java.lang.Object.class);
            }
            /**
             * ``BucketResource.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-serversideencryptionbydefault
             */
            public void setServerSideEncryptionByDefault(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("serverSideEncryptionByDefault", value);
            }
            /**
             * ``BucketResource.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-serversideencryptionbydefault
             */
            public void setServerSideEncryptionByDefault(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.ServerSideEncryptionByDefaultProperty value) {
                this.jsiiSet("serverSideEncryptionByDefault", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html
     */
    public static interface SourceSelectionCriteriaProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
         */
        java.lang.Object getSseKmsEncryptedObjects();
        /**
         * ``BucketResource.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
         */
        void setSseKmsEncryptedObjects(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
         */
        void setSseKmsEncryptedObjects(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.SseKmsEncryptedObjectsProperty value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link SourceSelectionCriteriaProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
             */
            public Build withSseKmsEncryptedObjects(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withSseKmsEncryptedObjects(value);
            }
            /**
             * ``BucketResource.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
             */
            public Build withSseKmsEncryptedObjects(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.SseKmsEncryptedObjectsProperty value) {
                return new FullBuilder().withSseKmsEncryptedObjects(value);
            }

            public interface Build {
                /**
                 * @return a new {@link SourceSelectionCriteriaProperty} object, initialized with the values set on this builder.
                 */
                SourceSelectionCriteriaProperty build();
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
                 */
                public Build withSseKmsEncryptedObjects(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "SourceSelectionCriteriaProperty#sseKmsEncryptedObjects is required");
                    this.instance._sseKmsEncryptedObjects = value;
                    return this;
                }
                /**
                 * ``BucketResource.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
                 */
                public Build withSseKmsEncryptedObjects(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.SseKmsEncryptedObjectsProperty value) {
                    java.util.Objects.requireNonNull(value, "SourceSelectionCriteriaProperty#sseKmsEncryptedObjects is required");
                    this.instance._sseKmsEncryptedObjects = value;
                    return this;
                }
                public SourceSelectionCriteriaProperty build() {
                    SourceSelectionCriteriaProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link SourceSelectionCriteriaProperty}.
         */
        final class Jsii$Pojo implements SourceSelectionCriteriaProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _sseKmsEncryptedObjects;

            public java.lang.Object getSseKmsEncryptedObjects() {
                return this._sseKmsEncryptedObjects;
            }
            public void setSseKmsEncryptedObjects(final software.amazon.awscdk.Token value) {
                this._sseKmsEncryptedObjects = value;
            }
            public void setSseKmsEncryptedObjects(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.SseKmsEncryptedObjectsProperty value) {
                this._sseKmsEncryptedObjects = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.SourceSelectionCriteriaProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
             */
            public java.lang.Object getSseKmsEncryptedObjects() {
                return this.jsiiGet("sseKmsEncryptedObjects", java.lang.Object.class);
            }
            /**
             * ``BucketResource.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
             */
            public void setSseKmsEncryptedObjects(final software.amazon.awscdk.Token value) {
                this.jsiiSet("sseKmsEncryptedObjects", java.util.Objects.requireNonNull(value, "sseKmsEncryptedObjects is required"));
            }
            /**
             * ``BucketResource.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
             */
            public void setSseKmsEncryptedObjects(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.SseKmsEncryptedObjectsProperty value) {
                this.jsiiSet("sseKmsEncryptedObjects", java.util.Objects.requireNonNull(value, "sseKmsEncryptedObjects is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html
     */
    public static interface SseKmsEncryptedObjectsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.SseKmsEncryptedObjectsProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html#cfn-s3-bucket-ssekmsencryptedobjects-status
         */
        java.lang.Object getStatus();
        /**
         * ``BucketResource.SseKmsEncryptedObjectsProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html#cfn-s3-bucket-ssekmsencryptedobjects-status
         */
        void setStatus(final java.lang.String value);
        /**
         * ``BucketResource.SseKmsEncryptedObjectsProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html#cfn-s3-bucket-ssekmsencryptedobjects-status
         */
        void setStatus(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link SseKmsEncryptedObjectsProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.SseKmsEncryptedObjectsProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html#cfn-s3-bucket-ssekmsencryptedobjects-status
             */
            public Build withStatus(final java.lang.String value) {
                return new FullBuilder().withStatus(value);
            }
            /**
             * ``BucketResource.SseKmsEncryptedObjectsProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html#cfn-s3-bucket-ssekmsencryptedobjects-status
             */
            public Build withStatus(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withStatus(value);
            }

            public interface Build {
                /**
                 * @return a new {@link SseKmsEncryptedObjectsProperty} object, initialized with the values set on this builder.
                 */
                SseKmsEncryptedObjectsProperty build();
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.SseKmsEncryptedObjectsProperty.Status``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html#cfn-s3-bucket-ssekmsencryptedobjects-status
                 */
                public Build withStatus(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "SseKmsEncryptedObjectsProperty#status is required");
                    this.instance._status = value;
                    return this;
                }
                /**
                 * ``BucketResource.SseKmsEncryptedObjectsProperty.Status``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html#cfn-s3-bucket-ssekmsencryptedobjects-status
                 */
                public Build withStatus(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "SseKmsEncryptedObjectsProperty#status is required");
                    this.instance._status = value;
                    return this;
                }
                public SseKmsEncryptedObjectsProperty build() {
                    SseKmsEncryptedObjectsProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link SseKmsEncryptedObjectsProperty}.
         */
        final class Jsii$Pojo implements SseKmsEncryptedObjectsProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _status;

            public java.lang.Object getStatus() {
                return this._status;
            }
            public void setStatus(final java.lang.String value) {
                this._status = value;
            }
            public void setStatus(final software.amazon.awscdk.Token value) {
                this._status = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.SseKmsEncryptedObjectsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.SseKmsEncryptedObjectsProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html#cfn-s3-bucket-ssekmsencryptedobjects-status
             */
            public java.lang.Object getStatus() {
                return this.jsiiGet("status", java.lang.Object.class);
            }
            /**
             * ``BucketResource.SseKmsEncryptedObjectsProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html#cfn-s3-bucket-ssekmsencryptedobjects-status
             */
            public void setStatus(final java.lang.String value) {
                this.jsiiSet("status", java.util.Objects.requireNonNull(value, "status is required"));
            }
            /**
             * ``BucketResource.SseKmsEncryptedObjectsProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html#cfn-s3-bucket-ssekmsencryptedobjects-status
             */
            public void setStatus(final software.amazon.awscdk.Token value) {
                this.jsiiSet("status", java.util.Objects.requireNonNull(value, "status is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html
     */
    public static interface StorageClassAnalysisProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.StorageClassAnalysisProperty.DataExport``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html#cfn-s3-bucket-storageclassanalysis-dataexport
         */
        java.lang.Object getDataExport();
        /**
         * ``BucketResource.StorageClassAnalysisProperty.DataExport``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html#cfn-s3-bucket-storageclassanalysis-dataexport
         */
        void setDataExport(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.StorageClassAnalysisProperty.DataExport``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html#cfn-s3-bucket-storageclassanalysis-dataexport
         */
        void setDataExport(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.DataExportProperty value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link StorageClassAnalysisProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``BucketResource.StorageClassAnalysisProperty.DataExport``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html#cfn-s3-bucket-storageclassanalysis-dataexport
             */
            public Builder withDataExport(final software.amazon.awscdk.Token value) {
                this.instance._dataExport = value;
                return this;
            }
            /**
             * ``BucketResource.StorageClassAnalysisProperty.DataExport``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html#cfn-s3-bucket-storageclassanalysis-dataexport
             */
            public Builder withDataExport(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.DataExportProperty value) {
                this.instance._dataExport = value;
                return this;
            }
            public StorageClassAnalysisProperty build() {
                StorageClassAnalysisProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link StorageClassAnalysisProperty}.
         */
        final class Jsii$Pojo implements StorageClassAnalysisProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _dataExport;

            public java.lang.Object getDataExport() {
                return this._dataExport;
            }
            public void setDataExport(final software.amazon.awscdk.Token value) {
                this._dataExport = value;
            }
            public void setDataExport(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.DataExportProperty value) {
                this._dataExport = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.StorageClassAnalysisProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.StorageClassAnalysisProperty.DataExport``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html#cfn-s3-bucket-storageclassanalysis-dataexport
             */
            @javax.annotation.Nullable
            public java.lang.Object getDataExport() {
                return this.jsiiGet("dataExport", java.lang.Object.class);
            }
            /**
             * ``BucketResource.StorageClassAnalysisProperty.DataExport``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html#cfn-s3-bucket-storageclassanalysis-dataexport
             */
            public void setDataExport(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("dataExport", value);
            }
            /**
             * ``BucketResource.StorageClassAnalysisProperty.DataExport``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html#cfn-s3-bucket-storageclassanalysis-dataexport
             */
            public void setDataExport(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.DataExportProperty value) {
                this.jsiiSet("dataExport", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html
     */
    public static interface TagFilterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.TagFilterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-key
         */
        java.lang.Object getKey();
        /**
         * ``BucketResource.TagFilterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-key
         */
        void setKey(final java.lang.String value);
        /**
         * ``BucketResource.TagFilterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-key
         */
        void setKey(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.TagFilterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-value
         */
        java.lang.Object getValue();
        /**
         * ``BucketResource.TagFilterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-value
         */
        void setValue(final java.lang.String value);
        /**
         * ``BucketResource.TagFilterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-value
         */
        void setValue(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link TagFilterProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-key
             */
            public ValueStep withKey(final java.lang.String value) {
                return new FullBuilder().withKey(value);
            }
            /**
             * ``BucketResource.TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-key
             */
            public ValueStep withKey(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withKey(value);
            }

            public interface ValueStep {
                /**
                 * ``BucketResource.TagFilterProperty.Value``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-value
                 */
                Build withValue(final java.lang.String value);
                /**
                 * ``BucketResource.TagFilterProperty.Value``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-value
                 */
                Build withValue(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link TagFilterProperty} object, initialized with the values set on this builder.
                 */
                TagFilterProperty build();
            }

            final class FullBuilder implements ValueStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.TagFilterProperty.Key``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-key
                 */
                public ValueStep withKey(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "TagFilterProperty#key is required");
                    this.instance._key = value;
                    return this;
                }
                /**
                 * ``BucketResource.TagFilterProperty.Key``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-key
                 */
                public ValueStep withKey(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "TagFilterProperty#key is required");
                    this.instance._key = value;
                    return this;
                }
                /**
                 * ``BucketResource.TagFilterProperty.Value``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-value
                 */
                public Build withValue(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "TagFilterProperty#value is required");
                    this.instance._value = value;
                    return this;
                }
                /**
                 * ``BucketResource.TagFilterProperty.Value``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-value
                 */
                public Build withValue(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "TagFilterProperty#value is required");
                    this.instance._value = value;
                    return this;
                }
                public TagFilterProperty build() {
                    TagFilterProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link TagFilterProperty}.
         */
        final class Jsii$Pojo implements TagFilterProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _key;

            public java.lang.Object getKey() {
                return this._key;
            }
            public void setKey(final java.lang.String value) {
                this._key = value;
            }
            public void setKey(final software.amazon.awscdk.Token value) {
                this._key = value;
            }

            protected java.lang.Object _value;

            public java.lang.Object getValue() {
                return this._value;
            }
            public void setValue(final java.lang.String value) {
                this._value = value;
            }
            public void setValue(final software.amazon.awscdk.Token value) {
                this._value = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.TagFilterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-key
             */
            public java.lang.Object getKey() {
                return this.jsiiGet("key", java.lang.Object.class);
            }
            /**
             * ``BucketResource.TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-key
             */
            public void setKey(final java.lang.String value) {
                this.jsiiSet("key", java.util.Objects.requireNonNull(value, "key is required"));
            }
            /**
             * ``BucketResource.TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-key
             */
            public void setKey(final software.amazon.awscdk.Token value) {
                this.jsiiSet("key", java.util.Objects.requireNonNull(value, "key is required"));
            }
            /**
             * ``BucketResource.TagFilterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-value
             */
            public java.lang.Object getValue() {
                return this.jsiiGet("value", java.lang.Object.class);
            }
            /**
             * ``BucketResource.TagFilterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-value
             */
            public void setValue(final java.lang.String value) {
                this.jsiiSet("value", java.util.Objects.requireNonNull(value, "value is required"));
            }
            /**
             * ``BucketResource.TagFilterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-value
             */
            public void setValue(final software.amazon.awscdk.Token value) {
                this.jsiiSet("value", java.util.Objects.requireNonNull(value, "value is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html
     */
    public static interface TopicConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.TopicConfigurationProperty.Event``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-event
         */
        java.lang.Object getEvent();
        /**
         * ``BucketResource.TopicConfigurationProperty.Event``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-event
         */
        void setEvent(final java.lang.String value);
        /**
         * ``BucketResource.TopicConfigurationProperty.Event``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-event
         */
        void setEvent(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.TopicConfigurationProperty.Filter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
         */
        java.lang.Object getFilter();
        /**
         * ``BucketResource.TopicConfigurationProperty.Filter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
         */
        void setFilter(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.TopicConfigurationProperty.Filter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
         */
        void setFilter(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationFilterProperty value);
        /**
         * ``BucketResource.TopicConfigurationProperty.Topic``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-topic
         */
        java.lang.Object getTopic();
        /**
         * ``BucketResource.TopicConfigurationProperty.Topic``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-topic
         */
        void setTopic(final java.lang.String value);
        /**
         * ``BucketResource.TopicConfigurationProperty.Topic``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-topic
         */
        void setTopic(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link TopicConfigurationProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.TopicConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-event
             */
            public TopicStep withEvent(final java.lang.String value) {
                return new FullBuilder().withEvent(value);
            }
            /**
             * ``BucketResource.TopicConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-event
             */
            public TopicStep withEvent(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withEvent(value);
            }

            public interface TopicStep {
                /**
                 * ``BucketResource.TopicConfigurationProperty.Topic``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-topic
                 */
                Build withTopic(final java.lang.String value);
                /**
                 * ``BucketResource.TopicConfigurationProperty.Topic``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-topic
                 */
                Build withTopic(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link TopicConfigurationProperty} object, initialized with the values set on this builder.
                 */
                TopicConfigurationProperty build();
                /**
                 * ``BucketResource.TopicConfigurationProperty.Filter``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
                 */
                Build withFilter(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.TopicConfigurationProperty.Filter``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
                 */
                Build withFilter(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationFilterProperty value);
            }

            final class FullBuilder implements TopicStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.TopicConfigurationProperty.Event``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-event
                 */
                public TopicStep withEvent(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "TopicConfigurationProperty#event is required");
                    this.instance._event = value;
                    return this;
                }
                /**
                 * ``BucketResource.TopicConfigurationProperty.Event``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-event
                 */
                public TopicStep withEvent(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "TopicConfigurationProperty#event is required");
                    this.instance._event = value;
                    return this;
                }
                /**
                 * ``BucketResource.TopicConfigurationProperty.Filter``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
                 */
                public Build withFilter(final software.amazon.awscdk.Token value) {
                    this.instance._filter = value;
                    return this;
                }
                /**
                 * ``BucketResource.TopicConfigurationProperty.Filter``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
                 */
                public Build withFilter(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationFilterProperty value) {
                    this.instance._filter = value;
                    return this;
                }
                /**
                 * ``BucketResource.TopicConfigurationProperty.Topic``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-topic
                 */
                public Build withTopic(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "TopicConfigurationProperty#topic is required");
                    this.instance._topic = value;
                    return this;
                }
                /**
                 * ``BucketResource.TopicConfigurationProperty.Topic``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-topic
                 */
                public Build withTopic(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "TopicConfigurationProperty#topic is required");
                    this.instance._topic = value;
                    return this;
                }
                public TopicConfigurationProperty build() {
                    TopicConfigurationProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link TopicConfigurationProperty}.
         */
        final class Jsii$Pojo implements TopicConfigurationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _event;

            public java.lang.Object getEvent() {
                return this._event;
            }
            public void setEvent(final java.lang.String value) {
                this._event = value;
            }
            public void setEvent(final software.amazon.awscdk.Token value) {
                this._event = value;
            }

            protected java.lang.Object _filter;

            public java.lang.Object getFilter() {
                return this._filter;
            }
            public void setFilter(final software.amazon.awscdk.Token value) {
                this._filter = value;
            }
            public void setFilter(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationFilterProperty value) {
                this._filter = value;
            }

            protected java.lang.Object _topic;

            public java.lang.Object getTopic() {
                return this._topic;
            }
            public void setTopic(final java.lang.String value) {
                this._topic = value;
            }
            public void setTopic(final software.amazon.awscdk.Token value) {
                this._topic = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.TopicConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.TopicConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-event
             */
            public java.lang.Object getEvent() {
                return this.jsiiGet("event", java.lang.Object.class);
            }
            /**
             * ``BucketResource.TopicConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-event
             */
            public void setEvent(final java.lang.String value) {
                this.jsiiSet("event", java.util.Objects.requireNonNull(value, "event is required"));
            }
            /**
             * ``BucketResource.TopicConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-event
             */
            public void setEvent(final software.amazon.awscdk.Token value) {
                this.jsiiSet("event", java.util.Objects.requireNonNull(value, "event is required"));
            }
            /**
             * ``BucketResource.TopicConfigurationProperty.Filter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
             */
            @javax.annotation.Nullable
            public java.lang.Object getFilter() {
                return this.jsiiGet("filter", java.lang.Object.class);
            }
            /**
             * ``BucketResource.TopicConfigurationProperty.Filter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
             */
            public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("filter", value);
            }
            /**
             * ``BucketResource.TopicConfigurationProperty.Filter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
             */
            public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationFilterProperty value) {
                this.jsiiSet("filter", value);
            }
            /**
             * ``BucketResource.TopicConfigurationProperty.Topic``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-topic
             */
            public java.lang.Object getTopic() {
                return this.jsiiGet("topic", java.lang.Object.class);
            }
            /**
             * ``BucketResource.TopicConfigurationProperty.Topic``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-topic
             */
            public void setTopic(final java.lang.String value) {
                this.jsiiSet("topic", java.util.Objects.requireNonNull(value, "topic is required"));
            }
            /**
             * ``BucketResource.TopicConfigurationProperty.Topic``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-topic
             */
            public void setTopic(final software.amazon.awscdk.Token value) {
                this.jsiiSet("topic", java.util.Objects.requireNonNull(value, "topic is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html
     */
    public static interface TransitionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.TransitionProperty.StorageClass``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-storageclass
         */
        java.lang.Object getStorageClass();
        /**
         * ``BucketResource.TransitionProperty.StorageClass``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-storageclass
         */
        void setStorageClass(final java.lang.String value);
        /**
         * ``BucketResource.TransitionProperty.StorageClass``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-storageclass
         */
        void setStorageClass(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.TransitionProperty.TransitionDate``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
         */
        java.lang.Object getTransitionDate();
        /**
         * ``BucketResource.TransitionProperty.TransitionDate``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
         */
        void setTransitionDate(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.TransitionProperty.TransitionDate``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
         */
        void setTransitionDate(final java.time.Instant value);
        /**
         * ``BucketResource.TransitionProperty.TransitionInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
         */
        java.lang.Object getTransitionInDays();
        /**
         * ``BucketResource.TransitionProperty.TransitionInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
         */
        void setTransitionInDays(final java.lang.Number value);
        /**
         * ``BucketResource.TransitionProperty.TransitionInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
         */
        void setTransitionInDays(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link TransitionProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.TransitionProperty.StorageClass``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-storageclass
             */
            public Build withStorageClass(final java.lang.String value) {
                return new FullBuilder().withStorageClass(value);
            }
            /**
             * ``BucketResource.TransitionProperty.StorageClass``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-storageclass
             */
            public Build withStorageClass(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withStorageClass(value);
            }

            public interface Build {
                /**
                 * @return a new {@link TransitionProperty} object, initialized with the values set on this builder.
                 */
                TransitionProperty build();
                /**
                 * ``BucketResource.TransitionProperty.TransitionDate``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
                 */
                Build withTransitionDate(final software.amazon.awscdk.Token value);
                /**
                 * ``BucketResource.TransitionProperty.TransitionDate``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
                 */
                Build withTransitionDate(final java.time.Instant value);
                /**
                 * ``BucketResource.TransitionProperty.TransitionInDays``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
                 */
                Build withTransitionInDays(final java.lang.Number value);
                /**
                 * ``BucketResource.TransitionProperty.TransitionInDays``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
                 */
                Build withTransitionInDays(final software.amazon.awscdk.Token value);
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.TransitionProperty.StorageClass``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-storageclass
                 */
                public Build withStorageClass(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "TransitionProperty#storageClass is required");
                    this.instance._storageClass = value;
                    return this;
                }
                /**
                 * ``BucketResource.TransitionProperty.StorageClass``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-storageclass
                 */
                public Build withStorageClass(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "TransitionProperty#storageClass is required");
                    this.instance._storageClass = value;
                    return this;
                }
                /**
                 * ``BucketResource.TransitionProperty.TransitionDate``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
                 */
                public Build withTransitionDate(final software.amazon.awscdk.Token value) {
                    this.instance._transitionDate = value;
                    return this;
                }
                /**
                 * ``BucketResource.TransitionProperty.TransitionDate``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
                 */
                public Build withTransitionDate(final java.time.Instant value) {
                    this.instance._transitionDate = value;
                    return this;
                }
                /**
                 * ``BucketResource.TransitionProperty.TransitionInDays``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
                 */
                public Build withTransitionInDays(final java.lang.Number value) {
                    this.instance._transitionInDays = value;
                    return this;
                }
                /**
                 * ``BucketResource.TransitionProperty.TransitionInDays``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
                 */
                public Build withTransitionInDays(final software.amazon.awscdk.Token value) {
                    this.instance._transitionInDays = value;
                    return this;
                }
                public TransitionProperty build() {
                    TransitionProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link TransitionProperty}.
         */
        final class Jsii$Pojo implements TransitionProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _storageClass;

            public java.lang.Object getStorageClass() {
                return this._storageClass;
            }
            public void setStorageClass(final java.lang.String value) {
                this._storageClass = value;
            }
            public void setStorageClass(final software.amazon.awscdk.Token value) {
                this._storageClass = value;
            }

            protected java.lang.Object _transitionDate;

            public java.lang.Object getTransitionDate() {
                return this._transitionDate;
            }
            public void setTransitionDate(final software.amazon.awscdk.Token value) {
                this._transitionDate = value;
            }
            public void setTransitionDate(final java.time.Instant value) {
                this._transitionDate = value;
            }

            protected java.lang.Object _transitionInDays;

            public java.lang.Object getTransitionInDays() {
                return this._transitionInDays;
            }
            public void setTransitionInDays(final java.lang.Number value) {
                this._transitionInDays = value;
            }
            public void setTransitionInDays(final software.amazon.awscdk.Token value) {
                this._transitionInDays = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.TransitionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.TransitionProperty.StorageClass``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-storageclass
             */
            public java.lang.Object getStorageClass() {
                return this.jsiiGet("storageClass", java.lang.Object.class);
            }
            /**
             * ``BucketResource.TransitionProperty.StorageClass``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-storageclass
             */
            public void setStorageClass(final java.lang.String value) {
                this.jsiiSet("storageClass", java.util.Objects.requireNonNull(value, "storageClass is required"));
            }
            /**
             * ``BucketResource.TransitionProperty.StorageClass``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-storageclass
             */
            public void setStorageClass(final software.amazon.awscdk.Token value) {
                this.jsiiSet("storageClass", java.util.Objects.requireNonNull(value, "storageClass is required"));
            }
            /**
             * ``BucketResource.TransitionProperty.TransitionDate``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
             */
            @javax.annotation.Nullable
            public java.lang.Object getTransitionDate() {
                return this.jsiiGet("transitionDate", java.lang.Object.class);
            }
            /**
             * ``BucketResource.TransitionProperty.TransitionDate``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
             */
            public void setTransitionDate(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("transitionDate", value);
            }
            /**
             * ``BucketResource.TransitionProperty.TransitionDate``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
             */
            public void setTransitionDate(@javax.annotation.Nullable final java.time.Instant value) {
                this.jsiiSet("transitionDate", value);
            }
            /**
             * ``BucketResource.TransitionProperty.TransitionInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
             */
            @javax.annotation.Nullable
            public java.lang.Object getTransitionInDays() {
                return this.jsiiGet("transitionInDays", java.lang.Object.class);
            }
            /**
             * ``BucketResource.TransitionProperty.TransitionInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
             */
            public void setTransitionInDays(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("transitionInDays", value);
            }
            /**
             * ``BucketResource.TransitionProperty.TransitionInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
             */
            public void setTransitionInDays(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("transitionInDays", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html
     */
    public static interface VersioningConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.VersioningConfigurationProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html#cfn-s3-bucket-versioningconfig-status
         */
        java.lang.Object getStatus();
        /**
         * ``BucketResource.VersioningConfigurationProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html#cfn-s3-bucket-versioningconfig-status
         */
        void setStatus(final java.lang.String value);
        /**
         * ``BucketResource.VersioningConfigurationProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html#cfn-s3-bucket-versioningconfig-status
         */
        void setStatus(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link VersioningConfigurationProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``BucketResource.VersioningConfigurationProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html#cfn-s3-bucket-versioningconfig-status
             */
            public Build withStatus(final java.lang.String value) {
                return new FullBuilder().withStatus(value);
            }
            /**
             * ``BucketResource.VersioningConfigurationProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html#cfn-s3-bucket-versioningconfig-status
             */
            public Build withStatus(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withStatus(value);
            }

            public interface Build {
                /**
                 * @return a new {@link VersioningConfigurationProperty} object, initialized with the values set on this builder.
                 */
                VersioningConfigurationProperty build();
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``BucketResource.VersioningConfigurationProperty.Status``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html#cfn-s3-bucket-versioningconfig-status
                 */
                public Build withStatus(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "VersioningConfigurationProperty#status is required");
                    this.instance._status = value;
                    return this;
                }
                /**
                 * ``BucketResource.VersioningConfigurationProperty.Status``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html#cfn-s3-bucket-versioningconfig-status
                 */
                public Build withStatus(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "VersioningConfigurationProperty#status is required");
                    this.instance._status = value;
                    return this;
                }
                public VersioningConfigurationProperty build() {
                    VersioningConfigurationProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link VersioningConfigurationProperty}.
         */
        final class Jsii$Pojo implements VersioningConfigurationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _status;

            public java.lang.Object getStatus() {
                return this._status;
            }
            public void setStatus(final java.lang.String value) {
                this._status = value;
            }
            public void setStatus(final software.amazon.awscdk.Token value) {
                this._status = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.VersioningConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.VersioningConfigurationProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html#cfn-s3-bucket-versioningconfig-status
             */
            public java.lang.Object getStatus() {
                return this.jsiiGet("status", java.lang.Object.class);
            }
            /**
             * ``BucketResource.VersioningConfigurationProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html#cfn-s3-bucket-versioningconfig-status
             */
            public void setStatus(final java.lang.String value) {
                this.jsiiSet("status", java.util.Objects.requireNonNull(value, "status is required"));
            }
            /**
             * ``BucketResource.VersioningConfigurationProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html#cfn-s3-bucket-versioningconfig-status
             */
            public void setStatus(final software.amazon.awscdk.Token value) {
                this.jsiiSet("status", java.util.Objects.requireNonNull(value, "status is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html
     */
    public static interface WebsiteConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.WebsiteConfigurationProperty.ErrorDocument``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-errordocument
         */
        java.lang.Object getErrorDocument();
        /**
         * ``BucketResource.WebsiteConfigurationProperty.ErrorDocument``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-errordocument
         */
        void setErrorDocument(final java.lang.String value);
        /**
         * ``BucketResource.WebsiteConfigurationProperty.ErrorDocument``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-errordocument
         */
        void setErrorDocument(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.WebsiteConfigurationProperty.IndexDocument``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-indexdocument
         */
        java.lang.Object getIndexDocument();
        /**
         * ``BucketResource.WebsiteConfigurationProperty.IndexDocument``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-indexdocument
         */
        void setIndexDocument(final java.lang.String value);
        /**
         * ``BucketResource.WebsiteConfigurationProperty.IndexDocument``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-indexdocument
         */
        void setIndexDocument(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.WebsiteConfigurationProperty.RedirectAllRequestsTo``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-redirectallrequeststo
         */
        java.lang.Object getRedirectAllRequestsTo();
        /**
         * ``BucketResource.WebsiteConfigurationProperty.RedirectAllRequestsTo``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-redirectallrequeststo
         */
        void setRedirectAllRequestsTo(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.WebsiteConfigurationProperty.RedirectAllRequestsTo``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-redirectallrequeststo
         */
        void setRedirectAllRequestsTo(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.RedirectAllRequestsToProperty value);
        /**
         * ``BucketResource.WebsiteConfigurationProperty.RoutingRules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-routingrules
         */
        java.lang.Object getRoutingRules();
        /**
         * ``BucketResource.WebsiteConfigurationProperty.RoutingRules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-routingrules
         */
        void setRoutingRules(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.WebsiteConfigurationProperty.RoutingRules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-routingrules
         */
        void setRoutingRules(final java.util.List<java.lang.Object> value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link WebsiteConfigurationProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``BucketResource.WebsiteConfigurationProperty.ErrorDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-errordocument
             */
            public Builder withErrorDocument(final java.lang.String value) {
                this.instance._errorDocument = value;
                return this;
            }
            /**
             * ``BucketResource.WebsiteConfigurationProperty.ErrorDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-errordocument
             */
            public Builder withErrorDocument(final software.amazon.awscdk.Token value) {
                this.instance._errorDocument = value;
                return this;
            }
            /**
             * ``BucketResource.WebsiteConfigurationProperty.IndexDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-indexdocument
             */
            public Builder withIndexDocument(final java.lang.String value) {
                this.instance._indexDocument = value;
                return this;
            }
            /**
             * ``BucketResource.WebsiteConfigurationProperty.IndexDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-indexdocument
             */
            public Builder withIndexDocument(final software.amazon.awscdk.Token value) {
                this.instance._indexDocument = value;
                return this;
            }
            /**
             * ``BucketResource.WebsiteConfigurationProperty.RedirectAllRequestsTo``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-redirectallrequeststo
             */
            public Builder withRedirectAllRequestsTo(final software.amazon.awscdk.Token value) {
                this.instance._redirectAllRequestsTo = value;
                return this;
            }
            /**
             * ``BucketResource.WebsiteConfigurationProperty.RedirectAllRequestsTo``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-redirectallrequeststo
             */
            public Builder withRedirectAllRequestsTo(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.RedirectAllRequestsToProperty value) {
                this.instance._redirectAllRequestsTo = value;
                return this;
            }
            /**
             * ``BucketResource.WebsiteConfigurationProperty.RoutingRules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-routingrules
             */
            public Builder withRoutingRules(final software.amazon.awscdk.Token value) {
                this.instance._routingRules = value;
                return this;
            }
            /**
             * ``BucketResource.WebsiteConfigurationProperty.RoutingRules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-routingrules
             */
            public Builder withRoutingRules(final java.util.List<java.lang.Object> value) {
                this.instance._routingRules = value;
                return this;
            }
            public WebsiteConfigurationProperty build() {
                WebsiteConfigurationProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link WebsiteConfigurationProperty}.
         */
        final class Jsii$Pojo implements WebsiteConfigurationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _errorDocument;

            public java.lang.Object getErrorDocument() {
                return this._errorDocument;
            }
            public void setErrorDocument(final java.lang.String value) {
                this._errorDocument = value;
            }
            public void setErrorDocument(final software.amazon.awscdk.Token value) {
                this._errorDocument = value;
            }

            protected java.lang.Object _indexDocument;

            public java.lang.Object getIndexDocument() {
                return this._indexDocument;
            }
            public void setIndexDocument(final java.lang.String value) {
                this._indexDocument = value;
            }
            public void setIndexDocument(final software.amazon.awscdk.Token value) {
                this._indexDocument = value;
            }

            protected java.lang.Object _redirectAllRequestsTo;

            public java.lang.Object getRedirectAllRequestsTo() {
                return this._redirectAllRequestsTo;
            }
            public void setRedirectAllRequestsTo(final software.amazon.awscdk.Token value) {
                this._redirectAllRequestsTo = value;
            }
            public void setRedirectAllRequestsTo(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.RedirectAllRequestsToProperty value) {
                this._redirectAllRequestsTo = value;
            }

            protected java.lang.Object _routingRules;

            public java.lang.Object getRoutingRules() {
                return this._routingRules;
            }
            public void setRoutingRules(final software.amazon.awscdk.Token value) {
                this._routingRules = value;
            }
            public void setRoutingRules(final java.util.List<java.lang.Object> value) {
                this._routingRules = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.WebsiteConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``BucketResource.WebsiteConfigurationProperty.ErrorDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-errordocument
             */
            @javax.annotation.Nullable
            public java.lang.Object getErrorDocument() {
                return this.jsiiGet("errorDocument", java.lang.Object.class);
            }
            /**
             * ``BucketResource.WebsiteConfigurationProperty.ErrorDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-errordocument
             */
            public void setErrorDocument(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("errorDocument", value);
            }
            /**
             * ``BucketResource.WebsiteConfigurationProperty.ErrorDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-errordocument
             */
            public void setErrorDocument(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("errorDocument", value);
            }
            /**
             * ``BucketResource.WebsiteConfigurationProperty.IndexDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-indexdocument
             */
            @javax.annotation.Nullable
            public java.lang.Object getIndexDocument() {
                return this.jsiiGet("indexDocument", java.lang.Object.class);
            }
            /**
             * ``BucketResource.WebsiteConfigurationProperty.IndexDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-indexdocument
             */
            public void setIndexDocument(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("indexDocument", value);
            }
            /**
             * ``BucketResource.WebsiteConfigurationProperty.IndexDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-indexdocument
             */
            public void setIndexDocument(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("indexDocument", value);
            }
            /**
             * ``BucketResource.WebsiteConfigurationProperty.RedirectAllRequestsTo``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-redirectallrequeststo
             */
            @javax.annotation.Nullable
            public java.lang.Object getRedirectAllRequestsTo() {
                return this.jsiiGet("redirectAllRequestsTo", java.lang.Object.class);
            }
            /**
             * ``BucketResource.WebsiteConfigurationProperty.RedirectAllRequestsTo``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-redirectallrequeststo
             */
            public void setRedirectAllRequestsTo(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("redirectAllRequestsTo", value);
            }
            /**
             * ``BucketResource.WebsiteConfigurationProperty.RedirectAllRequestsTo``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-redirectallrequeststo
             */
            public void setRedirectAllRequestsTo(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.RedirectAllRequestsToProperty value) {
                this.jsiiSet("redirectAllRequestsTo", value);
            }
            /**
             * ``BucketResource.WebsiteConfigurationProperty.RoutingRules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-routingrules
             */
            @javax.annotation.Nullable
            public java.lang.Object getRoutingRules() {
                return this.jsiiGet("routingRules", java.lang.Object.class);
            }
            /**
             * ``BucketResource.WebsiteConfigurationProperty.RoutingRules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-routingrules
             */
            public void setRoutingRules(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("routingRules", value);
            }
            /**
             * ``BucketResource.WebsiteConfigurationProperty.RoutingRules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-routingrules
             */
            public void setRoutingRules(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("routingRules", value);
            }
        }
    }
}
