package software.amazon.awscdk.services.s3;
public interface BucketPolicyProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The Amazon S3 bucket that the policy applies to.
     */
    software.amazon.awscdk.services.s3.BucketRef getBucket();
    /**
     * The Amazon S3 bucket that the policy applies to.
     */
    void setBucket(final software.amazon.awscdk.services.s3.BucketRef value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link BucketPolicyProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * The Amazon S3 bucket that the policy applies to.
         */
        public Build withBucket(final software.amazon.awscdk.services.s3.BucketRef value) {
            return new FullBuilder().withBucket(value);
        }

        public interface Build {
            /**
             * @return a new {@link BucketPolicyProps} object, initialized with the values set on this builder.
             */
            BucketPolicyProps build();
        }

        final class FullBuilder implements Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * The Amazon S3 bucket that the policy applies to.
             */
            public Build withBucket(final software.amazon.awscdk.services.s3.BucketRef value) {
                java.util.Objects.requireNonNull(value, "BucketPolicyProps#bucket is required");
                this.instance._bucket = value;
                return this;
            }
            public BucketPolicyProps build() {
                BucketPolicyProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link BucketPolicyProps}.
     */
    final class Jsii$Pojo implements BucketPolicyProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected software.amazon.awscdk.services.s3.BucketRef _bucket;

        public software.amazon.awscdk.services.s3.BucketRef getBucket() {
            return this._bucket;
        }
        public void setBucket(final software.amazon.awscdk.services.s3.BucketRef value) {
            this._bucket = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.BucketPolicyProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * The Amazon S3 bucket that the policy applies to.
         */
        public software.amazon.awscdk.services.s3.BucketRef getBucket() {
            return this.jsiiGet("bucket", software.amazon.awscdk.services.s3.BucketRef.class);
        }
        /**
         * The Amazon S3 bucket that the policy applies to.
         */
        public void setBucket(final software.amazon.awscdk.services.s3.BucketRef value) {
            this.jsiiSet("bucket", java.util.Objects.requireNonNull(value, "bucket is required"));
        }
    }
}
