package software.amazon.awscdk.services.s3;
/**
 * Represents an S3 Bucket.
 * 
 * Buckets can be either defined within this stack:
 * 
 *      new Bucket(this, 'MyBucket', { props });
 * 
 * Or imported from an existing bucket:
 * 
 *      BucketRef.import(this, 'MyImportedBucket', { bucketArn: ... });
 * 
 * You can also export a bucket and import it into another stack:
 * 
 *      const ref = myBucket.export();
 *      BucketRef.import(this, 'MyImportedBucket', ref);
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.BucketRef")
public abstract class BucketRef extends software.amazon.awscdk.Construct {
    protected BucketRef(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    /**
     * Creates a Bucket construct that represents an external bucket.
     * @param parent The parent creating construct (usually `this`).
     * @param name The construct's name.
     */
    public static software.amazon.awscdk.services.s3.BucketRef import_(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.s3.BucketRefProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.BucketRef.class, "import", software.amazon.awscdk.services.s3.BucketRef.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }
    /**
     * Exports this bucket from the stack.
     */
    public software.amazon.awscdk.services.s3.BucketRefProps export() {
        return this.jsiiCall("export", software.amazon.awscdk.services.s3.BucketRefProps.class);
    }
    /**
     * Adds a statement to the resource policy for a principal (i.e.
     * account/role/service) to perform actions on this bucket and/or it's
     * contents. Use `bucketArn` and `arnForObjects(keys)` to obtain ARNs for
     * this bucket or objects.
     */
    public void addToResourcePolicy(final software.amazon.awscdk.PolicyStatement permission) {
        this.jsiiCall("addToResourcePolicy", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(permission, "permission is required")).toArray());
    }
    /**
     * The https URL of an S3 object. For example:
     * @example https://s3.cn-north-1.amazonaws.com.cn/china-bucket/mykey
     * @return an ObjectS3Url token
     * @param key The S3 key of the object. If not specified, the URL of the
bucket is returned.
     */
    public software.amazon.awscdk.services.s3.S3Url urlForObject(@javax.annotation.Nullable final java.lang.Object key) {
        return this.jsiiCall("urlForObject", software.amazon.awscdk.services.s3.S3Url.class, java.util.stream.Stream.of(key).toArray());
    }
    /**
     * The https URL of an S3 object. For example:
     * @example https://s3.cn-north-1.amazonaws.com.cn/china-bucket/mykey
     * @return an ObjectS3Url token
     */
    public software.amazon.awscdk.services.s3.S3Url urlForObject() {
        return this.jsiiCall("urlForObject", software.amazon.awscdk.services.s3.S3Url.class);
    }
    /**
     * Returns an ARN that represents all objects within the bucket that match
     * the key pattern specified. To represent all keys, specify ``"*"``.
     * 
     * If you specify multiple components for keyPattern, they will be concatenated::
     * 
     *      arnForObjects('home/', team, '/', user, '/*')
     */
    public software.amazon.awscdk.Arn arnForObjects(final java.lang.Object... keyPattern) {
        return this.jsiiCall("arnForObjects", software.amazon.awscdk.Arn.class, java.util.Arrays.stream(java.util.Objects.requireNonNull(keyPattern, "keyPattern is required")).toArray());
    }
    /**
     * Temporary API for granting read permissions for this bucket and it's
     * contents to an IAM principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to ues the key to decrypt the
     * contents of the bucket will also be granted.
     */
    public void grantRead(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity, @javax.annotation.Nullable final java.lang.Object objectsKeyPattern) {
        this.jsiiCall("grantRead", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(identity), java.util.stream.Stream.of(objectsKeyPattern)).toArray());
    }
    /**
     * Temporary API for granting read permissions for this bucket and it's
     * contents to an IAM principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to ues the key to decrypt the
     * contents of the bucket will also be granted.
     */
    public void grantRead(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity) {
        this.jsiiCall("grantRead", Void.class, java.util.stream.Stream.of(identity).toArray());
    }
    /**
     * Temporary API for granting read permissions for this bucket and it's
     * contents to an IAM principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to ues the key to decrypt the
     * contents of the bucket will also be granted.
     */
    public void grantRead() {
        this.jsiiCall("grantRead", Void.class);
    }
    /**
     * Grants read/write permissions for this bucket and it's contents to an IAM
     * principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     */
    public void grantReadWrite(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity, @javax.annotation.Nullable final java.lang.Object objectsKeyPattern) {
        this.jsiiCall("grantReadWrite", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(identity), java.util.stream.Stream.of(objectsKeyPattern)).toArray());
    }
    /**
     * Grants read/write permissions for this bucket and it's contents to an IAM
     * principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     */
    public void grantReadWrite(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity) {
        this.jsiiCall("grantReadWrite", Void.class, java.util.stream.Stream.of(identity).toArray());
    }
    /**
     * Grants read/write permissions for this bucket and it's contents to an IAM
     * principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     */
    public void grantReadWrite() {
        this.jsiiCall("grantReadWrite", Void.class);
    }
    /**
     * The ARN of the bucket.
     */
    public software.amazon.awscdk.services.s3.BucketArn getBucketArn() {
        return this.jsiiGet("bucketArn", software.amazon.awscdk.services.s3.BucketArn.class);
    }
    /**
     * The name of the bucket.
     */
    public software.amazon.awscdk.services.s3.BucketName getBucketName() {
        return this.jsiiGet("bucketName", software.amazon.awscdk.services.s3.BucketName.class);
    }
    /**
     * Optional KMS encryption key associated with this bucket.
     */
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.kms.EncryptionKeyRef getEncryptionKey() {
        return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.EncryptionKeyRef.class);
    }
    /**
     * The resource policy assoicated with this bucket.
     * 
     * If `autoCreatePolicy` is true, a `BucketPolicy` will be created upon the
     * first call to addToResourcePolicy(s).
     */
    @javax.annotation.Nullable
    protected software.amazon.awscdk.services.s3.BucketPolicy getPolicy() {
        return this.jsiiGet("policy", software.amazon.awscdk.services.s3.BucketPolicy.class);
    }
    /**
     * The resource policy assoicated with this bucket.
     * 
     * If `autoCreatePolicy` is true, a `BucketPolicy` will be created upon the
     * first call to addToResourcePolicy(s).
     */
    protected void setPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.BucketPolicy value) {
        this.jsiiSet("policy", value);
    }
    /**
     * Indicates if a bucket resource policy should automatically created upon
     * the first call to `addToResourcePolicy`.
     */
    protected java.lang.Boolean getAutoCreatePolicy() {
        return this.jsiiGet("autoCreatePolicy", java.lang.Boolean.class);
    }
    /**
     * Indicates if a bucket resource policy should automatically created upon
     * the first call to `addToResourcePolicy`.
     */
    protected void setAutoCreatePolicy(final java.lang.Boolean value) {
        this.jsiiSet("autoCreatePolicy", java.util.Objects.requireNonNull(value, "autoCreatePolicy is required"));
    }
    /**
     * The https:// URL of this bucket.
     * @example https://s3.us-west-1.amazonaws.com/onlybucket Similar to calling `urlForObject` with no object key.
     */
    public software.amazon.awscdk.services.s3.S3Url getBucketUrl() {
        return this.jsiiGet("bucketUrl", software.amazon.awscdk.services.s3.S3Url.class);
    }
}
