package software.amazon.awscdk.services.s3;
/**
 * A reference to a bucket. The easiest way to instantiate is to call
 * `bucket.export()`. Then, the consumer can use `Bucket.import(this, ref)` and
 * get a `Bucket`.
 */
public interface BucketRefProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The ARN fo the bucket. At least one of bucketArn or bucketName must be
     * defined in order to initialize a bucket ref.
     */
    software.amazon.awscdk.services.s3.BucketArn getBucketArn();
    /**
     * The ARN fo the bucket. At least one of bucketArn or bucketName must be
     * defined in order to initialize a bucket ref.
     */
    void setBucketArn(final software.amazon.awscdk.services.s3.BucketArn value);
    /**
     * The name of the bucket. If the underlying value of ARN is a string, the
     * name will be parsed from the ARN. Otherwise, the name is optional, but
     * some features that require the bucket name such as auto-creating a bucket
     * policy, won't work.
     */
    software.amazon.awscdk.services.s3.BucketName getBucketName();
    /**
     * The name of the bucket. If the underlying value of ARN is a string, the
     * name will be parsed from the ARN. Otherwise, the name is optional, but
     * some features that require the bucket name such as auto-creating a bucket
     * policy, won't work.
     */
    void setBucketName(final software.amazon.awscdk.services.s3.BucketName value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }

    /**
     * A fluent builder class for {@link BucketRefProps}.
     */
    public static final class Builder {
        private Jsii$Pojo instance = new Jsii$Pojo();

        /**
         * The ARN fo the bucket. At least one of bucketArn or bucketName must be
         * defined in order to initialize a bucket ref.
         */
        public Builder withBucketArn(final software.amazon.awscdk.services.s3.BucketArn value) {
            this.instance._bucketArn = value;
            return this;
        }
        /**
         * The name of the bucket. If the underlying value of ARN is a string, the
         * name will be parsed from the ARN. Otherwise, the name is optional, but
         * some features that require the bucket name such as auto-creating a bucket
         * policy, won't work.
         */
        public Builder withBucketName(final software.amazon.awscdk.services.s3.BucketName value) {
            this.instance._bucketName = value;
            return this;
        }
        public BucketRefProps build() {
            BucketRefProps result = this.instance;
            this.instance = new Jsii$Pojo();
            return result;
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link BucketRefProps}.
     */
    final class Jsii$Pojo implements BucketRefProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected software.amazon.awscdk.services.s3.BucketArn _bucketArn;

        public software.amazon.awscdk.services.s3.BucketArn getBucketArn() {
            return this._bucketArn;
        }
        public void setBucketArn(final software.amazon.awscdk.services.s3.BucketArn value) {
            this._bucketArn = value;
        }

        protected software.amazon.awscdk.services.s3.BucketName _bucketName;

        public software.amazon.awscdk.services.s3.BucketName getBucketName() {
            return this._bucketName;
        }
        public void setBucketName(final software.amazon.awscdk.services.s3.BucketName value) {
            this._bucketName = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.BucketRefProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * The ARN fo the bucket. At least one of bucketArn or bucketName must be
         * defined in order to initialize a bucket ref.
         */
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.s3.BucketArn getBucketArn() {
            return this.jsiiGet("bucketArn", software.amazon.awscdk.services.s3.BucketArn.class);
        }
        /**
         * The ARN fo the bucket. At least one of bucketArn or bucketName must be
         * defined in order to initialize a bucket ref.
         */
        public void setBucketArn(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.BucketArn value) {
            this.jsiiSet("bucketArn", value);
        }
        /**
         * The name of the bucket. If the underlying value of ARN is a string, the
         * name will be parsed from the ARN. Otherwise, the name is optional, but
         * some features that require the bucket name such as auto-creating a bucket
         * policy, won't work.
         */
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.s3.BucketName getBucketName() {
            return this.jsiiGet("bucketName", software.amazon.awscdk.services.s3.BucketName.class);
        }
        /**
         * The name of the bucket. If the underlying value of ARN is a string, the
         * name will be parsed from the ARN. Otherwise, the name is optional, but
         * some features that require the bucket name such as auto-creating a bucket
         * policy, won't work.
         */
        public void setBucketName(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.BucketName value) {
            this.jsiiSet("bucketName", value);
        }
    }
}
