package software.amazon.awscdk.services.s3;
/**
 * Declaration of a Life cycle rule
 */
public interface LifecycleRule extends software.amazon.jsii.JsiiSerializable {
    /**
     * A unique identifier for this rule. The value cannot be more than 255 characters.
     */
    java.lang.String getId();
    /**
     * A unique identifier for this rule. The value cannot be more than 255 characters.
     */
    void setId(final java.lang.String value);
    /**
     * Whether this rule is enabled.
     * @default true
     */
    java.lang.Boolean getEnabled();
    /**
     * Whether this rule is enabled.
     * @default true
     */
    void setEnabled(final java.lang.Boolean value);
    /**
     * Specifies a lifecycle rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
     * 
     * The AbortIncompleteMultipartUpload property type creates a lifecycle
     * rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
     * When Amazon S3 aborts a multipart upload, it deletes all parts
     * associated with the multipart upload.
     * @default Incomplete uploads are never aborted
     */
    java.lang.Number getAbortIncompleteMultipartUploadAfterDays();
    /**
     * Specifies a lifecycle rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
     * 
     * The AbortIncompleteMultipartUpload property type creates a lifecycle
     * rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
     * When Amazon S3 aborts a multipart upload, it deletes all parts
     * associated with the multipart upload.
     * @default Incomplete uploads are never aborted
     */
    void setAbortIncompleteMultipartUploadAfterDays(final java.lang.Number value);
    /**
     * Indicates when objects are deleted from Amazon S3 and Amazon Glacier.
     * 
     * The date value must be in ISO 8601 format. The time is always midnight UTC.
     * 
     * If you specify an expiration and transition time, you must use the same
     * time unit for both properties (either in days or by date). The
     * expiration time must also be later than the transition time.
     * @default No expiration date
     */
    java.time.Instant getExpirationDate();
    /**
     * Indicates when objects are deleted from Amazon S3 and Amazon Glacier.
     * 
     * The date value must be in ISO 8601 format. The time is always midnight UTC.
     * 
     * If you specify an expiration and transition time, you must use the same
     * time unit for both properties (either in days or by date). The
     * expiration time must also be later than the transition time.
     * @default No expiration date
     */
    void setExpirationDate(final java.time.Instant value);
    /**
     * Indicates the number of days after creation when objects are deleted from Amazon S3 and Amazon Glacier.
     * 
     * If you specify an expiration and transition time, you must use the same
     * time unit for both properties (either in days or by date). The
     * expiration time must also be later than the transition time.
     * @default No expiration timeout
     */
    java.lang.Number getExpirationInDays();
    /**
     * Indicates the number of days after creation when objects are deleted from Amazon S3 and Amazon Glacier.
     * 
     * If you specify an expiration and transition time, you must use the same
     * time unit for both properties (either in days or by date). The
     * expiration time must also be later than the transition time.
     * @default No expiration timeout
     */
    void setExpirationInDays(final java.lang.Number value);
    /**
     * Time between when a new version of the object is uploaded to the bucket and when old versions of the object expire.
     * 
     * For buckets with versioning enabled (or suspended), specifies the time,
     * in days, between when a new version of the object is uploaded to the
     * bucket and when old versions of the object expire. When object versions
     * expire, Amazon S3 permanently deletes them. If you specify a transition
     * and expiration time, the expiration time must be later than the
     * transition time.
     * @default No noncurrent version expiration
     */
    java.lang.Number getNoncurrentVersionExpirationInDays();
    /**
     * Time between when a new version of the object is uploaded to the bucket and when old versions of the object expire.
     * 
     * For buckets with versioning enabled (or suspended), specifies the time,
     * in days, between when a new version of the object is uploaded to the
     * bucket and when old versions of the object expire. When object versions
     * expire, Amazon S3 permanently deletes them. If you specify a transition
     * and expiration time, the expiration time must be later than the
     * transition time.
     * @default No noncurrent version expiration
     */
    void setNoncurrentVersionExpirationInDays(final java.lang.Number value);
    /**
     * One or more transition rules that specify when non-current objects transition to a specified storage class.
     * 
     * Only for for buckets with versioning enabled (or suspended).
     * 
     * If you specify a transition and expiration time, the expiration time
     * must be later than the transition time.
     */
    java.util.List<software.amazon.awscdk.services.s3.NoncurrentVersionTransition> getNoncurrentVersionTransitions();
    /**
     * One or more transition rules that specify when non-current objects transition to a specified storage class.
     * 
     * Only for for buckets with versioning enabled (or suspended).
     * 
     * If you specify a transition and expiration time, the expiration time
     * must be later than the transition time.
     */
    void setNoncurrentVersionTransitions(final java.util.List<software.amazon.awscdk.services.s3.NoncurrentVersionTransition> value);
    /**
     * One or more transition rules that specify when an object transitions to a specified storage class.
     * 
     * If you specify an expiration and transition time, you must use the same
     * time unit for both properties (either in days or by date). The
     * expiration time must also be later than the transition time.
     * @default No transition rules
     */
    java.util.List<software.amazon.awscdk.services.s3.Transition> getTransitions();
    /**
     * One or more transition rules that specify when an object transitions to a specified storage class.
     * 
     * If you specify an expiration and transition time, you must use the same
     * time unit for both properties (either in days or by date). The
     * expiration time must also be later than the transition time.
     * @default No transition rules
     */
    void setTransitions(final java.util.List<software.amazon.awscdk.services.s3.Transition> value);
    /**
     * Object key prefix that identifies one or more objects to which this rule applies.
     * @default Rule applies to all objects
     */
    java.lang.String getPrefix();
    /**
     * Object key prefix that identifies one or more objects to which this rule applies.
     * @default Rule applies to all objects
     */
    void setPrefix(final java.lang.String value);
    /**
     * The TagFilter property type specifies tags to use to identify a subset of objects for an Amazon S3 bucket.
     * @default Rule applies to all objects
     */
    java.util.Map<java.lang.String, java.lang.Object> getTagFilters();
    /**
     * The TagFilter property type specifies tags to use to identify a subset of objects for an Amazon S3 bucket.
     * @default Rule applies to all objects
     */
    void setTagFilters(final java.util.Map<java.lang.String, java.lang.Object> value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }

    /**
     * A fluent builder class for {@link LifecycleRule}.
     */
    public static final class Builder {
        private Jsii$Pojo instance = new Jsii$Pojo();

        /**
         * A unique identifier for this rule. The value cannot be more than 255 characters.
         */
        public Builder withId(final java.lang.String value) {
            this.instance._id = value;
            return this;
        }
        /**
         * Whether this rule is enabled.
         * @default true
         */
        public Builder withEnabled(final java.lang.Boolean value) {
            this.instance._enabled = value;
            return this;
        }
        /**
         * Specifies a lifecycle rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
         * 
         * The AbortIncompleteMultipartUpload property type creates a lifecycle
         * rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
         * When Amazon S3 aborts a multipart upload, it deletes all parts
         * associated with the multipart upload.
         * @default Incomplete uploads are never aborted
         */
        public Builder withAbortIncompleteMultipartUploadAfterDays(final java.lang.Number value) {
            this.instance._abortIncompleteMultipartUploadAfterDays = value;
            return this;
        }
        /**
         * Indicates when objects are deleted from Amazon S3 and Amazon Glacier.
         * 
         * The date value must be in ISO 8601 format. The time is always midnight UTC.
         * 
         * If you specify an expiration and transition time, you must use the same
         * time unit for both properties (either in days or by date). The
         * expiration time must also be later than the transition time.
         * @default No expiration date
         */
        public Builder withExpirationDate(final java.time.Instant value) {
            this.instance._expirationDate = value;
            return this;
        }
        /**
         * Indicates the number of days after creation when objects are deleted from Amazon S3 and Amazon Glacier.
         * 
         * If you specify an expiration and transition time, you must use the same
         * time unit for both properties (either in days or by date). The
         * expiration time must also be later than the transition time.
         * @default No expiration timeout
         */
        public Builder withExpirationInDays(final java.lang.Number value) {
            this.instance._expirationInDays = value;
            return this;
        }
        /**
         * Time between when a new version of the object is uploaded to the bucket and when old versions of the object expire.
         * 
         * For buckets with versioning enabled (or suspended), specifies the time,
         * in days, between when a new version of the object is uploaded to the
         * bucket and when old versions of the object expire. When object versions
         * expire, Amazon S3 permanently deletes them. If you specify a transition
         * and expiration time, the expiration time must be later than the
         * transition time.
         * @default No noncurrent version expiration
         */
        public Builder withNoncurrentVersionExpirationInDays(final java.lang.Number value) {
            this.instance._noncurrentVersionExpirationInDays = value;
            return this;
        }
        /**
         * One or more transition rules that specify when non-current objects transition to a specified storage class.
         * 
         * Only for for buckets with versioning enabled (or suspended).
         * 
         * If you specify a transition and expiration time, the expiration time
         * must be later than the transition time.
         */
        public Builder withNoncurrentVersionTransitions(final java.util.List<software.amazon.awscdk.services.s3.NoncurrentVersionTransition> value) {
            this.instance._noncurrentVersionTransitions = value;
            return this;
        }
        /**
         * One or more transition rules that specify when an object transitions to a specified storage class.
         * 
         * If you specify an expiration and transition time, you must use the same
         * time unit for both properties (either in days or by date). The
         * expiration time must also be later than the transition time.
         * @default No transition rules
         */
        public Builder withTransitions(final java.util.List<software.amazon.awscdk.services.s3.Transition> value) {
            this.instance._transitions = value;
            return this;
        }
        /**
         * Object key prefix that identifies one or more objects to which this rule applies.
         * @default Rule applies to all objects
         */
        public Builder withPrefix(final java.lang.String value) {
            this.instance._prefix = value;
            return this;
        }
        /**
         * The TagFilter property type specifies tags to use to identify a subset of objects for an Amazon S3 bucket.
         * @default Rule applies to all objects
         */
        public Builder withTagFilters(final java.util.Map<java.lang.String, java.lang.Object> value) {
            this.instance._tagFilters = value;
            return this;
        }
        public LifecycleRule build() {
            LifecycleRule result = this.instance;
            this.instance = new Jsii$Pojo();
            return result;
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link LifecycleRule}.
     */
    final class Jsii$Pojo implements LifecycleRule {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.String _id;

        public java.lang.String getId() {
            return this._id;
        }
        public void setId(final java.lang.String value) {
            this._id = value;
        }

        protected java.lang.Boolean _enabled;

        public java.lang.Boolean getEnabled() {
            return this._enabled;
        }
        public void setEnabled(final java.lang.Boolean value) {
            this._enabled = value;
        }

        protected java.lang.Number _abortIncompleteMultipartUploadAfterDays;

        public java.lang.Number getAbortIncompleteMultipartUploadAfterDays() {
            return this._abortIncompleteMultipartUploadAfterDays;
        }
        public void setAbortIncompleteMultipartUploadAfterDays(final java.lang.Number value) {
            this._abortIncompleteMultipartUploadAfterDays = value;
        }

        protected java.time.Instant _expirationDate;

        public java.time.Instant getExpirationDate() {
            return this._expirationDate;
        }
        public void setExpirationDate(final java.time.Instant value) {
            this._expirationDate = value;
        }

        protected java.lang.Number _expirationInDays;

        public java.lang.Number getExpirationInDays() {
            return this._expirationInDays;
        }
        public void setExpirationInDays(final java.lang.Number value) {
            this._expirationInDays = value;
        }

        protected java.lang.Number _noncurrentVersionExpirationInDays;

        public java.lang.Number getNoncurrentVersionExpirationInDays() {
            return this._noncurrentVersionExpirationInDays;
        }
        public void setNoncurrentVersionExpirationInDays(final java.lang.Number value) {
            this._noncurrentVersionExpirationInDays = value;
        }

        protected java.util.List<software.amazon.awscdk.services.s3.NoncurrentVersionTransition> _noncurrentVersionTransitions;

        public java.util.List<software.amazon.awscdk.services.s3.NoncurrentVersionTransition> getNoncurrentVersionTransitions() {
            return this._noncurrentVersionTransitions;
        }
        public void setNoncurrentVersionTransitions(final java.util.List<software.amazon.awscdk.services.s3.NoncurrentVersionTransition> value) {
            this._noncurrentVersionTransitions = value;
        }

        protected java.util.List<software.amazon.awscdk.services.s3.Transition> _transitions;

        public java.util.List<software.amazon.awscdk.services.s3.Transition> getTransitions() {
            return this._transitions;
        }
        public void setTransitions(final java.util.List<software.amazon.awscdk.services.s3.Transition> value) {
            this._transitions = value;
        }

        protected java.lang.String _prefix;

        public java.lang.String getPrefix() {
            return this._prefix;
        }
        public void setPrefix(final java.lang.String value) {
            this._prefix = value;
        }

        protected java.util.Map<java.lang.String, java.lang.Object> _tagFilters;

        public java.util.Map<java.lang.String, java.lang.Object> getTagFilters() {
            return this._tagFilters;
        }
        public void setTagFilters(final java.util.Map<java.lang.String, java.lang.Object> value) {
            this._tagFilters = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.LifecycleRule {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * A unique identifier for this rule. The value cannot be more than 255 characters.
         */
        @javax.annotation.Nullable
        public java.lang.String getId() {
            return this.jsiiGet("id", java.lang.String.class);
        }
        /**
         * A unique identifier for this rule. The value cannot be more than 255 characters.
         */
        public void setId(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("id", value);
        }
        /**
         * Whether this rule is enabled.
         * @default true
         */
        @javax.annotation.Nullable
        public java.lang.Boolean getEnabled() {
            return this.jsiiGet("enabled", java.lang.Boolean.class);
        }
        /**
         * Whether this rule is enabled.
         * @default true
         */
        public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("enabled", value);
        }
        /**
         * Specifies a lifecycle rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
         * 
         * The AbortIncompleteMultipartUpload property type creates a lifecycle
         * rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
         * When Amazon S3 aborts a multipart upload, it deletes all parts
         * associated with the multipart upload.
         * @default Incomplete uploads are never aborted
         */
        @javax.annotation.Nullable
        public java.lang.Number getAbortIncompleteMultipartUploadAfterDays() {
            return this.jsiiGet("abortIncompleteMultipartUploadAfterDays", java.lang.Number.class);
        }
        /**
         * Specifies a lifecycle rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
         * 
         * The AbortIncompleteMultipartUpload property type creates a lifecycle
         * rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
         * When Amazon S3 aborts a multipart upload, it deletes all parts
         * associated with the multipart upload.
         * @default Incomplete uploads are never aborted
         */
        public void setAbortIncompleteMultipartUploadAfterDays(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("abortIncompleteMultipartUploadAfterDays", value);
        }
        /**
         * Indicates when objects are deleted from Amazon S3 and Amazon Glacier.
         * 
         * The date value must be in ISO 8601 format. The time is always midnight UTC.
         * 
         * If you specify an expiration and transition time, you must use the same
         * time unit for both properties (either in days or by date). The
         * expiration time must also be later than the transition time.
         * @default No expiration date
         */
        @javax.annotation.Nullable
        public java.time.Instant getExpirationDate() {
            return this.jsiiGet("expirationDate", java.time.Instant.class);
        }
        /**
         * Indicates when objects are deleted from Amazon S3 and Amazon Glacier.
         * 
         * The date value must be in ISO 8601 format. The time is always midnight UTC.
         * 
         * If you specify an expiration and transition time, you must use the same
         * time unit for both properties (either in days or by date). The
         * expiration time must also be later than the transition time.
         * @default No expiration date
         */
        public void setExpirationDate(@javax.annotation.Nullable final java.time.Instant value) {
            this.jsiiSet("expirationDate", value);
        }
        /**
         * Indicates the number of days after creation when objects are deleted from Amazon S3 and Amazon Glacier.
         * 
         * If you specify an expiration and transition time, you must use the same
         * time unit for both properties (either in days or by date). The
         * expiration time must also be later than the transition time.
         * @default No expiration timeout
         */
        @javax.annotation.Nullable
        public java.lang.Number getExpirationInDays() {
            return this.jsiiGet("expirationInDays", java.lang.Number.class);
        }
        /**
         * Indicates the number of days after creation when objects are deleted from Amazon S3 and Amazon Glacier.
         * 
         * If you specify an expiration and transition time, you must use the same
         * time unit for both properties (either in days or by date). The
         * expiration time must also be later than the transition time.
         * @default No expiration timeout
         */
        public void setExpirationInDays(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("expirationInDays", value);
        }
        /**
         * Time between when a new version of the object is uploaded to the bucket and when old versions of the object expire.
         * 
         * For buckets with versioning enabled (or suspended), specifies the time,
         * in days, between when a new version of the object is uploaded to the
         * bucket and when old versions of the object expire. When object versions
         * expire, Amazon S3 permanently deletes them. If you specify a transition
         * and expiration time, the expiration time must be later than the
         * transition time.
         * @default No noncurrent version expiration
         */
        @javax.annotation.Nullable
        public java.lang.Number getNoncurrentVersionExpirationInDays() {
            return this.jsiiGet("noncurrentVersionExpirationInDays", java.lang.Number.class);
        }
        /**
         * Time between when a new version of the object is uploaded to the bucket and when old versions of the object expire.
         * 
         * For buckets with versioning enabled (or suspended), specifies the time,
         * in days, between when a new version of the object is uploaded to the
         * bucket and when old versions of the object expire. When object versions
         * expire, Amazon S3 permanently deletes them. If you specify a transition
         * and expiration time, the expiration time must be later than the
         * transition time.
         * @default No noncurrent version expiration
         */
        public void setNoncurrentVersionExpirationInDays(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("noncurrentVersionExpirationInDays", value);
        }
        /**
         * One or more transition rules that specify when non-current objects transition to a specified storage class.
         * 
         * Only for for buckets with versioning enabled (or suspended).
         * 
         * If you specify a transition and expiration time, the expiration time
         * must be later than the transition time.
         */
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.s3.NoncurrentVersionTransition> getNoncurrentVersionTransitions() {
            return this.jsiiGet("noncurrentVersionTransitions", java.util.List.class);
        }
        /**
         * One or more transition rules that specify when non-current objects transition to a specified storage class.
         * 
         * Only for for buckets with versioning enabled (or suspended).
         * 
         * If you specify a transition and expiration time, the expiration time
         * must be later than the transition time.
         */
        public void setNoncurrentVersionTransitions(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.s3.NoncurrentVersionTransition> value) {
            this.jsiiSet("noncurrentVersionTransitions", value);
        }
        /**
         * One or more transition rules that specify when an object transitions to a specified storage class.
         * 
         * If you specify an expiration and transition time, you must use the same
         * time unit for both properties (either in days or by date). The
         * expiration time must also be later than the transition time.
         * @default No transition rules
         */
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.s3.Transition> getTransitions() {
            return this.jsiiGet("transitions", java.util.List.class);
        }
        /**
         * One or more transition rules that specify when an object transitions to a specified storage class.
         * 
         * If you specify an expiration and transition time, you must use the same
         * time unit for both properties (either in days or by date). The
         * expiration time must also be later than the transition time.
         * @default No transition rules
         */
        public void setTransitions(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.s3.Transition> value) {
            this.jsiiSet("transitions", value);
        }
        /**
         * Object key prefix that identifies one or more objects to which this rule applies.
         * @default Rule applies to all objects
         */
        @javax.annotation.Nullable
        public java.lang.String getPrefix() {
            return this.jsiiGet("prefix", java.lang.String.class);
        }
        /**
         * Object key prefix that identifies one or more objects to which this rule applies.
         * @default Rule applies to all objects
         */
        public void setPrefix(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("prefix", value);
        }
        /**
         * The TagFilter property type specifies tags to use to identify a subset of objects for an Amazon S3 bucket.
         * @default Rule applies to all objects
         */
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.Object> getTagFilters() {
            return this.jsiiGet("tagFilters", java.util.Map.class);
        }
        /**
         * The TagFilter property type specifies tags to use to identify a subset of objects for an Amazon S3 bucket.
         * @default Rule applies to all objects
         */
        public void setTagFilters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
            this.jsiiSet("tagFilters", value);
        }
    }
}
