package software.amazon.awscdk.services.s3;

/**
 * Declaration of a Life cycle rule
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.4 (build e80a889)", date = "2018-09-11T09:58:01.381Z")
public interface LifecycleRule extends software.amazon.jsii.JsiiSerializable {
    /**
     * Specifies a lifecycle rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
     * 
     * The AbortIncompleteMultipartUpload property type creates a lifecycle
     * rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
     * When Amazon S3 aborts a multipart upload, it deletes all parts
     * associated with the multipart upload.
     * @default Incomplete uploads are never aborted
     */
    java.lang.Number getAbortIncompleteMultipartUploadAfterDays();
    /**
     * Specifies a lifecycle rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
     * 
     * The AbortIncompleteMultipartUpload property type creates a lifecycle
     * rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
     * When Amazon S3 aborts a multipart upload, it deletes all parts
     * associated with the multipart upload.
     * @default Incomplete uploads are never aborted
     */
    void setAbortIncompleteMultipartUploadAfterDays(final java.lang.Number value);
    /**
     * Whether this rule is enabled.
     * @default true
     */
    java.lang.Boolean getEnabled();
    /**
     * Whether this rule is enabled.
     * @default true
     */
    void setEnabled(final java.lang.Boolean value);
    /**
     * Indicates when objects are deleted from Amazon S3 and Amazon Glacier.
     * 
     * The date value must be in ISO 8601 format. The time is always midnight UTC.
     * 
     * If you specify an expiration and transition time, you must use the same
     * time unit for both properties (either in days or by date). The
     * expiration time must also be later than the transition time.
     * @default No expiration date
     */
    java.time.Instant getExpirationDate();
    /**
     * Indicates when objects are deleted from Amazon S3 and Amazon Glacier.
     * 
     * The date value must be in ISO 8601 format. The time is always midnight UTC.
     * 
     * If you specify an expiration and transition time, you must use the same
     * time unit for both properties (either in days or by date). The
     * expiration time must also be later than the transition time.
     * @default No expiration date
     */
    void setExpirationDate(final java.time.Instant value);
    /**
     * Indicates the number of days after creation when objects are deleted from Amazon S3 and Amazon Glacier.
     * 
     * If you specify an expiration and transition time, you must use the same
     * time unit for both properties (either in days or by date). The
     * expiration time must also be later than the transition time.
     * @default No expiration timeout
     */
    java.lang.Number getExpirationInDays();
    /**
     * Indicates the number of days after creation when objects are deleted from Amazon S3 and Amazon Glacier.
     * 
     * If you specify an expiration and transition time, you must use the same
     * time unit for both properties (either in days or by date). The
     * expiration time must also be later than the transition time.
     * @default No expiration timeout
     */
    void setExpirationInDays(final java.lang.Number value);
    /**
     * A unique identifier for this rule. The value cannot be more than 255 characters.
     */
    java.lang.String getId();
    /**
     * A unique identifier for this rule. The value cannot be more than 255 characters.
     */
    void setId(final java.lang.String value);
    /**
     * Time between when a new version of the object is uploaded to the bucket and when old versions of the object expire.
     * 
     * For buckets with versioning enabled (or suspended), specifies the time,
     * in days, between when a new version of the object is uploaded to the
     * bucket and when old versions of the object expire. When object versions
     * expire, Amazon S3 permanently deletes them. If you specify a transition
     * and expiration time, the expiration time must be later than the
     * transition time.
     * @default No noncurrent version expiration
     */
    java.lang.Number getNoncurrentVersionExpirationInDays();
    /**
     * Time between when a new version of the object is uploaded to the bucket and when old versions of the object expire.
     * 
     * For buckets with versioning enabled (or suspended), specifies the time,
     * in days, between when a new version of the object is uploaded to the
     * bucket and when old versions of the object expire. When object versions
     * expire, Amazon S3 permanently deletes them. If you specify a transition
     * and expiration time, the expiration time must be later than the
     * transition time.
     * @default No noncurrent version expiration
     */
    void setNoncurrentVersionExpirationInDays(final java.lang.Number value);
    /**
     * One or more transition rules that specify when non-current objects transition to a specified storage class.
     * 
     * Only for for buckets with versioning enabled (or suspended).
     * 
     * If you specify a transition and expiration time, the expiration time
     * must be later than the transition time.
     */
    java.util.List<software.amazon.awscdk.services.s3.NoncurrentVersionTransition> getNoncurrentVersionTransitions();
    /**
     * One or more transition rules that specify when non-current objects transition to a specified storage class.
     * 
     * Only for for buckets with versioning enabled (or suspended).
     * 
     * If you specify a transition and expiration time, the expiration time
     * must be later than the transition time.
     */
    void setNoncurrentVersionTransitions(final java.util.List<software.amazon.awscdk.services.s3.NoncurrentVersionTransition> value);
    /**
     * Object key prefix that identifies one or more objects to which this rule applies.
     * @default Rule applies to all objects
     */
    java.lang.String getPrefix();
    /**
     * Object key prefix that identifies one or more objects to which this rule applies.
     * @default Rule applies to all objects
     */
    void setPrefix(final java.lang.String value);
    /**
     * The TagFilter property type specifies tags to use to identify a subset of objects for an Amazon S3 bucket.
     * @default Rule applies to all objects
     */
    java.util.Map<java.lang.String, java.lang.Object> getTagFilters();
    /**
     * The TagFilter property type specifies tags to use to identify a subset of objects for an Amazon S3 bucket.
     * @default Rule applies to all objects
     */
    void setTagFilters(final java.util.Map<java.lang.String, java.lang.Object> value);
    /**
     * One or more transition rules that specify when an object transitions to a specified storage class.
     * 
     * If you specify an expiration and transition time, you must use the same
     * time unit for both properties (either in days or by date). The
     * expiration time must also be later than the transition time.
     * @default No transition rules
     */
    java.util.List<software.amazon.awscdk.services.s3.Transition> getTransitions();
    /**
     * One or more transition rules that specify when an object transitions to a specified storage class.
     * 
     * If you specify an expiration and transition time, you must use the same
     * time unit for both properties (either in days or by date). The
     * expiration time must also be later than the transition time.
     * @default No transition rules
     */
    void setTransitions(final java.util.List<software.amazon.awscdk.services.s3.Transition> value);

    /**
     * @return a {@link Builder} of {@link LifecycleRule}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link LifecycleRule}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.Number _abortIncompleteMultipartUploadAfterDays;
        @javax.annotation.Nullable
        private java.lang.Boolean _enabled;
        @javax.annotation.Nullable
        private java.time.Instant _expirationDate;
        @javax.annotation.Nullable
        private java.lang.Number _expirationInDays;
        @javax.annotation.Nullable
        private java.lang.String _id;
        @javax.annotation.Nullable
        private java.lang.Number _noncurrentVersionExpirationInDays;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.s3.NoncurrentVersionTransition> _noncurrentVersionTransitions;
        @javax.annotation.Nullable
        private java.lang.String _prefix;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.Object> _tagFilters;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.s3.Transition> _transitions;

        /**
         * Sets the value of AbortIncompleteMultipartUploadAfterDays
         * @param value Specifies a lifecycle rule that aborts incomplete multipart uploads to an Amazon S3 bucket.

The AbortIncompleteMultipartUpload property type creates a lifecycle
rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
When Amazon S3 aborts a multipart upload, it deletes all parts
associated with the multipart upload.
         * @return {@code this}
         */
        public Builder withAbortIncompleteMultipartUploadAfterDays(@javax.annotation.Nullable final java.lang.Number value) {
            this._abortIncompleteMultipartUploadAfterDays = value;
            return this;
        }
        /**
         * Sets the value of Enabled
         * @param value Whether this rule is enabled.
         * @return {@code this}
         */
        public Builder withEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._enabled = value;
            return this;
        }
        /**
         * Sets the value of ExpirationDate
         * @param value Indicates when objects are deleted from Amazon S3 and Amazon Glacier.

The date value must be in ISO 8601 format. The time is always midnight UTC.

If you specify an expiration and transition time, you must use the same
time unit for both properties (either in days or by date). The
expiration time must also be later than the transition time.
         * @return {@code this}
         */
        public Builder withExpirationDate(@javax.annotation.Nullable final java.time.Instant value) {
            this._expirationDate = value;
            return this;
        }
        /**
         * Sets the value of ExpirationInDays
         * @param value Indicates the number of days after creation when objects are deleted from Amazon S3 and Amazon Glacier.

If you specify an expiration and transition time, you must use the same
time unit for both properties (either in days or by date). The
expiration time must also be later than the transition time.
         * @return {@code this}
         */
        public Builder withExpirationInDays(@javax.annotation.Nullable final java.lang.Number value) {
            this._expirationInDays = value;
            return this;
        }
        /**
         * Sets the value of Id
         * @param value A unique identifier for this rule. The value cannot be more than 255 characters.
         * @return {@code this}
         */
        public Builder withId(@javax.annotation.Nullable final java.lang.String value) {
            this._id = value;
            return this;
        }
        /**
         * Sets the value of NoncurrentVersionExpirationInDays
         * @param value Time between when a new version of the object is uploaded to the bucket and when old versions of the object expire.

For buckets with versioning enabled (or suspended), specifies the time,
in days, between when a new version of the object is uploaded to the
bucket and when old versions of the object expire. When object versions
expire, Amazon S3 permanently deletes them. If you specify a transition
and expiration time, the expiration time must be later than the
transition time.
         * @return {@code this}
         */
        public Builder withNoncurrentVersionExpirationInDays(@javax.annotation.Nullable final java.lang.Number value) {
            this._noncurrentVersionExpirationInDays = value;
            return this;
        }
        /**
         * Sets the value of NoncurrentVersionTransitions
         * @param value One or more transition rules that specify when non-current objects transition to a specified storage class.

Only for for buckets with versioning enabled (or suspended).

If you specify a transition and expiration time, the expiration time
must be later than the transition time.
         * @return {@code this}
         */
        public Builder withNoncurrentVersionTransitions(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.s3.NoncurrentVersionTransition> value) {
            this._noncurrentVersionTransitions = value;
            return this;
        }
        /**
         * Sets the value of Prefix
         * @param value Object key prefix that identifies one or more objects to which this rule applies.
         * @return {@code this}
         */
        public Builder withPrefix(@javax.annotation.Nullable final java.lang.String value) {
            this._prefix = value;
            return this;
        }
        /**
         * Sets the value of TagFilters
         * @param value The TagFilter property type specifies tags to use to identify a subset of objects for an Amazon S3 bucket.
         * @return {@code this}
         */
        public Builder withTagFilters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
            this._tagFilters = value;
            return this;
        }
        /**
         * Sets the value of Transitions
         * @param value One or more transition rules that specify when an object transitions to a specified storage class.

If you specify an expiration and transition time, you must use the same
time unit for both properties (either in days or by date). The
expiration time must also be later than the transition time.
         * @return {@code this}
         */
        public Builder withTransitions(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.s3.Transition> value) {
            this._transitions = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LifecycleRule}
         * @throws NullPointerException if any required attribute was not provided
         */
        public LifecycleRule build() {
            return new LifecycleRule() {
                @javax.annotation.Nullable
                private java.lang.Number $abortIncompleteMultipartUploadAfterDays = _abortIncompleteMultipartUploadAfterDays;
                @javax.annotation.Nullable
                private java.lang.Boolean $enabled = _enabled;
                @javax.annotation.Nullable
                private java.time.Instant $expirationDate = _expirationDate;
                @javax.annotation.Nullable
                private java.lang.Number $expirationInDays = _expirationInDays;
                @javax.annotation.Nullable
                private java.lang.String $id = _id;
                @javax.annotation.Nullable
                private java.lang.Number $noncurrentVersionExpirationInDays = _noncurrentVersionExpirationInDays;
                @javax.annotation.Nullable
                private java.util.List<software.amazon.awscdk.services.s3.NoncurrentVersionTransition> $noncurrentVersionTransitions = _noncurrentVersionTransitions;
                @javax.annotation.Nullable
                private java.lang.String $prefix = _prefix;
                @javax.annotation.Nullable
                private java.util.Map<java.lang.String, java.lang.Object> $tagFilters = _tagFilters;
                @javax.annotation.Nullable
                private java.util.List<software.amazon.awscdk.services.s3.Transition> $transitions = _transitions;

                @Override
                public java.lang.Number getAbortIncompleteMultipartUploadAfterDays() {
                    return this.$abortIncompleteMultipartUploadAfterDays;
                }

                @Override
                public void setAbortIncompleteMultipartUploadAfterDays(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$abortIncompleteMultipartUploadAfterDays = value;
                }

                @Override
                public java.lang.Boolean getEnabled() {
                    return this.$enabled;
                }

                @Override
                public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$enabled = value;
                }

                @Override
                public java.time.Instant getExpirationDate() {
                    return this.$expirationDate;
                }

                @Override
                public void setExpirationDate(@javax.annotation.Nullable final java.time.Instant value) {
                    this.$expirationDate = value;
                }

                @Override
                public java.lang.Number getExpirationInDays() {
                    return this.$expirationInDays;
                }

                @Override
                public void setExpirationInDays(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$expirationInDays = value;
                }

                @Override
                public java.lang.String getId() {
                    return this.$id;
                }

                @Override
                public void setId(@javax.annotation.Nullable final java.lang.String value) {
                    this.$id = value;
                }

                @Override
                public java.lang.Number getNoncurrentVersionExpirationInDays() {
                    return this.$noncurrentVersionExpirationInDays;
                }

                @Override
                public void setNoncurrentVersionExpirationInDays(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$noncurrentVersionExpirationInDays = value;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.s3.NoncurrentVersionTransition> getNoncurrentVersionTransitions() {
                    return this.$noncurrentVersionTransitions;
                }

                @Override
                public void setNoncurrentVersionTransitions(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.s3.NoncurrentVersionTransition> value) {
                    this.$noncurrentVersionTransitions = value;
                }

                @Override
                public java.lang.String getPrefix() {
                    return this.$prefix;
                }

                @Override
                public void setPrefix(@javax.annotation.Nullable final java.lang.String value) {
                    this.$prefix = value;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.Object> getTagFilters() {
                    return this.$tagFilters;
                }

                @Override
                public void setTagFilters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                    this.$tagFilters = value;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.s3.Transition> getTransitions() {
                    return this.$transitions;
                }

                @Override
                public void setTransitions(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.s3.Transition> value) {
                    this.$transitions = value;
                }

            };
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.LifecycleRule {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Specifies a lifecycle rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
         * 
         * The AbortIncompleteMultipartUpload property type creates a lifecycle
         * rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
         * When Amazon S3 aborts a multipart upload, it deletes all parts
         * associated with the multipart upload.
         * @default Incomplete uploads are never aborted
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getAbortIncompleteMultipartUploadAfterDays() {
            return this.jsiiGet("abortIncompleteMultipartUploadAfterDays", java.lang.Number.class);
        }

        /**
         * Specifies a lifecycle rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
         * 
         * The AbortIncompleteMultipartUpload property type creates a lifecycle
         * rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
         * When Amazon S3 aborts a multipart upload, it deletes all parts
         * associated with the multipart upload.
         * @default Incomplete uploads are never aborted
         */
        @Override
        public void setAbortIncompleteMultipartUploadAfterDays(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("abortIncompleteMultipartUploadAfterDays", value);
        }

        /**
         * Whether this rule is enabled.
         * @default true
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getEnabled() {
            return this.jsiiGet("enabled", java.lang.Boolean.class);
        }

        /**
         * Whether this rule is enabled.
         * @default true
         */
        @Override
        public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("enabled", value);
        }

        /**
         * Indicates when objects are deleted from Amazon S3 and Amazon Glacier.
         * 
         * The date value must be in ISO 8601 format. The time is always midnight UTC.
         * 
         * If you specify an expiration and transition time, you must use the same
         * time unit for both properties (either in days or by date). The
         * expiration time must also be later than the transition time.
         * @default No expiration date
         */
        @Override
        @javax.annotation.Nullable
        public java.time.Instant getExpirationDate() {
            return this.jsiiGet("expirationDate", java.time.Instant.class);
        }

        /**
         * Indicates when objects are deleted from Amazon S3 and Amazon Glacier.
         * 
         * The date value must be in ISO 8601 format. The time is always midnight UTC.
         * 
         * If you specify an expiration and transition time, you must use the same
         * time unit for both properties (either in days or by date). The
         * expiration time must also be later than the transition time.
         * @default No expiration date
         */
        @Override
        public void setExpirationDate(@javax.annotation.Nullable final java.time.Instant value) {
            this.jsiiSet("expirationDate", value);
        }

        /**
         * Indicates the number of days after creation when objects are deleted from Amazon S3 and Amazon Glacier.
         * 
         * If you specify an expiration and transition time, you must use the same
         * time unit for both properties (either in days or by date). The
         * expiration time must also be later than the transition time.
         * @default No expiration timeout
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getExpirationInDays() {
            return this.jsiiGet("expirationInDays", java.lang.Number.class);
        }

        /**
         * Indicates the number of days after creation when objects are deleted from Amazon S3 and Amazon Glacier.
         * 
         * If you specify an expiration and transition time, you must use the same
         * time unit for both properties (either in days or by date). The
         * expiration time must also be later than the transition time.
         * @default No expiration timeout
         */
        @Override
        public void setExpirationInDays(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("expirationInDays", value);
        }

        /**
         * A unique identifier for this rule. The value cannot be more than 255 characters.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getId() {
            return this.jsiiGet("id", java.lang.String.class);
        }

        /**
         * A unique identifier for this rule. The value cannot be more than 255 characters.
         */
        @Override
        public void setId(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("id", value);
        }

        /**
         * Time between when a new version of the object is uploaded to the bucket and when old versions of the object expire.
         * 
         * For buckets with versioning enabled (or suspended), specifies the time,
         * in days, between when a new version of the object is uploaded to the
         * bucket and when old versions of the object expire. When object versions
         * expire, Amazon S3 permanently deletes them. If you specify a transition
         * and expiration time, the expiration time must be later than the
         * transition time.
         * @default No noncurrent version expiration
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getNoncurrentVersionExpirationInDays() {
            return this.jsiiGet("noncurrentVersionExpirationInDays", java.lang.Number.class);
        }

        /**
         * Time between when a new version of the object is uploaded to the bucket and when old versions of the object expire.
         * 
         * For buckets with versioning enabled (or suspended), specifies the time,
         * in days, between when a new version of the object is uploaded to the
         * bucket and when old versions of the object expire. When object versions
         * expire, Amazon S3 permanently deletes them. If you specify a transition
         * and expiration time, the expiration time must be later than the
         * transition time.
         * @default No noncurrent version expiration
         */
        @Override
        public void setNoncurrentVersionExpirationInDays(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("noncurrentVersionExpirationInDays", value);
        }

        /**
         * One or more transition rules that specify when non-current objects transition to a specified storage class.
         * 
         * Only for for buckets with versioning enabled (or suspended).
         * 
         * If you specify a transition and expiration time, the expiration time
         * must be later than the transition time.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.s3.NoncurrentVersionTransition> getNoncurrentVersionTransitions() {
            return this.jsiiGet("noncurrentVersionTransitions", java.util.List.class);
        }

        /**
         * One or more transition rules that specify when non-current objects transition to a specified storage class.
         * 
         * Only for for buckets with versioning enabled (or suspended).
         * 
         * If you specify a transition and expiration time, the expiration time
         * must be later than the transition time.
         */
        @Override
        public void setNoncurrentVersionTransitions(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.s3.NoncurrentVersionTransition> value) {
            this.jsiiSet("noncurrentVersionTransitions", value);
        }

        /**
         * Object key prefix that identifies one or more objects to which this rule applies.
         * @default Rule applies to all objects
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getPrefix() {
            return this.jsiiGet("prefix", java.lang.String.class);
        }

        /**
         * Object key prefix that identifies one or more objects to which this rule applies.
         * @default Rule applies to all objects
         */
        @Override
        public void setPrefix(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("prefix", value);
        }

        /**
         * The TagFilter property type specifies tags to use to identify a subset of objects for an Amazon S3 bucket.
         * @default Rule applies to all objects
         */
        @Override
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.Object> getTagFilters() {
            return this.jsiiGet("tagFilters", java.util.Map.class);
        }

        /**
         * The TagFilter property type specifies tags to use to identify a subset of objects for an Amazon S3 bucket.
         * @default Rule applies to all objects
         */
        @Override
        public void setTagFilters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
            this.jsiiSet("tagFilters", value);
        }

        /**
         * One or more transition rules that specify when an object transitions to a specified storage class.
         * 
         * If you specify an expiration and transition time, you must use the same
         * time unit for both properties (either in days or by date). The
         * expiration time must also be later than the transition time.
         * @default No transition rules
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.s3.Transition> getTransitions() {
            return this.jsiiGet("transitions", java.util.List.class);
        }

        /**
         * One or more transition rules that specify when an object transitions to a specified storage class.
         * 
         * If you specify an expiration and transition time, you must use the same
         * time unit for both properties (either in days or by date). The
         * expiration time must also be later than the transition time.
         * @default No transition rules
         */
        @Override
        public void setTransitions(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.s3.Transition> value) {
            this.jsiiSet("transitions", value);
        }
    }
}
