package software.amazon.awscdk.services.s3;

/**
 * Describes when noncurrent versions transition to a specified storage class.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.4 (build e80a889)", date = "2018-09-11T09:58:01.383Z")
public interface NoncurrentVersionTransition extends software.amazon.jsii.JsiiSerializable {
    /**
     * The storage class to which you want the object to transition.
     */
    software.amazon.awscdk.services.s3.StorageClass getStorageClass();
    /**
     * The storage class to which you want the object to transition.
     */
    void setStorageClass(final software.amazon.awscdk.services.s3.StorageClass value);
    /**
     * Indicates the number of days after creation when objects are transitioned to the specified storage class.
     * @default No transition count.
     */
    java.lang.Number getTransitionInDays();
    /**
     * Indicates the number of days after creation when objects are transitioned to the specified storage class.
     * @default No transition count.
     */
    void setTransitionInDays(final java.lang.Number value);

    /**
     * @return a {@link Builder} of {@link NoncurrentVersionTransition}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link NoncurrentVersionTransition}
     */
    final class Builder {
        private software.amazon.awscdk.services.s3.StorageClass _storageClass;
        private java.lang.Number _transitionInDays;

        /**
         * Sets the value of StorageClass
         * @param value The storage class to which you want the object to transition.
         * @return {@code this}
         */
        public Builder withStorageClass(final software.amazon.awscdk.services.s3.StorageClass value) {
            this._storageClass = java.util.Objects.requireNonNull(value, "storageClass is required");
            return this;
        }
        /**
         * Sets the value of TransitionInDays
         * @param value Indicates the number of days after creation when objects are transitioned to the specified storage class.
         * @return {@code this}
         */
        public Builder withTransitionInDays(final java.lang.Number value) {
            this._transitionInDays = java.util.Objects.requireNonNull(value, "transitionInDays is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NoncurrentVersionTransition}
         * @throws NullPointerException if any required attribute was not provided
         */
        public NoncurrentVersionTransition build() {
            return new NoncurrentVersionTransition() {
                private software.amazon.awscdk.services.s3.StorageClass $storageClass = java.util.Objects.requireNonNull(_storageClass, "storageClass is required");
                private java.lang.Number $transitionInDays = java.util.Objects.requireNonNull(_transitionInDays, "transitionInDays is required");

                @Override
                public software.amazon.awscdk.services.s3.StorageClass getStorageClass() {
                    return this.$storageClass;
                }

                @Override
                public void setStorageClass(final software.amazon.awscdk.services.s3.StorageClass value) {
                    this.$storageClass = java.util.Objects.requireNonNull(value, "storageClass is required");
                }

                @Override
                public java.lang.Number getTransitionInDays() {
                    return this.$transitionInDays;
                }

                @Override
                public void setTransitionInDays(final java.lang.Number value) {
                    this.$transitionInDays = java.util.Objects.requireNonNull(value, "transitionInDays is required");
                }

            };
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.NoncurrentVersionTransition {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The storage class to which you want the object to transition.
         */
        @Override
        public software.amazon.awscdk.services.s3.StorageClass getStorageClass() {
            return this.jsiiGet("storageClass", software.amazon.awscdk.services.s3.StorageClass.class);
        }

        /**
         * The storage class to which you want the object to transition.
         */
        @Override
        public void setStorageClass(final software.amazon.awscdk.services.s3.StorageClass value) {
            this.jsiiSet("storageClass", java.util.Objects.requireNonNull(value, "storageClass is required"));
        }

        /**
         * Indicates the number of days after creation when objects are transitioned to the specified storage class.
         * @default No transition count.
         */
        @Override
        public java.lang.Number getTransitionInDays() {
            return this.jsiiGet("transitionInDays", java.lang.Number.class);
        }

        /**
         * Indicates the number of days after creation when objects are transitioned to the specified storage class.
         * @default No transition count.
         */
        @Override
        public void setTransitionInDays(final java.lang.Number value) {
            this.jsiiSet("transitionInDays", java.util.Objects.requireNonNull(value, "transitionInDays is required"));
        }
    }
}
