package software.amazon.awscdk.services.s3;

/**
 * Common properties for creating {@link PipelineSource} -
 * either directly, through its constructor,
 * or through {@link BucketRef#addToPipeline}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.5 (build 845cc48)", date = "2018-09-14T09:18:26.850Z")
public interface CommonPipelineSourceProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The name of the source's output artifact. Output artifacts are used by CodePipeline as
     * inputs into other actions.
     */
    java.lang.String getArtifactName();
    /**
     * The name of the source's output artifact. Output artifacts are used by CodePipeline as
     * inputs into other actions.
     */
    void setArtifactName(final java.lang.String value);
    /**
     * The key within the S3 bucket that stores the source code.
     * @example 'path/to/file.zip'
     */
    java.lang.String getBucketKey();
    /**
     * The key within the S3 bucket that stores the source code.
     * @example 'path/to/file.zip'
     */
    void setBucketKey(final java.lang.String value);
    /**
     * Whether or not AWS CodePipeline should poll for source changes
     * @default true
     */
    java.lang.Boolean getPollForSourceChanges();
    /**
     * Whether or not AWS CodePipeline should poll for source changes
     * @default true
     */
    void setPollForSourceChanges(final java.lang.Boolean value);

    /**
     * @return a {@link Builder} of {@link CommonPipelineSourceProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CommonPipelineSourceProps}
     */
    final class Builder {
        private java.lang.String _artifactName;
        private java.lang.String _bucketKey;
        @javax.annotation.Nullable
        private java.lang.Boolean _pollForSourceChanges;

        /**
         * Sets the value of ArtifactName
         * @param value The name of the source's output artifact. Output artifacts are used by CodePipeline as
inputs into other actions.
         * @return {@code this}
         */
        public Builder withArtifactName(final java.lang.String value) {
            this._artifactName = java.util.Objects.requireNonNull(value, "artifactName is required");
            return this;
        }
        /**
         * Sets the value of BucketKey
         * @param value The key within the S3 bucket that stores the source code.
         * @return {@code this}
         */
        public Builder withBucketKey(final java.lang.String value) {
            this._bucketKey = java.util.Objects.requireNonNull(value, "bucketKey is required");
            return this;
        }
        /**
         * Sets the value of PollForSourceChanges
         * @param value Whether or not AWS CodePipeline should poll for source changes
         * @return {@code this}
         */
        public Builder withPollForSourceChanges(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._pollForSourceChanges = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CommonPipelineSourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public CommonPipelineSourceProps build() {
            return new CommonPipelineSourceProps() {
                private java.lang.String $artifactName = java.util.Objects.requireNonNull(_artifactName, "artifactName is required");
                private java.lang.String $bucketKey = java.util.Objects.requireNonNull(_bucketKey, "bucketKey is required");
                @javax.annotation.Nullable
                private java.lang.Boolean $pollForSourceChanges = _pollForSourceChanges;

                @Override
                public java.lang.String getArtifactName() {
                    return this.$artifactName;
                }

                @Override
                public void setArtifactName(final java.lang.String value) {
                    this.$artifactName = java.util.Objects.requireNonNull(value, "artifactName is required");
                }

                @Override
                public java.lang.String getBucketKey() {
                    return this.$bucketKey;
                }

                @Override
                public void setBucketKey(final java.lang.String value) {
                    this.$bucketKey = java.util.Objects.requireNonNull(value, "bucketKey is required");
                }

                @Override
                public java.lang.Boolean getPollForSourceChanges() {
                    return this.$pollForSourceChanges;
                }

                @Override
                public void setPollForSourceChanges(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$pollForSourceChanges = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CommonPipelineSourceProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The name of the source's output artifact. Output artifacts are used by CodePipeline as
         * inputs into other actions.
         */
        @Override
        public java.lang.String getArtifactName() {
            return this.jsiiGet("artifactName", java.lang.String.class);
        }

        /**
         * The name of the source's output artifact. Output artifacts are used by CodePipeline as
         * inputs into other actions.
         */
        @Override
        public void setArtifactName(final java.lang.String value) {
            this.jsiiSet("artifactName", java.util.Objects.requireNonNull(value, "artifactName is required"));
        }

        /**
         * The key within the S3 bucket that stores the source code.
         * @example 'path/to/file.zip'
         */
        @Override
        public java.lang.String getBucketKey() {
            return this.jsiiGet("bucketKey", java.lang.String.class);
        }

        /**
         * The key within the S3 bucket that stores the source code.
         * @example 'path/to/file.zip'
         */
        @Override
        public void setBucketKey(final java.lang.String value) {
            this.jsiiSet("bucketKey", java.util.Objects.requireNonNull(value, "bucketKey is required"));
        }

        /**
         * Whether or not AWS CodePipeline should poll for source changes
         * @default true
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getPollForSourceChanges() {
            return this.jsiiGet("pollForSourceChanges", java.lang.Boolean.class);
        }

        /**
         * Whether or not AWS CodePipeline should poll for source changes
         * @default true
         */
        @Override
        public void setPollForSourceChanges(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("pollForSourceChanges", value);
        }
    }
}
