package software.amazon.awscdk.services.s3;

@javax.annotation.Generated(value = "jsii-pacmak/0.7.6 (build 04cb6bb)", date = "2018-09-20T13:05:16.240Z")
public interface BucketProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Physical name of this bucket.
     * @default Assigned by CloudFormation (recommended)
     */
    java.lang.String getBucketName();
    /**
     * Physical name of this bucket.
     * @default Assigned by CloudFormation (recommended)
     */
    void setBucketName(final java.lang.String value);
    /**
     * The kind of server-side encryption to apply to this bucket.
     * 
     * If you choose KMS, you can specify a KMS key via `encryptionKey`. If
     * encryption key is not specified, a key will automatically be created.
     * @default Unencrypted
     */
    software.amazon.awscdk.services.s3.BucketEncryption getEncryption();
    /**
     * The kind of server-side encryption to apply to this bucket.
     * 
     * If you choose KMS, you can specify a KMS key via `encryptionKey`. If
     * encryption key is not specified, a key will automatically be created.
     * @default Unencrypted
     */
    void setEncryption(final software.amazon.awscdk.services.s3.BucketEncryption value);
    /**
     * External KMS key to use for bucket encryption.
     * 
     * The 'encryption' property must be either not specified or set to "Kms".
     * An error will be emitted if encryption is set to "Unencrypted" or
     * "Managed".
     * @default If encryption is set to "Kms" and this property is undefined, a new KMS key will be created and associated with this bucket.
     */
    software.amazon.awscdk.services.kms.EncryptionKeyRef getEncryptionKey();
    /**
     * External KMS key to use for bucket encryption.
     * 
     * The 'encryption' property must be either not specified or set to "Kms".
     * An error will be emitted if encryption is set to "Unencrypted" or
     * "Managed".
     * @default If encryption is set to "Kms" and this property is undefined, a new KMS key will be created and associated with this bucket.
     */
    void setEncryptionKey(final software.amazon.awscdk.services.kms.EncryptionKeyRef value);
    /**
     * Rules that define how Amazon S3 manages objects during their lifetime.
     * @default No lifecycle rules
     */
    java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> getLifecycleRules();
    /**
     * Rules that define how Amazon S3 manages objects during their lifetime.
     * @default No lifecycle rules
     */
    void setLifecycleRules(final java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> value);
    /**
     * Policy to apply when the bucket is removed from this stack.
     * @default By default, the bucket will be destroyed if it is removed from the stack.
     */
    software.amazon.awscdk.RemovalPolicy getRemovalPolicy();
    /**
     * Policy to apply when the bucket is removed from this stack.
     * @default By default, the bucket will be destroyed if it is removed from the stack.
     */
    void setRemovalPolicy(final software.amazon.awscdk.RemovalPolicy value);
    /**
     * Whether this bucket should have versioning turned on or not.
     * @default false
     */
    java.lang.Boolean getVersioned();
    /**
     * Whether this bucket should have versioning turned on or not.
     * @default false
     */
    void setVersioned(final java.lang.Boolean value);

    /**
     * @return a {@link Builder} of {@link BucketProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link BucketProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.String _bucketName;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.s3.BucketEncryption _encryption;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.kms.EncryptionKeyRef _encryptionKey;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> _lifecycleRules;
        @javax.annotation.Nullable
        private software.amazon.awscdk.RemovalPolicy _removalPolicy;
        @javax.annotation.Nullable
        private java.lang.Boolean _versioned;

        /**
         * Sets the value of BucketName
         * @param value Physical name of this bucket.
         * @return {@code this}
         */
        public Builder withBucketName(@javax.annotation.Nullable final java.lang.String value) {
            this._bucketName = value;
            return this;
        }
        /**
         * Sets the value of Encryption
         * @param value The kind of server-side encryption to apply to this bucket.

If you choose KMS, you can specify a KMS key via `encryptionKey`. If
encryption key is not specified, a key will automatically be created.
         * @return {@code this}
         */
        public Builder withEncryption(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.BucketEncryption value) {
            this._encryption = value;
            return this;
        }
        /**
         * Sets the value of EncryptionKey
         * @param value External KMS key to use for bucket encryption.

The 'encryption' property must be either not specified or set to "Kms".
An error will be emitted if encryption is set to "Unencrypted" or
"Managed".
         * @return {@code this}
         */
        public Builder withEncryptionKey(@javax.annotation.Nullable final software.amazon.awscdk.services.kms.EncryptionKeyRef value) {
            this._encryptionKey = value;
            return this;
        }
        /**
         * Sets the value of LifecycleRules
         * @param value Rules that define how Amazon S3 manages objects during their lifetime.
         * @return {@code this}
         */
        public Builder withLifecycleRules(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> value) {
            this._lifecycleRules = value;
            return this;
        }
        /**
         * Sets the value of RemovalPolicy
         * @param value Policy to apply when the bucket is removed from this stack.
         * @return {@code this}
         */
        public Builder withRemovalPolicy(@javax.annotation.Nullable final software.amazon.awscdk.RemovalPolicy value) {
            this._removalPolicy = value;
            return this;
        }
        /**
         * Sets the value of Versioned
         * @param value Whether this bucket should have versioning turned on or not.
         * @return {@code this}
         */
        public Builder withVersioned(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._versioned = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BucketProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public BucketProps build() {
            return new BucketProps() {
                @javax.annotation.Nullable
                private java.lang.String $bucketName = _bucketName;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.s3.BucketEncryption $encryption = _encryption;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.kms.EncryptionKeyRef $encryptionKey = _encryptionKey;
                @javax.annotation.Nullable
                private java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> $lifecycleRules = _lifecycleRules;
                @javax.annotation.Nullable
                private software.amazon.awscdk.RemovalPolicy $removalPolicy = _removalPolicy;
                @javax.annotation.Nullable
                private java.lang.Boolean $versioned = _versioned;

                @Override
                public java.lang.String getBucketName() {
                    return this.$bucketName;
                }

                @Override
                public void setBucketName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$bucketName = value;
                }

                @Override
                public software.amazon.awscdk.services.s3.BucketEncryption getEncryption() {
                    return this.$encryption;
                }

                @Override
                public void setEncryption(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.BucketEncryption value) {
                    this.$encryption = value;
                }

                @Override
                public software.amazon.awscdk.services.kms.EncryptionKeyRef getEncryptionKey() {
                    return this.$encryptionKey;
                }

                @Override
                public void setEncryptionKey(@javax.annotation.Nullable final software.amazon.awscdk.services.kms.EncryptionKeyRef value) {
                    this.$encryptionKey = value;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> getLifecycleRules() {
                    return this.$lifecycleRules;
                }

                @Override
                public void setLifecycleRules(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> value) {
                    this.$lifecycleRules = value;
                }

                @Override
                public software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
                    return this.$removalPolicy;
                }

                @Override
                public void setRemovalPolicy(@javax.annotation.Nullable final software.amazon.awscdk.RemovalPolicy value) {
                    this.$removalPolicy = value;
                }

                @Override
                public java.lang.Boolean getVersioned() {
                    return this.$versioned;
                }

                @Override
                public void setVersioned(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$versioned = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.BucketProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Physical name of this bucket.
         * @default Assigned by CloudFormation (recommended)
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getBucketName() {
            return this.jsiiGet("bucketName", java.lang.String.class);
        }

        /**
         * Physical name of this bucket.
         * @default Assigned by CloudFormation (recommended)
         */
        @Override
        public void setBucketName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("bucketName", value);
        }

        /**
         * The kind of server-side encryption to apply to this bucket.
         * 
         * If you choose KMS, you can specify a KMS key via `encryptionKey`. If
         * encryption key is not specified, a key will automatically be created.
         * @default Unencrypted
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.s3.BucketEncryption getEncryption() {
            return this.jsiiGet("encryption", software.amazon.awscdk.services.s3.BucketEncryption.class);
        }

        /**
         * The kind of server-side encryption to apply to this bucket.
         * 
         * If you choose KMS, you can specify a KMS key via `encryptionKey`. If
         * encryption key is not specified, a key will automatically be created.
         * @default Unencrypted
         */
        @Override
        public void setEncryption(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.BucketEncryption value) {
            this.jsiiSet("encryption", value);
        }

        /**
         * External KMS key to use for bucket encryption.
         * 
         * The 'encryption' property must be either not specified or set to "Kms".
         * An error will be emitted if encryption is set to "Unencrypted" or
         * "Managed".
         * @default If encryption is set to "Kms" and this property is undefined, a new KMS key will be created and associated with this bucket.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.kms.EncryptionKeyRef getEncryptionKey() {
            return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.EncryptionKeyRef.class);
        }

        /**
         * External KMS key to use for bucket encryption.
         * 
         * The 'encryption' property must be either not specified or set to "Kms".
         * An error will be emitted if encryption is set to "Unencrypted" or
         * "Managed".
         * @default If encryption is set to "Kms" and this property is undefined, a new KMS key will be created and associated with this bucket.
         */
        @Override
        public void setEncryptionKey(@javax.annotation.Nullable final software.amazon.awscdk.services.kms.EncryptionKeyRef value) {
            this.jsiiSet("encryptionKey", value);
        }

        /**
         * Rules that define how Amazon S3 manages objects during their lifetime.
         * @default No lifecycle rules
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> getLifecycleRules() {
            return this.jsiiGet("lifecycleRules", java.util.List.class);
        }

        /**
         * Rules that define how Amazon S3 manages objects during their lifetime.
         * @default No lifecycle rules
         */
        @Override
        public void setLifecycleRules(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> value) {
            this.jsiiSet("lifecycleRules", value);
        }

        /**
         * Policy to apply when the bucket is removed from this stack.
         * @default By default, the bucket will be destroyed if it is removed from the stack.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
            return this.jsiiGet("removalPolicy", software.amazon.awscdk.RemovalPolicy.class);
        }

        /**
         * Policy to apply when the bucket is removed from this stack.
         * @default By default, the bucket will be destroyed if it is removed from the stack.
         */
        @Override
        public void setRemovalPolicy(@javax.annotation.Nullable final software.amazon.awscdk.RemovalPolicy value) {
            this.jsiiSet("removalPolicy", value);
        }

        /**
         * Whether this bucket should have versioning turned on or not.
         * @default false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getVersioned() {
            return this.jsiiGet("versioned", java.lang.Boolean.class);
        }

        /**
         * Whether this bucket should have versioning turned on or not.
         * @default false
         */
        @Override
        public void setVersioned(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("versioned", value);
        }
    }
}
