package software.amazon.awscdk.services.s3;

/**
 * A CloudFormation `AWS::S3::Bucket`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-11T14:13:08.316Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket")
public class CfnBucket extends software.amazon.awscdk.core.CfnResource {
    protected CfnBucket(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.s3.CfnBucket.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }
    /**
     * Create a new `AWS::S3::Bucket`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnBucket(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucketProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }
    /**
     * Create a new `AWS::S3::Bucket`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnBucket(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getAttrArn() {
        return this.jsiiGet("attrArn", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getAttrDomainName() {
        return this.jsiiGet("attrDomainName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getAttrDualStackDomainName() {
        return this.jsiiGet("attrDualStackDomainName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getAttrRegionalDomainName() {
        return this.jsiiGet("attrRegionalDomainName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getAttrWebsiteUrl() {
        return this.jsiiGet("attrWebsiteUrl", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return this.jsiiGet("cfnProperties", java.util.Map.class);
    }

    /**
     * `AWS::S3::Bucket.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::S3::Bucket.AccelerateConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accelerateconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.Object getAccelerateConfiguration() {
        return this.jsiiGet("accelerateConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.AccelerateConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accelerateconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccelerateConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.AccelerateConfigurationProperty value) {
        this.jsiiSet("accelerateConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.AccelerateConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accelerateconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccelerateConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("accelerateConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.AccessControl`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accesscontrol
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.String getAccessControl() {
        return this.jsiiGet("accessControl", java.lang.String.class);
    }

    /**
     * `AWS::S3::Bucket.AccessControl`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accesscontrol
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessControl(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("accessControl", value);
    }

    /**
     * `AWS::S3::Bucket.AnalyticsConfigurations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-analyticsconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.Object getAnalyticsConfigurations() {
        return this.jsiiGet("analyticsConfigurations", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.AnalyticsConfigurations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-analyticsconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAnalyticsConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("analyticsConfigurations", value);
    }

    /**
     * `AWS::S3::Bucket.AnalyticsConfigurations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-analyticsconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAnalyticsConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
        this.jsiiSet("analyticsConfigurations", value);
    }

    /**
     * `AWS::S3::Bucket.BucketEncryption`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-bucketencryption
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.Object getBucketEncryption() {
        return this.jsiiGet("bucketEncryption", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.BucketEncryption`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-bucketencryption
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBucketEncryption(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("bucketEncryption", value);
    }

    /**
     * `AWS::S3::Bucket.BucketEncryption`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-bucketencryption
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBucketEncryption(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.BucketEncryptionProperty value) {
        this.jsiiSet("bucketEncryption", value);
    }

    /**
     * `AWS::S3::Bucket.BucketName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.String getBucketName() {
        return this.jsiiGet("bucketName", java.lang.String.class);
    }

    /**
     * `AWS::S3::Bucket.BucketName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBucketName(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("bucketName", value);
    }

    /**
     * `AWS::S3::Bucket.CorsConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-crossoriginconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.Object getCorsConfiguration() {
        return this.jsiiGet("corsConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.CorsConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-crossoriginconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCorsConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("corsConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.CorsConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-crossoriginconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCorsConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.CorsConfigurationProperty value) {
        this.jsiiSet("corsConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.InventoryConfigurations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-inventoryconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.Object getInventoryConfigurations() {
        return this.jsiiGet("inventoryConfigurations", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.InventoryConfigurations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-inventoryconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInventoryConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("inventoryConfigurations", value);
    }

    /**
     * `AWS::S3::Bucket.InventoryConfigurations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-inventoryconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInventoryConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
        this.jsiiSet("inventoryConfigurations", value);
    }

    /**
     * `AWS::S3::Bucket.LifecycleConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-lifecycleconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.Object getLifecycleConfiguration() {
        return this.jsiiGet("lifecycleConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.LifecycleConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-lifecycleconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLifecycleConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("lifecycleConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.LifecycleConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-lifecycleconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLifecycleConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.LifecycleConfigurationProperty value) {
        this.jsiiSet("lifecycleConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.LoggingConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-loggingconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.Object getLoggingConfiguration() {
        return this.jsiiGet("loggingConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.LoggingConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-loggingconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoggingConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("loggingConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.LoggingConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-loggingconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoggingConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.LoggingConfigurationProperty value) {
        this.jsiiSet("loggingConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.MetricsConfigurations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-metricsconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.Object getMetricsConfigurations() {
        return this.jsiiGet("metricsConfigurations", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.MetricsConfigurations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-metricsconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetricsConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("metricsConfigurations", value);
    }

    /**
     * `AWS::S3::Bucket.MetricsConfigurations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-metricsconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetricsConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
        this.jsiiSet("metricsConfigurations", value);
    }

    /**
     * `AWS::S3::Bucket.NotificationConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-notification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.Object getNotificationConfiguration() {
        return this.jsiiGet("notificationConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.NotificationConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-notification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotificationConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("notificationConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.NotificationConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-notification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotificationConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.NotificationConfigurationProperty value) {
        this.jsiiSet("notificationConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.ObjectLockConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.Object getObjectLockConfiguration() {
        return this.jsiiGet("objectLockConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.ObjectLockConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setObjectLockConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("objectLockConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.ObjectLockConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setObjectLockConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.ObjectLockConfigurationProperty value) {
        this.jsiiSet("objectLockConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.ObjectLockEnabled`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockenabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.Object getObjectLockEnabled() {
        return this.jsiiGet("objectLockEnabled", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.ObjectLockEnabled`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockenabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setObjectLockEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
        this.jsiiSet("objectLockEnabled", value);
    }

    /**
     * `AWS::S3::Bucket.ObjectLockEnabled`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockenabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setObjectLockEnabled(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("objectLockEnabled", value);
    }

    /**
     * `AWS::S3::Bucket.PublicAccessBlockConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-publicaccessblockconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.Object getPublicAccessBlockConfiguration() {
        return this.jsiiGet("publicAccessBlockConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.PublicAccessBlockConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-publicaccessblockconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPublicAccessBlockConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("publicAccessBlockConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.PublicAccessBlockConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-publicaccessblockconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPublicAccessBlockConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.PublicAccessBlockConfigurationProperty value) {
        this.jsiiSet("publicAccessBlockConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.ReplicationConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-replicationconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.Object getReplicationConfiguration() {
        return this.jsiiGet("replicationConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.ReplicationConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-replicationconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicationConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("replicationConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.ReplicationConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-replicationconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicationConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.ReplicationConfigurationProperty value) {
        this.jsiiSet("replicationConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.VersioningConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-versioning
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.Object getVersioningConfiguration() {
        return this.jsiiGet("versioningConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.VersioningConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-versioning
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVersioningConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("versioningConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.VersioningConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-versioning
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVersioningConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.VersioningConfigurationProperty value) {
        this.jsiiSet("versioningConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.WebsiteConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-websiteconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.Object getWebsiteConfiguration() {
        return this.jsiiGet("websiteConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.WebsiteConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-websiteconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWebsiteConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("websiteConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.WebsiteConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-websiteconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWebsiteConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.WebsiteConfigurationProperty value) {
        this.jsiiSet("websiteConfiguration", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AbortIncompleteMultipartUploadProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Number getDaysAfterInitiation();

        /**
         * @return a {@link Builder} of {@link AbortIncompleteMultipartUploadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AbortIncompleteMultipartUploadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.Number _daysAfterInitiation;

            /**
             * Sets the value of DaysAfterInitiation
             * @param value `CfnBucket.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withDaysAfterInitiation(final java.lang.Number value) {
                this._daysAfterInitiation = java.util.Objects.requireNonNull(value, "daysAfterInitiation is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AbortIncompleteMultipartUploadProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public AbortIncompleteMultipartUploadProperty build() {
                return new AbortIncompleteMultipartUploadProperty() {
                    private final java.lang.Number $daysAfterInitiation = java.util.Objects.requireNonNull(_daysAfterInitiation, "daysAfterInitiation is required");

                    @Override
                    public java.lang.Number getDaysAfterInitiation() {
                        return this.$daysAfterInitiation;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("daysAfterInitiation", om.valueToTree(this.getDaysAfterInitiation()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.AbortIncompleteMultipartUploadProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.Number getDaysAfterInitiation() {
                return this.jsiiGet("daysAfterInitiation", java.lang.Number.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccelerateConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.AccelerateConfigurationProperty.AccelerationStatus`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html#cfn-s3-bucket-accelerateconfiguration-accelerationstatus
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getAccelerationStatus();

        /**
         * @return a {@link Builder} of {@link AccelerateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AccelerateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _accelerationStatus;

            /**
             * Sets the value of AccelerationStatus
             * @param value `CfnBucket.AccelerateConfigurationProperty.AccelerationStatus`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withAccelerationStatus(final java.lang.String value) {
                this._accelerationStatus = java.util.Objects.requireNonNull(value, "accelerationStatus is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccelerateConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public AccelerateConfigurationProperty build() {
                return new AccelerateConfigurationProperty() {
                    private final java.lang.String $accelerationStatus = java.util.Objects.requireNonNull(_accelerationStatus, "accelerationStatus is required");

                    @Override
                    public java.lang.String getAccelerationStatus() {
                        return this.$accelerationStatus;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("accelerationStatus", om.valueToTree(this.getAccelerationStatus()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.AccelerateConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.AccelerateConfigurationProperty.AccelerationStatus`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html#cfn-s3-bucket-accelerateconfiguration-accelerationstatus
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getAccelerationStatus() {
                return this.jsiiGet("accelerationStatus", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccessControlTranslationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.AccessControlTranslationProperty.Owner`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html#cfn-s3-bucket-accesscontroltranslation-owner
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getOwner();

        /**
         * @return a {@link Builder} of {@link AccessControlTranslationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AccessControlTranslationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _owner;

            /**
             * Sets the value of Owner
             * @param value `CfnBucket.AccessControlTranslationProperty.Owner`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withOwner(final java.lang.String value) {
                this._owner = java.util.Objects.requireNonNull(value, "owner is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessControlTranslationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public AccessControlTranslationProperty build() {
                return new AccessControlTranslationProperty() {
                    private final java.lang.String $owner = java.util.Objects.requireNonNull(_owner, "owner is required");

                    @Override
                    public java.lang.String getOwner() {
                        return this.$owner;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("owner", om.valueToTree(this.getOwner()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.AccessControlTranslationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.AccessControlTranslationProperty.Owner`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html#cfn-s3-bucket-accesscontroltranslation-owner
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getOwner() {
                return this.jsiiGet("owner", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnalyticsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.AnalyticsConfigurationProperty.Id`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-id
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getId();
        /**
         * `CfnBucket.AnalyticsConfigurationProperty.StorageClassAnalysis`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getStorageClassAnalysis();
        /**
         * `CfnBucket.AnalyticsConfigurationProperty.Prefix`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-prefix
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getPrefix();
        /**
         * `CfnBucket.AnalyticsConfigurationProperty.TagFilters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getTagFilters();

        /**
         * @return a {@link Builder} of {@link AnalyticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AnalyticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _id;
            private java.lang.Object _storageClassAnalysis;
            @javax.annotation.Nullable
            private java.lang.String _prefix;
            @javax.annotation.Nullable
            private java.lang.Object _tagFilters;

            /**
             * Sets the value of Id
             * @param value `CfnBucket.AnalyticsConfigurationProperty.Id`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withId(final java.lang.String value) {
                this._id = java.util.Objects.requireNonNull(value, "id is required");
                return this;
            }
            /**
             * Sets the value of StorageClassAnalysis
             * @param value `CfnBucket.AnalyticsConfigurationProperty.StorageClassAnalysis`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withStorageClassAnalysis(final software.amazon.awscdk.core.IResolvable value) {
                this._storageClassAnalysis = java.util.Objects.requireNonNull(value, "storageClassAnalysis is required");
                return this;
            }
            /**
             * Sets the value of StorageClassAnalysis
             * @param value `CfnBucket.AnalyticsConfigurationProperty.StorageClassAnalysis`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withStorageClassAnalysis(final software.amazon.awscdk.services.s3.CfnBucket.StorageClassAnalysisProperty value) {
                this._storageClassAnalysis = java.util.Objects.requireNonNull(value, "storageClassAnalysis is required");
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value `CfnBucket.AnalyticsConfigurationProperty.Prefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this._prefix = value;
                return this;
            }
            /**
             * Sets the value of TagFilters
             * @param value `CfnBucket.AnalyticsConfigurationProperty.TagFilters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTagFilters(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._tagFilters = value;
                return this;
            }
            /**
             * Sets the value of TagFilters
             * @param value `CfnBucket.AnalyticsConfigurationProperty.TagFilters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTagFilters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._tagFilters = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalyticsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public AnalyticsConfigurationProperty build() {
                return new AnalyticsConfigurationProperty() {
                    private final java.lang.String $id = java.util.Objects.requireNonNull(_id, "id is required");
                    private final java.lang.Object $storageClassAnalysis = java.util.Objects.requireNonNull(_storageClassAnalysis, "storageClassAnalysis is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $prefix = _prefix;
                    @javax.annotation.Nullable
                    private final java.lang.Object $tagFilters = _tagFilters;

                    @Override
                    public java.lang.String getId() {
                        return this.$id;
                    }

                    @Override
                    public java.lang.Object getStorageClassAnalysis() {
                        return this.$storageClassAnalysis;
                    }

                    @Override
                    public java.lang.String getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public java.lang.Object getTagFilters() {
                        return this.$tagFilters;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("id", om.valueToTree(this.getId()));
                        obj.set("storageClassAnalysis", om.valueToTree(this.getStorageClassAnalysis()));
                        if (this.getPrefix() != null) {
                            obj.set("prefix", om.valueToTree(this.getPrefix()));
                        }
                        if (this.getTagFilters() != null) {
                            obj.set("tagFilters", om.valueToTree(this.getTagFilters()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.AnalyticsConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.AnalyticsConfigurationProperty.Id`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-id
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getId() {
                return this.jsiiGet("id", java.lang.String.class);
            }

            /**
             * `CfnBucket.AnalyticsConfigurationProperty.StorageClassAnalysis`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.Object getStorageClassAnalysis() {
                return this.jsiiGet("storageClassAnalysis", java.lang.Object.class);
            }

            /**
             * `CfnBucket.AnalyticsConfigurationProperty.Prefix`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-prefix
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getPrefix() {
                return this.jsiiGet("prefix", java.lang.String.class);
            }

            /**
             * `CfnBucket.AnalyticsConfigurationProperty.TagFilters`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getTagFilters() {
                return this.jsiiGet("tagFilters", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BucketEncryptionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.BucketEncryptionProperty.ServerSideEncryptionConfiguration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getServerSideEncryptionConfiguration();

        /**
         * @return a {@link Builder} of {@link BucketEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link BucketEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.Object _serverSideEncryptionConfiguration;

            /**
             * Sets the value of ServerSideEncryptionConfiguration
             * @param value `CfnBucket.BucketEncryptionProperty.ServerSideEncryptionConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withServerSideEncryptionConfiguration(final software.amazon.awscdk.core.IResolvable value) {
                this._serverSideEncryptionConfiguration = java.util.Objects.requireNonNull(value, "serverSideEncryptionConfiguration is required");
                return this;
            }
            /**
             * Sets the value of ServerSideEncryptionConfiguration
             * @param value `CfnBucket.BucketEncryptionProperty.ServerSideEncryptionConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withServerSideEncryptionConfiguration(final java.util.List<java.lang.Object> value) {
                this._serverSideEncryptionConfiguration = java.util.Objects.requireNonNull(value, "serverSideEncryptionConfiguration is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BucketEncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public BucketEncryptionProperty build() {
                return new BucketEncryptionProperty() {
                    private final java.lang.Object $serverSideEncryptionConfiguration = java.util.Objects.requireNonNull(_serverSideEncryptionConfiguration, "serverSideEncryptionConfiguration is required");

                    @Override
                    public java.lang.Object getServerSideEncryptionConfiguration() {
                        return this.$serverSideEncryptionConfiguration;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("serverSideEncryptionConfiguration", om.valueToTree(this.getServerSideEncryptionConfiguration()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.BucketEncryptionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.BucketEncryptionProperty.ServerSideEncryptionConfiguration`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.Object getServerSideEncryptionConfiguration() {
                return this.jsiiGet("serverSideEncryptionConfiguration", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CorsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.CorsConfigurationProperty.CorsRules`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getCorsRules();

        /**
         * @return a {@link Builder} of {@link CorsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CorsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.Object _corsRules;

            /**
             * Sets the value of CorsRules
             * @param value `CfnBucket.CorsConfigurationProperty.CorsRules`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withCorsRules(final software.amazon.awscdk.core.IResolvable value) {
                this._corsRules = java.util.Objects.requireNonNull(value, "corsRules is required");
                return this;
            }
            /**
             * Sets the value of CorsRules
             * @param value `CfnBucket.CorsConfigurationProperty.CorsRules`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withCorsRules(final java.util.List<java.lang.Object> value) {
                this._corsRules = java.util.Objects.requireNonNull(value, "corsRules is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CorsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public CorsConfigurationProperty build() {
                return new CorsConfigurationProperty() {
                    private final java.lang.Object $corsRules = java.util.Objects.requireNonNull(_corsRules, "corsRules is required");

                    @Override
                    public java.lang.Object getCorsRules() {
                        return this.$corsRules;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("corsRules", om.valueToTree(this.getCorsRules()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.CorsConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.CorsConfigurationProperty.CorsRules`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.Object getCorsRules() {
                return this.jsiiGet("corsRules", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CorsRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.CorsRuleProperty.AllowedMethods`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.util.List<java.lang.String> getAllowedMethods();
        /**
         * `CfnBucket.CorsRuleProperty.AllowedOrigins`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.util.List<java.lang.String> getAllowedOrigins();
        /**
         * `CfnBucket.CorsRuleProperty.AllowedHeaders`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.util.List<java.lang.String> getAllowedHeaders();
        /**
         * `CfnBucket.CorsRuleProperty.ExposedHeaders`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.util.List<java.lang.String> getExposedHeaders();
        /**
         * `CfnBucket.CorsRuleProperty.Id`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-id
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getId();
        /**
         * `CfnBucket.CorsRuleProperty.MaxAge`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Number getMaxAge();

        /**
         * @return a {@link Builder} of {@link CorsRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CorsRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.util.List<java.lang.String> _allowedMethods;
            private java.util.List<java.lang.String> _allowedOrigins;
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _allowedHeaders;
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _exposedHeaders;
            @javax.annotation.Nullable
            private java.lang.String _id;
            @javax.annotation.Nullable
            private java.lang.Number _maxAge;

            /**
             * Sets the value of AllowedMethods
             * @param value `CfnBucket.CorsRuleProperty.AllowedMethods`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withAllowedMethods(final java.util.List<java.lang.String> value) {
                this._allowedMethods = java.util.Objects.requireNonNull(value, "allowedMethods is required");
                return this;
            }
            /**
             * Sets the value of AllowedOrigins
             * @param value `CfnBucket.CorsRuleProperty.AllowedOrigins`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withAllowedOrigins(final java.util.List<java.lang.String> value) {
                this._allowedOrigins = java.util.Objects.requireNonNull(value, "allowedOrigins is required");
                return this;
            }
            /**
             * Sets the value of AllowedHeaders
             * @param value `CfnBucket.CorsRuleProperty.AllowedHeaders`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withAllowedHeaders(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._allowedHeaders = value;
                return this;
            }
            /**
             * Sets the value of ExposedHeaders
             * @param value `CfnBucket.CorsRuleProperty.ExposedHeaders`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withExposedHeaders(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._exposedHeaders = value;
                return this;
            }
            /**
             * Sets the value of Id
             * @param value `CfnBucket.CorsRuleProperty.Id`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withId(@javax.annotation.Nullable final java.lang.String value) {
                this._id = value;
                return this;
            }
            /**
             * Sets the value of MaxAge
             * @param value `CfnBucket.CorsRuleProperty.MaxAge`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withMaxAge(@javax.annotation.Nullable final java.lang.Number value) {
                this._maxAge = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CorsRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public CorsRuleProperty build() {
                return new CorsRuleProperty() {
                    private final java.util.List<java.lang.String> $allowedMethods = java.util.Objects.requireNonNull(_allowedMethods, "allowedMethods is required");
                    private final java.util.List<java.lang.String> $allowedOrigins = java.util.Objects.requireNonNull(_allowedOrigins, "allowedOrigins is required");
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $allowedHeaders = _allowedHeaders;
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $exposedHeaders = _exposedHeaders;
                    @javax.annotation.Nullable
                    private final java.lang.String $id = _id;
                    @javax.annotation.Nullable
                    private final java.lang.Number $maxAge = _maxAge;

                    @Override
                    public java.util.List<java.lang.String> getAllowedMethods() {
                        return this.$allowedMethods;
                    }

                    @Override
                    public java.util.List<java.lang.String> getAllowedOrigins() {
                        return this.$allowedOrigins;
                    }

                    @Override
                    public java.util.List<java.lang.String> getAllowedHeaders() {
                        return this.$allowedHeaders;
                    }

                    @Override
                    public java.util.List<java.lang.String> getExposedHeaders() {
                        return this.$exposedHeaders;
                    }

                    @Override
                    public java.lang.String getId() {
                        return this.$id;
                    }

                    @Override
                    public java.lang.Number getMaxAge() {
                        return this.$maxAge;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("allowedMethods", om.valueToTree(this.getAllowedMethods()));
                        obj.set("allowedOrigins", om.valueToTree(this.getAllowedOrigins()));
                        if (this.getAllowedHeaders() != null) {
                            obj.set("allowedHeaders", om.valueToTree(this.getAllowedHeaders()));
                        }
                        if (this.getExposedHeaders() != null) {
                            obj.set("exposedHeaders", om.valueToTree(this.getExposedHeaders()));
                        }
                        if (this.getId() != null) {
                            obj.set("id", om.valueToTree(this.getId()));
                        }
                        if (this.getMaxAge() != null) {
                            obj.set("maxAge", om.valueToTree(this.getMaxAge()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.CorsRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.CorsRuleProperty.AllowedMethods`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.util.List<java.lang.String> getAllowedMethods() {
                return this.jsiiGet("allowedMethods", java.util.List.class);
            }

            /**
             * `CfnBucket.CorsRuleProperty.AllowedOrigins`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.util.List<java.lang.String> getAllowedOrigins() {
                return this.jsiiGet("allowedOrigins", java.util.List.class);
            }

            /**
             * `CfnBucket.CorsRuleProperty.AllowedHeaders`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getAllowedHeaders() {
                return this.jsiiGet("allowedHeaders", java.util.List.class);
            }

            /**
             * `CfnBucket.CorsRuleProperty.ExposedHeaders`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getExposedHeaders() {
                return this.jsiiGet("exposedHeaders", java.util.List.class);
            }

            /**
             * `CfnBucket.CorsRuleProperty.Id`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-id
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getId() {
                return this.jsiiGet("id", java.lang.String.class);
            }

            /**
             * `CfnBucket.CorsRuleProperty.MaxAge`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Number getMaxAge() {
                return this.jsiiGet("maxAge", java.lang.Number.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataExportProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.DataExportProperty.Destination`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getDestination();
        /**
         * `CfnBucket.DataExportProperty.OutputSchemaVersion`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-outputschemaversion
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getOutputSchemaVersion();

        /**
         * @return a {@link Builder} of {@link DataExportProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link DataExportProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.Object _destination;
            private java.lang.String _outputSchemaVersion;

            /**
             * Sets the value of Destination
             * @param value `CfnBucket.DataExportProperty.Destination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withDestination(final software.amazon.awscdk.core.IResolvable value) {
                this._destination = java.util.Objects.requireNonNull(value, "destination is required");
                return this;
            }
            /**
             * Sets the value of Destination
             * @param value `CfnBucket.DataExportProperty.Destination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withDestination(final software.amazon.awscdk.services.s3.CfnBucket.DestinationProperty value) {
                this._destination = java.util.Objects.requireNonNull(value, "destination is required");
                return this;
            }
            /**
             * Sets the value of OutputSchemaVersion
             * @param value `CfnBucket.DataExportProperty.OutputSchemaVersion`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withOutputSchemaVersion(final java.lang.String value) {
                this._outputSchemaVersion = java.util.Objects.requireNonNull(value, "outputSchemaVersion is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataExportProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public DataExportProperty build() {
                return new DataExportProperty() {
                    private final java.lang.Object $destination = java.util.Objects.requireNonNull(_destination, "destination is required");
                    private final java.lang.String $outputSchemaVersion = java.util.Objects.requireNonNull(_outputSchemaVersion, "outputSchemaVersion is required");

                    @Override
                    public java.lang.Object getDestination() {
                        return this.$destination;
                    }

                    @Override
                    public java.lang.String getOutputSchemaVersion() {
                        return this.$outputSchemaVersion;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("destination", om.valueToTree(this.getDestination()));
                        obj.set("outputSchemaVersion", om.valueToTree(this.getOutputSchemaVersion()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.DataExportProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.DataExportProperty.Destination`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.Object getDestination() {
                return this.jsiiGet("destination", java.lang.Object.class);
            }

            /**
             * `CfnBucket.DataExportProperty.OutputSchemaVersion`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-outputschemaversion
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getOutputSchemaVersion() {
                return this.jsiiGet("outputSchemaVersion", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DefaultRetentionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.DefaultRetentionProperty.Days`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html#cfn-s3-bucket-defaultretention-days
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Number getDays();
        /**
         * `CfnBucket.DefaultRetentionProperty.Mode`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html#cfn-s3-bucket-defaultretention-mode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getMode();
        /**
         * `CfnBucket.DefaultRetentionProperty.Years`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html#cfn-s3-bucket-defaultretention-years
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Number getYears();

        /**
         * @return a {@link Builder} of {@link DefaultRetentionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link DefaultRetentionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Number _days;
            @javax.annotation.Nullable
            private java.lang.String _mode;
            @javax.annotation.Nullable
            private java.lang.Number _years;

            /**
             * Sets the value of Days
             * @param value `CfnBucket.DefaultRetentionProperty.Days`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withDays(@javax.annotation.Nullable final java.lang.Number value) {
                this._days = value;
                return this;
            }
            /**
             * Sets the value of Mode
             * @param value `CfnBucket.DefaultRetentionProperty.Mode`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withMode(@javax.annotation.Nullable final java.lang.String value) {
                this._mode = value;
                return this;
            }
            /**
             * Sets the value of Years
             * @param value `CfnBucket.DefaultRetentionProperty.Years`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withYears(@javax.annotation.Nullable final java.lang.Number value) {
                this._years = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DefaultRetentionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public DefaultRetentionProperty build() {
                return new DefaultRetentionProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Number $days = _days;
                    @javax.annotation.Nullable
                    private final java.lang.String $mode = _mode;
                    @javax.annotation.Nullable
                    private final java.lang.Number $years = _years;

                    @Override
                    public java.lang.Number getDays() {
                        return this.$days;
                    }

                    @Override
                    public java.lang.String getMode() {
                        return this.$mode;
                    }

                    @Override
                    public java.lang.Number getYears() {
                        return this.$years;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getDays() != null) {
                            obj.set("days", om.valueToTree(this.getDays()));
                        }
                        if (this.getMode() != null) {
                            obj.set("mode", om.valueToTree(this.getMode()));
                        }
                        if (this.getYears() != null) {
                            obj.set("years", om.valueToTree(this.getYears()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.DefaultRetentionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.DefaultRetentionProperty.Days`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html#cfn-s3-bucket-defaultretention-days
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Number getDays() {
                return this.jsiiGet("days", java.lang.Number.class);
            }

            /**
             * `CfnBucket.DefaultRetentionProperty.Mode`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html#cfn-s3-bucket-defaultretention-mode
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getMode() {
                return this.jsiiGet("mode", java.lang.String.class);
            }

            /**
             * `CfnBucket.DefaultRetentionProperty.Years`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html#cfn-s3-bucket-defaultretention-years
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Number getYears() {
                return this.jsiiGet("years", java.lang.Number.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DestinationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.DestinationProperty.BucketArn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getBucketArn();
        /**
         * `CfnBucket.DestinationProperty.Format`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-format
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getFormat();
        /**
         * `CfnBucket.DestinationProperty.BucketAccountId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketaccountid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getBucketAccountId();
        /**
         * `CfnBucket.DestinationProperty.Prefix`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-prefix
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getPrefix();

        /**
         * @return a {@link Builder} of {@link DestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link DestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _bucketArn;
            private java.lang.String _format;
            @javax.annotation.Nullable
            private java.lang.String _bucketAccountId;
            @javax.annotation.Nullable
            private java.lang.String _prefix;

            /**
             * Sets the value of BucketArn
             * @param value `CfnBucket.DestinationProperty.BucketArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withBucketArn(final java.lang.String value) {
                this._bucketArn = java.util.Objects.requireNonNull(value, "bucketArn is required");
                return this;
            }
            /**
             * Sets the value of Format
             * @param value `CfnBucket.DestinationProperty.Format`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withFormat(final java.lang.String value) {
                this._format = java.util.Objects.requireNonNull(value, "format is required");
                return this;
            }
            /**
             * Sets the value of BucketAccountId
             * @param value `CfnBucket.DestinationProperty.BucketAccountId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withBucketAccountId(@javax.annotation.Nullable final java.lang.String value) {
                this._bucketAccountId = value;
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value `CfnBucket.DestinationProperty.Prefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this._prefix = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public DestinationProperty build() {
                return new DestinationProperty() {
                    private final java.lang.String $bucketArn = java.util.Objects.requireNonNull(_bucketArn, "bucketArn is required");
                    private final java.lang.String $format = java.util.Objects.requireNonNull(_format, "format is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $bucketAccountId = _bucketAccountId;
                    @javax.annotation.Nullable
                    private final java.lang.String $prefix = _prefix;

                    @Override
                    public java.lang.String getBucketArn() {
                        return this.$bucketArn;
                    }

                    @Override
                    public java.lang.String getFormat() {
                        return this.$format;
                    }

                    @Override
                    public java.lang.String getBucketAccountId() {
                        return this.$bucketAccountId;
                    }

                    @Override
                    public java.lang.String getPrefix() {
                        return this.$prefix;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("bucketArn", om.valueToTree(this.getBucketArn()));
                        obj.set("format", om.valueToTree(this.getFormat()));
                        if (this.getBucketAccountId() != null) {
                            obj.set("bucketAccountId", om.valueToTree(this.getBucketAccountId()));
                        }
                        if (this.getPrefix() != null) {
                            obj.set("prefix", om.valueToTree(this.getPrefix()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.DestinationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.DestinationProperty.BucketArn`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketarn
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getBucketArn() {
                return this.jsiiGet("bucketArn", java.lang.String.class);
            }

            /**
             * `CfnBucket.DestinationProperty.Format`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-format
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getFormat() {
                return this.jsiiGet("format", java.lang.String.class);
            }

            /**
             * `CfnBucket.DestinationProperty.BucketAccountId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketaccountid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getBucketAccountId() {
                return this.jsiiGet("bucketAccountId", java.lang.String.class);
            }

            /**
             * `CfnBucket.DestinationProperty.Prefix`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-prefix
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getPrefix() {
                return this.jsiiGet("prefix", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.EncryptionConfigurationProperty.ReplicaKmsKeyID`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html#cfn-s3-bucket-encryptionconfiguration-replicakmskeyid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getReplicaKmsKeyId();

        /**
         * @return a {@link Builder} of {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _replicaKmsKeyId;

            /**
             * Sets the value of ReplicaKmsKeyId
             * @param value `CfnBucket.EncryptionConfigurationProperty.ReplicaKmsKeyID`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withReplicaKmsKeyId(final java.lang.String value) {
                this._replicaKmsKeyId = java.util.Objects.requireNonNull(value, "replicaKmsKeyId is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public EncryptionConfigurationProperty build() {
                return new EncryptionConfigurationProperty() {
                    private final java.lang.String $replicaKmsKeyId = java.util.Objects.requireNonNull(_replicaKmsKeyId, "replicaKmsKeyId is required");

                    @Override
                    public java.lang.String getReplicaKmsKeyId() {
                        return this.$replicaKmsKeyId;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("replicaKmsKeyId", om.valueToTree(this.getReplicaKmsKeyId()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.EncryptionConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.EncryptionConfigurationProperty.ReplicaKmsKeyID`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html#cfn-s3-bucket-encryptionconfiguration-replicakmskeyid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getReplicaKmsKeyId() {
                return this.jsiiGet("replicaKmsKeyId", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FilterRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.FilterRuleProperty.Name`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getName();
        /**
         * `CfnBucket.FilterRuleProperty.Value`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-value
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link FilterRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link FilterRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _name;
            private java.lang.String _value;

            /**
             * Sets the value of Name
             * @param value `CfnBucket.FilterRuleProperty.Name`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withName(final java.lang.String value) {
                this._name = java.util.Objects.requireNonNull(value, "name is required");
                return this;
            }
            /**
             * Sets the value of Value
             * @param value `CfnBucket.FilterRuleProperty.Value`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withValue(final java.lang.String value) {
                this._value = java.util.Objects.requireNonNull(value, "value is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FilterRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public FilterRuleProperty build() {
                return new FilterRuleProperty() {
                    private final java.lang.String $name = java.util.Objects.requireNonNull(_name, "name is required");
                    private final java.lang.String $value = java.util.Objects.requireNonNull(_value, "value is required");

                    @Override
                    public java.lang.String getName() {
                        return this.$name;
                    }

                    @Override
                    public java.lang.String getValue() {
                        return this.$value;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("name", om.valueToTree(this.getName()));
                        obj.set("value", om.valueToTree(this.getValue()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.FilterRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.FilterRuleProperty.Name`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-name
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getName() {
                return this.jsiiGet("name", java.lang.String.class);
            }

            /**
             * `CfnBucket.FilterRuleProperty.Value`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-value
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getValue() {
                return this.jsiiGet("value", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InventoryConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.InventoryConfigurationProperty.Destination`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getDestination();
        /**
         * `CfnBucket.InventoryConfigurationProperty.Enabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getEnabled();
        /**
         * `CfnBucket.InventoryConfigurationProperty.Id`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-id
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getId();
        /**
         * `CfnBucket.InventoryConfigurationProperty.IncludedObjectVersions`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-includedobjectversions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getIncludedObjectVersions();
        /**
         * `CfnBucket.InventoryConfigurationProperty.ScheduleFrequency`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-schedulefrequency
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getScheduleFrequency();
        /**
         * `CfnBucket.InventoryConfigurationProperty.OptionalFields`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.util.List<java.lang.String> getOptionalFields();
        /**
         * `CfnBucket.InventoryConfigurationProperty.Prefix`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-prefix
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getPrefix();

        /**
         * @return a {@link Builder} of {@link InventoryConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InventoryConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.Object _destination;
            private java.lang.Object _enabled;
            private java.lang.String _id;
            private java.lang.String _includedObjectVersions;
            private java.lang.String _scheduleFrequency;
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _optionalFields;
            @javax.annotation.Nullable
            private java.lang.String _prefix;

            /**
             * Sets the value of Destination
             * @param value `CfnBucket.InventoryConfigurationProperty.Destination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withDestination(final software.amazon.awscdk.core.IResolvable value) {
                this._destination = java.util.Objects.requireNonNull(value, "destination is required");
                return this;
            }
            /**
             * Sets the value of Destination
             * @param value `CfnBucket.InventoryConfigurationProperty.Destination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withDestination(final software.amazon.awscdk.services.s3.CfnBucket.DestinationProperty value) {
                this._destination = java.util.Objects.requireNonNull(value, "destination is required");
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value `CfnBucket.InventoryConfigurationProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withEnabled(final java.lang.Boolean value) {
                this._enabled = java.util.Objects.requireNonNull(value, "enabled is required");
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value `CfnBucket.InventoryConfigurationProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withEnabled(final software.amazon.awscdk.core.IResolvable value) {
                this._enabled = java.util.Objects.requireNonNull(value, "enabled is required");
                return this;
            }
            /**
             * Sets the value of Id
             * @param value `CfnBucket.InventoryConfigurationProperty.Id`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withId(final java.lang.String value) {
                this._id = java.util.Objects.requireNonNull(value, "id is required");
                return this;
            }
            /**
             * Sets the value of IncludedObjectVersions
             * @param value `CfnBucket.InventoryConfigurationProperty.IncludedObjectVersions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withIncludedObjectVersions(final java.lang.String value) {
                this._includedObjectVersions = java.util.Objects.requireNonNull(value, "includedObjectVersions is required");
                return this;
            }
            /**
             * Sets the value of ScheduleFrequency
             * @param value `CfnBucket.InventoryConfigurationProperty.ScheduleFrequency`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withScheduleFrequency(final java.lang.String value) {
                this._scheduleFrequency = java.util.Objects.requireNonNull(value, "scheduleFrequency is required");
                return this;
            }
            /**
             * Sets the value of OptionalFields
             * @param value `CfnBucket.InventoryConfigurationProperty.OptionalFields`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withOptionalFields(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._optionalFields = value;
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value `CfnBucket.InventoryConfigurationProperty.Prefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this._prefix = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InventoryConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public InventoryConfigurationProperty build() {
                return new InventoryConfigurationProperty() {
                    private final java.lang.Object $destination = java.util.Objects.requireNonNull(_destination, "destination is required");
                    private final java.lang.Object $enabled = java.util.Objects.requireNonNull(_enabled, "enabled is required");
                    private final java.lang.String $id = java.util.Objects.requireNonNull(_id, "id is required");
                    private final java.lang.String $includedObjectVersions = java.util.Objects.requireNonNull(_includedObjectVersions, "includedObjectVersions is required");
                    private final java.lang.String $scheduleFrequency = java.util.Objects.requireNonNull(_scheduleFrequency, "scheduleFrequency is required");
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $optionalFields = _optionalFields;
                    @javax.annotation.Nullable
                    private final java.lang.String $prefix = _prefix;

                    @Override
                    public java.lang.Object getDestination() {
                        return this.$destination;
                    }

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    @Override
                    public java.lang.String getId() {
                        return this.$id;
                    }

                    @Override
                    public java.lang.String getIncludedObjectVersions() {
                        return this.$includedObjectVersions;
                    }

                    @Override
                    public java.lang.String getScheduleFrequency() {
                        return this.$scheduleFrequency;
                    }

                    @Override
                    public java.util.List<java.lang.String> getOptionalFields() {
                        return this.$optionalFields;
                    }

                    @Override
                    public java.lang.String getPrefix() {
                        return this.$prefix;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("destination", om.valueToTree(this.getDestination()));
                        obj.set("enabled", om.valueToTree(this.getEnabled()));
                        obj.set("id", om.valueToTree(this.getId()));
                        obj.set("includedObjectVersions", om.valueToTree(this.getIncludedObjectVersions()));
                        obj.set("scheduleFrequency", om.valueToTree(this.getScheduleFrequency()));
                        if (this.getOptionalFields() != null) {
                            obj.set("optionalFields", om.valueToTree(this.getOptionalFields()));
                        }
                        if (this.getPrefix() != null) {
                            obj.set("prefix", om.valueToTree(this.getPrefix()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.InventoryConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.InventoryConfigurationProperty.Destination`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.Object getDestination() {
                return this.jsiiGet("destination", java.lang.Object.class);
            }

            /**
             * `CfnBucket.InventoryConfigurationProperty.Enabled`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }

            /**
             * `CfnBucket.InventoryConfigurationProperty.Id`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-id
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getId() {
                return this.jsiiGet("id", java.lang.String.class);
            }

            /**
             * `CfnBucket.InventoryConfigurationProperty.IncludedObjectVersions`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-includedobjectversions
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getIncludedObjectVersions() {
                return this.jsiiGet("includedObjectVersions", java.lang.String.class);
            }

            /**
             * `CfnBucket.InventoryConfigurationProperty.ScheduleFrequency`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-schedulefrequency
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getScheduleFrequency() {
                return this.jsiiGet("scheduleFrequency", java.lang.String.class);
            }

            /**
             * `CfnBucket.InventoryConfigurationProperty.OptionalFields`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getOptionalFields() {
                return this.jsiiGet("optionalFields", java.util.List.class);
            }

            /**
             * `CfnBucket.InventoryConfigurationProperty.Prefix`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-prefix
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getPrefix() {
                return this.jsiiGet("prefix", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.LambdaConfigurationProperty.Event`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-event
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getEvent();
        /**
         * `CfnBucket.LambdaConfigurationProperty.Function`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-function
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getFunction();
        /**
         * `CfnBucket.LambdaConfigurationProperty.Filter`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getFilter();

        /**
         * @return a {@link Builder} of {@link LambdaConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LambdaConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _event;
            private java.lang.String _function;
            @javax.annotation.Nullable
            private java.lang.Object _filter;

            /**
             * Sets the value of Event
             * @param value `CfnBucket.LambdaConfigurationProperty.Event`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withEvent(final java.lang.String value) {
                this._event = java.util.Objects.requireNonNull(value, "event is required");
                return this;
            }
            /**
             * Sets the value of Function
             * @param value `CfnBucket.LambdaConfigurationProperty.Function`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withFunction(final java.lang.String value) {
                this._function = java.util.Objects.requireNonNull(value, "function is required");
                return this;
            }
            /**
             * Sets the value of Filter
             * @param value `CfnBucket.LambdaConfigurationProperty.Filter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withFilter(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._filter = value;
                return this;
            }
            /**
             * Sets the value of Filter
             * @param value `CfnBucket.LambdaConfigurationProperty.Filter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withFilter(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty value) {
                this._filter = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public LambdaConfigurationProperty build() {
                return new LambdaConfigurationProperty() {
                    private final java.lang.String $event = java.util.Objects.requireNonNull(_event, "event is required");
                    private final java.lang.String $function = java.util.Objects.requireNonNull(_function, "function is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $filter = _filter;

                    @Override
                    public java.lang.String getEvent() {
                        return this.$event;
                    }

                    @Override
                    public java.lang.String getFunction() {
                        return this.$function;
                    }

                    @Override
                    public java.lang.Object getFilter() {
                        return this.$filter;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("event", om.valueToTree(this.getEvent()));
                        obj.set("function", om.valueToTree(this.getFunction()));
                        if (this.getFilter() != null) {
                            obj.set("filter", om.valueToTree(this.getFilter()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.LambdaConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.LambdaConfigurationProperty.Event`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-event
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getEvent() {
                return this.jsiiGet("event", java.lang.String.class);
            }

            /**
             * `CfnBucket.LambdaConfigurationProperty.Function`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-function
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getFunction() {
                return this.jsiiGet("function", java.lang.String.class);
            }

            /**
             * `CfnBucket.LambdaConfigurationProperty.Filter`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getFilter() {
                return this.jsiiGet("filter", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LifecycleConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.LifecycleConfigurationProperty.Rules`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getRules();

        /**
         * @return a {@link Builder} of {@link LifecycleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LifecycleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.Object _rules;

            /**
             * Sets the value of Rules
             * @param value `CfnBucket.LifecycleConfigurationProperty.Rules`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRules(final software.amazon.awscdk.core.IResolvable value) {
                this._rules = java.util.Objects.requireNonNull(value, "rules is required");
                return this;
            }
            /**
             * Sets the value of Rules
             * @param value `CfnBucket.LifecycleConfigurationProperty.Rules`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRules(final java.util.List<java.lang.Object> value) {
                this._rules = java.util.Objects.requireNonNull(value, "rules is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LifecycleConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public LifecycleConfigurationProperty build() {
                return new LifecycleConfigurationProperty() {
                    private final java.lang.Object $rules = java.util.Objects.requireNonNull(_rules, "rules is required");

                    @Override
                    public java.lang.Object getRules() {
                        return this.$rules;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("rules", om.valueToTree(this.getRules()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.LifecycleConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.LifecycleConfigurationProperty.Rules`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.Object getRules() {
                return this.jsiiGet("rules", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoggingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.LoggingConfigurationProperty.DestinationBucketName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-destinationbucketname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getDestinationBucketName();
        /**
         * `CfnBucket.LoggingConfigurationProperty.LogFilePrefix`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-logfileprefix
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getLogFilePrefix();

        /**
         * @return a {@link Builder} of {@link LoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _destinationBucketName;
            @javax.annotation.Nullable
            private java.lang.String _logFilePrefix;

            /**
             * Sets the value of DestinationBucketName
             * @param value `CfnBucket.LoggingConfigurationProperty.DestinationBucketName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withDestinationBucketName(@javax.annotation.Nullable final java.lang.String value) {
                this._destinationBucketName = value;
                return this;
            }
            /**
             * Sets the value of LogFilePrefix
             * @param value `CfnBucket.LoggingConfigurationProperty.LogFilePrefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withLogFilePrefix(@javax.annotation.Nullable final java.lang.String value) {
                this._logFilePrefix = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public LoggingConfigurationProperty build() {
                return new LoggingConfigurationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $destinationBucketName = _destinationBucketName;
                    @javax.annotation.Nullable
                    private final java.lang.String $logFilePrefix = _logFilePrefix;

                    @Override
                    public java.lang.String getDestinationBucketName() {
                        return this.$destinationBucketName;
                    }

                    @Override
                    public java.lang.String getLogFilePrefix() {
                        return this.$logFilePrefix;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getDestinationBucketName() != null) {
                            obj.set("destinationBucketName", om.valueToTree(this.getDestinationBucketName()));
                        }
                        if (this.getLogFilePrefix() != null) {
                            obj.set("logFilePrefix", om.valueToTree(this.getLogFilePrefix()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.LoggingConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.LoggingConfigurationProperty.DestinationBucketName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-destinationbucketname
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getDestinationBucketName() {
                return this.jsiiGet("destinationBucketName", java.lang.String.class);
            }

            /**
             * `CfnBucket.LoggingConfigurationProperty.LogFilePrefix`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-logfileprefix
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getLogFilePrefix() {
                return this.jsiiGet("logFilePrefix", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.MetricsConfigurationProperty.Id`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-id
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getId();
        /**
         * `CfnBucket.MetricsConfigurationProperty.Prefix`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-prefix
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getPrefix();
        /**
         * `CfnBucket.MetricsConfigurationProperty.TagFilters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getTagFilters();

        /**
         * @return a {@link Builder} of {@link MetricsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link MetricsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _id;
            @javax.annotation.Nullable
            private java.lang.String _prefix;
            @javax.annotation.Nullable
            private java.lang.Object _tagFilters;

            /**
             * Sets the value of Id
             * @param value `CfnBucket.MetricsConfigurationProperty.Id`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withId(final java.lang.String value) {
                this._id = java.util.Objects.requireNonNull(value, "id is required");
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value `CfnBucket.MetricsConfigurationProperty.Prefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this._prefix = value;
                return this;
            }
            /**
             * Sets the value of TagFilters
             * @param value `CfnBucket.MetricsConfigurationProperty.TagFilters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTagFilters(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._tagFilters = value;
                return this;
            }
            /**
             * Sets the value of TagFilters
             * @param value `CfnBucket.MetricsConfigurationProperty.TagFilters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTagFilters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._tagFilters = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public MetricsConfigurationProperty build() {
                return new MetricsConfigurationProperty() {
                    private final java.lang.String $id = java.util.Objects.requireNonNull(_id, "id is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $prefix = _prefix;
                    @javax.annotation.Nullable
                    private final java.lang.Object $tagFilters = _tagFilters;

                    @Override
                    public java.lang.String getId() {
                        return this.$id;
                    }

                    @Override
                    public java.lang.String getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public java.lang.Object getTagFilters() {
                        return this.$tagFilters;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("id", om.valueToTree(this.getId()));
                        if (this.getPrefix() != null) {
                            obj.set("prefix", om.valueToTree(this.getPrefix()));
                        }
                        if (this.getTagFilters() != null) {
                            obj.set("tagFilters", om.valueToTree(this.getTagFilters()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.MetricsConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.MetricsConfigurationProperty.Id`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-id
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getId() {
                return this.jsiiGet("id", java.lang.String.class);
            }

            /**
             * `CfnBucket.MetricsConfigurationProperty.Prefix`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-prefix
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getPrefix() {
                return this.jsiiGet("prefix", java.lang.String.class);
            }

            /**
             * `CfnBucket.MetricsConfigurationProperty.TagFilters`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getTagFilters() {
                return this.jsiiGet("tagFilters", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NoncurrentVersionTransitionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.NoncurrentVersionTransitionProperty.StorageClass`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-storageclass
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getStorageClass();
        /**
         * `CfnBucket.NoncurrentVersionTransitionProperty.TransitionInDays`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Number getTransitionInDays();

        /**
         * @return a {@link Builder} of {@link NoncurrentVersionTransitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link NoncurrentVersionTransitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _storageClass;
            private java.lang.Number _transitionInDays;

            /**
             * Sets the value of StorageClass
             * @param value `CfnBucket.NoncurrentVersionTransitionProperty.StorageClass`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withStorageClass(final java.lang.String value) {
                this._storageClass = java.util.Objects.requireNonNull(value, "storageClass is required");
                return this;
            }
            /**
             * Sets the value of TransitionInDays
             * @param value `CfnBucket.NoncurrentVersionTransitionProperty.TransitionInDays`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTransitionInDays(final java.lang.Number value) {
                this._transitionInDays = java.util.Objects.requireNonNull(value, "transitionInDays is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NoncurrentVersionTransitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public NoncurrentVersionTransitionProperty build() {
                return new NoncurrentVersionTransitionProperty() {
                    private final java.lang.String $storageClass = java.util.Objects.requireNonNull(_storageClass, "storageClass is required");
                    private final java.lang.Number $transitionInDays = java.util.Objects.requireNonNull(_transitionInDays, "transitionInDays is required");

                    @Override
                    public java.lang.String getStorageClass() {
                        return this.$storageClass;
                    }

                    @Override
                    public java.lang.Number getTransitionInDays() {
                        return this.$transitionInDays;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("storageClass", om.valueToTree(this.getStorageClass()));
                        obj.set("transitionInDays", om.valueToTree(this.getTransitionInDays()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.NoncurrentVersionTransitionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.NoncurrentVersionTransitionProperty.StorageClass`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-storageclass
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getStorageClass() {
                return this.jsiiGet("storageClass", java.lang.String.class);
            }

            /**
             * `CfnBucket.NoncurrentVersionTransitionProperty.TransitionInDays`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.Number getTransitionInDays() {
                return this.jsiiGet("transitionInDays", java.lang.Number.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NotificationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.NotificationConfigurationProperty.LambdaConfigurations`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getLambdaConfigurations();
        /**
         * `CfnBucket.NotificationConfigurationProperty.QueueConfigurations`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-queueconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getQueueConfigurations();
        /**
         * `CfnBucket.NotificationConfigurationProperty.TopicConfigurations`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-topicconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getTopicConfigurations();

        /**
         * @return a {@link Builder} of {@link NotificationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link NotificationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _lambdaConfigurations;
            @javax.annotation.Nullable
            private java.lang.Object _queueConfigurations;
            @javax.annotation.Nullable
            private java.lang.Object _topicConfigurations;

            /**
             * Sets the value of LambdaConfigurations
             * @param value `CfnBucket.NotificationConfigurationProperty.LambdaConfigurations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withLambdaConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._lambdaConfigurations = value;
                return this;
            }
            /**
             * Sets the value of LambdaConfigurations
             * @param value `CfnBucket.NotificationConfigurationProperty.LambdaConfigurations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withLambdaConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._lambdaConfigurations = value;
                return this;
            }
            /**
             * Sets the value of QueueConfigurations
             * @param value `CfnBucket.NotificationConfigurationProperty.QueueConfigurations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withQueueConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._queueConfigurations = value;
                return this;
            }
            /**
             * Sets the value of QueueConfigurations
             * @param value `CfnBucket.NotificationConfigurationProperty.QueueConfigurations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withQueueConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._queueConfigurations = value;
                return this;
            }
            /**
             * Sets the value of TopicConfigurations
             * @param value `CfnBucket.NotificationConfigurationProperty.TopicConfigurations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTopicConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._topicConfigurations = value;
                return this;
            }
            /**
             * Sets the value of TopicConfigurations
             * @param value `CfnBucket.NotificationConfigurationProperty.TopicConfigurations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTopicConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._topicConfigurations = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotificationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public NotificationConfigurationProperty build() {
                return new NotificationConfigurationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $lambdaConfigurations = _lambdaConfigurations;
                    @javax.annotation.Nullable
                    private final java.lang.Object $queueConfigurations = _queueConfigurations;
                    @javax.annotation.Nullable
                    private final java.lang.Object $topicConfigurations = _topicConfigurations;

                    @Override
                    public java.lang.Object getLambdaConfigurations() {
                        return this.$lambdaConfigurations;
                    }

                    @Override
                    public java.lang.Object getQueueConfigurations() {
                        return this.$queueConfigurations;
                    }

                    @Override
                    public java.lang.Object getTopicConfigurations() {
                        return this.$topicConfigurations;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getLambdaConfigurations() != null) {
                            obj.set("lambdaConfigurations", om.valueToTree(this.getLambdaConfigurations()));
                        }
                        if (this.getQueueConfigurations() != null) {
                            obj.set("queueConfigurations", om.valueToTree(this.getQueueConfigurations()));
                        }
                        if (this.getTopicConfigurations() != null) {
                            obj.set("topicConfigurations", om.valueToTree(this.getTopicConfigurations()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.NotificationConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.NotificationConfigurationProperty.LambdaConfigurations`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getLambdaConfigurations() {
                return this.jsiiGet("lambdaConfigurations", java.lang.Object.class);
            }

            /**
             * `CfnBucket.NotificationConfigurationProperty.QueueConfigurations`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-queueconfig
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getQueueConfigurations() {
                return this.jsiiGet("queueConfigurations", java.lang.Object.class);
            }

            /**
             * `CfnBucket.NotificationConfigurationProperty.TopicConfigurations`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-topicconfig
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getTopicConfigurations() {
                return this.jsiiGet("topicConfigurations", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NotificationFilterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.NotificationFilterProperty.S3Key`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getS3Key();

        /**
         * @return a {@link Builder} of {@link NotificationFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link NotificationFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.Object _s3Key;

            /**
             * Sets the value of S3Key
             * @param value `CfnBucket.NotificationFilterProperty.S3Key`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withS3Key(final software.amazon.awscdk.core.IResolvable value) {
                this._s3Key = java.util.Objects.requireNonNull(value, "s3Key is required");
                return this;
            }
            /**
             * Sets the value of S3Key
             * @param value `CfnBucket.NotificationFilterProperty.S3Key`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withS3Key(final software.amazon.awscdk.services.s3.CfnBucket.S3KeyFilterProperty value) {
                this._s3Key = java.util.Objects.requireNonNull(value, "s3Key is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotificationFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public NotificationFilterProperty build() {
                return new NotificationFilterProperty() {
                    private final java.lang.Object $s3Key = java.util.Objects.requireNonNull(_s3Key, "s3Key is required");

                    @Override
                    public java.lang.Object getS3Key() {
                        return this.$s3Key;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("s3Key", om.valueToTree(this.getS3Key()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.NotificationFilterProperty.S3Key`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.Object getS3Key() {
                return this.jsiiGet("s3Key", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ObjectLockConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.ObjectLockConfigurationProperty.ObjectLockEnabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockconfiguration.html#cfn-s3-bucket-objectlockconfiguration-objectlockenabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getObjectLockEnabled();
        /**
         * `CfnBucket.ObjectLockConfigurationProperty.Rule`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockconfiguration.html#cfn-s3-bucket-objectlockconfiguration-rule
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getRule();

        /**
         * @return a {@link Builder} of {@link ObjectLockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ObjectLockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _objectLockEnabled;
            @javax.annotation.Nullable
            private java.lang.Object _rule;

            /**
             * Sets the value of ObjectLockEnabled
             * @param value `CfnBucket.ObjectLockConfigurationProperty.ObjectLockEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withObjectLockEnabled(@javax.annotation.Nullable final java.lang.String value) {
                this._objectLockEnabled = value;
                return this;
            }
            /**
             * Sets the value of Rule
             * @param value `CfnBucket.ObjectLockConfigurationProperty.Rule`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRule(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._rule = value;
                return this;
            }
            /**
             * Sets the value of Rule
             * @param value `CfnBucket.ObjectLockConfigurationProperty.Rule`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRule(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.ObjectLockRuleProperty value) {
                this._rule = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ObjectLockConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public ObjectLockConfigurationProperty build() {
                return new ObjectLockConfigurationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $objectLockEnabled = _objectLockEnabled;
                    @javax.annotation.Nullable
                    private final java.lang.Object $rule = _rule;

                    @Override
                    public java.lang.String getObjectLockEnabled() {
                        return this.$objectLockEnabled;
                    }

                    @Override
                    public java.lang.Object getRule() {
                        return this.$rule;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getObjectLockEnabled() != null) {
                            obj.set("objectLockEnabled", om.valueToTree(this.getObjectLockEnabled()));
                        }
                        if (this.getRule() != null) {
                            obj.set("rule", om.valueToTree(this.getRule()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.ObjectLockConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.ObjectLockConfigurationProperty.ObjectLockEnabled`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockconfiguration.html#cfn-s3-bucket-objectlockconfiguration-objectlockenabled
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getObjectLockEnabled() {
                return this.jsiiGet("objectLockEnabled", java.lang.String.class);
            }

            /**
             * `CfnBucket.ObjectLockConfigurationProperty.Rule`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockconfiguration.html#cfn-s3-bucket-objectlockconfiguration-rule
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getRule() {
                return this.jsiiGet("rule", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockrule.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ObjectLockRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.ObjectLockRuleProperty.DefaultRetention`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockrule.html#cfn-s3-bucket-objectlockrule-defaultretention
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getDefaultRetention();

        /**
         * @return a {@link Builder} of {@link ObjectLockRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ObjectLockRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _defaultRetention;

            /**
             * Sets the value of DefaultRetention
             * @param value `CfnBucket.ObjectLockRuleProperty.DefaultRetention`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withDefaultRetention(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._defaultRetention = value;
                return this;
            }
            /**
             * Sets the value of DefaultRetention
             * @param value `CfnBucket.ObjectLockRuleProperty.DefaultRetention`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withDefaultRetention(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.DefaultRetentionProperty value) {
                this._defaultRetention = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ObjectLockRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public ObjectLockRuleProperty build() {
                return new ObjectLockRuleProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $defaultRetention = _defaultRetention;

                    @Override
                    public java.lang.Object getDefaultRetention() {
                        return this.$defaultRetention;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getDefaultRetention() != null) {
                            obj.set("defaultRetention", om.valueToTree(this.getDefaultRetention()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.ObjectLockRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.ObjectLockRuleProperty.DefaultRetention`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockrule.html#cfn-s3-bucket-objectlockrule-defaultretention
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getDefaultRetention() {
                return this.jsiiGet("defaultRetention", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PublicAccessBlockConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicAcls`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicacls
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getBlockPublicAcls();
        /**
         * `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicPolicy`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicpolicy
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getBlockPublicPolicy();
        /**
         * `CfnBucket.PublicAccessBlockConfigurationProperty.IgnorePublicAcls`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-ignorepublicacls
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getIgnorePublicAcls();
        /**
         * `CfnBucket.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-restrictpublicbuckets
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getRestrictPublicBuckets();

        /**
         * @return a {@link Builder} of {@link PublicAccessBlockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link PublicAccessBlockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _blockPublicAcls;
            @javax.annotation.Nullable
            private java.lang.Object _blockPublicPolicy;
            @javax.annotation.Nullable
            private java.lang.Object _ignorePublicAcls;
            @javax.annotation.Nullable
            private java.lang.Object _restrictPublicBuckets;

            /**
             * Sets the value of BlockPublicAcls
             * @param value `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicAcls`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withBlockPublicAcls(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._blockPublicAcls = value;
                return this;
            }
            /**
             * Sets the value of BlockPublicAcls
             * @param value `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicAcls`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withBlockPublicAcls(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._blockPublicAcls = value;
                return this;
            }
            /**
             * Sets the value of BlockPublicPolicy
             * @param value `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withBlockPublicPolicy(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._blockPublicPolicy = value;
                return this;
            }
            /**
             * Sets the value of BlockPublicPolicy
             * @param value `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withBlockPublicPolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._blockPublicPolicy = value;
                return this;
            }
            /**
             * Sets the value of IgnorePublicAcls
             * @param value `CfnBucket.PublicAccessBlockConfigurationProperty.IgnorePublicAcls`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withIgnorePublicAcls(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._ignorePublicAcls = value;
                return this;
            }
            /**
             * Sets the value of IgnorePublicAcls
             * @param value `CfnBucket.PublicAccessBlockConfigurationProperty.IgnorePublicAcls`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withIgnorePublicAcls(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._ignorePublicAcls = value;
                return this;
            }
            /**
             * Sets the value of RestrictPublicBuckets
             * @param value `CfnBucket.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRestrictPublicBuckets(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._restrictPublicBuckets = value;
                return this;
            }
            /**
             * Sets the value of RestrictPublicBuckets
             * @param value `CfnBucket.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRestrictPublicBuckets(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._restrictPublicBuckets = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PublicAccessBlockConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public PublicAccessBlockConfigurationProperty build() {
                return new PublicAccessBlockConfigurationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $blockPublicAcls = _blockPublicAcls;
                    @javax.annotation.Nullable
                    private final java.lang.Object $blockPublicPolicy = _blockPublicPolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $ignorePublicAcls = _ignorePublicAcls;
                    @javax.annotation.Nullable
                    private final java.lang.Object $restrictPublicBuckets = _restrictPublicBuckets;

                    @Override
                    public java.lang.Object getBlockPublicAcls() {
                        return this.$blockPublicAcls;
                    }

                    @Override
                    public java.lang.Object getBlockPublicPolicy() {
                        return this.$blockPublicPolicy;
                    }

                    @Override
                    public java.lang.Object getIgnorePublicAcls() {
                        return this.$ignorePublicAcls;
                    }

                    @Override
                    public java.lang.Object getRestrictPublicBuckets() {
                        return this.$restrictPublicBuckets;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getBlockPublicAcls() != null) {
                            obj.set("blockPublicAcls", om.valueToTree(this.getBlockPublicAcls()));
                        }
                        if (this.getBlockPublicPolicy() != null) {
                            obj.set("blockPublicPolicy", om.valueToTree(this.getBlockPublicPolicy()));
                        }
                        if (this.getIgnorePublicAcls() != null) {
                            obj.set("ignorePublicAcls", om.valueToTree(this.getIgnorePublicAcls()));
                        }
                        if (this.getRestrictPublicBuckets() != null) {
                            obj.set("restrictPublicBuckets", om.valueToTree(this.getRestrictPublicBuckets()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.PublicAccessBlockConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicAcls`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicacls
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getBlockPublicAcls() {
                return this.jsiiGet("blockPublicAcls", java.lang.Object.class);
            }

            /**
             * `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicPolicy`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicpolicy
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getBlockPublicPolicy() {
                return this.jsiiGet("blockPublicPolicy", java.lang.Object.class);
            }

            /**
             * `CfnBucket.PublicAccessBlockConfigurationProperty.IgnorePublicAcls`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-ignorepublicacls
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getIgnorePublicAcls() {
                return this.jsiiGet("ignorePublicAcls", java.lang.Object.class);
            }

            /**
             * `CfnBucket.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-restrictpublicbuckets
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getRestrictPublicBuckets() {
                return this.jsiiGet("restrictPublicBuckets", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QueueConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.QueueConfigurationProperty.Event`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-event
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getEvent();
        /**
         * `CfnBucket.QueueConfigurationProperty.Queue`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-queue
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getQueue();
        /**
         * `CfnBucket.QueueConfigurationProperty.Filter`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getFilter();

        /**
         * @return a {@link Builder} of {@link QueueConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link QueueConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _event;
            private java.lang.String _queue;
            @javax.annotation.Nullable
            private java.lang.Object _filter;

            /**
             * Sets the value of Event
             * @param value `CfnBucket.QueueConfigurationProperty.Event`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withEvent(final java.lang.String value) {
                this._event = java.util.Objects.requireNonNull(value, "event is required");
                return this;
            }
            /**
             * Sets the value of Queue
             * @param value `CfnBucket.QueueConfigurationProperty.Queue`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withQueue(final java.lang.String value) {
                this._queue = java.util.Objects.requireNonNull(value, "queue is required");
                return this;
            }
            /**
             * Sets the value of Filter
             * @param value `CfnBucket.QueueConfigurationProperty.Filter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withFilter(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._filter = value;
                return this;
            }
            /**
             * Sets the value of Filter
             * @param value `CfnBucket.QueueConfigurationProperty.Filter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withFilter(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty value) {
                this._filter = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueueConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public QueueConfigurationProperty build() {
                return new QueueConfigurationProperty() {
                    private final java.lang.String $event = java.util.Objects.requireNonNull(_event, "event is required");
                    private final java.lang.String $queue = java.util.Objects.requireNonNull(_queue, "queue is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $filter = _filter;

                    @Override
                    public java.lang.String getEvent() {
                        return this.$event;
                    }

                    @Override
                    public java.lang.String getQueue() {
                        return this.$queue;
                    }

                    @Override
                    public java.lang.Object getFilter() {
                        return this.$filter;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("event", om.valueToTree(this.getEvent()));
                        obj.set("queue", om.valueToTree(this.getQueue()));
                        if (this.getFilter() != null) {
                            obj.set("filter", om.valueToTree(this.getFilter()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.QueueConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.QueueConfigurationProperty.Event`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-event
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getEvent() {
                return this.jsiiGet("event", java.lang.String.class);
            }

            /**
             * `CfnBucket.QueueConfigurationProperty.Queue`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-queue
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getQueue() {
                return this.jsiiGet("queue", java.lang.String.class);
            }

            /**
             * `CfnBucket.QueueConfigurationProperty.Filter`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getFilter() {
                return this.jsiiGet("filter", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedirectAllRequestsToProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.RedirectAllRequestsToProperty.HostName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-hostname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getHostName();
        /**
         * `CfnBucket.RedirectAllRequestsToProperty.Protocol`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-protocol
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getProtocol();

        /**
         * @return a {@link Builder} of {@link RedirectAllRequestsToProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RedirectAllRequestsToProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _hostName;
            @javax.annotation.Nullable
            private java.lang.String _protocol;

            /**
             * Sets the value of HostName
             * @param value `CfnBucket.RedirectAllRequestsToProperty.HostName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withHostName(final java.lang.String value) {
                this._hostName = java.util.Objects.requireNonNull(value, "hostName is required");
                return this;
            }
            /**
             * Sets the value of Protocol
             * @param value `CfnBucket.RedirectAllRequestsToProperty.Protocol`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withProtocol(@javax.annotation.Nullable final java.lang.String value) {
                this._protocol = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedirectAllRequestsToProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public RedirectAllRequestsToProperty build() {
                return new RedirectAllRequestsToProperty() {
                    private final java.lang.String $hostName = java.util.Objects.requireNonNull(_hostName, "hostName is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $protocol = _protocol;

                    @Override
                    public java.lang.String getHostName() {
                        return this.$hostName;
                    }

                    @Override
                    public java.lang.String getProtocol() {
                        return this.$protocol;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("hostName", om.valueToTree(this.getHostName()));
                        if (this.getProtocol() != null) {
                            obj.set("protocol", om.valueToTree(this.getProtocol()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.RedirectAllRequestsToProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.RedirectAllRequestsToProperty.HostName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-hostname
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getHostName() {
                return this.jsiiGet("hostName", java.lang.String.class);
            }

            /**
             * `CfnBucket.RedirectAllRequestsToProperty.Protocol`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-protocol
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getProtocol() {
                return this.jsiiGet("protocol", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedirectRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.RedirectRuleProperty.HostName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-hostname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getHostName();
        /**
         * `CfnBucket.RedirectRuleProperty.HttpRedirectCode`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-httpredirectcode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getHttpRedirectCode();
        /**
         * `CfnBucket.RedirectRuleProperty.Protocol`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-protocol
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getProtocol();
        /**
         * `CfnBucket.RedirectRuleProperty.ReplaceKeyPrefixWith`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeyprefixwith
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getReplaceKeyPrefixWith();
        /**
         * `CfnBucket.RedirectRuleProperty.ReplaceKeyWith`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeywith
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getReplaceKeyWith();

        /**
         * @return a {@link Builder} of {@link RedirectRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RedirectRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _hostName;
            @javax.annotation.Nullable
            private java.lang.String _httpRedirectCode;
            @javax.annotation.Nullable
            private java.lang.String _protocol;
            @javax.annotation.Nullable
            private java.lang.String _replaceKeyPrefixWith;
            @javax.annotation.Nullable
            private java.lang.String _replaceKeyWith;

            /**
             * Sets the value of HostName
             * @param value `CfnBucket.RedirectRuleProperty.HostName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withHostName(@javax.annotation.Nullable final java.lang.String value) {
                this._hostName = value;
                return this;
            }
            /**
             * Sets the value of HttpRedirectCode
             * @param value `CfnBucket.RedirectRuleProperty.HttpRedirectCode`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withHttpRedirectCode(@javax.annotation.Nullable final java.lang.String value) {
                this._httpRedirectCode = value;
                return this;
            }
            /**
             * Sets the value of Protocol
             * @param value `CfnBucket.RedirectRuleProperty.Protocol`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withProtocol(@javax.annotation.Nullable final java.lang.String value) {
                this._protocol = value;
                return this;
            }
            /**
             * Sets the value of ReplaceKeyPrefixWith
             * @param value `CfnBucket.RedirectRuleProperty.ReplaceKeyPrefixWith`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withReplaceKeyPrefixWith(@javax.annotation.Nullable final java.lang.String value) {
                this._replaceKeyPrefixWith = value;
                return this;
            }
            /**
             * Sets the value of ReplaceKeyWith
             * @param value `CfnBucket.RedirectRuleProperty.ReplaceKeyWith`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withReplaceKeyWith(@javax.annotation.Nullable final java.lang.String value) {
                this._replaceKeyWith = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedirectRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public RedirectRuleProperty build() {
                return new RedirectRuleProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $hostName = _hostName;
                    @javax.annotation.Nullable
                    private final java.lang.String $httpRedirectCode = _httpRedirectCode;
                    @javax.annotation.Nullable
                    private final java.lang.String $protocol = _protocol;
                    @javax.annotation.Nullable
                    private final java.lang.String $replaceKeyPrefixWith = _replaceKeyPrefixWith;
                    @javax.annotation.Nullable
                    private final java.lang.String $replaceKeyWith = _replaceKeyWith;

                    @Override
                    public java.lang.String getHostName() {
                        return this.$hostName;
                    }

                    @Override
                    public java.lang.String getHttpRedirectCode() {
                        return this.$httpRedirectCode;
                    }

                    @Override
                    public java.lang.String getProtocol() {
                        return this.$protocol;
                    }

                    @Override
                    public java.lang.String getReplaceKeyPrefixWith() {
                        return this.$replaceKeyPrefixWith;
                    }

                    @Override
                    public java.lang.String getReplaceKeyWith() {
                        return this.$replaceKeyWith;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getHostName() != null) {
                            obj.set("hostName", om.valueToTree(this.getHostName()));
                        }
                        if (this.getHttpRedirectCode() != null) {
                            obj.set("httpRedirectCode", om.valueToTree(this.getHttpRedirectCode()));
                        }
                        if (this.getProtocol() != null) {
                            obj.set("protocol", om.valueToTree(this.getProtocol()));
                        }
                        if (this.getReplaceKeyPrefixWith() != null) {
                            obj.set("replaceKeyPrefixWith", om.valueToTree(this.getReplaceKeyPrefixWith()));
                        }
                        if (this.getReplaceKeyWith() != null) {
                            obj.set("replaceKeyWith", om.valueToTree(this.getReplaceKeyWith()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.RedirectRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.RedirectRuleProperty.HostName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-hostname
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getHostName() {
                return this.jsiiGet("hostName", java.lang.String.class);
            }

            /**
             * `CfnBucket.RedirectRuleProperty.HttpRedirectCode`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-httpredirectcode
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getHttpRedirectCode() {
                return this.jsiiGet("httpRedirectCode", java.lang.String.class);
            }

            /**
             * `CfnBucket.RedirectRuleProperty.Protocol`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-protocol
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getProtocol() {
                return this.jsiiGet("protocol", java.lang.String.class);
            }

            /**
             * `CfnBucket.RedirectRuleProperty.ReplaceKeyPrefixWith`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeyprefixwith
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getReplaceKeyPrefixWith() {
                return this.jsiiGet("replaceKeyPrefixWith", java.lang.String.class);
            }

            /**
             * `CfnBucket.RedirectRuleProperty.ReplaceKeyWith`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeywith
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getReplaceKeyWith() {
                return this.jsiiGet("replaceKeyWith", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.ReplicationConfigurationProperty.Role`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-role
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getRole();
        /**
         * `CfnBucket.ReplicationConfigurationProperty.Rules`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getRules();

        /**
         * @return a {@link Builder} of {@link ReplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ReplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _role;
            private java.lang.Object _rules;

            /**
             * Sets the value of Role
             * @param value `CfnBucket.ReplicationConfigurationProperty.Role`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRole(final java.lang.String value) {
                this._role = java.util.Objects.requireNonNull(value, "role is required");
                return this;
            }
            /**
             * Sets the value of Rules
             * @param value `CfnBucket.ReplicationConfigurationProperty.Rules`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRules(final software.amazon.awscdk.core.IResolvable value) {
                this._rules = java.util.Objects.requireNonNull(value, "rules is required");
                return this;
            }
            /**
             * Sets the value of Rules
             * @param value `CfnBucket.ReplicationConfigurationProperty.Rules`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRules(final java.util.List<java.lang.Object> value) {
                this._rules = java.util.Objects.requireNonNull(value, "rules is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public ReplicationConfigurationProperty build() {
                return new ReplicationConfigurationProperty() {
                    private final java.lang.String $role = java.util.Objects.requireNonNull(_role, "role is required");
                    private final java.lang.Object $rules = java.util.Objects.requireNonNull(_rules, "rules is required");

                    @Override
                    public java.lang.String getRole() {
                        return this.$role;
                    }

                    @Override
                    public java.lang.Object getRules() {
                        return this.$rules;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("role", om.valueToTree(this.getRole()));
                        obj.set("rules", om.valueToTree(this.getRules()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.ReplicationConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.ReplicationConfigurationProperty.Role`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-role
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getRole() {
                return this.jsiiGet("role", java.lang.String.class);
            }

            /**
             * `CfnBucket.ReplicationConfigurationProperty.Rules`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.Object getRules() {
                return this.jsiiGet("rules", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicationDestinationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.ReplicationDestinationProperty.Bucket`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-bucket
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getBucket();
        /**
         * `CfnBucket.ReplicationDestinationProperty.AccessControlTranslation`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getAccessControlTranslation();
        /**
         * `CfnBucket.ReplicationDestinationProperty.Account`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-account
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getAccount();
        /**
         * `CfnBucket.ReplicationDestinationProperty.EncryptionConfiguration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getEncryptionConfiguration();
        /**
         * `CfnBucket.ReplicationDestinationProperty.StorageClass`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-storageclass
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getStorageClass();

        /**
         * @return a {@link Builder} of {@link ReplicationDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ReplicationDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _bucket;
            @javax.annotation.Nullable
            private java.lang.Object _accessControlTranslation;
            @javax.annotation.Nullable
            private java.lang.String _account;
            @javax.annotation.Nullable
            private java.lang.Object _encryptionConfiguration;
            @javax.annotation.Nullable
            private java.lang.String _storageClass;

            /**
             * Sets the value of Bucket
             * @param value `CfnBucket.ReplicationDestinationProperty.Bucket`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withBucket(final java.lang.String value) {
                this._bucket = java.util.Objects.requireNonNull(value, "bucket is required");
                return this;
            }
            /**
             * Sets the value of AccessControlTranslation
             * @param value `CfnBucket.ReplicationDestinationProperty.AccessControlTranslation`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withAccessControlTranslation(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._accessControlTranslation = value;
                return this;
            }
            /**
             * Sets the value of AccessControlTranslation
             * @param value `CfnBucket.ReplicationDestinationProperty.AccessControlTranslation`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withAccessControlTranslation(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.AccessControlTranslationProperty value) {
                this._accessControlTranslation = value;
                return this;
            }
            /**
             * Sets the value of Account
             * @param value `CfnBucket.ReplicationDestinationProperty.Account`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withAccount(@javax.annotation.Nullable final java.lang.String value) {
                this._account = value;
                return this;
            }
            /**
             * Sets the value of EncryptionConfiguration
             * @param value `CfnBucket.ReplicationDestinationProperty.EncryptionConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withEncryptionConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._encryptionConfiguration = value;
                return this;
            }
            /**
             * Sets the value of EncryptionConfiguration
             * @param value `CfnBucket.ReplicationDestinationProperty.EncryptionConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withEncryptionConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.EncryptionConfigurationProperty value) {
                this._encryptionConfiguration = value;
                return this;
            }
            /**
             * Sets the value of StorageClass
             * @param value `CfnBucket.ReplicationDestinationProperty.StorageClass`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withStorageClass(@javax.annotation.Nullable final java.lang.String value) {
                this._storageClass = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public ReplicationDestinationProperty build() {
                return new ReplicationDestinationProperty() {
                    private final java.lang.String $bucket = java.util.Objects.requireNonNull(_bucket, "bucket is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $accessControlTranslation = _accessControlTranslation;
                    @javax.annotation.Nullable
                    private final java.lang.String $account = _account;
                    @javax.annotation.Nullable
                    private final java.lang.Object $encryptionConfiguration = _encryptionConfiguration;
                    @javax.annotation.Nullable
                    private final java.lang.String $storageClass = _storageClass;

                    @Override
                    public java.lang.String getBucket() {
                        return this.$bucket;
                    }

                    @Override
                    public java.lang.Object getAccessControlTranslation() {
                        return this.$accessControlTranslation;
                    }

                    @Override
                    public java.lang.String getAccount() {
                        return this.$account;
                    }

                    @Override
                    public java.lang.Object getEncryptionConfiguration() {
                        return this.$encryptionConfiguration;
                    }

                    @Override
                    public java.lang.String getStorageClass() {
                        return this.$storageClass;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("bucket", om.valueToTree(this.getBucket()));
                        if (this.getAccessControlTranslation() != null) {
                            obj.set("accessControlTranslation", om.valueToTree(this.getAccessControlTranslation()));
                        }
                        if (this.getAccount() != null) {
                            obj.set("account", om.valueToTree(this.getAccount()));
                        }
                        if (this.getEncryptionConfiguration() != null) {
                            obj.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
                        }
                        if (this.getStorageClass() != null) {
                            obj.set("storageClass", om.valueToTree(this.getStorageClass()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.ReplicationDestinationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.ReplicationDestinationProperty.Bucket`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-bucket
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getBucket() {
                return this.jsiiGet("bucket", java.lang.String.class);
            }

            /**
             * `CfnBucket.ReplicationDestinationProperty.AccessControlTranslation`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getAccessControlTranslation() {
                return this.jsiiGet("accessControlTranslation", java.lang.Object.class);
            }

            /**
             * `CfnBucket.ReplicationDestinationProperty.Account`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-account
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getAccount() {
                return this.jsiiGet("account", java.lang.String.class);
            }

            /**
             * `CfnBucket.ReplicationDestinationProperty.EncryptionConfiguration`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getEncryptionConfiguration() {
                return this.jsiiGet("encryptionConfiguration", java.lang.Object.class);
            }

            /**
             * `CfnBucket.ReplicationDestinationProperty.StorageClass`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-storageclass
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getStorageClass() {
                return this.jsiiGet("storageClass", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicationRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.ReplicationRuleProperty.Destination`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getDestination();
        /**
         * `CfnBucket.ReplicationRuleProperty.Prefix`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-prefix
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getPrefix();
        /**
         * `CfnBucket.ReplicationRuleProperty.Status`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-status
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getStatus();
        /**
         * `CfnBucket.ReplicationRuleProperty.Id`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-id
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getId();
        /**
         * `CfnBucket.ReplicationRuleProperty.SourceSelectionCriteria`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getSourceSelectionCriteria();

        /**
         * @return a {@link Builder} of {@link ReplicationRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ReplicationRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.Object _destination;
            private java.lang.String _prefix;
            private java.lang.String _status;
            @javax.annotation.Nullable
            private java.lang.String _id;
            @javax.annotation.Nullable
            private java.lang.Object _sourceSelectionCriteria;

            /**
             * Sets the value of Destination
             * @param value `CfnBucket.ReplicationRuleProperty.Destination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withDestination(final software.amazon.awscdk.core.IResolvable value) {
                this._destination = java.util.Objects.requireNonNull(value, "destination is required");
                return this;
            }
            /**
             * Sets the value of Destination
             * @param value `CfnBucket.ReplicationRuleProperty.Destination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withDestination(final software.amazon.awscdk.services.s3.CfnBucket.ReplicationDestinationProperty value) {
                this._destination = java.util.Objects.requireNonNull(value, "destination is required");
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value `CfnBucket.ReplicationRuleProperty.Prefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withPrefix(final java.lang.String value) {
                this._prefix = java.util.Objects.requireNonNull(value, "prefix is required");
                return this;
            }
            /**
             * Sets the value of Status
             * @param value `CfnBucket.ReplicationRuleProperty.Status`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withStatus(final java.lang.String value) {
                this._status = java.util.Objects.requireNonNull(value, "status is required");
                return this;
            }
            /**
             * Sets the value of Id
             * @param value `CfnBucket.ReplicationRuleProperty.Id`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withId(@javax.annotation.Nullable final java.lang.String value) {
                this._id = value;
                return this;
            }
            /**
             * Sets the value of SourceSelectionCriteria
             * @param value `CfnBucket.ReplicationRuleProperty.SourceSelectionCriteria`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withSourceSelectionCriteria(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._sourceSelectionCriteria = value;
                return this;
            }
            /**
             * Sets the value of SourceSelectionCriteria
             * @param value `CfnBucket.ReplicationRuleProperty.SourceSelectionCriteria`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withSourceSelectionCriteria(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.SourceSelectionCriteriaProperty value) {
                this._sourceSelectionCriteria = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public ReplicationRuleProperty build() {
                return new ReplicationRuleProperty() {
                    private final java.lang.Object $destination = java.util.Objects.requireNonNull(_destination, "destination is required");
                    private final java.lang.String $prefix = java.util.Objects.requireNonNull(_prefix, "prefix is required");
                    private final java.lang.String $status = java.util.Objects.requireNonNull(_status, "status is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $id = _id;
                    @javax.annotation.Nullable
                    private final java.lang.Object $sourceSelectionCriteria = _sourceSelectionCriteria;

                    @Override
                    public java.lang.Object getDestination() {
                        return this.$destination;
                    }

                    @Override
                    public java.lang.String getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public java.lang.String getStatus() {
                        return this.$status;
                    }

                    @Override
                    public java.lang.String getId() {
                        return this.$id;
                    }

                    @Override
                    public java.lang.Object getSourceSelectionCriteria() {
                        return this.$sourceSelectionCriteria;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("destination", om.valueToTree(this.getDestination()));
                        obj.set("prefix", om.valueToTree(this.getPrefix()));
                        obj.set("status", om.valueToTree(this.getStatus()));
                        if (this.getId() != null) {
                            obj.set("id", om.valueToTree(this.getId()));
                        }
                        if (this.getSourceSelectionCriteria() != null) {
                            obj.set("sourceSelectionCriteria", om.valueToTree(this.getSourceSelectionCriteria()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.ReplicationRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.ReplicationRuleProperty.Destination`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.Object getDestination() {
                return this.jsiiGet("destination", java.lang.Object.class);
            }

            /**
             * `CfnBucket.ReplicationRuleProperty.Prefix`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-prefix
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getPrefix() {
                return this.jsiiGet("prefix", java.lang.String.class);
            }

            /**
             * `CfnBucket.ReplicationRuleProperty.Status`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-status
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getStatus() {
                return this.jsiiGet("status", java.lang.String.class);
            }

            /**
             * `CfnBucket.ReplicationRuleProperty.Id`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-id
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getId() {
                return this.jsiiGet("id", java.lang.String.class);
            }

            /**
             * `CfnBucket.ReplicationRuleProperty.SourceSelectionCriteria`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getSourceSelectionCriteria() {
                return this.jsiiGet("sourceSelectionCriteria", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RoutingRuleConditionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-httperrorcodereturnedequals
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getHttpErrorCodeReturnedEquals();
        /**
         * `CfnBucket.RoutingRuleConditionProperty.KeyPrefixEquals`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-keyprefixequals
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getKeyPrefixEquals();

        /**
         * @return a {@link Builder} of {@link RoutingRuleConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RoutingRuleConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _httpErrorCodeReturnedEquals;
            @javax.annotation.Nullable
            private java.lang.String _keyPrefixEquals;

            /**
             * Sets the value of HttpErrorCodeReturnedEquals
             * @param value `CfnBucket.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withHttpErrorCodeReturnedEquals(@javax.annotation.Nullable final java.lang.String value) {
                this._httpErrorCodeReturnedEquals = value;
                return this;
            }
            /**
             * Sets the value of KeyPrefixEquals
             * @param value `CfnBucket.RoutingRuleConditionProperty.KeyPrefixEquals`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withKeyPrefixEquals(@javax.annotation.Nullable final java.lang.String value) {
                this._keyPrefixEquals = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RoutingRuleConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public RoutingRuleConditionProperty build() {
                return new RoutingRuleConditionProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $httpErrorCodeReturnedEquals = _httpErrorCodeReturnedEquals;
                    @javax.annotation.Nullable
                    private final java.lang.String $keyPrefixEquals = _keyPrefixEquals;

                    @Override
                    public java.lang.String getHttpErrorCodeReturnedEquals() {
                        return this.$httpErrorCodeReturnedEquals;
                    }

                    @Override
                    public java.lang.String getKeyPrefixEquals() {
                        return this.$keyPrefixEquals;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getHttpErrorCodeReturnedEquals() != null) {
                            obj.set("httpErrorCodeReturnedEquals", om.valueToTree(this.getHttpErrorCodeReturnedEquals()));
                        }
                        if (this.getKeyPrefixEquals() != null) {
                            obj.set("keyPrefixEquals", om.valueToTree(this.getKeyPrefixEquals()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.RoutingRuleConditionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-httperrorcodereturnedequals
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getHttpErrorCodeReturnedEquals() {
                return this.jsiiGet("httpErrorCodeReturnedEquals", java.lang.String.class);
            }

            /**
             * `CfnBucket.RoutingRuleConditionProperty.KeyPrefixEquals`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-keyprefixequals
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getKeyPrefixEquals() {
                return this.jsiiGet("keyPrefixEquals", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RoutingRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.RoutingRuleProperty.RedirectRule`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getRedirectRule();
        /**
         * `CfnBucket.RoutingRuleProperty.RoutingRuleCondition`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getRoutingRuleCondition();

        /**
         * @return a {@link Builder} of {@link RoutingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RoutingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.Object _redirectRule;
            @javax.annotation.Nullable
            private java.lang.Object _routingRuleCondition;

            /**
             * Sets the value of RedirectRule
             * @param value `CfnBucket.RoutingRuleProperty.RedirectRule`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRedirectRule(final software.amazon.awscdk.core.IResolvable value) {
                this._redirectRule = java.util.Objects.requireNonNull(value, "redirectRule is required");
                return this;
            }
            /**
             * Sets the value of RedirectRule
             * @param value `CfnBucket.RoutingRuleProperty.RedirectRule`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRedirectRule(final software.amazon.awscdk.services.s3.CfnBucket.RedirectRuleProperty value) {
                this._redirectRule = java.util.Objects.requireNonNull(value, "redirectRule is required");
                return this;
            }
            /**
             * Sets the value of RoutingRuleCondition
             * @param value `CfnBucket.RoutingRuleProperty.RoutingRuleCondition`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRoutingRuleCondition(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._routingRuleCondition = value;
                return this;
            }
            /**
             * Sets the value of RoutingRuleCondition
             * @param value `CfnBucket.RoutingRuleProperty.RoutingRuleCondition`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRoutingRuleCondition(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.RoutingRuleConditionProperty value) {
                this._routingRuleCondition = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RoutingRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public RoutingRuleProperty build() {
                return new RoutingRuleProperty() {
                    private final java.lang.Object $redirectRule = java.util.Objects.requireNonNull(_redirectRule, "redirectRule is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $routingRuleCondition = _routingRuleCondition;

                    @Override
                    public java.lang.Object getRedirectRule() {
                        return this.$redirectRule;
                    }

                    @Override
                    public java.lang.Object getRoutingRuleCondition() {
                        return this.$routingRuleCondition;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("redirectRule", om.valueToTree(this.getRedirectRule()));
                        if (this.getRoutingRuleCondition() != null) {
                            obj.set("routingRuleCondition", om.valueToTree(this.getRoutingRuleCondition()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.RoutingRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.RoutingRuleProperty.RedirectRule`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.Object getRedirectRule() {
                return this.jsiiGet("redirectRule", java.lang.Object.class);
            }

            /**
             * `CfnBucket.RoutingRuleProperty.RoutingRuleCondition`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getRoutingRuleCondition() {
                return this.jsiiGet("routingRuleCondition", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.RuleProperty.Status`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-status
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getStatus();
        /**
         * `CfnBucket.RuleProperty.AbortIncompleteMultipartUpload`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getAbortIncompleteMultipartUpload();
        /**
         * `CfnBucket.RuleProperty.ExpirationDate`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getExpirationDate();
        /**
         * `CfnBucket.RuleProperty.ExpirationInDays`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Number getExpirationInDays();
        /**
         * `CfnBucket.RuleProperty.Id`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-id
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getId();
        /**
         * `CfnBucket.RuleProperty.NoncurrentVersionExpirationInDays`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Number getNoncurrentVersionExpirationInDays();
        /**
         * `CfnBucket.RuleProperty.NoncurrentVersionTransition`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getNoncurrentVersionTransition();
        /**
         * `CfnBucket.RuleProperty.NoncurrentVersionTransitions`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getNoncurrentVersionTransitions();
        /**
         * `CfnBucket.RuleProperty.Prefix`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-prefix
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getPrefix();
        /**
         * `CfnBucket.RuleProperty.TagFilters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getTagFilters();
        /**
         * `CfnBucket.RuleProperty.Transition`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getTransition();
        /**
         * `CfnBucket.RuleProperty.Transitions`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getTransitions();

        /**
         * @return a {@link Builder} of {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _status;
            @javax.annotation.Nullable
            private java.lang.Object _abortIncompleteMultipartUpload;
            @javax.annotation.Nullable
            private java.lang.Object _expirationDate;
            @javax.annotation.Nullable
            private java.lang.Number _expirationInDays;
            @javax.annotation.Nullable
            private java.lang.String _id;
            @javax.annotation.Nullable
            private java.lang.Number _noncurrentVersionExpirationInDays;
            @javax.annotation.Nullable
            private java.lang.Object _noncurrentVersionTransition;
            @javax.annotation.Nullable
            private java.lang.Object _noncurrentVersionTransitions;
            @javax.annotation.Nullable
            private java.lang.String _prefix;
            @javax.annotation.Nullable
            private java.lang.Object _tagFilters;
            @javax.annotation.Nullable
            private java.lang.Object _transition;
            @javax.annotation.Nullable
            private java.lang.Object _transitions;

            /**
             * Sets the value of Status
             * @param value `CfnBucket.RuleProperty.Status`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withStatus(final java.lang.String value) {
                this._status = java.util.Objects.requireNonNull(value, "status is required");
                return this;
            }
            /**
             * Sets the value of AbortIncompleteMultipartUpload
             * @param value `CfnBucket.RuleProperty.AbortIncompleteMultipartUpload`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withAbortIncompleteMultipartUpload(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._abortIncompleteMultipartUpload = value;
                return this;
            }
            /**
             * Sets the value of AbortIncompleteMultipartUpload
             * @param value `CfnBucket.RuleProperty.AbortIncompleteMultipartUpload`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withAbortIncompleteMultipartUpload(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.AbortIncompleteMultipartUploadProperty value) {
                this._abortIncompleteMultipartUpload = value;
                return this;
            }
            /**
             * Sets the value of ExpirationDate
             * @param value `CfnBucket.RuleProperty.ExpirationDate`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withExpirationDate(@javax.annotation.Nullable final java.time.Instant value) {
                this._expirationDate = value;
                return this;
            }
            /**
             * Sets the value of ExpirationDate
             * @param value `CfnBucket.RuleProperty.ExpirationDate`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withExpirationDate(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._expirationDate = value;
                return this;
            }
            /**
             * Sets the value of ExpirationInDays
             * @param value `CfnBucket.RuleProperty.ExpirationInDays`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withExpirationInDays(@javax.annotation.Nullable final java.lang.Number value) {
                this._expirationInDays = value;
                return this;
            }
            /**
             * Sets the value of Id
             * @param value `CfnBucket.RuleProperty.Id`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withId(@javax.annotation.Nullable final java.lang.String value) {
                this._id = value;
                return this;
            }
            /**
             * Sets the value of NoncurrentVersionExpirationInDays
             * @param value `CfnBucket.RuleProperty.NoncurrentVersionExpirationInDays`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withNoncurrentVersionExpirationInDays(@javax.annotation.Nullable final java.lang.Number value) {
                this._noncurrentVersionExpirationInDays = value;
                return this;
            }
            /**
             * Sets the value of NoncurrentVersionTransition
             * @param value `CfnBucket.RuleProperty.NoncurrentVersionTransition`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withNoncurrentVersionTransition(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._noncurrentVersionTransition = value;
                return this;
            }
            /**
             * Sets the value of NoncurrentVersionTransition
             * @param value `CfnBucket.RuleProperty.NoncurrentVersionTransition`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withNoncurrentVersionTransition(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.NoncurrentVersionTransitionProperty value) {
                this._noncurrentVersionTransition = value;
                return this;
            }
            /**
             * Sets the value of NoncurrentVersionTransitions
             * @param value `CfnBucket.RuleProperty.NoncurrentVersionTransitions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withNoncurrentVersionTransitions(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._noncurrentVersionTransitions = value;
                return this;
            }
            /**
             * Sets the value of NoncurrentVersionTransitions
             * @param value `CfnBucket.RuleProperty.NoncurrentVersionTransitions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withNoncurrentVersionTransitions(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._noncurrentVersionTransitions = value;
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value `CfnBucket.RuleProperty.Prefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this._prefix = value;
                return this;
            }
            /**
             * Sets the value of TagFilters
             * @param value `CfnBucket.RuleProperty.TagFilters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTagFilters(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._tagFilters = value;
                return this;
            }
            /**
             * Sets the value of TagFilters
             * @param value `CfnBucket.RuleProperty.TagFilters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTagFilters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._tagFilters = value;
                return this;
            }
            /**
             * Sets the value of Transition
             * @param value `CfnBucket.RuleProperty.Transition`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTransition(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._transition = value;
                return this;
            }
            /**
             * Sets the value of Transition
             * @param value `CfnBucket.RuleProperty.Transition`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTransition(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.TransitionProperty value) {
                this._transition = value;
                return this;
            }
            /**
             * Sets the value of Transitions
             * @param value `CfnBucket.RuleProperty.Transitions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTransitions(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._transitions = value;
                return this;
            }
            /**
             * Sets the value of Transitions
             * @param value `CfnBucket.RuleProperty.Transitions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTransitions(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._transitions = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public RuleProperty build() {
                return new RuleProperty() {
                    private final java.lang.String $status = java.util.Objects.requireNonNull(_status, "status is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $abortIncompleteMultipartUpload = _abortIncompleteMultipartUpload;
                    @javax.annotation.Nullable
                    private final java.lang.Object $expirationDate = _expirationDate;
                    @javax.annotation.Nullable
                    private final java.lang.Number $expirationInDays = _expirationInDays;
                    @javax.annotation.Nullable
                    private final java.lang.String $id = _id;
                    @javax.annotation.Nullable
                    private final java.lang.Number $noncurrentVersionExpirationInDays = _noncurrentVersionExpirationInDays;
                    @javax.annotation.Nullable
                    private final java.lang.Object $noncurrentVersionTransition = _noncurrentVersionTransition;
                    @javax.annotation.Nullable
                    private final java.lang.Object $noncurrentVersionTransitions = _noncurrentVersionTransitions;
                    @javax.annotation.Nullable
                    private final java.lang.String $prefix = _prefix;
                    @javax.annotation.Nullable
                    private final java.lang.Object $tagFilters = _tagFilters;
                    @javax.annotation.Nullable
                    private final java.lang.Object $transition = _transition;
                    @javax.annotation.Nullable
                    private final java.lang.Object $transitions = _transitions;

                    @Override
                    public java.lang.String getStatus() {
                        return this.$status;
                    }

                    @Override
                    public java.lang.Object getAbortIncompleteMultipartUpload() {
                        return this.$abortIncompleteMultipartUpload;
                    }

                    @Override
                    public java.lang.Object getExpirationDate() {
                        return this.$expirationDate;
                    }

                    @Override
                    public java.lang.Number getExpirationInDays() {
                        return this.$expirationInDays;
                    }

                    @Override
                    public java.lang.String getId() {
                        return this.$id;
                    }

                    @Override
                    public java.lang.Number getNoncurrentVersionExpirationInDays() {
                        return this.$noncurrentVersionExpirationInDays;
                    }

                    @Override
                    public java.lang.Object getNoncurrentVersionTransition() {
                        return this.$noncurrentVersionTransition;
                    }

                    @Override
                    public java.lang.Object getNoncurrentVersionTransitions() {
                        return this.$noncurrentVersionTransitions;
                    }

                    @Override
                    public java.lang.String getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public java.lang.Object getTagFilters() {
                        return this.$tagFilters;
                    }

                    @Override
                    public java.lang.Object getTransition() {
                        return this.$transition;
                    }

                    @Override
                    public java.lang.Object getTransitions() {
                        return this.$transitions;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("status", om.valueToTree(this.getStatus()));
                        if (this.getAbortIncompleteMultipartUpload() != null) {
                            obj.set("abortIncompleteMultipartUpload", om.valueToTree(this.getAbortIncompleteMultipartUpload()));
                        }
                        if (this.getExpirationDate() != null) {
                            obj.set("expirationDate", om.valueToTree(this.getExpirationDate()));
                        }
                        if (this.getExpirationInDays() != null) {
                            obj.set("expirationInDays", om.valueToTree(this.getExpirationInDays()));
                        }
                        if (this.getId() != null) {
                            obj.set("id", om.valueToTree(this.getId()));
                        }
                        if (this.getNoncurrentVersionExpirationInDays() != null) {
                            obj.set("noncurrentVersionExpirationInDays", om.valueToTree(this.getNoncurrentVersionExpirationInDays()));
                        }
                        if (this.getNoncurrentVersionTransition() != null) {
                            obj.set("noncurrentVersionTransition", om.valueToTree(this.getNoncurrentVersionTransition()));
                        }
                        if (this.getNoncurrentVersionTransitions() != null) {
                            obj.set("noncurrentVersionTransitions", om.valueToTree(this.getNoncurrentVersionTransitions()));
                        }
                        if (this.getPrefix() != null) {
                            obj.set("prefix", om.valueToTree(this.getPrefix()));
                        }
                        if (this.getTagFilters() != null) {
                            obj.set("tagFilters", om.valueToTree(this.getTagFilters()));
                        }
                        if (this.getTransition() != null) {
                            obj.set("transition", om.valueToTree(this.getTransition()));
                        }
                        if (this.getTransitions() != null) {
                            obj.set("transitions", om.valueToTree(this.getTransitions()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.RuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.RuleProperty.Status`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-status
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getStatus() {
                return this.jsiiGet("status", java.lang.String.class);
            }

            /**
             * `CfnBucket.RuleProperty.AbortIncompleteMultipartUpload`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getAbortIncompleteMultipartUpload() {
                return this.jsiiGet("abortIncompleteMultipartUpload", java.lang.Object.class);
            }

            /**
             * `CfnBucket.RuleProperty.ExpirationDate`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getExpirationDate() {
                return this.jsiiGet("expirationDate", java.lang.Object.class);
            }

            /**
             * `CfnBucket.RuleProperty.ExpirationInDays`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Number getExpirationInDays() {
                return this.jsiiGet("expirationInDays", java.lang.Number.class);
            }

            /**
             * `CfnBucket.RuleProperty.Id`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-id
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getId() {
                return this.jsiiGet("id", java.lang.String.class);
            }

            /**
             * `CfnBucket.RuleProperty.NoncurrentVersionExpirationInDays`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Number getNoncurrentVersionExpirationInDays() {
                return this.jsiiGet("noncurrentVersionExpirationInDays", java.lang.Number.class);
            }

            /**
             * `CfnBucket.RuleProperty.NoncurrentVersionTransition`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getNoncurrentVersionTransition() {
                return this.jsiiGet("noncurrentVersionTransition", java.lang.Object.class);
            }

            /**
             * `CfnBucket.RuleProperty.NoncurrentVersionTransitions`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getNoncurrentVersionTransitions() {
                return this.jsiiGet("noncurrentVersionTransitions", java.lang.Object.class);
            }

            /**
             * `CfnBucket.RuleProperty.Prefix`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-prefix
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getPrefix() {
                return this.jsiiGet("prefix", java.lang.String.class);
            }

            /**
             * `CfnBucket.RuleProperty.TagFilters`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getTagFilters() {
                return this.jsiiGet("tagFilters", java.lang.Object.class);
            }

            /**
             * `CfnBucket.RuleProperty.Transition`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getTransition() {
                return this.jsiiGet("transition", java.lang.Object.class);
            }

            /**
             * `CfnBucket.RuleProperty.Transitions`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getTransitions() {
                return this.jsiiGet("transitions", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3KeyFilterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.S3KeyFilterProperty.Rules`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getRules();

        /**
         * @return a {@link Builder} of {@link S3KeyFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link S3KeyFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.Object _rules;

            /**
             * Sets the value of Rules
             * @param value `CfnBucket.S3KeyFilterProperty.Rules`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRules(final software.amazon.awscdk.core.IResolvable value) {
                this._rules = java.util.Objects.requireNonNull(value, "rules is required");
                return this;
            }
            /**
             * Sets the value of Rules
             * @param value `CfnBucket.S3KeyFilterProperty.Rules`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRules(final java.util.List<java.lang.Object> value) {
                this._rules = java.util.Objects.requireNonNull(value, "rules is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3KeyFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public S3KeyFilterProperty build() {
                return new S3KeyFilterProperty() {
                    private final java.lang.Object $rules = java.util.Objects.requireNonNull(_rules, "rules is required");

                    @Override
                    public java.lang.Object getRules() {
                        return this.$rules;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("rules", om.valueToTree(this.getRules()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.S3KeyFilterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.S3KeyFilterProperty.Rules`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.Object getRules() {
                return this.jsiiGet("rules", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServerSideEncryptionByDefaultProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.ServerSideEncryptionByDefaultProperty.SSEAlgorithm`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-ssealgorithm
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getSseAlgorithm();
        /**
         * `CfnBucket.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-kmsmasterkeyid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getKmsMasterKeyId();

        /**
         * @return a {@link Builder} of {@link ServerSideEncryptionByDefaultProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ServerSideEncryptionByDefaultProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _sseAlgorithm;
            @javax.annotation.Nullable
            private java.lang.String _kmsMasterKeyId;

            /**
             * Sets the value of SseAlgorithm
             * @param value `CfnBucket.ServerSideEncryptionByDefaultProperty.SSEAlgorithm`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withSseAlgorithm(final java.lang.String value) {
                this._sseAlgorithm = java.util.Objects.requireNonNull(value, "sseAlgorithm is required");
                return this;
            }
            /**
             * Sets the value of KmsMasterKeyId
             * @param value `CfnBucket.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withKmsMasterKeyId(@javax.annotation.Nullable final java.lang.String value) {
                this._kmsMasterKeyId = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerSideEncryptionByDefaultProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public ServerSideEncryptionByDefaultProperty build() {
                return new ServerSideEncryptionByDefaultProperty() {
                    private final java.lang.String $sseAlgorithm = java.util.Objects.requireNonNull(_sseAlgorithm, "sseAlgorithm is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $kmsMasterKeyId = _kmsMasterKeyId;

                    @Override
                    public java.lang.String getSseAlgorithm() {
                        return this.$sseAlgorithm;
                    }

                    @Override
                    public java.lang.String getKmsMasterKeyId() {
                        return this.$kmsMasterKeyId;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("sseAlgorithm", om.valueToTree(this.getSseAlgorithm()));
                        if (this.getKmsMasterKeyId() != null) {
                            obj.set("kmsMasterKeyId", om.valueToTree(this.getKmsMasterKeyId()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.ServerSideEncryptionByDefaultProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.ServerSideEncryptionByDefaultProperty.SSEAlgorithm`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-ssealgorithm
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getSseAlgorithm() {
                return this.jsiiGet("sseAlgorithm", java.lang.String.class);
            }

            /**
             * `CfnBucket.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-kmsmasterkeyid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getKmsMasterKeyId() {
                return this.jsiiGet("kmsMasterKeyId", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServerSideEncryptionRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-serversideencryptionbydefault
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getServerSideEncryptionByDefault();

        /**
         * @return a {@link Builder} of {@link ServerSideEncryptionRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ServerSideEncryptionRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _serverSideEncryptionByDefault;

            /**
             * Sets the value of ServerSideEncryptionByDefault
             * @param value `CfnBucket.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withServerSideEncryptionByDefault(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._serverSideEncryptionByDefault = value;
                return this;
            }
            /**
             * Sets the value of ServerSideEncryptionByDefault
             * @param value `CfnBucket.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withServerSideEncryptionByDefault(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.ServerSideEncryptionByDefaultProperty value) {
                this._serverSideEncryptionByDefault = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerSideEncryptionRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public ServerSideEncryptionRuleProperty build() {
                return new ServerSideEncryptionRuleProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $serverSideEncryptionByDefault = _serverSideEncryptionByDefault;

                    @Override
                    public java.lang.Object getServerSideEncryptionByDefault() {
                        return this.$serverSideEncryptionByDefault;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getServerSideEncryptionByDefault() != null) {
                            obj.set("serverSideEncryptionByDefault", om.valueToTree(this.getServerSideEncryptionByDefault()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.ServerSideEncryptionRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-serversideencryptionbydefault
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getServerSideEncryptionByDefault() {
                return this.jsiiGet("serverSideEncryptionByDefault", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceSelectionCriteriaProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getSseKmsEncryptedObjects();

        /**
         * @return a {@link Builder} of {@link SourceSelectionCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SourceSelectionCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.Object _sseKmsEncryptedObjects;

            /**
             * Sets the value of SseKmsEncryptedObjects
             * @param value `CfnBucket.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withSseKmsEncryptedObjects(final software.amazon.awscdk.core.IResolvable value) {
                this._sseKmsEncryptedObjects = java.util.Objects.requireNonNull(value, "sseKmsEncryptedObjects is required");
                return this;
            }
            /**
             * Sets the value of SseKmsEncryptedObjects
             * @param value `CfnBucket.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withSseKmsEncryptedObjects(final software.amazon.awscdk.services.s3.CfnBucket.SseKmsEncryptedObjectsProperty value) {
                this._sseKmsEncryptedObjects = java.util.Objects.requireNonNull(value, "sseKmsEncryptedObjects is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceSelectionCriteriaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public SourceSelectionCriteriaProperty build() {
                return new SourceSelectionCriteriaProperty() {
                    private final java.lang.Object $sseKmsEncryptedObjects = java.util.Objects.requireNonNull(_sseKmsEncryptedObjects, "sseKmsEncryptedObjects is required");

                    @Override
                    public java.lang.Object getSseKmsEncryptedObjects() {
                        return this.$sseKmsEncryptedObjects;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("sseKmsEncryptedObjects", om.valueToTree(this.getSseKmsEncryptedObjects()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.SourceSelectionCriteriaProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.Object getSseKmsEncryptedObjects() {
                return this.jsiiGet("sseKmsEncryptedObjects", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SseKmsEncryptedObjectsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.SseKmsEncryptedObjectsProperty.Status`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html#cfn-s3-bucket-ssekmsencryptedobjects-status
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getStatus();

        /**
         * @return a {@link Builder} of {@link SseKmsEncryptedObjectsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SseKmsEncryptedObjectsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _status;

            /**
             * Sets the value of Status
             * @param value `CfnBucket.SseKmsEncryptedObjectsProperty.Status`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withStatus(final java.lang.String value) {
                this._status = java.util.Objects.requireNonNull(value, "status is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SseKmsEncryptedObjectsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public SseKmsEncryptedObjectsProperty build() {
                return new SseKmsEncryptedObjectsProperty() {
                    private final java.lang.String $status = java.util.Objects.requireNonNull(_status, "status is required");

                    @Override
                    public java.lang.String getStatus() {
                        return this.$status;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("status", om.valueToTree(this.getStatus()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.SseKmsEncryptedObjectsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.SseKmsEncryptedObjectsProperty.Status`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html#cfn-s3-bucket-ssekmsencryptedobjects-status
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getStatus() {
                return this.jsiiGet("status", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StorageClassAnalysisProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.StorageClassAnalysisProperty.DataExport`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html#cfn-s3-bucket-storageclassanalysis-dataexport
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getDataExport();

        /**
         * @return a {@link Builder} of {@link StorageClassAnalysisProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link StorageClassAnalysisProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _dataExport;

            /**
             * Sets the value of DataExport
             * @param value `CfnBucket.StorageClassAnalysisProperty.DataExport`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withDataExport(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._dataExport = value;
                return this;
            }
            /**
             * Sets the value of DataExport
             * @param value `CfnBucket.StorageClassAnalysisProperty.DataExport`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withDataExport(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.DataExportProperty value) {
                this._dataExport = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StorageClassAnalysisProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public StorageClassAnalysisProperty build() {
                return new StorageClassAnalysisProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $dataExport = _dataExport;

                    @Override
                    public java.lang.Object getDataExport() {
                        return this.$dataExport;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getDataExport() != null) {
                            obj.set("dataExport", om.valueToTree(this.getDataExport()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.StorageClassAnalysisProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.StorageClassAnalysisProperty.DataExport`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html#cfn-s3-bucket-storageclassanalysis-dataexport
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getDataExport() {
                return this.jsiiGet("dataExport", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TagFilterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.TagFilterProperty.Key`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-key
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getKey();
        /**
         * `CfnBucket.TagFilterProperty.Value`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-value
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _key;
            private java.lang.String _value;

            /**
             * Sets the value of Key
             * @param value `CfnBucket.TagFilterProperty.Key`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withKey(final java.lang.String value) {
                this._key = java.util.Objects.requireNonNull(value, "key is required");
                return this;
            }
            /**
             * Sets the value of Value
             * @param value `CfnBucket.TagFilterProperty.Value`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withValue(final java.lang.String value) {
                this._value = java.util.Objects.requireNonNull(value, "value is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public TagFilterProperty build() {
                return new TagFilterProperty() {
                    private final java.lang.String $key = java.util.Objects.requireNonNull(_key, "key is required");
                    private final java.lang.String $value = java.util.Objects.requireNonNull(_value, "value is required");

                    @Override
                    public java.lang.String getKey() {
                        return this.$key;
                    }

                    @Override
                    public java.lang.String getValue() {
                        return this.$value;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("key", om.valueToTree(this.getKey()));
                        obj.set("value", om.valueToTree(this.getValue()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.TagFilterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.TagFilterProperty.Key`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-key
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getKey() {
                return this.jsiiGet("key", java.lang.String.class);
            }

            /**
             * `CfnBucket.TagFilterProperty.Value`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-value
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getValue() {
                return this.jsiiGet("value", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TopicConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.TopicConfigurationProperty.Event`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-event
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getEvent();
        /**
         * `CfnBucket.TopicConfigurationProperty.Topic`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-topic
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getTopic();
        /**
         * `CfnBucket.TopicConfigurationProperty.Filter`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getFilter();

        /**
         * @return a {@link Builder} of {@link TopicConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TopicConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _event;
            private java.lang.String _topic;
            @javax.annotation.Nullable
            private java.lang.Object _filter;

            /**
             * Sets the value of Event
             * @param value `CfnBucket.TopicConfigurationProperty.Event`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withEvent(final java.lang.String value) {
                this._event = java.util.Objects.requireNonNull(value, "event is required");
                return this;
            }
            /**
             * Sets the value of Topic
             * @param value `CfnBucket.TopicConfigurationProperty.Topic`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTopic(final java.lang.String value) {
                this._topic = java.util.Objects.requireNonNull(value, "topic is required");
                return this;
            }
            /**
             * Sets the value of Filter
             * @param value `CfnBucket.TopicConfigurationProperty.Filter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withFilter(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._filter = value;
                return this;
            }
            /**
             * Sets the value of Filter
             * @param value `CfnBucket.TopicConfigurationProperty.Filter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withFilter(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty value) {
                this._filter = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TopicConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public TopicConfigurationProperty build() {
                return new TopicConfigurationProperty() {
                    private final java.lang.String $event = java.util.Objects.requireNonNull(_event, "event is required");
                    private final java.lang.String $topic = java.util.Objects.requireNonNull(_topic, "topic is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $filter = _filter;

                    @Override
                    public java.lang.String getEvent() {
                        return this.$event;
                    }

                    @Override
                    public java.lang.String getTopic() {
                        return this.$topic;
                    }

                    @Override
                    public java.lang.Object getFilter() {
                        return this.$filter;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("event", om.valueToTree(this.getEvent()));
                        obj.set("topic", om.valueToTree(this.getTopic()));
                        if (this.getFilter() != null) {
                            obj.set("filter", om.valueToTree(this.getFilter()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.TopicConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.TopicConfigurationProperty.Event`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-event
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getEvent() {
                return this.jsiiGet("event", java.lang.String.class);
            }

            /**
             * `CfnBucket.TopicConfigurationProperty.Topic`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-topic
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getTopic() {
                return this.jsiiGet("topic", java.lang.String.class);
            }

            /**
             * `CfnBucket.TopicConfigurationProperty.Filter`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getFilter() {
                return this.jsiiGet("filter", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TransitionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.TransitionProperty.StorageClass`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-storageclass
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getStorageClass();
        /**
         * `CfnBucket.TransitionProperty.TransitionDate`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getTransitionDate();
        /**
         * `CfnBucket.TransitionProperty.TransitionInDays`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Number getTransitionInDays();

        /**
         * @return a {@link Builder} of {@link TransitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TransitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _storageClass;
            @javax.annotation.Nullable
            private java.lang.Object _transitionDate;
            @javax.annotation.Nullable
            private java.lang.Number _transitionInDays;

            /**
             * Sets the value of StorageClass
             * @param value `CfnBucket.TransitionProperty.StorageClass`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withStorageClass(final java.lang.String value) {
                this._storageClass = java.util.Objects.requireNonNull(value, "storageClass is required");
                return this;
            }
            /**
             * Sets the value of TransitionDate
             * @param value `CfnBucket.TransitionProperty.TransitionDate`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTransitionDate(@javax.annotation.Nullable final java.time.Instant value) {
                this._transitionDate = value;
                return this;
            }
            /**
             * Sets the value of TransitionDate
             * @param value `CfnBucket.TransitionProperty.TransitionDate`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTransitionDate(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._transitionDate = value;
                return this;
            }
            /**
             * Sets the value of TransitionInDays
             * @param value `CfnBucket.TransitionProperty.TransitionInDays`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTransitionInDays(@javax.annotation.Nullable final java.lang.Number value) {
                this._transitionInDays = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TransitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public TransitionProperty build() {
                return new TransitionProperty() {
                    private final java.lang.String $storageClass = java.util.Objects.requireNonNull(_storageClass, "storageClass is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $transitionDate = _transitionDate;
                    @javax.annotation.Nullable
                    private final java.lang.Number $transitionInDays = _transitionInDays;

                    @Override
                    public java.lang.String getStorageClass() {
                        return this.$storageClass;
                    }

                    @Override
                    public java.lang.Object getTransitionDate() {
                        return this.$transitionDate;
                    }

                    @Override
                    public java.lang.Number getTransitionInDays() {
                        return this.$transitionInDays;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("storageClass", om.valueToTree(this.getStorageClass()));
                        if (this.getTransitionDate() != null) {
                            obj.set("transitionDate", om.valueToTree(this.getTransitionDate()));
                        }
                        if (this.getTransitionInDays() != null) {
                            obj.set("transitionInDays", om.valueToTree(this.getTransitionInDays()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.TransitionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.TransitionProperty.StorageClass`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-storageclass
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getStorageClass() {
                return this.jsiiGet("storageClass", java.lang.String.class);
            }

            /**
             * `CfnBucket.TransitionProperty.TransitionDate`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getTransitionDate() {
                return this.jsiiGet("transitionDate", java.lang.Object.class);
            }

            /**
             * `CfnBucket.TransitionProperty.TransitionInDays`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Number getTransitionInDays() {
                return this.jsiiGet("transitionInDays", java.lang.Number.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VersioningConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.VersioningConfigurationProperty.Status`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html#cfn-s3-bucket-versioningconfig-status
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getStatus();

        /**
         * @return a {@link Builder} of {@link VersioningConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link VersioningConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _status;

            /**
             * Sets the value of Status
             * @param value `CfnBucket.VersioningConfigurationProperty.Status`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withStatus(final java.lang.String value) {
                this._status = java.util.Objects.requireNonNull(value, "status is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VersioningConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public VersioningConfigurationProperty build() {
                return new VersioningConfigurationProperty() {
                    private final java.lang.String $status = java.util.Objects.requireNonNull(_status, "status is required");

                    @Override
                    public java.lang.String getStatus() {
                        return this.$status;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("status", om.valueToTree(this.getStatus()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.VersioningConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.VersioningConfigurationProperty.Status`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html#cfn-s3-bucket-versioningconfig-status
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getStatus() {
                return this.jsiiGet("status", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WebsiteConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.WebsiteConfigurationProperty.ErrorDocument`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-errordocument
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getErrorDocument();
        /**
         * `CfnBucket.WebsiteConfigurationProperty.IndexDocument`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-indexdocument
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getIndexDocument();
        /**
         * `CfnBucket.WebsiteConfigurationProperty.RedirectAllRequestsTo`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-redirectallrequeststo
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getRedirectAllRequestsTo();
        /**
         * `CfnBucket.WebsiteConfigurationProperty.RoutingRules`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-routingrules
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getRoutingRules();

        /**
         * @return a {@link Builder} of {@link WebsiteConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link WebsiteConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _errorDocument;
            @javax.annotation.Nullable
            private java.lang.String _indexDocument;
            @javax.annotation.Nullable
            private java.lang.Object _redirectAllRequestsTo;
            @javax.annotation.Nullable
            private java.lang.Object _routingRules;

            /**
             * Sets the value of ErrorDocument
             * @param value `CfnBucket.WebsiteConfigurationProperty.ErrorDocument`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withErrorDocument(@javax.annotation.Nullable final java.lang.String value) {
                this._errorDocument = value;
                return this;
            }
            /**
             * Sets the value of IndexDocument
             * @param value `CfnBucket.WebsiteConfigurationProperty.IndexDocument`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withIndexDocument(@javax.annotation.Nullable final java.lang.String value) {
                this._indexDocument = value;
                return this;
            }
            /**
             * Sets the value of RedirectAllRequestsTo
             * @param value `CfnBucket.WebsiteConfigurationProperty.RedirectAllRequestsTo`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRedirectAllRequestsTo(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._redirectAllRequestsTo = value;
                return this;
            }
            /**
             * Sets the value of RedirectAllRequestsTo
             * @param value `CfnBucket.WebsiteConfigurationProperty.RedirectAllRequestsTo`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRedirectAllRequestsTo(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.RedirectAllRequestsToProperty value) {
                this._redirectAllRequestsTo = value;
                return this;
            }
            /**
             * Sets the value of RoutingRules
             * @param value `CfnBucket.WebsiteConfigurationProperty.RoutingRules`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRoutingRules(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._routingRules = value;
                return this;
            }
            /**
             * Sets the value of RoutingRules
             * @param value `CfnBucket.WebsiteConfigurationProperty.RoutingRules`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRoutingRules(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._routingRules = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WebsiteConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public WebsiteConfigurationProperty build() {
                return new WebsiteConfigurationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $errorDocument = _errorDocument;
                    @javax.annotation.Nullable
                    private final java.lang.String $indexDocument = _indexDocument;
                    @javax.annotation.Nullable
                    private final java.lang.Object $redirectAllRequestsTo = _redirectAllRequestsTo;
                    @javax.annotation.Nullable
                    private final java.lang.Object $routingRules = _routingRules;

                    @Override
                    public java.lang.String getErrorDocument() {
                        return this.$errorDocument;
                    }

                    @Override
                    public java.lang.String getIndexDocument() {
                        return this.$indexDocument;
                    }

                    @Override
                    public java.lang.Object getRedirectAllRequestsTo() {
                        return this.$redirectAllRequestsTo;
                    }

                    @Override
                    public java.lang.Object getRoutingRules() {
                        return this.$routingRules;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getErrorDocument() != null) {
                            obj.set("errorDocument", om.valueToTree(this.getErrorDocument()));
                        }
                        if (this.getIndexDocument() != null) {
                            obj.set("indexDocument", om.valueToTree(this.getIndexDocument()));
                        }
                        if (this.getRedirectAllRequestsTo() != null) {
                            obj.set("redirectAllRequestsTo", om.valueToTree(this.getRedirectAllRequestsTo()));
                        }
                        if (this.getRoutingRules() != null) {
                            obj.set("routingRules", om.valueToTree(this.getRoutingRules()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.WebsiteConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.WebsiteConfigurationProperty.ErrorDocument`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-errordocument
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getErrorDocument() {
                return this.jsiiGet("errorDocument", java.lang.String.class);
            }

            /**
             * `CfnBucket.WebsiteConfigurationProperty.IndexDocument`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-indexdocument
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getIndexDocument() {
                return this.jsiiGet("indexDocument", java.lang.String.class);
            }

            /**
             * `CfnBucket.WebsiteConfigurationProperty.RedirectAllRequestsTo`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-redirectallrequeststo
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getRedirectAllRequestsTo() {
                return this.jsiiGet("redirectAllRequestsTo", java.lang.Object.class);
            }

            /**
             * `CfnBucket.WebsiteConfigurationProperty.RoutingRules`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-routingrules
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getRoutingRules() {
                return this.jsiiGet("routingRules", java.lang.Object.class);
            }
        }
    }
}
