package software.amazon.awscdk.services.s3;

/**
 * Specifies a cross-origin access rule for an Amazon S3 bucket.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-11T14:13:08.345Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CorsRule extends software.amazon.jsii.JsiiSerializable {
    /**
     * An HTTP method that you allow the origin to execute.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.s3.HttpMethods> getAllowedMethods();
    /**
     * One or more origins you want customers to be able to access the bucket from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getAllowedOrigins();
    /**
     * Headers that are specified in the Access-Control-Request-Headers header.
     * 
     * Default: - No headers allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getAllowedHeaders();
    /**
     * One or more headers in the response that you want customers to be able to access from their applications.
     * 
     * Default: - No headers exposed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getExposedHeaders();
    /**
     * A unique identifier for this rule.
     * 
     * Default: - No id specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getId();
    /**
     * The time in seconds that your browser is to cache the preflight response for the specified resource.
     * 
     * Default: - No caching.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getMaxAge();

    /**
     * @return a {@link Builder} of {@link CorsRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CorsRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.util.List<software.amazon.awscdk.services.s3.HttpMethods> _allowedMethods;
        private java.util.List<java.lang.String> _allowedOrigins;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _allowedHeaders;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _exposedHeaders;
        @javax.annotation.Nullable
        private java.lang.String _id;
        @javax.annotation.Nullable
        private java.lang.Number _maxAge;

        /**
         * Sets the value of AllowedMethods
         * @param value An HTTP method that you allow the origin to execute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withAllowedMethods(final java.util.List<software.amazon.awscdk.services.s3.HttpMethods> value) {
            this._allowedMethods = java.util.Objects.requireNonNull(value, "allowedMethods is required");
            return this;
        }
        /**
         * Sets the value of AllowedOrigins
         * @param value One or more origins you want customers to be able to access the bucket from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withAllowedOrigins(final java.util.List<java.lang.String> value) {
            this._allowedOrigins = java.util.Objects.requireNonNull(value, "allowedOrigins is required");
            return this;
        }
        /**
         * Sets the value of AllowedHeaders
         * @param value Headers that are specified in the Access-Control-Request-Headers header.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withAllowedHeaders(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._allowedHeaders = value;
            return this;
        }
        /**
         * Sets the value of ExposedHeaders
         * @param value One or more headers in the response that you want customers to be able to access from their applications.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withExposedHeaders(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._exposedHeaders = value;
            return this;
        }
        /**
         * Sets the value of Id
         * @param value A unique identifier for this rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withId(@javax.annotation.Nullable final java.lang.String value) {
            this._id = value;
            return this;
        }
        /**
         * Sets the value of MaxAge
         * @param value The time in seconds that your browser is to cache the preflight response for the specified resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withMaxAge(@javax.annotation.Nullable final java.lang.Number value) {
            this._maxAge = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CorsRule}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public CorsRule build() {
            return new CorsRule() {
                private final java.util.List<software.amazon.awscdk.services.s3.HttpMethods> $allowedMethods = java.util.Objects.requireNonNull(_allowedMethods, "allowedMethods is required");
                private final java.util.List<java.lang.String> $allowedOrigins = java.util.Objects.requireNonNull(_allowedOrigins, "allowedOrigins is required");
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $allowedHeaders = _allowedHeaders;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $exposedHeaders = _exposedHeaders;
                @javax.annotation.Nullable
                private final java.lang.String $id = _id;
                @javax.annotation.Nullable
                private final java.lang.Number $maxAge = _maxAge;

                @Override
                public java.util.List<software.amazon.awscdk.services.s3.HttpMethods> getAllowedMethods() {
                    return this.$allowedMethods;
                }

                @Override
                public java.util.List<java.lang.String> getAllowedOrigins() {
                    return this.$allowedOrigins;
                }

                @Override
                public java.util.List<java.lang.String> getAllowedHeaders() {
                    return this.$allowedHeaders;
                }

                @Override
                public java.util.List<java.lang.String> getExposedHeaders() {
                    return this.$exposedHeaders;
                }

                @Override
                public java.lang.String getId() {
                    return this.$id;
                }

                @Override
                public java.lang.Number getMaxAge() {
                    return this.$maxAge;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("allowedMethods", om.valueToTree(this.getAllowedMethods()));
                    obj.set("allowedOrigins", om.valueToTree(this.getAllowedOrigins()));
                    if (this.getAllowedHeaders() != null) {
                        obj.set("allowedHeaders", om.valueToTree(this.getAllowedHeaders()));
                    }
                    if (this.getExposedHeaders() != null) {
                        obj.set("exposedHeaders", om.valueToTree(this.getExposedHeaders()));
                    }
                    if (this.getId() != null) {
                        obj.set("id", om.valueToTree(this.getId()));
                    }
                    if (this.getMaxAge() != null) {
                        obj.set("maxAge", om.valueToTree(this.getMaxAge()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CorsRule {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * An HTTP method that you allow the origin to execute.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.util.List<software.amazon.awscdk.services.s3.HttpMethods> getAllowedMethods() {
            return this.jsiiGet("allowedMethods", java.util.List.class);
        }

        /**
         * One or more origins you want customers to be able to access the bucket from.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.util.List<java.lang.String> getAllowedOrigins() {
            return this.jsiiGet("allowedOrigins", java.util.List.class);
        }

        /**
         * Headers that are specified in the Access-Control-Request-Headers header.
         * 
         * Default: - No headers allowed.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getAllowedHeaders() {
            return this.jsiiGet("allowedHeaders", java.util.List.class);
        }

        /**
         * One or more headers in the response that you want customers to be able to access from their applications.
         * 
         * Default: - No headers exposed.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getExposedHeaders() {
            return this.jsiiGet("exposedHeaders", java.util.List.class);
        }

        /**
         * A unique identifier for this rule.
         * 
         * Default: - No id specified.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getId() {
            return this.jsiiGet("id", java.lang.String.class);
        }

        /**
         * The time in seconds that your browser is to cache the preflight response for the specified resource.
         * 
         * Default: - No caching.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Number getMaxAge() {
            return this.jsiiGet("maxAge", java.lang.Number.class);
        }
    }
}
