package software.amazon.awscdk.services.s3;

/**
 * Options for the onCloudTrailPutObject method.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-11T14:13:08.351Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OnCloudTrailBucketEventOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.events.OnEventOptions {
    /**
     * Only watch changes to these object paths.
     * 
     * Default: - Watch changes to all objects
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getPaths();

    /**
     * @return a {@link Builder} of {@link OnCloudTrailBucketEventOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link OnCloudTrailBucketEventOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _paths;
        @javax.annotation.Nullable
        private java.lang.String _description;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.events.EventPattern _eventPattern;
        @javax.annotation.Nullable
        private java.lang.String _ruleName;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.events.IRuleTarget _target;

        /**
         * Sets the value of Paths
         * @param value Only watch changes to these object paths.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPaths(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._paths = value;
            return this;
        }
        /**
         * Sets the value of Description
         * @param value A description of the rule's purpose.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }
        /**
         * Sets the value of EventPattern
         * @param value Additional restrictions for the event to route to the specified target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withEventPattern(@javax.annotation.Nullable final software.amazon.awscdk.services.events.EventPattern value) {
            this._eventPattern = value;
            return this;
        }
        /**
         * Sets the value of RuleName
         * @param value A name for the rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withRuleName(@javax.annotation.Nullable final java.lang.String value) {
            this._ruleName = value;
            return this;
        }
        /**
         * Sets the value of Target
         * @param value The target to register for the event.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withTarget(@javax.annotation.Nullable final software.amazon.awscdk.services.events.IRuleTarget value) {
            this._target = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OnCloudTrailBucketEventOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public OnCloudTrailBucketEventOptions build() {
            return new OnCloudTrailBucketEventOptions() {
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $paths = _paths;
                @javax.annotation.Nullable
                private final java.lang.String $description = _description;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.events.EventPattern $eventPattern = _eventPattern;
                @javax.annotation.Nullable
                private final java.lang.String $ruleName = _ruleName;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.events.IRuleTarget $target = _target;

                @Override
                public java.util.List<java.lang.String> getPaths() {
                    return this.$paths;
                }

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                @Override
                public software.amazon.awscdk.services.events.EventPattern getEventPattern() {
                    return this.$eventPattern;
                }

                @Override
                public java.lang.String getRuleName() {
                    return this.$ruleName;
                }

                @Override
                public software.amazon.awscdk.services.events.IRuleTarget getTarget() {
                    return this.$target;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getPaths() != null) {
                        obj.set("paths", om.valueToTree(this.getPaths()));
                    }
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree(this.getDescription()));
                    }
                    if (this.getEventPattern() != null) {
                        obj.set("eventPattern", om.valueToTree(this.getEventPattern()));
                    }
                    if (this.getRuleName() != null) {
                        obj.set("ruleName", om.valueToTree(this.getRuleName()));
                    }
                    if (this.getTarget() != null) {
                        obj.set("target", om.valueToTree(this.getTarget()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.OnCloudTrailBucketEventOptions {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Only watch changes to these object paths.
         * 
         * Default: - Watch changes to all objects
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getPaths() {
            return this.jsiiGet("paths", java.util.List.class);
        }

        /**
         * A description of the rule's purpose.
         * 
         * Default: - No description
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * Additional restrictions for the event to route to the specified target.
         * 
         * The method that generates the rule probably imposes some type of event
         * filtering. The filtering implied by what you pass here is added
         * on top of that filtering.
         * 
         * Default: - No additional filtering based on an event pattern.
         * 
         * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CloudWatchEventsandEventPatterns.html
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.events.EventPattern getEventPattern() {
            return this.jsiiGet("eventPattern", software.amazon.awscdk.services.events.EventPattern.class);
        }

        /**
         * A name for the rule.
         * 
         * Default: AWS CloudFormation generates a unique physical ID.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getRuleName() {
            return this.jsiiGet("ruleName", java.lang.String.class);
        }

        /**
         * The target to register for the event.
         * 
         * Default: - No target is added to the rule. Use `addTarget()` to add a target.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.events.IRuleTarget getTarget() {
            return this.jsiiGet("target", software.amazon.awscdk.services.events.IRuleTarget.class);
        }
    }
}
