package software.amazon.awscdk.services.s3;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.2 (build e881f16)", date = "2019-07-19T19:06:34.121Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BlockPublicAccessOptions extends software.amazon.jsii.JsiiSerializable {
    /**
     * Whether to block public ACLs.
     * 
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getBlockPublicAcls();
    /**
     * Whether to block public policy.
     * 
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getBlockPublicPolicy();
    /**
     * Whether to ignore public ACLs.
     * 
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getIgnorePublicAcls();
    /**
     * Whether to restrict public access.
     * 
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getRestrictPublicBuckets();

    /**
     * @return a {@link Builder} of {@link BlockPublicAccessOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link BlockPublicAccessOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.Boolean _blockPublicAcls;
        @javax.annotation.Nullable
        private java.lang.Boolean _blockPublicPolicy;
        @javax.annotation.Nullable
        private java.lang.Boolean _ignorePublicAcls;
        @javax.annotation.Nullable
        private java.lang.Boolean _restrictPublicBuckets;

        /**
         * Sets the value of BlockPublicAcls
         * @param value Whether to block public ACLs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withBlockPublicAcls(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._blockPublicAcls = value;
            return this;
        }
        /**
         * Sets the value of BlockPublicPolicy
         * @param value Whether to block public policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withBlockPublicPolicy(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._blockPublicPolicy = value;
            return this;
        }
        /**
         * Sets the value of IgnorePublicAcls
         * @param value Whether to ignore public ACLs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withIgnorePublicAcls(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._ignorePublicAcls = value;
            return this;
        }
        /**
         * Sets the value of RestrictPublicBuckets
         * @param value Whether to restrict public access.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withRestrictPublicBuckets(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._restrictPublicBuckets = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BlockPublicAccessOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public BlockPublicAccessOptions build() {
            return new BlockPublicAccessOptions() {
                @javax.annotation.Nullable
                private final java.lang.Boolean $blockPublicAcls = _blockPublicAcls;
                @javax.annotation.Nullable
                private final java.lang.Boolean $blockPublicPolicy = _blockPublicPolicy;
                @javax.annotation.Nullable
                private final java.lang.Boolean $ignorePublicAcls = _ignorePublicAcls;
                @javax.annotation.Nullable
                private final java.lang.Boolean $restrictPublicBuckets = _restrictPublicBuckets;

                @Override
                public java.lang.Boolean getBlockPublicAcls() {
                    return this.$blockPublicAcls;
                }

                @Override
                public java.lang.Boolean getBlockPublicPolicy() {
                    return this.$blockPublicPolicy;
                }

                @Override
                public java.lang.Boolean getIgnorePublicAcls() {
                    return this.$ignorePublicAcls;
                }

                @Override
                public java.lang.Boolean getRestrictPublicBuckets() {
                    return this.$restrictPublicBuckets;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getBlockPublicAcls() != null) {
                        obj.set("blockPublicAcls", om.valueToTree(this.getBlockPublicAcls()));
                    }
                    if (this.getBlockPublicPolicy() != null) {
                        obj.set("blockPublicPolicy", om.valueToTree(this.getBlockPublicPolicy()));
                    }
                    if (this.getIgnorePublicAcls() != null) {
                        obj.set("ignorePublicAcls", om.valueToTree(this.getIgnorePublicAcls()));
                    }
                    if (this.getRestrictPublicBuckets() != null) {
                        obj.set("restrictPublicBuckets", om.valueToTree(this.getRestrictPublicBuckets()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.BlockPublicAccessOptions {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Whether to block public ACLs.
         * 
         * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-options
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getBlockPublicAcls() {
            return this.jsiiGet("blockPublicAcls", java.lang.Boolean.class);
        }

        /**
         * Whether to block public policy.
         * 
         * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-options
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getBlockPublicPolicy() {
            return this.jsiiGet("blockPublicPolicy", java.lang.Boolean.class);
        }

        /**
         * Whether to ignore public ACLs.
         * 
         * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-options
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getIgnorePublicAcls() {
            return this.jsiiGet("ignorePublicAcls", java.lang.Boolean.class);
        }

        /**
         * Whether to restrict public access.
         * 
         * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-options
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getRestrictPublicBuckets() {
            return this.jsiiGet("restrictPublicBuckets", java.lang.Boolean.class);
        }
    }
}
