package software.amazon.awscdk.services.s3;

/**
 * Describes when noncurrent versions transition to a specified storage class.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.2 (build e881f16)", date = "2019-07-19T19:06:34.166Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NoncurrentVersionTransition extends software.amazon.jsii.JsiiSerializable {
    /**
     * The storage class to which you want the object to transition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.s3.StorageClass getStorageClass();
    /**
     * Indicates the number of days after creation when objects are transitioned to the specified storage class.
     * 
     * Default: No transition count.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.Duration getTransitionAfter();

    /**
     * @return a {@link Builder} of {@link NoncurrentVersionTransition}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link NoncurrentVersionTransition}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.services.s3.StorageClass _storageClass;
        private software.amazon.awscdk.core.Duration _transitionAfter;

        /**
         * Sets the value of StorageClass
         * @param value The storage class to which you want the object to transition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withStorageClass(final software.amazon.awscdk.services.s3.StorageClass value) {
            this._storageClass = java.util.Objects.requireNonNull(value, "storageClass is required");
            return this;
        }
        /**
         * Sets the value of TransitionAfter
         * @param value Indicates the number of days after creation when objects are transitioned to the specified storage class.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withTransitionAfter(final software.amazon.awscdk.core.Duration value) {
            this._transitionAfter = java.util.Objects.requireNonNull(value, "transitionAfter is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NoncurrentVersionTransition}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public NoncurrentVersionTransition build() {
            return new NoncurrentVersionTransition() {
                private final software.amazon.awscdk.services.s3.StorageClass $storageClass = java.util.Objects.requireNonNull(_storageClass, "storageClass is required");
                private final software.amazon.awscdk.core.Duration $transitionAfter = java.util.Objects.requireNonNull(_transitionAfter, "transitionAfter is required");

                @Override
                public software.amazon.awscdk.services.s3.StorageClass getStorageClass() {
                    return this.$storageClass;
                }

                @Override
                public software.amazon.awscdk.core.Duration getTransitionAfter() {
                    return this.$transitionAfter;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("storageClass", om.valueToTree(this.getStorageClass()));
                    obj.set("transitionAfter", om.valueToTree(this.getTransitionAfter()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.NoncurrentVersionTransition {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The storage class to which you want the object to transition.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.s3.StorageClass getStorageClass() {
            return this.jsiiGet("storageClass", software.amazon.awscdk.services.s3.StorageClass.class);
        }

        /**
         * Indicates the number of days after creation when objects are transitioned to the specified storage class.
         * 
         * Default: No transition count.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.core.Duration getTransitionAfter() {
            return this.jsiiGet("transitionAfter", software.amazon.awscdk.core.Duration.class);
        }
    }
}
