package software.amazon.awscdk.services.s3;

/**
 * Default bucket access control types.
 * 
 * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.1 (build f4a0dbe)", date = "2019-10-02T18:23:58.921Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.BucketAccessControl")
public enum BucketAccessControl {
    /**
     * Owner gets FULL_CONTROL.
     * 
     * No one else has access rights.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PRIVATE,
    /**
     * Owner gets FULL_CONTROL.
     * 
     * The AllUsers group gets READ access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PUBLIC_READ,
    /**
     * Owner gets FULL_CONTROL.
     * 
     * The AllUsers group gets READ and WRITE access.
     * Granting this on a bucket is generally not recommended.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PUBLIC_READ_WRITE,
    /**
     * Owner gets FULL_CONTROL.
     * 
     * The AuthenticatedUsers group gets READ access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AUTHENTICATED_READ,
    /**
     * The LogDelivery group gets WRITE and READ_ACP permissions on the bucket.
     * 
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerLogs.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LOG_DELIVERY_WRITE,
    /**
     * Object owner gets FULL_CONTROL.
     * 
     * Bucket owner gets READ access.
     * If you specify this canned ACL when creating a bucket, Amazon S3 ignores it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BUCKET_OWNER_READ,
    /**
     * Both the object owner and the bucket owner get FULL_CONTROL over the object. If you specify this canned ACL when creating a bucket, Amazon S3 ignores it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BUCKET_OWNER_FULL_CONTROL,
    /**
     * Owner gets FULL_CONTROL.
     * 
     * Amazon EC2 gets READ access to GET an Amazon Machine Image (AMI) bundle from Amazon S3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AWS_EXEC_READ,
}
