package software.amazon.awscdk.services.s3;

/**
 * Declaration of a Life cycle rule.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-08-05T11:20:48.587Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.LifecycleRule")
@software.amazon.jsii.Jsii.Proxy(LifecycleRule.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LifecycleRule extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies a lifecycle rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
     * <p>
     * The AbortIncompleteMultipartUpload property type creates a lifecycle
     * rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
     * When Amazon S3 aborts a multipart upload, it deletes all parts
     * associated with the multipart upload.
     * <p>
     * Default: Incomplete uploads are never aborted
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getAbortIncompleteMultipartUploadAfter() {
        return null;
    }

    /**
     * Whether this rule is enabled.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnabled() {
        return null;
    }

    /**
     * Indicates the number of days after creation when objects are deleted from Amazon S3 and Amazon Glacier.
     * <p>
     * If you specify an expiration and transition time, you must use the same
     * time unit for both properties (either in days or by date). The
     * expiration time must also be later than the transition time.
     * <p>
     * Default: No expiration timeout
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getExpiration() {
        return null;
    }

    /**
     * Indicates when objects are deleted from Amazon S3 and Amazon Glacier.
     * <p>
     * The date value must be in ISO 8601 format. The time is always midnight UTC.
     * <p>
     * If you specify an expiration and transition time, you must use the same
     * time unit for both properties (either in days or by date). The
     * expiration time must also be later than the transition time.
     * <p>
     * Default: No expiration date
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.time.Instant getExpirationDate() {
        return null;
    }

    /**
     * Indicates whether Amazon S3 will remove a delete marker with no noncurrent versions.
     * <p>
     * If set to true, the delete marker will be expired.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getExpiredObjectDeleteMarker() {
        return null;
    }

    /**
     * A unique identifier for this rule.
     * <p>
     * The value cannot be more than 255 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getId() {
        return null;
    }

    /**
     * Time between when a new version of the object is uploaded to the bucket and when old versions of the object expire.
     * <p>
     * For buckets with versioning enabled (or suspended), specifies the time,
     * in days, between when a new version of the object is uploaded to the
     * bucket and when old versions of the object expire. When object versions
     * expire, Amazon S3 permanently deletes them. If you specify a transition
     * and expiration time, the expiration time must be later than the
     * transition time.
     * <p>
     * Default: No noncurrent version expiration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getNoncurrentVersionExpiration() {
        return null;
    }

    /**
     * One or more transition rules that specify when non-current objects transition to a specified storage class.
     * <p>
     * Only for for buckets with versioning enabled (or suspended).
     * <p>
     * If you specify a transition and expiration time, the expiration time
     * must be later than the transition time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.s3.NoncurrentVersionTransition> getNoncurrentVersionTransitions() {
        return null;
    }

    /**
     * Object key prefix that identifies one or more objects to which this rule applies.
     * <p>
     * Default: Rule applies to all objects
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
        return null;
    }

    /**
     * The TagFilter property type specifies tags to use to identify a subset of objects for an Amazon S3 bucket.
     * <p>
     * Default: Rule applies to all objects
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getTagFilters() {
        return null;
    }

    /**
     * One or more transition rules that specify when an object transitions to a specified storage class.
     * <p>
     * If you specify an expiration and transition time, you must use the same
     * time unit for both properties (either in days or by date). The
     * expiration time must also be later than the transition time.
     * <p>
     * Default: No transition rules
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.s3.Transition> getTransitions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LifecycleRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LifecycleRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LifecycleRule> {
        private software.amazon.awscdk.core.Duration abortIncompleteMultipartUploadAfter;
        private java.lang.Boolean enabled;
        private software.amazon.awscdk.core.Duration expiration;
        private java.time.Instant expirationDate;
        private java.lang.Boolean expiredObjectDeleteMarker;
        private java.lang.String id;
        private software.amazon.awscdk.core.Duration noncurrentVersionExpiration;
        private java.util.List<software.amazon.awscdk.services.s3.NoncurrentVersionTransition> noncurrentVersionTransitions;
        private java.lang.String prefix;
        private java.util.Map<java.lang.String, java.lang.Object> tagFilters;
        private java.util.List<software.amazon.awscdk.services.s3.Transition> transitions;

        /**
         * Sets the value of {@link LifecycleRule#getAbortIncompleteMultipartUploadAfter}
         * @param abortIncompleteMultipartUploadAfter Specifies a lifecycle rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
         *                                            The AbortIncompleteMultipartUpload property type creates a lifecycle
         *                                            rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
         *                                            When Amazon S3 aborts a multipart upload, it deletes all parts
         *                                            associated with the multipart upload.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder abortIncompleteMultipartUploadAfter(software.amazon.awscdk.core.Duration abortIncompleteMultipartUploadAfter) {
            this.abortIncompleteMultipartUploadAfter = abortIncompleteMultipartUploadAfter;
            return this;
        }

        /**
         * Sets the value of {@link LifecycleRule#getEnabled}
         * @param enabled Whether this rule is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link LifecycleRule#getExpiration}
         * @param expiration Indicates the number of days after creation when objects are deleted from Amazon S3 and Amazon Glacier.
         *                   If you specify an expiration and transition time, you must use the same
         *                   time unit for both properties (either in days or by date). The
         *                   expiration time must also be later than the transition time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder expiration(software.amazon.awscdk.core.Duration expiration) {
            this.expiration = expiration;
            return this;
        }

        /**
         * Sets the value of {@link LifecycleRule#getExpirationDate}
         * @param expirationDate Indicates when objects are deleted from Amazon S3 and Amazon Glacier.
         *                       The date value must be in ISO 8601 format. The time is always midnight UTC.
         *                       <p>
         *                       If you specify an expiration and transition time, you must use the same
         *                       time unit for both properties (either in days or by date). The
         *                       expiration time must also be later than the transition time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder expirationDate(java.time.Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        /**
         * Sets the value of {@link LifecycleRule#getExpiredObjectDeleteMarker}
         * @param expiredObjectDeleteMarker Indicates whether Amazon S3 will remove a delete marker with no noncurrent versions.
         *                                  If set to true, the delete marker will be expired.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder expiredObjectDeleteMarker(java.lang.Boolean expiredObjectDeleteMarker) {
            this.expiredObjectDeleteMarker = expiredObjectDeleteMarker;
            return this;
        }

        /**
         * Sets the value of {@link LifecycleRule#getId}
         * @param id A unique identifier for this rule.
         *           The value cannot be more than 255 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder id(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the value of {@link LifecycleRule#getNoncurrentVersionExpiration}
         * @param noncurrentVersionExpiration Time between when a new version of the object is uploaded to the bucket and when old versions of the object expire.
         *                                    For buckets with versioning enabled (or suspended), specifies the time,
         *                                    in days, between when a new version of the object is uploaded to the
         *                                    bucket and when old versions of the object expire. When object versions
         *                                    expire, Amazon S3 permanently deletes them. If you specify a transition
         *                                    and expiration time, the expiration time must be later than the
         *                                    transition time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder noncurrentVersionExpiration(software.amazon.awscdk.core.Duration noncurrentVersionExpiration) {
            this.noncurrentVersionExpiration = noncurrentVersionExpiration;
            return this;
        }

        /**
         * Sets the value of {@link LifecycleRule#getNoncurrentVersionTransitions}
         * @param noncurrentVersionTransitions One or more transition rules that specify when non-current objects transition to a specified storage class.
         *                                     Only for for buckets with versioning enabled (or suspended).
         *                                     <p>
         *                                     If you specify a transition and expiration time, the expiration time
         *                                     must be later than the transition time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder noncurrentVersionTransitions(java.util.List<? extends software.amazon.awscdk.services.s3.NoncurrentVersionTransition> noncurrentVersionTransitions) {
            this.noncurrentVersionTransitions = (java.util.List<software.amazon.awscdk.services.s3.NoncurrentVersionTransition>)noncurrentVersionTransitions;
            return this;
        }

        /**
         * Sets the value of {@link LifecycleRule#getPrefix}
         * @param prefix Object key prefix that identifies one or more objects to which this rule applies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prefix(java.lang.String prefix) {
            this.prefix = prefix;
            return this;
        }

        /**
         * Sets the value of {@link LifecycleRule#getTagFilters}
         * @param tagFilters The TagFilter property type specifies tags to use to identify a subset of objects for an Amazon S3 bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tagFilters(java.util.Map<java.lang.String, ? extends java.lang.Object> tagFilters) {
            this.tagFilters = (java.util.Map<java.lang.String, java.lang.Object>)tagFilters;
            return this;
        }

        /**
         * Sets the value of {@link LifecycleRule#getTransitions}
         * @param transitions One or more transition rules that specify when an object transitions to a specified storage class.
         *                    If you specify an expiration and transition time, you must use the same
         *                    time unit for both properties (either in days or by date). The
         *                    expiration time must also be later than the transition time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder transitions(java.util.List<? extends software.amazon.awscdk.services.s3.Transition> transitions) {
            this.transitions = (java.util.List<software.amazon.awscdk.services.s3.Transition>)transitions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LifecycleRule}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LifecycleRule build() {
            return new Jsii$Proxy(abortIncompleteMultipartUploadAfter, enabled, expiration, expirationDate, expiredObjectDeleteMarker, id, noncurrentVersionExpiration, noncurrentVersionTransitions, prefix, tagFilters, transitions);
        }
    }

    /**
     * An implementation for {@link LifecycleRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LifecycleRule {
        private final software.amazon.awscdk.core.Duration abortIncompleteMultipartUploadAfter;
        private final java.lang.Boolean enabled;
        private final software.amazon.awscdk.core.Duration expiration;
        private final java.time.Instant expirationDate;
        private final java.lang.Boolean expiredObjectDeleteMarker;
        private final java.lang.String id;
        private final software.amazon.awscdk.core.Duration noncurrentVersionExpiration;
        private final java.util.List<software.amazon.awscdk.services.s3.NoncurrentVersionTransition> noncurrentVersionTransitions;
        private final java.lang.String prefix;
        private final java.util.Map<java.lang.String, java.lang.Object> tagFilters;
        private final java.util.List<software.amazon.awscdk.services.s3.Transition> transitions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.abortIncompleteMultipartUploadAfter = software.amazon.jsii.Kernel.get(this, "abortIncompleteMultipartUploadAfter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.expiration = software.amazon.jsii.Kernel.get(this, "expiration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.expirationDate = software.amazon.jsii.Kernel.get(this, "expirationDate", software.amazon.jsii.NativeType.forClass(java.time.Instant.class));
            this.expiredObjectDeleteMarker = software.amazon.jsii.Kernel.get(this, "expiredObjectDeleteMarker", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.noncurrentVersionExpiration = software.amazon.jsii.Kernel.get(this, "noncurrentVersionExpiration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.noncurrentVersionTransitions = software.amazon.jsii.Kernel.get(this, "noncurrentVersionTransitions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.NoncurrentVersionTransition.class)));
            this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tagFilters = software.amazon.jsii.Kernel.get(this, "tagFilters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.transitions = software.amazon.jsii.Kernel.get(this, "transitions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.Transition.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final software.amazon.awscdk.core.Duration abortIncompleteMultipartUploadAfter, final java.lang.Boolean enabled, final software.amazon.awscdk.core.Duration expiration, final java.time.Instant expirationDate, final java.lang.Boolean expiredObjectDeleteMarker, final java.lang.String id, final software.amazon.awscdk.core.Duration noncurrentVersionExpiration, final java.util.List<? extends software.amazon.awscdk.services.s3.NoncurrentVersionTransition> noncurrentVersionTransitions, final java.lang.String prefix, final java.util.Map<java.lang.String, ? extends java.lang.Object> tagFilters, final java.util.List<? extends software.amazon.awscdk.services.s3.Transition> transitions) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.abortIncompleteMultipartUploadAfter = abortIncompleteMultipartUploadAfter;
            this.enabled = enabled;
            this.expiration = expiration;
            this.expirationDate = expirationDate;
            this.expiredObjectDeleteMarker = expiredObjectDeleteMarker;
            this.id = id;
            this.noncurrentVersionExpiration = noncurrentVersionExpiration;
            this.noncurrentVersionTransitions = (java.util.List<software.amazon.awscdk.services.s3.NoncurrentVersionTransition>)noncurrentVersionTransitions;
            this.prefix = prefix;
            this.tagFilters = (java.util.Map<java.lang.String, java.lang.Object>)tagFilters;
            this.transitions = (java.util.List<software.amazon.awscdk.services.s3.Transition>)transitions;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getAbortIncompleteMultipartUploadAfter() {
            return this.abortIncompleteMultipartUploadAfter;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getExpiration() {
            return this.expiration;
        }

        @Override
        public final java.time.Instant getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        public final java.lang.Boolean getExpiredObjectDeleteMarker() {
            return this.expiredObjectDeleteMarker;
        }

        @Override
        public final java.lang.String getId() {
            return this.id;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getNoncurrentVersionExpiration() {
            return this.noncurrentVersionExpiration;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.s3.NoncurrentVersionTransition> getNoncurrentVersionTransitions() {
            return this.noncurrentVersionTransitions;
        }

        @Override
        public final java.lang.String getPrefix() {
            return this.prefix;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getTagFilters() {
            return this.tagFilters;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.s3.Transition> getTransitions() {
            return this.transitions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAbortIncompleteMultipartUploadAfter() != null) {
                data.set("abortIncompleteMultipartUploadAfter", om.valueToTree(this.getAbortIncompleteMultipartUploadAfter()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getExpiration() != null) {
                data.set("expiration", om.valueToTree(this.getExpiration()));
            }
            if (this.getExpirationDate() != null) {
                data.set("expirationDate", om.valueToTree(this.getExpirationDate()));
            }
            if (this.getExpiredObjectDeleteMarker() != null) {
                data.set("expiredObjectDeleteMarker", om.valueToTree(this.getExpiredObjectDeleteMarker()));
            }
            if (this.getId() != null) {
                data.set("id", om.valueToTree(this.getId()));
            }
            if (this.getNoncurrentVersionExpiration() != null) {
                data.set("noncurrentVersionExpiration", om.valueToTree(this.getNoncurrentVersionExpiration()));
            }
            if (this.getNoncurrentVersionTransitions() != null) {
                data.set("noncurrentVersionTransitions", om.valueToTree(this.getNoncurrentVersionTransitions()));
            }
            if (this.getPrefix() != null) {
                data.set("prefix", om.valueToTree(this.getPrefix()));
            }
            if (this.getTagFilters() != null) {
                data.set("tagFilters", om.valueToTree(this.getTagFilters()));
            }
            if (this.getTransitions() != null) {
                data.set("transitions", om.valueToTree(this.getTransitions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.LifecycleRule"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LifecycleRule.Jsii$Proxy that = (LifecycleRule.Jsii$Proxy) o;

            if (this.abortIncompleteMultipartUploadAfter != null ? !this.abortIncompleteMultipartUploadAfter.equals(that.abortIncompleteMultipartUploadAfter) : that.abortIncompleteMultipartUploadAfter != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.expiration != null ? !this.expiration.equals(that.expiration) : that.expiration != null) return false;
            if (this.expirationDate != null ? !this.expirationDate.equals(that.expirationDate) : that.expirationDate != null) return false;
            if (this.expiredObjectDeleteMarker != null ? !this.expiredObjectDeleteMarker.equals(that.expiredObjectDeleteMarker) : that.expiredObjectDeleteMarker != null) return false;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
            if (this.noncurrentVersionExpiration != null ? !this.noncurrentVersionExpiration.equals(that.noncurrentVersionExpiration) : that.noncurrentVersionExpiration != null) return false;
            if (this.noncurrentVersionTransitions != null ? !this.noncurrentVersionTransitions.equals(that.noncurrentVersionTransitions) : that.noncurrentVersionTransitions != null) return false;
            if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
            if (this.tagFilters != null ? !this.tagFilters.equals(that.tagFilters) : that.tagFilters != null) return false;
            return this.transitions != null ? this.transitions.equals(that.transitions) : that.transitions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.abortIncompleteMultipartUploadAfter != null ? this.abortIncompleteMultipartUploadAfter.hashCode() : 0;
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.expiration != null ? this.expiration.hashCode() : 0);
            result = 31 * result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            result = 31 * result + (this.expiredObjectDeleteMarker != null ? this.expiredObjectDeleteMarker.hashCode() : 0);
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.noncurrentVersionExpiration != null ? this.noncurrentVersionExpiration.hashCode() : 0);
            result = 31 * result + (this.noncurrentVersionTransitions != null ? this.noncurrentVersionTransitions.hashCode() : 0);
            result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
            result = 31 * result + (this.tagFilters != null ? this.tagFilters.hashCode() : 0);
            result = 31 * result + (this.transitions != null ? this.transitions.hashCode() : 0);
            return result;
        }
    }
}
