package software.amazon.awscdk.services.s3;

/**
 * Specifies a cross-origin access rule for an Amazon S3 bucket.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.18.0 (build f29d29c)", date = "2019-10-07T15:39:30.630Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CorsRule extends software.amazon.jsii.JsiiSerializable {

    /**
     * An HTTP method that you allow the origin to execute.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.s3.HttpMethods> getAllowedMethods();

    /**
     * One or more origins you want customers to be able to access the bucket from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getAllowedOrigins();

    /**
     * Headers that are specified in the Access-Control-Request-Headers header.
     * 
     * Default: - No headers allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getAllowedHeaders();

    /**
     * One or more headers in the response that you want customers to be able to access from their applications.
     * 
     * Default: - No headers exposed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getExposedHeaders();

    /**
     * A unique identifier for this rule.
     * 
     * Default: - No id specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getId();

    /**
     * The time in seconds that your browser is to cache the preflight response for the specified resource.
     * 
     * Default: - No caching.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getMaxAge();

    /**
     * @return a {@link Builder} of {@link CorsRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CorsRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.util.List<software.amazon.awscdk.services.s3.HttpMethods> allowedMethods;
        private java.util.List<java.lang.String> allowedOrigins;
        private java.util.List<java.lang.String> allowedHeaders;
        private java.util.List<java.lang.String> exposedHeaders;
        private java.lang.String id;
        private java.lang.Number maxAge;

        /**
         * Sets the value of AllowedMethods
         * @param allowedMethods An HTTP method that you allow the origin to execute. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedMethods(java.util.List<software.amazon.awscdk.services.s3.HttpMethods> allowedMethods) {
            this.allowedMethods = allowedMethods;
            return this;
        }

        /**
         * Sets the value of AllowedOrigins
         * @param allowedOrigins One or more origins you want customers to be able to access the bucket from. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedOrigins(java.util.List<java.lang.String> allowedOrigins) {
            this.allowedOrigins = allowedOrigins;
            return this;
        }

        /**
         * Sets the value of AllowedHeaders
         * @param allowedHeaders Headers that are specified in the Access-Control-Request-Headers header.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedHeaders(java.util.List<java.lang.String> allowedHeaders) {
            this.allowedHeaders = allowedHeaders;
            return this;
        }

        /**
         * Sets the value of ExposedHeaders
         * @param exposedHeaders One or more headers in the response that you want customers to be able to access from their applications.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exposedHeaders(java.util.List<java.lang.String> exposedHeaders) {
            this.exposedHeaders = exposedHeaders;
            return this;
        }

        /**
         * Sets the value of Id
         * @param id A unique identifier for this rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder id(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the value of MaxAge
         * @param maxAge The time in seconds that your browser is to cache the preflight response for the specified resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAge(java.lang.Number maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CorsRule}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public CorsRule build() {
            return new Jsii$Proxy(allowedMethods, allowedOrigins, allowedHeaders, exposedHeaders, id, maxAge);
        }
    }

    /**
     * An implementation for {@link CorsRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CorsRule {
        private final java.util.List<software.amazon.awscdk.services.s3.HttpMethods> allowedMethods;
        private final java.util.List<java.lang.String> allowedOrigins;
        private final java.util.List<java.lang.String> allowedHeaders;
        private final java.util.List<java.lang.String> exposedHeaders;
        private final java.lang.String id;
        private final java.lang.Number maxAge;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.allowedMethods = this.jsiiGet("allowedMethods", java.util.List.class);
            this.allowedOrigins = this.jsiiGet("allowedOrigins", java.util.List.class);
            this.allowedHeaders = this.jsiiGet("allowedHeaders", java.util.List.class);
            this.exposedHeaders = this.jsiiGet("exposedHeaders", java.util.List.class);
            this.id = this.jsiiGet("id", java.lang.String.class);
            this.maxAge = this.jsiiGet("maxAge", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.util.List<software.amazon.awscdk.services.s3.HttpMethods> allowedMethods, java.util.List<java.lang.String> allowedOrigins, java.util.List<java.lang.String> allowedHeaders, java.util.List<java.lang.String> exposedHeaders, java.lang.String id, java.lang.Number maxAge) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowedMethods = java.util.Objects.requireNonNull(allowedMethods, "allowedMethods is required");
            this.allowedOrigins = java.util.Objects.requireNonNull(allowedOrigins, "allowedOrigins is required");
            this.allowedHeaders = allowedHeaders;
            this.exposedHeaders = exposedHeaders;
            this.id = id;
            this.maxAge = maxAge;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.s3.HttpMethods> getAllowedMethods() {
            return this.allowedMethods;
        }

        @Override
        public java.util.List<java.lang.String> getAllowedOrigins() {
            return this.allowedOrigins;
        }

        @Override
        public java.util.List<java.lang.String> getAllowedHeaders() {
            return this.allowedHeaders;
        }

        @Override
        public java.util.List<java.lang.String> getExposedHeaders() {
            return this.exposedHeaders;
        }

        @Override
        public java.lang.String getId() {
            return this.id;
        }

        @Override
        public java.lang.Number getMaxAge() {
            return this.maxAge;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("allowedMethods", om.valueToTree(this.getAllowedMethods()));
            obj.set("allowedOrigins", om.valueToTree(this.getAllowedOrigins()));
            if (this.getAllowedHeaders() != null) {
                obj.set("allowedHeaders", om.valueToTree(this.getAllowedHeaders()));
            }
            if (this.getExposedHeaders() != null) {
                obj.set("exposedHeaders", om.valueToTree(this.getExposedHeaders()));
            }
            if (this.getId() != null) {
                obj.set("id", om.valueToTree(this.getId()));
            }
            if (this.getMaxAge() != null) {
                obj.set("maxAge", om.valueToTree(this.getMaxAge()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CorsRule.Jsii$Proxy that = (CorsRule.Jsii$Proxy) o;

            if (!allowedMethods.equals(that.allowedMethods)) return false;
            if (!allowedOrigins.equals(that.allowedOrigins)) return false;
            if (this.allowedHeaders != null ? !this.allowedHeaders.equals(that.allowedHeaders) : that.allowedHeaders != null) return false;
            if (this.exposedHeaders != null ? !this.exposedHeaders.equals(that.exposedHeaders) : that.exposedHeaders != null) return false;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
            return this.maxAge != null ? this.maxAge.equals(that.maxAge) : that.maxAge == null;
        }

        @Override
        public int hashCode() {
            int result = this.allowedMethods.hashCode();
            result = 31 * result + (this.allowedOrigins.hashCode());
            result = 31 * result + (this.allowedHeaders != null ? this.allowedHeaders.hashCode() : 0);
            result = 31 * result + (this.exposedHeaders != null ? this.exposedHeaders.hashCode() : 0);
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.maxAge != null ? this.maxAge.hashCode() : 0);
            return result;
        }
    }
}
