package software.amazon.awscdk.services.s3;

/**
 * Specifies a redirect behavior of all requests to a website endpoint of a bucket.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.18.0 (build f29d29c)", date = "2019-10-07T15:39:30.647Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RedirectTarget extends software.amazon.jsii.JsiiSerializable {

    /**
     * Name of the host where requests are redirected.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getHostName();

    /**
     * Protocol to use when redirecting requests.
     * 
     * Default: - The protocol used in the original request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.s3.RedirectProtocol getProtocol();

    /**
     * @return a {@link Builder} of {@link RedirectTarget}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RedirectTarget}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String hostName;
        private software.amazon.awscdk.services.s3.RedirectProtocol protocol;

        /**
         * Sets the value of HostName
         * @param hostName Name of the host where requests are redirected. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostName(java.lang.String hostName) {
            this.hostName = hostName;
            return this;
        }

        /**
         * Sets the value of Protocol
         * @param protocol Protocol to use when redirecting requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(software.amazon.awscdk.services.s3.RedirectProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RedirectTarget}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public RedirectTarget build() {
            return new Jsii$Proxy(hostName, protocol);
        }
    }

    /**
     * An implementation for {@link RedirectTarget}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedirectTarget {
        private final java.lang.String hostName;
        private final software.amazon.awscdk.services.s3.RedirectProtocol protocol;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.hostName = this.jsiiGet("hostName", java.lang.String.class);
            this.protocol = this.jsiiGet("protocol", software.amazon.awscdk.services.s3.RedirectProtocol.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String hostName, software.amazon.awscdk.services.s3.RedirectProtocol protocol) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.hostName = java.util.Objects.requireNonNull(hostName, "hostName is required");
            this.protocol = protocol;
        }

        @Override
        public java.lang.String getHostName() {
            return this.hostName;
        }

        @Override
        public software.amazon.awscdk.services.s3.RedirectProtocol getProtocol() {
            return this.protocol;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("hostName", om.valueToTree(this.getHostName()));
            if (this.getProtocol() != null) {
                obj.set("protocol", om.valueToTree(this.getProtocol()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RedirectTarget.Jsii$Proxy that = (RedirectTarget.Jsii$Proxy) o;

            if (!hostName.equals(that.hostName)) return false;
            return this.protocol != null ? this.protocol.equals(that.protocol) : that.protocol == null;
        }

        @Override
        public int hashCode() {
            int result = this.hostName.hashCode();
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            return result;
        }
    }
}
