package software.amazon.awscdk.services.s3;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.34.0 (build 9b72778)", date = "2021-09-29T20:30:33.062Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.IBucket")
@software.amazon.jsii.Jsii.Proxy(IBucket.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IBucket extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.core.IResource {

    /**
     * The ARN of the bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBucketArn();

    /**
     * The IPv4 DNS name of the specified bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBucketDomainName();

    /**
     * The IPv6 DNS name of the specified bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBucketDualStackDomainName();

    /**
     * The name of the bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

    /**
     * The regional domain name of the specified bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBucketRegionalDomainName();

    /**
     * The Domain name of the static website.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBucketWebsiteDomainName();

    /**
     * The URL of the static website.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBucketWebsiteUrl();

    /**
     * Optional KMS encryption key associated with this bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * If this bucket has been configured for static website hosting.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIsWebsite() {
        return null;
    }

    /**
     * The resource policy associated with this bucket.
     * <p>
     * If <code>autoCreatePolicy</code> is true, a <code>BucketPolicy</code> will be created upon the
     * first call to addToResourcePolicy(s).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.BucketPolicy getPolicy() {
        return null;
    }

    /**
     * The resource policy associated with this bucket.
     * <p>
     * If <code>autoCreatePolicy</code> is true, a <code>BucketPolicy</code> will be created upon the
     * first call to addToResourcePolicy(s).
     */
    @software.amazon.jsii.Optional
    default void setPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.BucketPolicy value) {
        throw new UnsupportedOperationException("'void " + getClass().getCanonicalName() + "#setPolicy(@org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.BucketPolicy)' is not implemented!");
    }

    /**
     * Adds a bucket notification event destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * bucket.addEventNotification(EventType.getOnObjectCreated(), myLambda, "home/myusername/*");}</pre></blockquote>
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html
     * @param event The event to trigger the notification. This parameter is required.
     * @param dest The notification destination (Lambda, SNS Topic or SQS Queue). This parameter is required.
     * @param filters S3 object key filter rules to determine which objects trigger this event. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addEventNotification(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.EventType event, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucketNotificationDestination dest, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.NotificationKeyFilter... filters);

    /**
     * Subscribes a destination to receive notifications when an object is created in the bucket.
     * <p>
     * This is identical to calling
     * <code>onEvent(EventType.ObjectCreated)</code>.
     * <p>
     * @param dest The notification destination (see onEvent). This parameter is required.
     * @param filters Filters (see onEvent). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addObjectCreatedNotification(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucketNotificationDestination dest, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.NotificationKeyFilter... filters);

    /**
     * Subscribes a destination to receive notifications when an object is removed from the bucket.
     * <p>
     * This is identical to calling
     * <code>onEvent(EventType.ObjectRemoved)</code>.
     * <p>
     * @param dest The notification destination (see onEvent). This parameter is required.
     * @param filters Filters (see onEvent). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addObjectRemovedNotification(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucketNotificationDestination dest, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.NotificationKeyFilter... filters);

    /**
     * Adds a statement to the resource policy for a principal (i.e. account/role/service) to perform actions on this bucket and/or its contents. Use `bucketArn` and `arnForObjects(keys)` to obtain ARNs for this bucket or objects.
     * <p>
     * Note that the policy statement may or may not be added to the policy.
     * For example, when an <code>IBucket</code> is created from an existing bucket,
     * it's not possible to tell whether the bucket already has a policy
     * attached, let alone to re-use that policy to add more statements to it.
     * So it's safest to do nothing in these cases.
     * <p>
     * @return metadata about the execution of this method. If the policy
     * was not added, the value of `statementAdded` will be `false`. You
     * should always check this value to make sure that the operation was
     * actually carried out. Otherwise, synthesis and deploy will terminate
     * silently, which may be confusing.
     * @param permission the policy statement to be added to the bucket's policy. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToResourcePolicyResult addToResourcePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement permission);

    /**
     * Returns an ARN that represents all objects within the bucket that match the key pattern specified.
     * <p>
     * To represent all keys, specify <code>"*"</code>.
     * <p>
     * @param keyPattern This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String arnForObjects(final @org.jetbrains.annotations.NotNull java.lang.String keyPattern);

    /**
     * Grants s3:DeleteObject* permission to an IAM principal for objects in this bucket.
     * <p>
     * @param identity The principal. This parameter is required.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantDelete(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern);

    /**
     * Grants s3:DeleteObject* permission to an IAM principal for objects in this bucket.
     * <p>
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantDelete(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity);

    /**
     * Allows unrestricted access to objects from this bucket.
     * <p>
     * IMPORTANT: This permission allows anyone to perform actions on S3 objects
     * in this bucket, which is useful for when you configure your bucket as a
     * website and want everyone to be able to read objects in the bucket without
     * needing to authenticate.
     * <p>
     * Without arguments, this method will grant read ("s3:GetObject") access to
     * all objects ("*") in the bucket.
     * <p>
     * The method returns the <code>iam.Grant</code> object, which can then be modified
     * as needed. For example, you can add a condition that will restrict access only
     * to an IPv4 range like this:
     * <p>
     * <blockquote><pre>
     *  const grant = bucket.grantPublicAccess();
     *  grant.resourceStatement!.addCondition(‘IpAddress’, { “aws:SourceIp”: “54.240.143.0/24” });
     * </pre></blockquote>
     * <p>
     * @return The `iam.PolicyStatement` object, which can be used to apply e.g. conditions.
     * @param keyPrefix the prefix of S3 object keys (e.g. `home/*`). Default is "*".
     * @param allowedActions the set of S3 actions to allow. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPublicAccess(final @org.jetbrains.annotations.Nullable java.lang.String keyPrefix, final @org.jetbrains.annotations.NotNull java.lang.String... allowedActions);

    /**
     * Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.
     * <p>
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     * <p>
     * @param identity The principal. This parameter is required.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPut(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern);

    /**
     * Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.
     * <p>
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     * <p>
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPut(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity);

    /**
     * Grant the given IAM identity permissions to modify the ACLs of objects in the given Bucket.
     * <p>
     * If your application has the '&#64;aws-cdk/aws-s3:grantWriteWithoutAcl' feature flag set,
     * calling {&#64;link grantWrite} or {&#64;link grantReadWrite} no longer grants permissions to modify the ACLs of the objects;
     * in this case, if you need to modify object ACLs, call this method explicitly.
     * <p>
     * @param identity The principal. This parameter is required.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPutAcl(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.String objectsKeyPattern);

    /**
     * Grant the given IAM identity permissions to modify the ACLs of objects in the given Bucket.
     * <p>
     * If your application has the '&#64;aws-cdk/aws-s3:grantWriteWithoutAcl' feature flag set,
     * calling {&#64;link grantWrite} or {&#64;link grantReadWrite} no longer grants permissions to modify the ACLs of the objects;
     * in this case, if you need to modify object ACLs, call this method explicitly.
     * <p>
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPutAcl(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity);

    /**
     * Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * <p>
     * If encryption is used, permission to use the key to decrypt the contents
     * of the bucket will also be granted to the same principal.
     * <p>
     * @param identity The principal. This parameter is required.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern);

    /**
     * Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * <p>
     * If encryption is used, permission to use the key to decrypt the contents
     * of the bucket will also be granted to the same principal.
     * <p>
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity);

    /**
     * Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * <p>
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     * <p>
     * Before CDK version 1.85.0, this method granted the <code>s3:PutObject*</code> permission that included <code>s3:PutObjectAcl</code>,
     * which could be used to grant read/write object access to IAM principals in other accounts.
     * If you want to get rid of that behavior, update your CDK version to 1.85.0 or later,
     * and make sure the <code>&#64;aws-cdk/aws-s3:grantWriteWithoutAcl</code> feature flag is set to <code>true</code>
     * in the <code>context</code> key of your cdk.json file.
     * If you've already updated, but still need the principal to have permissions to modify the ACLs,
     * use the {&#64;link grantPutAcl} method.
     * <p>
     * @param identity The principal. This parameter is required.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern);

    /**
     * Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * <p>
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     * <p>
     * Before CDK version 1.85.0, this method granted the <code>s3:PutObject*</code> permission that included <code>s3:PutObjectAcl</code>,
     * which could be used to grant read/write object access to IAM principals in other accounts.
     * If you want to get rid of that behavior, update your CDK version to 1.85.0 or later,
     * and make sure the <code>&#64;aws-cdk/aws-s3:grantWriteWithoutAcl</code> feature flag is set to <code>true</code>
     * in the <code>context</code> key of your cdk.json file.
     * If you've already updated, but still need the principal to have permissions to modify the ACLs,
     * use the {&#64;link grantPutAcl} method.
     * <p>
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity);

    /**
     * Grant write permissions to this bucket to an IAM principal.
     * <p>
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     * <p>
     * Before CDK version 1.85.0, this method granted the <code>s3:PutObject*</code> permission that included <code>s3:PutObjectAcl</code>,
     * which could be used to grant read/write object access to IAM principals in other accounts.
     * If you want to get rid of that behavior, update your CDK version to 1.85.0 or later,
     * and make sure the <code>&#64;aws-cdk/aws-s3:grantWriteWithoutAcl</code> feature flag is set to <code>true</code>
     * in the <code>context</code> key of your cdk.json file.
     * If you've already updated, but still need the principal to have permissions to modify the ACLs,
     * use the {&#64;link grantPutAcl} method.
     * <p>
     * @param identity The principal. This parameter is required.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern);

    /**
     * Grant write permissions to this bucket to an IAM principal.
     * <p>
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     * <p>
     * Before CDK version 1.85.0, this method granted the <code>s3:PutObject*</code> permission that included <code>s3:PutObjectAcl</code>,
     * which could be used to grant read/write object access to IAM principals in other accounts.
     * If you want to get rid of that behavior, update your CDK version to 1.85.0 or later,
     * and make sure the <code>&#64;aws-cdk/aws-s3:grantWriteWithoutAcl</code> feature flag is set to <code>true</code>
     * in the <code>context</code> key of your cdk.json file.
     * If you've already updated, but still need the principal to have permissions to modify the ACLs,
     * use the {&#64;link grantPutAcl} method.
     * <p>
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity);

    /**
     * Defines a CloudWatch event that triggers when something happens to this bucket.
     * <p>
     * Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.
     * <p>
     * @param id The id of the rule. This parameter is required.
     * @param options Options for adding the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailEvent(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.OnCloudTrailBucketEventOptions options);

    /**
     * Defines a CloudWatch event that triggers when something happens to this bucket.
     * <p>
     * Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.
     * <p>
     * @param id The id of the rule. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailEvent(final @org.jetbrains.annotations.NotNull java.lang.String id);

    /**
     * Defines an AWS CloudWatch event that triggers when an object is uploaded to the specified paths (keys) in this bucket using the PutObject API call.
     * <p>
     * Note that some tools like <code>aws s3 cp</code> will automatically use either
     * PutObject or the multipart upload API depending on the file size,
     * so using <code>onCloudTrailWriteObject</code> may be preferable.
     * <p>
     * Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.
     * <p>
     * @param id The id of the rule. This parameter is required.
     * @param options Options for adding the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailPutObject(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.OnCloudTrailBucketEventOptions options);

    /**
     * Defines an AWS CloudWatch event that triggers when an object is uploaded to the specified paths (keys) in this bucket using the PutObject API call.
     * <p>
     * Note that some tools like <code>aws s3 cp</code> will automatically use either
     * PutObject or the multipart upload API depending on the file size,
     * so using <code>onCloudTrailWriteObject</code> may be preferable.
     * <p>
     * Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.
     * <p>
     * @param id The id of the rule. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailPutObject(final @org.jetbrains.annotations.NotNull java.lang.String id);

    /**
     * Defines an AWS CloudWatch event that triggers when an object at the specified paths (keys) in this bucket are written to.
     * <p>
     * This includes
     * the events PutObject, CopyObject, and CompleteMultipartUpload.
     * <p>
     * Note that some tools like <code>aws s3 cp</code> will automatically use either
     * PutObject or the multipart upload API depending on the file size,
     * so using this method may be preferable to <code>onCloudTrailPutObject</code>.
     * <p>
     * Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.
     * <p>
     * @param id The id of the rule. This parameter is required.
     * @param options Options for adding the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailWriteObject(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.OnCloudTrailBucketEventOptions options);

    /**
     * Defines an AWS CloudWatch event that triggers when an object at the specified paths (keys) in this bucket are written to.
     * <p>
     * This includes
     * the events PutObject, CopyObject, and CompleteMultipartUpload.
     * <p>
     * Note that some tools like <code>aws s3 cp</code> will automatically use either
     * PutObject or the multipart upload API depending on the file size,
     * so using this method may be preferable to <code>onCloudTrailPutObject</code>.
     * <p>
     * Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.
     * <p>
     * @param id The id of the rule. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailWriteObject(final @org.jetbrains.annotations.NotNull java.lang.String id);

    /**
     * The S3 URL of an S3 object.
     * <p>
     * For example:
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * s3:}</pre></blockquote>
     * <p>
     * @return an ObjectS3Url token
     * @param key The S3 key of the object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String s3UrlForObject(final @org.jetbrains.annotations.Nullable java.lang.String key);

    /**
     * The S3 URL of an S3 object.
     * <p>
     * For example:
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * s3:}</pre></blockquote>
     * <p>
     * @return an ObjectS3Url token
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String s3UrlForObject();

    /**
     * The https URL of an S3 object.
     * <p>
     * For example:
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * https:}</pre></blockquote>
     * <p>
     * @return an ObjectS3Url token
     * @param key The S3 key of the object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String urlForObject(final @org.jetbrains.annotations.Nullable java.lang.String key);

    /**
     * The https URL of an S3 object.
     * <p>
     * For example:
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * https:}</pre></blockquote>
     * <p>
     * @return an ObjectS3Url token
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String urlForObject();

    /**
     * The virtual hosted-style URL of an S3 object.
     * <p>
     * Specify <code>regional: false</code> at
     * the options for non-regional URL. For example:
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * https:}</pre></blockquote>
     * <p>
     * @return an ObjectS3Url token
     * @param key The S3 key of the object.
     * @param options Options for generating URL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String virtualHostedUrlForObject(final @org.jetbrains.annotations.Nullable java.lang.String key, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.VirtualHostedStyleUrlOptions options);

    /**
     * The virtual hosted-style URL of an S3 object.
     * <p>
     * Specify <code>regional: false</code> at
     * the options for non-regional URL. For example:
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * https:}</pre></blockquote>
     * <p>
     * @return an ObjectS3Url token
     * @param key The S3 key of the object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String virtualHostedUrlForObject(final @org.jetbrains.annotations.Nullable java.lang.String key);

    /**
     * The virtual hosted-style URL of an S3 object.
     * <p>
     * Specify <code>regional: false</code> at
     * the options for non-regional URL. For example:
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * https:}</pre></blockquote>
     * <p>
     * @return an ObjectS3Url token
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String virtualHostedUrlForObject();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.IBucket.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ConstructNode.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Stack.class));
        }

        /**
         * The ARN of the bucket.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getBucketArn() {
            return software.amazon.jsii.Kernel.get(this, "bucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The IPv4 DNS name of the specified bucket.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getBucketDomainName() {
            return software.amazon.jsii.Kernel.get(this, "bucketDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The IPv6 DNS name of the specified bucket.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getBucketDualStackDomainName() {
            return software.amazon.jsii.Kernel.get(this, "bucketDualStackDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The name of the bucket.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getBucketName() {
            return software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The regional domain name of the specified bucket.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getBucketRegionalDomainName() {
            return software.amazon.jsii.Kernel.get(this, "bucketRegionalDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The Domain name of the static website.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getBucketWebsiteDomainName() {
            return software.amazon.jsii.Kernel.get(this, "bucketWebsiteDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The URL of the static website.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getBucketWebsiteUrl() {
            return software.amazon.jsii.Kernel.get(this, "bucketWebsiteUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Optional KMS encryption key associated with this bucket.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
        }

        /**
         * If this bucket has been configured for static website hosting.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Boolean getIsWebsite() {
            return software.amazon.jsii.Kernel.get(this, "isWebsite", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * The resource policy associated with this bucket.
         * <p>
         * If <code>autoCreatePolicy</code> is true, a <code>BucketPolicy</code> will be created upon the
         * first call to addToResourcePolicy(s).
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.BucketPolicy getPolicy() {
            return software.amazon.jsii.Kernel.get(this, "policy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.BucketPolicy.class));
        }

        /**
         * The resource policy associated with this bucket.
         * <p>
         * If <code>autoCreatePolicy</code> is true, a <code>BucketPolicy</code> will be created upon the
         * first call to addToResourcePolicy(s).
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final void setPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.BucketPolicy value) {
            software.amazon.jsii.Kernel.set(this, "policy", value);
        }

        /**
         * Adds a bucket notification event destination.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>{@code
         * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         * bucket.addEventNotification(EventType.getOnObjectCreated(), myLambda, "home/myusername/*");}</pre></blockquote>
         * <p>
         * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html
         * @param event The event to trigger the notification. This parameter is required.
         * @param dest The notification destination (Lambda, SNS Topic or SQS Queue). This parameter is required.
         * @param filters S3 object key filter rules to determine which objects trigger this event. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void addEventNotification(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.EventType event, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucketNotificationDestination dest, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.NotificationKeyFilter... filters) {
            software.amazon.jsii.Kernel.call(this, "addEventNotification", software.amazon.jsii.NativeType.VOID, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(event, "event is required"), java.util.Objects.requireNonNull(dest, "dest is required") }), java.util.Arrays.<Object>stream(filters)).toArray(Object[]::new));
        }

        /**
         * Subscribes a destination to receive notifications when an object is created in the bucket.
         * <p>
         * This is identical to calling
         * <code>onEvent(EventType.ObjectCreated)</code>.
         * <p>
         * @param dest The notification destination (see onEvent). This parameter is required.
         * @param filters Filters (see onEvent). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void addObjectCreatedNotification(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucketNotificationDestination dest, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.NotificationKeyFilter... filters) {
            software.amazon.jsii.Kernel.call(this, "addObjectCreatedNotification", software.amazon.jsii.NativeType.VOID, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(dest, "dest is required") }), java.util.Arrays.<Object>stream(filters)).toArray(Object[]::new));
        }

        /**
         * Subscribes a destination to receive notifications when an object is removed from the bucket.
         * <p>
         * This is identical to calling
         * <code>onEvent(EventType.ObjectRemoved)</code>.
         * <p>
         * @param dest The notification destination (see onEvent). This parameter is required.
         * @param filters Filters (see onEvent). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void addObjectRemovedNotification(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucketNotificationDestination dest, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.NotificationKeyFilter... filters) {
            software.amazon.jsii.Kernel.call(this, "addObjectRemovedNotification", software.amazon.jsii.NativeType.VOID, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(dest, "dest is required") }), java.util.Arrays.<Object>stream(filters)).toArray(Object[]::new));
        }

        /**
         * Adds a statement to the resource policy for a principal (i.e. account/role/service) to perform actions on this bucket and/or its contents. Use `bucketArn` and `arnForObjects(keys)` to obtain ARNs for this bucket or objects.
         * <p>
         * Note that the policy statement may or may not be added to the policy.
         * For example, when an <code>IBucket</code> is created from an existing bucket,
         * it's not possible to tell whether the bucket already has a policy
         * attached, let alone to re-use that policy to add more statements to it.
         * So it's safest to do nothing in these cases.
         * <p>
         * @return metadata about the execution of this method. If the policy
         * was not added, the value of `statementAdded` will be `false`. You
         * should always check this value to make sure that the operation was
         * actually carried out. Otherwise, synthesis and deploy will terminate
         * silently, which may be confusing.
         * @param permission the policy statement to be added to the bucket's policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToResourcePolicyResult addToResourcePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement permission) {
            return software.amazon.jsii.Kernel.call(this, "addToResourcePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.AddToResourcePolicyResult.class), new Object[] { java.util.Objects.requireNonNull(permission, "permission is required") });
        }

        /**
         * Returns an ARN that represents all objects within the bucket that match the key pattern specified.
         * <p>
         * To represent all keys, specify <code>"*"</code>.
         * <p>
         * @param keyPattern This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.String arnForObjects(final @org.jetbrains.annotations.NotNull java.lang.String keyPattern) {
            return software.amazon.jsii.Kernel.call(this, "arnForObjects", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(keyPattern, "keyPattern is required") });
        }

        /**
         * Grants s3:DeleteObject* permission to an IAM principal for objects in this bucket.
         * <p>
         * @param identity The principal. This parameter is required.
         * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantDelete(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern) {
            return software.amazon.jsii.Kernel.call(this, "grantDelete", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
        }

        /**
         * Grants s3:DeleteObject* permission to an IAM principal for objects in this bucket.
         * <p>
         * @param identity The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantDelete(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantDelete", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * Allows unrestricted access to objects from this bucket.
         * <p>
         * IMPORTANT: This permission allows anyone to perform actions on S3 objects
         * in this bucket, which is useful for when you configure your bucket as a
         * website and want everyone to be able to read objects in the bucket without
         * needing to authenticate.
         * <p>
         * Without arguments, this method will grant read ("s3:GetObject") access to
         * all objects ("*") in the bucket.
         * <p>
         * The method returns the <code>iam.Grant</code> object, which can then be modified
         * as needed. For example, you can add a condition that will restrict access only
         * to an IPv4 range like this:
         * <p>
         * <blockquote><pre>
         *  const grant = bucket.grantPublicAccess();
         *  grant.resourceStatement!.addCondition(‘IpAddress’, { “aws:SourceIp”: “54.240.143.0/24” });
         * </pre></blockquote>
         * <p>
         * @return The `iam.PolicyStatement` object, which can be used to apply e.g. conditions.
         * @param keyPrefix the prefix of S3 object keys (e.g. `home/*`). Default is "*".
         * @param allowedActions the set of S3 actions to allow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPublicAccess(final @org.jetbrains.annotations.Nullable java.lang.String keyPrefix, final @org.jetbrains.annotations.NotNull java.lang.String... allowedActions) {
            return software.amazon.jsii.Kernel.call(this, "grantPublicAccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { keyPrefix }), java.util.Arrays.<Object>stream(allowedActions)).toArray(Object[]::new));
        }

        /**
         * Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.
         * <p>
         * If encryption is used, permission to use the key to encrypt the contents
         * of written files will also be granted to the same principal.
         * <p>
         * @param identity The principal. This parameter is required.
         * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPut(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern) {
            return software.amazon.jsii.Kernel.call(this, "grantPut", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
        }

        /**
         * Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.
         * <p>
         * If encryption is used, permission to use the key to encrypt the contents
         * of written files will also be granted to the same principal.
         * <p>
         * @param identity The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPut(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantPut", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * Grant the given IAM identity permissions to modify the ACLs of objects in the given Bucket.
         * <p>
         * If your application has the '&#64;aws-cdk/aws-s3:grantWriteWithoutAcl' feature flag set,
         * calling {&#64;link grantWrite} or {&#64;link grantReadWrite} no longer grants permissions to modify the ACLs of the objects;
         * in this case, if you need to modify object ACLs, call this method explicitly.
         * <p>
         * @param identity The principal. This parameter is required.
         * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPutAcl(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.String objectsKeyPattern) {
            return software.amazon.jsii.Kernel.call(this, "grantPutAcl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
        }

        /**
         * Grant the given IAM identity permissions to modify the ACLs of objects in the given Bucket.
         * <p>
         * If your application has the '&#64;aws-cdk/aws-s3:grantWriteWithoutAcl' feature flag set,
         * calling {&#64;link grantWrite} or {&#64;link grantReadWrite} no longer grants permissions to modify the ACLs of the objects;
         * in this case, if you need to modify object ACLs, call this method explicitly.
         * <p>
         * @param identity The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPutAcl(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantPutAcl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
         * <p>
         * If encryption is used, permission to use the key to decrypt the contents
         * of the bucket will also be granted to the same principal.
         * <p>
         * @param identity The principal. This parameter is required.
         * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern) {
            return software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
        }

        /**
         * Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
         * <p>
         * If encryption is used, permission to use the key to decrypt the contents
         * of the bucket will also be granted to the same principal.
         * <p>
         * @param identity The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
         * <p>
         * If an encryption key is used, permission to use the key for
         * encrypt/decrypt will also be granted.
         * <p>
         * Before CDK version 1.85.0, this method granted the <code>s3:PutObject*</code> permission that included <code>s3:PutObjectAcl</code>,
         * which could be used to grant read/write object access to IAM principals in other accounts.
         * If you want to get rid of that behavior, update your CDK version to 1.85.0 or later,
         * and make sure the <code>&#64;aws-cdk/aws-s3:grantWriteWithoutAcl</code> feature flag is set to <code>true</code>
         * in the <code>context</code> key of your cdk.json file.
         * If you've already updated, but still need the principal to have permissions to modify the ACLs,
         * use the {&#64;link grantPutAcl} method.
         * <p>
         * @param identity The principal. This parameter is required.
         * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern) {
            return software.amazon.jsii.Kernel.call(this, "grantReadWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
        }

        /**
         * Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
         * <p>
         * If an encryption key is used, permission to use the key for
         * encrypt/decrypt will also be granted.
         * <p>
         * Before CDK version 1.85.0, this method granted the <code>s3:PutObject*</code> permission that included <code>s3:PutObjectAcl</code>,
         * which could be used to grant read/write object access to IAM principals in other accounts.
         * If you want to get rid of that behavior, update your CDK version to 1.85.0 or later,
         * and make sure the <code>&#64;aws-cdk/aws-s3:grantWriteWithoutAcl</code> feature flag is set to <code>true</code>
         * in the <code>context</code> key of your cdk.json file.
         * If you've already updated, but still need the principal to have permissions to modify the ACLs,
         * use the {&#64;link grantPutAcl} method.
         * <p>
         * @param identity The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantReadWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * Grant write permissions to this bucket to an IAM principal.
         * <p>
         * If encryption is used, permission to use the key to encrypt the contents
         * of written files will also be granted to the same principal.
         * <p>
         * Before CDK version 1.85.0, this method granted the <code>s3:PutObject*</code> permission that included <code>s3:PutObjectAcl</code>,
         * which could be used to grant read/write object access to IAM principals in other accounts.
         * If you want to get rid of that behavior, update your CDK version to 1.85.0 or later,
         * and make sure the <code>&#64;aws-cdk/aws-s3:grantWriteWithoutAcl</code> feature flag is set to <code>true</code>
         * in the <code>context</code> key of your cdk.json file.
         * If you've already updated, but still need the principal to have permissions to modify the ACLs,
         * use the {&#64;link grantPutAcl} method.
         * <p>
         * @param identity The principal. This parameter is required.
         * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern) {
            return software.amazon.jsii.Kernel.call(this, "grantWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
        }

        /**
         * Grant write permissions to this bucket to an IAM principal.
         * <p>
         * If encryption is used, permission to use the key to encrypt the contents
         * of written files will also be granted to the same principal.
         * <p>
         * Before CDK version 1.85.0, this method granted the <code>s3:PutObject*</code> permission that included <code>s3:PutObjectAcl</code>,
         * which could be used to grant read/write object access to IAM principals in other accounts.
         * If you want to get rid of that behavior, update your CDK version to 1.85.0 or later,
         * and make sure the <code>&#64;aws-cdk/aws-s3:grantWriteWithoutAcl</code> feature flag is set to <code>true</code>
         * in the <code>context</code> key of your cdk.json file.
         * If you've already updated, but still need the principal to have permissions to modify the ACLs,
         * use the {&#64;link grantPutAcl} method.
         * <p>
         * @param identity The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * Defines a CloudWatch event that triggers when something happens to this bucket.
         * <p>
         * Requires that there exists at least one CloudTrail Trail in your account
         * that captures the event. This method will not create the Trail.
         * <p>
         * @param id The id of the rule. This parameter is required.
         * @param options Options for adding the rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailEvent(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.OnCloudTrailBucketEventOptions options) {
            return software.amazon.jsii.Kernel.call(this, "onCloudTrailEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * Defines a CloudWatch event that triggers when something happens to this bucket.
         * <p>
         * Requires that there exists at least one CloudTrail Trail in your account
         * that captures the event. This method will not create the Trail.
         * <p>
         * @param id The id of the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailEvent(final @org.jetbrains.annotations.NotNull java.lang.String id) {
            return software.amazon.jsii.Kernel.call(this, "onCloudTrailEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
        }

        /**
         * Defines an AWS CloudWatch event that triggers when an object is uploaded to the specified paths (keys) in this bucket using the PutObject API call.
         * <p>
         * Note that some tools like <code>aws s3 cp</code> will automatically use either
         * PutObject or the multipart upload API depending on the file size,
         * so using <code>onCloudTrailWriteObject</code> may be preferable.
         * <p>
         * Requires that there exists at least one CloudTrail Trail in your account
         * that captures the event. This method will not create the Trail.
         * <p>
         * @param id The id of the rule. This parameter is required.
         * @param options Options for adding the rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailPutObject(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.OnCloudTrailBucketEventOptions options) {
            return software.amazon.jsii.Kernel.call(this, "onCloudTrailPutObject", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * Defines an AWS CloudWatch event that triggers when an object is uploaded to the specified paths (keys) in this bucket using the PutObject API call.
         * <p>
         * Note that some tools like <code>aws s3 cp</code> will automatically use either
         * PutObject or the multipart upload API depending on the file size,
         * so using <code>onCloudTrailWriteObject</code> may be preferable.
         * <p>
         * Requires that there exists at least one CloudTrail Trail in your account
         * that captures the event. This method will not create the Trail.
         * <p>
         * @param id The id of the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailPutObject(final @org.jetbrains.annotations.NotNull java.lang.String id) {
            return software.amazon.jsii.Kernel.call(this, "onCloudTrailPutObject", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
        }

        /**
         * Defines an AWS CloudWatch event that triggers when an object at the specified paths (keys) in this bucket are written to.
         * <p>
         * This includes
         * the events PutObject, CopyObject, and CompleteMultipartUpload.
         * <p>
         * Note that some tools like <code>aws s3 cp</code> will automatically use either
         * PutObject or the multipart upload API depending on the file size,
         * so using this method may be preferable to <code>onCloudTrailPutObject</code>.
         * <p>
         * Requires that there exists at least one CloudTrail Trail in your account
         * that captures the event. This method will not create the Trail.
         * <p>
         * @param id The id of the rule. This parameter is required.
         * @param options Options for adding the rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailWriteObject(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.OnCloudTrailBucketEventOptions options) {
            return software.amazon.jsii.Kernel.call(this, "onCloudTrailWriteObject", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * Defines an AWS CloudWatch event that triggers when an object at the specified paths (keys) in this bucket are written to.
         * <p>
         * This includes
         * the events PutObject, CopyObject, and CompleteMultipartUpload.
         * <p>
         * Note that some tools like <code>aws s3 cp</code> will automatically use either
         * PutObject or the multipart upload API depending on the file size,
         * so using this method may be preferable to <code>onCloudTrailPutObject</code>.
         * <p>
         * Requires that there exists at least one CloudTrail Trail in your account
         * that captures the event. This method will not create the Trail.
         * <p>
         * @param id The id of the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailWriteObject(final @org.jetbrains.annotations.NotNull java.lang.String id) {
            return software.amazon.jsii.Kernel.call(this, "onCloudTrailWriteObject", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
        }

        /**
         * The S3 URL of an S3 object.
         * <p>
         * For example:
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>{@code
         * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         * s3:}</pre></blockquote>
         * <p>
         * @return an ObjectS3Url token
         * @param key The S3 key of the object.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.String s3UrlForObject(final @org.jetbrains.annotations.Nullable java.lang.String key) {
            return software.amazon.jsii.Kernel.call(this, "s3UrlForObject", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { key });
        }

        /**
         * The S3 URL of an S3 object.
         * <p>
         * For example:
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>{@code
         * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         * s3:}</pre></blockquote>
         * <p>
         * @return an ObjectS3Url token
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.String s3UrlForObject() {
            return software.amazon.jsii.Kernel.call(this, "s3UrlForObject", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The https URL of an S3 object.
         * <p>
         * For example:
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>{@code
         * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         * https:}</pre></blockquote>
         * <p>
         * @return an ObjectS3Url token
         * @param key The S3 key of the object.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.String urlForObject(final @org.jetbrains.annotations.Nullable java.lang.String key) {
            return software.amazon.jsii.Kernel.call(this, "urlForObject", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { key });
        }

        /**
         * The https URL of an S3 object.
         * <p>
         * For example:
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>{@code
         * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         * https:}</pre></blockquote>
         * <p>
         * @return an ObjectS3Url token
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.String urlForObject() {
            return software.amazon.jsii.Kernel.call(this, "urlForObject", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The virtual hosted-style URL of an S3 object.
         * <p>
         * Specify <code>regional: false</code> at
         * the options for non-regional URL. For example:
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>{@code
         * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         * https:}</pre></blockquote>
         * <p>
         * @return an ObjectS3Url token
         * @param key The S3 key of the object.
         * @param options Options for generating URL.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.String virtualHostedUrlForObject(final @org.jetbrains.annotations.Nullable java.lang.String key, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.VirtualHostedStyleUrlOptions options) {
            return software.amazon.jsii.Kernel.call(this, "virtualHostedUrlForObject", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { key, options });
        }

        /**
         * The virtual hosted-style URL of an S3 object.
         * <p>
         * Specify <code>regional: false</code> at
         * the options for non-regional URL. For example:
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>{@code
         * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         * https:}</pre></blockquote>
         * <p>
         * @return an ObjectS3Url token
         * @param key The S3 key of the object.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.String virtualHostedUrlForObject(final @org.jetbrains.annotations.Nullable java.lang.String key) {
            return software.amazon.jsii.Kernel.call(this, "virtualHostedUrlForObject", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { key });
        }

        /**
         * The virtual hosted-style URL of an S3 object.
         * <p>
         * Specify <code>regional: false</code> at
         * the options for non-regional URL. For example:
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>{@code
         * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         * https:}</pre></blockquote>
         * <p>
         * @return an ObjectS3Url token
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.String virtualHostedUrlForObject() {
            return software.amazon.jsii.Kernel.call(this, "virtualHostedUrlForObject", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }

    /**
     * Internal default implementation for {@link IBucket}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IBucket, software.amazon.awscdk.core.IResource.Jsii$Default {

        /**
         * The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ConstructNode.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Stack.class));
        }

        /**
         * The ARN of the bucket.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getBucketArn() {
            return software.amazon.jsii.Kernel.get(this, "bucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The IPv4 DNS name of the specified bucket.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getBucketDomainName() {
            return software.amazon.jsii.Kernel.get(this, "bucketDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The IPv6 DNS name of the specified bucket.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getBucketDualStackDomainName() {
            return software.amazon.jsii.Kernel.get(this, "bucketDualStackDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The name of the bucket.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getBucketName() {
            return software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The regional domain name of the specified bucket.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getBucketRegionalDomainName() {
            return software.amazon.jsii.Kernel.get(this, "bucketRegionalDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The Domain name of the static website.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getBucketWebsiteDomainName() {
            return software.amazon.jsii.Kernel.get(this, "bucketWebsiteDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The URL of the static website.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getBucketWebsiteUrl() {
            return software.amazon.jsii.Kernel.get(this, "bucketWebsiteUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Optional KMS encryption key associated with this bucket.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
        }

        /**
         * If this bucket has been configured for static website hosting.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Boolean getIsWebsite() {
            return software.amazon.jsii.Kernel.get(this, "isWebsite", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * The resource policy associated with this bucket.
         * <p>
         * If <code>autoCreatePolicy</code> is true, a <code>BucketPolicy</code> will be created upon the
         * first call to addToResourcePolicy(s).
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.BucketPolicy getPolicy() {
            return software.amazon.jsii.Kernel.get(this, "policy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.BucketPolicy.class));
        }

        /**
         * The resource policy associated with this bucket.
         * <p>
         * If <code>autoCreatePolicy</code> is true, a <code>BucketPolicy</code> will be created upon the
         * first call to addToResourcePolicy(s).
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default void setPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.BucketPolicy value) {
            software.amazon.jsii.Kernel.set(this, "policy", value);
        }

        /**
         * Adds a bucket notification event destination.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>{@code
         * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         * bucket.addEventNotification(EventType.getOnObjectCreated(), myLambda, "home/myusername/*");}</pre></blockquote>
         * <p>
         * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html
         * @param event The event to trigger the notification. This parameter is required.
         * @param dest The notification destination (Lambda, SNS Topic or SQS Queue). This parameter is required.
         * @param filters S3 object key filter rules to determine which objects trigger this event. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void addEventNotification(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.EventType event, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucketNotificationDestination dest, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.NotificationKeyFilter... filters) {
            software.amazon.jsii.Kernel.call(this, "addEventNotification", software.amazon.jsii.NativeType.VOID, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(event, "event is required"), java.util.Objects.requireNonNull(dest, "dest is required") }), java.util.Arrays.<Object>stream(filters)).toArray(Object[]::new));
        }

        /**
         * Subscribes a destination to receive notifications when an object is created in the bucket.
         * <p>
         * This is identical to calling
         * <code>onEvent(EventType.ObjectCreated)</code>.
         * <p>
         * @param dest The notification destination (see onEvent). This parameter is required.
         * @param filters Filters (see onEvent). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void addObjectCreatedNotification(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucketNotificationDestination dest, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.NotificationKeyFilter... filters) {
            software.amazon.jsii.Kernel.call(this, "addObjectCreatedNotification", software.amazon.jsii.NativeType.VOID, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(dest, "dest is required") }), java.util.Arrays.<Object>stream(filters)).toArray(Object[]::new));
        }

        /**
         * Subscribes a destination to receive notifications when an object is removed from the bucket.
         * <p>
         * This is identical to calling
         * <code>onEvent(EventType.ObjectRemoved)</code>.
         * <p>
         * @param dest The notification destination (see onEvent). This parameter is required.
         * @param filters Filters (see onEvent). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void addObjectRemovedNotification(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucketNotificationDestination dest, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.NotificationKeyFilter... filters) {
            software.amazon.jsii.Kernel.call(this, "addObjectRemovedNotification", software.amazon.jsii.NativeType.VOID, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(dest, "dest is required") }), java.util.Arrays.<Object>stream(filters)).toArray(Object[]::new));
        }

        /**
         * Adds a statement to the resource policy for a principal (i.e. account/role/service) to perform actions on this bucket and/or its contents. Use `bucketArn` and `arnForObjects(keys)` to obtain ARNs for this bucket or objects.
         * <p>
         * Note that the policy statement may or may not be added to the policy.
         * For example, when an <code>IBucket</code> is created from an existing bucket,
         * it's not possible to tell whether the bucket already has a policy
         * attached, let alone to re-use that policy to add more statements to it.
         * So it's safest to do nothing in these cases.
         * <p>
         * @return metadata about the execution of this method. If the policy
         * was not added, the value of `statementAdded` will be `false`. You
         * should always check this value to make sure that the operation was
         * actually carried out. Otherwise, synthesis and deploy will terminate
         * silently, which may be confusing.
         * @param permission the policy statement to be added to the bucket's policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToResourcePolicyResult addToResourcePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement permission) {
            return software.amazon.jsii.Kernel.call(this, "addToResourcePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.AddToResourcePolicyResult.class), new Object[] { java.util.Objects.requireNonNull(permission, "permission is required") });
        }

        /**
         * Returns an ARN that represents all objects within the bucket that match the key pattern specified.
         * <p>
         * To represent all keys, specify <code>"*"</code>.
         * <p>
         * @param keyPattern This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull java.lang.String arnForObjects(final @org.jetbrains.annotations.NotNull java.lang.String keyPattern) {
            return software.amazon.jsii.Kernel.call(this, "arnForObjects", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(keyPattern, "keyPattern is required") });
        }

        /**
         * Grants s3:DeleteObject* permission to an IAM principal for objects in this bucket.
         * <p>
         * @param identity The principal. This parameter is required.
         * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantDelete(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern) {
            return software.amazon.jsii.Kernel.call(this, "grantDelete", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
        }

        /**
         * Allows unrestricted access to objects from this bucket.
         * <p>
         * IMPORTANT: This permission allows anyone to perform actions on S3 objects
         * in this bucket, which is useful for when you configure your bucket as a
         * website and want everyone to be able to read objects in the bucket without
         * needing to authenticate.
         * <p>
         * Without arguments, this method will grant read ("s3:GetObject") access to
         * all objects ("*") in the bucket.
         * <p>
         * The method returns the <code>iam.Grant</code> object, which can then be modified
         * as needed. For example, you can add a condition that will restrict access only
         * to an IPv4 range like this:
         * <p>
         * <blockquote><pre>
         *  const grant = bucket.grantPublicAccess();
         *  grant.resourceStatement!.addCondition(‘IpAddress’, { “aws:SourceIp”: “54.240.143.0/24” });
         * </pre></blockquote>
         * <p>
         * @return The `iam.PolicyStatement` object, which can be used to apply e.g. conditions.
         * @param keyPrefix the prefix of S3 object keys (e.g. `home/*`). Default is "*".
         * @param allowedActions the set of S3 actions to allow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPublicAccess(final @org.jetbrains.annotations.Nullable java.lang.String keyPrefix, final @org.jetbrains.annotations.NotNull java.lang.String... allowedActions) {
            return software.amazon.jsii.Kernel.call(this, "grantPublicAccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { keyPrefix }), java.util.Arrays.<Object>stream(allowedActions)).toArray(Object[]::new));
        }

        /**
         * Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.
         * <p>
         * If encryption is used, permission to use the key to encrypt the contents
         * of written files will also be granted to the same principal.
         * <p>
         * @param identity The principal. This parameter is required.
         * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPut(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern) {
            return software.amazon.jsii.Kernel.call(this, "grantPut", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
        }

        /**
         * Grant the given IAM identity permissions to modify the ACLs of objects in the given Bucket.
         * <p>
         * If your application has the '&#64;aws-cdk/aws-s3:grantWriteWithoutAcl' feature flag set,
         * calling {&#64;link grantWrite} or {&#64;link grantReadWrite} no longer grants permissions to modify the ACLs of the objects;
         * in this case, if you need to modify object ACLs, call this method explicitly.
         * <p>
         * @param identity The principal. This parameter is required.
         * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPutAcl(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.String objectsKeyPattern) {
            return software.amazon.jsii.Kernel.call(this, "grantPutAcl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
        }

        /**
         * Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
         * <p>
         * If encryption is used, permission to use the key to decrypt the contents
         * of the bucket will also be granted to the same principal.
         * <p>
         * @param identity The principal. This parameter is required.
         * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern) {
            return software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
        }

        /**
         * Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
         * <p>
         * If an encryption key is used, permission to use the key for
         * encrypt/decrypt will also be granted.
         * <p>
         * Before CDK version 1.85.0, this method granted the <code>s3:PutObject*</code> permission that included <code>s3:PutObjectAcl</code>,
         * which could be used to grant read/write object access to IAM principals in other accounts.
         * If you want to get rid of that behavior, update your CDK version to 1.85.0 or later,
         * and make sure the <code>&#64;aws-cdk/aws-s3:grantWriteWithoutAcl</code> feature flag is set to <code>true</code>
         * in the <code>context</code> key of your cdk.json file.
         * If you've already updated, but still need the principal to have permissions to modify the ACLs,
         * use the {&#64;link grantPutAcl} method.
         * <p>
         * @param identity The principal. This parameter is required.
         * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern) {
            return software.amazon.jsii.Kernel.call(this, "grantReadWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
        }

        /**
         * Grant write permissions to this bucket to an IAM principal.
         * <p>
         * If encryption is used, permission to use the key to encrypt the contents
         * of written files will also be granted to the same principal.
         * <p>
         * Before CDK version 1.85.0, this method granted the <code>s3:PutObject*</code> permission that included <code>s3:PutObjectAcl</code>,
         * which could be used to grant read/write object access to IAM principals in other accounts.
         * If you want to get rid of that behavior, update your CDK version to 1.85.0 or later,
         * and make sure the <code>&#64;aws-cdk/aws-s3:grantWriteWithoutAcl</code> feature flag is set to <code>true</code>
         * in the <code>context</code> key of your cdk.json file.
         * If you've already updated, but still need the principal to have permissions to modify the ACLs,
         * use the {&#64;link grantPutAcl} method.
         * <p>
         * @param identity The principal. This parameter is required.
         * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern) {
            return software.amazon.jsii.Kernel.call(this, "grantWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
        }

        /**
         * Defines a CloudWatch event that triggers when something happens to this bucket.
         * <p>
         * Requires that there exists at least one CloudTrail Trail in your account
         * that captures the event. This method will not create the Trail.
         * <p>
         * @param id The id of the rule. This parameter is required.
         * @param options Options for adding the rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailEvent(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.OnCloudTrailBucketEventOptions options) {
            return software.amazon.jsii.Kernel.call(this, "onCloudTrailEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * Defines an AWS CloudWatch event that triggers when an object is uploaded to the specified paths (keys) in this bucket using the PutObject API call.
         * <p>
         * Note that some tools like <code>aws s3 cp</code> will automatically use either
         * PutObject or the multipart upload API depending on the file size,
         * so using <code>onCloudTrailWriteObject</code> may be preferable.
         * <p>
         * Requires that there exists at least one CloudTrail Trail in your account
         * that captures the event. This method will not create the Trail.
         * <p>
         * @param id The id of the rule. This parameter is required.
         * @param options Options for adding the rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailPutObject(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.OnCloudTrailBucketEventOptions options) {
            return software.amazon.jsii.Kernel.call(this, "onCloudTrailPutObject", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * Defines an AWS CloudWatch event that triggers when an object at the specified paths (keys) in this bucket are written to.
         * <p>
         * This includes
         * the events PutObject, CopyObject, and CompleteMultipartUpload.
         * <p>
         * Note that some tools like <code>aws s3 cp</code> will automatically use either
         * PutObject or the multipart upload API depending on the file size,
         * so using this method may be preferable to <code>onCloudTrailPutObject</code>.
         * <p>
         * Requires that there exists at least one CloudTrail Trail in your account
         * that captures the event. This method will not create the Trail.
         * <p>
         * @param id The id of the rule. This parameter is required.
         * @param options Options for adding the rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailWriteObject(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.OnCloudTrailBucketEventOptions options) {
            return software.amazon.jsii.Kernel.call(this, "onCloudTrailWriteObject", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * The S3 URL of an S3 object.
         * <p>
         * For example:
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>{@code
         * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         * s3:}</pre></blockquote>
         * <p>
         * @return an ObjectS3Url token
         * @param key The S3 key of the object.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull java.lang.String s3UrlForObject(final @org.jetbrains.annotations.Nullable java.lang.String key) {
            return software.amazon.jsii.Kernel.call(this, "s3UrlForObject", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { key });
        }

        /**
         * The https URL of an S3 object.
         * <p>
         * For example:
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>{@code
         * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         * https:}</pre></blockquote>
         * <p>
         * @return an ObjectS3Url token
         * @param key The S3 key of the object.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull java.lang.String urlForObject(final @org.jetbrains.annotations.Nullable java.lang.String key) {
            return software.amazon.jsii.Kernel.call(this, "urlForObject", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { key });
        }

        /**
         * The virtual hosted-style URL of an S3 object.
         * <p>
         * Specify <code>regional: false</code> at
         * the options for non-regional URL. For example:
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>{@code
         * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         * https:}</pre></blockquote>
         * <p>
         * @return an ObjectS3Url token
         * @param key The S3 key of the object.
         * @param options Options for generating URL.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull java.lang.String virtualHostedUrlForObject(final @org.jetbrains.annotations.Nullable java.lang.String key, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.VirtualHostedStyleUrlOptions options) {
            return software.amazon.jsii.Kernel.call(this, "virtualHostedUrlForObject", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { key, options });
        }
    }
}
