package software.amazon.awscdk.services.s3;

/**
 * Specifies a metrics configuration for the CloudWatch request metrics from an Amazon S3 bucket.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-15T12:29:33.055Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BucketMetrics extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID used to identify the metrics configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getId();

    /**
     * The prefix that an object must have to be included in the metrics results.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getPrefix();

    /**
     * Specifies a list of tag filters to use as a metrics configuration filter. The metrics configuration includes only objects that meet the filter's criteria.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.Map<java.lang.String, java.lang.Object> getTagFilters();

    /**
     * @return a {@link Builder} of {@link BucketMetrics}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BucketMetrics}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String id;
        private java.lang.String prefix;
        private java.util.Map<java.lang.String, java.lang.Object> tagFilters;

        /**
         * Sets the value of Id
         * @param id The ID used to identify the metrics configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder id(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the value of Prefix
         * @param prefix The prefix that an object must have to be included in the metrics results.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prefix(java.lang.String prefix) {
            this.prefix = prefix;
            return this;
        }

        /**
         * Sets the value of TagFilters
         * @param tagFilters Specifies a list of tag filters to use as a metrics configuration filter. The metrics configuration includes only objects that meet the filter's criteria.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagFilters(java.util.Map<java.lang.String, java.lang.Object> tagFilters) {
            this.tagFilters = tagFilters;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BucketMetrics}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public BucketMetrics build() {
            return new Jsii$Proxy(id, prefix, tagFilters);
        }
    }

    /**
     * An implementation for {@link BucketMetrics}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BucketMetrics {
        private final java.lang.String id;
        private final java.lang.String prefix;
        private final java.util.Map<java.lang.String, java.lang.Object> tagFilters;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.id = this.jsiiGet("id", java.lang.String.class);
            this.prefix = this.jsiiGet("prefix", java.lang.String.class);
            this.tagFilters = this.jsiiGet("tagFilters", java.util.Map.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String id, java.lang.String prefix, java.util.Map<java.lang.String, java.lang.Object> tagFilters) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.id = java.util.Objects.requireNonNull(id, "id is required");
            this.prefix = prefix;
            this.tagFilters = tagFilters;
        }

        @Override
        public java.lang.String getId() {
            return this.id;
        }

        @Override
        public java.lang.String getPrefix() {
            return this.prefix;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.Object> getTagFilters() {
            return this.tagFilters;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("id", om.valueToTree(this.getId()));
            if (this.getPrefix() != null) {
                obj.set("prefix", om.valueToTree(this.getPrefix()));
            }
            if (this.getTagFilters() != null) {
                obj.set("tagFilters", om.valueToTree(this.getTagFilters()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BucketMetrics.Jsii$Proxy that = (BucketMetrics.Jsii$Proxy) o;

            if (!id.equals(that.id)) return false;
            if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
            return this.tagFilters != null ? this.tagFilters.equals(that.tagFilters) : that.tagFilters == null;
        }

        @Override
        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
            result = 31 * result + (this.tagFilters != null ? this.tagFilters.hashCode() : 0);
            return result;
        }
    }
}
