/**
 * <h1>Amazon S3 Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * Define an unencrypted S3 bucket.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Bucket bucket = new Bucket(this, "MyFirstBucket");
 * </pre></blockquote>
 * <p>
 * <code>Bucket</code> constructs expose the following deploy-time attributes:
 * <p>
 * <ul>
 * <li><code>bucketArn</code> - the ARN of the bucket (i.e. <code>arn:aws:s3:::bucket_name</code>)</li>
 * <li><code>bucketName</code> - the name of the bucket (i.e. <code>bucket_name</code>)</li>
 * <li><code>bucketWebsiteUrl</code> - the Website URL of the bucket (i.e.
 * <code>http://bucket_name.s3-website-us-west-1.amazonaws.com</code>)</li>
 * <li><code>bucketDomainName</code> - the URL of the bucket (i.e. <code>bucket_name.s3.amazonaws.com</code>)</li>
 * <li><code>bucketDualStackDomainName</code> - the dual-stack URL of the bucket (i.e.
 * <code>bucket_name.s3.dualstack.eu-west-1.amazonaws.com</code>)</li>
 * <li><code>bucketRegionalDomainName</code> - the regional URL of the bucket (i.e.
 * <code>bucket_name.s3.eu-west-1.amazonaws.com</code>)</li>
 * <li><code>arnForObjects(pattern)</code> - the ARN of an object or objects within the bucket (i.e.
 * <code>arn:aws:s3:::bucket_name/exampleobject.png</code> or
 * <code>arn:aws:s3:::bucket_name/Development/*</code>)</li>
 * <li><code>urlForObject(key)</code> - the HTTP URL of an object within the bucket (i.e.
 * <code>https://s3.cn-north-1.amazonaws.com.cn/china-bucket/mykey</code>)</li>
 * <li><code>virtualHostedUrlForObject(key)</code> - the virtual-hosted style HTTP URL of an object
 * within the bucket (i.e. <code>https://china-bucket-s3.cn-north-1.amazonaws.com.cn/mykey</code>)</li>
 * <li><code>s3UrlForObject(key)</code> - the S3 URL of an object within the bucket (i.e.
 * <code>s3://bucket/mykey</code>)</li>
 * </ul>
 * <p>
 * <h2>Encryption</h2>
 * <p>
 * Define a KMS-encrypted bucket:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Bucket bucket = Bucket.Builder.create(this, "MyEncryptedBucket")
 *         .encryption(s3.BucketEncryption.KMS)
 *         .build();
 * 
 * // you can access the encryption key:
 * assert(bucket.getEncryptionKey() instanceof kms.getKey());
 * </pre></blockquote>
 * <p>
 * You can also supply your own key:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Key myKmsKey = new Key(this, "MyKey");
 * 
 * Bucket bucket = Bucket.Builder.create(this, "MyEncryptedBucket")
 *         .encryption(s3.BucketEncryption.KMS)
 *         .encryptionKey(myKmsKey)
 *         .build();
 * 
 * assert(bucket.getEncryptionKey() == myKmsKey);
 * </pre></blockquote>
 * <p>
 * Enable KMS-SSE encryption via <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html">S3 Bucket Keys</a>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Bucket bucket = Bucket.Builder.create(this, "MyEncryptedBucket")
 *         .encryption(s3.BucketEncryption.KMS)
 *         .bucketKeyEnabled(true)
 *         .build();
 * </pre></blockquote>
 * <p>
 * Use <code>BucketEncryption.ManagedKms</code> to use the S3 master KMS key:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Bucket bucket = Bucket.Builder.create(this, "Buck")
 *         .encryption(s3.BucketEncryption.KMS_MANAGED)
 *         .build();
 * 
 * assert(bucket.getEncryptionKey() == null);
 * </pre></blockquote>
 * <p>
 * <h2>Permissions</h2>
 * <p>
 * A bucket policy will be automatically created for the bucket upon the first call to
 * <code>addToResourcePolicy(statement)</code>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Bucket bucket = new Bucket(this, "MyBucket");
 * AddToResourcePolicyResult result = bucket.addToResourcePolicy(PolicyStatement.Builder.create()
 *         .actions(List.of("s3:GetObject"))
 *         .resources(List.of(bucket.arnForObjects("file.txt")))
 *         .principals(List.of(new AccountRootPrincipal()))
 *         .build());
 * </pre></blockquote>
 * <p>
 * If you try to add a policy statement to an existing bucket, this method will
 * not do anything:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * IBucket bucket = s3.Bucket.fromBucketName(this, "existingBucket", "bucket-name");
 * 
 * // No policy statement will be added to the resource
 * AddToResourcePolicyResult result = bucket.addToResourcePolicy(PolicyStatement.Builder.create()
 *         .actions(List.of("s3:GetObject"))
 *         .resources(List.of(bucket.arnForObjects("file.txt")))
 *         .principals(List.of(new AccountRootPrincipal()))
 *         .build());
 * </pre></blockquote>
 * <p>
 * That's because it's not possible to tell whether the bucket
 * already has a policy attached, let alone to re-use that policy to add more
 * statements to it. We recommend that you always check the result of the call:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Bucket bucket = new Bucket(this, "MyBucket");
 * AddToResourcePolicyResult result = bucket.addToResourcePolicy(PolicyStatement.Builder.create()
 *         .actions(List.of("s3:GetObject"))
 *         .resources(List.of(bucket.arnForObjects("file.txt")))
 *         .principals(List.of(new AccountRootPrincipal()))
 *         .build());
 * 
 * if (!result.getStatementAdded()) {
 * }
 * </pre></blockquote>
 * <p>
 * The bucket policy can be directly accessed after creation to add statements or
 * adjust the removal policy.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Bucket bucket = new Bucket(this, "MyBucket");
 * bucket.policy.applyRemovalPolicy(cdk.RemovalPolicy.RETAIN);
 * </pre></blockquote>
 * <p>
 * Most of the time, you won't have to manipulate the bucket policy directly.
 * Instead, buckets have "grant" methods called to give prepackaged sets of permissions
 * to other resources. For example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Function myLambda;
 * 
 * 
 * Bucket bucket = new Bucket(this, "MyBucket");
 * bucket.grantReadWrite(myLambda);
 * </pre></blockquote>
 * <p>
 * Will give the Lambda's execution role permissions to read and write
 * from the bucket.
 * <p>
 * <h2>AWS Foundational Security Best Practices</h2>
 * <p>
 * <h3>Enforcing SSL</h3>
 * <p>
 * To require all requests use Secure Socket Layer (SSL):
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Bucket bucket = Bucket.Builder.create(this, "Bucket")
 *         .enforceSSL(true)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Sharing buckets between stacks</h2>
 * <p>
 * To use a bucket in a different stack in the same CDK application, pass the object to the other stack:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * /**
 *  * Stack that defines the bucket
 *  *&#47;
 * public class Producer extends Stack {
 *     public final Bucket myBucket;
 * 
 *     public Producer(App scope, String id) {
 *         this(scope, id, null);
 *     }
 * 
 *     public Producer(App scope, String id, StackProps props) {
 *         super(scope, id, props);
 * 
 *         Bucket bucket = Bucket.Builder.create(this, "MyBucket")
 *                 .removalPolicy(cdk.RemovalPolicy.DESTROY)
 *                 .build();
 *         this.myBucket = bucket;
 *     }
 * }
 * 
 * public class ConsumerProps extends StackProps {
 *     private IBucket userBucket;
 *     public IBucket getUserBucket() {
 *         return this.userBucket;
 *     }
 *     public ConsumerProps userBucket(IBucket userBucket) {
 *         this.userBucket = userBucket;
 *         return this;
 *     }
 * }
 * 
 * /**
 *  * Stack that consumes the bucket
 *  *&#47;
 * public class Consumer extends Stack {
 *     public Consumer(App scope, String id, ConsumerProps props) {
 *         super(scope, id, props);
 * 
 *         User user = new User(this, "MyUser");
 *         props.userBucket.grantReadWrite(user);
 *     }
 * }
 * 
 * Producer producer = new Producer(app, "ProducerStack");
 * new Consumer(app, "ConsumerStack", new ConsumerProps().userBucket(producer.getMyBucket()));
 * </pre></blockquote>
 * <p>
 * <h2>Importing existing buckets</h2>
 * <p>
 * To import an existing bucket into your CDK application, use the <code>Bucket.fromBucketAttributes</code>
 * factory method. This method accepts <code>BucketAttributes</code> which describes the properties of an already
 * existing bucket:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Function myLambda;
 * 
 * IBucket bucket = s3.Bucket.fromBucketAttributes(this, "ImportedBucket", BucketAttributes.builder()
 *         .bucketArn("arn:aws:s3:::my-bucket")
 *         .build());
 * 
 * // now you can just call methods on the bucket
 * bucket.addEventNotification(s3.EventType.OBJECT_CREATED, new LambdaDestination(myLambda), NotificationKeyFilter.builder().prefix("home/myusername/*").build());
 * </pre></blockquote>
 * <p>
 * Alternatively, short-hand factories are available as <code>Bucket.fromBucketName</code> and
 * <code>Bucket.fromBucketArn</code>, which will derive all bucket attributes from the bucket
 * name or ARN respectively:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * IBucket byName = s3.Bucket.fromBucketName(this, "BucketByName", "my-bucket");
 * IBucket byArn = s3.Bucket.fromBucketArn(this, "BucketByArn", "arn:aws:s3:::my-bucket");
 * </pre></blockquote>
 * <p>
 * The bucket's region defaults to the current stack's region, but can also be explicitly set in cases where one of the bucket's
 * regional properties needs to contain the correct values.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * IBucket myCrossRegionBucket = s3.Bucket.fromBucketAttributes(this, "CrossRegionImport", BucketAttributes.builder()
 *         .bucketArn("arn:aws:s3:::my-bucket")
 *         .region("us-east-1")
 *         .build());
 * </pre></blockquote>
 * <p>
 * <h2>Bucket Notifications</h2>
 * <p>
 * The Amazon S3 notification feature enables you to receive notifications when
 * certain events happen in your bucket as described under [S3 Bucket
 * Notifications] of the S3 Developer Guide.
 * <p>
 * To subscribe for bucket notifications, use the <code>bucket.addEventNotification</code> method. The
 * <code>bucket.addObjectCreatedNotification</code> and <code>bucket.addObjectRemovedNotification</code> can also be used for
 * these common use cases.
 * <p>
 * The following example will subscribe an SNS topic to be notified of all <code>s3:ObjectCreated:*</code> events:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Bucket bucket = new Bucket(this, "MyBucket");
 * Topic topic = new Topic(this, "MyTopic");
 * bucket.addEventNotification(s3.EventType.OBJECT_CREATED, new SnsDestination(topic));
 * </pre></blockquote>
 * <p>
 * This call will also ensure that the topic policy can accept notifications for
 * this specific bucket.
 * <p>
 * Supported S3 notification targets are exposed by the <code>&#64;aws-cdk/aws-s3-notifications</code> package.
 * <p>
 * It is also possible to specify S3 object key filters when subscribing. The
 * following example will notify <code>myQueue</code> when objects prefixed with <code>foo/</code> and
 * have the <code>.jpg</code> suffix are removed from the bucket.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Queue myQueue;
 * 
 * Bucket bucket = new Bucket(this, "MyBucket");
 * bucket.addEventNotification(s3.EventType.OBJECT_REMOVED,
 * new SqsDestination(myQueue), NotificationKeyFilter.builder().prefix("foo/").suffix(".jpg").build());
 * </pre></blockquote>
 * <p>
 * Adding notifications on existing buckets:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Topic topic;
 * 
 * IBucket bucket = s3.Bucket.fromBucketAttributes(this, "ImportedBucket", BucketAttributes.builder()
 *         .bucketArn("arn:aws:s3:::my-bucket")
 *         .build());
 * bucket.addEventNotification(s3.EventType.OBJECT_CREATED, new SnsDestination(topic));
 * </pre></blockquote>
 * <p>
 * <h2>Block Public Access</h2>
 * <p>
 * Use <code>blockPublicAccess</code> to specify <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html">block public access settings</a> on the bucket.
 * <p>
 * Enable all block public access settings:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Bucket bucket = Bucket.Builder.create(this, "MyBlockedBucket")
 *         .blockPublicAccess(s3.BlockPublicAccess.BLOCK_ALL)
 *         .build();
 * </pre></blockquote>
 * <p>
 * Block and ignore public ACLs:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Bucket bucket = Bucket.Builder.create(this, "MyBlockedBucket")
 *         .blockPublicAccess(s3.BlockPublicAccess.BLOCK_ACLS)
 *         .build();
 * </pre></blockquote>
 * <p>
 * Alternatively, specify the settings manually:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Bucket bucket = Bucket.Builder.create(this, "MyBlockedBucket")
 *         .blockPublicAccess(BlockPublicAccess.Builder.create().blockPublicPolicy(true).build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * When <code>blockPublicPolicy</code> is set to <code>true</code>, <code>grantPublicRead()</code> throws an error.
 * <p>
 * <h2>Logging configuration</h2>
 * <p>
 * Use <code>serverAccessLogsBucket</code> to describe where server access logs are to be stored.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Bucket accessLogsBucket = new Bucket(this, "AccessLogsBucket");
 * 
 * Bucket bucket = Bucket.Builder.create(this, "MyBucket")
 *         .serverAccessLogsBucket(accessLogsBucket)
 *         .build();
 * </pre></blockquote>
 * <p>
 * It's also possible to specify a prefix for Amazon S3 to assign to all log object keys.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Bucket accessLogsBucket = new Bucket(this, "AccessLogsBucket");
 * 
 * Bucket bucket = Bucket.Builder.create(this, "MyBucket")
 *         .serverAccessLogsBucket(accessLogsBucket)
 *         .serverAccessLogsPrefix("logs")
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>S3 Inventory</h2>
 * <p>
 * An <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html">inventory</a> contains a list of the objects in the source bucket and metadata for each object. The inventory lists are stored in the destination bucket as a CSV file compressed with GZIP, as an Apache optimized row columnar (ORC) file compressed with ZLIB, or as an Apache Parquet (Parquet) file compressed with Snappy.
 * <p>
 * You can configure multiple inventory lists for a bucket. You can configure what object metadata to include in the inventory, whether to list all object versions or only current versions, where to store the inventory list file output, and whether to generate the inventory on a daily or weekly basis.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Bucket inventoryBucket = new Bucket(this, "InventoryBucket");
 * 
 * Bucket dataBucket = Bucket.Builder.create(this, "DataBucket")
 *         .inventories(List.of(Inventory.builder()
 *                 .frequency(s3.InventoryFrequency.DAILY)
 *                 .includeObjectVersions(s3.InventoryObjectVersion.CURRENT)
 *                 .destination(InventoryDestination.builder()
 *                         .bucket(inventoryBucket)
 *                         .build())
 *                 .build(), Inventory.builder()
 *                 .frequency(s3.InventoryFrequency.WEEKLY)
 *                 .includeObjectVersions(s3.InventoryObjectVersion.ALL)
 *                 .destination(InventoryDestination.builder()
 *                         .bucket(inventoryBucket)
 *                         .prefix("with-all-versions")
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * If the destination bucket is created as part of the same CDK application, the necessary permissions will be automatically added to the bucket policy.
 * However, if you use an imported bucket (i.e <code>Bucket.fromXXX()</code>), you'll have to make sure it contains the following policy document:
 * <p>
 * <blockquote><pre>
 * {
 *   "Version": "2012-10-17",
 *   "Statement": [
 *     {
 *       "Sid": "InventoryAndAnalyticsExamplePolicy",
 *       "Effect": "Allow",
 *       "Principal": { "Service": "s3.amazonaws.com" },
 *       "Action": "s3:PutObject",
 *       "Resource": ["arn:aws:s3:::destinationBucket/*"]
 *     }
 *   ]
 * }
 * </pre></blockquote>
 * <p>
 * <h2>Website redirection</h2>
 * <p>
 * You can use the two following properties to specify the bucket <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html#advanced-conditional-redirects">redirection policy</a>. Please note that these methods cannot both be applied to the same bucket.
 * <p>
 * <h3>Static redirection</h3>
 * <p>
 * You can statically redirect a to a given Bucket URL or any other host name with <code>websiteRedirect</code>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Bucket bucket = Bucket.Builder.create(this, "MyRedirectedBucket")
 *         .websiteRedirect(RedirectTarget.builder().hostName("www.example.com").build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Routing rules</h3>
 * <p>
 * Alternatively, you can also define multiple <code>websiteRoutingRules</code>, to define complex, conditional redirections:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Bucket bucket = Bucket.Builder.create(this, "MyRedirectedBucket")
 *         .websiteRoutingRules(List.of(RoutingRule.builder()
 *                 .hostName("www.example.com")
 *                 .httpRedirectCode("302")
 *                 .protocol(s3.RedirectProtocol.HTTPS)
 *                 .replaceKey(s3.ReplaceKey.prefixWith("test/"))
 *                 .condition(RoutingRuleCondition.builder()
 *                         .httpErrorCodeReturnedEquals("200")
 *                         .keyPrefixEquals("prefix")
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Filling the bucket as part of deployment</h2>
 * <p>
 * To put files into a bucket as part of a deployment (for example, to host a
 * website), see the <code>&#64;aws-cdk/aws-s3-deployment</code> package, which provides a
 * resource that can do just that.
 * <p>
 * <h2>The URL for objects</h2>
 * <p>
 * S3 provides two types of URLs for accessing objects via HTTP(S). Path-Style and
 * <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/VirtualHosting.html">Virtual Hosted-Style</a>
 * URL. Path-Style is a classic way and will be
 * <a href="https://aws.amazon.com/jp/blogs/aws/amazon-s3-path-deprecation-plan-the-rest-of-the-story">deprecated</a>.
 * We recommend to use Virtual Hosted-Style URL for newly made bucket.
 * <p>
 * You can generate both of them.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Bucket bucket = new Bucket(this, "MyBucket");
 * bucket.urlForObject("objectname"); // Path-Style URL
 * bucket.virtualHostedUrlForObject("objectname"); // Virtual Hosted-Style URL
 * bucket.virtualHostedUrlForObject("objectname", VirtualHostedStyleUrlOptions.builder().regional(false).build());
 * </pre></blockquote>
 * <p>
 * <h2>Object Ownership</h2>
 * <p>
 * You can use the two following properties to specify the bucket <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/about-object-ownership.html">object Ownership</a>.
 * <p>
 * <h3>Object writer</h3>
 * <p>
 * The Uploading account will own the object.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Bucket.Builder.create(this, "MyBucket")
 *         .objectOwnership(s3.ObjectOwnership.OBJECT_WRITER)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Bucket owner preferred</h3>
 * <p>
 * The bucket owner will own the object if the object is uploaded with the bucket-owner-full-control canned ACL. Without this setting and canned ACL, the object is uploaded and remains owned by the uploading account.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Bucket.Builder.create(this, "MyBucket")
 *         .objectOwnership(s3.ObjectOwnership.BUCKET_OWNER_PREFERRED)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Bucket deletion</h2>
 * <p>
 * When a bucket is removed from a stack (or the stack is deleted), the S3
 * bucket will be removed according to its removal policy (which by default will
 * simply orphan the bucket and leave it in your AWS account). If the removal
 * policy is set to <code>RemovalPolicy.DESTROY</code>, the bucket will be deleted as long
 * as it does not contain any objects.
 * <p>
 * To override this and force all objects to get deleted during bucket deletion,
 * enable the<code>autoDeleteObjects</code> option.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Bucket bucket = Bucket.Builder.create(this, "MyTempFileBucket")
 *         .removalPolicy(cdk.RemovalPolicy.DESTROY)
 *         .autoDeleteObjects(true)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <strong>Warning</strong> if you have deployed a bucket with <code>autoDeleteObjects: true</code>,
 * switching this to <code>false</code> in a CDK version <em>before</em> <code>1.126.0</code> will lead to
 * all objects in the bucket being deleted. Be sure to update your bucket resources
 * by deploying with CDK version <code>1.126.0</code> or later <strong>before</strong> switching this value to <code>false</code>.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.s3;
