package software.amazon.awscdk.services.s3;

/**
 * A CloudFormation `AWS::S3::MultiRegionAccessPoint`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3.*;
 * CfnMultiRegionAccessPoint cfnMultiRegionAccessPoint = CfnMultiRegionAccessPoint.Builder.create(this, "MyCfnMultiRegionAccessPoint")
 *         .regions(List.of(RegionProperty.builder()
 *                 .bucket("bucket")
 *                 .build()))
 *         // the properties below are optional
 *         .name("name")
 *         .publicAccessBlockConfiguration(PublicAccessBlockConfigurationProperty.builder()
 *                 .blockPublicAcls(false)
 *                 .blockPublicPolicy(false)
 *                 .ignorePublicAcls(false)
 *                 .restrictPublicBuckets(false)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.45.0 (build 61747b6)", date = "2021-11-19T21:31:10.112Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnMultiRegionAccessPoint")
public class CfnMultiRegionAccessPoint extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnMultiRegionAccessPoint(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMultiRegionAccessPoint(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.s3.CfnMultiRegionAccessPoint.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::S3::MultiRegionAccessPoint`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMultiRegionAccessPoint(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.CfnMultiRegionAccessPointProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAlias() {
        return software.amazon.jsii.Kernel.get(this, "attrAlias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::S3::MultiRegionAccessPoint.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::S3::MultiRegionAccessPoint.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * `AWS::S3::MultiRegionAccessPoint.PublicAccessBlockConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPublicAccessBlockConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "publicAccessBlockConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::S3::MultiRegionAccessPoint.PublicAccessBlockConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPublicAccessBlockConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "publicAccessBlockConfiguration", value);
    }

    /**
     * `AWS::S3::MultiRegionAccessPoint.PublicAccessBlockConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPublicAccessBlockConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.CfnMultiRegionAccessPoint.PublicAccessBlockConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "publicAccessBlockConfiguration", value);
    }

    /**
     * `AWS::S3::MultiRegionAccessPoint.Regions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getRegions() {
        return software.amazon.jsii.Kernel.get(this, "regions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::S3::MultiRegionAccessPoint.Regions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRegions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "regions", java.util.Objects.requireNonNull(value, "regions is required"));
    }

    /**
     * `AWS::S3::MultiRegionAccessPoint.Regions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRegions(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "regions", java.util.Objects.requireNonNull(value, "regions is required"));
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * PublicAccessBlockConfigurationProperty publicAccessBlockConfigurationProperty = PublicAccessBlockConfigurationProperty.builder()
     *         .blockPublicAcls(false)
     *         .blockPublicPolicy(false)
     *         .ignorePublicAcls(false)
     *         .restrictPublicBuckets(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnMultiRegionAccessPoint.PublicAccessBlockConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PublicAccessBlockConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PublicAccessBlockConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMultiRegionAccessPoint.PublicAccessBlockConfigurationProperty.BlockPublicAcls`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBlockPublicAcls() {
            return null;
        }

        /**
         * `CfnMultiRegionAccessPoint.PublicAccessBlockConfigurationProperty.BlockPublicPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBlockPublicPolicy() {
            return null;
        }

        /**
         * `CfnMultiRegionAccessPoint.PublicAccessBlockConfigurationProperty.IgnorePublicAcls`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIgnorePublicAcls() {
            return null;
        }

        /**
         * `CfnMultiRegionAccessPoint.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRestrictPublicBuckets() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PublicAccessBlockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PublicAccessBlockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PublicAccessBlockConfigurationProperty> {
            java.lang.Object blockPublicAcls;
            java.lang.Object blockPublicPolicy;
            java.lang.Object ignorePublicAcls;
            java.lang.Object restrictPublicBuckets;

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getBlockPublicAcls}
             * @param blockPublicAcls `CfnMultiRegionAccessPoint.PublicAccessBlockConfigurationProperty.BlockPublicAcls`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockPublicAcls(java.lang.Boolean blockPublicAcls) {
                this.blockPublicAcls = blockPublicAcls;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getBlockPublicAcls}
             * @param blockPublicAcls `CfnMultiRegionAccessPoint.PublicAccessBlockConfigurationProperty.BlockPublicAcls`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockPublicAcls(software.amazon.awscdk.core.IResolvable blockPublicAcls) {
                this.blockPublicAcls = blockPublicAcls;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getBlockPublicPolicy}
             * @param blockPublicPolicy `CfnMultiRegionAccessPoint.PublicAccessBlockConfigurationProperty.BlockPublicPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockPublicPolicy(java.lang.Boolean blockPublicPolicy) {
                this.blockPublicPolicy = blockPublicPolicy;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getBlockPublicPolicy}
             * @param blockPublicPolicy `CfnMultiRegionAccessPoint.PublicAccessBlockConfigurationProperty.BlockPublicPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockPublicPolicy(software.amazon.awscdk.core.IResolvable blockPublicPolicy) {
                this.blockPublicPolicy = blockPublicPolicy;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getIgnorePublicAcls}
             * @param ignorePublicAcls `CfnMultiRegionAccessPoint.PublicAccessBlockConfigurationProperty.IgnorePublicAcls`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ignorePublicAcls(java.lang.Boolean ignorePublicAcls) {
                this.ignorePublicAcls = ignorePublicAcls;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getIgnorePublicAcls}
             * @param ignorePublicAcls `CfnMultiRegionAccessPoint.PublicAccessBlockConfigurationProperty.IgnorePublicAcls`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ignorePublicAcls(software.amazon.awscdk.core.IResolvable ignorePublicAcls) {
                this.ignorePublicAcls = ignorePublicAcls;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getRestrictPublicBuckets}
             * @param restrictPublicBuckets `CfnMultiRegionAccessPoint.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictPublicBuckets(java.lang.Boolean restrictPublicBuckets) {
                this.restrictPublicBuckets = restrictPublicBuckets;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getRestrictPublicBuckets}
             * @param restrictPublicBuckets `CfnMultiRegionAccessPoint.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictPublicBuckets(software.amazon.awscdk.core.IResolvable restrictPublicBuckets) {
                this.restrictPublicBuckets = restrictPublicBuckets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PublicAccessBlockConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PublicAccessBlockConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PublicAccessBlockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PublicAccessBlockConfigurationProperty {
            private final java.lang.Object blockPublicAcls;
            private final java.lang.Object blockPublicPolicy;
            private final java.lang.Object ignorePublicAcls;
            private final java.lang.Object restrictPublicBuckets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.blockPublicAcls = software.amazon.jsii.Kernel.get(this, "blockPublicAcls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.blockPublicPolicy = software.amazon.jsii.Kernel.get(this, "blockPublicPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ignorePublicAcls = software.amazon.jsii.Kernel.get(this, "ignorePublicAcls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.restrictPublicBuckets = software.amazon.jsii.Kernel.get(this, "restrictPublicBuckets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.blockPublicAcls = builder.blockPublicAcls;
                this.blockPublicPolicy = builder.blockPublicPolicy;
                this.ignorePublicAcls = builder.ignorePublicAcls;
                this.restrictPublicBuckets = builder.restrictPublicBuckets;
            }

            @Override
            public final java.lang.Object getBlockPublicAcls() {
                return this.blockPublicAcls;
            }

            @Override
            public final java.lang.Object getBlockPublicPolicy() {
                return this.blockPublicPolicy;
            }

            @Override
            public final java.lang.Object getIgnorePublicAcls() {
                return this.ignorePublicAcls;
            }

            @Override
            public final java.lang.Object getRestrictPublicBuckets() {
                return this.restrictPublicBuckets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBlockPublicAcls() != null) {
                    data.set("blockPublicAcls", om.valueToTree(this.getBlockPublicAcls()));
                }
                if (this.getBlockPublicPolicy() != null) {
                    data.set("blockPublicPolicy", om.valueToTree(this.getBlockPublicPolicy()));
                }
                if (this.getIgnorePublicAcls() != null) {
                    data.set("ignorePublicAcls", om.valueToTree(this.getIgnorePublicAcls()));
                }
                if (this.getRestrictPublicBuckets() != null) {
                    data.set("restrictPublicBuckets", om.valueToTree(this.getRestrictPublicBuckets()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnMultiRegionAccessPoint.PublicAccessBlockConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PublicAccessBlockConfigurationProperty.Jsii$Proxy that = (PublicAccessBlockConfigurationProperty.Jsii$Proxy) o;

                if (this.blockPublicAcls != null ? !this.blockPublicAcls.equals(that.blockPublicAcls) : that.blockPublicAcls != null) return false;
                if (this.blockPublicPolicy != null ? !this.blockPublicPolicy.equals(that.blockPublicPolicy) : that.blockPublicPolicy != null) return false;
                if (this.ignorePublicAcls != null ? !this.ignorePublicAcls.equals(that.ignorePublicAcls) : that.ignorePublicAcls != null) return false;
                return this.restrictPublicBuckets != null ? this.restrictPublicBuckets.equals(that.restrictPublicBuckets) : that.restrictPublicBuckets == null;
            }

            @Override
            public final int hashCode() {
                int result = this.blockPublicAcls != null ? this.blockPublicAcls.hashCode() : 0;
                result = 31 * result + (this.blockPublicPolicy != null ? this.blockPublicPolicy.hashCode() : 0);
                result = 31 * result + (this.ignorePublicAcls != null ? this.ignorePublicAcls.hashCode() : 0);
                result = 31 * result + (this.restrictPublicBuckets != null ? this.restrictPublicBuckets.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * RegionProperty regionProperty = RegionProperty.builder()
     *         .bucket("bucket")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnMultiRegionAccessPoint.RegionProperty")
    @software.amazon.jsii.Jsii.Proxy(RegionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RegionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMultiRegionAccessPoint.RegionProperty.Bucket`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * @return a {@link Builder} of {@link RegionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RegionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RegionProperty> {
            java.lang.String bucket;

            /**
             * Sets the value of {@link RegionProperty#getBucket}
             * @param bucket `CfnMultiRegionAccessPoint.RegionProperty.Bucket`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RegionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RegionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RegionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RegionProperty {
            private final java.lang.String bucket;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnMultiRegionAccessPoint.RegionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RegionProperty.Jsii$Proxy that = (RegionProperty.Jsii$Proxy) o;

                return this.bucket.equals(that.bucket);
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.s3.CfnMultiRegionAccessPoint}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.s3.CfnMultiRegionAccessPoint> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.s3.CfnMultiRegionAccessPointProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.s3.CfnMultiRegionAccessPointProps.Builder();
        }

        /**
         * `AWS::S3::MultiRegionAccessPoint.Name`.
         * <p>
         * @return {@code this}
         * @param name `AWS::S3::MultiRegionAccessPoint.Name`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * `AWS::S3::MultiRegionAccessPoint.PublicAccessBlockConfiguration`.
         * <p>
         * @return {@code this}
         * @param publicAccessBlockConfiguration `AWS::S3::MultiRegionAccessPoint.PublicAccessBlockConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicAccessBlockConfiguration(final software.amazon.awscdk.core.IResolvable publicAccessBlockConfiguration) {
            this.props.publicAccessBlockConfiguration(publicAccessBlockConfiguration);
            return this;
        }
        /**
         * `AWS::S3::MultiRegionAccessPoint.PublicAccessBlockConfiguration`.
         * <p>
         * @return {@code this}
         * @param publicAccessBlockConfiguration `AWS::S3::MultiRegionAccessPoint.PublicAccessBlockConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicAccessBlockConfiguration(final software.amazon.awscdk.services.s3.CfnMultiRegionAccessPoint.PublicAccessBlockConfigurationProperty publicAccessBlockConfiguration) {
            this.props.publicAccessBlockConfiguration(publicAccessBlockConfiguration);
            return this;
        }

        /**
         * `AWS::S3::MultiRegionAccessPoint.Regions`.
         * <p>
         * @return {@code this}
         * @param regions `AWS::S3::MultiRegionAccessPoint.Regions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regions(final software.amazon.awscdk.core.IResolvable regions) {
            this.props.regions(regions);
            return this;
        }
        /**
         * `AWS::S3::MultiRegionAccessPoint.Regions`.
         * <p>
         * @return {@code this}
         * @param regions `AWS::S3::MultiRegionAccessPoint.Regions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regions(final java.util.List<? extends java.lang.Object> regions) {
            this.props.regions(regions);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.s3.CfnMultiRegionAccessPoint}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.s3.CfnMultiRegionAccessPoint build() {
            return new software.amazon.awscdk.services.s3.CfnMultiRegionAccessPoint(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
