package software.amazon.awscdk.services.s3;

/**
 * The ObjectOwnership of the bucket.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket.Builder.create(this, "MyBucket")
 *         .objectOwnership(ObjectOwnership.OBJECT_WRITER)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/about-object-ownership.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.45.0 (build 61747b6)", date = "2021-11-19T21:31:10.142Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.ObjectOwnership")
public enum ObjectOwnership {
    /**
     * Objects uploaded to the bucket change ownership to the bucket owner .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BUCKET_OWNER_PREFERRED,
    /**
     * The uploading account will own the object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OBJECT_WRITER,
}
