package software.amazon.awscdk.services.s3;

/**
 * Notification event types.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Queue myQueue;
 * Bucket bucket = new Bucket(this, "MyBucket");
 * bucket.addEventNotification(EventType.OBJECT_REMOVED,
 * new SqsDestination(myQueue), NotificationKeyFilter.builder().prefix("foo/").suffix(".jpg").build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-15T10:03:44.568Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.EventType")
public enum EventType {
    /**
     * Amazon S3 APIs such as PUT, POST, and COPY can create an object.
     * <p>
     * Using
     * these event types, you can enable notification when an object is created
     * using a specific API, or you can use the s3:ObjectCreated:* event type to
     * request notification regardless of the API that was used to create an
     * object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OBJECT_CREATED,
    /**
     * Amazon S3 APIs such as PUT, POST, and COPY can create an object.
     * <p>
     * Using
     * these event types, you can enable notification when an object is created
     * using a specific API, or you can use the s3:ObjectCreated:* event type to
     * request notification regardless of the API that was used to create an
     * object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OBJECT_CREATED_COMPLETE_MULTIPART_UPLOAD,
    /**
     * Amazon S3 APIs such as PUT, POST, and COPY can create an object.
     * <p>
     * Using
     * these event types, you can enable notification when an object is created
     * using a specific API, or you can use the s3:ObjectCreated:* event type to
     * request notification regardless of the API that was used to create an
     * object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OBJECT_CREATED_COPY,
    /**
     * Amazon S3 APIs such as PUT, POST, and COPY can create an object.
     * <p>
     * Using
     * these event types, you can enable notification when an object is created
     * using a specific API, or you can use the s3:ObjectCreated:* event type to
     * request notification regardless of the API that was used to create an
     * object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OBJECT_CREATED_POST,
    /**
     * Amazon S3 APIs such as PUT, POST, and COPY can create an object.
     * <p>
     * Using
     * these event types, you can enable notification when an object is created
     * using a specific API, or you can use the s3:ObjectCreated:* event type to
     * request notification regardless of the API that was used to create an
     * object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OBJECT_CREATED_PUT,
    /**
     * By using the ObjectRemoved event types, you can enable notification when an object or a batch of objects is removed from a bucket.
     * <p>
     * You can request notification when an object is deleted or a versioned
     * object is permanently deleted by using the s3:ObjectRemoved:Delete event
     * type. Or you can request notification when a delete marker is created for
     * a versioned object by using s3:ObjectRemoved:DeleteMarkerCreated. For
     * information about deleting versioned objects, see Deleting Object
     * Versions. You can also use a wildcard s3:ObjectRemoved:* to request
     * notification anytime an object is deleted.
     * <p>
     * You will not receive event notifications from automatic deletes from
     * lifecycle policies or from failed operations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OBJECT_REMOVED,
    /**
     * By using the ObjectRemoved event types, you can enable notification when an object or a batch of objects is removed from a bucket.
     * <p>
     * You can request notification when an object is deleted or a versioned
     * object is permanently deleted by using the s3:ObjectRemoved:Delete event
     * type. Or you can request notification when a delete marker is created for
     * a versioned object by using s3:ObjectRemoved:DeleteMarkerCreated. For
     * information about deleting versioned objects, see Deleting Object
     * Versions. You can also use a wildcard s3:ObjectRemoved:* to request
     * notification anytime an object is deleted.
     * <p>
     * You will not receive event notifications from automatic deletes from
     * lifecycle policies or from failed operations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OBJECT_REMOVED_DELETE,
    /**
     * By using the ObjectRemoved event types, you can enable notification when an object or a batch of objects is removed from a bucket.
     * <p>
     * You can request notification when an object is deleted or a versioned
     * object is permanently deleted by using the s3:ObjectRemoved:Delete event
     * type. Or you can request notification when a delete marker is created for
     * a versioned object by using s3:ObjectRemoved:DeleteMarkerCreated. For
     * information about deleting versioned objects, see Deleting Object
     * Versions. You can also use a wildcard s3:ObjectRemoved:* to request
     * notification anytime an object is deleted.
     * <p>
     * You will not receive event notifications from automatic deletes from
     * lifecycle policies or from failed operations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OBJECT_REMOVED_DELETE_MARKER_CREATED,
    /**
     * Using restore object event types you can receive notifications for initiation and completion when restoring objects from the S3 Glacier storage class.
     * <p>
     * You use s3:ObjectRestore:Completed to request notification of
     * restoration completion.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OBJECT_RESTORE_COMPLETED,
    /**
     * Using restore object event types you can receive notifications for initiation and completion when restoring objects from the S3 Glacier storage class.
     * <p>
     * You use s3:ObjectRestore:Post to request notification of object restoration
     * initiation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OBJECT_RESTORE_POST,
    /**
     * You can use this event type to request Amazon S3 to send a notification message when Amazon S3 detects that an object of the RRS storage class is lost.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REDUCED_REDUNDANCY_LOST_OBJECT,
    /**
     * You receive this notification event when an object that was eligible for replication using Amazon S3 Replication Time Control failed to replicate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REPLICATION_OPERATION_FAILED_REPLICATION,
    /**
     * You receive this notification event when an object that was eligible for replication using Amazon S3 Replication Time Control exceeded the 15-minute threshold for replication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REPLICATION_OPERATION_MISSED_THRESHOLD,
    /**
     * You receive this notification event for an object that was eligible for replication using Amazon S3 Replication Time Control but is no longer tracked by replication metrics.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REPLICATION_OPERATION_NOT_TRACKED,
    /**
     * You receive this notification event for an object that was eligible for replication using the Amazon S3 Replication Time Control feature replicated after the 15-minute threshold.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REPLICATION_OPERATION_REPLICATED_AFTER_THRESHOLD,
}
