package software.amazon.awscdk.services.s3;

/**
 * Inventory version support.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket inventoryBucket = new Bucket(this, "InventoryBucket");
 * Bucket dataBucket = Bucket.Builder.create(this, "DataBucket")
 *         .inventories(List.of(Inventory.builder()
 *                 .frequency(InventoryFrequency.DAILY)
 *                 .includeObjectVersions(InventoryObjectVersion.CURRENT)
 *                 .destination(InventoryDestination.builder()
 *                         .bucket(inventoryBucket)
 *                         .build())
 *                 .build(), Inventory.builder()
 *                 .frequency(InventoryFrequency.WEEKLY)
 *                 .includeObjectVersions(InventoryObjectVersion.ALL)
 *                 .destination(InventoryDestination.builder()
 *                         .bucket(inventoryBucket)
 *                         .prefix("with-all-versions")
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.50.0 (build d1830a4)", date = "2022-01-04T15:38:52.359Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.InventoryObjectVersion")
public enum InventoryObjectVersion {
    /**
     * Includes all versions of each object in the report.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ALL,
    /**
     * Includes only the current version of each object in the report.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CURRENT,
}
