package software.amazon.awscdk.services.s3;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket = Bucket.Builder.create(this, "MyRedirectedBucket")
 *         .websiteRoutingRules(List.of(RoutingRule.builder()
 *                 .hostName("www.example.com")
 *                 .httpRedirectCode("302")
 *                 .protocol(RedirectProtocol.HTTPS)
 *                 .replaceKey(ReplaceKey.prefixWith("test/"))
 *                 .condition(RoutingRuleCondition.builder()
 *                         .httpErrorCodeReturnedEquals("200")
 *                         .keyPrefixEquals("prefix")
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-28T22:52:19.886Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.ReplaceKey")
public class ReplaceKey extends software.amazon.jsii.JsiiObject {

    protected ReplaceKey(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ReplaceKey(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * The object key prefix to use in the redirect request.
     * <p>
     * @param keyReplacement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.ReplaceKey prefixWith(final @org.jetbrains.annotations.NotNull java.lang.String keyReplacement) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.ReplaceKey.class, "prefixWith", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.ReplaceKey.class), new Object[] { java.util.Objects.requireNonNull(keyReplacement, "keyReplacement is required") });
    }

    /**
     * The specific object key to use in the redirect request.
     * <p>
     * @param keyReplacement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.ReplaceKey with(final @org.jetbrains.annotations.NotNull java.lang.String keyReplacement) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.ReplaceKey.class, "with", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.ReplaceKey.class), new Object[] { java.util.Objects.requireNonNull(keyReplacement, "keyReplacement is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPrefixWithKey() {
        return software.amazon.jsii.Kernel.get(this, "prefixWithKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getWithKey() {
        return software.amazon.jsii.Kernel.get(this, "withKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
