package software.amazon.awscdk.services.s3;

/**
 * A CloudFormation `AWS::S3::AccessPoint`.
 * <p>
 * The AWS::S3::AccessPoint resource is an Amazon S3 resource type that you can use to access buckets.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3.*;
 * Object policy;
 * Object policyStatus;
 * CfnAccessPoint cfnAccessPoint = CfnAccessPoint.Builder.create(this, "MyCfnAccessPoint")
 *         .bucket("bucket")
 *         // the properties below are optional
 *         .name("name")
 *         .policy(policy)
 *         .policyStatus(policyStatus)
 *         .publicAccessBlockConfiguration(PublicAccessBlockConfigurationProperty.builder()
 *                 .blockPublicAcls(false)
 *                 .blockPublicPolicy(false)
 *                 .ignorePublicAcls(false)
 *                 .restrictPublicBuckets(false)
 *                 .build())
 *         .vpcConfiguration(VpcConfigurationProperty.builder()
 *                 .vpcId("vpcId")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-01T01:54:42.993Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnAccessPoint")
public class CfnAccessPoint extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnAccessPoint(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAccessPoint(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.s3.CfnAccessPoint.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::S3::AccessPoint`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAccessPoint(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.CfnAccessPointProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The alias for this access point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAlias() {
        return software.amazon.jsii.Kernel.get(this, "attrAlias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * This property contains the details of the ARN for the access point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of this access point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrName() {
        return software.amazon.jsii.Kernel.get(this, "attrName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates whether this access point allows access from the internet.
     * <p>
     * If <code>VpcConfiguration</code> is specified for this access point, then <code>NetworkOrigin</code> is <code>VPC</code> , and the access point doesn't allow access from the internet. Otherwise, <code>NetworkOrigin</code> is <code>Internet</code> , and the access point allows access from the internet, subject to the access point and bucket access policies.
     * <p>
     * <em>Allowed values</em> : <code>VPC</code> | <code>Internet</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrNetworkOrigin() {
        return software.amazon.jsii.Kernel.get(this, "attrNetworkOrigin", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the bucket associated with this access point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBucket() {
        return software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the bucket associated with this access point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBucket(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "bucket", java.util.Objects.requireNonNull(value, "bucket is required"));
    }

    /**
     * The access point policy associated with this access point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getPolicy() {
        return software.amazon.jsii.Kernel.get(this, "policy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The access point policy associated with this access point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicy(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "policy", java.util.Objects.requireNonNull(value, "policy is required"));
    }

    /**
     * The container element for a bucket's policy status.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getPolicyStatus() {
        return software.amazon.jsii.Kernel.get(this, "policyStatus", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The container element for a bucket's policy status.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicyStatus(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "policyStatus", java.util.Objects.requireNonNull(value, "policyStatus is required"));
    }

    /**
     * The name of this access point.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the access point name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of this access point.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the access point name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The PublicAccessBlock configuration that you want to apply to this Amazon S3 bucket.
     * <p>
     * You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <em>Amazon S3 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPublicAccessBlockConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "publicAccessBlockConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The PublicAccessBlock configuration that you want to apply to this Amazon S3 bucket.
     * <p>
     * You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <em>Amazon S3 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPublicAccessBlockConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "publicAccessBlockConfiguration", value);
    }

    /**
     * The PublicAccessBlock configuration that you want to apply to this Amazon S3 bucket.
     * <p>
     * You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <em>Amazon S3 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPublicAccessBlockConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.CfnAccessPoint.PublicAccessBlockConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "publicAccessBlockConfiguration", value);
    }

    /**
     * The Virtual Private Cloud (VPC) configuration for this access point, if one exists.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "vpcConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Virtual Private Cloud (VPC) configuration for this access point, if one exists.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vpcConfiguration", value);
    }

    /**
     * The Virtual Private Cloud (VPC) configuration for this access point, if one exists.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.CfnAccessPoint.VpcConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "vpcConfiguration", value);
    }
    /**
     * The PublicAccessBlock configuration that you want to apply to this Amazon S3 bucket.
     * <p>
     * You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * PublicAccessBlockConfigurationProperty publicAccessBlockConfigurationProperty = PublicAccessBlockConfigurationProperty.builder()
     *         .blockPublicAcls(false)
     *         .blockPublicPolicy(false)
     *         .ignorePublicAcls(false)
     *         .restrictPublicBuckets(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnAccessPoint.PublicAccessBlockConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PublicAccessBlockConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PublicAccessBlockConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether Amazon S3 should block public access control lists (ACLs) for this bucket and objects in this bucket.
         * <p>
         * Setting this element to <code>TRUE</code> causes the following behavior:
         * <p>
         * <ul>
         * <li>PUT Bucket ACL and PUT Object ACL calls fail if the specified ACL is public.</li>
         * <li>PUT Object calls fail if the request includes a public ACL.</li>
         * <li>PUT Bucket calls fail if the request includes a public ACL.</li>
         * </ul>
         * <p>
         * Enabling this setting doesn't affect existing policies or ACLs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBlockPublicAcls() {
            return null;
        }

        /**
         * Specifies whether Amazon S3 should block public bucket policies for this bucket.
         * <p>
         * Setting this element to <code>TRUE</code> causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access.
         * <p>
         * Enabling this setting doesn't affect existing bucket policies.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBlockPublicPolicy() {
            return null;
        }

        /**
         * Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this bucket.
         * <p>
         * Setting this element to <code>TRUE</code> causes Amazon S3 to ignore all public ACLs on this bucket and objects in this bucket.
         * <p>
         * Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIgnorePublicAcls() {
            return null;
        }

        /**
         * Specifies whether Amazon S3 should restrict public bucket policies for this bucket.
         * <p>
         * Setting this element to <code>TRUE</code> restricts access to this bucket to only AWS service principals and authorized users within this account if the bucket has a public policy.
         * <p>
         * Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRestrictPublicBuckets() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PublicAccessBlockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PublicAccessBlockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PublicAccessBlockConfigurationProperty> {
            java.lang.Object blockPublicAcls;
            java.lang.Object blockPublicPolicy;
            java.lang.Object ignorePublicAcls;
            java.lang.Object restrictPublicBuckets;

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getBlockPublicAcls}
             * @param blockPublicAcls Specifies whether Amazon S3 should block public access control lists (ACLs) for this bucket and objects in this bucket.
             *                        Setting this element to <code>TRUE</code> causes the following behavior:
             *                        <p>
             *                        <ul>
             *                        <li>PUT Bucket ACL and PUT Object ACL calls fail if the specified ACL is public.</li>
             *                        <li>PUT Object calls fail if the request includes a public ACL.</li>
             *                        <li>PUT Bucket calls fail if the request includes a public ACL.</li>
             *                        </ul>
             *                        <p>
             *                        Enabling this setting doesn't affect existing policies or ACLs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockPublicAcls(java.lang.Boolean blockPublicAcls) {
                this.blockPublicAcls = blockPublicAcls;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getBlockPublicAcls}
             * @param blockPublicAcls Specifies whether Amazon S3 should block public access control lists (ACLs) for this bucket and objects in this bucket.
             *                        Setting this element to <code>TRUE</code> causes the following behavior:
             *                        <p>
             *                        <ul>
             *                        <li>PUT Bucket ACL and PUT Object ACL calls fail if the specified ACL is public.</li>
             *                        <li>PUT Object calls fail if the request includes a public ACL.</li>
             *                        <li>PUT Bucket calls fail if the request includes a public ACL.</li>
             *                        </ul>
             *                        <p>
             *                        Enabling this setting doesn't affect existing policies or ACLs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockPublicAcls(software.amazon.awscdk.core.IResolvable blockPublicAcls) {
                this.blockPublicAcls = blockPublicAcls;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getBlockPublicPolicy}
             * @param blockPublicPolicy Specifies whether Amazon S3 should block public bucket policies for this bucket.
             *                          Setting this element to <code>TRUE</code> causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access.
             *                          <p>
             *                          Enabling this setting doesn't affect existing bucket policies.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockPublicPolicy(java.lang.Boolean blockPublicPolicy) {
                this.blockPublicPolicy = blockPublicPolicy;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getBlockPublicPolicy}
             * @param blockPublicPolicy Specifies whether Amazon S3 should block public bucket policies for this bucket.
             *                          Setting this element to <code>TRUE</code> causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access.
             *                          <p>
             *                          Enabling this setting doesn't affect existing bucket policies.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockPublicPolicy(software.amazon.awscdk.core.IResolvable blockPublicPolicy) {
                this.blockPublicPolicy = blockPublicPolicy;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getIgnorePublicAcls}
             * @param ignorePublicAcls Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this bucket.
             *                         Setting this element to <code>TRUE</code> causes Amazon S3 to ignore all public ACLs on this bucket and objects in this bucket.
             *                         <p>
             *                         Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ignorePublicAcls(java.lang.Boolean ignorePublicAcls) {
                this.ignorePublicAcls = ignorePublicAcls;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getIgnorePublicAcls}
             * @param ignorePublicAcls Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this bucket.
             *                         Setting this element to <code>TRUE</code> causes Amazon S3 to ignore all public ACLs on this bucket and objects in this bucket.
             *                         <p>
             *                         Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ignorePublicAcls(software.amazon.awscdk.core.IResolvable ignorePublicAcls) {
                this.ignorePublicAcls = ignorePublicAcls;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getRestrictPublicBuckets}
             * @param restrictPublicBuckets Specifies whether Amazon S3 should restrict public bucket policies for this bucket.
             *                              Setting this element to <code>TRUE</code> restricts access to this bucket to only AWS service principals and authorized users within this account if the bucket has a public policy.
             *                              <p>
             *                              Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictPublicBuckets(java.lang.Boolean restrictPublicBuckets) {
                this.restrictPublicBuckets = restrictPublicBuckets;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getRestrictPublicBuckets}
             * @param restrictPublicBuckets Specifies whether Amazon S3 should restrict public bucket policies for this bucket.
             *                              Setting this element to <code>TRUE</code> restricts access to this bucket to only AWS service principals and authorized users within this account if the bucket has a public policy.
             *                              <p>
             *                              Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictPublicBuckets(software.amazon.awscdk.core.IResolvable restrictPublicBuckets) {
                this.restrictPublicBuckets = restrictPublicBuckets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PublicAccessBlockConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PublicAccessBlockConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PublicAccessBlockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PublicAccessBlockConfigurationProperty {
            private final java.lang.Object blockPublicAcls;
            private final java.lang.Object blockPublicPolicy;
            private final java.lang.Object ignorePublicAcls;
            private final java.lang.Object restrictPublicBuckets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.blockPublicAcls = software.amazon.jsii.Kernel.get(this, "blockPublicAcls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.blockPublicPolicy = software.amazon.jsii.Kernel.get(this, "blockPublicPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ignorePublicAcls = software.amazon.jsii.Kernel.get(this, "ignorePublicAcls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.restrictPublicBuckets = software.amazon.jsii.Kernel.get(this, "restrictPublicBuckets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.blockPublicAcls = builder.blockPublicAcls;
                this.blockPublicPolicy = builder.blockPublicPolicy;
                this.ignorePublicAcls = builder.ignorePublicAcls;
                this.restrictPublicBuckets = builder.restrictPublicBuckets;
            }

            @Override
            public final java.lang.Object getBlockPublicAcls() {
                return this.blockPublicAcls;
            }

            @Override
            public final java.lang.Object getBlockPublicPolicy() {
                return this.blockPublicPolicy;
            }

            @Override
            public final java.lang.Object getIgnorePublicAcls() {
                return this.ignorePublicAcls;
            }

            @Override
            public final java.lang.Object getRestrictPublicBuckets() {
                return this.restrictPublicBuckets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBlockPublicAcls() != null) {
                    data.set("blockPublicAcls", om.valueToTree(this.getBlockPublicAcls()));
                }
                if (this.getBlockPublicPolicy() != null) {
                    data.set("blockPublicPolicy", om.valueToTree(this.getBlockPublicPolicy()));
                }
                if (this.getIgnorePublicAcls() != null) {
                    data.set("ignorePublicAcls", om.valueToTree(this.getIgnorePublicAcls()));
                }
                if (this.getRestrictPublicBuckets() != null) {
                    data.set("restrictPublicBuckets", om.valueToTree(this.getRestrictPublicBuckets()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnAccessPoint.PublicAccessBlockConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PublicAccessBlockConfigurationProperty.Jsii$Proxy that = (PublicAccessBlockConfigurationProperty.Jsii$Proxy) o;

                if (this.blockPublicAcls != null ? !this.blockPublicAcls.equals(that.blockPublicAcls) : that.blockPublicAcls != null) return false;
                if (this.blockPublicPolicy != null ? !this.blockPublicPolicy.equals(that.blockPublicPolicy) : that.blockPublicPolicy != null) return false;
                if (this.ignorePublicAcls != null ? !this.ignorePublicAcls.equals(that.ignorePublicAcls) : that.ignorePublicAcls != null) return false;
                return this.restrictPublicBuckets != null ? this.restrictPublicBuckets.equals(that.restrictPublicBuckets) : that.restrictPublicBuckets == null;
            }

            @Override
            public final int hashCode() {
                int result = this.blockPublicAcls != null ? this.blockPublicAcls.hashCode() : 0;
                result = 31 * result + (this.blockPublicPolicy != null ? this.blockPublicPolicy.hashCode() : 0);
                result = 31 * result + (this.ignorePublicAcls != null ? this.ignorePublicAcls.hashCode() : 0);
                result = 31 * result + (this.restrictPublicBuckets != null ? this.restrictPublicBuckets.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Virtual Private Cloud (VPC) configuration for this access point.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * VpcConfigurationProperty vpcConfigurationProperty = VpcConfigurationProperty.builder()
     *         .vpcId("vpcId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnAccessPoint.VpcConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If this field is specified, the access point will only allow connections from the specified VPC ID.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcConfigurationProperty> {
            java.lang.String vpcId;

            /**
             * Sets the value of {@link VpcConfigurationProperty#getVpcId}
             * @param vpcId If this field is specified, the access point will only allow connections from the specified VPC ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcId(java.lang.String vpcId) {
                this.vpcId = vpcId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcConfigurationProperty {
            private final java.lang.String vpcId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.vpcId = builder.vpcId;
            }

            @Override
            public final java.lang.String getVpcId() {
                return this.vpcId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getVpcId() != null) {
                    data.set("vpcId", om.valueToTree(this.getVpcId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnAccessPoint.VpcConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcConfigurationProperty.Jsii$Proxy that = (VpcConfigurationProperty.Jsii$Proxy) o;

                return this.vpcId != null ? this.vpcId.equals(that.vpcId) : that.vpcId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.vpcId != null ? this.vpcId.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.s3.CfnAccessPoint}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.s3.CfnAccessPoint> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.s3.CfnAccessPointProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.s3.CfnAccessPointProps.Builder();
        }

        /**
         * The name of the bucket associated with this access point.
         * <p>
         * @return {@code this}
         * @param bucket The name of the bucket associated with this access point. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(final java.lang.String bucket) {
            this.props.bucket(bucket);
            return this;
        }

        /**
         * The name of this access point.
         * <p>
         * If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the access point name.
         * <p>
         * @return {@code this}
         * @param name The name of this access point. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The access point policy associated with this access point.
         * <p>
         * @return {@code this}
         * @param policy The access point policy associated with this access point. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(final java.lang.Object policy) {
            this.props.policy(policy);
            return this;
        }

        /**
         * The container element for a bucket's policy status.
         * <p>
         * @return {@code this}
         * @param policyStatus The container element for a bucket's policy status. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyStatus(final java.lang.Object policyStatus) {
            this.props.policyStatus(policyStatus);
            return this;
        }

        /**
         * The PublicAccessBlock configuration that you want to apply to this Amazon S3 bucket.
         * <p>
         * You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <em>Amazon S3 User Guide</em> .
         * <p>
         * @return {@code this}
         * @param publicAccessBlockConfiguration The PublicAccessBlock configuration that you want to apply to this Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicAccessBlockConfiguration(final software.amazon.awscdk.core.IResolvable publicAccessBlockConfiguration) {
            this.props.publicAccessBlockConfiguration(publicAccessBlockConfiguration);
            return this;
        }
        /**
         * The PublicAccessBlock configuration that you want to apply to this Amazon S3 bucket.
         * <p>
         * You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <em>Amazon S3 User Guide</em> .
         * <p>
         * @return {@code this}
         * @param publicAccessBlockConfiguration The PublicAccessBlock configuration that you want to apply to this Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicAccessBlockConfiguration(final software.amazon.awscdk.services.s3.CfnAccessPoint.PublicAccessBlockConfigurationProperty publicAccessBlockConfiguration) {
            this.props.publicAccessBlockConfiguration(publicAccessBlockConfiguration);
            return this;
        }

        /**
         * The Virtual Private Cloud (VPC) configuration for this access point, if one exists.
         * <p>
         * @return {@code this}
         * @param vpcConfiguration The Virtual Private Cloud (VPC) configuration for this access point, if one exists. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfiguration(final software.amazon.awscdk.core.IResolvable vpcConfiguration) {
            this.props.vpcConfiguration(vpcConfiguration);
            return this;
        }
        /**
         * The Virtual Private Cloud (VPC) configuration for this access point, if one exists.
         * <p>
         * @return {@code this}
         * @param vpcConfiguration The Virtual Private Cloud (VPC) configuration for this access point, if one exists. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfiguration(final software.amazon.awscdk.services.s3.CfnAccessPoint.VpcConfigurationProperty vpcConfiguration) {
            this.props.vpcConfiguration(vpcConfiguration);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.s3.CfnAccessPoint}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.s3.CfnAccessPoint build() {
            return new software.amazon.awscdk.services.s3.CfnAccessPoint(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
