package software.amazon.awscdk.services.s3;

/**
 * Rule that define when a redirect is applied and the redirect behavior.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3.*;
 * ReplaceKey replaceKey;
 * RoutingRule routingRule = RoutingRule.builder()
 *         .condition(RoutingRuleCondition.builder()
 *                 .httpErrorCodeReturnedEquals("httpErrorCodeReturnedEquals")
 *                 .keyPrefixEquals("keyPrefixEquals")
 *                 .build())
 *         .hostName("hostName")
 *         .httpRedirectCode("httpRedirectCode")
 *         .protocol(RedirectProtocol.HTTP)
 *         .replaceKey(replaceKey)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.58.0 (build f8ba112)", date = "2022-05-13T01:13:31.635Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.RoutingRule")
@software.amazon.jsii.Jsii.Proxy(RoutingRule.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RoutingRule extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies a condition that must be met for the specified redirect to apply.
     * <p>
     * Default: - No condition
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.RoutingRuleCondition getCondition() {
        return null;
    }

    /**
     * The host name to use in the redirect request.
     * <p>
     * Default: - The host name used in the original request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHostName() {
        return null;
    }

    /**
     * The HTTP redirect code to use on the response.
     * <p>
     * Default: "301" - Moved Permanently
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHttpRedirectCode() {
        return null;
    }

    /**
     * Protocol to use when redirecting requests.
     * <p>
     * Default: - The protocol used in the original request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.RedirectProtocol getProtocol() {
        return null;
    }

    /**
     * Specifies the object key prefix to use in the redirect request.
     * <p>
     * Default: - The key will not be replaced
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.ReplaceKey getReplaceKey() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RoutingRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RoutingRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RoutingRule> {
        software.amazon.awscdk.services.s3.RoutingRuleCondition condition;
        java.lang.String hostName;
        java.lang.String httpRedirectCode;
        software.amazon.awscdk.services.s3.RedirectProtocol protocol;
        software.amazon.awscdk.services.s3.ReplaceKey replaceKey;

        /**
         * Sets the value of {@link RoutingRule#getCondition}
         * @param condition Specifies a condition that must be met for the specified redirect to apply.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder condition(software.amazon.awscdk.services.s3.RoutingRuleCondition condition) {
            this.condition = condition;
            return this;
        }

        /**
         * Sets the value of {@link RoutingRule#getHostName}
         * @param hostName The host name to use in the redirect request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostName(java.lang.String hostName) {
            this.hostName = hostName;
            return this;
        }

        /**
         * Sets the value of {@link RoutingRule#getHttpRedirectCode}
         * @param httpRedirectCode The HTTP redirect code to use on the response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpRedirectCode(java.lang.String httpRedirectCode) {
            this.httpRedirectCode = httpRedirectCode;
            return this;
        }

        /**
         * Sets the value of {@link RoutingRule#getProtocol}
         * @param protocol Protocol to use when redirecting requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(software.amazon.awscdk.services.s3.RedirectProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link RoutingRule#getReplaceKey}
         * @param replaceKey Specifies the object key prefix to use in the redirect request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replaceKey(software.amazon.awscdk.services.s3.ReplaceKey replaceKey) {
            this.replaceKey = replaceKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RoutingRule}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RoutingRule build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RoutingRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RoutingRule {
        private final software.amazon.awscdk.services.s3.RoutingRuleCondition condition;
        private final java.lang.String hostName;
        private final java.lang.String httpRedirectCode;
        private final software.amazon.awscdk.services.s3.RedirectProtocol protocol;
        private final software.amazon.awscdk.services.s3.ReplaceKey replaceKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.RoutingRuleCondition.class));
            this.hostName = software.amazon.jsii.Kernel.get(this, "hostName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.httpRedirectCode = software.amazon.jsii.Kernel.get(this, "httpRedirectCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.RedirectProtocol.class));
            this.replaceKey = software.amazon.jsii.Kernel.get(this, "replaceKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.ReplaceKey.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.condition = builder.condition;
            this.hostName = builder.hostName;
            this.httpRedirectCode = builder.httpRedirectCode;
            this.protocol = builder.protocol;
            this.replaceKey = builder.replaceKey;
        }

        @Override
        public final software.amazon.awscdk.services.s3.RoutingRuleCondition getCondition() {
            return this.condition;
        }

        @Override
        public final java.lang.String getHostName() {
            return this.hostName;
        }

        @Override
        public final java.lang.String getHttpRedirectCode() {
            return this.httpRedirectCode;
        }

        @Override
        public final software.amazon.awscdk.services.s3.RedirectProtocol getProtocol() {
            return this.protocol;
        }

        @Override
        public final software.amazon.awscdk.services.s3.ReplaceKey getReplaceKey() {
            return this.replaceKey;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCondition() != null) {
                data.set("condition", om.valueToTree(this.getCondition()));
            }
            if (this.getHostName() != null) {
                data.set("hostName", om.valueToTree(this.getHostName()));
            }
            if (this.getHttpRedirectCode() != null) {
                data.set("httpRedirectCode", om.valueToTree(this.getHttpRedirectCode()));
            }
            if (this.getProtocol() != null) {
                data.set("protocol", om.valueToTree(this.getProtocol()));
            }
            if (this.getReplaceKey() != null) {
                data.set("replaceKey", om.valueToTree(this.getReplaceKey()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.RoutingRule"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RoutingRule.Jsii$Proxy that = (RoutingRule.Jsii$Proxy) o;

            if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) return false;
            if (this.hostName != null ? !this.hostName.equals(that.hostName) : that.hostName != null) return false;
            if (this.httpRedirectCode != null ? !this.httpRedirectCode.equals(that.httpRedirectCode) : that.httpRedirectCode != null) return false;
            if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
            return this.replaceKey != null ? this.replaceKey.equals(that.replaceKey) : that.replaceKey == null;
        }

        @Override
        public final int hashCode() {
            int result = this.condition != null ? this.condition.hashCode() : 0;
            result = 31 * result + (this.hostName != null ? this.hostName.hashCode() : 0);
            result = 31 * result + (this.httpRedirectCode != null ? this.httpRedirectCode.hashCode() : 0);
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            result = 31 * result + (this.replaceKey != null ? this.replaceKey.hashCode() : 0);
            return result;
        }
    }
}
