package software.amazon.awscdk.services.s3;

/**
 * Options for creating a Transfer Acceleration URL.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3.*;
 * TransferAccelerationUrlOptions transferAccelerationUrlOptions = TransferAccelerationUrlOptions.builder()
 *         .dualStack(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.58.0 (build f8ba112)", date = "2022-05-20T22:19:58.218Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.TransferAccelerationUrlOptions")
@software.amazon.jsii.Jsii.Proxy(TransferAccelerationUrlOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TransferAccelerationUrlOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Dual-stack support to connect to the bucket over IPv6.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDualStack() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TransferAccelerationUrlOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TransferAccelerationUrlOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TransferAccelerationUrlOptions> {
        java.lang.Boolean dualStack;

        /**
         * Sets the value of {@link TransferAccelerationUrlOptions#getDualStack}
         * @param dualStack Dual-stack support to connect to the bucket over IPv6.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dualStack(java.lang.Boolean dualStack) {
            this.dualStack = dualStack;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TransferAccelerationUrlOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TransferAccelerationUrlOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TransferAccelerationUrlOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransferAccelerationUrlOptions {
        private final java.lang.Boolean dualStack;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dualStack = software.amazon.jsii.Kernel.get(this, "dualStack", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dualStack = builder.dualStack;
        }

        @Override
        public final java.lang.Boolean getDualStack() {
            return this.dualStack;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDualStack() != null) {
                data.set("dualStack", om.valueToTree(this.getDualStack()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.TransferAccelerationUrlOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TransferAccelerationUrlOptions.Jsii$Proxy that = (TransferAccelerationUrlOptions.Jsii$Proxy) o;

            return this.dualStack != null ? this.dualStack.equals(that.dualStack) : that.dualStack == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dualStack != null ? this.dualStack.hashCode() : 0;
            return result;
        }
    }
}
