package software.amazon.awscdk.services.s3;

/**
 * Describes when an object transitions to a specified storage class.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.4 (build 96d89e1)", date = "2019-11-12T11:54:44.206Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.Transition")
@software.amazon.jsii.Jsii.Proxy(Transition.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface Transition extends software.amazon.jsii.JsiiSerializable {

    /**
     * The storage class to which you want the object to transition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.s3.StorageClass getStorageClass();

    /**
     * Indicates the number of days after creation when objects are transitioned to the specified storage class.
     * 
     * Default: No transition count.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.core.Duration getTransitionAfter() {
        return null;
    }

    /**
     * Indicates when objects are transitioned to the specified storage class.
     * 
     * The date value must be in ISO 8601 format. The time is always midnight UTC.
     * 
     * Default: No transition date.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.time.Instant getTransitionDate() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Transition}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Transition}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.services.s3.StorageClass storageClass;
        private software.amazon.awscdk.core.Duration transitionAfter;
        private java.time.Instant transitionDate;

        /**
         * Sets the value of StorageClass
         * @param storageClass The storage class to which you want the object to transition. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageClass(software.amazon.awscdk.services.s3.StorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        /**
         * Sets the value of TransitionAfter
         * @param transitionAfter Indicates the number of days after creation when objects are transitioned to the specified storage class.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitionAfter(software.amazon.awscdk.core.Duration transitionAfter) {
            this.transitionAfter = transitionAfter;
            return this;
        }

        /**
         * Sets the value of TransitionDate
         * @param transitionDate Indicates when objects are transitioned to the specified storage class.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitionDate(java.time.Instant transitionDate) {
            this.transitionDate = transitionDate;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Transition}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Transition build() {
            return new Jsii$Proxy(storageClass, transitionAfter, transitionDate);
        }
    }

    /**
     * An implementation for {@link Transition}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Transition {
        private final software.amazon.awscdk.services.s3.StorageClass storageClass;
        private final software.amazon.awscdk.core.Duration transitionAfter;
        private final java.time.Instant transitionDate;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.storageClass = this.jsiiGet("storageClass", software.amazon.awscdk.services.s3.StorageClass.class);
            this.transitionAfter = this.jsiiGet("transitionAfter", software.amazon.awscdk.core.Duration.class);
            this.transitionDate = this.jsiiGet("transitionDate", java.time.Instant.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.s3.StorageClass storageClass, final software.amazon.awscdk.core.Duration transitionAfter, final java.time.Instant transitionDate) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.storageClass = java.util.Objects.requireNonNull(storageClass, "storageClass is required");
            this.transitionAfter = transitionAfter;
            this.transitionDate = transitionDate;
        }

        @Override
        public software.amazon.awscdk.services.s3.StorageClass getStorageClass() {
            return this.storageClass;
        }

        @Override
        public software.amazon.awscdk.core.Duration getTransitionAfter() {
            return this.transitionAfter;
        }

        @Override
        public java.time.Instant getTransitionDate() {
            return this.transitionDate;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("storageClass", om.valueToTree(this.getStorageClass()));
            if (this.getTransitionAfter() != null) {
                data.set("transitionAfter", om.valueToTree(this.getTransitionAfter()));
            }
            if (this.getTransitionDate() != null) {
                data.set("transitionDate", om.valueToTree(this.getTransitionDate()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.Transition"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Transition.Jsii$Proxy that = (Transition.Jsii$Proxy) o;

            if (!storageClass.equals(that.storageClass)) return false;
            if (this.transitionAfter != null ? !this.transitionAfter.equals(that.transitionAfter) : that.transitionAfter != null) return false;
            return this.transitionDate != null ? this.transitionDate.equals(that.transitionDate) : that.transitionDate == null;
        }

        @Override
        public int hashCode() {
            int result = this.storageClass.hashCode();
            result = 31 * result + (this.transitionAfter != null ? this.transitionAfter.hashCode() : 0);
            result = 31 * result + (this.transitionDate != null ? this.transitionDate.hashCode() : 0);
            return result;
        }
    }
}
