package software.amazon.awscdk.services.s3;

/**
 * All supported inventory frequencies.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket inventoryBucket = new Bucket(this, "InventoryBucket");
 * Bucket dataBucket = Bucket.Builder.create(this, "DataBucket")
 *         .inventories(List.of(Inventory.builder()
 *                 .frequency(InventoryFrequency.DAILY)
 *                 .includeObjectVersions(InventoryObjectVersion.CURRENT)
 *                 .destination(InventoryDestination.builder()
 *                         .bucket(inventoryBucket)
 *                         .build())
 *                 .build(), Inventory.builder()
 *                 .frequency(InventoryFrequency.WEEKLY)
 *                 .includeObjectVersions(InventoryObjectVersion.ALL)
 *                 .destination(InventoryDestination.builder()
 *                         .bucket(inventoryBucket)
 *                         .prefix("with-all-versions")
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.65.0 (build 7a02b7f)", date = "2022-08-25T20:40:34.259Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.InventoryFrequency")
public enum InventoryFrequency {
    /**
     * A report is generated every day.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DAILY,
    /**
     * A report is generated every Sunday (UTC timezone) after the initial report.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WEEKLY,
}
