package software.amazon.awscdk.services.s3;

/**
 * Options for the onCloudTrailPutObject method.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.events.*;
 * import software.amazon.awscdk.services.s3.*;
 * Object detail;
 * IRuleTarget ruleTarget;
 * OnCloudTrailBucketEventOptions onCloudTrailBucketEventOptions = OnCloudTrailBucketEventOptions.builder()
 *         .description("description")
 *         .eventPattern(EventPattern.builder()
 *                 .account(List.of("account"))
 *                 .detail(Map.of(
 *                         "detailKey", detail))
 *                 .detailType(List.of("detailType"))
 *                 .id(List.of("id"))
 *                 .region(List.of("region"))
 *                 .resources(List.of("resources"))
 *                 .source(List.of("source"))
 *                 .time(List.of("time"))
 *                 .version(List.of("version"))
 *                 .build())
 *         .paths(List.of("paths"))
 *         .ruleName("ruleName")
 *         .target(ruleTarget)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:39.709Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.OnCloudTrailBucketEventOptions")
@software.amazon.jsii.Jsii.Proxy(OnCloudTrailBucketEventOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OnCloudTrailBucketEventOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.events.OnEventOptions {

    /**
     * Only watch changes to these object paths.
     * <p>
     * Default: - Watch changes to all objects
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPaths() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link OnCloudTrailBucketEventOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OnCloudTrailBucketEventOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OnCloudTrailBucketEventOptions> {
        java.util.List<java.lang.String> paths;
        java.lang.String description;
        software.amazon.awscdk.services.events.EventPattern eventPattern;
        java.lang.String ruleName;
        software.amazon.awscdk.services.events.IRuleTarget target;

        /**
         * Sets the value of {@link OnCloudTrailBucketEventOptions#getPaths}
         * @param paths Only watch changes to these object paths.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder paths(java.util.List<java.lang.String> paths) {
            this.paths = paths;
            return this;
        }

        /**
         * Sets the value of {@link OnCloudTrailBucketEventOptions#getDescription}
         * @param description A description of the rule's purpose.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link OnCloudTrailBucketEventOptions#getEventPattern}
         * @param eventPattern Additional restrictions for the event to route to the specified target.
         *                     The method that generates the rule probably imposes some type of event
         *                     filtering. The filtering implied by what you pass here is added
         *                     on top of that filtering.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventPattern(software.amazon.awscdk.services.events.EventPattern eventPattern) {
            this.eventPattern = eventPattern;
            return this;
        }

        /**
         * Sets the value of {@link OnCloudTrailBucketEventOptions#getRuleName}
         * @param ruleName A name for the rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleName(java.lang.String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        /**
         * Sets the value of {@link OnCloudTrailBucketEventOptions#getTarget}
         * @param target The target to register for the event.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(software.amazon.awscdk.services.events.IRuleTarget target) {
            this.target = target;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OnCloudTrailBucketEventOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OnCloudTrailBucketEventOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OnCloudTrailBucketEventOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OnCloudTrailBucketEventOptions {
        private final java.util.List<java.lang.String> paths;
        private final java.lang.String description;
        private final software.amazon.awscdk.services.events.EventPattern eventPattern;
        private final java.lang.String ruleName;
        private final software.amazon.awscdk.services.events.IRuleTarget target;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.paths = software.amazon.jsii.Kernel.get(this, "paths", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.eventPattern = software.amazon.jsii.Kernel.get(this, "eventPattern", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.EventPattern.class));
            this.ruleName = software.amazon.jsii.Kernel.get(this, "ruleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.IRuleTarget.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.paths = builder.paths;
            this.description = builder.description;
            this.eventPattern = builder.eventPattern;
            this.ruleName = builder.ruleName;
            this.target = builder.target;
        }

        @Override
        public final java.util.List<java.lang.String> getPaths() {
            return this.paths;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.services.events.EventPattern getEventPattern() {
            return this.eventPattern;
        }

        @Override
        public final java.lang.String getRuleName() {
            return this.ruleName;
        }

        @Override
        public final software.amazon.awscdk.services.events.IRuleTarget getTarget() {
            return this.target;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPaths() != null) {
                data.set("paths", om.valueToTree(this.getPaths()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEventPattern() != null) {
                data.set("eventPattern", om.valueToTree(this.getEventPattern()));
            }
            if (this.getRuleName() != null) {
                data.set("ruleName", om.valueToTree(this.getRuleName()));
            }
            if (this.getTarget() != null) {
                data.set("target", om.valueToTree(this.getTarget()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.OnCloudTrailBucketEventOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OnCloudTrailBucketEventOptions.Jsii$Proxy that = (OnCloudTrailBucketEventOptions.Jsii$Proxy) o;

            if (this.paths != null ? !this.paths.equals(that.paths) : that.paths != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.eventPattern != null ? !this.eventPattern.equals(that.eventPattern) : that.eventPattern != null) return false;
            if (this.ruleName != null ? !this.ruleName.equals(that.ruleName) : that.ruleName != null) return false;
            return this.target != null ? this.target.equals(that.target) : that.target == null;
        }

        @Override
        public final int hashCode() {
            int result = this.paths != null ? this.paths.hashCode() : 0;
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.eventPattern != null ? this.eventPattern.hashCode() : 0);
            result = 31 * result + (this.ruleName != null ? this.ruleName.hashCode() : 0);
            result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
            return result;
        }
    }
}
