package software.amazon.awscdk.services.s3;

/**
 * An S3 bucket with associated policy objects.
 * 
 * <p>This bucket does not yet have all features that exposed by the underlying
 * BucketResource.</p>
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.11 (build d4fd44f)", date = "2019-12-17T13:05:38.799Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.Bucket")
public class Bucket extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.s3.IBucket {

    protected Bucket(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Bucket(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Bucket(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.s3.BucketProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Bucket(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param bucketArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.s3.IBucket fromBucketArn(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final java.lang.String bucketArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.Bucket.class, "fromBucketArn", software.amazon.awscdk.services.s3.IBucket.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(bucketArn, "bucketArn is required") });
    }

    /**
     * Creates a Bucket construct that represents an external bucket.
     * 
     * @param scope The parent creating construct (usually `this`). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param attrs A `BucketAttributes` object. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.s3.IBucket fromBucketAttributes(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.s3.BucketAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.Bucket.class, "fromBucketAttributes", software.amazon.awscdk.services.s3.IBucket.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param bucketName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.s3.IBucket fromBucketName(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final java.lang.String bucketName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.Bucket.class, "fromBucketName", software.amazon.awscdk.services.s3.IBucket.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(bucketName, "bucketName is required") });
    }

    /**
     * Adds a cross-origin access configuration for objects in an Amazon S3 bucket.
     * 
     * @param rule The CORS configuration rule to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addCorsRule(final software.amazon.awscdk.services.s3.CorsRule rule) {
        this.jsiiCall("addCorsRule", Void.class, new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
    }

    /**
     * Adds a bucket notification event destination.
     * 
     * Example:
     * 
     * <blockquote><pre>{@code
     * // This example is in TypeScript, examples in Java are coming soon.
     *    bucket.addEventNotification(EventType.OnObjectCreated, myLambda, 'home/myusername/*')
     * }</pre></blockquote>
     * 
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html
     * @param event The event to trigger the notification. This parameter is required.
     * @param dest The notification destination (Lambda, SNS Topic or SQS Queue). This parameter is required.
     * @param filters S3 object key filter rules to determine which objects trigger this event. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addEventNotification(final software.amazon.awscdk.services.s3.EventType event, final software.amazon.awscdk.services.s3.IBucketNotificationDestination dest, final software.amazon.awscdk.services.s3.NotificationKeyFilter... filters) {
        this.jsiiCall("addEventNotification", Void.class, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(event, "event is required"), java.util.Objects.requireNonNull(dest, "dest is required") }), java.util.Arrays.<Object>stream(filters)).toArray(Object[]::new));
    }

    /**
     * Add a lifecycle rule to the bucket.
     * 
     * @param rule The rule to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addLifecycleRule(final software.amazon.awscdk.services.s3.LifecycleRule rule) {
        this.jsiiCall("addLifecycleRule", Void.class, new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
    }

    /**
     * Adds a metrics configuration for the CloudWatch request metrics from the bucket.
     * 
     * @param metric The metric configuration to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addMetric(final software.amazon.awscdk.services.s3.BucketMetrics metric) {
        this.jsiiCall("addMetric", Void.class, new Object[] { java.util.Objects.requireNonNull(metric, "metric is required") });
    }

    /**
     * Subscribes a destination to receive notificatins when an object is created in the bucket.
     * 
     * <p>This is identical to calling
     * <code>onEvent(EventType.ObjectCreated)</code>.</p>
     * 
     * @param dest The notification destination (see onEvent). This parameter is required.
     * @param filters Filters (see onEvent). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addObjectCreatedNotification(final software.amazon.awscdk.services.s3.IBucketNotificationDestination dest, final software.amazon.awscdk.services.s3.NotificationKeyFilter... filters) {
        this.jsiiCall("addObjectCreatedNotification", Void.class, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(dest, "dest is required") }), java.util.Arrays.<Object>stream(filters)).toArray(Object[]::new));
    }

    /**
     * Subscribes a destination to receive notificatins when an object is removed from the bucket.
     * 
     * <p>This is identical to calling
     * <code>onEvent(EventType.ObjectRemoved)</code>.</p>
     * 
     * @param dest The notification destination (see onEvent). This parameter is required.
     * @param filters Filters (see onEvent). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addObjectRemovedNotification(final software.amazon.awscdk.services.s3.IBucketNotificationDestination dest, final software.amazon.awscdk.services.s3.NotificationKeyFilter... filters) {
        this.jsiiCall("addObjectRemovedNotification", Void.class, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(dest, "dest is required") }), java.util.Arrays.<Object>stream(filters)).toArray(Object[]::new));
    }

    /**
     * Adds a statement to the resource policy for a principal (i.e. account/role/service) to perform actions on this bucket and/or it's contents. Use `bucketArn` and `arnForObjects(keys)` to obtain ARNs for this bucket or objects.
     * 
     * @param permission This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addToResourcePolicy(final software.amazon.awscdk.services.iam.PolicyStatement permission) {
        this.jsiiCall("addToResourcePolicy", Void.class, new Object[] { java.util.Objects.requireNonNull(permission, "permission is required") });
    }

    /**
     * Returns an ARN that represents all objects within the bucket that match the key pattern specified.
     * 
     * <p>To represent all keys, specify <code>&quot;*&quot;</code>.</p>
     * <p>If you specify multiple components for keyPattern, they will be concatenated::</p>
     * <p>arnForObjects('home/', team, '/', user, '/*')</p>
     * 
     * @param keyPattern This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public java.lang.String arnForObjects(final java.lang.String keyPattern) {
        return this.jsiiCall("arnForObjects", java.lang.String.class, new Object[] { java.util.Objects.requireNonNull(keyPattern, "keyPattern is required") });
    }

    /**
     * Grants s3:DeleteObject* permission to an IAM pricipal for objects in this bucket.
     * 
     * @param identity The principal. This parameter is required.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.iam.Grant grantDelete(final software.amazon.awscdk.services.iam.IGrantable identity, final java.lang.Object objectsKeyPattern) {
        return this.jsiiCall("grantDelete", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
    }

    /**
     * Grants s3:DeleteObject* permission to an IAM pricipal for objects in this bucket.
     * 
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.iam.Grant grantDelete(final software.amazon.awscdk.services.iam.IGrantable identity) {
        return this.jsiiCall("grantDelete", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Allows unrestricted access to objects from this bucket.
     * 
     * <p>IMPORTANT: This permission allows anyone to perform actions on S3 objects
     * in this bucket, which is useful for when you configure your bucket as a
     * website and want everyone to be able to read objects in the bucket without
     * needing to authenticate.</p>
     * <p>Without arguments, this method will grant read (&quot;s3:GetObject&quot;) access to
     * all objects (&quot;*&quot;) in the bucket.</p>
     * <p>The method returns the <code>iam.Grant</code> object, which can then be modified
     * as needed. For example, you can add a condition that will restrict access only
     * to an IPv4 range like this:</p>
     * <pre><code> const grant = bucket.grantPublicAccess();
     *  grant.resourceStatement!.addCondition(‘IpAddress’, { “aws:SourceIp”: “54.240.143.0/24” });
     * </code></pre>
     * 
     * @param keyPrefix the prefix of S3 object keys (e.g. `home/*`). Default is "*".
     * @param allowedActions the set of S3 actions to allow. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.iam.Grant grantPublicAccess(final java.lang.String keyPrefix, final java.lang.String... allowedActions) {
        return this.jsiiCall("grantPublicAccess", software.amazon.awscdk.services.iam.Grant.class, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { keyPrefix }), java.util.Arrays.<Object>stream(allowedActions)).toArray(Object[]::new));
    }

    /**
     * Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.
     * 
     * <p>If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.</p>
     * 
     * @param identity The principal. This parameter is required.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.iam.Grant grantPut(final software.amazon.awscdk.services.iam.IGrantable identity, final java.lang.Object objectsKeyPattern) {
        return this.jsiiCall("grantPut", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
    }

    /**
     * Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.
     * 
     * <p>If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.</p>
     * 
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.iam.Grant grantPut(final software.amazon.awscdk.services.iam.IGrantable identity) {
        return this.jsiiCall("grantPut", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * 
     * <p>If encryption is used, permission to use the key to decrypt the contents
     * of the bucket will also be granted to the same principal.</p>
     * 
     * @param identity The principal. This parameter is required.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.iam.Grant grantRead(final software.amazon.awscdk.services.iam.IGrantable identity, final java.lang.Object objectsKeyPattern) {
        return this.jsiiCall("grantRead", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
    }

    /**
     * Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * 
     * <p>If encryption is used, permission to use the key to decrypt the contents
     * of the bucket will also be granted to the same principal.</p>
     * 
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.iam.Grant grantRead(final software.amazon.awscdk.services.iam.IGrantable identity) {
        return this.jsiiCall("grantRead", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * 
     * <p>If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.</p>
     * 
     * @param identity The principal. This parameter is required.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.iam.Grant grantReadWrite(final software.amazon.awscdk.services.iam.IGrantable identity, final java.lang.Object objectsKeyPattern) {
        return this.jsiiCall("grantReadWrite", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
    }

    /**
     * Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * 
     * <p>If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.</p>
     * 
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.iam.Grant grantReadWrite(final software.amazon.awscdk.services.iam.IGrantable identity) {
        return this.jsiiCall("grantReadWrite", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Grant write permissions to this bucket to an IAM principal.
     * 
     * <p>If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.</p>
     * 
     * @param identity The principal. This parameter is required.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.iam.Grant grantWrite(final software.amazon.awscdk.services.iam.IGrantable identity, final java.lang.Object objectsKeyPattern) {
        return this.jsiiCall("grantWrite", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
    }

    /**
     * Grant write permissions to this bucket to an IAM principal.
     * 
     * <p>If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.</p>
     * 
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.iam.Grant grantWrite(final software.amazon.awscdk.services.iam.IGrantable identity) {
        return this.jsiiCall("grantWrite", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Define a CloudWatch event that triggers when something happens to this repository.
     * 
     * <p>Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.</p>
     * 
     * @param id The id of the rule. This parameter is required.
     * @param options Options for adding the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.events.Rule onCloudTrailEvent(final java.lang.String id, final software.amazon.awscdk.services.s3.OnCloudTrailBucketEventOptions options) {
        return this.jsiiCall("onCloudTrailEvent", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Define a CloudWatch event that triggers when something happens to this repository.
     * 
     * <p>Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.</p>
     * 
     * @param id The id of the rule. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.events.Rule onCloudTrailEvent(final java.lang.String id) {
        return this.jsiiCall("onCloudTrailEvent", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines an AWS CloudWatch event that triggers when an object is uploaded to the specified paths (keys) in this bucket using the PutObject API call.
     * 
     * <p>Note that some tools like <code>aws s3 cp</code> will automatically use either
     * PutObject or the multipart upload API depending on the file size,
     * so using <code>onCloudTrailWriteObject</code> may be preferable.</p>
     * <p>Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.</p>
     * 
     * @param id The id of the rule. This parameter is required.
     * @param options Options for adding the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.events.Rule onCloudTrailPutObject(final java.lang.String id, final software.amazon.awscdk.services.s3.OnCloudTrailBucketEventOptions options) {
        return this.jsiiCall("onCloudTrailPutObject", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines an AWS CloudWatch event that triggers when an object is uploaded to the specified paths (keys) in this bucket using the PutObject API call.
     * 
     * <p>Note that some tools like <code>aws s3 cp</code> will automatically use either
     * PutObject or the multipart upload API depending on the file size,
     * so using <code>onCloudTrailWriteObject</code> may be preferable.</p>
     * <p>Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.</p>
     * 
     * @param id The id of the rule. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.events.Rule onCloudTrailPutObject(final java.lang.String id) {
        return this.jsiiCall("onCloudTrailPutObject", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines an AWS CloudWatch event that triggers when an object at the specified paths (keys) in this bucket are written to.
     * 
     * <p>This includes
     * the events PutObject, CopyObject, and CompleteMultipartUpload.</p>
     * <p>Note that some tools like <code>aws s3 cp</code> will automatically use either
     * PutObject or the multipart upload API depending on the file size,
     * so using this method may be preferable to <code>onCloudTrailPutObject</code>.</p>
     * <p>Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.</p>
     * 
     * @param id The id of the rule. This parameter is required.
     * @param options Options for adding the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.events.Rule onCloudTrailWriteObject(final java.lang.String id, final software.amazon.awscdk.services.s3.OnCloudTrailBucketEventOptions options) {
        return this.jsiiCall("onCloudTrailWriteObject", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines an AWS CloudWatch event that triggers when an object at the specified paths (keys) in this bucket are written to.
     * 
     * <p>This includes
     * the events PutObject, CopyObject, and CompleteMultipartUpload.</p>
     * <p>Note that some tools like <code>aws s3 cp</code> will automatically use either
     * PutObject or the multipart upload API depending on the file size,
     * so using this method may be preferable to <code>onCloudTrailPutObject</code>.</p>
     * <p>Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.</p>
     * 
     * @param id The id of the rule. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.events.Rule onCloudTrailWriteObject(final java.lang.String id) {
        return this.jsiiCall("onCloudTrailWriteObject", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * The https URL of an S3 object.
     * 
     * <p>For example:</p>
     * 
     * Example:
     * 
     * <blockquote><pre>{@code
     * // This example is in TypeScript, examples in Java are coming soon.
     * https://s3.cn-north-1.amazonaws.com.cn/china-bucket/mykey
     * }</pre></blockquote>
     * 
     * @return an ObjectS3Url token
     * @param key The S3 key of the object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public java.lang.String urlForObject(final java.lang.String key) {
        return this.jsiiCall("urlForObject", java.lang.String.class, new Object[] { key });
    }

    /**
     * The https URL of an S3 object.
     * 
     * <p>For example:</p>
     * 
     * Example:
     * 
     * <blockquote><pre>{@code
     * // This example is in TypeScript, examples in Java are coming soon.
     * https://s3.cn-north-1.amazonaws.com.cn/china-bucket/mykey
     * }</pre></blockquote>
     * 
     * @return an ObjectS3Url token
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public java.lang.String urlForObject() {
        return this.jsiiCall("urlForObject", java.lang.String.class);
    }

    /**
     * The ARN of the bucket.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getBucketArn() {
        return this.jsiiGet("bucketArn", java.lang.String.class);
    }

    /**
     * The IPv4 DNS name of the specified bucket.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getBucketDomainName() {
        return this.jsiiGet("bucketDomainName", java.lang.String.class);
    }

    /**
     * The IPv6 DNS name of the specified bucket.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getBucketDualStackDomainName() {
        return this.jsiiGet("bucketDualStackDomainName", java.lang.String.class);
    }

    /**
     * The name of the bucket.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getBucketName() {
        return this.jsiiGet("bucketName", java.lang.String.class);
    }

    /**
     * The regional domain name of the specified bucket.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getBucketRegionalDomainName() {
        return this.jsiiGet("bucketRegionalDomainName", java.lang.String.class);
    }

    /**
     * The Domain name of the static website.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getBucketWebsiteDomainName() {
        return this.jsiiGet("bucketWebsiteDomainName", java.lang.String.class);
    }

    /**
     * The URL of the static website.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getBucketWebsiteUrl() {
        return this.jsiiGet("bucketWebsiteUrl", java.lang.String.class);
    }

    /**
     * Optional KMS encryption key associated with this bucket.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.IKey.class);
    }

    /**
     * Indicates if a bucket resource policy should automatically created upon the first call to `addToResourcePolicy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected java.lang.Boolean getAutoCreatePolicy() {
        return this.jsiiGet("autoCreatePolicy", java.lang.Boolean.class);
    }

    /**
     * Indicates if a bucket resource policy should automatically created upon the first call to `addToResourcePolicy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setAutoCreatePolicy(final java.lang.Boolean value) {
        this.jsiiSet("autoCreatePolicy", java.util.Objects.requireNonNull(value, "autoCreatePolicy is required"));
    }

    /**
     * Whether to disallow public access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected java.lang.Boolean getDisallowPublicAccess() {
        return this.jsiiGet("disallowPublicAccess", java.lang.Boolean.class);
    }

    /**
     * Whether to disallow public access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setDisallowPublicAccess(final java.lang.Boolean value) {
        this.jsiiSet("disallowPublicAccess", value);
    }

    /**
     * The resource policy associated with this bucket.
     * 
     * <p>If <code>autoCreatePolicy</code> is true, a <code>BucketPolicy</code> will be created upon the
     * first call to addToResourcePolicy(s).</p>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.s3.BucketPolicy getPolicy() {
        return this.jsiiGet("policy", software.amazon.awscdk.services.s3.BucketPolicy.class);
    }

    /**
     * The resource policy associated with this bucket.
     * 
     * <p>If <code>autoCreatePolicy</code> is true, a <code>BucketPolicy</code> will be created upon the
     * first call to addToResourcePolicy(s).</p>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicy(final software.amazon.awscdk.services.s3.BucketPolicy value) {
        this.jsiiSet("policy", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.s3.Bucket}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.s3.BucketProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Specifies a canned ACL that grants predefined permissions to the bucket.
         * 
         * Default: BucketAccessControl.PRIVATE
         * 
         * @return {@code this}
         * @param accessControl Specifies a canned ACL that grants predefined permissions to the bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessControl(final software.amazon.awscdk.services.s3.BucketAccessControl accessControl) {
            this.props().accessControl(accessControl);
            return this;
        }

        /**
         * The block public access configuration of this bucket.
         * 
         * Default: false New buckets and objects don't allow public access, but users can modify bucket
         * policies or object permissions to allow public access.
         * 
         * @return {@code this}
         * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html
         * @param blockPublicAccess The block public access configuration of this bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockPublicAccess(final software.amazon.awscdk.services.s3.BlockPublicAccess blockPublicAccess) {
            this.props().blockPublicAccess(blockPublicAccess);
            return this;
        }

        /**
         * Physical name of this bucket.
         * 
         * Default: - Assigned by CloudFormation (recommended).
         * 
         * @return {@code this}
         * @param bucketName Physical name of this bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketName(final java.lang.String bucketName) {
            this.props().bucketName(bucketName);
            return this;
        }

        /**
         * The CORS configuration of this bucket.
         * 
         * Default: - No CORS configuration.
         * 
         * @return {@code this}
         * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html
         * @param cors The CORS configuration of this bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cors(final java.util.List<software.amazon.awscdk.services.s3.CorsRule> cors) {
            this.props().cors(cors);
            return this;
        }

        /**
         * The kind of server-side encryption to apply to this bucket.
         * 
         * <p>If you choose KMS, you can specify a KMS key via <code>encryptionKey</code>. If
         * encryption key is not specified, a key will automatically be created.</p>
         * 
         * Default: - `Kms` if `encryptionKey` is specified, or `Unencrypted` otherwise.
         * 
         * @return {@code this}
         * @param encryption The kind of server-side encryption to apply to this bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(final software.amazon.awscdk.services.s3.BucketEncryption encryption) {
            this.props().encryption(encryption);
            return this;
        }

        /**
         * External KMS key to use for bucket encryption.
         * 
         * <p>The 'encryption' property must be either not specified or set to &quot;Kms&quot;.
         * An error will be emitted if encryption is set to &quot;Unencrypted&quot; or
         * &quot;Managed&quot;.</p>
         * 
         * Default: - If encryption is set to "Kms" and this property is undefined,
         * a new KMS key will be created and associated with this bucket.
         * 
         * @return {@code this}
         * @param encryptionKey External KMS key to use for bucket encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(final software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.props().encryptionKey(encryptionKey);
            return this;
        }

        /**
         * Rules that define how Amazon S3 manages objects during their lifetime.
         * 
         * Default: - No lifecycle rules.
         * 
         * @return {@code this}
         * @param lifecycleRules Rules that define how Amazon S3 manages objects during their lifetime. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleRules(final java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> lifecycleRules) {
            this.props().lifecycleRules(lifecycleRules);
            return this;
        }

        /**
         * The metrics configuration of this bucket.
         * 
         * Default: - No metrics configuration.
         * 
         * @return {@code this}
         * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html
         * @param metrics The metrics configuration of this bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metrics(final java.util.List<software.amazon.awscdk.services.s3.BucketMetrics> metrics) {
            this.props().metrics(metrics);
            return this;
        }

        /**
         * Grants public read access to all objects in the bucket. Similar to calling `bucket.grantPublicAccess()`.
         * 
         * Default: false
         * 
         * @return {@code this}
         * @param publicReadAccess Grants public read access to all objects in the bucket. Similar to calling `bucket.grantPublicAccess()`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicReadAccess(final java.lang.Boolean publicReadAccess) {
            this.props().publicReadAccess(publicReadAccess);
            return this;
        }

        /**
         * Policy to apply when the bucket is removed from this stack.
         * 
         * Default: - The bucket will be orphaned.
         * 
         * @return {@code this}
         * @param removalPolicy Policy to apply when the bucket is removed from this stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.props().removalPolicy(removalPolicy);
            return this;
        }

        /**
         * Whether this bucket should have versioning turned on or not.
         * 
         * Default: false
         * 
         * @return {@code this}
         * @param versioned Whether this bucket should have versioning turned on or not. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versioned(final java.lang.Boolean versioned) {
            this.props().versioned(versioned);
            return this;
        }

        /**
         * The name of the error document (e.g. "404.html") for the website. `websiteIndexDocument` must also be set if this is set.
         * 
         * Default: - No error document.
         * 
         * @return {@code this}
         * @param websiteErrorDocument The name of the error document (e.g. "404.html") for the website. `websiteIndexDocument` must also be set if this is set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder websiteErrorDocument(final java.lang.String websiteErrorDocument) {
            this.props().websiteErrorDocument(websiteErrorDocument);
            return this;
        }

        /**
         * The name of the index document (e.g. "index.html") for the website. Enables static website hosting for this bucket.
         * 
         * Default: - No index document.
         * 
         * @return {@code this}
         * @param websiteIndexDocument The name of the index document (e.g. "index.html") for the website. Enables static website hosting for this bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder websiteIndexDocument(final java.lang.String websiteIndexDocument) {
            this.props().websiteIndexDocument(websiteIndexDocument);
            return this;
        }

        /**
         * Specifies the redirect behavior of all requests to a website endpoint of a bucket.
         * 
         * <p>If you specify this property, you can't specify &quot;websiteIndexDocument&quot;, &quot;websiteErrorDocument&quot; nor , &quot;websiteRoutingRules&quot;.</p>
         * 
         * Default: - No redirection.
         * 
         * @return {@code this}
         * @param websiteRedirect Specifies the redirect behavior of all requests to a website endpoint of a bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder websiteRedirect(final software.amazon.awscdk.services.s3.RedirectTarget websiteRedirect) {
            this.props().websiteRedirect(websiteRedirect);
            return this;
        }

        /**
         * Rules that define when a redirect is applied and the redirect behavior.
         * 
         * Default: - No redirection rules.
         * 
         * @return {@code this}
         * @param websiteRoutingRules Rules that define when a redirect is applied and the redirect behavior. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder websiteRoutingRules(final java.util.List<software.amazon.awscdk.services.s3.RoutingRule> websiteRoutingRules) {
            this.props().websiteRoutingRules(websiteRoutingRules);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.s3.Bucket}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.s3.Bucket build() {
            return new software.amazon.awscdk.services.s3.Bucket(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.s3.BucketProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.s3.BucketProps.Builder();
            }
            return this.props;
        }
    }
}
