package software.amazon.awscdk.services.s3;

/**
 * All http request methods.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket = Bucket.Builder.create(this, "MyRedirectedBucket")
 *         .websiteRoutingRules(List.of(RoutingRule.builder()
 *                 .hostName("www.example.com")
 *                 .httpRedirectCode("302")
 *                 .protocol(RedirectProtocol.HTTPS)
 *                 .replaceKey(ReplaceKey.prefixWith("test/"))
 *                 .condition(RoutingRuleCondition.builder()
 *                         .httpErrorCodeReturnedEquals("200")
 *                         .keyPrefixEquals("prefix")
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.73.0 (build 6faeda3)", date = "2023-01-31T18:36:52.018Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.RedirectProtocol")
public enum RedirectProtocol {
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTP,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTPS,
}
