package software.amazon.awscdk.services.s3;

/**
 * A reference to a bucket outside this stack.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function myLambda;
 * IBucket bucket = Bucket.fromBucketAttributes(this, "ImportedBucket", BucketAttributes.builder()
 *         .bucketArn("arn:aws:s3:::my-bucket")
 *         .build());
 * // now you can just call methods on the bucket
 * bucket.addEventNotification(EventType.OBJECT_CREATED, new LambdaDestination(myLambda), NotificationKeyFilter.builder().prefix("home/myusername/*").build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-02-21T19:24:03.830Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.BucketAttributes")
@software.amazon.jsii.Jsii.Proxy(BucketAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BucketAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The account this existing bucket belongs to.
     * <p>
     * Default: - it's assumed the bucket belongs to the same account as the scope it's being imported into
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAccount() {
        return null;
    }

    /**
     * The ARN of the bucket.
     * <p>
     * At least one of bucketArn or bucketName must be
     * defined in order to initialize a bucket ref.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBucketArn() {
        return null;
    }

    /**
     * The domain name of the bucket.
     * <p>
     * Default: Inferred from bucket name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBucketDomainName() {
        return null;
    }

    /**
     * The IPv6 DNS name of the specified bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBucketDualStackDomainName() {
        return null;
    }

    /**
     * The name of the bucket.
     * <p>
     * If the underlying value of ARN is a string, the
     * name will be parsed from the ARN. Otherwise, the name is optional, but
     * some features that require the bucket name such as auto-creating a bucket
     * policy, won't work.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBucketName() {
        return null;
    }

    /**
     * The regional domain name of the specified bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBucketRegionalDomainName() {
        return null;
    }

    /**
     * The format of the website URL of the bucket.
     * <p>
     * This should be true for
     * regions launched since 2014.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getBucketWebsiteNewUrlFormat() {
        return null;
    }

    /**
     * The website URL of the bucket (if static web hosting is enabled).
     * <p>
     * Default: Inferred from bucket name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBucketWebsiteUrl() {
        return null;
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * If this bucket has been configured for static website hosting.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIsWebsite() {
        return null;
    }

    /**
     * The role to be used by the notifications handler.
     * <p>
     * Default: - a new role will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getNotificationsHandlerRole() {
        return null;
    }

    /**
     * The region this existing bucket is in.
     * <p>
     * Default: - it's assumed the bucket is in the same region as the scope it's being imported into
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BucketAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BucketAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BucketAttributes> {
        java.lang.String account;
        java.lang.String bucketArn;
        java.lang.String bucketDomainName;
        java.lang.String bucketDualStackDomainName;
        java.lang.String bucketName;
        java.lang.String bucketRegionalDomainName;
        java.lang.Boolean bucketWebsiteNewUrlFormat;
        java.lang.String bucketWebsiteUrl;
        software.amazon.awscdk.services.kms.IKey encryptionKey;
        java.lang.Boolean isWebsite;
        software.amazon.awscdk.services.iam.IRole notificationsHandlerRole;
        java.lang.String region;

        /**
         * Sets the value of {@link BucketAttributes#getAccount}
         * @param account The account this existing bucket belongs to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder account(java.lang.String account) {
            this.account = account;
            return this;
        }

        /**
         * Sets the value of {@link BucketAttributes#getBucketArn}
         * @param bucketArn The ARN of the bucket.
         *                  At least one of bucketArn or bucketName must be
         *                  defined in order to initialize a bucket ref.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketArn(java.lang.String bucketArn) {
            this.bucketArn = bucketArn;
            return this;
        }

        /**
         * Sets the value of {@link BucketAttributes#getBucketDomainName}
         * @param bucketDomainName The domain name of the bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketDomainName(java.lang.String bucketDomainName) {
            this.bucketDomainName = bucketDomainName;
            return this;
        }

        /**
         * Sets the value of {@link BucketAttributes#getBucketDualStackDomainName}
         * @param bucketDualStackDomainName The IPv6 DNS name of the specified bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketDualStackDomainName(java.lang.String bucketDualStackDomainName) {
            this.bucketDualStackDomainName = bucketDualStackDomainName;
            return this;
        }

        /**
         * Sets the value of {@link BucketAttributes#getBucketName}
         * @param bucketName The name of the bucket.
         *                   If the underlying value of ARN is a string, the
         *                   name will be parsed from the ARN. Otherwise, the name is optional, but
         *                   some features that require the bucket name such as auto-creating a bucket
         *                   policy, won't work.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketName(java.lang.String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        /**
         * Sets the value of {@link BucketAttributes#getBucketRegionalDomainName}
         * @param bucketRegionalDomainName The regional domain name of the specified bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketRegionalDomainName(java.lang.String bucketRegionalDomainName) {
            this.bucketRegionalDomainName = bucketRegionalDomainName;
            return this;
        }

        /**
         * Sets the value of {@link BucketAttributes#getBucketWebsiteNewUrlFormat}
         * @param bucketWebsiteNewUrlFormat The format of the website URL of the bucket.
         *                                  This should be true for
         *                                  regions launched since 2014.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketWebsiteNewUrlFormat(java.lang.Boolean bucketWebsiteNewUrlFormat) {
            this.bucketWebsiteNewUrlFormat = bucketWebsiteNewUrlFormat;
            return this;
        }

        /**
         * Sets the value of {@link BucketAttributes#getBucketWebsiteUrl}
         * @param bucketWebsiteUrl The website URL of the bucket (if static web hosting is enabled).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketWebsiteUrl(java.lang.String bucketWebsiteUrl) {
            this.bucketWebsiteUrl = bucketWebsiteUrl;
            return this;
        }

        /**
         * Sets the value of {@link BucketAttributes#getEncryptionKey}
         * @param encryptionKey the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link BucketAttributes#getIsWebsite}
         * @param isWebsite If this bucket has been configured for static website hosting.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isWebsite(java.lang.Boolean isWebsite) {
            this.isWebsite = isWebsite;
            return this;
        }

        /**
         * Sets the value of {@link BucketAttributes#getNotificationsHandlerRole}
         * @param notificationsHandlerRole The role to be used by the notifications handler.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationsHandlerRole(software.amazon.awscdk.services.iam.IRole notificationsHandlerRole) {
            this.notificationsHandlerRole = notificationsHandlerRole;
            return this;
        }

        /**
         * Sets the value of {@link BucketAttributes#getRegion}
         * @param region The region this existing bucket is in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BucketAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BucketAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BucketAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BucketAttributes {
        private final java.lang.String account;
        private final java.lang.String bucketArn;
        private final java.lang.String bucketDomainName;
        private final java.lang.String bucketDualStackDomainName;
        private final java.lang.String bucketName;
        private final java.lang.String bucketRegionalDomainName;
        private final java.lang.Boolean bucketWebsiteNewUrlFormat;
        private final java.lang.String bucketWebsiteUrl;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final java.lang.Boolean isWebsite;
        private final software.amazon.awscdk.services.iam.IRole notificationsHandlerRole;
        private final java.lang.String region;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.account = software.amazon.jsii.Kernel.get(this, "account", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bucketArn = software.amazon.jsii.Kernel.get(this, "bucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bucketDomainName = software.amazon.jsii.Kernel.get(this, "bucketDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bucketDualStackDomainName = software.amazon.jsii.Kernel.get(this, "bucketDualStackDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bucketRegionalDomainName = software.amazon.jsii.Kernel.get(this, "bucketRegionalDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bucketWebsiteNewUrlFormat = software.amazon.jsii.Kernel.get(this, "bucketWebsiteNewUrlFormat", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.bucketWebsiteUrl = software.amazon.jsii.Kernel.get(this, "bucketWebsiteUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.isWebsite = software.amazon.jsii.Kernel.get(this, "isWebsite", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.notificationsHandlerRole = software.amazon.jsii.Kernel.get(this, "notificationsHandlerRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.account = builder.account;
            this.bucketArn = builder.bucketArn;
            this.bucketDomainName = builder.bucketDomainName;
            this.bucketDualStackDomainName = builder.bucketDualStackDomainName;
            this.bucketName = builder.bucketName;
            this.bucketRegionalDomainName = builder.bucketRegionalDomainName;
            this.bucketWebsiteNewUrlFormat = builder.bucketWebsiteNewUrlFormat;
            this.bucketWebsiteUrl = builder.bucketWebsiteUrl;
            this.encryptionKey = builder.encryptionKey;
            this.isWebsite = builder.isWebsite;
            this.notificationsHandlerRole = builder.notificationsHandlerRole;
            this.region = builder.region;
        }

        @Override
        public final java.lang.String getAccount() {
            return this.account;
        }

        @Override
        public final java.lang.String getBucketArn() {
            return this.bucketArn;
        }

        @Override
        public final java.lang.String getBucketDomainName() {
            return this.bucketDomainName;
        }

        @Override
        public final java.lang.String getBucketDualStackDomainName() {
            return this.bucketDualStackDomainName;
        }

        @Override
        public final java.lang.String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final java.lang.String getBucketRegionalDomainName() {
            return this.bucketRegionalDomainName;
        }

        @Override
        public final java.lang.Boolean getBucketWebsiteNewUrlFormat() {
            return this.bucketWebsiteNewUrlFormat;
        }

        @Override
        public final java.lang.String getBucketWebsiteUrl() {
            return this.bucketWebsiteUrl;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final java.lang.Boolean getIsWebsite() {
            return this.isWebsite;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getNotificationsHandlerRole() {
            return this.notificationsHandlerRole;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAccount() != null) {
                data.set("account", om.valueToTree(this.getAccount()));
            }
            if (this.getBucketArn() != null) {
                data.set("bucketArn", om.valueToTree(this.getBucketArn()));
            }
            if (this.getBucketDomainName() != null) {
                data.set("bucketDomainName", om.valueToTree(this.getBucketDomainName()));
            }
            if (this.getBucketDualStackDomainName() != null) {
                data.set("bucketDualStackDomainName", om.valueToTree(this.getBucketDualStackDomainName()));
            }
            if (this.getBucketName() != null) {
                data.set("bucketName", om.valueToTree(this.getBucketName()));
            }
            if (this.getBucketRegionalDomainName() != null) {
                data.set("bucketRegionalDomainName", om.valueToTree(this.getBucketRegionalDomainName()));
            }
            if (this.getBucketWebsiteNewUrlFormat() != null) {
                data.set("bucketWebsiteNewUrlFormat", om.valueToTree(this.getBucketWebsiteNewUrlFormat()));
            }
            if (this.getBucketWebsiteUrl() != null) {
                data.set("bucketWebsiteUrl", om.valueToTree(this.getBucketWebsiteUrl()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getIsWebsite() != null) {
                data.set("isWebsite", om.valueToTree(this.getIsWebsite()));
            }
            if (this.getNotificationsHandlerRole() != null) {
                data.set("notificationsHandlerRole", om.valueToTree(this.getNotificationsHandlerRole()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.BucketAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BucketAttributes.Jsii$Proxy that = (BucketAttributes.Jsii$Proxy) o;

            if (this.account != null ? !this.account.equals(that.account) : that.account != null) return false;
            if (this.bucketArn != null ? !this.bucketArn.equals(that.bucketArn) : that.bucketArn != null) return false;
            if (this.bucketDomainName != null ? !this.bucketDomainName.equals(that.bucketDomainName) : that.bucketDomainName != null) return false;
            if (this.bucketDualStackDomainName != null ? !this.bucketDualStackDomainName.equals(that.bucketDualStackDomainName) : that.bucketDualStackDomainName != null) return false;
            if (this.bucketName != null ? !this.bucketName.equals(that.bucketName) : that.bucketName != null) return false;
            if (this.bucketRegionalDomainName != null ? !this.bucketRegionalDomainName.equals(that.bucketRegionalDomainName) : that.bucketRegionalDomainName != null) return false;
            if (this.bucketWebsiteNewUrlFormat != null ? !this.bucketWebsiteNewUrlFormat.equals(that.bucketWebsiteNewUrlFormat) : that.bucketWebsiteNewUrlFormat != null) return false;
            if (this.bucketWebsiteUrl != null ? !this.bucketWebsiteUrl.equals(that.bucketWebsiteUrl) : that.bucketWebsiteUrl != null) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.isWebsite != null ? !this.isWebsite.equals(that.isWebsite) : that.isWebsite != null) return false;
            if (this.notificationsHandlerRole != null ? !this.notificationsHandlerRole.equals(that.notificationsHandlerRole) : that.notificationsHandlerRole != null) return false;
            return this.region != null ? this.region.equals(that.region) : that.region == null;
        }

        @Override
        public final int hashCode() {
            int result = this.account != null ? this.account.hashCode() : 0;
            result = 31 * result + (this.bucketArn != null ? this.bucketArn.hashCode() : 0);
            result = 31 * result + (this.bucketDomainName != null ? this.bucketDomainName.hashCode() : 0);
            result = 31 * result + (this.bucketDualStackDomainName != null ? this.bucketDualStackDomainName.hashCode() : 0);
            result = 31 * result + (this.bucketName != null ? this.bucketName.hashCode() : 0);
            result = 31 * result + (this.bucketRegionalDomainName != null ? this.bucketRegionalDomainName.hashCode() : 0);
            result = 31 * result + (this.bucketWebsiteNewUrlFormat != null ? this.bucketWebsiteNewUrlFormat.hashCode() : 0);
            result = 31 * result + (this.bucketWebsiteUrl != null ? this.bucketWebsiteUrl.hashCode() : 0);
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.isWebsite != null ? this.isWebsite.hashCode() : 0);
            result = 31 * result + (this.notificationsHandlerRole != null ? this.notificationsHandlerRole.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            return result;
        }
    }
}
