package software.amazon.awscdk.services.s3;

/**
 * A CloudFormation `AWS::S3::Bucket`.
 * <p>
 * The <code>AWS::S3::Bucket</code> resource creates an Amazon S3 bucket in the same AWS Region where you create the AWS CloudFormation stack.
 * <p>
 * To control how AWS CloudFormation handles the bucket when the stack is deleted, you can set a deletion policy for your bucket. You can choose to <em>retain</em> the bucket or to <em>delete</em> the bucket. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html">DeletionPolicy Attribute</a> .
 * <p>
 * <blockquote>
 * <p>
 * You can only delete empty buckets. Deletion fails for buckets that have contents.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CfnInclude cfnTemplate;
 * CfnBucket cfnBucket = (CfnBucket)cfnTemplate.getResource("Bucket");
 * Role role = Role.Builder.create(this, "Role")
 *         .assumedBy(new AnyPrincipal())
 *         .build();
 * role.addToPolicy(PolicyStatement.Builder.create()
 *         .actions(List.of("s3:*"))
 *         .resources(List.of(cfnBucket.getAttrArn()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-02-21T19:24:03.848Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket")
public class CfnBucket extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnBucket(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnBucket(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.s3.CfnBucket.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::S3::Bucket`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnBucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.CfnBucketProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::S3::Bucket`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnBucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns the Amazon Resource Name (ARN) of the specified bucket.
     * <p>
     * Example: <code>arn:aws:s3:::DOC-EXAMPLE-BUCKET</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the IPv4 DNS name of the specified bucket.
     * <p>
     * Example: <code>DOC-EXAMPLE-BUCKET.s3.amazonaws.com</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDomainName() {
        return software.amazon.jsii.Kernel.get(this, "attrDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the IPv6 DNS name of the specified bucket.
     * <p>
     * Example: <code>DOC-EXAMPLE-BUCKET.s3.dualstack.us-east-2.amazonaws.com</code>
     * <p>
     * For more information about dual-stack endpoints, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/dual-stack-endpoints.html">Using Amazon S3 Dual-Stack Endpoints</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDualStackDomainName() {
        return software.amazon.jsii.Kernel.get(this, "attrDualStackDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the regional domain name of the specified bucket.
     * <p>
     * Example: <code>DOC-EXAMPLE-BUCKET.s3.us-east-2.amazonaws.com</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRegionalDomainName() {
        return software.amazon.jsii.Kernel.get(this, "attrRegionalDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the Amazon S3 website endpoint for the specified bucket.
     * <p>
     * Example (IPv4): <code>http://DOC-EXAMPLE-BUCKET.s3-website.us-east-2.amazonaws.com</code>
     * <p>
     * Example (IPv6): <code>http://DOC-EXAMPLE-BUCKET.s3.dualstack.us-east-2.amazonaws.com</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrWebsiteUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrWebsiteUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An arbitrary set of tags (key-value pairs) for this S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * Configures the transfer acceleration state for an Amazon S3 bucket.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html">Amazon S3 Transfer Acceleration</a> in the <em>Amazon S3 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAccelerateConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "accelerateConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configures the transfer acceleration state for an Amazon S3 bucket.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html">Amazon S3 Transfer Acceleration</a> in the <em>Amazon S3 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccelerateConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "accelerateConfiguration", value);
    }

    /**
     * Configures the transfer acceleration state for an Amazon S3 bucket.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html">Amazon S3 Transfer Acceleration</a> in the <em>Amazon S3 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccelerateConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.CfnBucket.AccelerateConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "accelerateConfiguration", value);
    }

    /**
     * A canned access control list (ACL) that grants predefined permissions to the bucket.
     * <p>
     * For more information about canned ACLs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">Canned ACL</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * Be aware that the syntax for this property differs from the information provided in the <em>Amazon S3 User Guide</em> . The AccessControl property is case-sensitive and must be one of the following values: Private, PublicRead, PublicReadWrite, AuthenticatedRead, LogDeliveryWrite, BucketOwnerRead, BucketOwnerFullControl, or AwsExecRead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAccessControl() {
        return software.amazon.jsii.Kernel.get(this, "accessControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A canned access control list (ACL) that grants predefined permissions to the bucket.
     * <p>
     * For more information about canned ACLs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">Canned ACL</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * Be aware that the syntax for this property differs from the information provided in the <em>Amazon S3 User Guide</em> . The AccessControl property is case-sensitive and must be one of the following values: Private, PublicRead, PublicReadWrite, AuthenticatedRead, LogDeliveryWrite, BucketOwnerRead, BucketOwnerFullControl, or AwsExecRead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessControl(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "accessControl", value);
    }

    /**
     * Specifies the configuration and any analyses for the analytics filter of an Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAnalyticsConfigurations() {
        return software.amazon.jsii.Kernel.get(this, "analyticsConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the configuration and any analyses for the analytics filter of an Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAnalyticsConfigurations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "analyticsConfigurations", value);
    }

    /**
     * Specifies the configuration and any analyses for the analytics filter of an Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAnalyticsConfigurations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.s3.CfnBucket.AnalyticsConfigurationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.core.IResolvable, software.amazon.awscdk.services.s3.CfnBucket.AnalyticsConfigurationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "analyticsConfigurations", value);
    }

    /**
     * Specifies default encryption for a bucket using server-side encryption with Amazon S3-managed keys (SSE-S3) or AWS KMS-managed keys (SSE-KMS) bucket.
     * <p>
     * For information about the Amazon S3 default encryption feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">Amazon S3 Default Encryption for S3 Buckets</a> in the <em>Amazon S3 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBucketEncryption() {
        return software.amazon.jsii.Kernel.get(this, "bucketEncryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies default encryption for a bucket using server-side encryption with Amazon S3-managed keys (SSE-S3) or AWS KMS-managed keys (SSE-KMS) bucket.
     * <p>
     * For information about the Amazon S3 default encryption feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">Amazon S3 Default Encryption for S3 Buckets</a> in the <em>Amazon S3 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBucketEncryption(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "bucketEncryption", value);
    }

    /**
     * Specifies default encryption for a bucket using server-side encryption with Amazon S3-managed keys (SSE-S3) or AWS KMS-managed keys (SSE-KMS) bucket.
     * <p>
     * For information about the Amazon S3 default encryption feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">Amazon S3 Default Encryption for S3 Buckets</a> in the <em>Amazon S3 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBucketEncryption(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.CfnBucket.BucketEncryptionProperty value) {
        software.amazon.jsii.Kernel.set(this, "bucketEncryption", value);
    }

    /**
     * A name for the bucket.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the bucket name. The bucket name must contain only lowercase letters, numbers, periods (.), and dashes (-) and must follow <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Amazon S3 bucket restrictions and limitations</a> . For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html#bucketnamingrules">Rules for naming Amazon S3 buckets</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you need to replace the resource, specify a new name.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBucketName() {
        return software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the bucket.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the bucket name. The bucket name must contain only lowercase letters, numbers, periods (.), and dashes (-) and must follow <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Amazon S3 bucket restrictions and limitations</a> . For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html#bucketnamingrules">Rules for naming Amazon S3 buckets</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you need to replace the resource, specify a new name.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBucketName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "bucketName", value);
    }

    /**
     * Describes the cross-origin access configuration for objects in an Amazon S3 bucket.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">Enabling Cross-Origin Resource Sharing</a> in the <em>Amazon S3 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCorsConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "corsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Describes the cross-origin access configuration for objects in an Amazon S3 bucket.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">Enabling Cross-Origin Resource Sharing</a> in the <em>Amazon S3 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCorsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "corsConfiguration", value);
    }

    /**
     * Describes the cross-origin access configuration for objects in an Amazon S3 bucket.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">Enabling Cross-Origin Resource Sharing</a> in the <em>Amazon S3 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCorsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.CfnBucket.CorsConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "corsConfiguration", value);
    }

    /**
     * Defines how Amazon S3 handles Intelligent-Tiering storage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIntelligentTieringConfigurations() {
        return software.amazon.jsii.Kernel.get(this, "intelligentTieringConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Defines how Amazon S3 handles Intelligent-Tiering storage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIntelligentTieringConfigurations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "intelligentTieringConfigurations", value);
    }

    /**
     * Defines how Amazon S3 handles Intelligent-Tiering storage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIntelligentTieringConfigurations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.s3.CfnBucket.IntelligentTieringConfigurationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.core.IResolvable, software.amazon.awscdk.services.s3.CfnBucket.IntelligentTieringConfigurationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "intelligentTieringConfigurations", value);
    }

    /**
     * Specifies the inventory configuration for an Amazon S3 bucket.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketGETInventoryConfig.html">GET Bucket inventory</a> in the <em>Amazon S3 API Reference</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInventoryConfigurations() {
        return software.amazon.jsii.Kernel.get(this, "inventoryConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the inventory configuration for an Amazon S3 bucket.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketGETInventoryConfig.html">GET Bucket inventory</a> in the <em>Amazon S3 API Reference</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInventoryConfigurations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "inventoryConfigurations", value);
    }

    /**
     * Specifies the inventory configuration for an Amazon S3 bucket.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketGETInventoryConfig.html">GET Bucket inventory</a> in the <em>Amazon S3 API Reference</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInventoryConfigurations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.s3.CfnBucket.InventoryConfigurationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.core.IResolvable, software.amazon.awscdk.services.s3.CfnBucket.InventoryConfigurationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "inventoryConfigurations", value);
    }

    /**
     * Specifies the lifecycle configuration for objects in an Amazon S3 bucket.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html">Object Lifecycle Management</a> in the <em>Amazon S3 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLifecycleConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "lifecycleConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the lifecycle configuration for objects in an Amazon S3 bucket.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html">Object Lifecycle Management</a> in the <em>Amazon S3 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLifecycleConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "lifecycleConfiguration", value);
    }

    /**
     * Specifies the lifecycle configuration for objects in an Amazon S3 bucket.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html">Object Lifecycle Management</a> in the <em>Amazon S3 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLifecycleConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.CfnBucket.LifecycleConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "lifecycleConfiguration", value);
    }

    /**
     * Settings that define where logs are stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLoggingConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "loggingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings that define where logs are stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoggingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "loggingConfiguration", value);
    }

    /**
     * Settings that define where logs are stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoggingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.CfnBucket.LoggingConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "loggingConfiguration", value);
    }

    /**
     * Specifies a metrics configuration for the CloudWatch request metrics (specified by the metrics configuration ID) from an Amazon S3 bucket.
     * <p>
     * If you're updating an existing metrics configuration, note that this is a full replacement of the existing metrics configuration. If you don't include the elements you want to keep, they are erased. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTMetricConfiguration.html">PutBucketMetricsConfiguration</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMetricsConfigurations() {
        return software.amazon.jsii.Kernel.get(this, "metricsConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies a metrics configuration for the CloudWatch request metrics (specified by the metrics configuration ID) from an Amazon S3 bucket.
     * <p>
     * If you're updating an existing metrics configuration, note that this is a full replacement of the existing metrics configuration. If you don't include the elements you want to keep, they are erased. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTMetricConfiguration.html">PutBucketMetricsConfiguration</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetricsConfigurations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "metricsConfigurations", value);
    }

    /**
     * Specifies a metrics configuration for the CloudWatch request metrics (specified by the metrics configuration ID) from an Amazon S3 bucket.
     * <p>
     * If you're updating an existing metrics configuration, note that this is a full replacement of the existing metrics configuration. If you don't include the elements you want to keep, they are erased. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTMetricConfiguration.html">PutBucketMetricsConfiguration</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetricsConfigurations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.s3.CfnBucket.MetricsConfigurationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.core.IResolvable, software.amazon.awscdk.services.s3.CfnBucket.MetricsConfigurationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "metricsConfigurations", value);
    }

    /**
     * Configuration that defines how Amazon S3 handles bucket notifications.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNotificationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "notificationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration that defines how Amazon S3 handles bucket notifications.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotificationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "notificationConfiguration", value);
    }

    /**
     * Configuration that defines how Amazon S3 handles bucket notifications.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotificationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.CfnBucket.NotificationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "notificationConfiguration", value);
    }

    /**
     * Places an Object Lock configuration on the specified bucket.
     * <p>
     * The rule specified in the Object Lock configuration will be applied by default to every new object placed in the specified bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Locking Objects</a> .
     * <p>
     * <blockquote>
     * <p>
     * <ul>
     * <li>The <code>DefaultRetention</code> settings require both a mode and a period.</li>
     * <li>The <code>DefaultRetention</code> period can be either <code>Days</code> or <code>Years</code> but you must select one. You cannot specify <code>Days</code> and <code>Years</code> at the same time.</li>
     * <li>You can only enable Object Lock for new buckets. If you want to turn on Object Lock for an existing bucket, contact AWS Support.</li>
     * </ul>
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getObjectLockConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "objectLockConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Places an Object Lock configuration on the specified bucket.
     * <p>
     * The rule specified in the Object Lock configuration will be applied by default to every new object placed in the specified bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Locking Objects</a> .
     * <p>
     * <blockquote>
     * <p>
     * <ul>
     * <li>The <code>DefaultRetention</code> settings require both a mode and a period.</li>
     * <li>The <code>DefaultRetention</code> period can be either <code>Days</code> or <code>Years</code> but you must select one. You cannot specify <code>Days</code> and <code>Years</code> at the same time.</li>
     * <li>You can only enable Object Lock for new buckets. If you want to turn on Object Lock for an existing bucket, contact AWS Support.</li>
     * </ul>
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setObjectLockConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "objectLockConfiguration", value);
    }

    /**
     * Places an Object Lock configuration on the specified bucket.
     * <p>
     * The rule specified in the Object Lock configuration will be applied by default to every new object placed in the specified bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Locking Objects</a> .
     * <p>
     * <blockquote>
     * <p>
     * <ul>
     * <li>The <code>DefaultRetention</code> settings require both a mode and a period.</li>
     * <li>The <code>DefaultRetention</code> period can be either <code>Days</code> or <code>Years</code> but you must select one. You cannot specify <code>Days</code> and <code>Years</code> at the same time.</li>
     * <li>You can only enable Object Lock for new buckets. If you want to turn on Object Lock for an existing bucket, contact AWS Support.</li>
     * </ul>
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setObjectLockConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.CfnBucket.ObjectLockConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "objectLockConfiguration", value);
    }

    /**
     * Indicates whether this bucket has an Object Lock configuration enabled.
     * <p>
     * Enable <code>ObjectLockEnabled</code> when you apply <code>ObjectLockConfiguration</code> to a bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getObjectLockEnabled() {
        return software.amazon.jsii.Kernel.get(this, "objectLockEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether this bucket has an Object Lock configuration enabled.
     * <p>
     * Enable <code>ObjectLockEnabled</code> when you apply <code>ObjectLockConfiguration</code> to a bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setObjectLockEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "objectLockEnabled", value);
    }

    /**
     * Indicates whether this bucket has an Object Lock configuration enabled.
     * <p>
     * Enable <code>ObjectLockEnabled</code> when you apply <code>ObjectLockConfiguration</code> to a bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setObjectLockEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "objectLockEnabled", value);
    }

    /**
     * Configuration that defines how Amazon S3 handles Object Ownership rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOwnershipControls() {
        return software.amazon.jsii.Kernel.get(this, "ownershipControls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration that defines how Amazon S3 handles Object Ownership rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOwnershipControls(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ownershipControls", value);
    }

    /**
     * Configuration that defines how Amazon S3 handles Object Ownership rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOwnershipControls(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.CfnBucket.OwnershipControlsProperty value) {
        software.amazon.jsii.Kernel.set(this, "ownershipControls", value);
    }

    /**
     * Configuration that defines how Amazon S3 handles public access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPublicAccessBlockConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "publicAccessBlockConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration that defines how Amazon S3 handles public access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPublicAccessBlockConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "publicAccessBlockConfiguration", value);
    }

    /**
     * Configuration that defines how Amazon S3 handles public access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPublicAccessBlockConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.CfnBucket.PublicAccessBlockConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "publicAccessBlockConfiguration", value);
    }

    /**
     * Configuration for replicating objects in an S3 bucket.
     * <p>
     * To enable replication, you must also enable versioning by using the <code>VersioningConfiguration</code> property.
     * <p>
     * Amazon S3 can store replicated objects in a single destination bucket or multiple destination buckets. The destination bucket or buckets must already exist.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getReplicationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "replicationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration for replicating objects in an S3 bucket.
     * <p>
     * To enable replication, you must also enable versioning by using the <code>VersioningConfiguration</code> property.
     * <p>
     * Amazon S3 can store replicated objects in a single destination bucket or multiple destination buckets. The destination bucket or buckets must already exist.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "replicationConfiguration", value);
    }

    /**
     * Configuration for replicating objects in an S3 bucket.
     * <p>
     * To enable replication, you must also enable versioning by using the <code>VersioningConfiguration</code> property.
     * <p>
     * Amazon S3 can store replicated objects in a single destination bucket or multiple destination buckets. The destination bucket or buckets must already exist.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.CfnBucket.ReplicationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "replicationConfiguration", value);
    }

    /**
     * Enables multiple versions of all objects in this bucket.
     * <p>
     * You might enable versioning to prevent objects from being deleted or overwritten by mistake or to archive objects so that you can retrieve previous versions of them.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVersioningConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "versioningConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Enables multiple versions of all objects in this bucket.
     * <p>
     * You might enable versioning to prevent objects from being deleted or overwritten by mistake or to archive objects so that you can retrieve previous versions of them.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVersioningConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "versioningConfiguration", value);
    }

    /**
     * Enables multiple versions of all objects in this bucket.
     * <p>
     * You might enable versioning to prevent objects from being deleted or overwritten by mistake or to archive objects so that you can retrieve previous versions of them.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVersioningConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.CfnBucket.VersioningConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "versioningConfiguration", value);
    }

    /**
     * Information used to configure the bucket as a static website.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">Hosting Websites on Amazon S3</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getWebsiteConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "websiteConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information used to configure the bucket as a static website.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">Hosting Websites on Amazon S3</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWebsiteConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "websiteConfiguration", value);
    }

    /**
     * Information used to configure the bucket as a static website.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">Hosting Websites on Amazon S3</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWebsiteConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.CfnBucket.WebsiteConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "websiteConfiguration", value);
    }
    /**
     * Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config">Stopping Incomplete Multipart Uploads Using a Bucket Lifecycle Policy</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * AbortIncompleteMultipartUploadProperty abortIncompleteMultipartUploadProperty = AbortIncompleteMultipartUploadProperty.builder()
     *         .daysAfterInitiation(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.AbortIncompleteMultipartUploadProperty")
    @software.amazon.jsii.Jsii.Proxy(AbortIncompleteMultipartUploadProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AbortIncompleteMultipartUploadProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the number of days after which Amazon S3 stops an incomplete multipart upload.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getDaysAfterInitiation();

        /**
         * @return a {@link Builder} of {@link AbortIncompleteMultipartUploadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AbortIncompleteMultipartUploadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AbortIncompleteMultipartUploadProperty> {
            java.lang.Number daysAfterInitiation;

            /**
             * Sets the value of {@link AbortIncompleteMultipartUploadProperty#getDaysAfterInitiation}
             * @param daysAfterInitiation Specifies the number of days after which Amazon S3 stops an incomplete multipart upload. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder daysAfterInitiation(java.lang.Number daysAfterInitiation) {
                this.daysAfterInitiation = daysAfterInitiation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AbortIncompleteMultipartUploadProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AbortIncompleteMultipartUploadProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AbortIncompleteMultipartUploadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AbortIncompleteMultipartUploadProperty {
            private final java.lang.Number daysAfterInitiation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.daysAfterInitiation = software.amazon.jsii.Kernel.get(this, "daysAfterInitiation", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.daysAfterInitiation = java.util.Objects.requireNonNull(builder.daysAfterInitiation, "daysAfterInitiation is required");
            }

            @Override
            public final java.lang.Number getDaysAfterInitiation() {
                return this.daysAfterInitiation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("daysAfterInitiation", om.valueToTree(this.getDaysAfterInitiation()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.AbortIncompleteMultipartUploadProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AbortIncompleteMultipartUploadProperty.Jsii$Proxy that = (AbortIncompleteMultipartUploadProperty.Jsii$Proxy) o;

                return this.daysAfterInitiation.equals(that.daysAfterInitiation);
            }

            @Override
            public final int hashCode() {
                int result = this.daysAfterInitiation.hashCode();
                return result;
            }
        }
    }
    /**
     * Configures the transfer acceleration state for an Amazon S3 bucket.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html">Amazon S3 Transfer Acceleration</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * AccelerateConfigurationProperty accelerateConfigurationProperty = AccelerateConfigurationProperty.builder()
     *         .accelerationStatus("accelerationStatus")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.AccelerateConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AccelerateConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccelerateConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the transfer acceleration status of the bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAccelerationStatus();

        /**
         * @return a {@link Builder} of {@link AccelerateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccelerateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccelerateConfigurationProperty> {
            java.lang.String accelerationStatus;

            /**
             * Sets the value of {@link AccelerateConfigurationProperty#getAccelerationStatus}
             * @param accelerationStatus Specifies the transfer acceleration status of the bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accelerationStatus(java.lang.String accelerationStatus) {
                this.accelerationStatus = accelerationStatus;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccelerateConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccelerateConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AccelerateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccelerateConfigurationProperty {
            private final java.lang.String accelerationStatus;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accelerationStatus = software.amazon.jsii.Kernel.get(this, "accelerationStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accelerationStatus = java.util.Objects.requireNonNull(builder.accelerationStatus, "accelerationStatus is required");
            }

            @Override
            public final java.lang.String getAccelerationStatus() {
                return this.accelerationStatus;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("accelerationStatus", om.valueToTree(this.getAccelerationStatus()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.AccelerateConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccelerateConfigurationProperty.Jsii$Proxy that = (AccelerateConfigurationProperty.Jsii$Proxy) o;

                return this.accelerationStatus.equals(that.accelerationStatus);
            }

            @Override
            public final int hashCode() {
                int result = this.accelerationStatus.hashCode();
                return result;
            }
        }
    }
    /**
     * Specify this only in a cross-account scenario (where source and destination bucket owners are not the same), and you want to change replica ownership to the AWS account that owns the destination bucket.
     * <p>
     * If this is not specified in the replication configuration, the replicas are owned by same AWS account that owns the source object.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * AccessControlTranslationProperty accessControlTranslationProperty = AccessControlTranslationProperty.builder()
     *         .owner("owner")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.AccessControlTranslationProperty")
    @software.amazon.jsii.Jsii.Proxy(AccessControlTranslationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccessControlTranslationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the replica ownership.
         * <p>
         * For default and valid values, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTreplication.html">PUT bucket replication</a> in the <em>Amazon S3 API Reference</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOwner();

        /**
         * @return a {@link Builder} of {@link AccessControlTranslationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccessControlTranslationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccessControlTranslationProperty> {
            java.lang.String owner;

            /**
             * Sets the value of {@link AccessControlTranslationProperty#getOwner}
             * @param owner Specifies the replica ownership. This parameter is required.
             *              For default and valid values, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTreplication.html">PUT bucket replication</a> in the <em>Amazon S3 API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder owner(java.lang.String owner) {
                this.owner = owner;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessControlTranslationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccessControlTranslationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AccessControlTranslationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessControlTranslationProperty {
            private final java.lang.String owner;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.owner = software.amazon.jsii.Kernel.get(this, "owner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.owner = java.util.Objects.requireNonNull(builder.owner, "owner is required");
            }

            @Override
            public final java.lang.String getOwner() {
                return this.owner;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("owner", om.valueToTree(this.getOwner()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.AccessControlTranslationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccessControlTranslationProperty.Jsii$Proxy that = (AccessControlTranslationProperty.Jsii$Proxy) o;

                return this.owner.equals(that.owner);
            }

            @Override
            public final int hashCode() {
                int result = this.owner.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies the configuration and any analyses for the analytics filter of an Amazon S3 bucket.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * AnalyticsConfigurationProperty analyticsConfigurationProperty = AnalyticsConfigurationProperty.builder()
     *         .id("id")
     *         .storageClassAnalysis(StorageClassAnalysisProperty.builder()
     *                 .dataExport(DataExportProperty.builder()
     *                         .destination(DestinationProperty.builder()
     *                                 .bucketArn("bucketArn")
     *                                 .format("format")
     *                                 // the properties below are optional
     *                                 .bucketAccountId("bucketAccountId")
     *                                 .prefix("prefix")
     *                                 .build())
     *                         .outputSchemaVersion("outputSchemaVersion")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .prefix("prefix")
     *         .tagFilters(List.of(TagFilterProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.AnalyticsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AnalyticsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnalyticsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID that identifies the analytics configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * Contains data related to access patterns to be collected and made available to analyze the tradeoffs between different storage classes.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getStorageClassAnalysis();

        /**
         * The prefix that an object must have to be included in the analytics results.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * The tags to use when evaluating an analytics filter.
         * <p>
         * The analytics only includes objects that meet the filter's criteria. If no filter is specified, all of the contents of the bucket are included in the analysis.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagFilters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AnalyticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnalyticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnalyticsConfigurationProperty> {
            java.lang.String id;
            java.lang.Object storageClassAnalysis;
            java.lang.String prefix;
            java.lang.Object tagFilters;

            /**
             * Sets the value of {@link AnalyticsConfigurationProperty#getId}
             * @param id The ID that identifies the analytics configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link AnalyticsConfigurationProperty#getStorageClassAnalysis}
             * @param storageClassAnalysis Contains data related to access patterns to be collected and made available to analyze the tradeoffs between different storage classes. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageClassAnalysis(software.amazon.awscdk.core.IResolvable storageClassAnalysis) {
                this.storageClassAnalysis = storageClassAnalysis;
                return this;
            }

            /**
             * Sets the value of {@link AnalyticsConfigurationProperty#getStorageClassAnalysis}
             * @param storageClassAnalysis Contains data related to access patterns to be collected and made available to analyze the tradeoffs between different storage classes. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageClassAnalysis(software.amazon.awscdk.services.s3.CfnBucket.StorageClassAnalysisProperty storageClassAnalysis) {
                this.storageClassAnalysis = storageClassAnalysis;
                return this;
            }

            /**
             * Sets the value of {@link AnalyticsConfigurationProperty#getPrefix}
             * @param prefix The prefix that an object must have to be included in the analytics results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of {@link AnalyticsConfigurationProperty#getTagFilters}
             * @param tagFilters The tags to use when evaluating an analytics filter.
             *                   The analytics only includes objects that meet the filter's criteria. If no filter is specified, all of the contents of the bucket are included in the analysis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagFilters(software.amazon.awscdk.core.IResolvable tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Sets the value of {@link AnalyticsConfigurationProperty#getTagFilters}
             * @param tagFilters The tags to use when evaluating an analytics filter.
             *                   The analytics only includes objects that meet the filter's criteria. If no filter is specified, all of the contents of the bucket are included in the analysis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagFilters(java.util.List<? extends java.lang.Object> tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalyticsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnalyticsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnalyticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnalyticsConfigurationProperty {
            private final java.lang.String id;
            private final java.lang.Object storageClassAnalysis;
            private final java.lang.String prefix;
            private final java.lang.Object tagFilters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.storageClassAnalysis = software.amazon.jsii.Kernel.get(this, "storageClassAnalysis", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tagFilters = software.amazon.jsii.Kernel.get(this, "tagFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.storageClassAnalysis = java.util.Objects.requireNonNull(builder.storageClassAnalysis, "storageClassAnalysis is required");
                this.prefix = builder.prefix;
                this.tagFilters = builder.tagFilters;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.Object getStorageClassAnalysis() {
                return this.storageClassAnalysis;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public final java.lang.Object getTagFilters() {
                return this.tagFilters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("id", om.valueToTree(this.getId()));
                data.set("storageClassAnalysis", om.valueToTree(this.getStorageClassAnalysis()));
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }
                if (this.getTagFilters() != null) {
                    data.set("tagFilters", om.valueToTree(this.getTagFilters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.AnalyticsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnalyticsConfigurationProperty.Jsii$Proxy that = (AnalyticsConfigurationProperty.Jsii$Proxy) o;

                if (!id.equals(that.id)) return false;
                if (!storageClassAnalysis.equals(that.storageClassAnalysis)) return false;
                if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
                return this.tagFilters != null ? this.tagFilters.equals(that.tagFilters) : that.tagFilters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.id.hashCode();
                result = 31 * result + (this.storageClassAnalysis.hashCode());
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                result = 31 * result + (this.tagFilters != null ? this.tagFilters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies default encryption for a bucket using server-side encryption with Amazon S3-managed keys (SSE-S3) or AWS KMS-managed keys (SSE-KMS) bucket.
     * <p>
     * For information about the Amazon S3 default encryption feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">Amazon S3 Default Encryption for S3 Buckets</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * BucketEncryptionProperty bucketEncryptionProperty = BucketEncryptionProperty.builder()
     *         .serverSideEncryptionConfiguration(List.of(ServerSideEncryptionRuleProperty.builder()
     *                 .bucketKeyEnabled(false)
     *                 .serverSideEncryptionByDefault(ServerSideEncryptionByDefaultProperty.builder()
     *                         .sseAlgorithm("sseAlgorithm")
     *                         // the properties below are optional
     *                         .kmsMasterKeyId("kmsMasterKeyId")
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.BucketEncryptionProperty")
    @software.amazon.jsii.Jsii.Proxy(BucketEncryptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BucketEncryptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the default server-side-encryption configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getServerSideEncryptionConfiguration();

        /**
         * @return a {@link Builder} of {@link BucketEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BucketEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BucketEncryptionProperty> {
            java.lang.Object serverSideEncryptionConfiguration;

            /**
             * Sets the value of {@link BucketEncryptionProperty#getServerSideEncryptionConfiguration}
             * @param serverSideEncryptionConfiguration Specifies the default server-side-encryption configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverSideEncryptionConfiguration(software.amazon.awscdk.core.IResolvable serverSideEncryptionConfiguration) {
                this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link BucketEncryptionProperty#getServerSideEncryptionConfiguration}
             * @param serverSideEncryptionConfiguration Specifies the default server-side-encryption configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverSideEncryptionConfiguration(java.util.List<? extends java.lang.Object> serverSideEncryptionConfiguration) {
                this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BucketEncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BucketEncryptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BucketEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BucketEncryptionProperty {
            private final java.lang.Object serverSideEncryptionConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.serverSideEncryptionConfiguration = software.amazon.jsii.Kernel.get(this, "serverSideEncryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.serverSideEncryptionConfiguration = java.util.Objects.requireNonNull(builder.serverSideEncryptionConfiguration, "serverSideEncryptionConfiguration is required");
            }

            @Override
            public final java.lang.Object getServerSideEncryptionConfiguration() {
                return this.serverSideEncryptionConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("serverSideEncryptionConfiguration", om.valueToTree(this.getServerSideEncryptionConfiguration()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.BucketEncryptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BucketEncryptionProperty.Jsii$Proxy that = (BucketEncryptionProperty.Jsii$Proxy) o;

                return this.serverSideEncryptionConfiguration.equals(that.serverSideEncryptionConfiguration);
            }

            @Override
            public final int hashCode() {
                int result = this.serverSideEncryptionConfiguration.hashCode();
                return result;
            }
        }
    }
    /**
     * Describes the cross-origin access configuration for objects in an Amazon S3 bucket.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">Enabling Cross-Origin Resource Sharing</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * CorsConfigurationProperty corsConfigurationProperty = CorsConfigurationProperty.builder()
     *         .corsRules(List.of(CorsRuleProperty.builder()
     *                 .allowedMethods(List.of("allowedMethods"))
     *                 .allowedOrigins(List.of("allowedOrigins"))
     *                 // the properties below are optional
     *                 .allowedHeaders(List.of("allowedHeaders"))
     *                 .exposedHeaders(List.of("exposedHeaders"))
     *                 .id("id")
     *                 .maxAge(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.CorsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CorsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CorsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A set of origins and methods (cross-origin access that you want to allow).
         * <p>
         * You can add up to 100 rules to the configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCorsRules();

        /**
         * @return a {@link Builder} of {@link CorsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CorsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CorsConfigurationProperty> {
            java.lang.Object corsRules;

            /**
             * Sets the value of {@link CorsConfigurationProperty#getCorsRules}
             * @param corsRules A set of origins and methods (cross-origin access that you want to allow). This parameter is required.
             *                  You can add up to 100 rules to the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder corsRules(software.amazon.awscdk.core.IResolvable corsRules) {
                this.corsRules = corsRules;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigurationProperty#getCorsRules}
             * @param corsRules A set of origins and methods (cross-origin access that you want to allow). This parameter is required.
             *                  You can add up to 100 rules to the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder corsRules(java.util.List<? extends java.lang.Object> corsRules) {
                this.corsRules = corsRules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CorsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CorsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CorsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CorsConfigurationProperty {
            private final java.lang.Object corsRules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.corsRules = software.amazon.jsii.Kernel.get(this, "corsRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.corsRules = java.util.Objects.requireNonNull(builder.corsRules, "corsRules is required");
            }

            @Override
            public final java.lang.Object getCorsRules() {
                return this.corsRules;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("corsRules", om.valueToTree(this.getCorsRules()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.CorsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CorsConfigurationProperty.Jsii$Proxy that = (CorsConfigurationProperty.Jsii$Proxy) o;

                return this.corsRules.equals(that.corsRules);
            }

            @Override
            public final int hashCode() {
                int result = this.corsRules.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies a cross-origin access rule for an Amazon S3 bucket.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * CorsRuleProperty corsRuleProperty = CorsRuleProperty.builder()
     *         .allowedMethods(List.of("allowedMethods"))
     *         .allowedOrigins(List.of("allowedOrigins"))
     *         // the properties below are optional
     *         .allowedHeaders(List.of("allowedHeaders"))
     *         .exposedHeaders(List.of("exposedHeaders"))
     *         .id("id")
     *         .maxAge(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.CorsRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(CorsRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CorsRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An HTTP method that you allow the origin to run.
         * <p>
         * <em>Allowed values</em> : <code>GET</code> | <code>PUT</code> | <code>HEAD</code> | <code>POST</code> | <code>DELETE</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAllowedMethods();

        /**
         * One or more origins you want customers to be able to access the bucket from.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAllowedOrigins();

        /**
         * Headers that are specified in the `Access-Control-Request-Headers` header.
         * <p>
         * These headers are allowed in a preflight OPTIONS request. In response to any preflight OPTIONS request, Amazon S3 returns any requested headers that are allowed.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedHeaders() {
            return null;
        }

        /**
         * One or more headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript `XMLHttpRequest` object).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExposedHeaders() {
            return null;
        }

        /**
         * A unique identifier for this rule.
         * <p>
         * The value must be no more than 255 characters.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getId() {
            return null;
        }

        /**
         * The time in seconds that your browser is to cache the preflight response for the specified resource.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxAge() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CorsRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CorsRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CorsRuleProperty> {
            java.util.List<java.lang.String> allowedMethods;
            java.util.List<java.lang.String> allowedOrigins;
            java.util.List<java.lang.String> allowedHeaders;
            java.util.List<java.lang.String> exposedHeaders;
            java.lang.String id;
            java.lang.Number maxAge;

            /**
             * Sets the value of {@link CorsRuleProperty#getAllowedMethods}
             * @param allowedMethods An HTTP method that you allow the origin to run. This parameter is required.
             *                       <em>Allowed values</em> : <code>GET</code> | <code>PUT</code> | <code>HEAD</code> | <code>POST</code> | <code>DELETE</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedMethods(java.util.List<java.lang.String> allowedMethods) {
                this.allowedMethods = allowedMethods;
                return this;
            }

            /**
             * Sets the value of {@link CorsRuleProperty#getAllowedOrigins}
             * @param allowedOrigins One or more origins you want customers to be able to access the bucket from. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedOrigins(java.util.List<java.lang.String> allowedOrigins) {
                this.allowedOrigins = allowedOrigins;
                return this;
            }

            /**
             * Sets the value of {@link CorsRuleProperty#getAllowedHeaders}
             * @param allowedHeaders Headers that are specified in the `Access-Control-Request-Headers` header.
             *                       These headers are allowed in a preflight OPTIONS request. In response to any preflight OPTIONS request, Amazon S3 returns any requested headers that are allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedHeaders(java.util.List<java.lang.String> allowedHeaders) {
                this.allowedHeaders = allowedHeaders;
                return this;
            }

            /**
             * Sets the value of {@link CorsRuleProperty#getExposedHeaders}
             * @param exposedHeaders One or more headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript `XMLHttpRequest` object).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exposedHeaders(java.util.List<java.lang.String> exposedHeaders) {
                this.exposedHeaders = exposedHeaders;
                return this;
            }

            /**
             * Sets the value of {@link CorsRuleProperty#getId}
             * @param id A unique identifier for this rule.
             *           The value must be no more than 255 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link CorsRuleProperty#getMaxAge}
             * @param maxAge The time in seconds that your browser is to cache the preflight response for the specified resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxAge(java.lang.Number maxAge) {
                this.maxAge = maxAge;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CorsRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CorsRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CorsRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CorsRuleProperty {
            private final java.util.List<java.lang.String> allowedMethods;
            private final java.util.List<java.lang.String> allowedOrigins;
            private final java.util.List<java.lang.String> allowedHeaders;
            private final java.util.List<java.lang.String> exposedHeaders;
            private final java.lang.String id;
            private final java.lang.Number maxAge;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowedMethods = software.amazon.jsii.Kernel.get(this, "allowedMethods", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.allowedOrigins = software.amazon.jsii.Kernel.get(this, "allowedOrigins", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.allowedHeaders = software.amazon.jsii.Kernel.get(this, "allowedHeaders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.exposedHeaders = software.amazon.jsii.Kernel.get(this, "exposedHeaders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maxAge = software.amazon.jsii.Kernel.get(this, "maxAge", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowedMethods = java.util.Objects.requireNonNull(builder.allowedMethods, "allowedMethods is required");
                this.allowedOrigins = java.util.Objects.requireNonNull(builder.allowedOrigins, "allowedOrigins is required");
                this.allowedHeaders = builder.allowedHeaders;
                this.exposedHeaders = builder.exposedHeaders;
                this.id = builder.id;
                this.maxAge = builder.maxAge;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedMethods() {
                return this.allowedMethods;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedOrigins() {
                return this.allowedOrigins;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedHeaders() {
                return this.allowedHeaders;
            }

            @Override
            public final java.util.List<java.lang.String> getExposedHeaders() {
                return this.exposedHeaders;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.Number getMaxAge() {
                return this.maxAge;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("allowedMethods", om.valueToTree(this.getAllowedMethods()));
                data.set("allowedOrigins", om.valueToTree(this.getAllowedOrigins()));
                if (this.getAllowedHeaders() != null) {
                    data.set("allowedHeaders", om.valueToTree(this.getAllowedHeaders()));
                }
                if (this.getExposedHeaders() != null) {
                    data.set("exposedHeaders", om.valueToTree(this.getExposedHeaders()));
                }
                if (this.getId() != null) {
                    data.set("id", om.valueToTree(this.getId()));
                }
                if (this.getMaxAge() != null) {
                    data.set("maxAge", om.valueToTree(this.getMaxAge()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.CorsRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CorsRuleProperty.Jsii$Proxy that = (CorsRuleProperty.Jsii$Proxy) o;

                if (!allowedMethods.equals(that.allowedMethods)) return false;
                if (!allowedOrigins.equals(that.allowedOrigins)) return false;
                if (this.allowedHeaders != null ? !this.allowedHeaders.equals(that.allowedHeaders) : that.allowedHeaders != null) return false;
                if (this.exposedHeaders != null ? !this.exposedHeaders.equals(that.exposedHeaders) : that.exposedHeaders != null) return false;
                if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
                return this.maxAge != null ? this.maxAge.equals(that.maxAge) : that.maxAge == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allowedMethods.hashCode();
                result = 31 * result + (this.allowedOrigins.hashCode());
                result = 31 * result + (this.allowedHeaders != null ? this.allowedHeaders.hashCode() : 0);
                result = 31 * result + (this.exposedHeaders != null ? this.exposedHeaders.hashCode() : 0);
                result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
                result = 31 * result + (this.maxAge != null ? this.maxAge.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies how data related to the storage class analysis for an Amazon S3 bucket should be exported.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * DataExportProperty dataExportProperty = DataExportProperty.builder()
     *         .destination(DestinationProperty.builder()
     *                 .bucketArn("bucketArn")
     *                 .format("format")
     *                 // the properties below are optional
     *                 .bucketAccountId("bucketAccountId")
     *                 .prefix("prefix")
     *                 .build())
     *         .outputSchemaVersion("outputSchemaVersion")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.DataExportProperty")
    @software.amazon.jsii.Jsii.Proxy(DataExportProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataExportProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The place to store the data for an analysis.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDestination();

        /**
         * The version of the output schema to use when exporting data.
         * <p>
         * Must be <code>V_1</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOutputSchemaVersion();

        /**
         * @return a {@link Builder} of {@link DataExportProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataExportProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataExportProperty> {
            java.lang.Object destination;
            java.lang.String outputSchemaVersion;

            /**
             * Sets the value of {@link DataExportProperty#getDestination}
             * @param destination The place to store the data for an analysis. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.core.IResolvable destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link DataExportProperty#getDestination}
             * @param destination The place to store the data for an analysis. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.services.s3.CfnBucket.DestinationProperty destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link DataExportProperty#getOutputSchemaVersion}
             * @param outputSchemaVersion The version of the output schema to use when exporting data. This parameter is required.
             *                            Must be <code>V_1</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputSchemaVersion(java.lang.String outputSchemaVersion) {
                this.outputSchemaVersion = outputSchemaVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataExportProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataExportProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataExportProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataExportProperty {
            private final java.lang.Object destination;
            private final java.lang.String outputSchemaVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outputSchemaVersion = software.amazon.jsii.Kernel.get(this, "outputSchemaVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destination = java.util.Objects.requireNonNull(builder.destination, "destination is required");
                this.outputSchemaVersion = java.util.Objects.requireNonNull(builder.outputSchemaVersion, "outputSchemaVersion is required");
            }

            @Override
            public final java.lang.Object getDestination() {
                return this.destination;
            }

            @Override
            public final java.lang.String getOutputSchemaVersion() {
                return this.outputSchemaVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destination", om.valueToTree(this.getDestination()));
                data.set("outputSchemaVersion", om.valueToTree(this.getOutputSchemaVersion()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.DataExportProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataExportProperty.Jsii$Proxy that = (DataExportProperty.Jsii$Proxy) o;

                if (!destination.equals(that.destination)) return false;
                return this.outputSchemaVersion.equals(that.outputSchemaVersion);
            }

            @Override
            public final int hashCode() {
                int result = this.destination.hashCode();
                result = 31 * result + (this.outputSchemaVersion.hashCode());
                return result;
            }
        }
    }
    /**
     * The container element for specifying the default Object Lock retention settings for new objects placed in the specified bucket.
     * <p>
     * <blockquote>
     * <p>
     * <ul>
     * <li>The <code>DefaultRetention</code> settings require both a mode and a period.</li>
     * <li>The <code>DefaultRetention</code> period can be either <code>Days</code> or <code>Years</code> but you must select one. You cannot specify <code>Days</code> and <code>Years</code> at the same time.</li>
     * </ul>
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * DefaultRetentionProperty defaultRetentionProperty = DefaultRetentionProperty.builder()
     *         .days(123)
     *         .mode("mode")
     *         .years(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.DefaultRetentionProperty")
    @software.amazon.jsii.Jsii.Proxy(DefaultRetentionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DefaultRetentionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of days that you want to specify for the default retention period.
         * <p>
         * If Object Lock is turned on, you must specify <code>Mode</code> and specify either <code>Days</code> or <code>Years</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDays() {
            return null;
        }

        /**
         * The default Object Lock retention mode you want to apply to new objects placed in the specified bucket.
         * <p>
         * If Object Lock is turned on, you must specify <code>Mode</code> and specify either <code>Days</code> or <code>Years</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMode() {
            return null;
        }

        /**
         * The number of years that you want to specify for the default retention period.
         * <p>
         * If Object Lock is turned on, you must specify <code>Mode</code> and specify either <code>Days</code> or <code>Years</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getYears() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DefaultRetentionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DefaultRetentionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DefaultRetentionProperty> {
            java.lang.Number days;
            java.lang.String mode;
            java.lang.Number years;

            /**
             * Sets the value of {@link DefaultRetentionProperty#getDays}
             * @param days The number of days that you want to specify for the default retention period.
             *             If Object Lock is turned on, you must specify <code>Mode</code> and specify either <code>Days</code> or <code>Years</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder days(java.lang.Number days) {
                this.days = days;
                return this;
            }

            /**
             * Sets the value of {@link DefaultRetentionProperty#getMode}
             * @param mode The default Object Lock retention mode you want to apply to new objects placed in the specified bucket.
             *             If Object Lock is turned on, you must specify <code>Mode</code> and specify either <code>Days</code> or <code>Years</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mode(java.lang.String mode) {
                this.mode = mode;
                return this;
            }

            /**
             * Sets the value of {@link DefaultRetentionProperty#getYears}
             * @param years The number of years that you want to specify for the default retention period.
             *              If Object Lock is turned on, you must specify <code>Mode</code> and specify either <code>Days</code> or <code>Years</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder years(java.lang.Number years) {
                this.years = years;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DefaultRetentionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DefaultRetentionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DefaultRetentionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefaultRetentionProperty {
            private final java.lang.Number days;
            private final java.lang.String mode;
            private final java.lang.Number years;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.days = software.amazon.jsii.Kernel.get(this, "days", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.years = software.amazon.jsii.Kernel.get(this, "years", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.days = builder.days;
                this.mode = builder.mode;
                this.years = builder.years;
            }

            @Override
            public final java.lang.Number getDays() {
                return this.days;
            }

            @Override
            public final java.lang.String getMode() {
                return this.mode;
            }

            @Override
            public final java.lang.Number getYears() {
                return this.years;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDays() != null) {
                    data.set("days", om.valueToTree(this.getDays()));
                }
                if (this.getMode() != null) {
                    data.set("mode", om.valueToTree(this.getMode()));
                }
                if (this.getYears() != null) {
                    data.set("years", om.valueToTree(this.getYears()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.DefaultRetentionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DefaultRetentionProperty.Jsii$Proxy that = (DefaultRetentionProperty.Jsii$Proxy) o;

                if (this.days != null ? !this.days.equals(that.days) : that.days != null) return false;
                if (this.mode != null ? !this.mode.equals(that.mode) : that.mode != null) return false;
                return this.years != null ? this.years.equals(that.years) : that.years == null;
            }

            @Override
            public final int hashCode() {
                int result = this.days != null ? this.days.hashCode() : 0;
                result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
                result = 31 * result + (this.years != null ? this.years.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies whether Amazon S3 replicates delete markers.
     * <p>
     * If you specify a <code>Filter</code> in your replication configuration, you must also include a <code>DeleteMarkerReplication</code> element. If your <code>Filter</code> includes a <code>Tag</code> element, the <code>DeleteMarkerReplication</code> <code>Status</code> must be set to Disabled, because Amazon S3 does not support replicating delete markers for tag-based rules. For an example configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-config-min-rule-config">Basic Rule Configuration</a> .
     * <p>
     * For more information about delete marker replication, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/delete-marker-replication.html">Basic Rule Configuration</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you are using an earlier version of the replication configuration, Amazon S3 handles replication of delete markers differently. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-backward-compat-considerations">Backward Compatibility</a> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * DeleteMarkerReplicationProperty deleteMarkerReplicationProperty = DeleteMarkerReplicationProperty.builder()
     *         .status("status")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.DeleteMarkerReplicationProperty")
    @software.amazon.jsii.Jsii.Proxy(DeleteMarkerReplicationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeleteMarkerReplicationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether to replicate delete markers.
         * <p>
         * Disabled by default.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeleteMarkerReplicationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeleteMarkerReplicationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeleteMarkerReplicationProperty> {
            java.lang.String status;

            /**
             * Sets the value of {@link DeleteMarkerReplicationProperty#getStatus}
             * @param status Indicates whether to replicate delete markers.
             *               Disabled by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeleteMarkerReplicationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeleteMarkerReplicationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeleteMarkerReplicationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeleteMarkerReplicationProperty {
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.status = builder.status;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.DeleteMarkerReplicationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeleteMarkerReplicationProperty.Jsii$Proxy that = (DeleteMarkerReplicationProperty.Jsii$Proxy) o;

                return this.status != null ? this.status.equals(that.status) : that.status == null;
            }

            @Override
            public final int hashCode() {
                int result = this.status != null ? this.status.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies information about where to publish analysis or configuration results for an Amazon S3 bucket.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * DestinationProperty destinationProperty = DestinationProperty.builder()
     *         .bucketArn("bucketArn")
     *         .format("format")
     *         // the properties below are optional
     *         .bucketAccountId("bucketAccountId")
     *         .prefix("prefix")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.DestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(DestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the bucket to which data is exported.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketArn();

        /**
         * Specifies the file format used when exporting data to Amazon S3.
         * <p>
         * <em>Allowed values</em> : <code>CSV</code> | <code>ORC</code> | <code>Parquet</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFormat();

        /**
         * The account ID that owns the destination S3 bucket.
         * <p>
         * If no account ID is provided, the owner is not validated before exporting data.
         * <p>
         * <blockquote>
         * <p>
         * Although this value is optional, we strongly recommend that you set it to help prevent problems if the destination bucket ownership changes.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketAccountId() {
            return null;
        }

        /**
         * The prefix to use when exporting data.
         * <p>
         * The prefix is prepended to all results.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DestinationProperty> {
            java.lang.String bucketArn;
            java.lang.String format;
            java.lang.String bucketAccountId;
            java.lang.String prefix;

            /**
             * Sets the value of {@link DestinationProperty#getBucketArn}
             * @param bucketArn The Amazon Resource Name (ARN) of the bucket to which data is exported. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketArn(java.lang.String bucketArn) {
                this.bucketArn = bucketArn;
                return this;
            }

            /**
             * Sets the value of {@link DestinationProperty#getFormat}
             * @param format Specifies the file format used when exporting data to Amazon S3. This parameter is required.
             *               <em>Allowed values</em> : <code>CSV</code> | <code>ORC</code> | <code>Parquet</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder format(java.lang.String format) {
                this.format = format;
                return this;
            }

            /**
             * Sets the value of {@link DestinationProperty#getBucketAccountId}
             * @param bucketAccountId The account ID that owns the destination S3 bucket.
             *                        If no account ID is provided, the owner is not validated before exporting data.
             *                        <p>
             *                        <blockquote>
             *                        <p>
             *                        Although this value is optional, we strongly recommend that you set it to help prevent problems if the destination bucket ownership changes.
             *                        <p>
             *                        </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketAccountId(java.lang.String bucketAccountId) {
                this.bucketAccountId = bucketAccountId;
                return this;
            }

            /**
             * Sets the value of {@link DestinationProperty#getPrefix}
             * @param prefix The prefix to use when exporting data.
             *               The prefix is prepended to all results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DestinationProperty {
            private final java.lang.String bucketArn;
            private final java.lang.String format;
            private final java.lang.String bucketAccountId;
            private final java.lang.String prefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketArn = software.amazon.jsii.Kernel.get(this, "bucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.format = software.amazon.jsii.Kernel.get(this, "format", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketAccountId = software.amazon.jsii.Kernel.get(this, "bucketAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketArn = java.util.Objects.requireNonNull(builder.bucketArn, "bucketArn is required");
                this.format = java.util.Objects.requireNonNull(builder.format, "format is required");
                this.bucketAccountId = builder.bucketAccountId;
                this.prefix = builder.prefix;
            }

            @Override
            public final java.lang.String getBucketArn() {
                return this.bucketArn;
            }

            @Override
            public final java.lang.String getFormat() {
                return this.format;
            }

            @Override
            public final java.lang.String getBucketAccountId() {
                return this.bucketAccountId;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketArn", om.valueToTree(this.getBucketArn()));
                data.set("format", om.valueToTree(this.getFormat()));
                if (this.getBucketAccountId() != null) {
                    data.set("bucketAccountId", om.valueToTree(this.getBucketAccountId()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.DestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DestinationProperty.Jsii$Proxy that = (DestinationProperty.Jsii$Proxy) o;

                if (!bucketArn.equals(that.bucketArn)) return false;
                if (!format.equals(that.format)) return false;
                if (this.bucketAccountId != null ? !this.bucketAccountId.equals(that.bucketAccountId) : that.bucketAccountId != null) return false;
                return this.prefix != null ? this.prefix.equals(that.prefix) : that.prefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketArn.hashCode();
                result = 31 * result + (this.format.hashCode());
                result = 31 * result + (this.bucketAccountId != null ? this.bucketAccountId.hashCode() : 0);
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies encryption-related information for an Amazon S3 bucket that is a destination for replicated objects.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * EncryptionConfigurationProperty encryptionConfigurationProperty = EncryptionConfigurationProperty.builder()
     *         .replicaKmsKeyId("replicaKmsKeyId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.EncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the ID (Key ARN or Alias ARN) of the customer managed AWS KMS key stored in AWS Key Management Service (KMS) for the destination bucket.
         * <p>
         * Amazon S3 uses this key to encrypt replica objects. Amazon S3 only supports symmetric encryption KMS keys. For more information, see <a href="https://docs.aws.amazon.com//kms/latest/developerguide/symmetric-asymmetric.html">Asymmetric keys in AWS KMS</a> in the <em>AWS Key Management Service Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getReplicaKmsKeyId();

        /**
         * @return a {@link Builder} of {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionConfigurationProperty> {
            java.lang.String replicaKmsKeyId;

            /**
             * Sets the value of {@link EncryptionConfigurationProperty#getReplicaKmsKeyId}
             * @param replicaKmsKeyId Specifies the ID (Key ARN or Alias ARN) of the customer managed AWS KMS key stored in AWS Key Management Service (KMS) for the destination bucket. This parameter is required.
             *                        Amazon S3 uses this key to encrypt replica objects. Amazon S3 only supports symmetric encryption KMS keys. For more information, see <a href="https://docs.aws.amazon.com//kms/latest/developerguide/symmetric-asymmetric.html">Asymmetric keys in AWS KMS</a> in the <em>AWS Key Management Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replicaKmsKeyId(java.lang.String replicaKmsKeyId) {
                this.replicaKmsKeyId = replicaKmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionConfigurationProperty {
            private final java.lang.String replicaKmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.replicaKmsKeyId = software.amazon.jsii.Kernel.get(this, "replicaKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.replicaKmsKeyId = java.util.Objects.requireNonNull(builder.replicaKmsKeyId, "replicaKmsKeyId is required");
            }

            @Override
            public final java.lang.String getReplicaKmsKeyId() {
                return this.replicaKmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("replicaKmsKeyId", om.valueToTree(this.getReplicaKmsKeyId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.EncryptionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionConfigurationProperty.Jsii$Proxy that = (EncryptionConfigurationProperty.Jsii$Proxy) o;

                return this.replicaKmsKeyId.equals(that.replicaKmsKeyId);
            }

            @Override
            public final int hashCode() {
                int result = this.replicaKmsKeyId.hashCode();
                return result;
            }
        }
    }
    /**
     * Amazon S3 can send events to Amazon EventBridge whenever certain events happen in your bucket, see [Using EventBridge](https://docs.aws.amazon.com/AmazonS3/latest/userguide/EventBridge.html) in the *Amazon S3 User Guide* .
     * <p>
     * Unlike other destinations, delivery of events to EventBridge can be either enabled or disabled for a bucket. If enabled, all events will be sent to EventBridge and you can use EventBridge rules to route events to additional targets. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-what-is.html">What Is Amazon EventBridge</a> in the <em>Amazon EventBridge User Guide</em>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * EventBridgeConfigurationProperty eventBridgeConfigurationProperty = EventBridgeConfigurationProperty.builder()
     *         .eventBridgeEnabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.EventBridgeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EventBridgeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventBridgeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enables delivery of events to Amazon EventBridge.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEventBridgeEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EventBridgeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventBridgeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventBridgeConfigurationProperty> {
            java.lang.Object eventBridgeEnabled;

            /**
             * Sets the value of {@link EventBridgeConfigurationProperty#getEventBridgeEnabled}
             * @param eventBridgeEnabled Enables delivery of events to Amazon EventBridge.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventBridgeEnabled(java.lang.Boolean eventBridgeEnabled) {
                this.eventBridgeEnabled = eventBridgeEnabled;
                return this;
            }

            /**
             * Sets the value of {@link EventBridgeConfigurationProperty#getEventBridgeEnabled}
             * @param eventBridgeEnabled Enables delivery of events to Amazon EventBridge.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventBridgeEnabled(software.amazon.awscdk.core.IResolvable eventBridgeEnabled) {
                this.eventBridgeEnabled = eventBridgeEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventBridgeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventBridgeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventBridgeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventBridgeConfigurationProperty {
            private final java.lang.Object eventBridgeEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eventBridgeEnabled = software.amazon.jsii.Kernel.get(this, "eventBridgeEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eventBridgeEnabled = builder.eventBridgeEnabled;
            }

            @Override
            public final java.lang.Object getEventBridgeEnabled() {
                return this.eventBridgeEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEventBridgeEnabled() != null) {
                    data.set("eventBridgeEnabled", om.valueToTree(this.getEventBridgeEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.EventBridgeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventBridgeConfigurationProperty.Jsii$Proxy that = (EventBridgeConfigurationProperty.Jsii$Proxy) o;

                return this.eventBridgeEnabled != null ? this.eventBridgeEnabled.equals(that.eventBridgeEnabled) : that.eventBridgeEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.eventBridgeEnabled != null ? this.eventBridgeEnabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies the Amazon S3 object key name to filter on and whether to filter on the suffix or prefix of the key name.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * FilterRuleProperty filterRuleProperty = FilterRuleProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.FilterRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(FilterRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FilterRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object key name prefix or suffix identifying one or more objects to which the filtering rule applies.
         * <p>
         * The maximum length is 1,024 characters. Overlapping prefixes and suffixes are not supported. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a> in the <em>Amazon S3 User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The value that the filter searches for in object key names.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link FilterRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FilterRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FilterRuleProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link FilterRuleProperty#getName}
             * @param name The object key name prefix or suffix identifying one or more objects to which the filtering rule applies. This parameter is required.
             *             The maximum length is 1,024 characters. Overlapping prefixes and suffixes are not supported. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a> in the <em>Amazon S3 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link FilterRuleProperty#getValue}
             * @param value The value that the filter searches for in object key names. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FilterRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FilterRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FilterRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FilterRuleProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.FilterRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FilterRuleProperty.Jsii$Proxy that = (FilterRuleProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies the S3 Intelligent-Tiering configuration for an Amazon S3 bucket.
     * <p>
     * For information about the S3 Intelligent-Tiering storage class, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access">Storage class for automatically optimizing frequently and infrequently accessed objects</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * IntelligentTieringConfigurationProperty intelligentTieringConfigurationProperty = IntelligentTieringConfigurationProperty.builder()
     *         .id("id")
     *         .status("status")
     *         .tierings(List.of(TieringProperty.builder()
     *                 .accessTier("accessTier")
     *                 .days(123)
     *                 .build()))
     *         // the properties below are optional
     *         .prefix("prefix")
     *         .tagFilters(List.of(TagFilterProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.IntelligentTieringConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(IntelligentTieringConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IntelligentTieringConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID used to identify the S3 Intelligent-Tiering configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * Specifies the status of the configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatus();

        /**
         * Specifies a list of S3 Intelligent-Tiering storage class tiers in the configuration.
         * <p>
         * At least one tier must be defined in the list. At most, you can specify two tiers in the list, one for each available AccessTier: <code>ARCHIVE_ACCESS</code> and <code>DEEP_ARCHIVE_ACCESS</code> .
         * <p>
         * <blockquote>
         * <p>
         * You only need Intelligent Tiering Configuration enabled on a bucket if you want to automatically move objects stored in the Intelligent-Tiering storage class to Archive Access or Deep Archive Access tiers.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTierings();

        /**
         * An object key name prefix that identifies the subset of objects to which the rule applies.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * A container for a key-value pair.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagFilters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IntelligentTieringConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IntelligentTieringConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IntelligentTieringConfigurationProperty> {
            java.lang.String id;
            java.lang.String status;
            java.lang.Object tierings;
            java.lang.String prefix;
            java.lang.Object tagFilters;

            /**
             * Sets the value of {@link IntelligentTieringConfigurationProperty#getId}
             * @param id The ID used to identify the S3 Intelligent-Tiering configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link IntelligentTieringConfigurationProperty#getStatus}
             * @param status Specifies the status of the configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link IntelligentTieringConfigurationProperty#getTierings}
             * @param tierings Specifies a list of S3 Intelligent-Tiering storage class tiers in the configuration. This parameter is required.
             *                 At least one tier must be defined in the list. At most, you can specify two tiers in the list, one for each available AccessTier: <code>ARCHIVE_ACCESS</code> and <code>DEEP_ARCHIVE_ACCESS</code> .
             *                 <p>
             *                 <blockquote>
             *                 <p>
             *                 You only need Intelligent Tiering Configuration enabled on a bucket if you want to automatically move objects stored in the Intelligent-Tiering storage class to Archive Access or Deep Archive Access tiers.
             *                 <p>
             *                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tierings(software.amazon.awscdk.core.IResolvable tierings) {
                this.tierings = tierings;
                return this;
            }

            /**
             * Sets the value of {@link IntelligentTieringConfigurationProperty#getTierings}
             * @param tierings Specifies a list of S3 Intelligent-Tiering storage class tiers in the configuration. This parameter is required.
             *                 At least one tier must be defined in the list. At most, you can specify two tiers in the list, one for each available AccessTier: <code>ARCHIVE_ACCESS</code> and <code>DEEP_ARCHIVE_ACCESS</code> .
             *                 <p>
             *                 <blockquote>
             *                 <p>
             *                 You only need Intelligent Tiering Configuration enabled on a bucket if you want to automatically move objects stored in the Intelligent-Tiering storage class to Archive Access or Deep Archive Access tiers.
             *                 <p>
             *                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tierings(java.util.List<? extends java.lang.Object> tierings) {
                this.tierings = tierings;
                return this;
            }

            /**
             * Sets the value of {@link IntelligentTieringConfigurationProperty#getPrefix}
             * @param prefix An object key name prefix that identifies the subset of objects to which the rule applies.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of {@link IntelligentTieringConfigurationProperty#getTagFilters}
             * @param tagFilters A container for a key-value pair.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagFilters(software.amazon.awscdk.core.IResolvable tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Sets the value of {@link IntelligentTieringConfigurationProperty#getTagFilters}
             * @param tagFilters A container for a key-value pair.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagFilters(java.util.List<? extends java.lang.Object> tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntelligentTieringConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IntelligentTieringConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IntelligentTieringConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntelligentTieringConfigurationProperty {
            private final java.lang.String id;
            private final java.lang.String status;
            private final java.lang.Object tierings;
            private final java.lang.String prefix;
            private final java.lang.Object tagFilters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tierings = software.amazon.jsii.Kernel.get(this, "tierings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tagFilters = software.amazon.jsii.Kernel.get(this, "tagFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.status = java.util.Objects.requireNonNull(builder.status, "status is required");
                this.tierings = java.util.Objects.requireNonNull(builder.tierings, "tierings is required");
                this.prefix = builder.prefix;
                this.tagFilters = builder.tagFilters;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.lang.Object getTierings() {
                return this.tierings;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public final java.lang.Object getTagFilters() {
                return this.tagFilters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("id", om.valueToTree(this.getId()));
                data.set("status", om.valueToTree(this.getStatus()));
                data.set("tierings", om.valueToTree(this.getTierings()));
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }
                if (this.getTagFilters() != null) {
                    data.set("tagFilters", om.valueToTree(this.getTagFilters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.IntelligentTieringConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IntelligentTieringConfigurationProperty.Jsii$Proxy that = (IntelligentTieringConfigurationProperty.Jsii$Proxy) o;

                if (!id.equals(that.id)) return false;
                if (!status.equals(that.status)) return false;
                if (!tierings.equals(that.tierings)) return false;
                if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
                return this.tagFilters != null ? this.tagFilters.equals(that.tagFilters) : that.tagFilters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.id.hashCode();
                result = 31 * result + (this.status.hashCode());
                result = 31 * result + (this.tierings.hashCode());
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                result = 31 * result + (this.tagFilters != null ? this.tagFilters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the inventory configuration for an Amazon S3 bucket.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketGETInventoryConfig.html">GET Bucket inventory</a> in the <em>Amazon S3 API Reference</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * InventoryConfigurationProperty inventoryConfigurationProperty = InventoryConfigurationProperty.builder()
     *         .destination(DestinationProperty.builder()
     *                 .bucketArn("bucketArn")
     *                 .format("format")
     *                 // the properties below are optional
     *                 .bucketAccountId("bucketAccountId")
     *                 .prefix("prefix")
     *                 .build())
     *         .enabled(false)
     *         .id("id")
     *         .includedObjectVersions("includedObjectVersions")
     *         .scheduleFrequency("scheduleFrequency")
     *         // the properties below are optional
     *         .optionalFields(List.of("optionalFields"))
     *         .prefix("prefix")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.InventoryConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(InventoryConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InventoryConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains information about where to publish the inventory results.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDestination();

        /**
         * Specifies whether the inventory is enabled or disabled.
         * <p>
         * If set to <code>True</code> , an inventory list is generated. If set to <code>False</code> , no inventory list is generated.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * The ID used to identify the inventory configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * Object versions to include in the inventory list.
         * <p>
         * If set to <code>All</code> , the list includes all the object versions, which adds the version-related fields <code>VersionId</code> , <code>IsLatest</code> , and <code>DeleteMarker</code> to the list. If set to <code>Current</code> , the list does not contain these version-related fields.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIncludedObjectVersions();

        /**
         * Specifies the schedule for generating inventory results.
         * <p>
         * <em>Allowed values</em> : <code>Daily</code> | <code>Weekly</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getScheduleFrequency();

        /**
         * Contains the optional fields that are included in the inventory results.
         * <p>
         * <em>Valid values</em> : <code>Size | LastModifiedDate | StorageClass | ETag | IsMultipartUploaded | ReplicationStatus | EncryptionStatus | ObjectLockRetainUntilDate | ObjectLockMode | ObjectLockLegalHoldStatus | IntelligentTieringAccessTier | BucketKeyStatus</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOptionalFields() {
            return null;
        }

        /**
         * Specifies the inventory filter prefix.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InventoryConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InventoryConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InventoryConfigurationProperty> {
            java.lang.Object destination;
            java.lang.Object enabled;
            java.lang.String id;
            java.lang.String includedObjectVersions;
            java.lang.String scheduleFrequency;
            java.util.List<java.lang.String> optionalFields;
            java.lang.String prefix;

            /**
             * Sets the value of {@link InventoryConfigurationProperty#getDestination}
             * @param destination Contains information about where to publish the inventory results. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.core.IResolvable destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link InventoryConfigurationProperty#getDestination}
             * @param destination Contains information about where to publish the inventory results. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.services.s3.CfnBucket.DestinationProperty destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link InventoryConfigurationProperty#getEnabled}
             * @param enabled Specifies whether the inventory is enabled or disabled. This parameter is required.
             *                If set to <code>True</code> , an inventory list is generated. If set to <code>False</code> , no inventory list is generated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link InventoryConfigurationProperty#getEnabled}
             * @param enabled Specifies whether the inventory is enabled or disabled. This parameter is required.
             *                If set to <code>True</code> , an inventory list is generated. If set to <code>False</code> , no inventory list is generated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link InventoryConfigurationProperty#getId}
             * @param id The ID used to identify the inventory configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link InventoryConfigurationProperty#getIncludedObjectVersions}
             * @param includedObjectVersions Object versions to include in the inventory list. This parameter is required.
             *                               If set to <code>All</code> , the list includes all the object versions, which adds the version-related fields <code>VersionId</code> , <code>IsLatest</code> , and <code>DeleteMarker</code> to the list. If set to <code>Current</code> , the list does not contain these version-related fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includedObjectVersions(java.lang.String includedObjectVersions) {
                this.includedObjectVersions = includedObjectVersions;
                return this;
            }

            /**
             * Sets the value of {@link InventoryConfigurationProperty#getScheduleFrequency}
             * @param scheduleFrequency Specifies the schedule for generating inventory results. This parameter is required.
             *                          <em>Allowed values</em> : <code>Daily</code> | <code>Weekly</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleFrequency(java.lang.String scheduleFrequency) {
                this.scheduleFrequency = scheduleFrequency;
                return this;
            }

            /**
             * Sets the value of {@link InventoryConfigurationProperty#getOptionalFields}
             * @param optionalFields Contains the optional fields that are included in the inventory results.
             *                       <em>Valid values</em> : <code>Size | LastModifiedDate | StorageClass | ETag | IsMultipartUploaded | ReplicationStatus | EncryptionStatus | ObjectLockRetainUntilDate | ObjectLockMode | ObjectLockLegalHoldStatus | IntelligentTieringAccessTier | BucketKeyStatus</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder optionalFields(java.util.List<java.lang.String> optionalFields) {
                this.optionalFields = optionalFields;
                return this;
            }

            /**
             * Sets the value of {@link InventoryConfigurationProperty#getPrefix}
             * @param prefix Specifies the inventory filter prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InventoryConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InventoryConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InventoryConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InventoryConfigurationProperty {
            private final java.lang.Object destination;
            private final java.lang.Object enabled;
            private final java.lang.String id;
            private final java.lang.String includedObjectVersions;
            private final java.lang.String scheduleFrequency;
            private final java.util.List<java.lang.String> optionalFields;
            private final java.lang.String prefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.includedObjectVersions = software.amazon.jsii.Kernel.get(this, "includedObjectVersions", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scheduleFrequency = software.amazon.jsii.Kernel.get(this, "scheduleFrequency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.optionalFields = software.amazon.jsii.Kernel.get(this, "optionalFields", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destination = java.util.Objects.requireNonNull(builder.destination, "destination is required");
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.includedObjectVersions = java.util.Objects.requireNonNull(builder.includedObjectVersions, "includedObjectVersions is required");
                this.scheduleFrequency = java.util.Objects.requireNonNull(builder.scheduleFrequency, "scheduleFrequency is required");
                this.optionalFields = builder.optionalFields;
                this.prefix = builder.prefix;
            }

            @Override
            public final java.lang.Object getDestination() {
                return this.destination;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getIncludedObjectVersions() {
                return this.includedObjectVersions;
            }

            @Override
            public final java.lang.String getScheduleFrequency() {
                return this.scheduleFrequency;
            }

            @Override
            public final java.util.List<java.lang.String> getOptionalFields() {
                return this.optionalFields;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destination", om.valueToTree(this.getDestination()));
                data.set("enabled", om.valueToTree(this.getEnabled()));
                data.set("id", om.valueToTree(this.getId()));
                data.set("includedObjectVersions", om.valueToTree(this.getIncludedObjectVersions()));
                data.set("scheduleFrequency", om.valueToTree(this.getScheduleFrequency()));
                if (this.getOptionalFields() != null) {
                    data.set("optionalFields", om.valueToTree(this.getOptionalFields()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.InventoryConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InventoryConfigurationProperty.Jsii$Proxy that = (InventoryConfigurationProperty.Jsii$Proxy) o;

                if (!destination.equals(that.destination)) return false;
                if (!enabled.equals(that.enabled)) return false;
                if (!id.equals(that.id)) return false;
                if (!includedObjectVersions.equals(that.includedObjectVersions)) return false;
                if (!scheduleFrequency.equals(that.scheduleFrequency)) return false;
                if (this.optionalFields != null ? !this.optionalFields.equals(that.optionalFields) : that.optionalFields != null) return false;
                return this.prefix != null ? this.prefix.equals(that.prefix) : that.prefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destination.hashCode();
                result = 31 * result + (this.enabled.hashCode());
                result = 31 * result + (this.id.hashCode());
                result = 31 * result + (this.includedObjectVersions.hashCode());
                result = 31 * result + (this.scheduleFrequency.hashCode());
                result = 31 * result + (this.optionalFields != null ? this.optionalFields.hashCode() : 0);
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the AWS Lambda functions to invoke and the events for which to invoke them.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * LambdaConfigurationProperty lambdaConfigurationProperty = LambdaConfigurationProperty.builder()
     *         .event("event")
     *         .function("function")
     *         // the properties below are optional
     *         .filter(NotificationFilterProperty.builder()
     *                 .s3Key(S3KeyFilterProperty.builder()
     *                         .rules(List.of(FilterRuleProperty.builder()
     *                                 .name("name")
     *                                 .value("value")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.LambdaConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 bucket event for which to invoke the AWS Lambda function.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Supported Event Types</a> in the <em>Amazon S3 User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEvent();

        /**
         * The Amazon Resource Name (ARN) of the AWS Lambda function that Amazon S3 invokes when the specified event type occurs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFunction();

        /**
         * The filtering rules that determine which objects invoke the AWS Lambda function.
         * <p>
         * For example, you can create a filter so that only image files with a <code>.jpg</code> extension invoke the function when they are added to the Amazon S3 bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilter() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LambdaConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaConfigurationProperty> {
            java.lang.String event;
            java.lang.String function;
            java.lang.Object filter;

            /**
             * Sets the value of {@link LambdaConfigurationProperty#getEvent}
             * @param event The Amazon S3 bucket event for which to invoke the AWS Lambda function. This parameter is required.
             *              For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Supported Event Types</a> in the <em>Amazon S3 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder event(java.lang.String event) {
                this.event = event;
                return this;
            }

            /**
             * Sets the value of {@link LambdaConfigurationProperty#getFunction}
             * @param function The Amazon Resource Name (ARN) of the AWS Lambda function that Amazon S3 invokes when the specified event type occurs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder function(java.lang.String function) {
                this.function = function;
                return this;
            }

            /**
             * Sets the value of {@link LambdaConfigurationProperty#getFilter}
             * @param filter The filtering rules that determine which objects invoke the AWS Lambda function.
             *               For example, you can create a filter so that only image files with a <code>.jpg</code> extension invoke the function when they are added to the Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.core.IResolvable filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Sets the value of {@link LambdaConfigurationProperty#getFilter}
             * @param filter The filtering rules that determine which objects invoke the AWS Lambda function.
             *               For example, you can create a filter so that only image files with a <code>.jpg</code> extension invoke the function when they are added to the Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LambdaConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaConfigurationProperty {
            private final java.lang.String event;
            private final java.lang.String function;
            private final java.lang.Object filter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.event = software.amazon.jsii.Kernel.get(this, "event", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.function = software.amazon.jsii.Kernel.get(this, "function", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.filter = software.amazon.jsii.Kernel.get(this, "filter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.event = java.util.Objects.requireNonNull(builder.event, "event is required");
                this.function = java.util.Objects.requireNonNull(builder.function, "function is required");
                this.filter = builder.filter;
            }

            @Override
            public final java.lang.String getEvent() {
                return this.event;
            }

            @Override
            public final java.lang.String getFunction() {
                return this.function;
            }

            @Override
            public final java.lang.Object getFilter() {
                return this.filter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("event", om.valueToTree(this.getEvent()));
                data.set("function", om.valueToTree(this.getFunction()));
                if (this.getFilter() != null) {
                    data.set("filter", om.valueToTree(this.getFilter()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.LambdaConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaConfigurationProperty.Jsii$Proxy that = (LambdaConfigurationProperty.Jsii$Proxy) o;

                if (!event.equals(that.event)) return false;
                if (!function.equals(that.function)) return false;
                return this.filter != null ? this.filter.equals(that.filter) : that.filter == null;
            }

            @Override
            public final int hashCode() {
                int result = this.event.hashCode();
                result = 31 * result + (this.function.hashCode());
                result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the lifecycle configuration for objects in an Amazon S3 bucket.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html">Object Lifecycle Management</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * LifecycleConfigurationProperty lifecycleConfigurationProperty = LifecycleConfigurationProperty.builder()
     *         .rules(List.of(RuleProperty.builder()
     *                 .status("status")
     *                 // the properties below are optional
     *                 .abortIncompleteMultipartUpload(AbortIncompleteMultipartUploadProperty.builder()
     *                         .daysAfterInitiation(123)
     *                         .build())
     *                 .expirationDate(new Date())
     *                 .expirationInDays(123)
     *                 .expiredObjectDeleteMarker(false)
     *                 .id("id")
     *                 .noncurrentVersionExpiration(NoncurrentVersionExpirationProperty.builder()
     *                         .noncurrentDays(123)
     *                         // the properties below are optional
     *                         .newerNoncurrentVersions(123)
     *                         .build())
     *                 .noncurrentVersionExpirationInDays(123)
     *                 .noncurrentVersionTransition(NoncurrentVersionTransitionProperty.builder()
     *                         .storageClass("storageClass")
     *                         .transitionInDays(123)
     *                         // the properties below are optional
     *                         .newerNoncurrentVersions(123)
     *                         .build())
     *                 .noncurrentVersionTransitions(List.of(NoncurrentVersionTransitionProperty.builder()
     *                         .storageClass("storageClass")
     *                         .transitionInDays(123)
     *                         // the properties below are optional
     *                         .newerNoncurrentVersions(123)
     *                         .build()))
     *                 .objectSizeGreaterThan(123)
     *                 .objectSizeLessThan(123)
     *                 .prefix("prefix")
     *                 .tagFilters(List.of(TagFilterProperty.builder()
     *                         .key("key")
     *                         .value("value")
     *                         .build()))
     *                 .transition(TransitionProperty.builder()
     *                         .storageClass("storageClass")
     *                         // the properties below are optional
     *                         .transitionDate(new Date())
     *                         .transitionInDays(123)
     *                         .build())
     *                 .transitions(List.of(TransitionProperty.builder()
     *                         .storageClass("storageClass")
     *                         // the properties below are optional
     *                         .transitionDate(new Date())
     *                         .transitionInDays(123)
     *                         .build()))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.LifecycleConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LifecycleConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LifecycleConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A lifecycle rule for individual objects in an Amazon S3 bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRules();

        /**
         * @return a {@link Builder} of {@link LifecycleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LifecycleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LifecycleConfigurationProperty> {
            java.lang.Object rules;

            /**
             * Sets the value of {@link LifecycleConfigurationProperty#getRules}
             * @param rules A lifecycle rule for individual objects in an Amazon S3 bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(software.amazon.awscdk.core.IResolvable rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Sets the value of {@link LifecycleConfigurationProperty#getRules}
             * @param rules A lifecycle rule for individual objects in an Amazon S3 bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(java.util.List<? extends java.lang.Object> rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LifecycleConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LifecycleConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LifecycleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LifecycleConfigurationProperty {
            private final java.lang.Object rules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.rules = software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.rules = java.util.Objects.requireNonNull(builder.rules, "rules is required");
            }

            @Override
            public final java.lang.Object getRules() {
                return this.rules;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("rules", om.valueToTree(this.getRules()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.LifecycleConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LifecycleConfigurationProperty.Jsii$Proxy that = (LifecycleConfigurationProperty.Jsii$Proxy) o;

                return this.rules.equals(that.rules);
            }

            @Override
            public final int hashCode() {
                int result = this.rules.hashCode();
                return result;
            }
        }
    }
    /**
     * Describes where logs are stored and the prefix that Amazon S3 assigns to all log object keys for a bucket.
     * <p>
     * For examples and more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlogging.html">PUT Bucket logging</a> in the <em>Amazon S3 API Reference</em> .
     * <p>
     * <blockquote>
     * <p>
     * To successfully complete the <code>AWS::S3::Bucket LoggingConfiguration</code> request, you must have <code>s3:PutObject</code> and <code>s3:PutObjectAcl</code> in your IAM permissions.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * LoggingConfigurationProperty loggingConfigurationProperty = LoggingConfigurationProperty.builder()
     *         .destinationBucketName("destinationBucketName")
     *         .logFilePrefix("logFilePrefix")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.LoggingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LoggingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoggingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the bucket where Amazon S3 should store server access log files.
         * <p>
         * You can store log files in any bucket that you own. By default, logs are stored in the bucket where the <code>LoggingConfiguration</code> property is defined.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDestinationBucketName() {
            return null;
        }

        /**
         * A prefix for all log object keys.
         * <p>
         * If you store log files from multiple Amazon S3 buckets in a single bucket, you can use a prefix to distinguish which log files came from which bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogFilePrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoggingConfigurationProperty> {
            java.lang.String destinationBucketName;
            java.lang.String logFilePrefix;

            /**
             * Sets the value of {@link LoggingConfigurationProperty#getDestinationBucketName}
             * @param destinationBucketName The name of the bucket where Amazon S3 should store server access log files.
             *                              You can store log files in any bucket that you own. By default, logs are stored in the bucket where the <code>LoggingConfiguration</code> property is defined.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationBucketName(java.lang.String destinationBucketName) {
                this.destinationBucketName = destinationBucketName;
                return this;
            }

            /**
             * Sets the value of {@link LoggingConfigurationProperty#getLogFilePrefix}
             * @param logFilePrefix A prefix for all log object keys.
             *                      If you store log files from multiple Amazon S3 buckets in a single bucket, you can use a prefix to distinguish which log files came from which bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logFilePrefix(java.lang.String logFilePrefix) {
                this.logFilePrefix = logFilePrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoggingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingConfigurationProperty {
            private final java.lang.String destinationBucketName;
            private final java.lang.String logFilePrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationBucketName = software.amazon.jsii.Kernel.get(this, "destinationBucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logFilePrefix = software.amazon.jsii.Kernel.get(this, "logFilePrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationBucketName = builder.destinationBucketName;
                this.logFilePrefix = builder.logFilePrefix;
            }

            @Override
            public final java.lang.String getDestinationBucketName() {
                return this.destinationBucketName;
            }

            @Override
            public final java.lang.String getLogFilePrefix() {
                return this.logFilePrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDestinationBucketName() != null) {
                    data.set("destinationBucketName", om.valueToTree(this.getDestinationBucketName()));
                }
                if (this.getLogFilePrefix() != null) {
                    data.set("logFilePrefix", om.valueToTree(this.getLogFilePrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.LoggingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoggingConfigurationProperty.Jsii$Proxy that = (LoggingConfigurationProperty.Jsii$Proxy) o;

                if (this.destinationBucketName != null ? !this.destinationBucketName.equals(that.destinationBucketName) : that.destinationBucketName != null) return false;
                return this.logFilePrefix != null ? this.logFilePrefix.equals(that.logFilePrefix) : that.logFilePrefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destinationBucketName != null ? this.destinationBucketName.hashCode() : 0;
                result = 31 * result + (this.logFilePrefix != null ? this.logFilePrefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a metrics configuration for the CloudWatch request metrics (specified by the metrics configuration ID) from an Amazon S3 bucket.
     * <p>
     * If you're updating an existing metrics configuration, note that this is a full replacement of the existing metrics configuration. If you don't include the elements you want to keep, they are erased. For examples, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#aws-properties-s3-bucket--examples">AWS::S3::Bucket</a> . For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTMetricConfiguration.html">PUT Bucket metrics</a> in the <em>Amazon S3 API Reference</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * MetricsConfigurationProperty metricsConfigurationProperty = MetricsConfigurationProperty.builder()
     *         .id("id")
     *         // the properties below are optional
     *         .accessPointArn("accessPointArn")
     *         .prefix("prefix")
     *         .tagFilters(List.of(TagFilterProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.MetricsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID used to identify the metrics configuration.
         * <p>
         * This can be any value you choose that helps you identify your metrics configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * The access point that was used while performing operations on the object.
         * <p>
         * The metrics configuration only includes objects that meet the filter's criteria.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessPointArn() {
            return null;
        }

        /**
         * The prefix that an object must have to be included in the metrics results.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * Specifies a list of tag filters to use as a metrics configuration filter.
         * <p>
         * The metrics configuration includes only objects that meet the filter's criteria.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagFilters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetricsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricsConfigurationProperty> {
            java.lang.String id;
            java.lang.String accessPointArn;
            java.lang.String prefix;
            java.lang.Object tagFilters;

            /**
             * Sets the value of {@link MetricsConfigurationProperty#getId}
             * @param id The ID used to identify the metrics configuration. This parameter is required.
             *           This can be any value you choose that helps you identify your metrics configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link MetricsConfigurationProperty#getAccessPointArn}
             * @param accessPointArn The access point that was used while performing operations on the object.
             *                       The metrics configuration only includes objects that meet the filter's criteria.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessPointArn(java.lang.String accessPointArn) {
                this.accessPointArn = accessPointArn;
                return this;
            }

            /**
             * Sets the value of {@link MetricsConfigurationProperty#getPrefix}
             * @param prefix The prefix that an object must have to be included in the metrics results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of {@link MetricsConfigurationProperty#getTagFilters}
             * @param tagFilters Specifies a list of tag filters to use as a metrics configuration filter.
             *                   The metrics configuration includes only objects that meet the filter's criteria.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagFilters(software.amazon.awscdk.core.IResolvable tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Sets the value of {@link MetricsConfigurationProperty#getTagFilters}
             * @param tagFilters Specifies a list of tag filters to use as a metrics configuration filter.
             *                   The metrics configuration includes only objects that meet the filter's criteria.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagFilters(java.util.List<? extends java.lang.Object> tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricsConfigurationProperty {
            private final java.lang.String id;
            private final java.lang.String accessPointArn;
            private final java.lang.String prefix;
            private final java.lang.Object tagFilters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.accessPointArn = software.amazon.jsii.Kernel.get(this, "accessPointArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tagFilters = software.amazon.jsii.Kernel.get(this, "tagFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.accessPointArn = builder.accessPointArn;
                this.prefix = builder.prefix;
                this.tagFilters = builder.tagFilters;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getAccessPointArn() {
                return this.accessPointArn;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public final java.lang.Object getTagFilters() {
                return this.tagFilters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("id", om.valueToTree(this.getId()));
                if (this.getAccessPointArn() != null) {
                    data.set("accessPointArn", om.valueToTree(this.getAccessPointArn()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }
                if (this.getTagFilters() != null) {
                    data.set("tagFilters", om.valueToTree(this.getTagFilters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.MetricsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricsConfigurationProperty.Jsii$Proxy that = (MetricsConfigurationProperty.Jsii$Proxy) o;

                if (!id.equals(that.id)) return false;
                if (this.accessPointArn != null ? !this.accessPointArn.equals(that.accessPointArn) : that.accessPointArn != null) return false;
                if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
                return this.tagFilters != null ? this.tagFilters.equals(that.tagFilters) : that.tagFilters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.id.hashCode();
                result = 31 * result + (this.accessPointArn != null ? this.accessPointArn.hashCode() : 0);
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                result = 31 * result + (this.tagFilters != null ? this.tagFilters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A container specifying replication metrics-related settings enabling replication metrics and events.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * MetricsProperty metricsProperty = MetricsProperty.builder()
     *         .status("status")
     *         // the properties below are optional
     *         .eventThreshold(ReplicationTimeValueProperty.builder()
     *                 .minutes(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.MetricsProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether the replication metrics are enabled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatus();

        /**
         * A container specifying the time threshold for emitting the `s3:Replication:OperationMissedThreshold` event.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEventThreshold() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetricsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricsProperty> {
            java.lang.String status;
            java.lang.Object eventThreshold;

            /**
             * Sets the value of {@link MetricsProperty#getStatus}
             * @param status Specifies whether the replication metrics are enabled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link MetricsProperty#getEventThreshold}
             * @param eventThreshold A container specifying the time threshold for emitting the `s3:Replication:OperationMissedThreshold` event.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventThreshold(software.amazon.awscdk.core.IResolvable eventThreshold) {
                this.eventThreshold = eventThreshold;
                return this;
            }

            /**
             * Sets the value of {@link MetricsProperty#getEventThreshold}
             * @param eventThreshold A container specifying the time threshold for emitting the `s3:Replication:OperationMissedThreshold` event.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventThreshold(software.amazon.awscdk.services.s3.CfnBucket.ReplicationTimeValueProperty eventThreshold) {
                this.eventThreshold = eventThreshold;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricsProperty {
            private final java.lang.String status;
            private final java.lang.Object eventThreshold;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.eventThreshold = software.amazon.jsii.Kernel.get(this, "eventThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.status = java.util.Objects.requireNonNull(builder.status, "status is required");
                this.eventThreshold = builder.eventThreshold;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.lang.Object getEventThreshold() {
                return this.eventThreshold;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("status", om.valueToTree(this.getStatus()));
                if (this.getEventThreshold() != null) {
                    data.set("eventThreshold", om.valueToTree(this.getEventThreshold()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.MetricsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricsProperty.Jsii$Proxy that = (MetricsProperty.Jsii$Proxy) o;

                if (!status.equals(that.status)) return false;
                return this.eventThreshold != null ? this.eventThreshold.equals(that.eventThreshold) : that.eventThreshold == null;
            }

            @Override
            public final int hashCode() {
                int result = this.status.hashCode();
                result = 31 * result + (this.eventThreshold != null ? this.eventThreshold.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies when noncurrent object versions expire.
     * <p>
     * Upon expiration, Amazon S3 permanently deletes the noncurrent object versions. You set this lifecycle configuration action on a bucket that has versioning enabled (or suspended) to request that Amazon S3 delete noncurrent object versions at a specific period in the object's lifetime.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * NoncurrentVersionExpirationProperty noncurrentVersionExpirationProperty = NoncurrentVersionExpirationProperty.builder()
     *         .noncurrentDays(123)
     *         // the properties below are optional
     *         .newerNoncurrentVersions(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.NoncurrentVersionExpirationProperty")
    @software.amazon.jsii.Jsii.Proxy(NoncurrentVersionExpirationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NoncurrentVersionExpirationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action.
         * <p>
         * For information about the noncurrent days calculations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations">How Amazon S3 Calculates When an Object Became Noncurrent</a> in the <em>Amazon S3 User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getNoncurrentDays();

        /**
         * Specifies how many noncurrent versions Amazon S3 will retain.
         * <p>
         * If there are this many more recent noncurrent versions, Amazon S3 will take the associated action. For more information about noncurrent versions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/intro-lifecycle-rules.html">Lifecycle configuration elements</a> in the <em>Amazon S3 User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNewerNoncurrentVersions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NoncurrentVersionExpirationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NoncurrentVersionExpirationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NoncurrentVersionExpirationProperty> {
            java.lang.Number noncurrentDays;
            java.lang.Number newerNoncurrentVersions;

            /**
             * Sets the value of {@link NoncurrentVersionExpirationProperty#getNoncurrentDays}
             * @param noncurrentDays Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action. This parameter is required.
             *                       For information about the noncurrent days calculations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations">How Amazon S3 Calculates When an Object Became Noncurrent</a> in the <em>Amazon S3 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noncurrentDays(java.lang.Number noncurrentDays) {
                this.noncurrentDays = noncurrentDays;
                return this;
            }

            /**
             * Sets the value of {@link NoncurrentVersionExpirationProperty#getNewerNoncurrentVersions}
             * @param newerNoncurrentVersions Specifies how many noncurrent versions Amazon S3 will retain.
             *                                If there are this many more recent noncurrent versions, Amazon S3 will take the associated action. For more information about noncurrent versions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/intro-lifecycle-rules.html">Lifecycle configuration elements</a> in the <em>Amazon S3 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder newerNoncurrentVersions(java.lang.Number newerNoncurrentVersions) {
                this.newerNoncurrentVersions = newerNoncurrentVersions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NoncurrentVersionExpirationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NoncurrentVersionExpirationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NoncurrentVersionExpirationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NoncurrentVersionExpirationProperty {
            private final java.lang.Number noncurrentDays;
            private final java.lang.Number newerNoncurrentVersions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.noncurrentDays = software.amazon.jsii.Kernel.get(this, "noncurrentDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.newerNoncurrentVersions = software.amazon.jsii.Kernel.get(this, "newerNoncurrentVersions", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.noncurrentDays = java.util.Objects.requireNonNull(builder.noncurrentDays, "noncurrentDays is required");
                this.newerNoncurrentVersions = builder.newerNoncurrentVersions;
            }

            @Override
            public final java.lang.Number getNoncurrentDays() {
                return this.noncurrentDays;
            }

            @Override
            public final java.lang.Number getNewerNoncurrentVersions() {
                return this.newerNoncurrentVersions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("noncurrentDays", om.valueToTree(this.getNoncurrentDays()));
                if (this.getNewerNoncurrentVersions() != null) {
                    data.set("newerNoncurrentVersions", om.valueToTree(this.getNewerNoncurrentVersions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.NoncurrentVersionExpirationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NoncurrentVersionExpirationProperty.Jsii$Proxy that = (NoncurrentVersionExpirationProperty.Jsii$Proxy) o;

                if (!noncurrentDays.equals(that.noncurrentDays)) return false;
                return this.newerNoncurrentVersions != null ? this.newerNoncurrentVersions.equals(that.newerNoncurrentVersions) : that.newerNoncurrentVersions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.noncurrentDays.hashCode();
                result = 31 * result + (this.newerNoncurrentVersions != null ? this.newerNoncurrentVersions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Container for the transition rule that describes when noncurrent objects transition to the `STANDARD_IA` , `ONEZONE_IA` , `INTELLIGENT_TIERING` , `GLACIER_IR` , `GLACIER` , or `DEEP_ARCHIVE` storage class.
     * <p>
     * If your bucket is versioning-enabled (or versioning is suspended), you can set this action to request that Amazon S3 transition noncurrent object versions to the <code>STANDARD_IA</code> , <code>ONEZONE_IA</code> , <code>INTELLIGENT_TIERING</code> , <code>GLACIER_IR</code> , <code>GLACIER</code> , or <code>DEEP_ARCHIVE</code> storage class at a specific period in the object's lifetime. If you specify this property, don't specify the <code>NoncurrentVersionTransitions</code> property.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * NoncurrentVersionTransitionProperty noncurrentVersionTransitionProperty = NoncurrentVersionTransitionProperty.builder()
     *         .storageClass("storageClass")
     *         .transitionInDays(123)
     *         // the properties below are optional
     *         .newerNoncurrentVersions(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.NoncurrentVersionTransitionProperty")
    @software.amazon.jsii.Jsii.Proxy(NoncurrentVersionTransitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NoncurrentVersionTransitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The class of storage used to store the object.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStorageClass();

        /**
         * Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action.
         * <p>
         * For information about the noncurrent days calculations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations">How Amazon S3 Calculates How Long an Object Has Been Noncurrent</a> in the <em>Amazon S3 User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTransitionInDays();

        /**
         * Specifies how many noncurrent versions Amazon S3 will retain.
         * <p>
         * If there are this many more recent noncurrent versions, Amazon S3 will take the associated action. For more information about noncurrent versions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/intro-lifecycle-rules.html">Lifecycle configuration elements</a> in the <em>Amazon S3 User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNewerNoncurrentVersions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NoncurrentVersionTransitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NoncurrentVersionTransitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NoncurrentVersionTransitionProperty> {
            java.lang.String storageClass;
            java.lang.Number transitionInDays;
            java.lang.Number newerNoncurrentVersions;

            /**
             * Sets the value of {@link NoncurrentVersionTransitionProperty#getStorageClass}
             * @param storageClass The class of storage used to store the object. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageClass(java.lang.String storageClass) {
                this.storageClass = storageClass;
                return this;
            }

            /**
             * Sets the value of {@link NoncurrentVersionTransitionProperty#getTransitionInDays}
             * @param transitionInDays Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action. This parameter is required.
             *                         For information about the noncurrent days calculations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations">How Amazon S3 Calculates How Long an Object Has Been Noncurrent</a> in the <em>Amazon S3 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitionInDays(java.lang.Number transitionInDays) {
                this.transitionInDays = transitionInDays;
                return this;
            }

            /**
             * Sets the value of {@link NoncurrentVersionTransitionProperty#getNewerNoncurrentVersions}
             * @param newerNoncurrentVersions Specifies how many noncurrent versions Amazon S3 will retain.
             *                                If there are this many more recent noncurrent versions, Amazon S3 will take the associated action. For more information about noncurrent versions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/intro-lifecycle-rules.html">Lifecycle configuration elements</a> in the <em>Amazon S3 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder newerNoncurrentVersions(java.lang.Number newerNoncurrentVersions) {
                this.newerNoncurrentVersions = newerNoncurrentVersions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NoncurrentVersionTransitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NoncurrentVersionTransitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NoncurrentVersionTransitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NoncurrentVersionTransitionProperty {
            private final java.lang.String storageClass;
            private final java.lang.Number transitionInDays;
            private final java.lang.Number newerNoncurrentVersions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.storageClass = software.amazon.jsii.Kernel.get(this, "storageClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.transitionInDays = software.amazon.jsii.Kernel.get(this, "transitionInDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.newerNoncurrentVersions = software.amazon.jsii.Kernel.get(this, "newerNoncurrentVersions", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.storageClass = java.util.Objects.requireNonNull(builder.storageClass, "storageClass is required");
                this.transitionInDays = java.util.Objects.requireNonNull(builder.transitionInDays, "transitionInDays is required");
                this.newerNoncurrentVersions = builder.newerNoncurrentVersions;
            }

            @Override
            public final java.lang.String getStorageClass() {
                return this.storageClass;
            }

            @Override
            public final java.lang.Number getTransitionInDays() {
                return this.transitionInDays;
            }

            @Override
            public final java.lang.Number getNewerNoncurrentVersions() {
                return this.newerNoncurrentVersions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("storageClass", om.valueToTree(this.getStorageClass()));
                data.set("transitionInDays", om.valueToTree(this.getTransitionInDays()));
                if (this.getNewerNoncurrentVersions() != null) {
                    data.set("newerNoncurrentVersions", om.valueToTree(this.getNewerNoncurrentVersions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.NoncurrentVersionTransitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NoncurrentVersionTransitionProperty.Jsii$Proxy that = (NoncurrentVersionTransitionProperty.Jsii$Proxy) o;

                if (!storageClass.equals(that.storageClass)) return false;
                if (!transitionInDays.equals(that.transitionInDays)) return false;
                return this.newerNoncurrentVersions != null ? this.newerNoncurrentVersions.equals(that.newerNoncurrentVersions) : that.newerNoncurrentVersions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.storageClass.hashCode();
                result = 31 * result + (this.transitionInDays.hashCode());
                result = 31 * result + (this.newerNoncurrentVersions != null ? this.newerNoncurrentVersions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the notification configuration for an Amazon S3 bucket.
     * <p>
     * <blockquote>
     * <p>
     * If you create the target resource and related permissions in the same template, you might have a circular dependency.
     * <p>
     * For example, you might use the <code>AWS::Lambda::Permission</code> resource to grant the bucket permission to invoke an AWS Lambda function. However, AWS CloudFormation can't create the bucket until the bucket has permission to invoke the function ( AWS CloudFormation checks whether the bucket can invoke the function). If you're using Refs to pass the bucket name, this leads to a circular dependency.
     * <p>
     * To avoid this dependency, you can create all resources without specifying the notification configuration. Then, update the stack with a notification configuration.
     * <p>
     * For more information on permissions, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html">AWS::Lambda::Permission</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#grant-destinations-permissions-to-s3">Granting Permissions to Publish Event Notification Messages to a Destination</a> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * NotificationConfigurationProperty notificationConfigurationProperty = NotificationConfigurationProperty.builder()
     *         .eventBridgeConfiguration(EventBridgeConfigurationProperty.builder()
     *                 .eventBridgeEnabled(false)
     *                 .build())
     *         .lambdaConfigurations(List.of(LambdaConfigurationProperty.builder()
     *                 .event("event")
     *                 .function("function")
     *                 // the properties below are optional
     *                 .filter(NotificationFilterProperty.builder()
     *                         .s3Key(S3KeyFilterProperty.builder()
     *                                 .rules(List.of(FilterRuleProperty.builder()
     *                                         .name("name")
     *                                         .value("value")
     *                                         .build()))
     *                                 .build())
     *                         .build())
     *                 .build()))
     *         .queueConfigurations(List.of(QueueConfigurationProperty.builder()
     *                 .event("event")
     *                 .queue("queue")
     *                 // the properties below are optional
     *                 .filter(NotificationFilterProperty.builder()
     *                         .s3Key(S3KeyFilterProperty.builder()
     *                                 .rules(List.of(FilterRuleProperty.builder()
     *                                         .name("name")
     *                                         .value("value")
     *                                         .build()))
     *                                 .build())
     *                         .build())
     *                 .build()))
     *         .topicConfigurations(List.of(TopicConfigurationProperty.builder()
     *                 .event("event")
     *                 .topic("topic")
     *                 // the properties below are optional
     *                 .filter(NotificationFilterProperty.builder()
     *                         .s3Key(S3KeyFilterProperty.builder()
     *                                 .rules(List.of(FilterRuleProperty.builder()
     *                                         .name("name")
     *                                         .value("value")
     *                                         .build()))
     *                                 .build())
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.NotificationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(NotificationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NotificationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enables delivery of events to Amazon EventBridge.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEventBridgeConfiguration() {
            return null;
        }

        /**
         * Describes the AWS Lambda functions to invoke and the events for which to invoke them.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLambdaConfigurations() {
            return null;
        }

        /**
         * The Amazon Simple Queue Service queues to publish messages to and the events for which to publish messages.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getQueueConfigurations() {
            return null;
        }

        /**
         * The topic to which notifications are sent and the events for which notifications are generated.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTopicConfigurations() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NotificationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NotificationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NotificationConfigurationProperty> {
            java.lang.Object eventBridgeConfiguration;
            java.lang.Object lambdaConfigurations;
            java.lang.Object queueConfigurations;
            java.lang.Object topicConfigurations;

            /**
             * Sets the value of {@link NotificationConfigurationProperty#getEventBridgeConfiguration}
             * @param eventBridgeConfiguration Enables delivery of events to Amazon EventBridge.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventBridgeConfiguration(software.amazon.awscdk.core.IResolvable eventBridgeConfiguration) {
                this.eventBridgeConfiguration = eventBridgeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link NotificationConfigurationProperty#getEventBridgeConfiguration}
             * @param eventBridgeConfiguration Enables delivery of events to Amazon EventBridge.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventBridgeConfiguration(software.amazon.awscdk.services.s3.CfnBucket.EventBridgeConfigurationProperty eventBridgeConfiguration) {
                this.eventBridgeConfiguration = eventBridgeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link NotificationConfigurationProperty#getLambdaConfigurations}
             * @param lambdaConfigurations Describes the AWS Lambda functions to invoke and the events for which to invoke them.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaConfigurations(software.amazon.awscdk.core.IResolvable lambdaConfigurations) {
                this.lambdaConfigurations = lambdaConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link NotificationConfigurationProperty#getLambdaConfigurations}
             * @param lambdaConfigurations Describes the AWS Lambda functions to invoke and the events for which to invoke them.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaConfigurations(java.util.List<? extends java.lang.Object> lambdaConfigurations) {
                this.lambdaConfigurations = lambdaConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link NotificationConfigurationProperty#getQueueConfigurations}
             * @param queueConfigurations The Amazon Simple Queue Service queues to publish messages to and the events for which to publish messages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queueConfigurations(software.amazon.awscdk.core.IResolvable queueConfigurations) {
                this.queueConfigurations = queueConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link NotificationConfigurationProperty#getQueueConfigurations}
             * @param queueConfigurations The Amazon Simple Queue Service queues to publish messages to and the events for which to publish messages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queueConfigurations(java.util.List<? extends java.lang.Object> queueConfigurations) {
                this.queueConfigurations = queueConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link NotificationConfigurationProperty#getTopicConfigurations}
             * @param topicConfigurations The topic to which notifications are sent and the events for which notifications are generated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicConfigurations(software.amazon.awscdk.core.IResolvable topicConfigurations) {
                this.topicConfigurations = topicConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link NotificationConfigurationProperty#getTopicConfigurations}
             * @param topicConfigurations The topic to which notifications are sent and the events for which notifications are generated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicConfigurations(java.util.List<? extends java.lang.Object> topicConfigurations) {
                this.topicConfigurations = topicConfigurations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotificationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NotificationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NotificationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NotificationConfigurationProperty {
            private final java.lang.Object eventBridgeConfiguration;
            private final java.lang.Object lambdaConfigurations;
            private final java.lang.Object queueConfigurations;
            private final java.lang.Object topicConfigurations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eventBridgeConfiguration = software.amazon.jsii.Kernel.get(this, "eventBridgeConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lambdaConfigurations = software.amazon.jsii.Kernel.get(this, "lambdaConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.queueConfigurations = software.amazon.jsii.Kernel.get(this, "queueConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.topicConfigurations = software.amazon.jsii.Kernel.get(this, "topicConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eventBridgeConfiguration = builder.eventBridgeConfiguration;
                this.lambdaConfigurations = builder.lambdaConfigurations;
                this.queueConfigurations = builder.queueConfigurations;
                this.topicConfigurations = builder.topicConfigurations;
            }

            @Override
            public final java.lang.Object getEventBridgeConfiguration() {
                return this.eventBridgeConfiguration;
            }

            @Override
            public final java.lang.Object getLambdaConfigurations() {
                return this.lambdaConfigurations;
            }

            @Override
            public final java.lang.Object getQueueConfigurations() {
                return this.queueConfigurations;
            }

            @Override
            public final java.lang.Object getTopicConfigurations() {
                return this.topicConfigurations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEventBridgeConfiguration() != null) {
                    data.set("eventBridgeConfiguration", om.valueToTree(this.getEventBridgeConfiguration()));
                }
                if (this.getLambdaConfigurations() != null) {
                    data.set("lambdaConfigurations", om.valueToTree(this.getLambdaConfigurations()));
                }
                if (this.getQueueConfigurations() != null) {
                    data.set("queueConfigurations", om.valueToTree(this.getQueueConfigurations()));
                }
                if (this.getTopicConfigurations() != null) {
                    data.set("topicConfigurations", om.valueToTree(this.getTopicConfigurations()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.NotificationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NotificationConfigurationProperty.Jsii$Proxy that = (NotificationConfigurationProperty.Jsii$Proxy) o;

                if (this.eventBridgeConfiguration != null ? !this.eventBridgeConfiguration.equals(that.eventBridgeConfiguration) : that.eventBridgeConfiguration != null) return false;
                if (this.lambdaConfigurations != null ? !this.lambdaConfigurations.equals(that.lambdaConfigurations) : that.lambdaConfigurations != null) return false;
                if (this.queueConfigurations != null ? !this.queueConfigurations.equals(that.queueConfigurations) : that.queueConfigurations != null) return false;
                return this.topicConfigurations != null ? this.topicConfigurations.equals(that.topicConfigurations) : that.topicConfigurations == null;
            }

            @Override
            public final int hashCode() {
                int result = this.eventBridgeConfiguration != null ? this.eventBridgeConfiguration.hashCode() : 0;
                result = 31 * result + (this.lambdaConfigurations != null ? this.lambdaConfigurations.hashCode() : 0);
                result = 31 * result + (this.queueConfigurations != null ? this.queueConfigurations.hashCode() : 0);
                result = 31 * result + (this.topicConfigurations != null ? this.topicConfigurations.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies object key name filtering rules.
     * <p>
     * For information about key name filtering, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * NotificationFilterProperty notificationFilterProperty = NotificationFilterProperty.builder()
     *         .s3Key(S3KeyFilterProperty.builder()
     *                 .rules(List.of(FilterRuleProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.NotificationFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(NotificationFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NotificationFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A container for object key name prefix and suffix filtering rules.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3Key();

        /**
         * @return a {@link Builder} of {@link NotificationFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NotificationFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NotificationFilterProperty> {
            java.lang.Object s3Key;

            /**
             * Sets the value of {@link NotificationFilterProperty#getS3Key}
             * @param s3Key A container for object key name prefix and suffix filtering rules. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Key(software.amazon.awscdk.core.IResolvable s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            /**
             * Sets the value of {@link NotificationFilterProperty#getS3Key}
             * @param s3Key A container for object key name prefix and suffix filtering rules. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Key(software.amazon.awscdk.services.s3.CfnBucket.S3KeyFilterProperty s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotificationFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NotificationFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NotificationFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NotificationFilterProperty {
            private final java.lang.Object s3Key;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Key = software.amazon.jsii.Kernel.get(this, "s3Key", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Key = java.util.Objects.requireNonNull(builder.s3Key, "s3Key is required");
            }

            @Override
            public final java.lang.Object getS3Key() {
                return this.s3Key;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3Key", om.valueToTree(this.getS3Key()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.NotificationFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NotificationFilterProperty.Jsii$Proxy that = (NotificationFilterProperty.Jsii$Proxy) o;

                return this.s3Key.equals(that.s3Key);
            }

            @Override
            public final int hashCode() {
                int result = this.s3Key.hashCode();
                return result;
            }
        }
    }
    /**
     * Places an Object Lock configuration on the specified bucket.
     * <p>
     * The rule specified in the Object Lock configuration will be applied by default to every new object placed in the specified bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Locking Objects</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * ObjectLockConfigurationProperty objectLockConfigurationProperty = ObjectLockConfigurationProperty.builder()
     *         .objectLockEnabled("objectLockEnabled")
     *         .rule(ObjectLockRuleProperty.builder()
     *                 .defaultRetention(DefaultRetentionProperty.builder()
     *                         .days(123)
     *                         .mode("mode")
     *                         .years(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.ObjectLockConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ObjectLockConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ObjectLockConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether this bucket has an Object Lock configuration enabled.
         * <p>
         * Enable <code>ObjectLockEnabled</code> when you apply <code>ObjectLockConfiguration</code> to a bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getObjectLockEnabled() {
            return null;
        }

        /**
         * Specifies the Object Lock rule for the specified object.
         * <p>
         * Enable this rule when you apply <code>ObjectLockConfiguration</code> to a bucket. If Object Lock is turned on, bucket settings require both <code>Mode</code> and a period of either <code>Days</code> or <code>Years</code> . You cannot specify <code>Days</code> and <code>Years</code> at the same time. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockrule.html">ObjectLockRule</a> and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html">DefaultRetention</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRule() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ObjectLockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ObjectLockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ObjectLockConfigurationProperty> {
            java.lang.String objectLockEnabled;
            java.lang.Object rule;

            /**
             * Sets the value of {@link ObjectLockConfigurationProperty#getObjectLockEnabled}
             * @param objectLockEnabled Indicates whether this bucket has an Object Lock configuration enabled.
             *                          Enable <code>ObjectLockEnabled</code> when you apply <code>ObjectLockConfiguration</code> to a bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectLockEnabled(java.lang.String objectLockEnabled) {
                this.objectLockEnabled = objectLockEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ObjectLockConfigurationProperty#getRule}
             * @param rule Specifies the Object Lock rule for the specified object.
             *             Enable this rule when you apply <code>ObjectLockConfiguration</code> to a bucket. If Object Lock is turned on, bucket settings require both <code>Mode</code> and a period of either <code>Days</code> or <code>Years</code> . You cannot specify <code>Days</code> and <code>Years</code> at the same time. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockrule.html">ObjectLockRule</a> and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html">DefaultRetention</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rule(software.amazon.awscdk.core.IResolvable rule) {
                this.rule = rule;
                return this;
            }

            /**
             * Sets the value of {@link ObjectLockConfigurationProperty#getRule}
             * @param rule Specifies the Object Lock rule for the specified object.
             *             Enable this rule when you apply <code>ObjectLockConfiguration</code> to a bucket. If Object Lock is turned on, bucket settings require both <code>Mode</code> and a period of either <code>Days</code> or <code>Years</code> . You cannot specify <code>Days</code> and <code>Years</code> at the same time. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockrule.html">ObjectLockRule</a> and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html">DefaultRetention</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rule(software.amazon.awscdk.services.s3.CfnBucket.ObjectLockRuleProperty rule) {
                this.rule = rule;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ObjectLockConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ObjectLockConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ObjectLockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ObjectLockConfigurationProperty {
            private final java.lang.String objectLockEnabled;
            private final java.lang.Object rule;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.objectLockEnabled = software.amazon.jsii.Kernel.get(this, "objectLockEnabled", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rule = software.amazon.jsii.Kernel.get(this, "rule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.objectLockEnabled = builder.objectLockEnabled;
                this.rule = builder.rule;
            }

            @Override
            public final java.lang.String getObjectLockEnabled() {
                return this.objectLockEnabled;
            }

            @Override
            public final java.lang.Object getRule() {
                return this.rule;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getObjectLockEnabled() != null) {
                    data.set("objectLockEnabled", om.valueToTree(this.getObjectLockEnabled()));
                }
                if (this.getRule() != null) {
                    data.set("rule", om.valueToTree(this.getRule()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.ObjectLockConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ObjectLockConfigurationProperty.Jsii$Proxy that = (ObjectLockConfigurationProperty.Jsii$Proxy) o;

                if (this.objectLockEnabled != null ? !this.objectLockEnabled.equals(that.objectLockEnabled) : that.objectLockEnabled != null) return false;
                return this.rule != null ? this.rule.equals(that.rule) : that.rule == null;
            }

            @Override
            public final int hashCode() {
                int result = this.objectLockEnabled != null ? this.objectLockEnabled.hashCode() : 0;
                result = 31 * result + (this.rule != null ? this.rule.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the Object Lock rule for the specified object.
     * <p>
     * Enable the this rule when you apply <code>ObjectLockConfiguration</code> to a bucket.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * ObjectLockRuleProperty objectLockRuleProperty = ObjectLockRuleProperty.builder()
     *         .defaultRetention(DefaultRetentionProperty.builder()
     *                 .days(123)
     *                 .mode("mode")
     *                 .years(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.ObjectLockRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(ObjectLockRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ObjectLockRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The default Object Lock retention mode and period that you want to apply to new objects placed in the specified bucket.
         * <p>
         * If Object Lock is turned on, bucket settings require both <code>Mode</code> and a period of either <code>Days</code> or <code>Years</code> . You cannot specify <code>Days</code> and <code>Years</code> at the same time. For more information about allowable values for mode and period, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html">DefaultRetention</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultRetention() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ObjectLockRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ObjectLockRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ObjectLockRuleProperty> {
            java.lang.Object defaultRetention;

            /**
             * Sets the value of {@link ObjectLockRuleProperty#getDefaultRetention}
             * @param defaultRetention The default Object Lock retention mode and period that you want to apply to new objects placed in the specified bucket.
             *                         If Object Lock is turned on, bucket settings require both <code>Mode</code> and a period of either <code>Days</code> or <code>Years</code> . You cannot specify <code>Days</code> and <code>Years</code> at the same time. For more information about allowable values for mode and period, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html">DefaultRetention</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultRetention(software.amazon.awscdk.core.IResolvable defaultRetention) {
                this.defaultRetention = defaultRetention;
                return this;
            }

            /**
             * Sets the value of {@link ObjectLockRuleProperty#getDefaultRetention}
             * @param defaultRetention The default Object Lock retention mode and period that you want to apply to new objects placed in the specified bucket.
             *                         If Object Lock is turned on, bucket settings require both <code>Mode</code> and a period of either <code>Days</code> or <code>Years</code> . You cannot specify <code>Days</code> and <code>Years</code> at the same time. For more information about allowable values for mode and period, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html">DefaultRetention</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultRetention(software.amazon.awscdk.services.s3.CfnBucket.DefaultRetentionProperty defaultRetention) {
                this.defaultRetention = defaultRetention;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ObjectLockRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ObjectLockRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ObjectLockRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ObjectLockRuleProperty {
            private final java.lang.Object defaultRetention;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultRetention = software.amazon.jsii.Kernel.get(this, "defaultRetention", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultRetention = builder.defaultRetention;
            }

            @Override
            public final java.lang.Object getDefaultRetention() {
                return this.defaultRetention;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDefaultRetention() != null) {
                    data.set("defaultRetention", om.valueToTree(this.getDefaultRetention()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.ObjectLockRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ObjectLockRuleProperty.Jsii$Proxy that = (ObjectLockRuleProperty.Jsii$Proxy) o;

                return this.defaultRetention != null ? this.defaultRetention.equals(that.defaultRetention) : that.defaultRetention == null;
            }

            @Override
            public final int hashCode() {
                int result = this.defaultRetention != null ? this.defaultRetention.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies the container element for Object Ownership rules.
     * <p>
     * S3 Object Ownership is an Amazon S3 bucket-level setting that you can use to disable access control lists (ACLs) and take ownership of every object in your bucket, simplifying access management for data stored in Amazon S3. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling ownership of objects and disabling ACLs</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * OwnershipControlsProperty ownershipControlsProperty = OwnershipControlsProperty.builder()
     *         .rules(List.of(OwnershipControlsRuleProperty.builder()
     *                 .objectOwnership("objectOwnership")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.OwnershipControlsProperty")
    @software.amazon.jsii.Jsii.Proxy(OwnershipControlsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OwnershipControlsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the container element for Object Ownership rules.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRules();

        /**
         * @return a {@link Builder} of {@link OwnershipControlsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OwnershipControlsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OwnershipControlsProperty> {
            java.lang.Object rules;

            /**
             * Sets the value of {@link OwnershipControlsProperty#getRules}
             * @param rules Specifies the container element for Object Ownership rules. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(software.amazon.awscdk.core.IResolvable rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Sets the value of {@link OwnershipControlsProperty#getRules}
             * @param rules Specifies the container element for Object Ownership rules. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(java.util.List<? extends java.lang.Object> rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OwnershipControlsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OwnershipControlsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OwnershipControlsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OwnershipControlsProperty {
            private final java.lang.Object rules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.rules = software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.rules = java.util.Objects.requireNonNull(builder.rules, "rules is required");
            }

            @Override
            public final java.lang.Object getRules() {
                return this.rules;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("rules", om.valueToTree(this.getRules()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.OwnershipControlsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OwnershipControlsProperty.Jsii$Proxy that = (OwnershipControlsProperty.Jsii$Proxy) o;

                return this.rules.equals(that.rules);
            }

            @Override
            public final int hashCode() {
                int result = this.rules.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies an Object Ownership rule.
     * <p>
     * S3 Object Ownership is an Amazon S3 bucket-level setting that you can use to disable access control lists (ACLs) and take ownership of every object in your bucket, simplifying access management for data stored in Amazon S3. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling ownership of objects and disabling ACLs</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * OwnershipControlsRuleProperty ownershipControlsRuleProperty = OwnershipControlsRuleProperty.builder()
     *         .objectOwnership("objectOwnership")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.OwnershipControlsRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(OwnershipControlsRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OwnershipControlsRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies an Object Ownership rule.
         * <p>
         * <em>Allowed values</em> : <code>BucketOwnerEnforced</code> | <code>ObjectWriter</code> | <code>BucketOwnerPreferred</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getObjectOwnership() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OwnershipControlsRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OwnershipControlsRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OwnershipControlsRuleProperty> {
            java.lang.String objectOwnership;

            /**
             * Sets the value of {@link OwnershipControlsRuleProperty#getObjectOwnership}
             * @param objectOwnership Specifies an Object Ownership rule.
             *                        <em>Allowed values</em> : <code>BucketOwnerEnforced</code> | <code>ObjectWriter</code> | <code>BucketOwnerPreferred</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectOwnership(java.lang.String objectOwnership) {
                this.objectOwnership = objectOwnership;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OwnershipControlsRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OwnershipControlsRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OwnershipControlsRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OwnershipControlsRuleProperty {
            private final java.lang.String objectOwnership;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.objectOwnership = software.amazon.jsii.Kernel.get(this, "objectOwnership", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.objectOwnership = builder.objectOwnership;
            }

            @Override
            public final java.lang.String getObjectOwnership() {
                return this.objectOwnership;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getObjectOwnership() != null) {
                    data.set("objectOwnership", om.valueToTree(this.getObjectOwnership()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.OwnershipControlsRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OwnershipControlsRuleProperty.Jsii$Proxy that = (OwnershipControlsRuleProperty.Jsii$Proxy) o;

                return this.objectOwnership != null ? this.objectOwnership.equals(that.objectOwnership) : that.objectOwnership == null;
            }

            @Override
            public final int hashCode() {
                int result = this.objectOwnership != null ? this.objectOwnership.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The PublicAccessBlock configuration that you want to apply to this Amazon S3 bucket.
     * <p>
     * You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * PublicAccessBlockConfigurationProperty publicAccessBlockConfigurationProperty = PublicAccessBlockConfigurationProperty.builder()
     *         .blockPublicAcls(false)
     *         .blockPublicPolicy(false)
     *         .ignorePublicAcls(false)
     *         .restrictPublicBuckets(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.PublicAccessBlockConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PublicAccessBlockConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PublicAccessBlockConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether Amazon S3 should block public access control lists (ACLs) for this bucket and objects in this bucket.
         * <p>
         * Setting this element to <code>TRUE</code> causes the following behavior:
         * <p>
         * <ul>
         * <li>PUT Bucket ACL and PUT Object ACL calls fail if the specified ACL is public.</li>
         * <li>PUT Object calls fail if the request includes a public ACL.</li>
         * <li>PUT Bucket calls fail if the request includes a public ACL.</li>
         * </ul>
         * <p>
         * Enabling this setting doesn't affect existing policies or ACLs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBlockPublicAcls() {
            return null;
        }

        /**
         * Specifies whether Amazon S3 should block public bucket policies for this bucket.
         * <p>
         * Setting this element to <code>TRUE</code> causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access.
         * <p>
         * Enabling this setting doesn't affect existing bucket policies.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBlockPublicPolicy() {
            return null;
        }

        /**
         * Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this bucket.
         * <p>
         * Setting this element to <code>TRUE</code> causes Amazon S3 to ignore all public ACLs on this bucket and objects in this bucket.
         * <p>
         * Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIgnorePublicAcls() {
            return null;
        }

        /**
         * Specifies whether Amazon S3 should restrict public bucket policies for this bucket.
         * <p>
         * Setting this element to <code>TRUE</code> restricts access to this bucket to only AWS service principals and authorized users within this account if the bucket has a public policy.
         * <p>
         * Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRestrictPublicBuckets() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PublicAccessBlockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PublicAccessBlockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PublicAccessBlockConfigurationProperty> {
            java.lang.Object blockPublicAcls;
            java.lang.Object blockPublicPolicy;
            java.lang.Object ignorePublicAcls;
            java.lang.Object restrictPublicBuckets;

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getBlockPublicAcls}
             * @param blockPublicAcls Specifies whether Amazon S3 should block public access control lists (ACLs) for this bucket and objects in this bucket.
             *                        Setting this element to <code>TRUE</code> causes the following behavior:
             *                        <p>
             *                        <ul>
             *                        <li>PUT Bucket ACL and PUT Object ACL calls fail if the specified ACL is public.</li>
             *                        <li>PUT Object calls fail if the request includes a public ACL.</li>
             *                        <li>PUT Bucket calls fail if the request includes a public ACL.</li>
             *                        </ul>
             *                        <p>
             *                        Enabling this setting doesn't affect existing policies or ACLs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockPublicAcls(java.lang.Boolean blockPublicAcls) {
                this.blockPublicAcls = blockPublicAcls;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getBlockPublicAcls}
             * @param blockPublicAcls Specifies whether Amazon S3 should block public access control lists (ACLs) for this bucket and objects in this bucket.
             *                        Setting this element to <code>TRUE</code> causes the following behavior:
             *                        <p>
             *                        <ul>
             *                        <li>PUT Bucket ACL and PUT Object ACL calls fail if the specified ACL is public.</li>
             *                        <li>PUT Object calls fail if the request includes a public ACL.</li>
             *                        <li>PUT Bucket calls fail if the request includes a public ACL.</li>
             *                        </ul>
             *                        <p>
             *                        Enabling this setting doesn't affect existing policies or ACLs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockPublicAcls(software.amazon.awscdk.core.IResolvable blockPublicAcls) {
                this.blockPublicAcls = blockPublicAcls;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getBlockPublicPolicy}
             * @param blockPublicPolicy Specifies whether Amazon S3 should block public bucket policies for this bucket.
             *                          Setting this element to <code>TRUE</code> causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access.
             *                          <p>
             *                          Enabling this setting doesn't affect existing bucket policies.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockPublicPolicy(java.lang.Boolean blockPublicPolicy) {
                this.blockPublicPolicy = blockPublicPolicy;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getBlockPublicPolicy}
             * @param blockPublicPolicy Specifies whether Amazon S3 should block public bucket policies for this bucket.
             *                          Setting this element to <code>TRUE</code> causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access.
             *                          <p>
             *                          Enabling this setting doesn't affect existing bucket policies.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockPublicPolicy(software.amazon.awscdk.core.IResolvable blockPublicPolicy) {
                this.blockPublicPolicy = blockPublicPolicy;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getIgnorePublicAcls}
             * @param ignorePublicAcls Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this bucket.
             *                         Setting this element to <code>TRUE</code> causes Amazon S3 to ignore all public ACLs on this bucket and objects in this bucket.
             *                         <p>
             *                         Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ignorePublicAcls(java.lang.Boolean ignorePublicAcls) {
                this.ignorePublicAcls = ignorePublicAcls;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getIgnorePublicAcls}
             * @param ignorePublicAcls Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this bucket.
             *                         Setting this element to <code>TRUE</code> causes Amazon S3 to ignore all public ACLs on this bucket and objects in this bucket.
             *                         <p>
             *                         Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ignorePublicAcls(software.amazon.awscdk.core.IResolvable ignorePublicAcls) {
                this.ignorePublicAcls = ignorePublicAcls;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getRestrictPublicBuckets}
             * @param restrictPublicBuckets Specifies whether Amazon S3 should restrict public bucket policies for this bucket.
             *                              Setting this element to <code>TRUE</code> restricts access to this bucket to only AWS service principals and authorized users within this account if the bucket has a public policy.
             *                              <p>
             *                              Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictPublicBuckets(java.lang.Boolean restrictPublicBuckets) {
                this.restrictPublicBuckets = restrictPublicBuckets;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getRestrictPublicBuckets}
             * @param restrictPublicBuckets Specifies whether Amazon S3 should restrict public bucket policies for this bucket.
             *                              Setting this element to <code>TRUE</code> restricts access to this bucket to only AWS service principals and authorized users within this account if the bucket has a public policy.
             *                              <p>
             *                              Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictPublicBuckets(software.amazon.awscdk.core.IResolvable restrictPublicBuckets) {
                this.restrictPublicBuckets = restrictPublicBuckets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PublicAccessBlockConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PublicAccessBlockConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PublicAccessBlockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PublicAccessBlockConfigurationProperty {
            private final java.lang.Object blockPublicAcls;
            private final java.lang.Object blockPublicPolicy;
            private final java.lang.Object ignorePublicAcls;
            private final java.lang.Object restrictPublicBuckets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.blockPublicAcls = software.amazon.jsii.Kernel.get(this, "blockPublicAcls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.blockPublicPolicy = software.amazon.jsii.Kernel.get(this, "blockPublicPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ignorePublicAcls = software.amazon.jsii.Kernel.get(this, "ignorePublicAcls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.restrictPublicBuckets = software.amazon.jsii.Kernel.get(this, "restrictPublicBuckets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.blockPublicAcls = builder.blockPublicAcls;
                this.blockPublicPolicy = builder.blockPublicPolicy;
                this.ignorePublicAcls = builder.ignorePublicAcls;
                this.restrictPublicBuckets = builder.restrictPublicBuckets;
            }

            @Override
            public final java.lang.Object getBlockPublicAcls() {
                return this.blockPublicAcls;
            }

            @Override
            public final java.lang.Object getBlockPublicPolicy() {
                return this.blockPublicPolicy;
            }

            @Override
            public final java.lang.Object getIgnorePublicAcls() {
                return this.ignorePublicAcls;
            }

            @Override
            public final java.lang.Object getRestrictPublicBuckets() {
                return this.restrictPublicBuckets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBlockPublicAcls() != null) {
                    data.set("blockPublicAcls", om.valueToTree(this.getBlockPublicAcls()));
                }
                if (this.getBlockPublicPolicy() != null) {
                    data.set("blockPublicPolicy", om.valueToTree(this.getBlockPublicPolicy()));
                }
                if (this.getIgnorePublicAcls() != null) {
                    data.set("ignorePublicAcls", om.valueToTree(this.getIgnorePublicAcls()));
                }
                if (this.getRestrictPublicBuckets() != null) {
                    data.set("restrictPublicBuckets", om.valueToTree(this.getRestrictPublicBuckets()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.PublicAccessBlockConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PublicAccessBlockConfigurationProperty.Jsii$Proxy that = (PublicAccessBlockConfigurationProperty.Jsii$Proxy) o;

                if (this.blockPublicAcls != null ? !this.blockPublicAcls.equals(that.blockPublicAcls) : that.blockPublicAcls != null) return false;
                if (this.blockPublicPolicy != null ? !this.blockPublicPolicy.equals(that.blockPublicPolicy) : that.blockPublicPolicy != null) return false;
                if (this.ignorePublicAcls != null ? !this.ignorePublicAcls.equals(that.ignorePublicAcls) : that.ignorePublicAcls != null) return false;
                return this.restrictPublicBuckets != null ? this.restrictPublicBuckets.equals(that.restrictPublicBuckets) : that.restrictPublicBuckets == null;
            }

            @Override
            public final int hashCode() {
                int result = this.blockPublicAcls != null ? this.blockPublicAcls.hashCode() : 0;
                result = 31 * result + (this.blockPublicPolicy != null ? this.blockPublicPolicy.hashCode() : 0);
                result = 31 * result + (this.ignorePublicAcls != null ? this.ignorePublicAcls.hashCode() : 0);
                result = 31 * result + (this.restrictPublicBuckets != null ? this.restrictPublicBuckets.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the configuration for publishing messages to an Amazon Simple Queue Service (Amazon SQS) queue when Amazon S3 detects specified events.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * QueueConfigurationProperty queueConfigurationProperty = QueueConfigurationProperty.builder()
     *         .event("event")
     *         .queue("queue")
     *         // the properties below are optional
     *         .filter(NotificationFilterProperty.builder()
     *                 .s3Key(S3KeyFilterProperty.builder()
     *                         .rules(List.of(FilterRuleProperty.builder()
     *                                 .name("name")
     *                                 .value("value")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.QueueConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(QueueConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QueueConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 bucket event about which you want to publish messages to Amazon SQS.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Supported Event Types</a> in the <em>Amazon S3 User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEvent();

        /**
         * The Amazon Resource Name (ARN) of the Amazon SQS queue to which Amazon S3 publishes a message when it detects events of the specified type.
         * <p>
         * FIFO queues are not allowed when enabling an SQS queue as the event notification destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getQueue();

        /**
         * The filtering rules that determine which objects trigger notifications.
         * <p>
         * For example, you can create a filter so that Amazon S3 sends notifications only when image files with a <code>.jpg</code> extension are added to the bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/user-guide/notification-how-to-filtering.html">Configuring event notifications using object key name filtering</a> in the <em>Amazon S3 User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilter() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link QueueConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QueueConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<QueueConfigurationProperty> {
            java.lang.String event;
            java.lang.String queue;
            java.lang.Object filter;

            /**
             * Sets the value of {@link QueueConfigurationProperty#getEvent}
             * @param event The Amazon S3 bucket event about which you want to publish messages to Amazon SQS. This parameter is required.
             *              For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Supported Event Types</a> in the <em>Amazon S3 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder event(java.lang.String event) {
                this.event = event;
                return this;
            }

            /**
             * Sets the value of {@link QueueConfigurationProperty#getQueue}
             * @param queue The Amazon Resource Name (ARN) of the Amazon SQS queue to which Amazon S3 publishes a message when it detects events of the specified type. This parameter is required.
             *              FIFO queues are not allowed when enabling an SQS queue as the event notification destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queue(java.lang.String queue) {
                this.queue = queue;
                return this;
            }

            /**
             * Sets the value of {@link QueueConfigurationProperty#getFilter}
             * @param filter The filtering rules that determine which objects trigger notifications.
             *               For example, you can create a filter so that Amazon S3 sends notifications only when image files with a <code>.jpg</code> extension are added to the bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/user-guide/notification-how-to-filtering.html">Configuring event notifications using object key name filtering</a> in the <em>Amazon S3 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.core.IResolvable filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Sets the value of {@link QueueConfigurationProperty#getFilter}
             * @param filter The filtering rules that determine which objects trigger notifications.
             *               For example, you can create a filter so that Amazon S3 sends notifications only when image files with a <code>.jpg</code> extension are added to the bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/user-guide/notification-how-to-filtering.html">Configuring event notifications using object key name filtering</a> in the <em>Amazon S3 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueueConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public QueueConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link QueueConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueueConfigurationProperty {
            private final java.lang.String event;
            private final java.lang.String queue;
            private final java.lang.Object filter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.event = software.amazon.jsii.Kernel.get(this, "event", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.queue = software.amazon.jsii.Kernel.get(this, "queue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.filter = software.amazon.jsii.Kernel.get(this, "filter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.event = java.util.Objects.requireNonNull(builder.event, "event is required");
                this.queue = java.util.Objects.requireNonNull(builder.queue, "queue is required");
                this.filter = builder.filter;
            }

            @Override
            public final java.lang.String getEvent() {
                return this.event;
            }

            @Override
            public final java.lang.String getQueue() {
                return this.queue;
            }

            @Override
            public final java.lang.Object getFilter() {
                return this.filter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("event", om.valueToTree(this.getEvent()));
                data.set("queue", om.valueToTree(this.getQueue()));
                if (this.getFilter() != null) {
                    data.set("filter", om.valueToTree(this.getFilter()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.QueueConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QueueConfigurationProperty.Jsii$Proxy that = (QueueConfigurationProperty.Jsii$Proxy) o;

                if (!event.equals(that.event)) return false;
                if (!queue.equals(that.queue)) return false;
                return this.filter != null ? this.filter.equals(that.filter) : that.filter == null;
            }

            @Override
            public final int hashCode() {
                int result = this.event.hashCode();
                result = 31 * result + (this.queue.hashCode());
                result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the redirect behavior of all requests to a website endpoint of an Amazon S3 bucket.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * RedirectAllRequestsToProperty redirectAllRequestsToProperty = RedirectAllRequestsToProperty.builder()
     *         .hostName("hostName")
     *         // the properties below are optional
     *         .protocol("protocol")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.RedirectAllRequestsToProperty")
    @software.amazon.jsii.Jsii.Proxy(RedirectAllRequestsToProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedirectAllRequestsToProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Name of the host where requests are redirected.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHostName();

        /**
         * Protocol to use when redirecting requests.
         * <p>
         * The default is the protocol that is used in the original request.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedirectAllRequestsToProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedirectAllRequestsToProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedirectAllRequestsToProperty> {
            java.lang.String hostName;
            java.lang.String protocol;

            /**
             * Sets the value of {@link RedirectAllRequestsToProperty#getHostName}
             * @param hostName Name of the host where requests are redirected. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostName(java.lang.String hostName) {
                this.hostName = hostName;
                return this;
            }

            /**
             * Sets the value of {@link RedirectAllRequestsToProperty#getProtocol}
             * @param protocol Protocol to use when redirecting requests.
             *                 The default is the protocol that is used in the original request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedirectAllRequestsToProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedirectAllRequestsToProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedirectAllRequestsToProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedirectAllRequestsToProperty {
            private final java.lang.String hostName;
            private final java.lang.String protocol;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hostName = software.amazon.jsii.Kernel.get(this, "hostName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hostName = java.util.Objects.requireNonNull(builder.hostName, "hostName is required");
                this.protocol = builder.protocol;
            }

            @Override
            public final java.lang.String getHostName() {
                return this.hostName;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("hostName", om.valueToTree(this.getHostName()));
                if (this.getProtocol() != null) {
                    data.set("protocol", om.valueToTree(this.getProtocol()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.RedirectAllRequestsToProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedirectAllRequestsToProperty.Jsii$Proxy that = (RedirectAllRequestsToProperty.Jsii$Proxy) o;

                if (!hostName.equals(that.hostName)) return false;
                return this.protocol != null ? this.protocol.equals(that.protocol) : that.protocol == null;
            }

            @Override
            public final int hashCode() {
                int result = this.hostName.hashCode();
                result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies how requests are redirected.
     * <p>
     * In the event of an error, you can specify a different error code to return.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * RedirectRuleProperty redirectRuleProperty = RedirectRuleProperty.builder()
     *         .hostName("hostName")
     *         .httpRedirectCode("httpRedirectCode")
     *         .protocol("protocol")
     *         .replaceKeyPrefixWith("replaceKeyPrefixWith")
     *         .replaceKeyWith("replaceKeyWith")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.RedirectRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(RedirectRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedirectRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The host name to use in the redirect request.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostName() {
            return null;
        }

        /**
         * The HTTP redirect code to use on the response.
         * <p>
         * Not required if one of the siblings is present.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHttpRedirectCode() {
            return null;
        }

        /**
         * Protocol to use when redirecting requests.
         * <p>
         * The default is the protocol that is used in the original request.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
            return null;
        }

        /**
         * The object key prefix to use in the redirect request.
         * <p>
         * For example, to redirect requests for all pages with prefix <code>docs/</code> (objects in the <code>docs/</code> folder) to <code>documents/</code> , you can set a condition block with <code>KeyPrefixEquals</code> set to <code>docs/</code> and in the Redirect set <code>ReplaceKeyPrefixWith</code> to <code>/documents</code> . Not required if one of the siblings is present. Can be present only if <code>ReplaceKeyWith</code> is not provided.
         * <p>
         * <blockquote>
         * <p>
         * Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints">XML related object key constraints</a> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReplaceKeyPrefixWith() {
            return null;
        }

        /**
         * The specific object key to use in the redirect request.
         * <p>
         * For example, redirect request to <code>error.html</code> . Not required if one of the siblings is present. Can be present only if <code>ReplaceKeyPrefixWith</code> is not provided.
         * <p>
         * <blockquote>
         * <p>
         * Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints">XML related object key constraints</a> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReplaceKeyWith() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedirectRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedirectRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedirectRuleProperty> {
            java.lang.String hostName;
            java.lang.String httpRedirectCode;
            java.lang.String protocol;
            java.lang.String replaceKeyPrefixWith;
            java.lang.String replaceKeyWith;

            /**
             * Sets the value of {@link RedirectRuleProperty#getHostName}
             * @param hostName The host name to use in the redirect request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostName(java.lang.String hostName) {
                this.hostName = hostName;
                return this;
            }

            /**
             * Sets the value of {@link RedirectRuleProperty#getHttpRedirectCode}
             * @param httpRedirectCode The HTTP redirect code to use on the response.
             *                         Not required if one of the siblings is present.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpRedirectCode(java.lang.String httpRedirectCode) {
                this.httpRedirectCode = httpRedirectCode;
                return this;
            }

            /**
             * Sets the value of {@link RedirectRuleProperty#getProtocol}
             * @param protocol Protocol to use when redirecting requests.
             *                 The default is the protocol that is used in the original request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Sets the value of {@link RedirectRuleProperty#getReplaceKeyPrefixWith}
             * @param replaceKeyPrefixWith The object key prefix to use in the redirect request.
             *                             For example, to redirect requests for all pages with prefix <code>docs/</code> (objects in the <code>docs/</code> folder) to <code>documents/</code> , you can set a condition block with <code>KeyPrefixEquals</code> set to <code>docs/</code> and in the Redirect set <code>ReplaceKeyPrefixWith</code> to <code>/documents</code> . Not required if one of the siblings is present. Can be present only if <code>ReplaceKeyWith</code> is not provided.
             *                             <p>
             *                             <blockquote>
             *                             <p>
             *                             Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints">XML related object key constraints</a> .
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replaceKeyPrefixWith(java.lang.String replaceKeyPrefixWith) {
                this.replaceKeyPrefixWith = replaceKeyPrefixWith;
                return this;
            }

            /**
             * Sets the value of {@link RedirectRuleProperty#getReplaceKeyWith}
             * @param replaceKeyWith The specific object key to use in the redirect request.
             *                       For example, redirect request to <code>error.html</code> . Not required if one of the siblings is present. Can be present only if <code>ReplaceKeyPrefixWith</code> is not provided.
             *                       <p>
             *                       <blockquote>
             *                       <p>
             *                       Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints">XML related object key constraints</a> .
             *                       <p>
             *                       </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replaceKeyWith(java.lang.String replaceKeyWith) {
                this.replaceKeyWith = replaceKeyWith;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedirectRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedirectRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedirectRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedirectRuleProperty {
            private final java.lang.String hostName;
            private final java.lang.String httpRedirectCode;
            private final java.lang.String protocol;
            private final java.lang.String replaceKeyPrefixWith;
            private final java.lang.String replaceKeyWith;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hostName = software.amazon.jsii.Kernel.get(this, "hostName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.httpRedirectCode = software.amazon.jsii.Kernel.get(this, "httpRedirectCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.replaceKeyPrefixWith = software.amazon.jsii.Kernel.get(this, "replaceKeyPrefixWith", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.replaceKeyWith = software.amazon.jsii.Kernel.get(this, "replaceKeyWith", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hostName = builder.hostName;
                this.httpRedirectCode = builder.httpRedirectCode;
                this.protocol = builder.protocol;
                this.replaceKeyPrefixWith = builder.replaceKeyPrefixWith;
                this.replaceKeyWith = builder.replaceKeyWith;
            }

            @Override
            public final java.lang.String getHostName() {
                return this.hostName;
            }

            @Override
            public final java.lang.String getHttpRedirectCode() {
                return this.httpRedirectCode;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public final java.lang.String getReplaceKeyPrefixWith() {
                return this.replaceKeyPrefixWith;
            }

            @Override
            public final java.lang.String getReplaceKeyWith() {
                return this.replaceKeyWith;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHostName() != null) {
                    data.set("hostName", om.valueToTree(this.getHostName()));
                }
                if (this.getHttpRedirectCode() != null) {
                    data.set("httpRedirectCode", om.valueToTree(this.getHttpRedirectCode()));
                }
                if (this.getProtocol() != null) {
                    data.set("protocol", om.valueToTree(this.getProtocol()));
                }
                if (this.getReplaceKeyPrefixWith() != null) {
                    data.set("replaceKeyPrefixWith", om.valueToTree(this.getReplaceKeyPrefixWith()));
                }
                if (this.getReplaceKeyWith() != null) {
                    data.set("replaceKeyWith", om.valueToTree(this.getReplaceKeyWith()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.RedirectRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedirectRuleProperty.Jsii$Proxy that = (RedirectRuleProperty.Jsii$Proxy) o;

                if (this.hostName != null ? !this.hostName.equals(that.hostName) : that.hostName != null) return false;
                if (this.httpRedirectCode != null ? !this.httpRedirectCode.equals(that.httpRedirectCode) : that.httpRedirectCode != null) return false;
                if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
                if (this.replaceKeyPrefixWith != null ? !this.replaceKeyPrefixWith.equals(that.replaceKeyPrefixWith) : that.replaceKeyPrefixWith != null) return false;
                return this.replaceKeyWith != null ? this.replaceKeyWith.equals(that.replaceKeyWith) : that.replaceKeyWith == null;
            }

            @Override
            public final int hashCode() {
                int result = this.hostName != null ? this.hostName.hashCode() : 0;
                result = 31 * result + (this.httpRedirectCode != null ? this.httpRedirectCode.hashCode() : 0);
                result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
                result = 31 * result + (this.replaceKeyPrefixWith != null ? this.replaceKeyPrefixWith.hashCode() : 0);
                result = 31 * result + (this.replaceKeyWith != null ? this.replaceKeyWith.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A filter that you can specify for selection for modifications on replicas.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * ReplicaModificationsProperty replicaModificationsProperty = ReplicaModificationsProperty.builder()
     *         .status("status")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.ReplicaModificationsProperty")
    @software.amazon.jsii.Jsii.Proxy(ReplicaModificationsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicaModificationsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether Amazon S3 replicates modifications on replicas.
         * <p>
         * <em>Allowed values</em> : <code>Enabled</code> | <code>Disabled</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatus();

        /**
         * @return a {@link Builder} of {@link ReplicaModificationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReplicaModificationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReplicaModificationsProperty> {
            java.lang.String status;

            /**
             * Sets the value of {@link ReplicaModificationsProperty#getStatus}
             * @param status Specifies whether Amazon S3 replicates modifications on replicas. This parameter is required.
             *               <em>Allowed values</em> : <code>Enabled</code> | <code>Disabled</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicaModificationsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReplicaModificationsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReplicaModificationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicaModificationsProperty {
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.status = java.util.Objects.requireNonNull(builder.status, "status is required");
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("status", om.valueToTree(this.getStatus()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.ReplicaModificationsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicaModificationsProperty.Jsii$Proxy that = (ReplicaModificationsProperty.Jsii$Proxy) o;

                return this.status.equals(that.status);
            }

            @Override
            public final int hashCode() {
                int result = this.status.hashCode();
                return result;
            }
        }
    }
    /**
     * A container for replication rules.
     * <p>
     * You can add up to 1,000 rules. The maximum size of a replication configuration is 2 MB.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * ReplicationConfigurationProperty replicationConfigurationProperty = ReplicationConfigurationProperty.builder()
     *         .role("role")
     *         .rules(List.of(ReplicationRuleProperty.builder()
     *                 .destination(ReplicationDestinationProperty.builder()
     *                         .bucket("bucket")
     *                         // the properties below are optional
     *                         .accessControlTranslation(AccessControlTranslationProperty.builder()
     *                                 .owner("owner")
     *                                 .build())
     *                         .account("account")
     *                         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                                 .replicaKmsKeyId("replicaKmsKeyId")
     *                                 .build())
     *                         .metrics(MetricsProperty.builder()
     *                                 .status("status")
     *                                 // the properties below are optional
     *                                 .eventThreshold(ReplicationTimeValueProperty.builder()
     *                                         .minutes(123)
     *                                         .build())
     *                                 .build())
     *                         .replicationTime(ReplicationTimeProperty.builder()
     *                                 .status("status")
     *                                 .time(ReplicationTimeValueProperty.builder()
     *                                         .minutes(123)
     *                                         .build())
     *                                 .build())
     *                         .storageClass("storageClass")
     *                         .build())
     *                 .status("status")
     *                 // the properties below are optional
     *                 .deleteMarkerReplication(DeleteMarkerReplicationProperty.builder()
     *                         .status("status")
     *                         .build())
     *                 .filter(ReplicationRuleFilterProperty.builder()
     *                         .and(ReplicationRuleAndOperatorProperty.builder()
     *                                 .prefix("prefix")
     *                                 .tagFilters(List.of(TagFilterProperty.builder()
     *                                         .key("key")
     *                                         .value("value")
     *                                         .build()))
     *                                 .build())
     *                         .prefix("prefix")
     *                         .tagFilter(TagFilterProperty.builder()
     *                                 .key("key")
     *                                 .value("value")
     *                                 .build())
     *                         .build())
     *                 .id("id")
     *                 .prefix("prefix")
     *                 .priority(123)
     *                 .sourceSelectionCriteria(SourceSelectionCriteriaProperty.builder()
     *                         .replicaModifications(ReplicaModificationsProperty.builder()
     *                                 .status("status")
     *                                 .build())
     *                         .sseKmsEncryptedObjects(SseKmsEncryptedObjectsProperty.builder()
     *                                 .status("status")
     *                                 .build())
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.ReplicationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ReplicationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that Amazon S3 assumes when replicating objects.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-how-setup.html">How to Set Up Replication</a> in the <em>Amazon S3 User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRole();

        /**
         * A container for one or more replication rules.
         * <p>
         * A replication configuration must have at least one rule and can contain a maximum of 1,000 rules.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRules();

        /**
         * @return a {@link Builder} of {@link ReplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReplicationConfigurationProperty> {
            java.lang.String role;
            java.lang.Object rules;

            /**
             * Sets the value of {@link ReplicationConfigurationProperty#getRole}
             * @param role The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that Amazon S3 assumes when replicating objects. This parameter is required.
             *             For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-how-setup.html">How to Set Up Replication</a> in the <em>Amazon S3 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder role(java.lang.String role) {
                this.role = role;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationConfigurationProperty#getRules}
             * @param rules A container for one or more replication rules. This parameter is required.
             *              A replication configuration must have at least one rule and can contain a maximum of 1,000 rules.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(software.amazon.awscdk.core.IResolvable rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationConfigurationProperty#getRules}
             * @param rules A container for one or more replication rules. This parameter is required.
             *              A replication configuration must have at least one rule and can contain a maximum of 1,000 rules.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(java.util.List<? extends java.lang.Object> rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReplicationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicationConfigurationProperty {
            private final java.lang.String role;
            private final java.lang.Object rules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rules = software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.role = java.util.Objects.requireNonNull(builder.role, "role is required");
                this.rules = java.util.Objects.requireNonNull(builder.rules, "rules is required");
            }

            @Override
            public final java.lang.String getRole() {
                return this.role;
            }

            @Override
            public final java.lang.Object getRules() {
                return this.rules;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("role", om.valueToTree(this.getRole()));
                data.set("rules", om.valueToTree(this.getRules()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.ReplicationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicationConfigurationProperty.Jsii$Proxy that = (ReplicationConfigurationProperty.Jsii$Proxy) o;

                if (!role.equals(that.role)) return false;
                return this.rules.equals(that.rules);
            }

            @Override
            public final int hashCode() {
                int result = this.role.hashCode();
                result = 31 * result + (this.rules.hashCode());
                return result;
            }
        }
    }
    /**
     * A container for information about the replication destination and its configurations including enabling the S3 Replication Time Control (S3 RTC).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * ReplicationDestinationProperty replicationDestinationProperty = ReplicationDestinationProperty.builder()
     *         .bucket("bucket")
     *         // the properties below are optional
     *         .accessControlTranslation(AccessControlTranslationProperty.builder()
     *                 .owner("owner")
     *                 .build())
     *         .account("account")
     *         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                 .replicaKmsKeyId("replicaKmsKeyId")
     *                 .build())
     *         .metrics(MetricsProperty.builder()
     *                 .status("status")
     *                 // the properties below are optional
     *                 .eventThreshold(ReplicationTimeValueProperty.builder()
     *                         .minutes(123)
     *                         .build())
     *                 .build())
     *         .replicationTime(ReplicationTimeProperty.builder()
     *                 .status("status")
     *                 .time(ReplicationTimeValueProperty.builder()
     *                         .minutes(123)
     *                         .build())
     *                 .build())
     *         .storageClass("storageClass")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.ReplicationDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(ReplicationDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicationDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the bucket where you want Amazon S3 to store the results.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * Specify this only in a cross-account scenario (where source and destination bucket owners are not the same), and you want to change replica ownership to the AWS account that owns the destination bucket.
         * <p>
         * If this is not specified in the replication configuration, the replicas are owned by same AWS account that owns the source object.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAccessControlTranslation() {
            return null;
        }

        /**
         * Destination bucket owner account ID.
         * <p>
         * In a cross-account scenario, if you direct Amazon S3 to change replica ownership to the AWS account that owns the destination bucket by specifying the <code>AccessControlTranslation</code> property, this is the account ID of the destination bucket owner. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/crr-change-owner.html">Cross-Region Replication Additional Configuration: Change Replica Owner</a> in the <em>Amazon S3 User Guide</em> .
         * <p>
         * If you specify the <code>AccessControlTranslation</code> property, the <code>Account</code> property is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccount() {
            return null;
        }

        /**
         * Specifies encryption-related information.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfiguration() {
            return null;
        }

        /**
         * A container specifying replication metrics-related settings enabling replication metrics and events.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetrics() {
            return null;
        }

        /**
         * A container specifying S3 Replication Time Control (S3 RTC), including whether S3 RTC is enabled and the time when all objects and operations on objects must be replicated.
         * <p>
         * Must be specified together with a <code>Metrics</code> block.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReplicationTime() {
            return null;
        }

        /**
         * The storage class to use when replicating objects, such as S3 Standard or reduced redundancy.
         * <p>
         * By default, Amazon S3 uses the storage class of the source object to create the object replica.
         * <p>
         * For valid values, see the <code>StorageClass</code> element of the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTreplication.html">PUT Bucket replication</a> action in the <em>Amazon S3 API Reference</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStorageClass() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReplicationDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReplicationDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReplicationDestinationProperty> {
            java.lang.String bucket;
            java.lang.Object accessControlTranslation;
            java.lang.String account;
            java.lang.Object encryptionConfiguration;
            java.lang.Object metrics;
            java.lang.Object replicationTime;
            java.lang.String storageClass;

            /**
             * Sets the value of {@link ReplicationDestinationProperty#getBucket}
             * @param bucket The Amazon Resource Name (ARN) of the bucket where you want Amazon S3 to store the results. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationDestinationProperty#getAccessControlTranslation}
             * @param accessControlTranslation Specify this only in a cross-account scenario (where source and destination bucket owners are not the same), and you want to change replica ownership to the AWS account that owns the destination bucket.
             *                                 If this is not specified in the replication configuration, the replicas are owned by same AWS account that owns the source object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessControlTranslation(software.amazon.awscdk.core.IResolvable accessControlTranslation) {
                this.accessControlTranslation = accessControlTranslation;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationDestinationProperty#getAccessControlTranslation}
             * @param accessControlTranslation Specify this only in a cross-account scenario (where source and destination bucket owners are not the same), and you want to change replica ownership to the AWS account that owns the destination bucket.
             *                                 If this is not specified in the replication configuration, the replicas are owned by same AWS account that owns the source object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessControlTranslation(software.amazon.awscdk.services.s3.CfnBucket.AccessControlTranslationProperty accessControlTranslation) {
                this.accessControlTranslation = accessControlTranslation;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationDestinationProperty#getAccount}
             * @param account Destination bucket owner account ID.
             *                In a cross-account scenario, if you direct Amazon S3 to change replica ownership to the AWS account that owns the destination bucket by specifying the <code>AccessControlTranslation</code> property, this is the account ID of the destination bucket owner. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/crr-change-owner.html">Cross-Region Replication Additional Configuration: Change Replica Owner</a> in the <em>Amazon S3 User Guide</em> .
             *                <p>
             *                If you specify the <code>AccessControlTranslation</code> property, the <code>Account</code> property is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder account(java.lang.String account) {
                this.account = account;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationDestinationProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration Specifies encryption-related information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.core.IResolvable encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationDestinationProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration Specifies encryption-related information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.services.s3.CfnBucket.EncryptionConfigurationProperty encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationDestinationProperty#getMetrics}
             * @param metrics A container specifying replication metrics-related settings enabling replication metrics and events.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metrics(software.amazon.awscdk.core.IResolvable metrics) {
                this.metrics = metrics;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationDestinationProperty#getMetrics}
             * @param metrics A container specifying replication metrics-related settings enabling replication metrics and events.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metrics(software.amazon.awscdk.services.s3.CfnBucket.MetricsProperty metrics) {
                this.metrics = metrics;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationDestinationProperty#getReplicationTime}
             * @param replicationTime A container specifying S3 Replication Time Control (S3 RTC), including whether S3 RTC is enabled and the time when all objects and operations on objects must be replicated.
             *                        Must be specified together with a <code>Metrics</code> block.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replicationTime(software.amazon.awscdk.core.IResolvable replicationTime) {
                this.replicationTime = replicationTime;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationDestinationProperty#getReplicationTime}
             * @param replicationTime A container specifying S3 Replication Time Control (S3 RTC), including whether S3 RTC is enabled and the time when all objects and operations on objects must be replicated.
             *                        Must be specified together with a <code>Metrics</code> block.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replicationTime(software.amazon.awscdk.services.s3.CfnBucket.ReplicationTimeProperty replicationTime) {
                this.replicationTime = replicationTime;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationDestinationProperty#getStorageClass}
             * @param storageClass The storage class to use when replicating objects, such as S3 Standard or reduced redundancy.
             *                     By default, Amazon S3 uses the storage class of the source object to create the object replica.
             *                     <p>
             *                     For valid values, see the <code>StorageClass</code> element of the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTreplication.html">PUT Bucket replication</a> action in the <em>Amazon S3 API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageClass(java.lang.String storageClass) {
                this.storageClass = storageClass;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReplicationDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReplicationDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicationDestinationProperty {
            private final java.lang.String bucket;
            private final java.lang.Object accessControlTranslation;
            private final java.lang.String account;
            private final java.lang.Object encryptionConfiguration;
            private final java.lang.Object metrics;
            private final java.lang.Object replicationTime;
            private final java.lang.String storageClass;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.accessControlTranslation = software.amazon.jsii.Kernel.get(this, "accessControlTranslation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.account = software.amazon.jsii.Kernel.get(this, "account", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.encryptionConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.metrics = software.amazon.jsii.Kernel.get(this, "metrics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.replicationTime = software.amazon.jsii.Kernel.get(this, "replicationTime", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.storageClass = software.amazon.jsii.Kernel.get(this, "storageClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
                this.accessControlTranslation = builder.accessControlTranslation;
                this.account = builder.account;
                this.encryptionConfiguration = builder.encryptionConfiguration;
                this.metrics = builder.metrics;
                this.replicationTime = builder.replicationTime;
                this.storageClass = builder.storageClass;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.Object getAccessControlTranslation() {
                return this.accessControlTranslation;
            }

            @Override
            public final java.lang.String getAccount() {
                return this.account;
            }

            @Override
            public final java.lang.Object getEncryptionConfiguration() {
                return this.encryptionConfiguration;
            }

            @Override
            public final java.lang.Object getMetrics() {
                return this.metrics;
            }

            @Override
            public final java.lang.Object getReplicationTime() {
                return this.replicationTime;
            }

            @Override
            public final java.lang.String getStorageClass() {
                return this.storageClass;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                if (this.getAccessControlTranslation() != null) {
                    data.set("accessControlTranslation", om.valueToTree(this.getAccessControlTranslation()));
                }
                if (this.getAccount() != null) {
                    data.set("account", om.valueToTree(this.getAccount()));
                }
                if (this.getEncryptionConfiguration() != null) {
                    data.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
                }
                if (this.getMetrics() != null) {
                    data.set("metrics", om.valueToTree(this.getMetrics()));
                }
                if (this.getReplicationTime() != null) {
                    data.set("replicationTime", om.valueToTree(this.getReplicationTime()));
                }
                if (this.getStorageClass() != null) {
                    data.set("storageClass", om.valueToTree(this.getStorageClass()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.ReplicationDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicationDestinationProperty.Jsii$Proxy that = (ReplicationDestinationProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (this.accessControlTranslation != null ? !this.accessControlTranslation.equals(that.accessControlTranslation) : that.accessControlTranslation != null) return false;
                if (this.account != null ? !this.account.equals(that.account) : that.account != null) return false;
                if (this.encryptionConfiguration != null ? !this.encryptionConfiguration.equals(that.encryptionConfiguration) : that.encryptionConfiguration != null) return false;
                if (this.metrics != null ? !this.metrics.equals(that.metrics) : that.metrics != null) return false;
                if (this.replicationTime != null ? !this.replicationTime.equals(that.replicationTime) : that.replicationTime != null) return false;
                return this.storageClass != null ? this.storageClass.equals(that.storageClass) : that.storageClass == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.accessControlTranslation != null ? this.accessControlTranslation.hashCode() : 0);
                result = 31 * result + (this.account != null ? this.account.hashCode() : 0);
                result = 31 * result + (this.encryptionConfiguration != null ? this.encryptionConfiguration.hashCode() : 0);
                result = 31 * result + (this.metrics != null ? this.metrics.hashCode() : 0);
                result = 31 * result + (this.replicationTime != null ? this.replicationTime.hashCode() : 0);
                result = 31 * result + (this.storageClass != null ? this.storageClass.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A container for specifying rule filters.
     * <p>
     * The filters determine the subset of objects to which the rule applies. This element is required only if you specify more than one filter.
     * <p>
     * For example:
     * <p>
     * <ul>
     * <li>If you specify both a <code>Prefix</code> and a <code>TagFilter</code> , wrap these filters in an <code>And</code> tag.</li>
     * <li>If you specify a filter based on multiple tags, wrap the <code>TagFilter</code> elements in an <code>And</code> tag</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * ReplicationRuleAndOperatorProperty replicationRuleAndOperatorProperty = ReplicationRuleAndOperatorProperty.builder()
     *         .prefix("prefix")
     *         .tagFilters(List.of(TagFilterProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.ReplicationRuleAndOperatorProperty")
    @software.amazon.jsii.Jsii.Proxy(ReplicationRuleAndOperatorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicationRuleAndOperatorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object key name prefix that identifies the subset of objects to which the rule applies.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * An array of tags containing key and value pairs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagFilters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReplicationRuleAndOperatorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReplicationRuleAndOperatorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReplicationRuleAndOperatorProperty> {
            java.lang.String prefix;
            java.lang.Object tagFilters;

            /**
             * Sets the value of {@link ReplicationRuleAndOperatorProperty#getPrefix}
             * @param prefix An object key name prefix that identifies the subset of objects to which the rule applies.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleAndOperatorProperty#getTagFilters}
             * @param tagFilters An array of tags containing key and value pairs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagFilters(software.amazon.awscdk.core.IResolvable tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleAndOperatorProperty#getTagFilters}
             * @param tagFilters An array of tags containing key and value pairs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagFilters(java.util.List<? extends java.lang.Object> tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationRuleAndOperatorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReplicationRuleAndOperatorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReplicationRuleAndOperatorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicationRuleAndOperatorProperty {
            private final java.lang.String prefix;
            private final java.lang.Object tagFilters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tagFilters = software.amazon.jsii.Kernel.get(this, "tagFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.prefix = builder.prefix;
                this.tagFilters = builder.tagFilters;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public final java.lang.Object getTagFilters() {
                return this.tagFilters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }
                if (this.getTagFilters() != null) {
                    data.set("tagFilters", om.valueToTree(this.getTagFilters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.ReplicationRuleAndOperatorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicationRuleAndOperatorProperty.Jsii$Proxy that = (ReplicationRuleAndOperatorProperty.Jsii$Proxy) o;

                if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
                return this.tagFilters != null ? this.tagFilters.equals(that.tagFilters) : that.tagFilters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.prefix != null ? this.prefix.hashCode() : 0;
                result = 31 * result + (this.tagFilters != null ? this.tagFilters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A filter that identifies the subset of objects to which the replication rule applies.
     * <p>
     * A <code>Filter</code> must specify exactly one <code>Prefix</code> , <code>TagFilter</code> , or an <code>And</code> child element.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * ReplicationRuleFilterProperty replicationRuleFilterProperty = ReplicationRuleFilterProperty.builder()
     *         .and(ReplicationRuleAndOperatorProperty.builder()
     *                 .prefix("prefix")
     *                 .tagFilters(List.of(TagFilterProperty.builder()
     *                         .key("key")
     *                         .value("value")
     *                         .build()))
     *                 .build())
     *         .prefix("prefix")
     *         .tagFilter(TagFilterProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.ReplicationRuleFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(ReplicationRuleFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicationRuleFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A container for specifying rule filters.
         * <p>
         * The filters determine the subset of objects to which the rule applies. This element is required only if you specify more than one filter. For example:
         * <p>
         * <ul>
         * <li>If you specify both a <code>Prefix</code> and a <code>TagFilter</code> , wrap these filters in an <code>And</code> tag.</li>
         * <li>If you specify a filter based on multiple tags, wrap the <code>TagFilter</code> elements in an <code>And</code> tag.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAnd() {
            return null;
        }

        /**
         * An object key name prefix that identifies the subset of objects to which the rule applies.
         * <p>
         * <blockquote>
         * <p>
         * Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints">XML related object key constraints</a> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * A container for specifying a tag key and value.
         * <p>
         * The rule applies only to objects that have the tag in their tag set.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagFilter() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReplicationRuleFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReplicationRuleFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReplicationRuleFilterProperty> {
            java.lang.Object and;
            java.lang.String prefix;
            java.lang.Object tagFilter;

            /**
             * Sets the value of {@link ReplicationRuleFilterProperty#getAnd}
             * @param and A container for specifying rule filters.
             *            The filters determine the subset of objects to which the rule applies. This element is required only if you specify more than one filter. For example:
             *            <p>
             *            <ul>
             *            <li>If you specify both a <code>Prefix</code> and a <code>TagFilter</code> , wrap these filters in an <code>And</code> tag.</li>
             *            <li>If you specify a filter based on multiple tags, wrap the <code>TagFilter</code> elements in an <code>And</code> tag.</li>
             *            </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder and(software.amazon.awscdk.core.IResolvable and) {
                this.and = and;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleFilterProperty#getAnd}
             * @param and A container for specifying rule filters.
             *            The filters determine the subset of objects to which the rule applies. This element is required only if you specify more than one filter. For example:
             *            <p>
             *            <ul>
             *            <li>If you specify both a <code>Prefix</code> and a <code>TagFilter</code> , wrap these filters in an <code>And</code> tag.</li>
             *            <li>If you specify a filter based on multiple tags, wrap the <code>TagFilter</code> elements in an <code>And</code> tag.</li>
             *            </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder and(software.amazon.awscdk.services.s3.CfnBucket.ReplicationRuleAndOperatorProperty and) {
                this.and = and;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleFilterProperty#getPrefix}
             * @param prefix An object key name prefix that identifies the subset of objects to which the rule applies.
             *               <blockquote>
             *               <p>
             *               Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints">XML related object key constraints</a> .
             *               <p>
             *               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleFilterProperty#getTagFilter}
             * @param tagFilter A container for specifying a tag key and value.
             *                  The rule applies only to objects that have the tag in their tag set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagFilter(software.amazon.awscdk.core.IResolvable tagFilter) {
                this.tagFilter = tagFilter;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleFilterProperty#getTagFilter}
             * @param tagFilter A container for specifying a tag key and value.
             *                  The rule applies only to objects that have the tag in their tag set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagFilter(software.amazon.awscdk.services.s3.CfnBucket.TagFilterProperty tagFilter) {
                this.tagFilter = tagFilter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationRuleFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReplicationRuleFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReplicationRuleFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicationRuleFilterProperty {
            private final java.lang.Object and;
            private final java.lang.String prefix;
            private final java.lang.Object tagFilter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.and = software.amazon.jsii.Kernel.get(this, "and", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tagFilter = software.amazon.jsii.Kernel.get(this, "tagFilter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.and = builder.and;
                this.prefix = builder.prefix;
                this.tagFilter = builder.tagFilter;
            }

            @Override
            public final java.lang.Object getAnd() {
                return this.and;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public final java.lang.Object getTagFilter() {
                return this.tagFilter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAnd() != null) {
                    data.set("and", om.valueToTree(this.getAnd()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }
                if (this.getTagFilter() != null) {
                    data.set("tagFilter", om.valueToTree(this.getTagFilter()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.ReplicationRuleFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicationRuleFilterProperty.Jsii$Proxy that = (ReplicationRuleFilterProperty.Jsii$Proxy) o;

                if (this.and != null ? !this.and.equals(that.and) : that.and != null) return false;
                if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
                return this.tagFilter != null ? this.tagFilter.equals(that.tagFilter) : that.tagFilter == null;
            }

            @Override
            public final int hashCode() {
                int result = this.and != null ? this.and.hashCode() : 0;
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                result = 31 * result + (this.tagFilter != null ? this.tagFilter.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies which Amazon S3 objects to replicate and where to store the replicas.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * ReplicationRuleProperty replicationRuleProperty = ReplicationRuleProperty.builder()
     *         .destination(ReplicationDestinationProperty.builder()
     *                 .bucket("bucket")
     *                 // the properties below are optional
     *                 .accessControlTranslation(AccessControlTranslationProperty.builder()
     *                         .owner("owner")
     *                         .build())
     *                 .account("account")
     *                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                         .replicaKmsKeyId("replicaKmsKeyId")
     *                         .build())
     *                 .metrics(MetricsProperty.builder()
     *                         .status("status")
     *                         // the properties below are optional
     *                         .eventThreshold(ReplicationTimeValueProperty.builder()
     *                                 .minutes(123)
     *                                 .build())
     *                         .build())
     *                 .replicationTime(ReplicationTimeProperty.builder()
     *                         .status("status")
     *                         .time(ReplicationTimeValueProperty.builder()
     *                                 .minutes(123)
     *                                 .build())
     *                         .build())
     *                 .storageClass("storageClass")
     *                 .build())
     *         .status("status")
     *         // the properties below are optional
     *         .deleteMarkerReplication(DeleteMarkerReplicationProperty.builder()
     *                 .status("status")
     *                 .build())
     *         .filter(ReplicationRuleFilterProperty.builder()
     *                 .and(ReplicationRuleAndOperatorProperty.builder()
     *                         .prefix("prefix")
     *                         .tagFilters(List.of(TagFilterProperty.builder()
     *                                 .key("key")
     *                                 .value("value")
     *                                 .build()))
     *                         .build())
     *                 .prefix("prefix")
     *                 .tagFilter(TagFilterProperty.builder()
     *                         .key("key")
     *                         .value("value")
     *                         .build())
     *                 .build())
     *         .id("id")
     *         .prefix("prefix")
     *         .priority(123)
     *         .sourceSelectionCriteria(SourceSelectionCriteriaProperty.builder()
     *                 .replicaModifications(ReplicaModificationsProperty.builder()
     *                         .status("status")
     *                         .build())
     *                 .sseKmsEncryptedObjects(SseKmsEncryptedObjectsProperty.builder()
     *                         .status("status")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.ReplicationRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(ReplicationRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicationRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A container for information about the replication destination and its configurations including enabling the S3 Replication Time Control (S3 RTC).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDestination();

        /**
         * Specifies whether the rule is enabled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatus();

        /**
         * Specifies whether Amazon S3 replicates delete markers.
         * <p>
         * If you specify a <code>Filter</code> in your replication configuration, you must also include a <code>DeleteMarkerReplication</code> element. If your <code>Filter</code> includes a <code>Tag</code> element, the <code>DeleteMarkerReplication</code> <code>Status</code> must be set to Disabled, because Amazon S3 does not support replicating delete markers for tag-based rules. For an example configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-config-min-rule-config">Basic Rule Configuration</a> .
         * <p>
         * For more information about delete marker replication, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/delete-marker-replication.html">Basic Rule Configuration</a> .
         * <p>
         * <blockquote>
         * <p>
         * If you are using an earlier version of the replication configuration, Amazon S3 handles replication of delete markers differently. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-backward-compat-considerations">Backward Compatibility</a> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeleteMarkerReplication() {
            return null;
        }

        /**
         * A filter that identifies the subset of objects to which the replication rule applies.
         * <p>
         * A <code>Filter</code> must specify exactly one <code>Prefix</code> , <code>TagFilter</code> , or an <code>And</code> child element. The use of the filter field indicates that this is a V2 replication configuration. This field isn't supported in a V1 replication configuration.
         * <p>
         * <blockquote>
         * <p>
         * V1 replication configuration only supports filtering by key prefix. To filter using a V1 replication configuration, add the <code>Prefix</code> directly as a child element of the <code>Rule</code> element.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilter() {
            return null;
        }

        /**
         * A unique identifier for the rule.
         * <p>
         * The maximum value is 255 characters. If you don't specify a value, AWS CloudFormation generates a random ID. When using a V2 replication configuration this property is capitalized as "ID".
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getId() {
            return null;
        }

        /**
         * An object key name prefix that identifies the object or objects to which the rule applies.
         * <p>
         * The maximum prefix length is 1,024 characters. To include all objects in a bucket, specify an empty string. To filter using a V1 replication configuration, add the <code>Prefix</code> directly as a child element of the <code>Rule</code> element.
         * <p>
         * <blockquote>
         * <p>
         * Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints">XML related object key constraints</a> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * The priority indicates which rule has precedence whenever two or more replication rules conflict.
         * <p>
         * Amazon S3 will attempt to replicate objects according to all replication rules. However, if there are two or more rules with the same destination bucket, then objects will be replicated according to the rule with the highest priority. The higher the number, the higher the priority.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html">Replication</a> in the <em>Amazon S3 User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
            return null;
        }

        /**
         * A container that describes additional filters for identifying the source objects that you want to replicate.
         * <p>
         * You can choose to enable or disable the replication of these objects.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSourceSelectionCriteria() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReplicationRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReplicationRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReplicationRuleProperty> {
            java.lang.Object destination;
            java.lang.String status;
            java.lang.Object deleteMarkerReplication;
            java.lang.Object filter;
            java.lang.String id;
            java.lang.String prefix;
            java.lang.Number priority;
            java.lang.Object sourceSelectionCriteria;

            /**
             * Sets the value of {@link ReplicationRuleProperty#getDestination}
             * @param destination A container for information about the replication destination and its configurations including enabling the S3 Replication Time Control (S3 RTC). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.core.IResolvable destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleProperty#getDestination}
             * @param destination A container for information about the replication destination and its configurations including enabling the S3 Replication Time Control (S3 RTC). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.services.s3.CfnBucket.ReplicationDestinationProperty destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleProperty#getStatus}
             * @param status Specifies whether the rule is enabled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleProperty#getDeleteMarkerReplication}
             * @param deleteMarkerReplication Specifies whether Amazon S3 replicates delete markers.
             *                                If you specify a <code>Filter</code> in your replication configuration, you must also include a <code>DeleteMarkerReplication</code> element. If your <code>Filter</code> includes a <code>Tag</code> element, the <code>DeleteMarkerReplication</code> <code>Status</code> must be set to Disabled, because Amazon S3 does not support replicating delete markers for tag-based rules. For an example configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-config-min-rule-config">Basic Rule Configuration</a> .
             *                                <p>
             *                                For more information about delete marker replication, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/delete-marker-replication.html">Basic Rule Configuration</a> .
             *                                <p>
             *                                <blockquote>
             *                                <p>
             *                                If you are using an earlier version of the replication configuration, Amazon S3 handles replication of delete markers differently. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-backward-compat-considerations">Backward Compatibility</a> .
             *                                <p>
             *                                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteMarkerReplication(software.amazon.awscdk.core.IResolvable deleteMarkerReplication) {
                this.deleteMarkerReplication = deleteMarkerReplication;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleProperty#getDeleteMarkerReplication}
             * @param deleteMarkerReplication Specifies whether Amazon S3 replicates delete markers.
             *                                If you specify a <code>Filter</code> in your replication configuration, you must also include a <code>DeleteMarkerReplication</code> element. If your <code>Filter</code> includes a <code>Tag</code> element, the <code>DeleteMarkerReplication</code> <code>Status</code> must be set to Disabled, because Amazon S3 does not support replicating delete markers for tag-based rules. For an example configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-config-min-rule-config">Basic Rule Configuration</a> .
             *                                <p>
             *                                For more information about delete marker replication, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/delete-marker-replication.html">Basic Rule Configuration</a> .
             *                                <p>
             *                                <blockquote>
             *                                <p>
             *                                If you are using an earlier version of the replication configuration, Amazon S3 handles replication of delete markers differently. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-backward-compat-considerations">Backward Compatibility</a> .
             *                                <p>
             *                                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteMarkerReplication(software.amazon.awscdk.services.s3.CfnBucket.DeleteMarkerReplicationProperty deleteMarkerReplication) {
                this.deleteMarkerReplication = deleteMarkerReplication;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleProperty#getFilter}
             * @param filter A filter that identifies the subset of objects to which the replication rule applies.
             *               A <code>Filter</code> must specify exactly one <code>Prefix</code> , <code>TagFilter</code> , or an <code>And</code> child element. The use of the filter field indicates that this is a V2 replication configuration. This field isn't supported in a V1 replication configuration.
             *               <p>
             *               <blockquote>
             *               <p>
             *               V1 replication configuration only supports filtering by key prefix. To filter using a V1 replication configuration, add the <code>Prefix</code> directly as a child element of the <code>Rule</code> element.
             *               <p>
             *               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.core.IResolvable filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleProperty#getFilter}
             * @param filter A filter that identifies the subset of objects to which the replication rule applies.
             *               A <code>Filter</code> must specify exactly one <code>Prefix</code> , <code>TagFilter</code> , or an <code>And</code> child element. The use of the filter field indicates that this is a V2 replication configuration. This field isn't supported in a V1 replication configuration.
             *               <p>
             *               <blockquote>
             *               <p>
             *               V1 replication configuration only supports filtering by key prefix. To filter using a V1 replication configuration, add the <code>Prefix</code> directly as a child element of the <code>Rule</code> element.
             *               <p>
             *               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.services.s3.CfnBucket.ReplicationRuleFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleProperty#getId}
             * @param id A unique identifier for the rule.
             *           The maximum value is 255 characters. If you don't specify a value, AWS CloudFormation generates a random ID. When using a V2 replication configuration this property is capitalized as "ID".
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleProperty#getPrefix}
             * @param prefix An object key name prefix that identifies the object or objects to which the rule applies.
             *               The maximum prefix length is 1,024 characters. To include all objects in a bucket, specify an empty string. To filter using a V1 replication configuration, add the <code>Prefix</code> directly as a child element of the <code>Rule</code> element.
             *               <p>
             *               <blockquote>
             *               <p>
             *               Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints">XML related object key constraints</a> .
             *               <p>
             *               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleProperty#getPriority}
             * @param priority The priority indicates which rule has precedence whenever two or more replication rules conflict.
             *                 Amazon S3 will attempt to replicate objects according to all replication rules. However, if there are two or more rules with the same destination bucket, then objects will be replicated according to the rule with the highest priority. The higher the number, the higher the priority.
             *                 <p>
             *                 For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html">Replication</a> in the <em>Amazon S3 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder priority(java.lang.Number priority) {
                this.priority = priority;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleProperty#getSourceSelectionCriteria}
             * @param sourceSelectionCriteria A container that describes additional filters for identifying the source objects that you want to replicate.
             *                                You can choose to enable or disable the replication of these objects.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceSelectionCriteria(software.amazon.awscdk.core.IResolvable sourceSelectionCriteria) {
                this.sourceSelectionCriteria = sourceSelectionCriteria;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleProperty#getSourceSelectionCriteria}
             * @param sourceSelectionCriteria A container that describes additional filters for identifying the source objects that you want to replicate.
             *                                You can choose to enable or disable the replication of these objects.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceSelectionCriteria(software.amazon.awscdk.services.s3.CfnBucket.SourceSelectionCriteriaProperty sourceSelectionCriteria) {
                this.sourceSelectionCriteria = sourceSelectionCriteria;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReplicationRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReplicationRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicationRuleProperty {
            private final java.lang.Object destination;
            private final java.lang.String status;
            private final java.lang.Object deleteMarkerReplication;
            private final java.lang.Object filter;
            private final java.lang.String id;
            private final java.lang.String prefix;
            private final java.lang.Number priority;
            private final java.lang.Object sourceSelectionCriteria;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.deleteMarkerReplication = software.amazon.jsii.Kernel.get(this, "deleteMarkerReplication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.filter = software.amazon.jsii.Kernel.get(this, "filter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sourceSelectionCriteria = software.amazon.jsii.Kernel.get(this, "sourceSelectionCriteria", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destination = java.util.Objects.requireNonNull(builder.destination, "destination is required");
                this.status = java.util.Objects.requireNonNull(builder.status, "status is required");
                this.deleteMarkerReplication = builder.deleteMarkerReplication;
                this.filter = builder.filter;
                this.id = builder.id;
                this.prefix = builder.prefix;
                this.priority = builder.priority;
                this.sourceSelectionCriteria = builder.sourceSelectionCriteria;
            }

            @Override
            public final java.lang.Object getDestination() {
                return this.destination;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.lang.Object getDeleteMarkerReplication() {
                return this.deleteMarkerReplication;
            }

            @Override
            public final java.lang.Object getFilter() {
                return this.filter;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public final java.lang.Number getPriority() {
                return this.priority;
            }

            @Override
            public final java.lang.Object getSourceSelectionCriteria() {
                return this.sourceSelectionCriteria;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destination", om.valueToTree(this.getDestination()));
                data.set("status", om.valueToTree(this.getStatus()));
                if (this.getDeleteMarkerReplication() != null) {
                    data.set("deleteMarkerReplication", om.valueToTree(this.getDeleteMarkerReplication()));
                }
                if (this.getFilter() != null) {
                    data.set("filter", om.valueToTree(this.getFilter()));
                }
                if (this.getId() != null) {
                    data.set("id", om.valueToTree(this.getId()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }
                if (this.getPriority() != null) {
                    data.set("priority", om.valueToTree(this.getPriority()));
                }
                if (this.getSourceSelectionCriteria() != null) {
                    data.set("sourceSelectionCriteria", om.valueToTree(this.getSourceSelectionCriteria()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.ReplicationRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicationRuleProperty.Jsii$Proxy that = (ReplicationRuleProperty.Jsii$Proxy) o;

                if (!destination.equals(that.destination)) return false;
                if (!status.equals(that.status)) return false;
                if (this.deleteMarkerReplication != null ? !this.deleteMarkerReplication.equals(that.deleteMarkerReplication) : that.deleteMarkerReplication != null) return false;
                if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) return false;
                if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
                if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
                if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) return false;
                return this.sourceSelectionCriteria != null ? this.sourceSelectionCriteria.equals(that.sourceSelectionCriteria) : that.sourceSelectionCriteria == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destination.hashCode();
                result = 31 * result + (this.status.hashCode());
                result = 31 * result + (this.deleteMarkerReplication != null ? this.deleteMarkerReplication.hashCode() : 0);
                result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
                result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
                result = 31 * result + (this.sourceSelectionCriteria != null ? this.sourceSelectionCriteria.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A container specifying S3 Replication Time Control (S3 RTC) related information, including whether S3 RTC is enabled and the time when all objects and operations on objects must be replicated.
     * <p>
     * Must be specified together with a <code>Metrics</code> block.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * ReplicationTimeProperty replicationTimeProperty = ReplicationTimeProperty.builder()
     *         .status("status")
     *         .time(ReplicationTimeValueProperty.builder()
     *                 .minutes(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.ReplicationTimeProperty")
    @software.amazon.jsii.Jsii.Proxy(ReplicationTimeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicationTimeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether the replication time is enabled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatus();

        /**
         * A container specifying the time by which replication should be complete for all objects and operations on objects.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTime();

        /**
         * @return a {@link Builder} of {@link ReplicationTimeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReplicationTimeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReplicationTimeProperty> {
            java.lang.String status;
            java.lang.Object time;

            /**
             * Sets the value of {@link ReplicationTimeProperty#getStatus}
             * @param status Specifies whether the replication time is enabled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationTimeProperty#getTime}
             * @param time A container specifying the time by which replication should be complete for all objects and operations on objects. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder time(software.amazon.awscdk.core.IResolvable time) {
                this.time = time;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationTimeProperty#getTime}
             * @param time A container specifying the time by which replication should be complete for all objects and operations on objects. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder time(software.amazon.awscdk.services.s3.CfnBucket.ReplicationTimeValueProperty time) {
                this.time = time;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationTimeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReplicationTimeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReplicationTimeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicationTimeProperty {
            private final java.lang.String status;
            private final java.lang.Object time;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.time = software.amazon.jsii.Kernel.get(this, "time", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.status = java.util.Objects.requireNonNull(builder.status, "status is required");
                this.time = java.util.Objects.requireNonNull(builder.time, "time is required");
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.lang.Object getTime() {
                return this.time;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("status", om.valueToTree(this.getStatus()));
                data.set("time", om.valueToTree(this.getTime()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.ReplicationTimeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicationTimeProperty.Jsii$Proxy that = (ReplicationTimeProperty.Jsii$Proxy) o;

                if (!status.equals(that.status)) return false;
                return this.time.equals(that.time);
            }

            @Override
            public final int hashCode() {
                int result = this.status.hashCode();
                result = 31 * result + (this.time.hashCode());
                return result;
            }
        }
    }
    /**
     * A container specifying the time value for S3 Replication Time Control (S3 RTC) and replication metrics `EventThreshold` .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * ReplicationTimeValueProperty replicationTimeValueProperty = ReplicationTimeValueProperty.builder()
     *         .minutes(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.ReplicationTimeValueProperty")
    @software.amazon.jsii.Jsii.Proxy(ReplicationTimeValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicationTimeValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains an integer specifying time in minutes.
         * <p>
         * Valid value: 15
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinutes();

        /**
         * @return a {@link Builder} of {@link ReplicationTimeValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReplicationTimeValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReplicationTimeValueProperty> {
            java.lang.Number minutes;

            /**
             * Sets the value of {@link ReplicationTimeValueProperty#getMinutes}
             * @param minutes Contains an integer specifying time in minutes. This parameter is required.
             *                Valid value: 15
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minutes(java.lang.Number minutes) {
                this.minutes = minutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationTimeValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReplicationTimeValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReplicationTimeValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicationTimeValueProperty {
            private final java.lang.Number minutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.minutes = software.amazon.jsii.Kernel.get(this, "minutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.minutes = java.util.Objects.requireNonNull(builder.minutes, "minutes is required");
            }

            @Override
            public final java.lang.Number getMinutes() {
                return this.minutes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("minutes", om.valueToTree(this.getMinutes()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.ReplicationTimeValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicationTimeValueProperty.Jsii$Proxy that = (ReplicationTimeValueProperty.Jsii$Proxy) o;

                return this.minutes.equals(that.minutes);
            }

            @Override
            public final int hashCode() {
                int result = this.minutes.hashCode();
                return result;
            }
        }
    }
    /**
     * A container for describing a condition that must be met for the specified redirect to apply.
     * <p>
     * For example, 1. If request is for pages in the <code>/docs</code> folder, redirect to the <code>/documents</code> folder. 2. If request results in HTTP error 4xx, redirect request to another host where you might process the error.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * RoutingRuleConditionProperty routingRuleConditionProperty = RoutingRuleConditionProperty.builder()
     *         .httpErrorCodeReturnedEquals("httpErrorCodeReturnedEquals")
     *         .keyPrefixEquals("keyPrefixEquals")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.RoutingRuleConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(RoutingRuleConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RoutingRuleConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The HTTP error code when the redirect is applied.
         * <p>
         * In the event of an error, if the error code equals this value, then the specified redirect is applied.
         * <p>
         * Required when parent element <code>Condition</code> is specified and sibling <code>KeyPrefixEquals</code> is not specified. If both are specified, then both must be true for the redirect to be applied.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHttpErrorCodeReturnedEquals() {
            return null;
        }

        /**
         * The object key name prefix when the redirect is applied.
         * <p>
         * For example, to redirect requests for <code>ExamplePage.html</code> , the key prefix will be <code>ExamplePage.html</code> . To redirect request for all pages with the prefix <code>docs/</code> , the key prefix will be <code>/docs</code> , which identifies all objects in the docs/ folder.
         * <p>
         * Required when the parent element <code>Condition</code> is specified and sibling <code>HttpErrorCodeReturnedEquals</code> is not specified. If both conditions are specified, both must be true for the redirect to be applied.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKeyPrefixEquals() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RoutingRuleConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RoutingRuleConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RoutingRuleConditionProperty> {
            java.lang.String httpErrorCodeReturnedEquals;
            java.lang.String keyPrefixEquals;

            /**
             * Sets the value of {@link RoutingRuleConditionProperty#getHttpErrorCodeReturnedEquals}
             * @param httpErrorCodeReturnedEquals The HTTP error code when the redirect is applied.
             *                                    In the event of an error, if the error code equals this value, then the specified redirect is applied.
             *                                    <p>
             *                                    Required when parent element <code>Condition</code> is specified and sibling <code>KeyPrefixEquals</code> is not specified. If both are specified, then both must be true for the redirect to be applied.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpErrorCodeReturnedEquals(java.lang.String httpErrorCodeReturnedEquals) {
                this.httpErrorCodeReturnedEquals = httpErrorCodeReturnedEquals;
                return this;
            }

            /**
             * Sets the value of {@link RoutingRuleConditionProperty#getKeyPrefixEquals}
             * @param keyPrefixEquals The object key name prefix when the redirect is applied.
             *                        For example, to redirect requests for <code>ExamplePage.html</code> , the key prefix will be <code>ExamplePage.html</code> . To redirect request for all pages with the prefix <code>docs/</code> , the key prefix will be <code>/docs</code> , which identifies all objects in the docs/ folder.
             *                        <p>
             *                        Required when the parent element <code>Condition</code> is specified and sibling <code>HttpErrorCodeReturnedEquals</code> is not specified. If both conditions are specified, both must be true for the redirect to be applied.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyPrefixEquals(java.lang.String keyPrefixEquals) {
                this.keyPrefixEquals = keyPrefixEquals;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RoutingRuleConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RoutingRuleConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RoutingRuleConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RoutingRuleConditionProperty {
            private final java.lang.String httpErrorCodeReturnedEquals;
            private final java.lang.String keyPrefixEquals;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.httpErrorCodeReturnedEquals = software.amazon.jsii.Kernel.get(this, "httpErrorCodeReturnedEquals", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keyPrefixEquals = software.amazon.jsii.Kernel.get(this, "keyPrefixEquals", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.httpErrorCodeReturnedEquals = builder.httpErrorCodeReturnedEquals;
                this.keyPrefixEquals = builder.keyPrefixEquals;
            }

            @Override
            public final java.lang.String getHttpErrorCodeReturnedEquals() {
                return this.httpErrorCodeReturnedEquals;
            }

            @Override
            public final java.lang.String getKeyPrefixEquals() {
                return this.keyPrefixEquals;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHttpErrorCodeReturnedEquals() != null) {
                    data.set("httpErrorCodeReturnedEquals", om.valueToTree(this.getHttpErrorCodeReturnedEquals()));
                }
                if (this.getKeyPrefixEquals() != null) {
                    data.set("keyPrefixEquals", om.valueToTree(this.getKeyPrefixEquals()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.RoutingRuleConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RoutingRuleConditionProperty.Jsii$Proxy that = (RoutingRuleConditionProperty.Jsii$Proxy) o;

                if (this.httpErrorCodeReturnedEquals != null ? !this.httpErrorCodeReturnedEquals.equals(that.httpErrorCodeReturnedEquals) : that.httpErrorCodeReturnedEquals != null) return false;
                return this.keyPrefixEquals != null ? this.keyPrefixEquals.equals(that.keyPrefixEquals) : that.keyPrefixEquals == null;
            }

            @Override
            public final int hashCode() {
                int result = this.httpErrorCodeReturnedEquals != null ? this.httpErrorCodeReturnedEquals.hashCode() : 0;
                result = 31 * result + (this.keyPrefixEquals != null ? this.keyPrefixEquals.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the redirect behavior and when a redirect is applied.
     * <p>
     * For more information about routing rules, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html#advanced-conditional-redirects">Configuring advanced conditional redirects</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * RoutingRuleProperty routingRuleProperty = RoutingRuleProperty.builder()
     *         .redirectRule(RedirectRuleProperty.builder()
     *                 .hostName("hostName")
     *                 .httpRedirectCode("httpRedirectCode")
     *                 .protocol("protocol")
     *                 .replaceKeyPrefixWith("replaceKeyPrefixWith")
     *                 .replaceKeyWith("replaceKeyWith")
     *                 .build())
     *         // the properties below are optional
     *         .routingRuleCondition(RoutingRuleConditionProperty.builder()
     *                 .httpErrorCodeReturnedEquals("httpErrorCodeReturnedEquals")
     *                 .keyPrefixEquals("keyPrefixEquals")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.RoutingRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(RoutingRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RoutingRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Container for redirect information.
         * <p>
         * You can redirect requests to another host, to another page, or with another protocol. In the event of an error, you can specify a different error code to return.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRedirectRule();

        /**
         * A container for describing a condition that must be met for the specified redirect to apply.
         * <p>
         * For example, 1. If request is for pages in the <code>/docs</code> folder, redirect to the <code>/documents</code> folder. 2. If request results in HTTP error 4xx, redirect request to another host where you might process the error.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRoutingRuleCondition() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RoutingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RoutingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RoutingRuleProperty> {
            java.lang.Object redirectRule;
            java.lang.Object routingRuleCondition;

            /**
             * Sets the value of {@link RoutingRuleProperty#getRedirectRule}
             * @param redirectRule Container for redirect information. This parameter is required.
             *                     You can redirect requests to another host, to another page, or with another protocol. In the event of an error, you can specify a different error code to return.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redirectRule(software.amazon.awscdk.core.IResolvable redirectRule) {
                this.redirectRule = redirectRule;
                return this;
            }

            /**
             * Sets the value of {@link RoutingRuleProperty#getRedirectRule}
             * @param redirectRule Container for redirect information. This parameter is required.
             *                     You can redirect requests to another host, to another page, or with another protocol. In the event of an error, you can specify a different error code to return.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redirectRule(software.amazon.awscdk.services.s3.CfnBucket.RedirectRuleProperty redirectRule) {
                this.redirectRule = redirectRule;
                return this;
            }

            /**
             * Sets the value of {@link RoutingRuleProperty#getRoutingRuleCondition}
             * @param routingRuleCondition A container for describing a condition that must be met for the specified redirect to apply.
             *                             For example, 1. If request is for pages in the <code>/docs</code> folder, redirect to the <code>/documents</code> folder. 2. If request results in HTTP error 4xx, redirect request to another host where you might process the error.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder routingRuleCondition(software.amazon.awscdk.core.IResolvable routingRuleCondition) {
                this.routingRuleCondition = routingRuleCondition;
                return this;
            }

            /**
             * Sets the value of {@link RoutingRuleProperty#getRoutingRuleCondition}
             * @param routingRuleCondition A container for describing a condition that must be met for the specified redirect to apply.
             *                             For example, 1. If request is for pages in the <code>/docs</code> folder, redirect to the <code>/documents</code> folder. 2. If request results in HTTP error 4xx, redirect request to another host where you might process the error.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder routingRuleCondition(software.amazon.awscdk.services.s3.CfnBucket.RoutingRuleConditionProperty routingRuleCondition) {
                this.routingRuleCondition = routingRuleCondition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RoutingRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RoutingRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RoutingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RoutingRuleProperty {
            private final java.lang.Object redirectRule;
            private final java.lang.Object routingRuleCondition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.redirectRule = software.amazon.jsii.Kernel.get(this, "redirectRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.routingRuleCondition = software.amazon.jsii.Kernel.get(this, "routingRuleCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.redirectRule = java.util.Objects.requireNonNull(builder.redirectRule, "redirectRule is required");
                this.routingRuleCondition = builder.routingRuleCondition;
            }

            @Override
            public final java.lang.Object getRedirectRule() {
                return this.redirectRule;
            }

            @Override
            public final java.lang.Object getRoutingRuleCondition() {
                return this.routingRuleCondition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("redirectRule", om.valueToTree(this.getRedirectRule()));
                if (this.getRoutingRuleCondition() != null) {
                    data.set("routingRuleCondition", om.valueToTree(this.getRoutingRuleCondition()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.RoutingRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RoutingRuleProperty.Jsii$Proxy that = (RoutingRuleProperty.Jsii$Proxy) o;

                if (!redirectRule.equals(that.redirectRule)) return false;
                return this.routingRuleCondition != null ? this.routingRuleCondition.equals(that.routingRuleCondition) : that.routingRuleCondition == null;
            }

            @Override
            public final int hashCode() {
                int result = this.redirectRule.hashCode();
                result = 31 * result + (this.routingRuleCondition != null ? this.routingRuleCondition.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies lifecycle rules for an Amazon S3 bucket.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlifecycle.html">Put Bucket Lifecycle Configuration</a> in the <em>Amazon S3 API Reference</em> .
     * <p>
     * You must specify at least one of the following properties: <code>AbortIncompleteMultipartUpload</code> , <code>ExpirationDate</code> , <code>ExpirationInDays</code> , <code>NoncurrentVersionExpirationInDays</code> , <code>NoncurrentVersionTransition</code> , <code>NoncurrentVersionTransitions</code> , <code>Transition</code> , or <code>Transitions</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * RuleProperty ruleProperty = RuleProperty.builder()
     *         .status("status")
     *         // the properties below are optional
     *         .abortIncompleteMultipartUpload(AbortIncompleteMultipartUploadProperty.builder()
     *                 .daysAfterInitiation(123)
     *                 .build())
     *         .expirationDate(new Date())
     *         .expirationInDays(123)
     *         .expiredObjectDeleteMarker(false)
     *         .id("id")
     *         .noncurrentVersionExpiration(NoncurrentVersionExpirationProperty.builder()
     *                 .noncurrentDays(123)
     *                 // the properties below are optional
     *                 .newerNoncurrentVersions(123)
     *                 .build())
     *         .noncurrentVersionExpirationInDays(123)
     *         .noncurrentVersionTransition(NoncurrentVersionTransitionProperty.builder()
     *                 .storageClass("storageClass")
     *                 .transitionInDays(123)
     *                 // the properties below are optional
     *                 .newerNoncurrentVersions(123)
     *                 .build())
     *         .noncurrentVersionTransitions(List.of(NoncurrentVersionTransitionProperty.builder()
     *                 .storageClass("storageClass")
     *                 .transitionInDays(123)
     *                 // the properties below are optional
     *                 .newerNoncurrentVersions(123)
     *                 .build()))
     *         .objectSizeGreaterThan(123)
     *         .objectSizeLessThan(123)
     *         .prefix("prefix")
     *         .tagFilters(List.of(TagFilterProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .transition(TransitionProperty.builder()
     *                 .storageClass("storageClass")
     *                 // the properties below are optional
     *                 .transitionDate(new Date())
     *                 .transitionInDays(123)
     *                 .build())
     *         .transitions(List.of(TransitionProperty.builder()
     *                 .storageClass("storageClass")
     *                 // the properties below are optional
     *                 .transitionDate(new Date())
     *                 .transitionInDays(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.RuleProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If `Enabled` , the rule is currently being applied.
         * <p>
         * If <code>Disabled</code> , the rule is not currently being applied.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatus();

        /**
         * Specifies a lifecycle rule that stops incomplete multipart uploads to an Amazon S3 bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAbortIncompleteMultipartUpload() {
            return null;
        }

        /**
         * Indicates when objects are deleted from Amazon S3 and Amazon S3 Glacier.
         * <p>
         * The date value must be in ISO 8601 format. The time is always midnight UTC. If you specify an expiration and transition time, you must use the same time unit for both properties (either in days or by date). The expiration time must also be later than the transition time.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExpirationDate() {
            return null;
        }

        /**
         * Indicates the number of days after creation when objects are deleted from Amazon S3 and Amazon S3 Glacier.
         * <p>
         * If you specify an expiration and transition time, you must use the same time unit for both properties (either in days or by date). The expiration time must also be later than the transition time.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getExpirationInDays() {
            return null;
        }

        /**
         * Indicates whether Amazon S3 will remove a delete marker without any noncurrent versions.
         * <p>
         * If set to true, the delete marker will be removed if there are no noncurrent versions. This cannot be specified with <code>ExpirationInDays</code> , <code>ExpirationDate</code> , or <code>TagFilters</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExpiredObjectDeleteMarker() {
            return null;
        }

        /**
         * Unique identifier for the rule.
         * <p>
         * The value can't be longer than 255 characters.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getId() {
            return null;
        }

        /**
         * Specifies when noncurrent object versions expire.
         * <p>
         * Upon expiration, Amazon S3 permanently deletes the noncurrent object versions. You set this lifecycle configuration action on a bucket that has versioning enabled (or suspended) to request that Amazon S3 delete noncurrent object versions at a specific period in the object's lifetime.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNoncurrentVersionExpiration() {
            return null;
        }

        /**
         * (Deprecated.) For buckets with versioning enabled (or suspended), specifies the time, in days, between when a new version of the object is uploaded to the bucket and when old versions of the object expire. When object versions expire, Amazon S3 permanently deletes them. If you specify a transition and expiration time, the expiration time must be later than the transition time.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNoncurrentVersionExpirationInDays() {
            return null;
        }

        /**
         * (Deprecated.) For buckets with versioning enabled (or suspended), specifies when non-current objects transition to a specified storage class. If you specify a transition and expiration time, the expiration time must be later than the transition time. If you specify this property, don't specify the `NoncurrentVersionTransitions` property.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNoncurrentVersionTransition() {
            return null;
        }

        /**
         * For buckets with versioning enabled (or suspended), one or more transition rules that specify when non-current objects transition to a specified storage class.
         * <p>
         * If you specify a transition and expiration time, the expiration time must be later than the transition time. If you specify this property, don't specify the <code>NoncurrentVersionTransition</code> property.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNoncurrentVersionTransitions() {
            return null;
        }

        /**
         * Specifies the minimum object size in bytes for this rule to apply to.
         * <p>
         * Objects must be larger than this value in bytes. For more information about size based rules, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/lifecycle-configuration-examples.html#lc-size-rules">Lifecycle configuration using size-based rules</a> in the <em>Amazon S3 User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getObjectSizeGreaterThan() {
            return null;
        }

        /**
         * Specifies the maximum object size in bytes for this rule to apply to.
         * <p>
         * Objects must be smaller than this value in bytes. For more information about sized based rules, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/lifecycle-configuration-examples.html#lc-size-rules">Lifecycle configuration using size-based rules</a> in the <em>Amazon S3 User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getObjectSizeLessThan() {
            return null;
        }

        /**
         * Object key prefix that identifies one or more objects to which this rule applies.
         * <p>
         * <blockquote>
         * <p>
         * Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints">XML related object key constraints</a> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * Tags to use to identify a subset of objects to which the lifecycle rule applies.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagFilters() {
            return null;
        }

        /**
         * (Deprecated.) Specifies when an object transitions to a specified storage class. If you specify an expiration and transition time, you must use the same time unit for both properties (either in days or by date). The expiration time must also be later than the transition time. If you specify this property, don't specify the `Transitions` property.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTransition() {
            return null;
        }

        /**
         * One or more transition rules that specify when an object transitions to a specified storage class.
         * <p>
         * If you specify an expiration and transition time, you must use the same time unit for both properties (either in days or by date). The expiration time must also be later than the transition time. If you specify this property, don't specify the <code>Transition</code> property.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTransitions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleProperty> {
            java.lang.String status;
            java.lang.Object abortIncompleteMultipartUpload;
            java.lang.Object expirationDate;
            java.lang.Number expirationInDays;
            java.lang.Object expiredObjectDeleteMarker;
            java.lang.String id;
            java.lang.Object noncurrentVersionExpiration;
            java.lang.Number noncurrentVersionExpirationInDays;
            java.lang.Object noncurrentVersionTransition;
            java.lang.Object noncurrentVersionTransitions;
            java.lang.Number objectSizeGreaterThan;
            java.lang.Number objectSizeLessThan;
            java.lang.String prefix;
            java.lang.Object tagFilters;
            java.lang.Object transition;
            java.lang.Object transitions;

            /**
             * Sets the value of {@link RuleProperty#getStatus}
             * @param status If `Enabled` , the rule is currently being applied. This parameter is required.
             *               If <code>Disabled</code> , the rule is not currently being applied.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getAbortIncompleteMultipartUpload}
             * @param abortIncompleteMultipartUpload Specifies a lifecycle rule that stops incomplete multipart uploads to an Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder abortIncompleteMultipartUpload(software.amazon.awscdk.core.IResolvable abortIncompleteMultipartUpload) {
                this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getAbortIncompleteMultipartUpload}
             * @param abortIncompleteMultipartUpload Specifies a lifecycle rule that stops incomplete multipart uploads to an Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder abortIncompleteMultipartUpload(software.amazon.awscdk.services.s3.CfnBucket.AbortIncompleteMultipartUploadProperty abortIncompleteMultipartUpload) {
                this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getExpirationDate}
             * @param expirationDate Indicates when objects are deleted from Amazon S3 and Amazon S3 Glacier.
             *                       The date value must be in ISO 8601 format. The time is always midnight UTC. If you specify an expiration and transition time, you must use the same time unit for both properties (either in days or by date). The expiration time must also be later than the transition time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expirationDate(java.time.Instant expirationDate) {
                this.expirationDate = expirationDate;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getExpirationDate}
             * @param expirationDate Indicates when objects are deleted from Amazon S3 and Amazon S3 Glacier.
             *                       The date value must be in ISO 8601 format. The time is always midnight UTC. If you specify an expiration and transition time, you must use the same time unit for both properties (either in days or by date). The expiration time must also be later than the transition time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expirationDate(software.amazon.awscdk.core.IResolvable expirationDate) {
                this.expirationDate = expirationDate;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getExpirationInDays}
             * @param expirationInDays Indicates the number of days after creation when objects are deleted from Amazon S3 and Amazon S3 Glacier.
             *                         If you specify an expiration and transition time, you must use the same time unit for both properties (either in days or by date). The expiration time must also be later than the transition time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expirationInDays(java.lang.Number expirationInDays) {
                this.expirationInDays = expirationInDays;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getExpiredObjectDeleteMarker}
             * @param expiredObjectDeleteMarker Indicates whether Amazon S3 will remove a delete marker without any noncurrent versions.
             *                                  If set to true, the delete marker will be removed if there are no noncurrent versions. This cannot be specified with <code>ExpirationInDays</code> , <code>ExpirationDate</code> , or <code>TagFilters</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expiredObjectDeleteMarker(java.lang.Boolean expiredObjectDeleteMarker) {
                this.expiredObjectDeleteMarker = expiredObjectDeleteMarker;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getExpiredObjectDeleteMarker}
             * @param expiredObjectDeleteMarker Indicates whether Amazon S3 will remove a delete marker without any noncurrent versions.
             *                                  If set to true, the delete marker will be removed if there are no noncurrent versions. This cannot be specified with <code>ExpirationInDays</code> , <code>ExpirationDate</code> , or <code>TagFilters</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expiredObjectDeleteMarker(software.amazon.awscdk.core.IResolvable expiredObjectDeleteMarker) {
                this.expiredObjectDeleteMarker = expiredObjectDeleteMarker;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getId}
             * @param id Unique identifier for the rule.
             *           The value can't be longer than 255 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getNoncurrentVersionExpiration}
             * @param noncurrentVersionExpiration Specifies when noncurrent object versions expire.
             *                                    Upon expiration, Amazon S3 permanently deletes the noncurrent object versions. You set this lifecycle configuration action on a bucket that has versioning enabled (or suspended) to request that Amazon S3 delete noncurrent object versions at a specific period in the object's lifetime.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noncurrentVersionExpiration(software.amazon.awscdk.core.IResolvable noncurrentVersionExpiration) {
                this.noncurrentVersionExpiration = noncurrentVersionExpiration;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getNoncurrentVersionExpiration}
             * @param noncurrentVersionExpiration Specifies when noncurrent object versions expire.
             *                                    Upon expiration, Amazon S3 permanently deletes the noncurrent object versions. You set this lifecycle configuration action on a bucket that has versioning enabled (or suspended) to request that Amazon S3 delete noncurrent object versions at a specific period in the object's lifetime.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noncurrentVersionExpiration(software.amazon.awscdk.services.s3.CfnBucket.NoncurrentVersionExpirationProperty noncurrentVersionExpiration) {
                this.noncurrentVersionExpiration = noncurrentVersionExpiration;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getNoncurrentVersionExpirationInDays}
             * @param noncurrentVersionExpirationInDays (Deprecated.) For buckets with versioning enabled (or suspended), specifies the time, in days, between when a new version of the object is uploaded to the bucket and when old versions of the object expire. When object versions expire, Amazon S3 permanently deletes them. If you specify a transition and expiration time, the expiration time must be later than the transition time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noncurrentVersionExpirationInDays(java.lang.Number noncurrentVersionExpirationInDays) {
                this.noncurrentVersionExpirationInDays = noncurrentVersionExpirationInDays;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getNoncurrentVersionTransition}
             * @param noncurrentVersionTransition (Deprecated.) For buckets with versioning enabled (or suspended), specifies when non-current objects transition to a specified storage class. If you specify a transition and expiration time, the expiration time must be later than the transition time. If you specify this property, don't specify the `NoncurrentVersionTransitions` property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noncurrentVersionTransition(software.amazon.awscdk.core.IResolvable noncurrentVersionTransition) {
                this.noncurrentVersionTransition = noncurrentVersionTransition;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getNoncurrentVersionTransition}
             * @param noncurrentVersionTransition (Deprecated.) For buckets with versioning enabled (or suspended), specifies when non-current objects transition to a specified storage class. If you specify a transition and expiration time, the expiration time must be later than the transition time. If you specify this property, don't specify the `NoncurrentVersionTransitions` property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noncurrentVersionTransition(software.amazon.awscdk.services.s3.CfnBucket.NoncurrentVersionTransitionProperty noncurrentVersionTransition) {
                this.noncurrentVersionTransition = noncurrentVersionTransition;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getNoncurrentVersionTransitions}
             * @param noncurrentVersionTransitions For buckets with versioning enabled (or suspended), one or more transition rules that specify when non-current objects transition to a specified storage class.
             *                                     If you specify a transition and expiration time, the expiration time must be later than the transition time. If you specify this property, don't specify the <code>NoncurrentVersionTransition</code> property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noncurrentVersionTransitions(software.amazon.awscdk.core.IResolvable noncurrentVersionTransitions) {
                this.noncurrentVersionTransitions = noncurrentVersionTransitions;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getNoncurrentVersionTransitions}
             * @param noncurrentVersionTransitions For buckets with versioning enabled (or suspended), one or more transition rules that specify when non-current objects transition to a specified storage class.
             *                                     If you specify a transition and expiration time, the expiration time must be later than the transition time. If you specify this property, don't specify the <code>NoncurrentVersionTransition</code> property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noncurrentVersionTransitions(java.util.List<? extends java.lang.Object> noncurrentVersionTransitions) {
                this.noncurrentVersionTransitions = noncurrentVersionTransitions;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getObjectSizeGreaterThan}
             * @param objectSizeGreaterThan Specifies the minimum object size in bytes for this rule to apply to.
             *                              Objects must be larger than this value in bytes. For more information about size based rules, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/lifecycle-configuration-examples.html#lc-size-rules">Lifecycle configuration using size-based rules</a> in the <em>Amazon S3 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectSizeGreaterThan(java.lang.Number objectSizeGreaterThan) {
                this.objectSizeGreaterThan = objectSizeGreaterThan;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getObjectSizeLessThan}
             * @param objectSizeLessThan Specifies the maximum object size in bytes for this rule to apply to.
             *                           Objects must be smaller than this value in bytes. For more information about sized based rules, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/lifecycle-configuration-examples.html#lc-size-rules">Lifecycle configuration using size-based rules</a> in the <em>Amazon S3 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectSizeLessThan(java.lang.Number objectSizeLessThan) {
                this.objectSizeLessThan = objectSizeLessThan;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getPrefix}
             * @param prefix Object key prefix that identifies one or more objects to which this rule applies.
             *               <blockquote>
             *               <p>
             *               Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints">XML related object key constraints</a> .
             *               <p>
             *               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getTagFilters}
             * @param tagFilters Tags to use to identify a subset of objects to which the lifecycle rule applies.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagFilters(software.amazon.awscdk.core.IResolvable tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getTagFilters}
             * @param tagFilters Tags to use to identify a subset of objects to which the lifecycle rule applies.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagFilters(java.util.List<? extends java.lang.Object> tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getTransition}
             * @param transition (Deprecated.) Specifies when an object transitions to a specified storage class. If you specify an expiration and transition time, you must use the same time unit for both properties (either in days or by date). The expiration time must also be later than the transition time. If you specify this property, don't specify the `Transitions` property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transition(software.amazon.awscdk.core.IResolvable transition) {
                this.transition = transition;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getTransition}
             * @param transition (Deprecated.) Specifies when an object transitions to a specified storage class. If you specify an expiration and transition time, you must use the same time unit for both properties (either in days or by date). The expiration time must also be later than the transition time. If you specify this property, don't specify the `Transitions` property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transition(software.amazon.awscdk.services.s3.CfnBucket.TransitionProperty transition) {
                this.transition = transition;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getTransitions}
             * @param transitions One or more transition rules that specify when an object transitions to a specified storage class.
             *                    If you specify an expiration and transition time, you must use the same time unit for both properties (either in days or by date). The expiration time must also be later than the transition time. If you specify this property, don't specify the <code>Transition</code> property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitions(software.amazon.awscdk.core.IResolvable transitions) {
                this.transitions = transitions;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getTransitions}
             * @param transitions One or more transition rules that specify when an object transitions to a specified storage class.
             *                    If you specify an expiration and transition time, you must use the same time unit for both properties (either in days or by date). The expiration time must also be later than the transition time. If you specify this property, don't specify the <code>Transition</code> property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitions(java.util.List<? extends java.lang.Object> transitions) {
                this.transitions = transitions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleProperty {
            private final java.lang.String status;
            private final java.lang.Object abortIncompleteMultipartUpload;
            private final java.lang.Object expirationDate;
            private final java.lang.Number expirationInDays;
            private final java.lang.Object expiredObjectDeleteMarker;
            private final java.lang.String id;
            private final java.lang.Object noncurrentVersionExpiration;
            private final java.lang.Number noncurrentVersionExpirationInDays;
            private final java.lang.Object noncurrentVersionTransition;
            private final java.lang.Object noncurrentVersionTransitions;
            private final java.lang.Number objectSizeGreaterThan;
            private final java.lang.Number objectSizeLessThan;
            private final java.lang.String prefix;
            private final java.lang.Object tagFilters;
            private final java.lang.Object transition;
            private final java.lang.Object transitions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.abortIncompleteMultipartUpload = software.amazon.jsii.Kernel.get(this, "abortIncompleteMultipartUpload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.expirationDate = software.amazon.jsii.Kernel.get(this, "expirationDate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.expirationInDays = software.amazon.jsii.Kernel.get(this, "expirationInDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.expiredObjectDeleteMarker = software.amazon.jsii.Kernel.get(this, "expiredObjectDeleteMarker", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.noncurrentVersionExpiration = software.amazon.jsii.Kernel.get(this, "noncurrentVersionExpiration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.noncurrentVersionExpirationInDays = software.amazon.jsii.Kernel.get(this, "noncurrentVersionExpirationInDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.noncurrentVersionTransition = software.amazon.jsii.Kernel.get(this, "noncurrentVersionTransition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.noncurrentVersionTransitions = software.amazon.jsii.Kernel.get(this, "noncurrentVersionTransitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.objectSizeGreaterThan = software.amazon.jsii.Kernel.get(this, "objectSizeGreaterThan", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.objectSizeLessThan = software.amazon.jsii.Kernel.get(this, "objectSizeLessThan", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tagFilters = software.amazon.jsii.Kernel.get(this, "tagFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.transition = software.amazon.jsii.Kernel.get(this, "transition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.transitions = software.amazon.jsii.Kernel.get(this, "transitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.status = java.util.Objects.requireNonNull(builder.status, "status is required");
                this.abortIncompleteMultipartUpload = builder.abortIncompleteMultipartUpload;
                this.expirationDate = builder.expirationDate;
                this.expirationInDays = builder.expirationInDays;
                this.expiredObjectDeleteMarker = builder.expiredObjectDeleteMarker;
                this.id = builder.id;
                this.noncurrentVersionExpiration = builder.noncurrentVersionExpiration;
                this.noncurrentVersionExpirationInDays = builder.noncurrentVersionExpirationInDays;
                this.noncurrentVersionTransition = builder.noncurrentVersionTransition;
                this.noncurrentVersionTransitions = builder.noncurrentVersionTransitions;
                this.objectSizeGreaterThan = builder.objectSizeGreaterThan;
                this.objectSizeLessThan = builder.objectSizeLessThan;
                this.prefix = builder.prefix;
                this.tagFilters = builder.tagFilters;
                this.transition = builder.transition;
                this.transitions = builder.transitions;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.lang.Object getAbortIncompleteMultipartUpload() {
                return this.abortIncompleteMultipartUpload;
            }

            @Override
            public final java.lang.Object getExpirationDate() {
                return this.expirationDate;
            }

            @Override
            public final java.lang.Number getExpirationInDays() {
                return this.expirationInDays;
            }

            @Override
            public final java.lang.Object getExpiredObjectDeleteMarker() {
                return this.expiredObjectDeleteMarker;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.Object getNoncurrentVersionExpiration() {
                return this.noncurrentVersionExpiration;
            }

            @Override
            public final java.lang.Number getNoncurrentVersionExpirationInDays() {
                return this.noncurrentVersionExpirationInDays;
            }

            @Override
            public final java.lang.Object getNoncurrentVersionTransition() {
                return this.noncurrentVersionTransition;
            }

            @Override
            public final java.lang.Object getNoncurrentVersionTransitions() {
                return this.noncurrentVersionTransitions;
            }

            @Override
            public final java.lang.Number getObjectSizeGreaterThan() {
                return this.objectSizeGreaterThan;
            }

            @Override
            public final java.lang.Number getObjectSizeLessThan() {
                return this.objectSizeLessThan;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public final java.lang.Object getTagFilters() {
                return this.tagFilters;
            }

            @Override
            public final java.lang.Object getTransition() {
                return this.transition;
            }

            @Override
            public final java.lang.Object getTransitions() {
                return this.transitions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("status", om.valueToTree(this.getStatus()));
                if (this.getAbortIncompleteMultipartUpload() != null) {
                    data.set("abortIncompleteMultipartUpload", om.valueToTree(this.getAbortIncompleteMultipartUpload()));
                }
                if (this.getExpirationDate() != null) {
                    data.set("expirationDate", om.valueToTree(this.getExpirationDate()));
                }
                if (this.getExpirationInDays() != null) {
                    data.set("expirationInDays", om.valueToTree(this.getExpirationInDays()));
                }
                if (this.getExpiredObjectDeleteMarker() != null) {
                    data.set("expiredObjectDeleteMarker", om.valueToTree(this.getExpiredObjectDeleteMarker()));
                }
                if (this.getId() != null) {
                    data.set("id", om.valueToTree(this.getId()));
                }
                if (this.getNoncurrentVersionExpiration() != null) {
                    data.set("noncurrentVersionExpiration", om.valueToTree(this.getNoncurrentVersionExpiration()));
                }
                if (this.getNoncurrentVersionExpirationInDays() != null) {
                    data.set("noncurrentVersionExpirationInDays", om.valueToTree(this.getNoncurrentVersionExpirationInDays()));
                }
                if (this.getNoncurrentVersionTransition() != null) {
                    data.set("noncurrentVersionTransition", om.valueToTree(this.getNoncurrentVersionTransition()));
                }
                if (this.getNoncurrentVersionTransitions() != null) {
                    data.set("noncurrentVersionTransitions", om.valueToTree(this.getNoncurrentVersionTransitions()));
                }
                if (this.getObjectSizeGreaterThan() != null) {
                    data.set("objectSizeGreaterThan", om.valueToTree(this.getObjectSizeGreaterThan()));
                }
                if (this.getObjectSizeLessThan() != null) {
                    data.set("objectSizeLessThan", om.valueToTree(this.getObjectSizeLessThan()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }
                if (this.getTagFilters() != null) {
                    data.set("tagFilters", om.valueToTree(this.getTagFilters()));
                }
                if (this.getTransition() != null) {
                    data.set("transition", om.valueToTree(this.getTransition()));
                }
                if (this.getTransitions() != null) {
                    data.set("transitions", om.valueToTree(this.getTransitions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.RuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleProperty.Jsii$Proxy that = (RuleProperty.Jsii$Proxy) o;

                if (!status.equals(that.status)) return false;
                if (this.abortIncompleteMultipartUpload != null ? !this.abortIncompleteMultipartUpload.equals(that.abortIncompleteMultipartUpload) : that.abortIncompleteMultipartUpload != null) return false;
                if (this.expirationDate != null ? !this.expirationDate.equals(that.expirationDate) : that.expirationDate != null) return false;
                if (this.expirationInDays != null ? !this.expirationInDays.equals(that.expirationInDays) : that.expirationInDays != null) return false;
                if (this.expiredObjectDeleteMarker != null ? !this.expiredObjectDeleteMarker.equals(that.expiredObjectDeleteMarker) : that.expiredObjectDeleteMarker != null) return false;
                if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
                if (this.noncurrentVersionExpiration != null ? !this.noncurrentVersionExpiration.equals(that.noncurrentVersionExpiration) : that.noncurrentVersionExpiration != null) return false;
                if (this.noncurrentVersionExpirationInDays != null ? !this.noncurrentVersionExpirationInDays.equals(that.noncurrentVersionExpirationInDays) : that.noncurrentVersionExpirationInDays != null) return false;
                if (this.noncurrentVersionTransition != null ? !this.noncurrentVersionTransition.equals(that.noncurrentVersionTransition) : that.noncurrentVersionTransition != null) return false;
                if (this.noncurrentVersionTransitions != null ? !this.noncurrentVersionTransitions.equals(that.noncurrentVersionTransitions) : that.noncurrentVersionTransitions != null) return false;
                if (this.objectSizeGreaterThan != null ? !this.objectSizeGreaterThan.equals(that.objectSizeGreaterThan) : that.objectSizeGreaterThan != null) return false;
                if (this.objectSizeLessThan != null ? !this.objectSizeLessThan.equals(that.objectSizeLessThan) : that.objectSizeLessThan != null) return false;
                if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
                if (this.tagFilters != null ? !this.tagFilters.equals(that.tagFilters) : that.tagFilters != null) return false;
                if (this.transition != null ? !this.transition.equals(that.transition) : that.transition != null) return false;
                return this.transitions != null ? this.transitions.equals(that.transitions) : that.transitions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.status.hashCode();
                result = 31 * result + (this.abortIncompleteMultipartUpload != null ? this.abortIncompleteMultipartUpload.hashCode() : 0);
                result = 31 * result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
                result = 31 * result + (this.expirationInDays != null ? this.expirationInDays.hashCode() : 0);
                result = 31 * result + (this.expiredObjectDeleteMarker != null ? this.expiredObjectDeleteMarker.hashCode() : 0);
                result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
                result = 31 * result + (this.noncurrentVersionExpiration != null ? this.noncurrentVersionExpiration.hashCode() : 0);
                result = 31 * result + (this.noncurrentVersionExpirationInDays != null ? this.noncurrentVersionExpirationInDays.hashCode() : 0);
                result = 31 * result + (this.noncurrentVersionTransition != null ? this.noncurrentVersionTransition.hashCode() : 0);
                result = 31 * result + (this.noncurrentVersionTransitions != null ? this.noncurrentVersionTransitions.hashCode() : 0);
                result = 31 * result + (this.objectSizeGreaterThan != null ? this.objectSizeGreaterThan.hashCode() : 0);
                result = 31 * result + (this.objectSizeLessThan != null ? this.objectSizeLessThan.hashCode() : 0);
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                result = 31 * result + (this.tagFilters != null ? this.tagFilters.hashCode() : 0);
                result = 31 * result + (this.transition != null ? this.transition.hashCode() : 0);
                result = 31 * result + (this.transitions != null ? this.transitions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A container for object key name prefix and suffix filtering rules.
     * <p>
     * For more information about object key name filtering, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/notification-how-to-filtering.html">Configuring event notifications using object key name filtering</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * The same type of filter rule cannot be used more than once. For example, you cannot specify two prefix rules.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * S3KeyFilterProperty s3KeyFilterProperty = S3KeyFilterProperty.builder()
     *         .rules(List.of(FilterRuleProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.S3KeyFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(S3KeyFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3KeyFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of containers for the key-value pair that defines the criteria for the filter rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRules();

        /**
         * @return a {@link Builder} of {@link S3KeyFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3KeyFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3KeyFilterProperty> {
            java.lang.Object rules;

            /**
             * Sets the value of {@link S3KeyFilterProperty#getRules}
             * @param rules A list of containers for the key-value pair that defines the criteria for the filter rule. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(software.amazon.awscdk.core.IResolvable rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Sets the value of {@link S3KeyFilterProperty#getRules}
             * @param rules A list of containers for the key-value pair that defines the criteria for the filter rule. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(java.util.List<? extends java.lang.Object> rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3KeyFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3KeyFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3KeyFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3KeyFilterProperty {
            private final java.lang.Object rules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.rules = software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.rules = java.util.Objects.requireNonNull(builder.rules, "rules is required");
            }

            @Override
            public final java.lang.Object getRules() {
                return this.rules;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("rules", om.valueToTree(this.getRules()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.S3KeyFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3KeyFilterProperty.Jsii$Proxy that = (S3KeyFilterProperty.Jsii$Proxy) o;

                return this.rules.equals(that.rules);
            }

            @Override
            public final int hashCode() {
                int result = this.rules.hashCode();
                return result;
            }
        }
    }
    /**
     * Describes the default server-side encryption to apply to new objects in the bucket.
     * <p>
     * If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied. If you don't specify a customer managed key at configuration, Amazon S3 automatically creates an AWS KMS key in your AWS account the first time that you add an object encrypted with SSE-KMS to a bucket. By default, Amazon S3 uses this KMS key for SSE-KMS. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTencryption.html">PUT Bucket encryption</a> in the <em>Amazon S3 API Reference</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * ServerSideEncryptionByDefaultProperty serverSideEncryptionByDefaultProperty = ServerSideEncryptionByDefaultProperty.builder()
     *         .sseAlgorithm("sseAlgorithm")
     *         // the properties below are optional
     *         .kmsMasterKeyId("kmsMasterKeyId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.ServerSideEncryptionByDefaultProperty")
    @software.amazon.jsii.Jsii.Proxy(ServerSideEncryptionByDefaultProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServerSideEncryptionByDefaultProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Server-side encryption algorithm to use for the default encryption.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSseAlgorithm();

        /**
         * KMS key ID to use for the default encryption. This parameter is allowed if SSEAlgorithm is aws:kms.
         * <p>
         * You can specify the key ID or the Amazon Resource Name (ARN) of the CMK. However, if you are using encryption with cross-account operations, you must use a fully qualified CMK ARN. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html#bucket-encryption-update-bucket-policy">Using encryption for cross-account operations</a> .
         * <p>
         * For example:
         * <p>
         * <ul>
         * <li>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
         * <li>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * Amazon S3 only supports symmetric KMS keys and not asymmetric KMS keys. For more information, see <a href="https://docs.aws.amazon.com//kms/latest/developerguide/symmetric-asymmetric.html">Using Symmetric and Asymmetric Keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsMasterKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServerSideEncryptionByDefaultProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServerSideEncryptionByDefaultProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServerSideEncryptionByDefaultProperty> {
            java.lang.String sseAlgorithm;
            java.lang.String kmsMasterKeyId;

            /**
             * Sets the value of {@link ServerSideEncryptionByDefaultProperty#getSseAlgorithm}
             * @param sseAlgorithm Server-side encryption algorithm to use for the default encryption. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sseAlgorithm(java.lang.String sseAlgorithm) {
                this.sseAlgorithm = sseAlgorithm;
                return this;
            }

            /**
             * Sets the value of {@link ServerSideEncryptionByDefaultProperty#getKmsMasterKeyId}
             * @param kmsMasterKeyId KMS key ID to use for the default encryption. This parameter is allowed if SSEAlgorithm is aws:kms.
             *                       You can specify the key ID or the Amazon Resource Name (ARN) of the CMK. However, if you are using encryption with cross-account operations, you must use a fully qualified CMK ARN. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html#bucket-encryption-update-bucket-policy">Using encryption for cross-account operations</a> .
             *                       <p>
             *                       For example:
             *                       <p>
             *                       <ul>
             *                       <li>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
             *                       <li>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
             *                       </ul>
             *                       <p>
             *                       <blockquote>
             *                       <p>
             *                       Amazon S3 only supports symmetric KMS keys and not asymmetric KMS keys. For more information, see <a href="https://docs.aws.amazon.com//kms/latest/developerguide/symmetric-asymmetric.html">Using Symmetric and Asymmetric Keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
             *                       <p>
             *                       </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsMasterKeyId(java.lang.String kmsMasterKeyId) {
                this.kmsMasterKeyId = kmsMasterKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerSideEncryptionByDefaultProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServerSideEncryptionByDefaultProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServerSideEncryptionByDefaultProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerSideEncryptionByDefaultProperty {
            private final java.lang.String sseAlgorithm;
            private final java.lang.String kmsMasterKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sseAlgorithm = software.amazon.jsii.Kernel.get(this, "sseAlgorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsMasterKeyId = software.amazon.jsii.Kernel.get(this, "kmsMasterKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sseAlgorithm = java.util.Objects.requireNonNull(builder.sseAlgorithm, "sseAlgorithm is required");
                this.kmsMasterKeyId = builder.kmsMasterKeyId;
            }

            @Override
            public final java.lang.String getSseAlgorithm() {
                return this.sseAlgorithm;
            }

            @Override
            public final java.lang.String getKmsMasterKeyId() {
                return this.kmsMasterKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sseAlgorithm", om.valueToTree(this.getSseAlgorithm()));
                if (this.getKmsMasterKeyId() != null) {
                    data.set("kmsMasterKeyId", om.valueToTree(this.getKmsMasterKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.ServerSideEncryptionByDefaultProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServerSideEncryptionByDefaultProperty.Jsii$Proxy that = (ServerSideEncryptionByDefaultProperty.Jsii$Proxy) o;

                if (!sseAlgorithm.equals(that.sseAlgorithm)) return false;
                return this.kmsMasterKeyId != null ? this.kmsMasterKeyId.equals(that.kmsMasterKeyId) : that.kmsMasterKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sseAlgorithm.hashCode();
                result = 31 * result + (this.kmsMasterKeyId != null ? this.kmsMasterKeyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the default server-side encryption configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * ServerSideEncryptionRuleProperty serverSideEncryptionRuleProperty = ServerSideEncryptionRuleProperty.builder()
     *         .bucketKeyEnabled(false)
     *         .serverSideEncryptionByDefault(ServerSideEncryptionByDefaultProperty.builder()
     *                 .sseAlgorithm("sseAlgorithm")
     *                 // the properties below are optional
     *                 .kmsMasterKeyId("kmsMasterKeyId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.ServerSideEncryptionRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(ServerSideEncryptionRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServerSideEncryptionRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether Amazon S3 should use an S3 Bucket Key with server-side encryption using KMS (SSE-KMS) for new objects in the bucket.
         * <p>
         * Existing objects are not affected. Setting the <code>BucketKeyEnabled</code> element to <code>true</code> causes Amazon S3 to use an S3 Bucket Key. By default, S3 Bucket Key is not enabled.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html">Amazon S3 Bucket Keys</a> in the <em>Amazon S3 User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBucketKeyEnabled() {
            return null;
        }

        /**
         * Specifies the default server-side encryption to apply to new objects in the bucket.
         * <p>
         * If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getServerSideEncryptionByDefault() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServerSideEncryptionRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServerSideEncryptionRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServerSideEncryptionRuleProperty> {
            java.lang.Object bucketKeyEnabled;
            java.lang.Object serverSideEncryptionByDefault;

            /**
             * Sets the value of {@link ServerSideEncryptionRuleProperty#getBucketKeyEnabled}
             * @param bucketKeyEnabled Specifies whether Amazon S3 should use an S3 Bucket Key with server-side encryption using KMS (SSE-KMS) for new objects in the bucket.
             *                         Existing objects are not affected. Setting the <code>BucketKeyEnabled</code> element to <code>true</code> causes Amazon S3 to use an S3 Bucket Key. By default, S3 Bucket Key is not enabled.
             *                         <p>
             *                         For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html">Amazon S3 Bucket Keys</a> in the <em>Amazon S3 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketKeyEnabled(java.lang.Boolean bucketKeyEnabled) {
                this.bucketKeyEnabled = bucketKeyEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ServerSideEncryptionRuleProperty#getBucketKeyEnabled}
             * @param bucketKeyEnabled Specifies whether Amazon S3 should use an S3 Bucket Key with server-side encryption using KMS (SSE-KMS) for new objects in the bucket.
             *                         Existing objects are not affected. Setting the <code>BucketKeyEnabled</code> element to <code>true</code> causes Amazon S3 to use an S3 Bucket Key. By default, S3 Bucket Key is not enabled.
             *                         <p>
             *                         For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html">Amazon S3 Bucket Keys</a> in the <em>Amazon S3 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketKeyEnabled(software.amazon.awscdk.core.IResolvable bucketKeyEnabled) {
                this.bucketKeyEnabled = bucketKeyEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ServerSideEncryptionRuleProperty#getServerSideEncryptionByDefault}
             * @param serverSideEncryptionByDefault Specifies the default server-side encryption to apply to new objects in the bucket.
             *                                      If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverSideEncryptionByDefault(software.amazon.awscdk.core.IResolvable serverSideEncryptionByDefault) {
                this.serverSideEncryptionByDefault = serverSideEncryptionByDefault;
                return this;
            }

            /**
             * Sets the value of {@link ServerSideEncryptionRuleProperty#getServerSideEncryptionByDefault}
             * @param serverSideEncryptionByDefault Specifies the default server-side encryption to apply to new objects in the bucket.
             *                                      If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverSideEncryptionByDefault(software.amazon.awscdk.services.s3.CfnBucket.ServerSideEncryptionByDefaultProperty serverSideEncryptionByDefault) {
                this.serverSideEncryptionByDefault = serverSideEncryptionByDefault;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerSideEncryptionRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServerSideEncryptionRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServerSideEncryptionRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerSideEncryptionRuleProperty {
            private final java.lang.Object bucketKeyEnabled;
            private final java.lang.Object serverSideEncryptionByDefault;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketKeyEnabled = software.amazon.jsii.Kernel.get(this, "bucketKeyEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serverSideEncryptionByDefault = software.amazon.jsii.Kernel.get(this, "serverSideEncryptionByDefault", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketKeyEnabled = builder.bucketKeyEnabled;
                this.serverSideEncryptionByDefault = builder.serverSideEncryptionByDefault;
            }

            @Override
            public final java.lang.Object getBucketKeyEnabled() {
                return this.bucketKeyEnabled;
            }

            @Override
            public final java.lang.Object getServerSideEncryptionByDefault() {
                return this.serverSideEncryptionByDefault;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBucketKeyEnabled() != null) {
                    data.set("bucketKeyEnabled", om.valueToTree(this.getBucketKeyEnabled()));
                }
                if (this.getServerSideEncryptionByDefault() != null) {
                    data.set("serverSideEncryptionByDefault", om.valueToTree(this.getServerSideEncryptionByDefault()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.ServerSideEncryptionRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServerSideEncryptionRuleProperty.Jsii$Proxy that = (ServerSideEncryptionRuleProperty.Jsii$Proxy) o;

                if (this.bucketKeyEnabled != null ? !this.bucketKeyEnabled.equals(that.bucketKeyEnabled) : that.bucketKeyEnabled != null) return false;
                return this.serverSideEncryptionByDefault != null ? this.serverSideEncryptionByDefault.equals(that.serverSideEncryptionByDefault) : that.serverSideEncryptionByDefault == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketKeyEnabled != null ? this.bucketKeyEnabled.hashCode() : 0;
                result = 31 * result + (this.serverSideEncryptionByDefault != null ? this.serverSideEncryptionByDefault.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A container that describes additional filters for identifying the source objects that you want to replicate.
     * <p>
     * You can choose to enable or disable the replication of these objects.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * SourceSelectionCriteriaProperty sourceSelectionCriteriaProperty = SourceSelectionCriteriaProperty.builder()
     *         .replicaModifications(ReplicaModificationsProperty.builder()
     *                 .status("status")
     *                 .build())
     *         .sseKmsEncryptedObjects(SseKmsEncryptedObjectsProperty.builder()
     *                 .status("status")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.SourceSelectionCriteriaProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceSelectionCriteriaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceSelectionCriteriaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A filter that you can specify for selection for modifications on replicas.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReplicaModifications() {
            return null;
        }

        /**
         * A container for filter information for the selection of Amazon S3 objects encrypted with AWS KMS.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSseKmsEncryptedObjects() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceSelectionCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceSelectionCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceSelectionCriteriaProperty> {
            java.lang.Object replicaModifications;
            java.lang.Object sseKmsEncryptedObjects;

            /**
             * Sets the value of {@link SourceSelectionCriteriaProperty#getReplicaModifications}
             * @param replicaModifications A filter that you can specify for selection for modifications on replicas.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replicaModifications(software.amazon.awscdk.core.IResolvable replicaModifications) {
                this.replicaModifications = replicaModifications;
                return this;
            }

            /**
             * Sets the value of {@link SourceSelectionCriteriaProperty#getReplicaModifications}
             * @param replicaModifications A filter that you can specify for selection for modifications on replicas.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replicaModifications(software.amazon.awscdk.services.s3.CfnBucket.ReplicaModificationsProperty replicaModifications) {
                this.replicaModifications = replicaModifications;
                return this;
            }

            /**
             * Sets the value of {@link SourceSelectionCriteriaProperty#getSseKmsEncryptedObjects}
             * @param sseKmsEncryptedObjects A container for filter information for the selection of Amazon S3 objects encrypted with AWS KMS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sseKmsEncryptedObjects(software.amazon.awscdk.core.IResolvable sseKmsEncryptedObjects) {
                this.sseKmsEncryptedObjects = sseKmsEncryptedObjects;
                return this;
            }

            /**
             * Sets the value of {@link SourceSelectionCriteriaProperty#getSseKmsEncryptedObjects}
             * @param sseKmsEncryptedObjects A container for filter information for the selection of Amazon S3 objects encrypted with AWS KMS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sseKmsEncryptedObjects(software.amazon.awscdk.services.s3.CfnBucket.SseKmsEncryptedObjectsProperty sseKmsEncryptedObjects) {
                this.sseKmsEncryptedObjects = sseKmsEncryptedObjects;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceSelectionCriteriaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceSelectionCriteriaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceSelectionCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceSelectionCriteriaProperty {
            private final java.lang.Object replicaModifications;
            private final java.lang.Object sseKmsEncryptedObjects;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.replicaModifications = software.amazon.jsii.Kernel.get(this, "replicaModifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sseKmsEncryptedObjects = software.amazon.jsii.Kernel.get(this, "sseKmsEncryptedObjects", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.replicaModifications = builder.replicaModifications;
                this.sseKmsEncryptedObjects = builder.sseKmsEncryptedObjects;
            }

            @Override
            public final java.lang.Object getReplicaModifications() {
                return this.replicaModifications;
            }

            @Override
            public final java.lang.Object getSseKmsEncryptedObjects() {
                return this.sseKmsEncryptedObjects;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getReplicaModifications() != null) {
                    data.set("replicaModifications", om.valueToTree(this.getReplicaModifications()));
                }
                if (this.getSseKmsEncryptedObjects() != null) {
                    data.set("sseKmsEncryptedObjects", om.valueToTree(this.getSseKmsEncryptedObjects()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.SourceSelectionCriteriaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceSelectionCriteriaProperty.Jsii$Proxy that = (SourceSelectionCriteriaProperty.Jsii$Proxy) o;

                if (this.replicaModifications != null ? !this.replicaModifications.equals(that.replicaModifications) : that.replicaModifications != null) return false;
                return this.sseKmsEncryptedObjects != null ? this.sseKmsEncryptedObjects.equals(that.sseKmsEncryptedObjects) : that.sseKmsEncryptedObjects == null;
            }

            @Override
            public final int hashCode() {
                int result = this.replicaModifications != null ? this.replicaModifications.hashCode() : 0;
                result = 31 * result + (this.sseKmsEncryptedObjects != null ? this.sseKmsEncryptedObjects.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A container for filter information for the selection of S3 objects encrypted with AWS KMS.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * SseKmsEncryptedObjectsProperty sseKmsEncryptedObjectsProperty = SseKmsEncryptedObjectsProperty.builder()
     *         .status("status")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.SseKmsEncryptedObjectsProperty")
    @software.amazon.jsii.Jsii.Proxy(SseKmsEncryptedObjectsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SseKmsEncryptedObjectsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether Amazon S3 replicates objects created with server-side encryption using an AWS KMS key stored in AWS Key Management Service.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatus();

        /**
         * @return a {@link Builder} of {@link SseKmsEncryptedObjectsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SseKmsEncryptedObjectsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SseKmsEncryptedObjectsProperty> {
            java.lang.String status;

            /**
             * Sets the value of {@link SseKmsEncryptedObjectsProperty#getStatus}
             * @param status Specifies whether Amazon S3 replicates objects created with server-side encryption using an AWS KMS key stored in AWS Key Management Service. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SseKmsEncryptedObjectsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SseKmsEncryptedObjectsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SseKmsEncryptedObjectsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SseKmsEncryptedObjectsProperty {
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.status = java.util.Objects.requireNonNull(builder.status, "status is required");
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("status", om.valueToTree(this.getStatus()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.SseKmsEncryptedObjectsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SseKmsEncryptedObjectsProperty.Jsii$Proxy that = (SseKmsEncryptedObjectsProperty.Jsii$Proxy) o;

                return this.status.equals(that.status);
            }

            @Override
            public final int hashCode() {
                int result = this.status.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies data related to access patterns to be collected and made available to analyze the tradeoffs between different storage classes for an Amazon S3 bucket.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * StorageClassAnalysisProperty storageClassAnalysisProperty = StorageClassAnalysisProperty.builder()
     *         .dataExport(DataExportProperty.builder()
     *                 .destination(DestinationProperty.builder()
     *                         .bucketArn("bucketArn")
     *                         .format("format")
     *                         // the properties below are optional
     *                         .bucketAccountId("bucketAccountId")
     *                         .prefix("prefix")
     *                         .build())
     *                 .outputSchemaVersion("outputSchemaVersion")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.StorageClassAnalysisProperty")
    @software.amazon.jsii.Jsii.Proxy(StorageClassAnalysisProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StorageClassAnalysisProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies how data related to the storage class analysis for an Amazon S3 bucket should be exported.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataExport() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StorageClassAnalysisProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StorageClassAnalysisProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StorageClassAnalysisProperty> {
            java.lang.Object dataExport;

            /**
             * Sets the value of {@link StorageClassAnalysisProperty#getDataExport}
             * @param dataExport Specifies how data related to the storage class analysis for an Amazon S3 bucket should be exported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataExport(software.amazon.awscdk.core.IResolvable dataExport) {
                this.dataExport = dataExport;
                return this;
            }

            /**
             * Sets the value of {@link StorageClassAnalysisProperty#getDataExport}
             * @param dataExport Specifies how data related to the storage class analysis for an Amazon S3 bucket should be exported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataExport(software.amazon.awscdk.services.s3.CfnBucket.DataExportProperty dataExport) {
                this.dataExport = dataExport;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StorageClassAnalysisProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StorageClassAnalysisProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StorageClassAnalysisProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StorageClassAnalysisProperty {
            private final java.lang.Object dataExport;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataExport = software.amazon.jsii.Kernel.get(this, "dataExport", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataExport = builder.dataExport;
            }

            @Override
            public final java.lang.Object getDataExport() {
                return this.dataExport;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDataExport() != null) {
                    data.set("dataExport", om.valueToTree(this.getDataExport()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.StorageClassAnalysisProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StorageClassAnalysisProperty.Jsii$Proxy that = (StorageClassAnalysisProperty.Jsii$Proxy) o;

                return this.dataExport != null ? this.dataExport.equals(that.dataExport) : that.dataExport == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataExport != null ? this.dataExport.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies tags to use to identify a subset of objects for an Amazon S3 bucket.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * TagFilterProperty tagFilterProperty = TagFilterProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.TagFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(TagFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TagFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The tag key.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The tag value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TagFilterProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link TagFilterProperty#getKey}
             * @param key The tag key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link TagFilterProperty#getValue}
             * @param value The tag value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TagFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagFilterProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.TagFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagFilterProperty.Jsii$Proxy that = (TagFilterProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The S3 Intelligent-Tiering storage class is designed to optimize storage costs by automatically moving data to the most cost-effective storage access tier, without additional operational overhead.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * TieringProperty tieringProperty = TieringProperty.builder()
     *         .accessTier("accessTier")
     *         .days(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.TieringProperty")
    @software.amazon.jsii.Jsii.Proxy(TieringProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TieringProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * S3 Intelligent-Tiering access tier.
         * <p>
         * See <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access">Storage class for automatically optimizing frequently and infrequently accessed objects</a> for a list of access tiers in the S3 Intelligent-Tiering storage class.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAccessTier();

        /**
         * The number of consecutive days of no access after which an object will be eligible to be transitioned to the corresponding tier.
         * <p>
         * The minimum number of days specified for Archive Access tier must be at least 90 days and Deep Archive Access tier must be at least 180 days. The maximum can be up to 2 years (730 days).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getDays();

        /**
         * @return a {@link Builder} of {@link TieringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TieringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TieringProperty> {
            java.lang.String accessTier;
            java.lang.Number days;

            /**
             * Sets the value of {@link TieringProperty#getAccessTier}
             * @param accessTier S3 Intelligent-Tiering access tier. This parameter is required.
             *                   See <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access">Storage class for automatically optimizing frequently and infrequently accessed objects</a> for a list of access tiers in the S3 Intelligent-Tiering storage class.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessTier(java.lang.String accessTier) {
                this.accessTier = accessTier;
                return this;
            }

            /**
             * Sets the value of {@link TieringProperty#getDays}
             * @param days The number of consecutive days of no access after which an object will be eligible to be transitioned to the corresponding tier. This parameter is required.
             *             The minimum number of days specified for Archive Access tier must be at least 90 days and Deep Archive Access tier must be at least 180 days. The maximum can be up to 2 years (730 days).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder days(java.lang.Number days) {
                this.days = days;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TieringProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TieringProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TieringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TieringProperty {
            private final java.lang.String accessTier;
            private final java.lang.Number days;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessTier = software.amazon.jsii.Kernel.get(this, "accessTier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.days = software.amazon.jsii.Kernel.get(this, "days", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessTier = java.util.Objects.requireNonNull(builder.accessTier, "accessTier is required");
                this.days = java.util.Objects.requireNonNull(builder.days, "days is required");
            }

            @Override
            public final java.lang.String getAccessTier() {
                return this.accessTier;
            }

            @Override
            public final java.lang.Number getDays() {
                return this.days;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("accessTier", om.valueToTree(this.getAccessTier()));
                data.set("days", om.valueToTree(this.getDays()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.TieringProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TieringProperty.Jsii$Proxy that = (TieringProperty.Jsii$Proxy) o;

                if (!accessTier.equals(that.accessTier)) return false;
                return this.days.equals(that.days);
            }

            @Override
            public final int hashCode() {
                int result = this.accessTier.hashCode();
                result = 31 * result + (this.days.hashCode());
                return result;
            }
        }
    }
    /**
     * A container for specifying the configuration for publication of messages to an Amazon Simple Notification Service (Amazon SNS) topic when Amazon S3 detects specified events.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * TopicConfigurationProperty topicConfigurationProperty = TopicConfigurationProperty.builder()
     *         .event("event")
     *         .topic("topic")
     *         // the properties below are optional
     *         .filter(NotificationFilterProperty.builder()
     *                 .s3Key(S3KeyFilterProperty.builder()
     *                         .rules(List.of(FilterRuleProperty.builder()
     *                                 .name("name")
     *                                 .value("value")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.TopicConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TopicConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TopicConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 bucket event about which to send notifications.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Supported Event Types</a> in the <em>Amazon S3 User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEvent();

        /**
         * The Amazon Resource Name (ARN) of the Amazon SNS topic to which Amazon S3 publishes a message when it detects events of the specified type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTopic();

        /**
         * The filtering rules that determine for which objects to send notifications.
         * <p>
         * For example, you can create a filter so that Amazon S3 sends notifications only when image files with a <code>.jpg</code> extension are added to the bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilter() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TopicConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TopicConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TopicConfigurationProperty> {
            java.lang.String event;
            java.lang.String topic;
            java.lang.Object filter;

            /**
             * Sets the value of {@link TopicConfigurationProperty#getEvent}
             * @param event The Amazon S3 bucket event about which to send notifications. This parameter is required.
             *              For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Supported Event Types</a> in the <em>Amazon S3 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder event(java.lang.String event) {
                this.event = event;
                return this;
            }

            /**
             * Sets the value of {@link TopicConfigurationProperty#getTopic}
             * @param topic The Amazon Resource Name (ARN) of the Amazon SNS topic to which Amazon S3 publishes a message when it detects events of the specified type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topic(java.lang.String topic) {
                this.topic = topic;
                return this;
            }

            /**
             * Sets the value of {@link TopicConfigurationProperty#getFilter}
             * @param filter The filtering rules that determine for which objects to send notifications.
             *               For example, you can create a filter so that Amazon S3 sends notifications only when image files with a <code>.jpg</code> extension are added to the bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.core.IResolvable filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Sets the value of {@link TopicConfigurationProperty#getFilter}
             * @param filter The filtering rules that determine for which objects to send notifications.
             *               For example, you can create a filter so that Amazon S3 sends notifications only when image files with a <code>.jpg</code> extension are added to the bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TopicConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TopicConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TopicConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicConfigurationProperty {
            private final java.lang.String event;
            private final java.lang.String topic;
            private final java.lang.Object filter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.event = software.amazon.jsii.Kernel.get(this, "event", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.topic = software.amazon.jsii.Kernel.get(this, "topic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.filter = software.amazon.jsii.Kernel.get(this, "filter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.event = java.util.Objects.requireNonNull(builder.event, "event is required");
                this.topic = java.util.Objects.requireNonNull(builder.topic, "topic is required");
                this.filter = builder.filter;
            }

            @Override
            public final java.lang.String getEvent() {
                return this.event;
            }

            @Override
            public final java.lang.String getTopic() {
                return this.topic;
            }

            @Override
            public final java.lang.Object getFilter() {
                return this.filter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("event", om.valueToTree(this.getEvent()));
                data.set("topic", om.valueToTree(this.getTopic()));
                if (this.getFilter() != null) {
                    data.set("filter", om.valueToTree(this.getFilter()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.TopicConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TopicConfigurationProperty.Jsii$Proxy that = (TopicConfigurationProperty.Jsii$Proxy) o;

                if (!event.equals(that.event)) return false;
                if (!topic.equals(that.topic)) return false;
                return this.filter != null ? this.filter.equals(that.filter) : that.filter == null;
            }

            @Override
            public final int hashCode() {
                int result = this.event.hashCode();
                result = 31 * result + (this.topic.hashCode());
                result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies when an object transitions to a specified storage class.
     * <p>
     * For more information about Amazon S3 lifecycle configuration rules, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/lifecycle-transition-general-considerations.html">Transitioning Objects Using Amazon S3 Lifecycle</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * TransitionProperty transitionProperty = TransitionProperty.builder()
     *         .storageClass("storageClass")
     *         // the properties below are optional
     *         .transitionDate(new Date())
     *         .transitionInDays(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.TransitionProperty")
    @software.amazon.jsii.Jsii.Proxy(TransitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TransitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The storage class to which you want the object to transition.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStorageClass();

        /**
         * Indicates when objects are transitioned to the specified storage class.
         * <p>
         * The date value must be in ISO 8601 format. The time is always midnight UTC.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTransitionDate() {
            return null;
        }

        /**
         * Indicates the number of days after creation when objects are transitioned to the specified storage class.
         * <p>
         * The value must be a positive integer.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTransitionInDays() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TransitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TransitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TransitionProperty> {
            java.lang.String storageClass;
            java.lang.Object transitionDate;
            java.lang.Number transitionInDays;

            /**
             * Sets the value of {@link TransitionProperty#getStorageClass}
             * @param storageClass The storage class to which you want the object to transition. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageClass(java.lang.String storageClass) {
                this.storageClass = storageClass;
                return this;
            }

            /**
             * Sets the value of {@link TransitionProperty#getTransitionDate}
             * @param transitionDate Indicates when objects are transitioned to the specified storage class.
             *                       The date value must be in ISO 8601 format. The time is always midnight UTC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitionDate(java.time.Instant transitionDate) {
                this.transitionDate = transitionDate;
                return this;
            }

            /**
             * Sets the value of {@link TransitionProperty#getTransitionDate}
             * @param transitionDate Indicates when objects are transitioned to the specified storage class.
             *                       The date value must be in ISO 8601 format. The time is always midnight UTC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitionDate(software.amazon.awscdk.core.IResolvable transitionDate) {
                this.transitionDate = transitionDate;
                return this;
            }

            /**
             * Sets the value of {@link TransitionProperty#getTransitionInDays}
             * @param transitionInDays Indicates the number of days after creation when objects are transitioned to the specified storage class.
             *                         The value must be a positive integer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitionInDays(java.lang.Number transitionInDays) {
                this.transitionInDays = transitionInDays;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TransitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TransitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TransitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransitionProperty {
            private final java.lang.String storageClass;
            private final java.lang.Object transitionDate;
            private final java.lang.Number transitionInDays;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.storageClass = software.amazon.jsii.Kernel.get(this, "storageClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.transitionDate = software.amazon.jsii.Kernel.get(this, "transitionDate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.transitionInDays = software.amazon.jsii.Kernel.get(this, "transitionInDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.storageClass = java.util.Objects.requireNonNull(builder.storageClass, "storageClass is required");
                this.transitionDate = builder.transitionDate;
                this.transitionInDays = builder.transitionInDays;
            }

            @Override
            public final java.lang.String getStorageClass() {
                return this.storageClass;
            }

            @Override
            public final java.lang.Object getTransitionDate() {
                return this.transitionDate;
            }

            @Override
            public final java.lang.Number getTransitionInDays() {
                return this.transitionInDays;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("storageClass", om.valueToTree(this.getStorageClass()));
                if (this.getTransitionDate() != null) {
                    data.set("transitionDate", om.valueToTree(this.getTransitionDate()));
                }
                if (this.getTransitionInDays() != null) {
                    data.set("transitionInDays", om.valueToTree(this.getTransitionInDays()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.TransitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TransitionProperty.Jsii$Proxy that = (TransitionProperty.Jsii$Proxy) o;

                if (!storageClass.equals(that.storageClass)) return false;
                if (this.transitionDate != null ? !this.transitionDate.equals(that.transitionDate) : that.transitionDate != null) return false;
                return this.transitionInDays != null ? this.transitionInDays.equals(that.transitionInDays) : that.transitionInDays == null;
            }

            @Override
            public final int hashCode() {
                int result = this.storageClass.hashCode();
                result = 31 * result + (this.transitionDate != null ? this.transitionDate.hashCode() : 0);
                result = 31 * result + (this.transitionInDays != null ? this.transitionInDays.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the versioning state of an Amazon S3 bucket.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTVersioningStatus.html">PUT Bucket versioning</a> in the <em>Amazon S3 API Reference</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * VersioningConfigurationProperty versioningConfigurationProperty = VersioningConfigurationProperty.builder()
     *         .status("status")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.VersioningConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(VersioningConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VersioningConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The versioning state of the bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatus();

        /**
         * @return a {@link Builder} of {@link VersioningConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VersioningConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VersioningConfigurationProperty> {
            java.lang.String status;

            /**
             * Sets the value of {@link VersioningConfigurationProperty#getStatus}
             * @param status The versioning state of the bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VersioningConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VersioningConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VersioningConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VersioningConfigurationProperty {
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.status = java.util.Objects.requireNonNull(builder.status, "status is required");
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("status", om.valueToTree(this.getStatus()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.VersioningConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VersioningConfigurationProperty.Jsii$Proxy that = (VersioningConfigurationProperty.Jsii$Proxy) o;

                return this.status.equals(that.status);
            }

            @Override
            public final int hashCode() {
                int result = this.status.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies website configuration parameters for an Amazon S3 bucket.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * WebsiteConfigurationProperty websiteConfigurationProperty = WebsiteConfigurationProperty.builder()
     *         .errorDocument("errorDocument")
     *         .indexDocument("indexDocument")
     *         .redirectAllRequestsTo(RedirectAllRequestsToProperty.builder()
     *                 .hostName("hostName")
     *                 // the properties below are optional
     *                 .protocol("protocol")
     *                 .build())
     *         .routingRules(List.of(RoutingRuleProperty.builder()
     *                 .redirectRule(RedirectRuleProperty.builder()
     *                         .hostName("hostName")
     *                         .httpRedirectCode("httpRedirectCode")
     *                         .protocol("protocol")
     *                         .replaceKeyPrefixWith("replaceKeyPrefixWith")
     *                         .replaceKeyWith("replaceKeyWith")
     *                         .build())
     *                 // the properties below are optional
     *                 .routingRuleCondition(RoutingRuleConditionProperty.builder()
     *                         .httpErrorCodeReturnedEquals("httpErrorCodeReturnedEquals")
     *                         .keyPrefixEquals("keyPrefixEquals")
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.WebsiteConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(WebsiteConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WebsiteConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the error document for the website.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getErrorDocument() {
            return null;
        }

        /**
         * The name of the index document for the website.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIndexDocument() {
            return null;
        }

        /**
         * The redirect behavior for every request to this bucket's website endpoint.
         * <p>
         * <blockquote>
         * <p>
         * If you specify this property, you can't specify any other property.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRedirectAllRequestsTo() {
            return null;
        }

        /**
         * Rules that define when a redirect is applied and the redirect behavior.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRoutingRules() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WebsiteConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WebsiteConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WebsiteConfigurationProperty> {
            java.lang.String errorDocument;
            java.lang.String indexDocument;
            java.lang.Object redirectAllRequestsTo;
            java.lang.Object routingRules;

            /**
             * Sets the value of {@link WebsiteConfigurationProperty#getErrorDocument}
             * @param errorDocument The name of the error document for the website.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorDocument(java.lang.String errorDocument) {
                this.errorDocument = errorDocument;
                return this;
            }

            /**
             * Sets the value of {@link WebsiteConfigurationProperty#getIndexDocument}
             * @param indexDocument The name of the index document for the website.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder indexDocument(java.lang.String indexDocument) {
                this.indexDocument = indexDocument;
                return this;
            }

            /**
             * Sets the value of {@link WebsiteConfigurationProperty#getRedirectAllRequestsTo}
             * @param redirectAllRequestsTo The redirect behavior for every request to this bucket's website endpoint.
             *                              <blockquote>
             *                              <p>
             *                              If you specify this property, you can't specify any other property.
             *                              <p>
             *                              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redirectAllRequestsTo(software.amazon.awscdk.core.IResolvable redirectAllRequestsTo) {
                this.redirectAllRequestsTo = redirectAllRequestsTo;
                return this;
            }

            /**
             * Sets the value of {@link WebsiteConfigurationProperty#getRedirectAllRequestsTo}
             * @param redirectAllRequestsTo The redirect behavior for every request to this bucket's website endpoint.
             *                              <blockquote>
             *                              <p>
             *                              If you specify this property, you can't specify any other property.
             *                              <p>
             *                              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redirectAllRequestsTo(software.amazon.awscdk.services.s3.CfnBucket.RedirectAllRequestsToProperty redirectAllRequestsTo) {
                this.redirectAllRequestsTo = redirectAllRequestsTo;
                return this;
            }

            /**
             * Sets the value of {@link WebsiteConfigurationProperty#getRoutingRules}
             * @param routingRules Rules that define when a redirect is applied and the redirect behavior.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder routingRules(software.amazon.awscdk.core.IResolvable routingRules) {
                this.routingRules = routingRules;
                return this;
            }

            /**
             * Sets the value of {@link WebsiteConfigurationProperty#getRoutingRules}
             * @param routingRules Rules that define when a redirect is applied and the redirect behavior.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder routingRules(java.util.List<? extends java.lang.Object> routingRules) {
                this.routingRules = routingRules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WebsiteConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WebsiteConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WebsiteConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebsiteConfigurationProperty {
            private final java.lang.String errorDocument;
            private final java.lang.String indexDocument;
            private final java.lang.Object redirectAllRequestsTo;
            private final java.lang.Object routingRules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.errorDocument = software.amazon.jsii.Kernel.get(this, "errorDocument", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.indexDocument = software.amazon.jsii.Kernel.get(this, "indexDocument", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.redirectAllRequestsTo = software.amazon.jsii.Kernel.get(this, "redirectAllRequestsTo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.routingRules = software.amazon.jsii.Kernel.get(this, "routingRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.errorDocument = builder.errorDocument;
                this.indexDocument = builder.indexDocument;
                this.redirectAllRequestsTo = builder.redirectAllRequestsTo;
                this.routingRules = builder.routingRules;
            }

            @Override
            public final java.lang.String getErrorDocument() {
                return this.errorDocument;
            }

            @Override
            public final java.lang.String getIndexDocument() {
                return this.indexDocument;
            }

            @Override
            public final java.lang.Object getRedirectAllRequestsTo() {
                return this.redirectAllRequestsTo;
            }

            @Override
            public final java.lang.Object getRoutingRules() {
                return this.routingRules;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getErrorDocument() != null) {
                    data.set("errorDocument", om.valueToTree(this.getErrorDocument()));
                }
                if (this.getIndexDocument() != null) {
                    data.set("indexDocument", om.valueToTree(this.getIndexDocument()));
                }
                if (this.getRedirectAllRequestsTo() != null) {
                    data.set("redirectAllRequestsTo", om.valueToTree(this.getRedirectAllRequestsTo()));
                }
                if (this.getRoutingRules() != null) {
                    data.set("routingRules", om.valueToTree(this.getRoutingRules()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.WebsiteConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WebsiteConfigurationProperty.Jsii$Proxy that = (WebsiteConfigurationProperty.Jsii$Proxy) o;

                if (this.errorDocument != null ? !this.errorDocument.equals(that.errorDocument) : that.errorDocument != null) return false;
                if (this.indexDocument != null ? !this.indexDocument.equals(that.indexDocument) : that.indexDocument != null) return false;
                if (this.redirectAllRequestsTo != null ? !this.redirectAllRequestsTo.equals(that.redirectAllRequestsTo) : that.redirectAllRequestsTo != null) return false;
                return this.routingRules != null ? this.routingRules.equals(that.routingRules) : that.routingRules == null;
            }

            @Override
            public final int hashCode() {
                int result = this.errorDocument != null ? this.errorDocument.hashCode() : 0;
                result = 31 * result + (this.indexDocument != null ? this.indexDocument.hashCode() : 0);
                result = 31 * result + (this.redirectAllRequestsTo != null ? this.redirectAllRequestsTo.hashCode() : 0);
                result = 31 * result + (this.routingRules != null ? this.routingRules.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.s3.CfnBucket}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.s3.CfnBucket> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.s3.CfnBucketProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Configures the transfer acceleration state for an Amazon S3 bucket.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html">Amazon S3 Transfer Acceleration</a> in the <em>Amazon S3 User Guide</em> .
         * <p>
         * @return {@code this}
         * @param accelerateConfiguration Configures the transfer acceleration state for an Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accelerateConfiguration(final software.amazon.awscdk.core.IResolvable accelerateConfiguration) {
            this.props().accelerateConfiguration(accelerateConfiguration);
            return this;
        }
        /**
         * Configures the transfer acceleration state for an Amazon S3 bucket.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html">Amazon S3 Transfer Acceleration</a> in the <em>Amazon S3 User Guide</em> .
         * <p>
         * @return {@code this}
         * @param accelerateConfiguration Configures the transfer acceleration state for an Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accelerateConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.AccelerateConfigurationProperty accelerateConfiguration) {
            this.props().accelerateConfiguration(accelerateConfiguration);
            return this;
        }

        /**
         * A canned access control list (ACL) that grants predefined permissions to the bucket.
         * <p>
         * For more information about canned ACLs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">Canned ACL</a> in the <em>Amazon S3 User Guide</em> .
         * <p>
         * Be aware that the syntax for this property differs from the information provided in the <em>Amazon S3 User Guide</em> . The AccessControl property is case-sensitive and must be one of the following values: Private, PublicRead, PublicReadWrite, AuthenticatedRead, LogDeliveryWrite, BucketOwnerRead, BucketOwnerFullControl, or AwsExecRead.
         * <p>
         * @return {@code this}
         * @param accessControl A canned access control list (ACL) that grants predefined permissions to the bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessControl(final java.lang.String accessControl) {
            this.props().accessControl(accessControl);
            return this;
        }

        /**
         * Specifies the configuration and any analyses for the analytics filter of an Amazon S3 bucket.
         * <p>
         * @return {@code this}
         * @param analyticsConfigurations Specifies the configuration and any analyses for the analytics filter of an Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analyticsConfigurations(final software.amazon.awscdk.core.IResolvable analyticsConfigurations) {
            this.props().analyticsConfigurations(analyticsConfigurations);
            return this;
        }
        /**
         * Specifies the configuration and any analyses for the analytics filter of an Amazon S3 bucket.
         * <p>
         * @return {@code this}
         * @param analyticsConfigurations Specifies the configuration and any analyses for the analytics filter of an Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analyticsConfigurations(final java.util.List<? extends java.lang.Object> analyticsConfigurations) {
            this.props().analyticsConfigurations(analyticsConfigurations);
            return this;
        }

        /**
         * Specifies default encryption for a bucket using server-side encryption with Amazon S3-managed keys (SSE-S3) or AWS KMS-managed keys (SSE-KMS) bucket.
         * <p>
         * For information about the Amazon S3 default encryption feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">Amazon S3 Default Encryption for S3 Buckets</a> in the <em>Amazon S3 User Guide</em> .
         * <p>
         * @return {@code this}
         * @param bucketEncryption Specifies default encryption for a bucket using server-side encryption with Amazon S3-managed keys (SSE-S3) or AWS KMS-managed keys (SSE-KMS) bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketEncryption(final software.amazon.awscdk.core.IResolvable bucketEncryption) {
            this.props().bucketEncryption(bucketEncryption);
            return this;
        }
        /**
         * Specifies default encryption for a bucket using server-side encryption with Amazon S3-managed keys (SSE-S3) or AWS KMS-managed keys (SSE-KMS) bucket.
         * <p>
         * For information about the Amazon S3 default encryption feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">Amazon S3 Default Encryption for S3 Buckets</a> in the <em>Amazon S3 User Guide</em> .
         * <p>
         * @return {@code this}
         * @param bucketEncryption Specifies default encryption for a bucket using server-side encryption with Amazon S3-managed keys (SSE-S3) or AWS KMS-managed keys (SSE-KMS) bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketEncryption(final software.amazon.awscdk.services.s3.CfnBucket.BucketEncryptionProperty bucketEncryption) {
            this.props().bucketEncryption(bucketEncryption);
            return this;
        }

        /**
         * A name for the bucket.
         * <p>
         * If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the bucket name. The bucket name must contain only lowercase letters, numbers, periods (.), and dashes (-) and must follow <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Amazon S3 bucket restrictions and limitations</a> . For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html#bucketnamingrules">Rules for naming Amazon S3 buckets</a> in the <em>Amazon S3 User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you need to replace the resource, specify a new name.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param bucketName A name for the bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketName(final java.lang.String bucketName) {
            this.props().bucketName(bucketName);
            return this;
        }

        /**
         * Describes the cross-origin access configuration for objects in an Amazon S3 bucket.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">Enabling Cross-Origin Resource Sharing</a> in the <em>Amazon S3 User Guide</em> .
         * <p>
         * @return {@code this}
         * @param corsConfiguration Describes the cross-origin access configuration for objects in an Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder corsConfiguration(final software.amazon.awscdk.core.IResolvable corsConfiguration) {
            this.props().corsConfiguration(corsConfiguration);
            return this;
        }
        /**
         * Describes the cross-origin access configuration for objects in an Amazon S3 bucket.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">Enabling Cross-Origin Resource Sharing</a> in the <em>Amazon S3 User Guide</em> .
         * <p>
         * @return {@code this}
         * @param corsConfiguration Describes the cross-origin access configuration for objects in an Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder corsConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.CorsConfigurationProperty corsConfiguration) {
            this.props().corsConfiguration(corsConfiguration);
            return this;
        }

        /**
         * Defines how Amazon S3 handles Intelligent-Tiering storage.
         * <p>
         * @return {@code this}
         * @param intelligentTieringConfigurations Defines how Amazon S3 handles Intelligent-Tiering storage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder intelligentTieringConfigurations(final software.amazon.awscdk.core.IResolvable intelligentTieringConfigurations) {
            this.props().intelligentTieringConfigurations(intelligentTieringConfigurations);
            return this;
        }
        /**
         * Defines how Amazon S3 handles Intelligent-Tiering storage.
         * <p>
         * @return {@code this}
         * @param intelligentTieringConfigurations Defines how Amazon S3 handles Intelligent-Tiering storage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder intelligentTieringConfigurations(final java.util.List<? extends java.lang.Object> intelligentTieringConfigurations) {
            this.props().intelligentTieringConfigurations(intelligentTieringConfigurations);
            return this;
        }

        /**
         * Specifies the inventory configuration for an Amazon S3 bucket.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketGETInventoryConfig.html">GET Bucket inventory</a> in the <em>Amazon S3 API Reference</em> .
         * <p>
         * @return {@code this}
         * @param inventoryConfigurations Specifies the inventory configuration for an Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inventoryConfigurations(final software.amazon.awscdk.core.IResolvable inventoryConfigurations) {
            this.props().inventoryConfigurations(inventoryConfigurations);
            return this;
        }
        /**
         * Specifies the inventory configuration for an Amazon S3 bucket.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketGETInventoryConfig.html">GET Bucket inventory</a> in the <em>Amazon S3 API Reference</em> .
         * <p>
         * @return {@code this}
         * @param inventoryConfigurations Specifies the inventory configuration for an Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inventoryConfigurations(final java.util.List<? extends java.lang.Object> inventoryConfigurations) {
            this.props().inventoryConfigurations(inventoryConfigurations);
            return this;
        }

        /**
         * Specifies the lifecycle configuration for objects in an Amazon S3 bucket.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html">Object Lifecycle Management</a> in the <em>Amazon S3 User Guide</em> .
         * <p>
         * @return {@code this}
         * @param lifecycleConfiguration Specifies the lifecycle configuration for objects in an Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleConfiguration(final software.amazon.awscdk.core.IResolvable lifecycleConfiguration) {
            this.props().lifecycleConfiguration(lifecycleConfiguration);
            return this;
        }
        /**
         * Specifies the lifecycle configuration for objects in an Amazon S3 bucket.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html">Object Lifecycle Management</a> in the <em>Amazon S3 User Guide</em> .
         * <p>
         * @return {@code this}
         * @param lifecycleConfiguration Specifies the lifecycle configuration for objects in an Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.LifecycleConfigurationProperty lifecycleConfiguration) {
            this.props().lifecycleConfiguration(lifecycleConfiguration);
            return this;
        }

        /**
         * Settings that define where logs are stored.
         * <p>
         * @return {@code this}
         * @param loggingConfiguration Settings that define where logs are stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfiguration(final software.amazon.awscdk.core.IResolvable loggingConfiguration) {
            this.props().loggingConfiguration(loggingConfiguration);
            return this;
        }
        /**
         * Settings that define where logs are stored.
         * <p>
         * @return {@code this}
         * @param loggingConfiguration Settings that define where logs are stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.LoggingConfigurationProperty loggingConfiguration) {
            this.props().loggingConfiguration(loggingConfiguration);
            return this;
        }

        /**
         * Specifies a metrics configuration for the CloudWatch request metrics (specified by the metrics configuration ID) from an Amazon S3 bucket.
         * <p>
         * If you're updating an existing metrics configuration, note that this is a full replacement of the existing metrics configuration. If you don't include the elements you want to keep, they are erased. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTMetricConfiguration.html">PutBucketMetricsConfiguration</a> .
         * <p>
         * @return {@code this}
         * @param metricsConfigurations Specifies a metrics configuration for the CloudWatch request metrics (specified by the metrics configuration ID) from an Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricsConfigurations(final software.amazon.awscdk.core.IResolvable metricsConfigurations) {
            this.props().metricsConfigurations(metricsConfigurations);
            return this;
        }
        /**
         * Specifies a metrics configuration for the CloudWatch request metrics (specified by the metrics configuration ID) from an Amazon S3 bucket.
         * <p>
         * If you're updating an existing metrics configuration, note that this is a full replacement of the existing metrics configuration. If you don't include the elements you want to keep, they are erased. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTMetricConfiguration.html">PutBucketMetricsConfiguration</a> .
         * <p>
         * @return {@code this}
         * @param metricsConfigurations Specifies a metrics configuration for the CloudWatch request metrics (specified by the metrics configuration ID) from an Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricsConfigurations(final java.util.List<? extends java.lang.Object> metricsConfigurations) {
            this.props().metricsConfigurations(metricsConfigurations);
            return this;
        }

        /**
         * Configuration that defines how Amazon S3 handles bucket notifications.
         * <p>
         * @return {@code this}
         * @param notificationConfiguration Configuration that defines how Amazon S3 handles bucket notifications. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationConfiguration(final software.amazon.awscdk.core.IResolvable notificationConfiguration) {
            this.props().notificationConfiguration(notificationConfiguration);
            return this;
        }
        /**
         * Configuration that defines how Amazon S3 handles bucket notifications.
         * <p>
         * @return {@code this}
         * @param notificationConfiguration Configuration that defines how Amazon S3 handles bucket notifications. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.NotificationConfigurationProperty notificationConfiguration) {
            this.props().notificationConfiguration(notificationConfiguration);
            return this;
        }

        /**
         * Places an Object Lock configuration on the specified bucket.
         * <p>
         * The rule specified in the Object Lock configuration will be applied by default to every new object placed in the specified bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Locking Objects</a> .
         * <p>
         * <blockquote>
         * <p>
         * <ul>
         * <li>The <code>DefaultRetention</code> settings require both a mode and a period.</li>
         * <li>The <code>DefaultRetention</code> period can be either <code>Days</code> or <code>Years</code> but you must select one. You cannot specify <code>Days</code> and <code>Years</code> at the same time.</li>
         * <li>You can only enable Object Lock for new buckets. If you want to turn on Object Lock for an existing bucket, contact AWS Support.</li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param objectLockConfiguration Places an Object Lock configuration on the specified bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectLockConfiguration(final software.amazon.awscdk.core.IResolvable objectLockConfiguration) {
            this.props().objectLockConfiguration(objectLockConfiguration);
            return this;
        }
        /**
         * Places an Object Lock configuration on the specified bucket.
         * <p>
         * The rule specified in the Object Lock configuration will be applied by default to every new object placed in the specified bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Locking Objects</a> .
         * <p>
         * <blockquote>
         * <p>
         * <ul>
         * <li>The <code>DefaultRetention</code> settings require both a mode and a period.</li>
         * <li>The <code>DefaultRetention</code> period can be either <code>Days</code> or <code>Years</code> but you must select one. You cannot specify <code>Days</code> and <code>Years</code> at the same time.</li>
         * <li>You can only enable Object Lock for new buckets. If you want to turn on Object Lock for an existing bucket, contact AWS Support.</li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param objectLockConfiguration Places an Object Lock configuration on the specified bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectLockConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.ObjectLockConfigurationProperty objectLockConfiguration) {
            this.props().objectLockConfiguration(objectLockConfiguration);
            return this;
        }

        /**
         * Indicates whether this bucket has an Object Lock configuration enabled.
         * <p>
         * Enable <code>ObjectLockEnabled</code> when you apply <code>ObjectLockConfiguration</code> to a bucket.
         * <p>
         * @return {@code this}
         * @param objectLockEnabled Indicates whether this bucket has an Object Lock configuration enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectLockEnabled(final java.lang.Boolean objectLockEnabled) {
            this.props().objectLockEnabled(objectLockEnabled);
            return this;
        }
        /**
         * Indicates whether this bucket has an Object Lock configuration enabled.
         * <p>
         * Enable <code>ObjectLockEnabled</code> when you apply <code>ObjectLockConfiguration</code> to a bucket.
         * <p>
         * @return {@code this}
         * @param objectLockEnabled Indicates whether this bucket has an Object Lock configuration enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectLockEnabled(final software.amazon.awscdk.core.IResolvable objectLockEnabled) {
            this.props().objectLockEnabled(objectLockEnabled);
            return this;
        }

        /**
         * Configuration that defines how Amazon S3 handles Object Ownership rules.
         * <p>
         * @return {@code this}
         * @param ownershipControls Configuration that defines how Amazon S3 handles Object Ownership rules. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownershipControls(final software.amazon.awscdk.core.IResolvable ownershipControls) {
            this.props().ownershipControls(ownershipControls);
            return this;
        }
        /**
         * Configuration that defines how Amazon S3 handles Object Ownership rules.
         * <p>
         * @return {@code this}
         * @param ownershipControls Configuration that defines how Amazon S3 handles Object Ownership rules. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownershipControls(final software.amazon.awscdk.services.s3.CfnBucket.OwnershipControlsProperty ownershipControls) {
            this.props().ownershipControls(ownershipControls);
            return this;
        }

        /**
         * Configuration that defines how Amazon S3 handles public access.
         * <p>
         * @return {@code this}
         * @param publicAccessBlockConfiguration Configuration that defines how Amazon S3 handles public access. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicAccessBlockConfiguration(final software.amazon.awscdk.core.IResolvable publicAccessBlockConfiguration) {
            this.props().publicAccessBlockConfiguration(publicAccessBlockConfiguration);
            return this;
        }
        /**
         * Configuration that defines how Amazon S3 handles public access.
         * <p>
         * @return {@code this}
         * @param publicAccessBlockConfiguration Configuration that defines how Amazon S3 handles public access. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicAccessBlockConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.PublicAccessBlockConfigurationProperty publicAccessBlockConfiguration) {
            this.props().publicAccessBlockConfiguration(publicAccessBlockConfiguration);
            return this;
        }

        /**
         * Configuration for replicating objects in an S3 bucket.
         * <p>
         * To enable replication, you must also enable versioning by using the <code>VersioningConfiguration</code> property.
         * <p>
         * Amazon S3 can store replicated objects in a single destination bucket or multiple destination buckets. The destination bucket or buckets must already exist.
         * <p>
         * @return {@code this}
         * @param replicationConfiguration Configuration for replicating objects in an S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationConfiguration(final software.amazon.awscdk.core.IResolvable replicationConfiguration) {
            this.props().replicationConfiguration(replicationConfiguration);
            return this;
        }
        /**
         * Configuration for replicating objects in an S3 bucket.
         * <p>
         * To enable replication, you must also enable versioning by using the <code>VersioningConfiguration</code> property.
         * <p>
         * Amazon S3 can store replicated objects in a single destination bucket or multiple destination buckets. The destination bucket or buckets must already exist.
         * <p>
         * @return {@code this}
         * @param replicationConfiguration Configuration for replicating objects in an S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.ReplicationConfigurationProperty replicationConfiguration) {
            this.props().replicationConfiguration(replicationConfiguration);
            return this;
        }

        /**
         * An arbitrary set of tags (key-value pairs) for this S3 bucket.
         * <p>
         * @return {@code this}
         * @param tags An arbitrary set of tags (key-value pairs) for this S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * Enables multiple versions of all objects in this bucket.
         * <p>
         * You might enable versioning to prevent objects from being deleted or overwritten by mistake or to archive objects so that you can retrieve previous versions of them.
         * <p>
         * @return {@code this}
         * @param versioningConfiguration Enables multiple versions of all objects in this bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versioningConfiguration(final software.amazon.awscdk.core.IResolvable versioningConfiguration) {
            this.props().versioningConfiguration(versioningConfiguration);
            return this;
        }
        /**
         * Enables multiple versions of all objects in this bucket.
         * <p>
         * You might enable versioning to prevent objects from being deleted or overwritten by mistake or to archive objects so that you can retrieve previous versions of them.
         * <p>
         * @return {@code this}
         * @param versioningConfiguration Enables multiple versions of all objects in this bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versioningConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.VersioningConfigurationProperty versioningConfiguration) {
            this.props().versioningConfiguration(versioningConfiguration);
            return this;
        }

        /**
         * Information used to configure the bucket as a static website.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">Hosting Websites on Amazon S3</a> .
         * <p>
         * @return {@code this}
         * @param websiteConfiguration Information used to configure the bucket as a static website. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder websiteConfiguration(final software.amazon.awscdk.core.IResolvable websiteConfiguration) {
            this.props().websiteConfiguration(websiteConfiguration);
            return this;
        }
        /**
         * Information used to configure the bucket as a static website.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">Hosting Websites on Amazon S3</a> .
         * <p>
         * @return {@code this}
         * @param websiteConfiguration Information used to configure the bucket as a static website. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder websiteConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.WebsiteConfigurationProperty websiteConfiguration) {
            this.props().websiteConfiguration(websiteConfiguration);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.s3.CfnBucket}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.s3.CfnBucket build() {
            return new software.amazon.awscdk.services.s3.CfnBucket(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.s3.CfnBucketProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.s3.CfnBucketProps.Builder();
            }
            return this.props;
        }
    }
}
