package software.amazon.awscdk.services.s3;

/**
 * Properties for defining a `CfnMultiRegionAccessPointPolicy`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3.*;
 * Object policy;
 * CfnMultiRegionAccessPointPolicyProps cfnMultiRegionAccessPointPolicyProps = CfnMultiRegionAccessPointPolicyProps.builder()
 *         .mrapName("mrapName")
 *         .policy(policy)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-02T14:17:18.627Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnMultiRegionAccessPointPolicyProps")
@software.amazon.jsii.Jsii.Proxy(CfnMultiRegionAccessPointPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMultiRegionAccessPointPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the Multi-Region Access Point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMrapName();

    /**
     * The access policy associated with the Multi-Region Access Point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getPolicy();

    /**
     * @return a {@link Builder} of {@link CfnMultiRegionAccessPointPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMultiRegionAccessPointPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMultiRegionAccessPointPolicyProps> {
        java.lang.String mrapName;
        java.lang.Object policy;

        /**
         * Sets the value of {@link CfnMultiRegionAccessPointPolicyProps#getMrapName}
         * @param mrapName The name of the Multi-Region Access Point. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mrapName(java.lang.String mrapName) {
            this.mrapName = mrapName;
            return this;
        }

        /**
         * Sets the value of {@link CfnMultiRegionAccessPointPolicyProps#getPolicy}
         * @param policy The access policy associated with the Multi-Region Access Point. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(java.lang.Object policy) {
            this.policy = policy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMultiRegionAccessPointPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMultiRegionAccessPointPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMultiRegionAccessPointPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMultiRegionAccessPointPolicyProps {
        private final java.lang.String mrapName;
        private final java.lang.Object policy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.mrapName = software.amazon.jsii.Kernel.get(this, "mrapName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.policy = software.amazon.jsii.Kernel.get(this, "policy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.mrapName = java.util.Objects.requireNonNull(builder.mrapName, "mrapName is required");
            this.policy = java.util.Objects.requireNonNull(builder.policy, "policy is required");
        }

        @Override
        public final java.lang.String getMrapName() {
            return this.mrapName;
        }

        @Override
        public final java.lang.Object getPolicy() {
            return this.policy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("mrapName", om.valueToTree(this.getMrapName()));
            data.set("policy", om.valueToTree(this.getPolicy()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnMultiRegionAccessPointPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMultiRegionAccessPointPolicyProps.Jsii$Proxy that = (CfnMultiRegionAccessPointPolicyProps.Jsii$Proxy) o;

            if (!mrapName.equals(that.mrapName)) return false;
            return this.policy.equals(that.policy);
        }

        @Override
        public final int hashCode() {
            int result = this.mrapName.hashCode();
            result = 31 * result + (this.policy.hashCode());
            return result;
        }
    }
}
