package software.amazon.awscdk.services.s3;

/**
 * A CloudFormation `AWS::S3::StorageLens`.
 * <p>
 * The AWS::S3::StorageLens resource creates an Amazon S3 Storage Lens configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3.*;
 * Object sses3;
 * CfnStorageLens cfnStorageLens = CfnStorageLens.Builder.create(this, "MyCfnStorageLens")
 *         .storageLensConfiguration(StorageLensConfigurationProperty.builder()
 *                 .accountLevel(AccountLevelProperty.builder()
 *                         .bucketLevel(BucketLevelProperty.builder()
 *                                 .activityMetrics(ActivityMetricsProperty.builder()
 *                                         .isEnabled(false)
 *                                         .build())
 *                                 .advancedCostOptimizationMetrics(AdvancedCostOptimizationMetricsProperty.builder()
 *                                         .isEnabled(false)
 *                                         .build())
 *                                 .advancedDataProtectionMetrics(AdvancedDataProtectionMetricsProperty.builder()
 *                                         .isEnabled(false)
 *                                         .build())
 *                                 .detailedStatusCodesMetrics(DetailedStatusCodesMetricsProperty.builder()
 *                                         .isEnabled(false)
 *                                         .build())
 *                                 .prefixLevel(PrefixLevelProperty.builder()
 *                                         .storageMetrics(PrefixLevelStorageMetricsProperty.builder()
 *                                                 .isEnabled(false)
 *                                                 .selectionCriteria(SelectionCriteriaProperty.builder()
 *                                                         .delimiter("delimiter")
 *                                                         .maxDepth(123)
 *                                                         .minStorageBytesPercentage(123)
 *                                                         .build())
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         // the properties below are optional
 *                         .activityMetrics(ActivityMetricsProperty.builder()
 *                                 .isEnabled(false)
 *                                 .build())
 *                         .advancedCostOptimizationMetrics(AdvancedCostOptimizationMetricsProperty.builder()
 *                                 .isEnabled(false)
 *                                 .build())
 *                         .advancedDataProtectionMetrics(AdvancedDataProtectionMetricsProperty.builder()
 *                                 .isEnabled(false)
 *                                 .build())
 *                         .detailedStatusCodesMetrics(DetailedStatusCodesMetricsProperty.builder()
 *                                 .isEnabled(false)
 *                                 .build())
 *                         .build())
 *                 .id("id")
 *                 .isEnabled(false)
 *                 // the properties below are optional
 *                 .awsOrg(AwsOrgProperty.builder()
 *                         .arn("arn")
 *                         .build())
 *                 .dataExport(DataExportProperty.builder()
 *                         .cloudWatchMetrics(CloudWatchMetricsProperty.builder()
 *                                 .isEnabled(false)
 *                                 .build())
 *                         .s3BucketDestination(S3BucketDestinationProperty.builder()
 *                                 .accountId("accountId")
 *                                 .arn("arn")
 *                                 .format("format")
 *                                 .outputSchemaVersion("outputSchemaVersion")
 *                                 // the properties below are optional
 *                                 .encryption(EncryptionProperty.builder()
 *                                         .ssekms(SSEKMSProperty.builder()
 *                                                 .keyId("keyId")
 *                                                 .build())
 *                                         .sses3(sses3)
 *                                         .build())
 *                                 .prefix("prefix")
 *                                 .build())
 *                         .build())
 *                 .exclude(BucketsAndRegionsProperty.builder()
 *                         .buckets(List.of("buckets"))
 *                         .regions(List.of("regions"))
 *                         .build())
 *                 .include(BucketsAndRegionsProperty.builder()
 *                         .buckets(List.of("buckets"))
 *                         .regions(List.of("regions"))
 *                         .build())
 *                 .storageLensArn("storageLensArn")
 *                 .build())
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-02T14:17:18.630Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnStorageLens")
public class CfnStorageLens extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnStorageLens(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStorageLens(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.s3.CfnStorageLens.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::S3::StorageLens`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnStorageLens(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.CfnStorageLensProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * This property contains the details of the ARN of the S3 Storage Lens configuration.
     * <p>
     * This property is read-only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStorageLensConfigurationStorageLensArn() {
        return software.amazon.jsii.Kernel.get(this, "attrStorageLensConfigurationStorageLensArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A set of tags (key–value pairs) to associate with the Storage Lens configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * This resource contains the details Amazon S3 Storage Lens configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getStorageLensConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "storageLensConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * This resource contains the details Amazon S3 Storage Lens configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageLensConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "storageLensConfiguration", java.util.Objects.requireNonNull(value, "storageLensConfiguration is required"));
    }

    /**
     * This resource contains the details Amazon S3 Storage Lens configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageLensConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.CfnStorageLens.StorageLensConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "storageLensConfiguration", java.util.Objects.requireNonNull(value, "storageLensConfiguration is required"));
    }
    /**
     * This resource contains the details of the account-level metrics for Amazon S3 Storage Lens.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * AccountLevelProperty accountLevelProperty = AccountLevelProperty.builder()
     *         .bucketLevel(BucketLevelProperty.builder()
     *                 .activityMetrics(ActivityMetricsProperty.builder()
     *                         .isEnabled(false)
     *                         .build())
     *                 .advancedCostOptimizationMetrics(AdvancedCostOptimizationMetricsProperty.builder()
     *                         .isEnabled(false)
     *                         .build())
     *                 .advancedDataProtectionMetrics(AdvancedDataProtectionMetricsProperty.builder()
     *                         .isEnabled(false)
     *                         .build())
     *                 .detailedStatusCodesMetrics(DetailedStatusCodesMetricsProperty.builder()
     *                         .isEnabled(false)
     *                         .build())
     *                 .prefixLevel(PrefixLevelProperty.builder()
     *                         .storageMetrics(PrefixLevelStorageMetricsProperty.builder()
     *                                 .isEnabled(false)
     *                                 .selectionCriteria(SelectionCriteriaProperty.builder()
     *                                         .delimiter("delimiter")
     *                                         .maxDepth(123)
     *                                         .minStorageBytesPercentage(123)
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .activityMetrics(ActivityMetricsProperty.builder()
     *                 .isEnabled(false)
     *                 .build())
     *         .advancedCostOptimizationMetrics(AdvancedCostOptimizationMetricsProperty.builder()
     *                 .isEnabled(false)
     *                 .build())
     *         .advancedDataProtectionMetrics(AdvancedDataProtectionMetricsProperty.builder()
     *                 .isEnabled(false)
     *                 .build())
     *         .detailedStatusCodesMetrics(DetailedStatusCodesMetricsProperty.builder()
     *                 .isEnabled(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnStorageLens.AccountLevelProperty")
    @software.amazon.jsii.Jsii.Proxy(AccountLevelProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccountLevelProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This property contains the details of the account-level bucket-level configurations for Amazon S3 Storage Lens.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getBucketLevel();

        /**
         * This property contains the details of account-level activity metrics for S3 Storage Lens.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getActivityMetrics() {
            return null;
        }

        /**
         * This property contains the details of account-level advanced cost optimization metrics for S3 Storage Lens.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAdvancedCostOptimizationMetrics() {
            return null;
        }

        /**
         * This property contains the details of account-level advanced data protection metrics for S3 Storage Lens.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAdvancedDataProtectionMetrics() {
            return null;
        }

        /**
         * This property contains the details of account-level detailed status code metrics for S3 Storage Lens.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDetailedStatusCodesMetrics() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AccountLevelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccountLevelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccountLevelProperty> {
            java.lang.Object bucketLevel;
            java.lang.Object activityMetrics;
            java.lang.Object advancedCostOptimizationMetrics;
            java.lang.Object advancedDataProtectionMetrics;
            java.lang.Object detailedStatusCodesMetrics;

            /**
             * Sets the value of {@link AccountLevelProperty#getBucketLevel}
             * @param bucketLevel This property contains the details of the account-level bucket-level configurations for Amazon S3 Storage Lens. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketLevel(software.amazon.awscdk.core.IResolvable bucketLevel) {
                this.bucketLevel = bucketLevel;
                return this;
            }

            /**
             * Sets the value of {@link AccountLevelProperty#getBucketLevel}
             * @param bucketLevel This property contains the details of the account-level bucket-level configurations for Amazon S3 Storage Lens. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketLevel(software.amazon.awscdk.services.s3.CfnStorageLens.BucketLevelProperty bucketLevel) {
                this.bucketLevel = bucketLevel;
                return this;
            }

            /**
             * Sets the value of {@link AccountLevelProperty#getActivityMetrics}
             * @param activityMetrics This property contains the details of account-level activity metrics for S3 Storage Lens.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder activityMetrics(software.amazon.awscdk.core.IResolvable activityMetrics) {
                this.activityMetrics = activityMetrics;
                return this;
            }

            /**
             * Sets the value of {@link AccountLevelProperty#getActivityMetrics}
             * @param activityMetrics This property contains the details of account-level activity metrics for S3 Storage Lens.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder activityMetrics(software.amazon.awscdk.services.s3.CfnStorageLens.ActivityMetricsProperty activityMetrics) {
                this.activityMetrics = activityMetrics;
                return this;
            }

            /**
             * Sets the value of {@link AccountLevelProperty#getAdvancedCostOptimizationMetrics}
             * @param advancedCostOptimizationMetrics This property contains the details of account-level advanced cost optimization metrics for S3 Storage Lens.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder advancedCostOptimizationMetrics(software.amazon.awscdk.core.IResolvable advancedCostOptimizationMetrics) {
                this.advancedCostOptimizationMetrics = advancedCostOptimizationMetrics;
                return this;
            }

            /**
             * Sets the value of {@link AccountLevelProperty#getAdvancedCostOptimizationMetrics}
             * @param advancedCostOptimizationMetrics This property contains the details of account-level advanced cost optimization metrics for S3 Storage Lens.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder advancedCostOptimizationMetrics(software.amazon.awscdk.services.s3.CfnStorageLens.AdvancedCostOptimizationMetricsProperty advancedCostOptimizationMetrics) {
                this.advancedCostOptimizationMetrics = advancedCostOptimizationMetrics;
                return this;
            }

            /**
             * Sets the value of {@link AccountLevelProperty#getAdvancedDataProtectionMetrics}
             * @param advancedDataProtectionMetrics This property contains the details of account-level advanced data protection metrics for S3 Storage Lens.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder advancedDataProtectionMetrics(software.amazon.awscdk.core.IResolvable advancedDataProtectionMetrics) {
                this.advancedDataProtectionMetrics = advancedDataProtectionMetrics;
                return this;
            }

            /**
             * Sets the value of {@link AccountLevelProperty#getAdvancedDataProtectionMetrics}
             * @param advancedDataProtectionMetrics This property contains the details of account-level advanced data protection metrics for S3 Storage Lens.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder advancedDataProtectionMetrics(software.amazon.awscdk.services.s3.CfnStorageLens.AdvancedDataProtectionMetricsProperty advancedDataProtectionMetrics) {
                this.advancedDataProtectionMetrics = advancedDataProtectionMetrics;
                return this;
            }

            /**
             * Sets the value of {@link AccountLevelProperty#getDetailedStatusCodesMetrics}
             * @param detailedStatusCodesMetrics This property contains the details of account-level detailed status code metrics for S3 Storage Lens.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder detailedStatusCodesMetrics(software.amazon.awscdk.core.IResolvable detailedStatusCodesMetrics) {
                this.detailedStatusCodesMetrics = detailedStatusCodesMetrics;
                return this;
            }

            /**
             * Sets the value of {@link AccountLevelProperty#getDetailedStatusCodesMetrics}
             * @param detailedStatusCodesMetrics This property contains the details of account-level detailed status code metrics for S3 Storage Lens.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder detailedStatusCodesMetrics(software.amazon.awscdk.services.s3.CfnStorageLens.DetailedStatusCodesMetricsProperty detailedStatusCodesMetrics) {
                this.detailedStatusCodesMetrics = detailedStatusCodesMetrics;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccountLevelProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccountLevelProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AccountLevelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccountLevelProperty {
            private final java.lang.Object bucketLevel;
            private final java.lang.Object activityMetrics;
            private final java.lang.Object advancedCostOptimizationMetrics;
            private final java.lang.Object advancedDataProtectionMetrics;
            private final java.lang.Object detailedStatusCodesMetrics;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketLevel = software.amazon.jsii.Kernel.get(this, "bucketLevel", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.activityMetrics = software.amazon.jsii.Kernel.get(this, "activityMetrics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.advancedCostOptimizationMetrics = software.amazon.jsii.Kernel.get(this, "advancedCostOptimizationMetrics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.advancedDataProtectionMetrics = software.amazon.jsii.Kernel.get(this, "advancedDataProtectionMetrics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.detailedStatusCodesMetrics = software.amazon.jsii.Kernel.get(this, "detailedStatusCodesMetrics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketLevel = java.util.Objects.requireNonNull(builder.bucketLevel, "bucketLevel is required");
                this.activityMetrics = builder.activityMetrics;
                this.advancedCostOptimizationMetrics = builder.advancedCostOptimizationMetrics;
                this.advancedDataProtectionMetrics = builder.advancedDataProtectionMetrics;
                this.detailedStatusCodesMetrics = builder.detailedStatusCodesMetrics;
            }

            @Override
            public final java.lang.Object getBucketLevel() {
                return this.bucketLevel;
            }

            @Override
            public final java.lang.Object getActivityMetrics() {
                return this.activityMetrics;
            }

            @Override
            public final java.lang.Object getAdvancedCostOptimizationMetrics() {
                return this.advancedCostOptimizationMetrics;
            }

            @Override
            public final java.lang.Object getAdvancedDataProtectionMetrics() {
                return this.advancedDataProtectionMetrics;
            }

            @Override
            public final java.lang.Object getDetailedStatusCodesMetrics() {
                return this.detailedStatusCodesMetrics;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketLevel", om.valueToTree(this.getBucketLevel()));
                if (this.getActivityMetrics() != null) {
                    data.set("activityMetrics", om.valueToTree(this.getActivityMetrics()));
                }
                if (this.getAdvancedCostOptimizationMetrics() != null) {
                    data.set("advancedCostOptimizationMetrics", om.valueToTree(this.getAdvancedCostOptimizationMetrics()));
                }
                if (this.getAdvancedDataProtectionMetrics() != null) {
                    data.set("advancedDataProtectionMetrics", om.valueToTree(this.getAdvancedDataProtectionMetrics()));
                }
                if (this.getDetailedStatusCodesMetrics() != null) {
                    data.set("detailedStatusCodesMetrics", om.valueToTree(this.getDetailedStatusCodesMetrics()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnStorageLens.AccountLevelProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccountLevelProperty.Jsii$Proxy that = (AccountLevelProperty.Jsii$Proxy) o;

                if (!bucketLevel.equals(that.bucketLevel)) return false;
                if (this.activityMetrics != null ? !this.activityMetrics.equals(that.activityMetrics) : that.activityMetrics != null) return false;
                if (this.advancedCostOptimizationMetrics != null ? !this.advancedCostOptimizationMetrics.equals(that.advancedCostOptimizationMetrics) : that.advancedCostOptimizationMetrics != null) return false;
                if (this.advancedDataProtectionMetrics != null ? !this.advancedDataProtectionMetrics.equals(that.advancedDataProtectionMetrics) : that.advancedDataProtectionMetrics != null) return false;
                return this.detailedStatusCodesMetrics != null ? this.detailedStatusCodesMetrics.equals(that.detailedStatusCodesMetrics) : that.detailedStatusCodesMetrics == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketLevel.hashCode();
                result = 31 * result + (this.activityMetrics != null ? this.activityMetrics.hashCode() : 0);
                result = 31 * result + (this.advancedCostOptimizationMetrics != null ? this.advancedCostOptimizationMetrics.hashCode() : 0);
                result = 31 * result + (this.advancedDataProtectionMetrics != null ? this.advancedDataProtectionMetrics.hashCode() : 0);
                result = 31 * result + (this.detailedStatusCodesMetrics != null ? this.detailedStatusCodesMetrics.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This resource enables Amazon S3 Storage Lens activity metrics.
     * <p>
     * Activity metrics show details about how your storage is requested, such as requests (for example, All requests, Get requests, Put requests), bytes uploaded or downloaded, and errors.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html">Assessing your storage activity and usage with S3 Storage Lens</a> in the <em>Amazon S3 User Guide</em> . For a complete list of metrics, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html">S3 Storage Lens metrics glossary</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * ActivityMetricsProperty activityMetricsProperty = ActivityMetricsProperty.builder()
     *         .isEnabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnStorageLens.ActivityMetricsProperty")
    @software.amazon.jsii.Jsii.Proxy(ActivityMetricsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActivityMetricsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A property that indicates whether the activity metrics is enabled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ActivityMetricsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActivityMetricsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActivityMetricsProperty> {
            java.lang.Object isEnabled;

            /**
             * Sets the value of {@link ActivityMetricsProperty#getIsEnabled}
             * @param isEnabled A property that indicates whether the activity metrics is enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isEnabled(java.lang.Boolean isEnabled) {
                this.isEnabled = isEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ActivityMetricsProperty#getIsEnabled}
             * @param isEnabled A property that indicates whether the activity metrics is enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isEnabled(software.amazon.awscdk.core.IResolvable isEnabled) {
                this.isEnabled = isEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActivityMetricsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActivityMetricsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ActivityMetricsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActivityMetricsProperty {
            private final java.lang.Object isEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.isEnabled = software.amazon.jsii.Kernel.get(this, "isEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.isEnabled = builder.isEnabled;
            }

            @Override
            public final java.lang.Object getIsEnabled() {
                return this.isEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIsEnabled() != null) {
                    data.set("isEnabled", om.valueToTree(this.getIsEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnStorageLens.ActivityMetricsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActivityMetricsProperty.Jsii$Proxy that = (ActivityMetricsProperty.Jsii$Proxy) o;

                return this.isEnabled != null ? this.isEnabled.equals(that.isEnabled) : that.isEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.isEnabled != null ? this.isEnabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * This resource enables Amazon S3 Storage Lens advanced cost optimization metrics.
     * <p>
     * Advanced cost optimization metrics provide insights that you can use to manage and optimize your storage costs, for example, lifecycle rule counts for transitions, expirations, and incomplete multipart uploads.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html">Assessing your storage activity and usage with S3 Storage Lens</a> in the <em>Amazon S3 User Guide</em> . For a complete list of metrics, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html">S3 Storage Lens metrics glossary</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * AdvancedCostOptimizationMetricsProperty advancedCostOptimizationMetricsProperty = AdvancedCostOptimizationMetricsProperty.builder()
     *         .isEnabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnStorageLens.AdvancedCostOptimizationMetricsProperty")
    @software.amazon.jsii.Jsii.Proxy(AdvancedCostOptimizationMetricsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AdvancedCostOptimizationMetricsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether advanced cost optimization metrics are enabled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AdvancedCostOptimizationMetricsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AdvancedCostOptimizationMetricsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AdvancedCostOptimizationMetricsProperty> {
            java.lang.Object isEnabled;

            /**
             * Sets the value of {@link AdvancedCostOptimizationMetricsProperty#getIsEnabled}
             * @param isEnabled Indicates whether advanced cost optimization metrics are enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isEnabled(java.lang.Boolean isEnabled) {
                this.isEnabled = isEnabled;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedCostOptimizationMetricsProperty#getIsEnabled}
             * @param isEnabled Indicates whether advanced cost optimization metrics are enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isEnabled(software.amazon.awscdk.core.IResolvable isEnabled) {
                this.isEnabled = isEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AdvancedCostOptimizationMetricsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AdvancedCostOptimizationMetricsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AdvancedCostOptimizationMetricsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AdvancedCostOptimizationMetricsProperty {
            private final java.lang.Object isEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.isEnabled = software.amazon.jsii.Kernel.get(this, "isEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.isEnabled = builder.isEnabled;
            }

            @Override
            public final java.lang.Object getIsEnabled() {
                return this.isEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIsEnabled() != null) {
                    data.set("isEnabled", om.valueToTree(this.getIsEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnStorageLens.AdvancedCostOptimizationMetricsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AdvancedCostOptimizationMetricsProperty.Jsii$Proxy that = (AdvancedCostOptimizationMetricsProperty.Jsii$Proxy) o;

                return this.isEnabled != null ? this.isEnabled.equals(that.isEnabled) : that.isEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.isEnabled != null ? this.isEnabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * This resource enables Amazon S3 Storage Lens advanced data protection metrics.
     * <p>
     * Advanced data protection metrics provide insights that you can use to perform audits and protect your data, for example replication rule counts within and across Regions.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html">Assessing your storage activity and usage with S3 Storage Lens</a> in the <em>Amazon S3 User Guide</em> . For a complete list of metrics, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html">S3 Storage Lens metrics glossary</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * AdvancedDataProtectionMetricsProperty advancedDataProtectionMetricsProperty = AdvancedDataProtectionMetricsProperty.builder()
     *         .isEnabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnStorageLens.AdvancedDataProtectionMetricsProperty")
    @software.amazon.jsii.Jsii.Proxy(AdvancedDataProtectionMetricsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AdvancedDataProtectionMetricsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether advanced data protection metrics are enabled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AdvancedDataProtectionMetricsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AdvancedDataProtectionMetricsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AdvancedDataProtectionMetricsProperty> {
            java.lang.Object isEnabled;

            /**
             * Sets the value of {@link AdvancedDataProtectionMetricsProperty#getIsEnabled}
             * @param isEnabled Indicates whether advanced data protection metrics are enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isEnabled(java.lang.Boolean isEnabled) {
                this.isEnabled = isEnabled;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedDataProtectionMetricsProperty#getIsEnabled}
             * @param isEnabled Indicates whether advanced data protection metrics are enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isEnabled(software.amazon.awscdk.core.IResolvable isEnabled) {
                this.isEnabled = isEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AdvancedDataProtectionMetricsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AdvancedDataProtectionMetricsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AdvancedDataProtectionMetricsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AdvancedDataProtectionMetricsProperty {
            private final java.lang.Object isEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.isEnabled = software.amazon.jsii.Kernel.get(this, "isEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.isEnabled = builder.isEnabled;
            }

            @Override
            public final java.lang.Object getIsEnabled() {
                return this.isEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIsEnabled() != null) {
                    data.set("isEnabled", om.valueToTree(this.getIsEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnStorageLens.AdvancedDataProtectionMetricsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AdvancedDataProtectionMetricsProperty.Jsii$Proxy that = (AdvancedDataProtectionMetricsProperty.Jsii$Proxy) o;

                return this.isEnabled != null ? this.isEnabled.equals(that.isEnabled) : that.isEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.isEnabled != null ? this.isEnabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * This resource contains the details of the AWS Organization for Amazon S3 Storage Lens.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * AwsOrgProperty awsOrgProperty = AwsOrgProperty.builder()
     *         .arn("arn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnStorageLens.AwsOrgProperty")
    @software.amazon.jsii.Jsii.Proxy(AwsOrgProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AwsOrgProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This resource contains the ARN of the AWS Organization.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getArn();

        /**
         * @return a {@link Builder} of {@link AwsOrgProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AwsOrgProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AwsOrgProperty> {
            java.lang.String arn;

            /**
             * Sets the value of {@link AwsOrgProperty#getArn}
             * @param arn This resource contains the ARN of the AWS Organization. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AwsOrgProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AwsOrgProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AwsOrgProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsOrgProperty {
            private final java.lang.String arn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = java.util.Objects.requireNonNull(builder.arn, "arn is required");
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("arn", om.valueToTree(this.getArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnStorageLens.AwsOrgProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AwsOrgProperty.Jsii$Proxy that = (AwsOrgProperty.Jsii$Proxy) o;

                return this.arn.equals(that.arn);
            }

            @Override
            public final int hashCode() {
                int result = this.arn.hashCode();
                return result;
            }
        }
    }
    /**
     * A property for the bucket-level storage metrics for Amazon S3 Storage Lens.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * BucketLevelProperty bucketLevelProperty = BucketLevelProperty.builder()
     *         .activityMetrics(ActivityMetricsProperty.builder()
     *                 .isEnabled(false)
     *                 .build())
     *         .advancedCostOptimizationMetrics(AdvancedCostOptimizationMetricsProperty.builder()
     *                 .isEnabled(false)
     *                 .build())
     *         .advancedDataProtectionMetrics(AdvancedDataProtectionMetricsProperty.builder()
     *                 .isEnabled(false)
     *                 .build())
     *         .detailedStatusCodesMetrics(DetailedStatusCodesMetricsProperty.builder()
     *                 .isEnabled(false)
     *                 .build())
     *         .prefixLevel(PrefixLevelProperty.builder()
     *                 .storageMetrics(PrefixLevelStorageMetricsProperty.builder()
     *                         .isEnabled(false)
     *                         .selectionCriteria(SelectionCriteriaProperty.builder()
     *                                 .delimiter("delimiter")
     *                                 .maxDepth(123)
     *                                 .minStorageBytesPercentage(123)
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnStorageLens.BucketLevelProperty")
    @software.amazon.jsii.Jsii.Proxy(BucketLevelProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BucketLevelProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A property for bucket-level activity metrics for S3 Storage Lens.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getActivityMetrics() {
            return null;
        }

        /**
         * A property for bucket-level advanced cost optimization metrics for S3 Storage Lens.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAdvancedCostOptimizationMetrics() {
            return null;
        }

        /**
         * A property for bucket-level advanced data protection metrics for S3 Storage Lens.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAdvancedDataProtectionMetrics() {
            return null;
        }

        /**
         * A property for bucket-level detailed status code metrics for S3 Storage Lens.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDetailedStatusCodesMetrics() {
            return null;
        }

        /**
         * A property for bucket-level prefix-level storage metrics for S3 Storage Lens.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrefixLevel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BucketLevelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BucketLevelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BucketLevelProperty> {
            java.lang.Object activityMetrics;
            java.lang.Object advancedCostOptimizationMetrics;
            java.lang.Object advancedDataProtectionMetrics;
            java.lang.Object detailedStatusCodesMetrics;
            java.lang.Object prefixLevel;

            /**
             * Sets the value of {@link BucketLevelProperty#getActivityMetrics}
             * @param activityMetrics A property for bucket-level activity metrics for S3 Storage Lens.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder activityMetrics(software.amazon.awscdk.core.IResolvable activityMetrics) {
                this.activityMetrics = activityMetrics;
                return this;
            }

            /**
             * Sets the value of {@link BucketLevelProperty#getActivityMetrics}
             * @param activityMetrics A property for bucket-level activity metrics for S3 Storage Lens.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder activityMetrics(software.amazon.awscdk.services.s3.CfnStorageLens.ActivityMetricsProperty activityMetrics) {
                this.activityMetrics = activityMetrics;
                return this;
            }

            /**
             * Sets the value of {@link BucketLevelProperty#getAdvancedCostOptimizationMetrics}
             * @param advancedCostOptimizationMetrics A property for bucket-level advanced cost optimization metrics for S3 Storage Lens.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder advancedCostOptimizationMetrics(software.amazon.awscdk.core.IResolvable advancedCostOptimizationMetrics) {
                this.advancedCostOptimizationMetrics = advancedCostOptimizationMetrics;
                return this;
            }

            /**
             * Sets the value of {@link BucketLevelProperty#getAdvancedCostOptimizationMetrics}
             * @param advancedCostOptimizationMetrics A property for bucket-level advanced cost optimization metrics for S3 Storage Lens.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder advancedCostOptimizationMetrics(software.amazon.awscdk.services.s3.CfnStorageLens.AdvancedCostOptimizationMetricsProperty advancedCostOptimizationMetrics) {
                this.advancedCostOptimizationMetrics = advancedCostOptimizationMetrics;
                return this;
            }

            /**
             * Sets the value of {@link BucketLevelProperty#getAdvancedDataProtectionMetrics}
             * @param advancedDataProtectionMetrics A property for bucket-level advanced data protection metrics for S3 Storage Lens.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder advancedDataProtectionMetrics(software.amazon.awscdk.core.IResolvable advancedDataProtectionMetrics) {
                this.advancedDataProtectionMetrics = advancedDataProtectionMetrics;
                return this;
            }

            /**
             * Sets the value of {@link BucketLevelProperty#getAdvancedDataProtectionMetrics}
             * @param advancedDataProtectionMetrics A property for bucket-level advanced data protection metrics for S3 Storage Lens.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder advancedDataProtectionMetrics(software.amazon.awscdk.services.s3.CfnStorageLens.AdvancedDataProtectionMetricsProperty advancedDataProtectionMetrics) {
                this.advancedDataProtectionMetrics = advancedDataProtectionMetrics;
                return this;
            }

            /**
             * Sets the value of {@link BucketLevelProperty#getDetailedStatusCodesMetrics}
             * @param detailedStatusCodesMetrics A property for bucket-level detailed status code metrics for S3 Storage Lens.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder detailedStatusCodesMetrics(software.amazon.awscdk.core.IResolvable detailedStatusCodesMetrics) {
                this.detailedStatusCodesMetrics = detailedStatusCodesMetrics;
                return this;
            }

            /**
             * Sets the value of {@link BucketLevelProperty#getDetailedStatusCodesMetrics}
             * @param detailedStatusCodesMetrics A property for bucket-level detailed status code metrics for S3 Storage Lens.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder detailedStatusCodesMetrics(software.amazon.awscdk.services.s3.CfnStorageLens.DetailedStatusCodesMetricsProperty detailedStatusCodesMetrics) {
                this.detailedStatusCodesMetrics = detailedStatusCodesMetrics;
                return this;
            }

            /**
             * Sets the value of {@link BucketLevelProperty#getPrefixLevel}
             * @param prefixLevel A property for bucket-level prefix-level storage metrics for S3 Storage Lens.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefixLevel(software.amazon.awscdk.core.IResolvable prefixLevel) {
                this.prefixLevel = prefixLevel;
                return this;
            }

            /**
             * Sets the value of {@link BucketLevelProperty#getPrefixLevel}
             * @param prefixLevel A property for bucket-level prefix-level storage metrics for S3 Storage Lens.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefixLevel(software.amazon.awscdk.services.s3.CfnStorageLens.PrefixLevelProperty prefixLevel) {
                this.prefixLevel = prefixLevel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BucketLevelProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BucketLevelProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BucketLevelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BucketLevelProperty {
            private final java.lang.Object activityMetrics;
            private final java.lang.Object advancedCostOptimizationMetrics;
            private final java.lang.Object advancedDataProtectionMetrics;
            private final java.lang.Object detailedStatusCodesMetrics;
            private final java.lang.Object prefixLevel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.activityMetrics = software.amazon.jsii.Kernel.get(this, "activityMetrics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.advancedCostOptimizationMetrics = software.amazon.jsii.Kernel.get(this, "advancedCostOptimizationMetrics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.advancedDataProtectionMetrics = software.amazon.jsii.Kernel.get(this, "advancedDataProtectionMetrics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.detailedStatusCodesMetrics = software.amazon.jsii.Kernel.get(this, "detailedStatusCodesMetrics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.prefixLevel = software.amazon.jsii.Kernel.get(this, "prefixLevel", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.activityMetrics = builder.activityMetrics;
                this.advancedCostOptimizationMetrics = builder.advancedCostOptimizationMetrics;
                this.advancedDataProtectionMetrics = builder.advancedDataProtectionMetrics;
                this.detailedStatusCodesMetrics = builder.detailedStatusCodesMetrics;
                this.prefixLevel = builder.prefixLevel;
            }

            @Override
            public final java.lang.Object getActivityMetrics() {
                return this.activityMetrics;
            }

            @Override
            public final java.lang.Object getAdvancedCostOptimizationMetrics() {
                return this.advancedCostOptimizationMetrics;
            }

            @Override
            public final java.lang.Object getAdvancedDataProtectionMetrics() {
                return this.advancedDataProtectionMetrics;
            }

            @Override
            public final java.lang.Object getDetailedStatusCodesMetrics() {
                return this.detailedStatusCodesMetrics;
            }

            @Override
            public final java.lang.Object getPrefixLevel() {
                return this.prefixLevel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getActivityMetrics() != null) {
                    data.set("activityMetrics", om.valueToTree(this.getActivityMetrics()));
                }
                if (this.getAdvancedCostOptimizationMetrics() != null) {
                    data.set("advancedCostOptimizationMetrics", om.valueToTree(this.getAdvancedCostOptimizationMetrics()));
                }
                if (this.getAdvancedDataProtectionMetrics() != null) {
                    data.set("advancedDataProtectionMetrics", om.valueToTree(this.getAdvancedDataProtectionMetrics()));
                }
                if (this.getDetailedStatusCodesMetrics() != null) {
                    data.set("detailedStatusCodesMetrics", om.valueToTree(this.getDetailedStatusCodesMetrics()));
                }
                if (this.getPrefixLevel() != null) {
                    data.set("prefixLevel", om.valueToTree(this.getPrefixLevel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnStorageLens.BucketLevelProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BucketLevelProperty.Jsii$Proxy that = (BucketLevelProperty.Jsii$Proxy) o;

                if (this.activityMetrics != null ? !this.activityMetrics.equals(that.activityMetrics) : that.activityMetrics != null) return false;
                if (this.advancedCostOptimizationMetrics != null ? !this.advancedCostOptimizationMetrics.equals(that.advancedCostOptimizationMetrics) : that.advancedCostOptimizationMetrics != null) return false;
                if (this.advancedDataProtectionMetrics != null ? !this.advancedDataProtectionMetrics.equals(that.advancedDataProtectionMetrics) : that.advancedDataProtectionMetrics != null) return false;
                if (this.detailedStatusCodesMetrics != null ? !this.detailedStatusCodesMetrics.equals(that.detailedStatusCodesMetrics) : that.detailedStatusCodesMetrics != null) return false;
                return this.prefixLevel != null ? this.prefixLevel.equals(that.prefixLevel) : that.prefixLevel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.activityMetrics != null ? this.activityMetrics.hashCode() : 0;
                result = 31 * result + (this.advancedCostOptimizationMetrics != null ? this.advancedCostOptimizationMetrics.hashCode() : 0);
                result = 31 * result + (this.advancedDataProtectionMetrics != null ? this.advancedDataProtectionMetrics.hashCode() : 0);
                result = 31 * result + (this.detailedStatusCodesMetrics != null ? this.detailedStatusCodesMetrics.hashCode() : 0);
                result = 31 * result + (this.prefixLevel != null ? this.prefixLevel.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This resource contains the details of the buckets and Regions for the Amazon S3 Storage Lens configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * BucketsAndRegionsProperty bucketsAndRegionsProperty = BucketsAndRegionsProperty.builder()
     *         .buckets(List.of("buckets"))
     *         .regions(List.of("regions"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnStorageLens.BucketsAndRegionsProperty")
    @software.amazon.jsii.Jsii.Proxy(BucketsAndRegionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BucketsAndRegionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This property contains the details of the buckets for the Amazon S3 Storage Lens configuration.
         * <p>
         * This should be the bucket Amazon Resource Name(ARN). For valid values, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_Include.html#API_control_Include_Contents">Buckets ARN format here</a> in the <em>Amazon S3 API Reference</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getBuckets() {
            return null;
        }

        /**
         * This property contains the details of the Regions for the S3 Storage Lens configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRegions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BucketsAndRegionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BucketsAndRegionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BucketsAndRegionsProperty> {
            java.util.List<java.lang.String> buckets;
            java.util.List<java.lang.String> regions;

            /**
             * Sets the value of {@link BucketsAndRegionsProperty#getBuckets}
             * @param buckets This property contains the details of the buckets for the Amazon S3 Storage Lens configuration.
             *                This should be the bucket Amazon Resource Name(ARN). For valid values, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_Include.html#API_control_Include_Contents">Buckets ARN format here</a> in the <em>Amazon S3 API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder buckets(java.util.List<java.lang.String> buckets) {
                this.buckets = buckets;
                return this;
            }

            /**
             * Sets the value of {@link BucketsAndRegionsProperty#getRegions}
             * @param regions This property contains the details of the Regions for the S3 Storage Lens configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regions(java.util.List<java.lang.String> regions) {
                this.regions = regions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BucketsAndRegionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BucketsAndRegionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BucketsAndRegionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BucketsAndRegionsProperty {
            private final java.util.List<java.lang.String> buckets;
            private final java.util.List<java.lang.String> regions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.buckets = software.amazon.jsii.Kernel.get(this, "buckets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.regions = software.amazon.jsii.Kernel.get(this, "regions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.buckets = builder.buckets;
                this.regions = builder.regions;
            }

            @Override
            public final java.util.List<java.lang.String> getBuckets() {
                return this.buckets;
            }

            @Override
            public final java.util.List<java.lang.String> getRegions() {
                return this.regions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBuckets() != null) {
                    data.set("buckets", om.valueToTree(this.getBuckets()));
                }
                if (this.getRegions() != null) {
                    data.set("regions", om.valueToTree(this.getRegions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnStorageLens.BucketsAndRegionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BucketsAndRegionsProperty.Jsii$Proxy that = (BucketsAndRegionsProperty.Jsii$Proxy) o;

                if (this.buckets != null ? !this.buckets.equals(that.buckets) : that.buckets != null) return false;
                return this.regions != null ? this.regions.equals(that.regions) : that.regions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.buckets != null ? this.buckets.hashCode() : 0;
                result = 31 * result + (this.regions != null ? this.regions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This resource enables the Amazon CloudWatch publishing option for Amazon S3 Storage Lens metrics.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_view_metrics_cloudwatch.html">Monitor S3 Storage Lens metrics in CloudWatch</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * CloudWatchMetricsProperty cloudWatchMetricsProperty = CloudWatchMetricsProperty.builder()
     *         .isEnabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnStorageLens.CloudWatchMetricsProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchMetricsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchMetricsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This property identifies whether the CloudWatch publishing option for S3 Storage Lens is enabled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getIsEnabled();

        /**
         * @return a {@link Builder} of {@link CloudWatchMetricsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchMetricsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchMetricsProperty> {
            java.lang.Object isEnabled;

            /**
             * Sets the value of {@link CloudWatchMetricsProperty#getIsEnabled}
             * @param isEnabled This property identifies whether the CloudWatch publishing option for S3 Storage Lens is enabled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isEnabled(java.lang.Boolean isEnabled) {
                this.isEnabled = isEnabled;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchMetricsProperty#getIsEnabled}
             * @param isEnabled This property identifies whether the CloudWatch publishing option for S3 Storage Lens is enabled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isEnabled(software.amazon.awscdk.core.IResolvable isEnabled) {
                this.isEnabled = isEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchMetricsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchMetricsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchMetricsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchMetricsProperty {
            private final java.lang.Object isEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.isEnabled = software.amazon.jsii.Kernel.get(this, "isEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.isEnabled = java.util.Objects.requireNonNull(builder.isEnabled, "isEnabled is required");
            }

            @Override
            public final java.lang.Object getIsEnabled() {
                return this.isEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("isEnabled", om.valueToTree(this.getIsEnabled()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnStorageLens.CloudWatchMetricsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchMetricsProperty.Jsii$Proxy that = (CloudWatchMetricsProperty.Jsii$Proxy) o;

                return this.isEnabled.equals(that.isEnabled);
            }

            @Override
            public final int hashCode() {
                int result = this.isEnabled.hashCode();
                return result;
            }
        }
    }
    /**
     * This resource contains the details of the Amazon S3 Storage Lens metrics export.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * Object sses3;
     * DataExportProperty dataExportProperty = DataExportProperty.builder()
     *         .cloudWatchMetrics(CloudWatchMetricsProperty.builder()
     *                 .isEnabled(false)
     *                 .build())
     *         .s3BucketDestination(S3BucketDestinationProperty.builder()
     *                 .accountId("accountId")
     *                 .arn("arn")
     *                 .format("format")
     *                 .outputSchemaVersion("outputSchemaVersion")
     *                 // the properties below are optional
     *                 .encryption(EncryptionProperty.builder()
     *                         .ssekms(SSEKMSProperty.builder()
     *                                 .keyId("keyId")
     *                                 .build())
     *                         .sses3(sses3)
     *                         .build())
     *                 .prefix("prefix")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnStorageLens.DataExportProperty")
    @software.amazon.jsii.Jsii.Proxy(DataExportProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataExportProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This property enables the Amazon CloudWatch publishing option for S3 Storage Lens metrics.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchMetrics() {
            return null;
        }

        /**
         * This property contains the details of the bucket where the S3 Storage Lens metrics export will be placed.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3BucketDestination() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataExportProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataExportProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataExportProperty> {
            java.lang.Object cloudWatchMetrics;
            java.lang.Object s3BucketDestination;

            /**
             * Sets the value of {@link DataExportProperty#getCloudWatchMetrics}
             * @param cloudWatchMetrics This property enables the Amazon CloudWatch publishing option for S3 Storage Lens metrics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchMetrics(software.amazon.awscdk.core.IResolvable cloudWatchMetrics) {
                this.cloudWatchMetrics = cloudWatchMetrics;
                return this;
            }

            /**
             * Sets the value of {@link DataExportProperty#getCloudWatchMetrics}
             * @param cloudWatchMetrics This property enables the Amazon CloudWatch publishing option for S3 Storage Lens metrics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchMetrics(software.amazon.awscdk.services.s3.CfnStorageLens.CloudWatchMetricsProperty cloudWatchMetrics) {
                this.cloudWatchMetrics = cloudWatchMetrics;
                return this;
            }

            /**
             * Sets the value of {@link DataExportProperty#getS3BucketDestination}
             * @param s3BucketDestination This property contains the details of the bucket where the S3 Storage Lens metrics export will be placed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketDestination(software.amazon.awscdk.core.IResolvable s3BucketDestination) {
                this.s3BucketDestination = s3BucketDestination;
                return this;
            }

            /**
             * Sets the value of {@link DataExportProperty#getS3BucketDestination}
             * @param s3BucketDestination This property contains the details of the bucket where the S3 Storage Lens metrics export will be placed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketDestination(software.amazon.awscdk.services.s3.CfnStorageLens.S3BucketDestinationProperty s3BucketDestination) {
                this.s3BucketDestination = s3BucketDestination;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataExportProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataExportProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataExportProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataExportProperty {
            private final java.lang.Object cloudWatchMetrics;
            private final java.lang.Object s3BucketDestination;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchMetrics = software.amazon.jsii.Kernel.get(this, "cloudWatchMetrics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3BucketDestination = software.amazon.jsii.Kernel.get(this, "s3BucketDestination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchMetrics = builder.cloudWatchMetrics;
                this.s3BucketDestination = builder.s3BucketDestination;
            }

            @Override
            public final java.lang.Object getCloudWatchMetrics() {
                return this.cloudWatchMetrics;
            }

            @Override
            public final java.lang.Object getS3BucketDestination() {
                return this.s3BucketDestination;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudWatchMetrics() != null) {
                    data.set("cloudWatchMetrics", om.valueToTree(this.getCloudWatchMetrics()));
                }
                if (this.getS3BucketDestination() != null) {
                    data.set("s3BucketDestination", om.valueToTree(this.getS3BucketDestination()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnStorageLens.DataExportProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataExportProperty.Jsii$Proxy that = (DataExportProperty.Jsii$Proxy) o;

                if (this.cloudWatchMetrics != null ? !this.cloudWatchMetrics.equals(that.cloudWatchMetrics) : that.cloudWatchMetrics != null) return false;
                return this.s3BucketDestination != null ? this.s3BucketDestination.equals(that.s3BucketDestination) : that.s3BucketDestination == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchMetrics != null ? this.cloudWatchMetrics.hashCode() : 0;
                result = 31 * result + (this.s3BucketDestination != null ? this.s3BucketDestination.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This resource enables Amazon S3 Storage Lens detailed status code metrics.
     * <p>
     * Detailed status code metrics generate metrics for HTTP status codes, such as <code>200 OK</code> , <code>403 Forbidden</code> , <code>503 Service Unavailable</code> and others.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html">Assessing your storage activity and usage with S3 Storage Lens</a> in the <em>Amazon S3 User Guide</em> . For a complete list of metrics, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html">S3 Storage Lens metrics glossary</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * DetailedStatusCodesMetricsProperty detailedStatusCodesMetricsProperty = DetailedStatusCodesMetricsProperty.builder()
     *         .isEnabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnStorageLens.DetailedStatusCodesMetricsProperty")
    @software.amazon.jsii.Jsii.Proxy(DetailedStatusCodesMetricsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DetailedStatusCodesMetricsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether detailed status code metrics are enabled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DetailedStatusCodesMetricsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DetailedStatusCodesMetricsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DetailedStatusCodesMetricsProperty> {
            java.lang.Object isEnabled;

            /**
             * Sets the value of {@link DetailedStatusCodesMetricsProperty#getIsEnabled}
             * @param isEnabled Indicates whether detailed status code metrics are enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isEnabled(java.lang.Boolean isEnabled) {
                this.isEnabled = isEnabled;
                return this;
            }

            /**
             * Sets the value of {@link DetailedStatusCodesMetricsProperty#getIsEnabled}
             * @param isEnabled Indicates whether detailed status code metrics are enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isEnabled(software.amazon.awscdk.core.IResolvable isEnabled) {
                this.isEnabled = isEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DetailedStatusCodesMetricsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DetailedStatusCodesMetricsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DetailedStatusCodesMetricsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DetailedStatusCodesMetricsProperty {
            private final java.lang.Object isEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.isEnabled = software.amazon.jsii.Kernel.get(this, "isEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.isEnabled = builder.isEnabled;
            }

            @Override
            public final java.lang.Object getIsEnabled() {
                return this.isEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIsEnabled() != null) {
                    data.set("isEnabled", om.valueToTree(this.getIsEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnStorageLens.DetailedStatusCodesMetricsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DetailedStatusCodesMetricsProperty.Jsii$Proxy that = (DetailedStatusCodesMetricsProperty.Jsii$Proxy) o;

                return this.isEnabled != null ? this.isEnabled.equals(that.isEnabled) : that.isEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.isEnabled != null ? this.isEnabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * This resource contains the type of server-side encryption used to encrypt an Amazon S3 Storage Lens metrics export.
     * <p>
     * For valid values, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_StorageLensDataExportEncryption.html">StorageLensDataExportEncryption</a> in the <em>Amazon S3 API Reference</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * Object sses3;
     * EncryptionProperty encryptionProperty = EncryptionProperty.builder()
     *         .ssekms(SSEKMSProperty.builder()
     *                 .keyId("keyId")
     *                 .build())
     *         .sses3(sses3)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnStorageLens.EncryptionProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the use of AWS Key Management Service keys (SSE-KMS) to encrypt the S3 Storage Lens metrics export file.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSsekms() {
            return null;
        }

        /**
         * Specifies the use of an Amazon S3-managed key (SSE-S3) to encrypt the S3 Storage Lens metrics export file.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSses3() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionProperty> {
            java.lang.Object ssekms;
            java.lang.Object sses3;

            /**
             * Sets the value of {@link EncryptionProperty#getSsekms}
             * @param ssekms Specifies the use of AWS Key Management Service keys (SSE-KMS) to encrypt the S3 Storage Lens metrics export file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ssekms(software.amazon.awscdk.core.IResolvable ssekms) {
                this.ssekms = ssekms;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getSsekms}
             * @param ssekms Specifies the use of AWS Key Management Service keys (SSE-KMS) to encrypt the S3 Storage Lens metrics export file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ssekms(software.amazon.awscdk.services.s3.CfnStorageLens.SSEKMSProperty ssekms) {
                this.ssekms = ssekms;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getSses3}
             * @param sses3 Specifies the use of an Amazon S3-managed key (SSE-S3) to encrypt the S3 Storage Lens metrics export file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sses3(java.lang.Object sses3) {
                this.sses3 = sses3;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionProperty {
            private final java.lang.Object ssekms;
            private final java.lang.Object sses3;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ssekms = software.amazon.jsii.Kernel.get(this, "ssekms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sses3 = software.amazon.jsii.Kernel.get(this, "sses3", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ssekms = builder.ssekms;
                this.sses3 = builder.sses3;
            }

            @Override
            public final java.lang.Object getSsekms() {
                return this.ssekms;
            }

            @Override
            public final java.lang.Object getSses3() {
                return this.sses3;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSsekms() != null) {
                    data.set("ssekms", om.valueToTree(this.getSsekms()));
                }
                if (this.getSses3() != null) {
                    data.set("sses3", om.valueToTree(this.getSses3()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnStorageLens.EncryptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionProperty.Jsii$Proxy that = (EncryptionProperty.Jsii$Proxy) o;

                if (this.ssekms != null ? !this.ssekms.equals(that.ssekms) : that.ssekms != null) return false;
                return this.sses3 != null ? this.sses3.equals(that.sses3) : that.sses3 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ssekms != null ? this.ssekms.hashCode() : 0;
                result = 31 * result + (this.sses3 != null ? this.sses3.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This resource contains the details of the prefix-level of the Amazon S3 Storage Lens.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * PrefixLevelProperty prefixLevelProperty = PrefixLevelProperty.builder()
     *         .storageMetrics(PrefixLevelStorageMetricsProperty.builder()
     *                 .isEnabled(false)
     *                 .selectionCriteria(SelectionCriteriaProperty.builder()
     *                         .delimiter("delimiter")
     *                         .maxDepth(123)
     *                         .minStorageBytesPercentage(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnStorageLens.PrefixLevelProperty")
    @software.amazon.jsii.Jsii.Proxy(PrefixLevelProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PrefixLevelProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A property for the prefix-level storage metrics for Amazon S3 Storage Lens.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getStorageMetrics();

        /**
         * @return a {@link Builder} of {@link PrefixLevelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PrefixLevelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PrefixLevelProperty> {
            java.lang.Object storageMetrics;

            /**
             * Sets the value of {@link PrefixLevelProperty#getStorageMetrics}
             * @param storageMetrics A property for the prefix-level storage metrics for Amazon S3 Storage Lens. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageMetrics(software.amazon.awscdk.core.IResolvable storageMetrics) {
                this.storageMetrics = storageMetrics;
                return this;
            }

            /**
             * Sets the value of {@link PrefixLevelProperty#getStorageMetrics}
             * @param storageMetrics A property for the prefix-level storage metrics for Amazon S3 Storage Lens. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageMetrics(software.amazon.awscdk.services.s3.CfnStorageLens.PrefixLevelStorageMetricsProperty storageMetrics) {
                this.storageMetrics = storageMetrics;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrefixLevelProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PrefixLevelProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PrefixLevelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrefixLevelProperty {
            private final java.lang.Object storageMetrics;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.storageMetrics = software.amazon.jsii.Kernel.get(this, "storageMetrics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.storageMetrics = java.util.Objects.requireNonNull(builder.storageMetrics, "storageMetrics is required");
            }

            @Override
            public final java.lang.Object getStorageMetrics() {
                return this.storageMetrics;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("storageMetrics", om.valueToTree(this.getStorageMetrics()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnStorageLens.PrefixLevelProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PrefixLevelProperty.Jsii$Proxy that = (PrefixLevelProperty.Jsii$Proxy) o;

                return this.storageMetrics.equals(that.storageMetrics);
            }

            @Override
            public final int hashCode() {
                int result = this.storageMetrics.hashCode();
                return result;
            }
        }
    }
    /**
     * This resource contains the details of the prefix-level storage metrics for Amazon S3 Storage Lens.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * PrefixLevelStorageMetricsProperty prefixLevelStorageMetricsProperty = PrefixLevelStorageMetricsProperty.builder()
     *         .isEnabled(false)
     *         .selectionCriteria(SelectionCriteriaProperty.builder()
     *                 .delimiter("delimiter")
     *                 .maxDepth(123)
     *                 .minStorageBytesPercentage(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnStorageLens.PrefixLevelStorageMetricsProperty")
    @software.amazon.jsii.Jsii.Proxy(PrefixLevelStorageMetricsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PrefixLevelStorageMetricsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This property identifies whether the details of the prefix-level storage metrics for S3 Storage Lens are enabled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsEnabled() {
            return null;
        }

        /**
         * This property identifies whether the details of the prefix-level storage metrics for S3 Storage Lens are enabled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSelectionCriteria() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PrefixLevelStorageMetricsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PrefixLevelStorageMetricsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PrefixLevelStorageMetricsProperty> {
            java.lang.Object isEnabled;
            java.lang.Object selectionCriteria;

            /**
             * Sets the value of {@link PrefixLevelStorageMetricsProperty#getIsEnabled}
             * @param isEnabled This property identifies whether the details of the prefix-level storage metrics for S3 Storage Lens are enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isEnabled(java.lang.Boolean isEnabled) {
                this.isEnabled = isEnabled;
                return this;
            }

            /**
             * Sets the value of {@link PrefixLevelStorageMetricsProperty#getIsEnabled}
             * @param isEnabled This property identifies whether the details of the prefix-level storage metrics for S3 Storage Lens are enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isEnabled(software.amazon.awscdk.core.IResolvable isEnabled) {
                this.isEnabled = isEnabled;
                return this;
            }

            /**
             * Sets the value of {@link PrefixLevelStorageMetricsProperty#getSelectionCriteria}
             * @param selectionCriteria This property identifies whether the details of the prefix-level storage metrics for S3 Storage Lens are enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selectionCriteria(software.amazon.awscdk.core.IResolvable selectionCriteria) {
                this.selectionCriteria = selectionCriteria;
                return this;
            }

            /**
             * Sets the value of {@link PrefixLevelStorageMetricsProperty#getSelectionCriteria}
             * @param selectionCriteria This property identifies whether the details of the prefix-level storage metrics for S3 Storage Lens are enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selectionCriteria(software.amazon.awscdk.services.s3.CfnStorageLens.SelectionCriteriaProperty selectionCriteria) {
                this.selectionCriteria = selectionCriteria;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrefixLevelStorageMetricsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PrefixLevelStorageMetricsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PrefixLevelStorageMetricsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrefixLevelStorageMetricsProperty {
            private final java.lang.Object isEnabled;
            private final java.lang.Object selectionCriteria;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.isEnabled = software.amazon.jsii.Kernel.get(this, "isEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.selectionCriteria = software.amazon.jsii.Kernel.get(this, "selectionCriteria", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.isEnabled = builder.isEnabled;
                this.selectionCriteria = builder.selectionCriteria;
            }

            @Override
            public final java.lang.Object getIsEnabled() {
                return this.isEnabled;
            }

            @Override
            public final java.lang.Object getSelectionCriteria() {
                return this.selectionCriteria;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIsEnabled() != null) {
                    data.set("isEnabled", om.valueToTree(this.getIsEnabled()));
                }
                if (this.getSelectionCriteria() != null) {
                    data.set("selectionCriteria", om.valueToTree(this.getSelectionCriteria()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnStorageLens.PrefixLevelStorageMetricsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PrefixLevelStorageMetricsProperty.Jsii$Proxy that = (PrefixLevelStorageMetricsProperty.Jsii$Proxy) o;

                if (this.isEnabled != null ? !this.isEnabled.equals(that.isEnabled) : that.isEnabled != null) return false;
                return this.selectionCriteria != null ? this.selectionCriteria.equals(that.selectionCriteria) : that.selectionCriteria == null;
            }

            @Override
            public final int hashCode() {
                int result = this.isEnabled != null ? this.isEnabled.hashCode() : 0;
                result = 31 * result + (this.selectionCriteria != null ? this.selectionCriteria.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This resource contains the details of the bucket where the Amazon S3 Storage Lens metrics export will be placed.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * Object sses3;
     * S3BucketDestinationProperty s3BucketDestinationProperty = S3BucketDestinationProperty.builder()
     *         .accountId("accountId")
     *         .arn("arn")
     *         .format("format")
     *         .outputSchemaVersion("outputSchemaVersion")
     *         // the properties below are optional
     *         .encryption(EncryptionProperty.builder()
     *                 .ssekms(SSEKMSProperty.builder()
     *                         .keyId("keyId")
     *                         .build())
     *                 .sses3(sses3)
     *                 .build())
     *         .prefix("prefix")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnStorageLens.S3BucketDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3BucketDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3BucketDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This property contains the details of the AWS account ID of the S3 Storage Lens export bucket destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAccountId();

        /**
         * This property contains the details of the ARN of the bucket destination of the S3 Storage Lens export.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getArn();

        /**
         * This property contains the details of the format of the S3 Storage Lens export bucket destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFormat();

        /**
         * This property contains the details of the output schema version of the S3 Storage Lens export bucket destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOutputSchemaVersion();

        /**
         * This property contains the details of the encryption of the bucket destination of the Amazon S3 Storage Lens metrics export.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryption() {
            return null;
        }

        /**
         * This property contains the details of the prefix of the bucket destination of the S3 Storage Lens export .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3BucketDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3BucketDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3BucketDestinationProperty> {
            java.lang.String accountId;
            java.lang.String arn;
            java.lang.String format;
            java.lang.String outputSchemaVersion;
            java.lang.Object encryption;
            java.lang.String prefix;

            /**
             * Sets the value of {@link S3BucketDestinationProperty#getAccountId}
             * @param accountId This property contains the details of the AWS account ID of the S3 Storage Lens export bucket destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accountId(java.lang.String accountId) {
                this.accountId = accountId;
                return this;
            }

            /**
             * Sets the value of {@link S3BucketDestinationProperty#getArn}
             * @param arn This property contains the details of the ARN of the bucket destination of the S3 Storage Lens export. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of {@link S3BucketDestinationProperty#getFormat}
             * @param format This property contains the details of the format of the S3 Storage Lens export bucket destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder format(java.lang.String format) {
                this.format = format;
                return this;
            }

            /**
             * Sets the value of {@link S3BucketDestinationProperty#getOutputSchemaVersion}
             * @param outputSchemaVersion This property contains the details of the output schema version of the S3 Storage Lens export bucket destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputSchemaVersion(java.lang.String outputSchemaVersion) {
                this.outputSchemaVersion = outputSchemaVersion;
                return this;
            }

            /**
             * Sets the value of {@link S3BucketDestinationProperty#getEncryption}
             * @param encryption This property contains the details of the encryption of the bucket destination of the Amazon S3 Storage Lens metrics export.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryption(software.amazon.awscdk.core.IResolvable encryption) {
                this.encryption = encryption;
                return this;
            }

            /**
             * Sets the value of {@link S3BucketDestinationProperty#getEncryption}
             * @param encryption This property contains the details of the encryption of the bucket destination of the Amazon S3 Storage Lens metrics export.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryption(software.amazon.awscdk.services.s3.CfnStorageLens.EncryptionProperty encryption) {
                this.encryption = encryption;
                return this;
            }

            /**
             * Sets the value of {@link S3BucketDestinationProperty#getPrefix}
             * @param prefix This property contains the details of the prefix of the bucket destination of the S3 Storage Lens export .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3BucketDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3BucketDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3BucketDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3BucketDestinationProperty {
            private final java.lang.String accountId;
            private final java.lang.String arn;
            private final java.lang.String format;
            private final java.lang.String outputSchemaVersion;
            private final java.lang.Object encryption;
            private final java.lang.String prefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accountId = software.amazon.jsii.Kernel.get(this, "accountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.format = software.amazon.jsii.Kernel.get(this, "format", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputSchemaVersion = software.amazon.jsii.Kernel.get(this, "outputSchemaVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.encryption = software.amazon.jsii.Kernel.get(this, "encryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accountId = java.util.Objects.requireNonNull(builder.accountId, "accountId is required");
                this.arn = java.util.Objects.requireNonNull(builder.arn, "arn is required");
                this.format = java.util.Objects.requireNonNull(builder.format, "format is required");
                this.outputSchemaVersion = java.util.Objects.requireNonNull(builder.outputSchemaVersion, "outputSchemaVersion is required");
                this.encryption = builder.encryption;
                this.prefix = builder.prefix;
            }

            @Override
            public final java.lang.String getAccountId() {
                return this.accountId;
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public final java.lang.String getFormat() {
                return this.format;
            }

            @Override
            public final java.lang.String getOutputSchemaVersion() {
                return this.outputSchemaVersion;
            }

            @Override
            public final java.lang.Object getEncryption() {
                return this.encryption;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("accountId", om.valueToTree(this.getAccountId()));
                data.set("arn", om.valueToTree(this.getArn()));
                data.set("format", om.valueToTree(this.getFormat()));
                data.set("outputSchemaVersion", om.valueToTree(this.getOutputSchemaVersion()));
                if (this.getEncryption() != null) {
                    data.set("encryption", om.valueToTree(this.getEncryption()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnStorageLens.S3BucketDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3BucketDestinationProperty.Jsii$Proxy that = (S3BucketDestinationProperty.Jsii$Proxy) o;

                if (!accountId.equals(that.accountId)) return false;
                if (!arn.equals(that.arn)) return false;
                if (!format.equals(that.format)) return false;
                if (!outputSchemaVersion.equals(that.outputSchemaVersion)) return false;
                if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) return false;
                return this.prefix != null ? this.prefix.equals(that.prefix) : that.prefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accountId.hashCode();
                result = 31 * result + (this.arn.hashCode());
                result = 31 * result + (this.format.hashCode());
                result = 31 * result + (this.outputSchemaVersion.hashCode());
                result = 31 * result + (this.encryption != null ? this.encryption.hashCode() : 0);
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the use of server-side encryption using an AWS Key Management Service key (SSE-KMS) to encrypt the delivered S3 Storage Lens metrics export file.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * SSEKMSProperty sSEKMSProperty = SSEKMSProperty.builder()
     *         .keyId("keyId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnStorageLens.SSEKMSProperty")
    @software.amazon.jsii.Jsii.Proxy(SSEKMSProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SSEKMSProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the Amazon Resource Name (ARN) of the customer managed AWS KMS key to use for encrypting the S3 Storage Lens metrics export file.
         * <p>
         * Amazon S3 only supports symmetric encryption keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-types.html">Special-purpose keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKeyId();

        /**
         * @return a {@link Builder} of {@link SSEKMSProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SSEKMSProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SSEKMSProperty> {
            java.lang.String keyId;

            /**
             * Sets the value of {@link SSEKMSProperty#getKeyId}
             * @param keyId Specifies the Amazon Resource Name (ARN) of the customer managed AWS KMS key to use for encrypting the S3 Storage Lens metrics export file. This parameter is required.
             *              Amazon S3 only supports symmetric encryption keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-types.html">Special-purpose keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyId(java.lang.String keyId) {
                this.keyId = keyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SSEKMSProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SSEKMSProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SSEKMSProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SSEKMSProperty {
            private final java.lang.String keyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.keyId = software.amazon.jsii.Kernel.get(this, "keyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.keyId = java.util.Objects.requireNonNull(builder.keyId, "keyId is required");
            }

            @Override
            public final java.lang.String getKeyId() {
                return this.keyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("keyId", om.valueToTree(this.getKeyId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnStorageLens.SSEKMSProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SSEKMSProperty.Jsii$Proxy that = (SSEKMSProperty.Jsii$Proxy) o;

                return this.keyId.equals(that.keyId);
            }

            @Override
            public final int hashCode() {
                int result = this.keyId.hashCode();
                return result;
            }
        }
    }
    /**
     * This resource contains the details of the Amazon S3 Storage Lens selection criteria.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * SelectionCriteriaProperty selectionCriteriaProperty = SelectionCriteriaProperty.builder()
     *         .delimiter("delimiter")
     *         .maxDepth(123)
     *         .minStorageBytesPercentage(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnStorageLens.SelectionCriteriaProperty")
    @software.amazon.jsii.Jsii.Proxy(SelectionCriteriaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SelectionCriteriaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This property contains the details of the S3 Storage Lens delimiter being used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDelimiter() {
            return null;
        }

        /**
         * This property contains the details of the max depth that S3 Storage Lens will collect metrics up to.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxDepth() {
            return null;
        }

        /**
         * This property contains the details of the minimum storage bytes percentage threshold that S3 Storage Lens will collect metrics up to.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinStorageBytesPercentage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SelectionCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SelectionCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SelectionCriteriaProperty> {
            java.lang.String delimiter;
            java.lang.Number maxDepth;
            java.lang.Number minStorageBytesPercentage;

            /**
             * Sets the value of {@link SelectionCriteriaProperty#getDelimiter}
             * @param delimiter This property contains the details of the S3 Storage Lens delimiter being used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder delimiter(java.lang.String delimiter) {
                this.delimiter = delimiter;
                return this;
            }

            /**
             * Sets the value of {@link SelectionCriteriaProperty#getMaxDepth}
             * @param maxDepth This property contains the details of the max depth that S3 Storage Lens will collect metrics up to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxDepth(java.lang.Number maxDepth) {
                this.maxDepth = maxDepth;
                return this;
            }

            /**
             * Sets the value of {@link SelectionCriteriaProperty#getMinStorageBytesPercentage}
             * @param minStorageBytesPercentage This property contains the details of the minimum storage bytes percentage threshold that S3 Storage Lens will collect metrics up to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minStorageBytesPercentage(java.lang.Number minStorageBytesPercentage) {
                this.minStorageBytesPercentage = minStorageBytesPercentage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SelectionCriteriaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SelectionCriteriaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SelectionCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SelectionCriteriaProperty {
            private final java.lang.String delimiter;
            private final java.lang.Number maxDepth;
            private final java.lang.Number minStorageBytesPercentage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.delimiter = software.amazon.jsii.Kernel.get(this, "delimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maxDepth = software.amazon.jsii.Kernel.get(this, "maxDepth", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minStorageBytesPercentage = software.amazon.jsii.Kernel.get(this, "minStorageBytesPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.delimiter = builder.delimiter;
                this.maxDepth = builder.maxDepth;
                this.minStorageBytesPercentage = builder.minStorageBytesPercentage;
            }

            @Override
            public final java.lang.String getDelimiter() {
                return this.delimiter;
            }

            @Override
            public final java.lang.Number getMaxDepth() {
                return this.maxDepth;
            }

            @Override
            public final java.lang.Number getMinStorageBytesPercentage() {
                return this.minStorageBytesPercentage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDelimiter() != null) {
                    data.set("delimiter", om.valueToTree(this.getDelimiter()));
                }
                if (this.getMaxDepth() != null) {
                    data.set("maxDepth", om.valueToTree(this.getMaxDepth()));
                }
                if (this.getMinStorageBytesPercentage() != null) {
                    data.set("minStorageBytesPercentage", om.valueToTree(this.getMinStorageBytesPercentage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnStorageLens.SelectionCriteriaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SelectionCriteriaProperty.Jsii$Proxy that = (SelectionCriteriaProperty.Jsii$Proxy) o;

                if (this.delimiter != null ? !this.delimiter.equals(that.delimiter) : that.delimiter != null) return false;
                if (this.maxDepth != null ? !this.maxDepth.equals(that.maxDepth) : that.maxDepth != null) return false;
                return this.minStorageBytesPercentage != null ? this.minStorageBytesPercentage.equals(that.minStorageBytesPercentage) : that.minStorageBytesPercentage == null;
            }

            @Override
            public final int hashCode() {
                int result = this.delimiter != null ? this.delimiter.hashCode() : 0;
                result = 31 * result + (this.maxDepth != null ? this.maxDepth.hashCode() : 0);
                result = 31 * result + (this.minStorageBytesPercentage != null ? this.minStorageBytesPercentage.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This is the property of the Amazon S3 Storage Lens configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * Object sses3;
     * StorageLensConfigurationProperty storageLensConfigurationProperty = StorageLensConfigurationProperty.builder()
     *         .accountLevel(AccountLevelProperty.builder()
     *                 .bucketLevel(BucketLevelProperty.builder()
     *                         .activityMetrics(ActivityMetricsProperty.builder()
     *                                 .isEnabled(false)
     *                                 .build())
     *                         .advancedCostOptimizationMetrics(AdvancedCostOptimizationMetricsProperty.builder()
     *                                 .isEnabled(false)
     *                                 .build())
     *                         .advancedDataProtectionMetrics(AdvancedDataProtectionMetricsProperty.builder()
     *                                 .isEnabled(false)
     *                                 .build())
     *                         .detailedStatusCodesMetrics(DetailedStatusCodesMetricsProperty.builder()
     *                                 .isEnabled(false)
     *                                 .build())
     *                         .prefixLevel(PrefixLevelProperty.builder()
     *                                 .storageMetrics(PrefixLevelStorageMetricsProperty.builder()
     *                                         .isEnabled(false)
     *                                         .selectionCriteria(SelectionCriteriaProperty.builder()
     *                                                 .delimiter("delimiter")
     *                                                 .maxDepth(123)
     *                                                 .minStorageBytesPercentage(123)
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .activityMetrics(ActivityMetricsProperty.builder()
     *                         .isEnabled(false)
     *                         .build())
     *                 .advancedCostOptimizationMetrics(AdvancedCostOptimizationMetricsProperty.builder()
     *                         .isEnabled(false)
     *                         .build())
     *                 .advancedDataProtectionMetrics(AdvancedDataProtectionMetricsProperty.builder()
     *                         .isEnabled(false)
     *                         .build())
     *                 .detailedStatusCodesMetrics(DetailedStatusCodesMetricsProperty.builder()
     *                         .isEnabled(false)
     *                         .build())
     *                 .build())
     *         .id("id")
     *         .isEnabled(false)
     *         // the properties below are optional
     *         .awsOrg(AwsOrgProperty.builder()
     *                 .arn("arn")
     *                 .build())
     *         .dataExport(DataExportProperty.builder()
     *                 .cloudWatchMetrics(CloudWatchMetricsProperty.builder()
     *                         .isEnabled(false)
     *                         .build())
     *                 .s3BucketDestination(S3BucketDestinationProperty.builder()
     *                         .accountId("accountId")
     *                         .arn("arn")
     *                         .format("format")
     *                         .outputSchemaVersion("outputSchemaVersion")
     *                         // the properties below are optional
     *                         .encryption(EncryptionProperty.builder()
     *                                 .ssekms(SSEKMSProperty.builder()
     *                                         .keyId("keyId")
     *                                         .build())
     *                                 .sses3(sses3)
     *                                 .build())
     *                         .prefix("prefix")
     *                         .build())
     *                 .build())
     *         .exclude(BucketsAndRegionsProperty.builder()
     *                 .buckets(List.of("buckets"))
     *                 .regions(List.of("regions"))
     *                 .build())
     *         .include(BucketsAndRegionsProperty.builder()
     *                 .buckets(List.of("buckets"))
     *                 .regions(List.of("regions"))
     *                 .build())
     *         .storageLensArn("storageLensArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnStorageLens.StorageLensConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(StorageLensConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StorageLensConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This property contains the details of the account-level metrics for Amazon S3 Storage Lens configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAccountLevel();

        /**
         * This property contains the details of the ID of the S3 Storage Lens configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * This property contains the details of whether the Amazon S3 Storage Lens configuration is enabled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getIsEnabled();

        /**
         * This property contains the details of the AWS Organization for the S3 Storage Lens configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAwsOrg() {
            return null;
        }

        /**
         * This property contains the details of this S3 Storage Lens configuration's metrics export.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataExport() {
            return null;
        }

        /**
         * This property contains the details of the bucket and or Regions excluded for Amazon S3 Storage Lens configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExclude() {
            return null;
        }

        /**
         * This property contains the details of the bucket and or Regions included for Amazon S3 Storage Lens configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInclude() {
            return null;
        }

        /**
         * This property contains the details of the ARN of the S3 Storage Lens configuration.
         * <p>
         * This property is read-only.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStorageLensArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StorageLensConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StorageLensConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StorageLensConfigurationProperty> {
            java.lang.Object accountLevel;
            java.lang.String id;
            java.lang.Object isEnabled;
            java.lang.Object awsOrg;
            java.lang.Object dataExport;
            java.lang.Object exclude;
            java.lang.Object include;
            java.lang.String storageLensArn;

            /**
             * Sets the value of {@link StorageLensConfigurationProperty#getAccountLevel}
             * @param accountLevel This property contains the details of the account-level metrics for Amazon S3 Storage Lens configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accountLevel(software.amazon.awscdk.core.IResolvable accountLevel) {
                this.accountLevel = accountLevel;
                return this;
            }

            /**
             * Sets the value of {@link StorageLensConfigurationProperty#getAccountLevel}
             * @param accountLevel This property contains the details of the account-level metrics for Amazon S3 Storage Lens configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accountLevel(software.amazon.awscdk.services.s3.CfnStorageLens.AccountLevelProperty accountLevel) {
                this.accountLevel = accountLevel;
                return this;
            }

            /**
             * Sets the value of {@link StorageLensConfigurationProperty#getId}
             * @param id This property contains the details of the ID of the S3 Storage Lens configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link StorageLensConfigurationProperty#getIsEnabled}
             * @param isEnabled This property contains the details of whether the Amazon S3 Storage Lens configuration is enabled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isEnabled(java.lang.Boolean isEnabled) {
                this.isEnabled = isEnabled;
                return this;
            }

            /**
             * Sets the value of {@link StorageLensConfigurationProperty#getIsEnabled}
             * @param isEnabled This property contains the details of whether the Amazon S3 Storage Lens configuration is enabled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isEnabled(software.amazon.awscdk.core.IResolvable isEnabled) {
                this.isEnabled = isEnabled;
                return this;
            }

            /**
             * Sets the value of {@link StorageLensConfigurationProperty#getAwsOrg}
             * @param awsOrg This property contains the details of the AWS Organization for the S3 Storage Lens configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsOrg(software.amazon.awscdk.core.IResolvable awsOrg) {
                this.awsOrg = awsOrg;
                return this;
            }

            /**
             * Sets the value of {@link StorageLensConfigurationProperty#getAwsOrg}
             * @param awsOrg This property contains the details of the AWS Organization for the S3 Storage Lens configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsOrg(software.amazon.awscdk.services.s3.CfnStorageLens.AwsOrgProperty awsOrg) {
                this.awsOrg = awsOrg;
                return this;
            }

            /**
             * Sets the value of {@link StorageLensConfigurationProperty#getDataExport}
             * @param dataExport This property contains the details of this S3 Storage Lens configuration's metrics export.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataExport(software.amazon.awscdk.core.IResolvable dataExport) {
                this.dataExport = dataExport;
                return this;
            }

            /**
             * Sets the value of {@link StorageLensConfigurationProperty#getDataExport}
             * @param dataExport This property contains the details of this S3 Storage Lens configuration's metrics export.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataExport(software.amazon.awscdk.services.s3.CfnStorageLens.DataExportProperty dataExport) {
                this.dataExport = dataExport;
                return this;
            }

            /**
             * Sets the value of {@link StorageLensConfigurationProperty#getExclude}
             * @param exclude This property contains the details of the bucket and or Regions excluded for Amazon S3 Storage Lens configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exclude(software.amazon.awscdk.core.IResolvable exclude) {
                this.exclude = exclude;
                return this;
            }

            /**
             * Sets the value of {@link StorageLensConfigurationProperty#getExclude}
             * @param exclude This property contains the details of the bucket and or Regions excluded for Amazon S3 Storage Lens configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exclude(software.amazon.awscdk.services.s3.CfnStorageLens.BucketsAndRegionsProperty exclude) {
                this.exclude = exclude;
                return this;
            }

            /**
             * Sets the value of {@link StorageLensConfigurationProperty#getInclude}
             * @param include This property contains the details of the bucket and or Regions included for Amazon S3 Storage Lens configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder include(software.amazon.awscdk.core.IResolvable include) {
                this.include = include;
                return this;
            }

            /**
             * Sets the value of {@link StorageLensConfigurationProperty#getInclude}
             * @param include This property contains the details of the bucket and or Regions included for Amazon S3 Storage Lens configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder include(software.amazon.awscdk.services.s3.CfnStorageLens.BucketsAndRegionsProperty include) {
                this.include = include;
                return this;
            }

            /**
             * Sets the value of {@link StorageLensConfigurationProperty#getStorageLensArn}
             * @param storageLensArn This property contains the details of the ARN of the S3 Storage Lens configuration.
             *                       This property is read-only.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageLensArn(java.lang.String storageLensArn) {
                this.storageLensArn = storageLensArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StorageLensConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StorageLensConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StorageLensConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StorageLensConfigurationProperty {
            private final java.lang.Object accountLevel;
            private final java.lang.String id;
            private final java.lang.Object isEnabled;
            private final java.lang.Object awsOrg;
            private final java.lang.Object dataExport;
            private final java.lang.Object exclude;
            private final java.lang.Object include;
            private final java.lang.String storageLensArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accountLevel = software.amazon.jsii.Kernel.get(this, "accountLevel", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.isEnabled = software.amazon.jsii.Kernel.get(this, "isEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.awsOrg = software.amazon.jsii.Kernel.get(this, "awsOrg", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dataExport = software.amazon.jsii.Kernel.get(this, "dataExport", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.exclude = software.amazon.jsii.Kernel.get(this, "exclude", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.include = software.amazon.jsii.Kernel.get(this, "include", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.storageLensArn = software.amazon.jsii.Kernel.get(this, "storageLensArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accountLevel = java.util.Objects.requireNonNull(builder.accountLevel, "accountLevel is required");
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.isEnabled = java.util.Objects.requireNonNull(builder.isEnabled, "isEnabled is required");
                this.awsOrg = builder.awsOrg;
                this.dataExport = builder.dataExport;
                this.exclude = builder.exclude;
                this.include = builder.include;
                this.storageLensArn = builder.storageLensArn;
            }

            @Override
            public final java.lang.Object getAccountLevel() {
                return this.accountLevel;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.Object getIsEnabled() {
                return this.isEnabled;
            }

            @Override
            public final java.lang.Object getAwsOrg() {
                return this.awsOrg;
            }

            @Override
            public final java.lang.Object getDataExport() {
                return this.dataExport;
            }

            @Override
            public final java.lang.Object getExclude() {
                return this.exclude;
            }

            @Override
            public final java.lang.Object getInclude() {
                return this.include;
            }

            @Override
            public final java.lang.String getStorageLensArn() {
                return this.storageLensArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("accountLevel", om.valueToTree(this.getAccountLevel()));
                data.set("id", om.valueToTree(this.getId()));
                data.set("isEnabled", om.valueToTree(this.getIsEnabled()));
                if (this.getAwsOrg() != null) {
                    data.set("awsOrg", om.valueToTree(this.getAwsOrg()));
                }
                if (this.getDataExport() != null) {
                    data.set("dataExport", om.valueToTree(this.getDataExport()));
                }
                if (this.getExclude() != null) {
                    data.set("exclude", om.valueToTree(this.getExclude()));
                }
                if (this.getInclude() != null) {
                    data.set("include", om.valueToTree(this.getInclude()));
                }
                if (this.getStorageLensArn() != null) {
                    data.set("storageLensArn", om.valueToTree(this.getStorageLensArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnStorageLens.StorageLensConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StorageLensConfigurationProperty.Jsii$Proxy that = (StorageLensConfigurationProperty.Jsii$Proxy) o;

                if (!accountLevel.equals(that.accountLevel)) return false;
                if (!id.equals(that.id)) return false;
                if (!isEnabled.equals(that.isEnabled)) return false;
                if (this.awsOrg != null ? !this.awsOrg.equals(that.awsOrg) : that.awsOrg != null) return false;
                if (this.dataExport != null ? !this.dataExport.equals(that.dataExport) : that.dataExport != null) return false;
                if (this.exclude != null ? !this.exclude.equals(that.exclude) : that.exclude != null) return false;
                if (this.include != null ? !this.include.equals(that.include) : that.include != null) return false;
                return this.storageLensArn != null ? this.storageLensArn.equals(that.storageLensArn) : that.storageLensArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accountLevel.hashCode();
                result = 31 * result + (this.id.hashCode());
                result = 31 * result + (this.isEnabled.hashCode());
                result = 31 * result + (this.awsOrg != null ? this.awsOrg.hashCode() : 0);
                result = 31 * result + (this.dataExport != null ? this.dataExport.hashCode() : 0);
                result = 31 * result + (this.exclude != null ? this.exclude.hashCode() : 0);
                result = 31 * result + (this.include != null ? this.include.hashCode() : 0);
                result = 31 * result + (this.storageLensArn != null ? this.storageLensArn.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.s3.CfnStorageLens}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.s3.CfnStorageLens> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.s3.CfnStorageLensProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.s3.CfnStorageLensProps.Builder();
        }

        /**
         * This resource contains the details Amazon S3 Storage Lens configuration.
         * <p>
         * @return {@code this}
         * @param storageLensConfiguration This resource contains the details Amazon S3 Storage Lens configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageLensConfiguration(final software.amazon.awscdk.core.IResolvable storageLensConfiguration) {
            this.props.storageLensConfiguration(storageLensConfiguration);
            return this;
        }
        /**
         * This resource contains the details Amazon S3 Storage Lens configuration.
         * <p>
         * @return {@code this}
         * @param storageLensConfiguration This resource contains the details Amazon S3 Storage Lens configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageLensConfiguration(final software.amazon.awscdk.services.s3.CfnStorageLens.StorageLensConfigurationProperty storageLensConfiguration) {
            this.props.storageLensConfiguration(storageLensConfiguration);
            return this;
        }

        /**
         * A set of tags (key–value pairs) to associate with the Storage Lens configuration.
         * <p>
         * @return {@code this}
         * @param tags A set of tags (key–value pairs) to associate with the Storage Lens configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.s3.CfnStorageLens}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.s3.CfnStorageLens build() {
            return new software.amazon.awscdk.services.s3.CfnStorageLens(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
