package software.amazon.awscdk.services.s3;

/**
 * An S3 bucket with associated policy objects.
 * <p>
 * This bucket does not yet have all features that exposed by the underlying
 * BucketResource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Repository ecrRepository;
 * Project.Builder.create(this, "Project")
 *         .environment(BuildEnvironment.builder()
 *                 .buildImage(WindowsBuildImage.fromEcrRepository(ecrRepository, "v1.0", WindowsImageType.SERVER_2019))
 *                 // optional certificate to include in the build image
 *                 .certificate(BuildEnvironmentCertificate.builder()
 *                         .bucket(Bucket.fromBucketName(this, "Bucket", "my-bucket"))
 *                         .objectKey("path/to/cert.pem")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-08T16:00:25.114Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.Bucket")
public class Bucket extends software.amazon.awscdk.services.s3.BucketBase {

    protected Bucket(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Bucket(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Bucket(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.BucketProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Bucket(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param bucketArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket fromBucketArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String bucketArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.Bucket.class, "fromBucketArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(bucketArn, "bucketArn is required") });
    }

    /**
     * Creates a Bucket construct that represents an external bucket.
     * <p>
     * @param scope The parent creating construct (usually `this`). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param attrs A `BucketAttributes` object. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket fromBucketAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.BucketAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.Bucket.class, "fromBucketAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param bucketName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket fromBucketName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String bucketName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.Bucket.class, "fromBucketName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(bucketName, "bucketName is required") });
    }

    /**
     * Thrown an exception if the given bucket name is not valid.
     * <p>
     * @param physicalName name of the bucket. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static void validateBucketName(final @org.jetbrains.annotations.NotNull java.lang.String physicalName) {
        software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.Bucket.class, "validateBucketName", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(physicalName, "physicalName is required") });
    }

    /**
     * Adds a cross-origin access configuration for objects in an Amazon S3 bucket.
     * <p>
     * @param rule The CORS configuration rule to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addCorsRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.CorsRule rule) {
        software.amazon.jsii.Kernel.call(this, "addCorsRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
    }

    /**
     * Add an inventory configuration.
     * <p>
     * @param inventory configuration to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addInventory(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.Inventory inventory) {
        software.amazon.jsii.Kernel.call(this, "addInventory", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inventory, "inventory is required") });
    }

    /**
     * Add a lifecycle rule to the bucket.
     * <p>
     * @param rule The rule to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addLifecycleRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.LifecycleRule rule) {
        software.amazon.jsii.Kernel.call(this, "addLifecycleRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
    }

    /**
     * Adds a metrics configuration for the CloudWatch request metrics from the bucket.
     * <p>
     * @param metric The metric configuration to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addMetric(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.BucketMetrics metric) {
        software.amazon.jsii.Kernel.call(this, "addMetric", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(metric, "metric is required") });
    }

    /**
     * The ARN of the bucket.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBucketArn() {
        return software.amazon.jsii.Kernel.get(this, "bucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IPv4 DNS name of the specified bucket.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBucketDomainName() {
        return software.amazon.jsii.Kernel.get(this, "bucketDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IPv6 DNS name of the specified bucket.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBucketDualStackDomainName() {
        return software.amazon.jsii.Kernel.get(this, "bucketDualStackDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the bucket.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBucketName() {
        return software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The regional domain name of the specified bucket.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBucketRegionalDomainName() {
        return software.amazon.jsii.Kernel.get(this, "bucketRegionalDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Domain name of the static website.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBucketWebsiteDomainName() {
        return software.amazon.jsii.Kernel.get(this, "bucketWebsiteDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The URL of the static website.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBucketWebsiteUrl() {
        return software.amazon.jsii.Kernel.get(this, "bucketWebsiteUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Optional KMS encryption key associated with this bucket.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
    }

    /**
     * If this bucket has been configured for static website hosting.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getIsWebsite() {
        return software.amazon.jsii.Kernel.get(this, "isWebsite", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Indicates if a bucket resource policy should automatically created upon the first call to `addToResourcePolicy`.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Boolean getAutoCreatePolicy() {
        return software.amazon.jsii.Kernel.get(this, "autoCreatePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Indicates if a bucket resource policy should automatically created upon the first call to `addToResourcePolicy`.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setAutoCreatePolicy(final @org.jetbrains.annotations.NotNull java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "autoCreatePolicy", java.util.Objects.requireNonNull(value, "autoCreatePolicy is required"));
    }

    /**
     * Whether to disallow public access.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.lang.Boolean getDisallowPublicAccess() {
        return software.amazon.jsii.Kernel.get(this, "disallowPublicAccess", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Whether to disallow public access.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setDisallowPublicAccess(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "disallowPublicAccess", value);
    }

    /**
     * The resource policy associated with this bucket.
     * <p>
     * If <code>autoCreatePolicy</code> is true, a <code>BucketPolicy</code> will be created upon the
     * first call to addToResourcePolicy(s).
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.BucketPolicy getPolicy() {
        return software.amazon.jsii.Kernel.get(this, "policy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.BucketPolicy.class));
    }

    /**
     * The resource policy associated with this bucket.
     * <p>
     * If <code>autoCreatePolicy</code> is true, a <code>BucketPolicy</code> will be created upon the
     * first call to addToResourcePolicy(s).
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.BucketPolicy value) {
        software.amazon.jsii.Kernel.set(this, "policy", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.s3.Bucket}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.s3.Bucket> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.s3.BucketProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Specifies a canned ACL that grants predefined permissions to the bucket.
         * <p>
         * Default: BucketAccessControl.PRIVATE
         * <p>
         * @return {@code this}
         * @param accessControl Specifies a canned ACL that grants predefined permissions to the bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessControl(final software.amazon.awscdk.services.s3.BucketAccessControl accessControl) {
            this.props().accessControl(accessControl);
            return this;
        }

        /**
         * Whether all objects should be automatically deleted when the bucket is removed from the stack or when the stack is deleted.
         * <p>
         * Requires the <code>removalPolicy</code> to be set to <code>RemovalPolicy.DESTROY</code>.
         * <p>
         * <strong>Warning</strong> if you have deployed a bucket with <code>autoDeleteObjects: true</code>,
         * switching this to <code>false</code> in a CDK version <em>before</em> <code>1.126.0</code> will lead to
         * all objects in the bucket being deleted. Be sure to update your bucket resources
         * by deploying with CDK version <code>1.126.0</code> or later <strong>before</strong> switching this value to <code>false</code>.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param autoDeleteObjects Whether all objects should be automatically deleted when the bucket is removed from the stack or when the stack is deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoDeleteObjects(final java.lang.Boolean autoDeleteObjects) {
            this.props().autoDeleteObjects(autoDeleteObjects);
            return this;
        }

        /**
         * The block public access configuration of this bucket.
         * <p>
         * Default: - CloudFormation defaults will apply. New buckets and objects don't allow public access, but users can modify bucket policies or object permissions to allow public access
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html">https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html</a>
         * @param blockPublicAccess The block public access configuration of this bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockPublicAccess(final software.amazon.awscdk.services.s3.BlockPublicAccess blockPublicAccess) {
            this.props().blockPublicAccess(blockPublicAccess);
            return this;
        }

        /**
         * Specifies whether Amazon S3 should use an S3 Bucket Key with server-side encryption using KMS (SSE-KMS) for new objects in the bucket.
         * <p>
         * Only relevant, when Encryption is set to {&#64;link BucketEncryption.KMS}
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param bucketKeyEnabled Specifies whether Amazon S3 should use an S3 Bucket Key with server-side encryption using KMS (SSE-KMS) for new objects in the bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketKeyEnabled(final java.lang.Boolean bucketKeyEnabled) {
            this.props().bucketKeyEnabled(bucketKeyEnabled);
            return this;
        }

        /**
         * Physical name of this bucket.
         * <p>
         * Default: - Assigned by CloudFormation (recommended).
         * <p>
         * @return {@code this}
         * @param bucketName Physical name of this bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketName(final java.lang.String bucketName) {
            this.props().bucketName(bucketName);
            return this;
        }

        /**
         * The CORS configuration of this bucket.
         * <p>
         * Default: - No CORS configuration.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html</a>
         * @param cors The CORS configuration of this bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cors(final java.util.List<? extends software.amazon.awscdk.services.s3.CorsRule> cors) {
            this.props().cors(cors);
            return this;
        }

        /**
         * The kind of server-side encryption to apply to this bucket.
         * <p>
         * If you choose KMS, you can specify a KMS key via <code>encryptionKey</code>. If
         * encryption key is not specified, a key will automatically be created.
         * <p>
         * Default: - `Kms` if `encryptionKey` is specified, or `Unencrypted` otherwise.
         * <p>
         * @return {@code this}
         * @param encryption The kind of server-side encryption to apply to this bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(final software.amazon.awscdk.services.s3.BucketEncryption encryption) {
            this.props().encryption(encryption);
            return this;
        }

        /**
         * External KMS key to use for bucket encryption.
         * <p>
         * The 'encryption' property must be either not specified or set to "Kms".
         * An error will be emitted if encryption is set to "Unencrypted" or
         * "Managed".
         * <p>
         * Default: - If encryption is set to "Kms" and this property is undefined,
         * a new KMS key will be created and associated with this bucket.
         * <p>
         * @return {@code this}
         * @param encryptionKey External KMS key to use for bucket encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(final software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.props().encryptionKey(encryptionKey);
            return this;
        }

        /**
         * Enforces SSL for requests.
         * <p>
         * S3.5 of the AWS Foundational Security Best Practices Regarding S3.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-ssl-requests-only.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-ssl-requests-only.html</a>
         * @param enforceSsl Enforces SSL for requests. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enforceSsl(final java.lang.Boolean enforceSsl) {
            this.props().enforceSsl(enforceSsl);
            return this;
        }

        /**
         * Whether this bucket should send notifications to Amazon EventBridge or not.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param eventBridgeEnabled Whether this bucket should send notifications to Amazon EventBridge or not. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBridgeEnabled(final java.lang.Boolean eventBridgeEnabled) {
            this.props().eventBridgeEnabled(eventBridgeEnabled);
            return this;
        }

        /**
         * Inteligent Tiering Configurations.
         * <p>
         * Default: No Intelligent Tiiering Configurations.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/intelligent-tiering.html">https://docs.aws.amazon.com/AmazonS3/latest/userguide/intelligent-tiering.html</a>
         * @param intelligentTieringConfigurations Inteligent Tiering Configurations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder intelligentTieringConfigurations(final java.util.List<? extends software.amazon.awscdk.services.s3.IntelligentTieringConfiguration> intelligentTieringConfigurations) {
            this.props().intelligentTieringConfigurations(intelligentTieringConfigurations);
            return this;
        }

        /**
         * The inventory configuration of the bucket.
         * <p>
         * Default: - No inventory configuration
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html">https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html</a>
         * @param inventories The inventory configuration of the bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inventories(final java.util.List<? extends software.amazon.awscdk.services.s3.Inventory> inventories) {
            this.props().inventories(inventories);
            return this;
        }

        /**
         * Rules that define how Amazon S3 manages objects during their lifetime.
         * <p>
         * Default: - No lifecycle rules.
         * <p>
         * @return {@code this}
         * @param lifecycleRules Rules that define how Amazon S3 manages objects during their lifetime. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleRules(final java.util.List<? extends software.amazon.awscdk.services.s3.LifecycleRule> lifecycleRules) {
            this.props().lifecycleRules(lifecycleRules);
            return this;
        }

        /**
         * The metrics configuration of this bucket.
         * <p>
         * Default: - No metrics configuration.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html</a>
         * @param metrics The metrics configuration of this bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metrics(final java.util.List<? extends software.amazon.awscdk.services.s3.BucketMetrics> metrics) {
            this.props().metrics(metrics);
            return this;
        }

        /**
         * The role to be used by the notifications handler.
         * <p>
         * Default: - a new role will be created.
         * <p>
         * @return {@code this}
         * @param notificationsHandlerRole The role to be used by the notifications handler. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationsHandlerRole(final software.amazon.awscdk.services.iam.IRole notificationsHandlerRole) {
            this.props().notificationsHandlerRole(notificationsHandlerRole);
            return this;
        }

        /**
         * The objectOwnership of the bucket.
         * <p>
         * Default: - No ObjectOwnership configuration, uploading account will own the object.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/about-object-ownership.html">https://docs.aws.amazon.com/AmazonS3/latest/dev/about-object-ownership.html</a>
         * @param objectOwnership The objectOwnership of the bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectOwnership(final software.amazon.awscdk.services.s3.ObjectOwnership objectOwnership) {
            this.props().objectOwnership(objectOwnership);
            return this;
        }

        /**
         * Grants public read access to all objects in the bucket.
         * <p>
         * Similar to calling <code>bucket.grantPublicAccess()</code>
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param publicReadAccess Grants public read access to all objects in the bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicReadAccess(final java.lang.Boolean publicReadAccess) {
            this.props().publicReadAccess(publicReadAccess);
            return this;
        }

        /**
         * Policy to apply when the bucket is removed from this stack.
         * <p>
         * Default: - The bucket will be orphaned.
         * <p>
         * @return {@code this}
         * @param removalPolicy Policy to apply when the bucket is removed from this stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.props().removalPolicy(removalPolicy);
            return this;
        }

        /**
         * Destination bucket for the server access logs.
         * <p>
         * Default: - If "serverAccessLogsPrefix" undefined - access logs disabled, otherwise - log to current bucket.
         * <p>
         * @return {@code this}
         * @param serverAccessLogsBucket Destination bucket for the server access logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverAccessLogsBucket(final software.amazon.awscdk.services.s3.IBucket serverAccessLogsBucket) {
            this.props().serverAccessLogsBucket(serverAccessLogsBucket);
            return this;
        }

        /**
         * Optional log file prefix to use for the bucket's access logs.
         * <p>
         * If defined without "serverAccessLogsBucket", enables access logs to current bucket with this prefix.
         * <p>
         * Default: - No log file prefix
         * <p>
         * @return {@code this}
         * @param serverAccessLogsPrefix Optional log file prefix to use for the bucket's access logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverAccessLogsPrefix(final java.lang.String serverAccessLogsPrefix) {
            this.props().serverAccessLogsPrefix(serverAccessLogsPrefix);
            return this;
        }

        /**
         * Whether this bucket should have transfer acceleration turned on or not.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param transferAcceleration Whether this bucket should have transfer acceleration turned on or not. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transferAcceleration(final java.lang.Boolean transferAcceleration) {
            this.props().transferAcceleration(transferAcceleration);
            return this;
        }

        /**
         * Whether this bucket should have versioning turned on or not.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param versioned Whether this bucket should have versioning turned on or not. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versioned(final java.lang.Boolean versioned) {
            this.props().versioned(versioned);
            return this;
        }

        /**
         * The name of the error document (e.g. "404.html") for the website. `websiteIndexDocument` must also be set if this is set.
         * <p>
         * Default: - No error document.
         * <p>
         * @return {@code this}
         * @param websiteErrorDocument The name of the error document (e.g. "404.html") for the website. `websiteIndexDocument` must also be set if this is set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder websiteErrorDocument(final java.lang.String websiteErrorDocument) {
            this.props().websiteErrorDocument(websiteErrorDocument);
            return this;
        }

        /**
         * The name of the index document (e.g. "index.html") for the website. Enables static website hosting for this bucket.
         * <p>
         * Default: - No index document.
         * <p>
         * @return {@code this}
         * @param websiteIndexDocument The name of the index document (e.g. "index.html") for the website. Enables static website hosting for this bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder websiteIndexDocument(final java.lang.String websiteIndexDocument) {
            this.props().websiteIndexDocument(websiteIndexDocument);
            return this;
        }

        /**
         * Specifies the redirect behavior of all requests to a website endpoint of a bucket.
         * <p>
         * If you specify this property, you can't specify "websiteIndexDocument", "websiteErrorDocument" nor , "websiteRoutingRules".
         * <p>
         * Default: - No redirection.
         * <p>
         * @return {@code this}
         * @param websiteRedirect Specifies the redirect behavior of all requests to a website endpoint of a bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder websiteRedirect(final software.amazon.awscdk.services.s3.RedirectTarget websiteRedirect) {
            this.props().websiteRedirect(websiteRedirect);
            return this;
        }

        /**
         * Rules that define when a redirect is applied and the redirect behavior.
         * <p>
         * Default: - No redirection rules.
         * <p>
         * @return {@code this}
         * @param websiteRoutingRules Rules that define when a redirect is applied and the redirect behavior. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder websiteRoutingRules(final java.util.List<? extends software.amazon.awscdk.services.s3.RoutingRule> websiteRoutingRules) {
            this.props().websiteRoutingRules(websiteRoutingRules);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.s3.Bucket}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.s3.Bucket build() {
            return new software.amazon.awscdk.services.s3.Bucket(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.s3.BucketProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.s3.BucketProps.Builder();
            }
            return this.props;
        }
    }
}
