package software.amazon.awscdk.services.s3;

/**
 * Default bucket access control types.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket = new Bucket(this, "MyBucket");
 * TopicRule.Builder.create(this, "TopicRule")
 *         .sql(IotSql.fromStringAsVer20160323("SELECT * FROM 'device/+/data'"))
 *         .actions(List.of(
 *             S3PutObjectAction.Builder.create(bucket)
 *                     .accessControl(BucketAccessControl.PUBLIC_READ)
 *                     .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-14T16:25:27.101Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.BucketAccessControl")
public enum BucketAccessControl {
    /**
     * Owner gets FULL_CONTROL.
     * <p>
     * No one else has access rights.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PRIVATE,
    /**
     * Owner gets FULL_CONTROL.
     * <p>
     * The AllUsers group gets READ access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PUBLIC_READ,
    /**
     * Owner gets FULL_CONTROL.
     * <p>
     * The AllUsers group gets READ and WRITE access.
     * Granting this on a bucket is generally not recommended.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PUBLIC_READ_WRITE,
    /**
     * Owner gets FULL_CONTROL.
     * <p>
     * The AuthenticatedUsers group gets READ access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AUTHENTICATED_READ,
    /**
     * The LogDelivery group gets WRITE and READ_ACP permissions on the bucket.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerLogs.html">https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerLogs.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LOG_DELIVERY_WRITE,
    /**
     * Object owner gets FULL_CONTROL.
     * <p>
     * Bucket owner gets READ access.
     * If you specify this canned ACL when creating a bucket, Amazon S3 ignores it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BUCKET_OWNER_READ,
    /**
     * Both the object owner and the bucket owner get FULL_CONTROL over the object.
     * <p>
     * If you specify this canned ACL when creating a bucket, Amazon S3 ignores it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BUCKET_OWNER_FULL_CONTROL,
    /**
     * Owner gets FULL_CONTROL.
     * <p>
     * Amazon EC2 gets READ access to GET an Amazon Machine Image (AMI) bundle from Amazon S3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AWS_EXEC_READ,
}
