package software.amazon.awscdk.services.s3;

/**
 * The ObjectOwnership of the bucket.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket.Builder.create(this, "MyBucket")
 *         .objectOwnership(ObjectOwnership.OBJECT_WRITER)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/about-object-ownership.html">https://docs.aws.amazon.com/AmazonS3/latest/dev/about-object-ownership.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-04-20T17:18:05.058Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.ObjectOwnership")
public enum ObjectOwnership {
    /**
     * ACLs are disabled, and the bucket owner automatically owns and has full control over every object in the bucket.
     * <p>
     * ACLs no longer affect permissions to data in the S3 bucket.
     * The bucket uses policies to define access control.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BUCKET_OWNER_ENFORCED,
    /**
     * Objects uploaded to the bucket change ownership to the bucket owner .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BUCKET_OWNER_PREFERRED,
    /**
     * The uploading account will own the object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OBJECT_WRITER,
}
